(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   8749088,     151629]
NotebookOptionsPosition[   8746844,     151557]
NotebookOutlinePosition[   8747187,     151572]
CellTagsIndexPosition[   8747144,     151569]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myDir", "=", 
  "\"\<E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\\2019\\\\\
Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\beta_90\>\"\
"}]], "Input",
 CellChangeTimes->{{3.6935999549200926`*^9, 3.693599957482935*^9}, {
   3.6935999996269164`*^9, 3.693600003029935*^9}, {3.693600057254778*^9, 
   3.6936000774003253`*^9}, 3.693601743489667*^9, {3.693602955722703*^9, 
   3.6936029563293314`*^9}, 3.69730959969602*^9, {3.759169295283514*^9, 
   3.759169310024805*^9}, {3.759169343271761*^9, 3.7591693503780036`*^9}, 
   3.7593481112896323`*^9, 3.7594115868556557`*^9}],

Cell[BoxData["\<\"E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\
\\2019\\\\Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\\
beta_90\"\>"], "Output",
 CellChangeTimes->{{3.759427355390133*^9, 3.7594273693496532`*^9}, 
   3.7594274078808208`*^9, 3.759427629968568*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "myDir", "]"}]], "Input",
 CellChangeTimes->{{3.6936002658317504`*^9, 3.693600275030756*^9}}],

Cell[BoxData["\<\"E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\
\\2019\\\\Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\\
beta_90\"\>"], "Output",
 CellChangeTimes->{{3.759427357281741*^9, 3.759427369361595*^9}, 
   3.7594274078917904`*^9, 3.7594276299835014`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"ni", "=", " ", 
     RowBox[{"number", " ", "of", " ", "intensities"}]}], "*)"}],
   FontFamily->"DejaVu Serif"], 
  StyleBox["\[IndentingNewLine]",
   FontFamily->"DejaVu Serif"], 
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"nl", "=", " ", 
     RowBox[{"number", " ", "of", " ", "lines"}]}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ni", "=", "221"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nl", "=", "96"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.689694059269452*^9, 3.689694064002336*^9}, {
   3.6896941238238187`*^9, 3.689694125569996*^9}, {3.689752559259322*^9, 
   3.689752565733532*^9}, {3.68975264856147*^9, 3.689752649082982*^9}, 
   3.689753162091238*^9, {3.689754062853174*^9, 3.6897541087276444`*^9}, {
   3.6900157454041543`*^9, 3.6900157487158165`*^9}, {3.7591695496920786`*^9, 
   3.759169550010056*^9}, 3.759427404669979*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "Reading", " ", "the", " ", "field", " ", "intensities", " ", "and", " ", 
     RowBox[{"lines", ".", " ", "The"}], " ", "resulting", " ", "matrix", 
     " ", "\"\<Linesm\>\"", " ", "has", " ", "dimensions", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ni", ",", 
        RowBox[{"nl", "+", "1"}]}], ")"}], "."}]}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Linesm", "=", 
    RowBox[{"Import", "[", "\"\<lines.dat\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.689693361098621*^9, 3.689693381860359*^9}, {
   3.6896936472062635`*^9, 3.6896937150432987`*^9}, {3.6896937962108545`*^9, 
   3.6896938259203672`*^9}, {3.6896939388836155`*^9, 3.689693952499734*^9}, {
   3.6896940790268393`*^9, 3.6896940896641397`*^9}, {3.689754112229719*^9, 
   3.689754218949134*^9}, {3.6897542998015575`*^9, 3.6897543291615667`*^9}, {
   3.6900224364760056`*^9, 3.6900224367971888`*^9}, {3.690745409621585*^9, 
   3.690745422078593*^9}, 3.690747672621636*^9, 3.6907477236792145`*^9, 
   3.6908273009902678`*^9, 3.6908304203268743`*^9, 3.6936002901183963`*^9, {
   3.6973096109741945`*^9, 3.697309611276761*^9}, {3.6973107957270465`*^9, 
   3.6973107965580835`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"Defining", " ", "the", " ", "transpose", " ", "of", " ", 
     RowBox[{"Linesm", "."}]}], "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Linesmt", "=", 
    RowBox[{"Transpose", "[", "Linesm", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.689752571956673*^9, 3.68975257981761*^9}, {
  3.689754164008151*^9, 3.689754165975405*^9}, {3.6897542271091337`*^9, 
  3.689754253656289*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "vector", " ", "Int", " ", "contains", " ", "the", " ", "ni", 
     " ", "intensities"}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"Linesmt", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.68969396008617*^9, 3.6896939815417056`*^9}, {
   3.6896940285650873`*^9, 3.6896940525016747`*^9}, {3.68969413469508*^9, 
   3.6896941418746924`*^9}, {3.6897524716670623`*^9, 3.6897524720207*^9}, {
   3.689754260684599*^9, 3.6897542860233145`*^9}, 3.68975433731924*^9, {
   3.689754375737059*^9, 3.6897543867579*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{"Plotting", " ", "the", " ", "theoretical", " ", "results"}], " ", 
   "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.689756737827545*^9, 3.6897567492844706`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"Linesmt", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.689754999811388*^9, 3.689755087250305*^9}, {
   3.689755163473254*^9, 3.6897552662597337`*^9}, {3.6897554609536524`*^9, 
   3.6897554837610016`*^9}, {3.6897558075794306`*^9, 3.6897558268551846`*^9}, 
   3.689756171350011*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmC1uEOuwqNAUMUiQxfMeMejKnaTaRNbQiN0kZlhukIw0Z
CZOFZoJKGKAEHMqLcB7cCcfdAXf/O8i2s2Y6TKOUnBcqNTM0Mifd88XvE5uy
z/78n+f39jx305LTEjaP8vPz+9n3T/7mT1zAxfDxN6NfHdFKUVpSUjJB+W1R
nR4XEEQ7koVhRV/mRPV8i0hJSfE+QYs0EZp3a+2T6u+3CR8tT9FXM8TAWktI
sHr/E+H7b/ckOixLuO5G9k5W630q34+dQsfkiHuRSQVT1fq5QucLKISO3yPm
+X7C1H55iHcanf6ZmJlUoD2r9t8rEiwhYyPown1il2/B51Q8+xHfdNr4hVzf
NEPFV4D8I+nUQhnfhCgV70HE8zw9dBD1maXiPyQsIXkfRtP5hxHvbJVPkaz/
vhfo4C/hGJXfiOfQtcWId67K9wjWn0fHfoX956v8S0Rfpm72AvpMiXzfb6Gq
R6msxzfK68tkvfIWqfocRX9i6f6j6J+y8RjyWUzvLMc8vajq9zXiVx5Tgf2X
qHpWyP5uVM89FZgntX9MJdZT8RdVIj+V/1Al5kXVL6kK/f+//lUi4KL+9kw6
Qi/nf5Lqb74e+an5GNBjfTVP8dWy/ylq/szVcr30Z1S/jiN/Ne9ZI1bn4+px
4QsnQ52nZSfQL3X+ak8g/0A6sEac9XhWP6b6W4P58qcv1CD+0arftXK/+8M3
HvlorfjId+Af0H51sv+Gf+hNdejvPfpMnfz7dX/Rs+qFvC9u04X1qN8APViP
/tyg159Evl7aflL4yhN3jQ5rQHxX6D0NeL+X7m9APS/RqxtFgXY3soc2NmLe
fqB1BvT7e3qnQfZ7qYfuNSDeM7Q4hfuui64+hb/X6DFG2Y9bHfRCo3i9L7PI
RqcaMR8WutSI+pppjxH5N9EPjeiPgY5pwn1STyc3Yb5q6KIm7K+nu5vQnwp6
qAnrHaOjmtHPEjqpGfkU0weaEd8h2tGM+S2g7zSjH5/TESacz3w60STz1+XR
+SY5D/oc2mrCfZJND5jQz0w6xIx4dtDxZtwv2+lcM/JPp81mxLuV9pplv5O2
0MGncf9vpledRj7JdBbs3UAbRp6/S18deb6OntiC52/Ry2BvPP3xyPM36doW
7L+SvgxvXE4HtmI+l9Ivt+I8vUKnt8p8zy2hq1pxvmPpC624r+bT/hacnzl0
rAXzE01/YMH5iFLn3SI/b8un099Z0L9wdf7b0N9Qem6bkL+mqPugDfdTMF3c
hnro1P3Qhn4E0ffbZPyeceq+sCLeAHqDFfPpr+4PK74PjKY1K87vcD/vEyvi
eUBPt+E+GKLX21DfQXqfDfX7k7bbMH+/03/YcH/dpMPsOM9eOsGO/a7Re+y4
j6/QLXbM4090vx3z/CM9uV3Wv/YCvbod9T5HZ7fL9XefpY3tqOe39K/tmP9u
WteB+DV6eQfi76R3dqB/Nrq+A/dbK93bgXkz0+M7ZT/ajbToxHqN9LZOrFdH
V3diveN0TyfWq6LHOLBeOT3VgX6W0QsduK+O0GscuM8O06kO9KuQznFgnvfT
pQ7Uby9tcmAe82iPA/3Poa8jnrhs+iHiKc+kn3aivzvoGCfO63Z6pRPnLY1O
dqI+W+ldTuSTShc50b9NdKMT3x830t14X/8efQXvj32HHsL7KYl0kIb9E+go
DfuvoV/TMD9v0Eka7p8VdIaG/JfRBzTkL+gaDff7S7RDQz8X05c0zNsC+o6G
+s+lH3fh/M2mI1w471F0nAv3zww60YV6hdNpLsQbSue7EO8UutKFz+Ng2uqS
/b6ro8+7cD6C6AEX7pNx9Fg3vg8G0CFu9NefXuTGvI6i4934/Bz+7ZG3uJHf
v3SuG/n9TZe5kd8gbXajH7fps27M4wDtdeP72Q162I377Tod3IX56aPndKEe
v9CrulCPy/T7XTiPPXRWF+btvM//Aes3XeI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1g9M1GUYB3BsWk1dTncztElazJF/kqAQs7M3YhJqdjIzrJsWKCpmootG
yhJJJjITVNBANJBTEOE8uAPuDg5+9wdjE22VWZkWNDNSKua/kSvt936v7+uM
zXOf3e/3/nme533em5SyPmnlAyEhIRf1f/J//g3/tmpg7ZXpLwWVKHRnvKu8
VKSlpV1W1lLEU+bCuHXq+zXild5NxcpivTjd3d2trG0U5kLfTeWeTGHJMA5/
T73/4f2emC3nH7g33hY5n085cqvQP3PujZ8r+hc5w5RN20TvJoNVrbcnD98r
Z2yX68m8t98dIu/qImc6XVQg/DcjLqxR69kpnGF5V1fTtk+EwZrQu0qtr1Do
4fKk0auLRJL+wkq13t0iWv9bQQ/uFpsN1s9T1Pr3SCe8Q+fvlc/bl6v9FMvx
hi2jQ0vwvFntrwT5epOu2SfjWZCs9rsf+VlCx36K7xer/Zfi/SS6qxT5Nal4
lCE/C+nkA8jHfBWfchmftYl0XznWm6DidRDzx9NZh0RZaem4OBW/z8StCHPh
i/TQCpnfEKOKZ4Wsv7TZdHcF4q0cWYnnX6CLK2U+Y5UHK2U+zcrmw9ivsvY/
h1fd/3x+FfKn3F+FelbzmyzCqA+g7LDI9RmVQ49gvc/T2UeE/nqEcs8RoZfT
pll0/FHUY6zK51HU40x6ZDXOY4zKb7XYoC/gOfpsNernWZXvGtR7NF1eg/MQ
pfJ/DM9H0ivg6BmqHo4hf9PpabWYf6qqj1qMN4W+UYv6jFD1clyu743JdFvQ
4ap+6lBvT9Db6jDeRFVPdZhvAr2gXn5/6DFVX/WYbxxtsOL5sarerMivgb4A
D4xW9XcC9TWKtpxA/xqp6tGGfA2nY2yI50OqPm3I71C6zCbzeXuIqleb7EdP
3/3tP9+xob7+piMbhP6Z8xed0iDPR+kturgB/ew6fbIB9TFADzZg/t/pKY3w
FdrciOd/pXc1YrxLtNaI+Xrpa43oXz/S4XbE5wd6iR3x/o7Ot8v6f/Ib2m3H
/r+k++2I5xk6zIH5TtEmB8bvonMdiFcn7XAgX176sgP12k6HNiG/rfS8JuTL
SWc3oV87aGsT6rmB7mnCfqz0mGac71o6vhnnu5r+oFk8rgfUQtcEn6+gzzej
Pg/SI1tQ32X0nBbU5z46owXx3ksfbkE8i+izLcjnTvpBJ+pnBx3rRHzy6HQn
+nsuXe7EedpCn3EifpvpEBf2n0VHudBP3qdXuJCfDfQ+V/A+p7tcWH86fdsl
+/moVfQ0N/KdSi9zY39v00Vuma8aM+1zo/8spW+4Ub+v05Nb0V+T6ORW3EcL
6QI4bj7dFvw+gf6jFfuNpye24T4WdFIb3jfS22DfLLq5DfPH0H2wJ4oe78H9
M4Ne4EG8p9IfeVDfEbTNg/oKp3/2IF+TaEM76nUCPbcd9/F4Oqtd6J85Y+na
duRnDH2hHffzKPqRDpyHEbToQD9+mN7YgXgMpS0d2M8Q+lwH+sc/feyPGtZ7
m56g4T6/Rcdocn0h1+nXNKznT3q1hvvtKr1Vk/1iQR9dpiH/l2i7hvrppbs1
xOci/UtwvvP0neB85+hHvajvr+hIL/L9BZ3oxf5O0SleOb6hi97sRbwDdLEX
vw81ut6L/uChT3pRHy76Jy/W30wPenFeG+nRPpxnKz3Fh/wcp1/2Ybxq2uzD
eBY604fxKuhdwfHK6ergeKW0FhyvhP7eh3zuoa/5cL530SP86F8FdLgf+dpO
G/2I38f0Ej/6QQ693o/7M5vO9yMfWXSlH/WWSbv96B8b6K/9uF/W0f1+9MN0
elgg+HucDgtgP6n0zADyt5w2BVB/b9Fr8L4xmc7F+4cW0wcCmN9EO/C++VX6
dAD1mkhfDuD37lz6bgD7j6NDO7H/OfQzneh/s+l5nThPM+nUTuQzms7uRPwj
df8LYsBreQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmpE2zsrrlSxO1nKmp016MzZFPWpKMprJput1yoZJaC3XD
iTJfEFNJERTUQzQQlBflPLgX7vAO/ve/P+oKbfZi5XBCTUZKzUzT2Ubd8z2/
P9ic+3j3/z/P8/t9fw+OTc9MWzkgLi7uevSP/ps/9v3mfePWlHdimqe6Ntmm
hsVLlc2Z/LHYSFdVa5Py+z9frb/vFKtMdam9vb3/++tVRkZGt7gzSzmTux71
P5+t3zfYpMfkqFKHY4RYbVXR7U0QT9uudt5emCg2ctVE+/7Z4gV5anT0C+LO
nXr9DPHaXSp63ixx3B71z4Tov9CF+Xq9mv797FWbbc4LYtc+5U/Yebt/f/vV
+9ECROhVhdiPeFqRGvxT5VrxwyK8X2wc0PXtEu8+qHoX+hMsOU8x6i8eXqKS
oi8Ud5ZgP+KaQ+r16E+bnPewrvcmceIRvT9THOdA/c/TFx2on7iwVPfDIV5y
VK2LbkA8pgz9ukD3lKEe8rnrmN7vy7K/jcexv/76faWi5UmS/A0s1/VObpF6
luv1PgzS7eXoZ7PUtwL99NPFFeinT+pdgXp7aPsJ9LNR6n8C9XPR4ypxnrPS
j0qd59R6urdSpUUfOC39qULea2lPFZ6vkX6dRP9P0TkndX2vVEn/TiIvlfS7
p3S+/RXSTzixnB5Sjf0fl/5Wq8j9CfZj9A/VSv9VJv2uwXyW0mU1yJND+l+L
vB2hV9RiXg9JHmqxnxJ6ch3mv1jyUYd+HKTv1aF/ByQvpzG/RXTwtO7PM4WS
nzO4DwrovDOYh32SpzOo7146tV7nx/2l5Kse+cynbU7kfY/kzYn87KY7nLjf
dkn+zqJeX9BVZ7FenuTRhTztoGe4kIdcyacLz2+nS13I21bJqwv12EL3uXS/
OnIkvw2o32Y6vQHnz5Y8N2D/G+nzDXpeQhsk3w2Ytyx6UiPma73kvRHzl0kX
NKL+n0n+G/X83F9F323EfK+UeXCj3un0Yjf6v0zmw4382elmN/q9VObFjfcv
ohM82H+azI9H12/bfDrXg3lIlXnC53Hz6G4P8viezJcX8zWbTvHivLNk3ryY
t5m004v1EmX+vMjDm/RzPpx/usyjD9+fSm/w4f2vynz6MI+v0Nd86Oc4mdcm
fV/Ej6XfbsL9PUrmtwn330j6RBPWf0HmuUnfT58+Tz/hRz2Gynz7df+Lh9Br
/Kj/IJl3P+oVT1/2I48DZP4DWK/v98d+LYD74V96RQD34wP6UAD37T36YgD7
+Yt+FMD9+Ac9uRl5u0V/1Iz9dtOFsO032mzGPN+g78EjOujx5/D5z/QSeMSP
dH7s8yt0MPb5ZfrPc1j/a3pMEPu7QKcFke8InRdE/wzaF0QegnRPEPeXnx4Z
Qh69dGoI92kDvSWEeXHSrhDyWUf/GkJ/qmlbC+alkp7bgvkupze2IE9ldF0L
6umgO1pwnhL66Vbst4hWrchXAb2+FfdTPl3Viv3soq+2Ik876IEG5mEbPcpA
fXPoGQbykU3PN7BeFr3KwHrr6O0G1vucLjVw/6yh3Qb6+QndbiBvy+mbhq7/
nWV0n4H7004PC+P/P0voaWHMyyJ6Xhj7X0inh1GvD+jNYcxHCl0cxvzPpevD
uE/m0Odj75tF34i9byb9MPa+RPpZE+97g55kYn/T6Tkmfh9Noe0mzjuRzjJx
3vF0gYl+vURXm6jfaNowdX+2vUj/YuL3zzD6ron72EY/GUHehtLjIpiPp+ik
CO6/QfTiCM4TT2dGcJ4B9O4I8tnX89gVEdw3j+hmPJ/8gP4ez9f8TffG1r9D
x1tYv5dOsLB+D/2WhbzepBdYOH8XvdrC+a/TuRbu52v0UQv3y1XaY6Gf39GX
LNT/W7rbQn6/of+zcN9cpIe3YR4senob9mvQKW3Yb4he3ob9BuicNsyPN+r/
AWFSdIo=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g1M1GUcB3DGpBVZlrum5SItc+q0yEpcDfdEmeFsAjVfimySMnxZ+DKc
oVkwKCQTX1ADScFDQJTz5I7juDvgf29IE3OmiRamWBIoK+fUyJp2z/f6/pxu
yj7+//c8v+f5vRyj0jJTFkVGREScC/3VP/nHGZO/9Mrlia+FlajyryQ773qe
iu40XxUbaaq0pOTxfnm+WHVnm54Tq0z1YuiP2Fip4qM7nxFfyFKW6d237q7/
iRqXWuQTj1yn91suVp+pyuXx0eLYHHVzbGrRZVk/V+kf4qQ8tSI+ek6f7Jev
+pOdu3vp5V+qYx0dHb/L/htUenp6Tw+9uVCF7uPKJYlnozKFAv6Ntn6tQuE1
/yrxFen4Ci/SGZv1eRK6Jd4tWO88PbBFpYT+4xeJf6s+z5BzdME2rPeznKdY
ha7nxll6+Hac74ycb7sKPa45TdfsQL5OyXl3Ij8n6Snf6POmn5Dzl+A+j9Pt
Jcj/MbmPUr1f51F67i6s/53cT5k+T1Q73VumngotcETu61ucV7xmt64Pm1jt
Uf4bY7vEg8pRH+KMctyPrN9RjvoTx1bc6+KKe98fqMD9yXqpe5F/sbFXvdWd
XSwebb43/gIzPt9G95txX+KkSv15k9heifMGJV/7UD8Bet0+na+x4gv7kE8/
/UaV3i/LJ/ms0veR7aUHV+t6WmpIfqtRb630qWrko0XyXaPzb/HQZTV43y35
3496bqIX7ke/OqUe9iMeBz2hFvmzS33UIn/19PVa1LtV6uUAbKE9B/D+Qamf
g6i3WjrvoAr9+3mN1BOeT6miZ9ahX81SX3V4v4I2WTAv9ki9wYVldJdFvx9R
KvV3CP2wk648hPsolnq0op620pOtqI8iqU88L9pIl1oxzzZIvVpx/i/o21bE
lyf1exj3nUOnHcb8XC/1fFjHE7+Wbgt7jdR32Fn0+HqcZ5XUez3mwwp6Uz3u
P1Pqvx718jF9rR7xLJN+sOH+l9CzbdgvQ/rDhnjTaZcNn18o/WLD+ml0jB37
fyj9Y9fvmz+gc+2I/33pJzv6ex7dY1drTZYjs6W/GvD+u/SMBuQ3RfqtAfmf
RVsakM+3pf/Cz2fQQx2YP9OlHx1Yfxq92oH9E6Q/Hfr7JUbRPznw/RUv/dqI
+n6FntqI9eOkfxtxfy/TexvR35Oknxsxn56n73OiPidIfzsxX8bRS5xYf4z0
uxPnHU1/70S8o6T/mzCPYuhJTfi+GCHzIOzh9I7w+4/JfGjCekPpW02Yh0Nk
XriQj8H0fBf64X6ZHy7dTyeiaJ8L8yVS5okL/XWn73+PceN+/qXnujHP/qYL
3dj/Ju1xY15co/9wY/0/6ZEezNd+OsWD9froPA/qt4d2eJD/i3Qvnuefp59o
xue76JnNyMcZen0z5vGPtLUZ9fUDfbEZ8R+nTS3Y7yj9ZgvmcTu9pgX3H6Rr
w+976a4W1GML/XAr1nfTqhX12UivbNX9mWqnK1sRv5U+3ar7saSOHmSgfmvp
Jw3ks4qebCBfZnqWgXoopzMMrFdG5xiotxK61MA83U7bsH7yVrrDQP1voi8Z
OO9X9O3wfgX0MC/qKY+O9WK+5NCJXsyjT+k0L+LJptd6cV+r6WIv5uEqus6L
eDPpNq/Ox/Rl9Hkvfv/IoAe8OM8i+lEf7m8BPR5Onk+/Hn7+Hp0afj6Hzgo/
f4feFH6eRFf7sP9M2vAhvkT6rA/xT6Ov+XC+BPpBP84/lR7tR/5fpeP9+L6J
o2f7UZ8v0Zl+5DuWLvBjPk2kK/zop3G0y4/fv56lT/pRT0/T/X7kP4aOCuC8
I+iYAM4zjI4L4PvMRCcFEO8j9OIA6uEhOjeAeB6gdwUQTxRtD6B/I+lj2P/E
7V5+X2H/hH/oOwH0/1/08CD2u06/EMT30VV6RhD79dMfBfV5F/TR64LI56WQ
/wNkk4XM
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g9MlGUcB3ByaIu0zK5ETUQlQ1NDM6XZ6eOfVJgudM5oslxozj8r0UUZ
MkOS+ScDVNRANBCQE/Q4ODgOuIP3/qCunS2ni2Vk4pJpMGcOi+lG3fPV78+8
TfCzl3uf37/ned/RyZuWfdwvJCTkt+A//ft/nwzVNWnOw//GKZN1Ycdjf6DG
J+XMFRvJapkzImu2XF+vfPei22fRapPaFryB2Niifc5MX0tVm81h74tDvlT6
pzgyXWV1LXW+I/f7CuuJY3aotcGP2MjE/cQJO3U8SeJrWSqsrSRFnLJLLepI
yxOH7EF84ty9er3+j+PZ92S8tm8Rn1jlKHNY21jJd12uKsjPzxfH7FfdS50R
Uq/e/SrHe88iNg48Wd/dB3V+neKEPPV3dFLOHDr8EP5+ruR3CPWbR1sO6+te
ccoRVZpi3jufjv0O+bwr+efreKIX0OfzVbD998W5BepCIBBYSCce1fkcXyT1
KUQ/4uibhTr/YfFSr2Ooh3jrcRVsh1usvtc2i0OLUC+537oifF/WDxShPhJ/
TDHWk/zyijF/Up/eYhUsR6rUM+mE7lfJ4/k8oevRJv2PKtH1fn6m9KNEjQo2
/G26uwT5z5D+lOr733uLri1FfadJv8owX1Pp9DL0b4r0rwz1fYOefxL1nCz9
PKn7FzaJHliO/r4u/S3H/phAXy7H+uOl3xb1ZvATTRdaMK+vSf9PoX7j6DWn
cP1VmYdT+H4UPbEC9Rgr81Gh5yVtDN1TgfkeLfNSifMkknZV4v7iyNPIdxS9
87Rezx4h83Ra6V/ixWew/kiZrzPo5yu0yYp+jJB5s2IexO1W7P/hMn9ViG8Y
XVqlOtJMk8WhNpwf4fR0m75uHSrzacM8vkwX2PT9TeKADfP9Et1nw/lkkvmt
VsH2bXyRTq7GvA6Rea5GfQbTZ6tR70Ey39Xofxg9oQZ+Wua9RtcvI5TOrkE+
T8n81yCevj8f+W4N5vMBHWVHv3rpFXacDz30bjvm9y+60Y79cZvutiP+Ljqi
FvW9SSfU6nju/EFn4rq1g66txfev0p21OB9+pcPr9DxcbKPj65DvZTq9Dutd
pK112O8X6GsP//4HeogD+Z6j5zuwf3305w7EY9AWB54XbvqKA/k30APr9fMi
1kHPqke9auiUetyvij5Rj/mtpC/X4/y20AOc2K9ldKwT+62Y3uDEfj1OFzpx
XhTQPzr1+ouP0CENqN9BemoD5iGXXtOA/bGPPtyAePfQ5+HOLPp+A+Y5k57Y
qN21nf4Q3riNzn14/Qva24j7f0b3wJ0p9LgmHc9Hn9CJTXj/WE/vbcL5t5Z2
NaHeyfTtJpwHq+hIF55HK+llLtQvkd7pQn2X0w4X5m8pfdOF82QJPdyNeYin
F7uxXxfQ293Idy5tc6Pes+nrbsQ7kzY14/yIpRc0Y39Mo7c2I54pdEUz5mUS
3d6M/Tqefq4F9R1Hqxb0fwy9pQXrjaJLW5D/CPrnFpxv4XSooYI/M0z0SAP5
DaanGzivB9HvGaj3M/Q6A/ttAL3DQPz96AID+6Hv1iPbDdTrAR0wMN//0DcM
vM/00H0G3p/u0EM9uF83HePB/W7RcR7Ed4NO9iC+6/Q2D87Xq3SeB/leoc94
sL/a6LMePM8u0b97UL+f6F7EkxqgX/DifDpPT/Di/Gil53nxPuShk7zor5tO
9SKfRjrbi3wcdLkX82KnDS/6V0X/gu+3V9J38X2zhX7Wh/VL6Sgf1i+izT7s
v2P0Ch/el/PpTT7kf5je7UP+B+hiH+Yxm2704fz+hr7kw3zsort9OB++pvv7
8fzKoCP8OI/T6Rl+xLuVTvAj3lR6vR/92kxn+vE++Cl91I/zawNd68fzYS19
AetFrKY7sV7aKvpfrNe2kg5vRX6J9JRW5Lecjm9Ffgn06lb0Ywmd3op+xAX9
Hy+WYo0=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1n1MlVUcB3ByaoXMl2RJtkgnc0SaKEtxhTu+JEKYwJraYm6SMs0/IDea
KUtlsshZoKHJi8g7F5TrvdwL3AsXeO4Lyhy0LEozneCKaWg5BuastHu+d9+f
0w3vPnue+zzn9zvfc86dm56Zun1CUFDQdf+f/uS/tALP+MqRhSsDSlD3I9Om
PfEH6nJ1VpzYSFfrhvYWPbm+U2VkZAyLVabKG0mJXSX371apjvA88WC2ejVv
5JI46DN1J8URvpqek6P8t+8Sq/0qJibGJo4+qPTHGnl+rurv60sSJx/SzysX
D+ap4MvV98RZX6h9oeb4d+T9X+J+ceFhPH+tjOeI8o5HpoktX6nX/A0TqwLl
b19kPL2jEP0RRx/V9U9aRz84qvxfzxYbx3S9I+L8b5R/eFsTpJ4i9Ulc8GVx
2HHdv5REqe+4rr9PbDqB+t6Ver/FeMWxJzGfSVJ/Mfor7i1WQ3tD31gv/ShB
f8SbS5GP96Q/ZcocP7RXfKsMeRBbTmE8G+g95cpfTrVYndb9GBdPrNDjXZUs
/axAfsR9FXr8neLoSvRPXFSJ8aVIvysxP+K0Kl1vjNioQr3iiGpVUlz8kji/
GuOT59+pRj/FyTWoX2yv0fXNE4fVYrxSXw4cJx6s1e83S7/W1KmarLhgsakO
8y39D6lHP2S+surRT5nfgXrMp+Qh1qTrN0l+yky6PwWSt6AG5E3yuq0B61Hy
3duAfMn6WdD49PosbFRP7R9jjXq9ZSnJyxnkdwXtOoN+x0l+zuL+t+hDZ1HP
csnTWfR7GZ3UhP3jTclXE8YXQ4eaUf9iyZsZ/VpEXzMjjwslf+cw/ii65hzW
b6Tk0YJ+zKeXWnQ+iudJPi1Y33PpEgv6GS55tWB+X6YfWZDXMMmvFc9/kU63
YnwzJc9W7Bcz6PNWvb4ypku+rdj/ptFRzcjfVMl7M/a/EPrrZoxniuS/Gftb
MD3arPP88DlZDzbk5Vl6o033J3SyrA+bzuvhiXS7Df2cIOvFhvE9Q4fb0b/H
f3D92DGf/9G5dqU//qXtdtTzkB62Y/0+oMNacN7cpxNbcH2MzmlBf0dpcwvq
+4sebEF+7tIvtKLeEXpNK8Z/m/60Fd8fpk2t2B9/o6+24v036ZA25PcGvaIN
83udzgpcv0pXtWF9XKEH2tCvn+jJDvT3BzrWgfF9T3/swP39dJlD53HoIv2d
A/3opYOcen1u6qGXOLFePPQ2J/LSTZ9wYr5cdK8TeXbSD52YvzZ6QTv2Yzu9
pR37q5UubMd4zLQn4DP0WOB+Ez2/A8+rpTd34H1V9OEO5L2cdnVg/yml/+zA
fnySnuNCv47TqS6st2P0IRf23wK61YU8HqFv4f7xfHp2J+Yzj07qRJ5y6c87
0e/9tKUT9eXQNzv1ery2hw7twviy6bVd+P5uek8X+pFJN3bh/bvoa104n3bQ
U7txHm6nVTfet5Xe3Y3530LXdCPPH9I/B+7fRE80dP8PvE+/YqA/KfRSQ+f9
wnp6g4HzI5HeYeC8i6cPGjivVtMlBn4PKNpm4P1v030G5ms5/XvgeUvpRwbW
5xJ6lhv1LKKj3Rjf63SCG/2NpNPd+D0TQe9z431z6SI39v9wusmN+Z5Nn3dj
fmfRN9w432bSD9yYj+n0DA/OrxA6yoP97Xl6tQf5nUSnedCfCXQ27Hl0m/u9
B/vNP3Q9fOFv2ghcH6N/CVy/R48Gnn+XnuLF82/TEV78nhmm47x6vI6b9EYv
+n2DzvRiP/mVzvei/it0pRfzNUC3e9G/S/SPXvS3n77jRf8v0pN8yPt5OtyH
/cBDL/Ph/Oymk33YHzronT7spw4614d+2+lSH/ZnK233YbxNdL8P67GRHvYp
//8H6ujHgfFU0WE9OH9P04t7cB6V0ok9mP+T9Ec9WB9FdE4PzuOjfv8PvWZt
PA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlg1MlWUUx8l52ySWfbBhudDMnDhtGA2pRB8/8gMpgRKlbqaIBLkCLQgR
CxwsciaaaIFk8iUXRLxwL3C9fL33vRe1DVtNF6usxKXDYOVMzdlG3edP/+OS
Ddhv732fc87//M+5z+PJGQkbxwQEBPzk/9X/+bNsILc0b2jWglFarrw3pp+/
w0mqJjM6cDvZSFYl5o3pwgHpaiA3+ClhlaGG412hdz6/RTUtHbgt513IUv3V
mV13zt+qXKFFm4Qn56kEV6hFWH2ouWgbObxAf34oV87foc+LFo4rVNYSM2ur
xCtS5WVlZTnkzI9UdGB/9fsS/2M8zybv2anzzc2SfHapbcFNS98j2z9Bfu9K
fiVaD9tmctoe5JMp+e5VYf6E3iHf2quKhuKj3pb8P9V6HdpELt6n87+RLvWU
4rw08oT9yv83P1Xq268iIiIcKWTbAeVPdyBZ6v0M+a4nR32u63/iDam/TOe3
8HXy6TLdf+troke58suVmURec1DdnG4tWS36VOh6XKvIgxXo98ui1xd4P4Gc
cwh6xot+X0KfOPLYw+ivcNph9EM+33cYesh54ZXwm8QrrdT5jX9F9B5lyc9a
BU4U/at0/x+ReqZWw99rpB/VWt8IqX+4Gvm/Kv2pUZujA1eLXs4a+Nkq/apF
v0TfvFql522t9K8W/pF+LD4CPddJP4+oM319fdK/oLq7+lun9b26gXyuTscL
2Cj9tqFe8UuFTZ8XKxxQD/3EPyn18J/EO12P+JLfzAbkK/XsadD7YafUf73h
Lr8c1fmuF307j0Iv6cfkRjXJX7D0r7AR/pN+DzZinleSY49hXl8Ufx1DfivI
wU1a3+AY8VsT+rGMfL5Jx+9fIv47jnxeINccV6mpqZcXiR/t8PtCcqQd+i0Q
f9qhnyKX2zFv88WvdvRjHnkE542PFv82w19zycnNyPd58TOeO54jn2zG+8K3
muGvZ8kzWhBP2NoCv0WRd7dg/wgbLZi3OeRrLYgnPNWB/Suc6EB+wsUO9FfY
fRcPO+AH4VAn9BSOc+L7QHiHE/4Tdjr/n+9lJ/wmPKEV/RKOaUV/pP68VuwX
4SbwQtHvQque51PCD7XBf6L/4jbkI5zdBv9Jv2xt2AfSzx/asP+Eg9oxz9L/
ee3YZ+KPzHa8L/6pasc+En+da8d8C9/rgr7CUS70T+K95YLeUk+FC/lEkr92
wS8RMv8n4Jdw8tMn0O+Zsg/AljDygdHnT8p+GH0+hXwb5+WHyr5w4/yJ5LVu
1B8i+8ON+h4mm2746wHZJ27suyDytA70Z5zslw69P761kHd2QM8xsm864K+R
3/7j3ztwX/mbPLkT94G/yAmd2B/XyYWdqPcqua0TfhgmD3Zq/6VeIT/ahXwu
kWO74LeL5A+6MF8/k+1d2B8/ki92wd/95OBuxDtLXtKN/n9DzunG/usjN3Rj
Xr4in+/G/aKXfH8P7nMmWfXAL93kLT24/7nJNT3Iv538XQ/2v4M81sA+spMf
M7CvG8mRBs6zkVcaOK+WnGbgvEpygYH8DpHLDeRXTnYY0PcAuc9AvfvIlwzM
Zwl5xID/dpFDPNCvmBzuwX4oJC/34H5UQE72oP/byds82DdbyaUe+C2bfMyD
eraQT+J9Swb5F7yfuol8C++fepP8oIn4KeQZJuKvIy8yMQ9WstWEnknkLBP9
XkXebWL+48l1JubnJbJhYj/FkL834f+l5Gsm9F9Evs8Lv80nT/XivjSXHO1F
vlHkRC/yfYac4cX9bTa52It+zSJXerEPwshuxIudRj6LeLYp5GHEs0wiW3yo
byI51If6QshzfPBrMDnON7pvyOk++CGIvMOH+RxHPuiDvy1kpw963EM+44Me
I1f4feXT/su/Tf7Hh/vHTfKEXuyjP8mzezH/f5BjeqHfEHlDL/w+SM7rxffp
r37+F2zUX8M=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx5nL1rTlcrSoFllZIyuH0dS1UR9/pIA2kT9It6slkoFUIIUp
ogLBJDIQQxNEBQ4BEc6DO47jjoPvfTmstrPVbLqcLmxlTpgrp43ZRt3n/e15
M7qNsdc+P5/3836ez/fJjNy0d2dERUVdifzp//KbddH+R9/Yi8ssSlZXC6MX
TvFGleaNLfcIGxkqgmO9HM/WnENWucqx+updN+fnq/H13uPk0QK1LXHWm+So
nXo8ljyvSNmqzTsu7rdXRUc2JMeX6PUXyUbp9PHUsunrR8tVfV3dI9w/b596
zla9fOr8z/T8AvKBSpWQkOCaus9+pfUhO7+APlPxVk+PP+sA4iXH16iL9rwA
eaJG7Yp2fE02DqrIddvJFV+q4TtxNnJqrXqifOwHnh9zSOl/U3oeQj56hNsP
63jruhnvV6olL3GWU3jpEb3fegfjr9Px5XUKf1MHPTqoR73aEvm1C284Cv1a
qU+DSooI0iJ8vQH5aaJex/R47QnhHcfVuXB47THqdwJ+qRe+pxF6HKGejfDL
YeFwI+Kvpb5NmF8jXNuE/aupdxP8sF/Y1oz8VFL/Zp2P1RXC8+3IdznzYcf8
T4XH7di/hPlpwX32Crtb4J8i5usk/FEoXHRSReR5egfzdxL+LRBe2YrzPmI+
W/X4pm3C97dhfS7z24b8vy/8YxvO38p8t+v7FWcJN7SjHt5j/k9hP45nnoK/
s+mHU3q/BO73Qgc4h/6wmOfftvgD+uW0zk/ch8IDp1HvvP+8TvVXnG1OnnBZ
J/RkvNc7tf+ukdd2af3D+fRXl76vg3pFO7TfKz+m3xzQj/pediC+7fTfGfiP
3HIG9foJ/eiEfszXYqeKlM/SnfSnE/cj1zvhd+Y77IQeu4Qnnahncnw36ot+
yeiG/8i13ajH3cJnrXHyhLV+j/CCHuxPtvXgfPqzqgf6kI0e3W8uk2/1ID/F
rAcX6o+c7sJ6coUL+pN9Lt0fTPL4/zjWjf5ETnXD/zy/1I16Znxui6nnNTf0
YH5iehEf853Si3qgn4p6cR796OhF/6KfR635W4TnerQfqzezHj3wyzvC2z3w
n4316YH+G4UveRRkYr32wQ9pwq/2oR7WsX77tJ+8a4Sb+9CPkljPfeinK4Xv
9eL85axvL+p9hfBWL+Ll/AYv3u/Xhb/zQr9VrP9+3H+18Ev9eH94fmY/3otk
4cP90C+F/aEf+vD+d/vx3qxlv/DhvuS3fajHN9g/fOh3ZNOH+iLf9qE/cP2z
fozz/A1+1APvX+lHPIx3wI96pl43/XgPXmP/GYDfE4XTBvT8xFfYjwbQ75cI
ewZQDy+zP1m8SPjRAPRayH4VgF7PC+8JwK9x7F8B9ONnhH8JwD9PsZ8Noj5j
hVcNwi+Psb8Nwq8xwh2D0Pch9rtBnDdX+IEh7D+H/W8I3yOzhfOHUN/3sR8O
If6ZwheGkI8Z7I8G1k/e+I8fN+C3v4UXG8jXhPA6A/m6LZxlIP9/CpcY0O+m
cL2B/nxD2GWgH/wuHLbm/yr8m4H8jgpPGqiHK8IPB5HfS8LxQeh7QTg5qM8r
PC+cEUR+vhfeFUS9hYVrg9DnW+GuIN6DEeGz1n6m8M9BfC8NCU8E9ftr9ws/
aEIvr/ACE/q6hVeY8Fu3sM3EeV3CBSa+5zqEq0zo1yrcZiI/dmHDRD4bhX8y
oVeD8C0T9VEnPHsY9z0kPH8Y/eygcCK4vUo4fRj94XPhXLBjn3CFNV4m3GSN
Fwv7rPHdwuet/XcKj1vnbxeeGcL98oVjQ9b3hvCSEOLLEU4NIR9Zwtkh+D9T
uDSk9Zq5SfhoCPl8S9gdgp83Cp8Lof+kC18LwV9pwv+E4Nd1wjEjeB/XCC8a
Qf6ThFNGEO9K4c0j8OMy4aIR3Dcxwv8CFnZ7Wg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1GUcx5nT1rTpbGyam0TTGlk5ys3cGu0pLdK5Eluo7eYmFsNcg1g6
RVQkmUQFWucL+BKvciIeB3ccd8cB/3sBtcAymy6nS2oxp9acpSPXMv7f6/vl
NsY+e/7P8/xevr/v//9ETv7K9yckJSVdHfuz//NXU11dPXjzuVcStNQ0FmRM
HhKvMY6q6CaxlWNid9OujK9vME87ql49Rzb5JmPypQaxVWjsf9+Rr20yye7M
deKkreZSQ0GPOLXYjMXz2Pc6b6dxZw4XidN34X6xVYr7z5NX7DbDRclu8bUy
nPcDuWCPuZfmqBInfWpWBlImXSDvrbDjLRGnfo566HnPF2ZocHD5eHxV5o3h
IqfyzdtrAillN1XP9H3m8bKbWd+SR8Hnzyr+L5HfGXL5V+ajjMmrTisfpxkr
Z8EAeeZ++/7BfuW3H+ti1wHsFxccxPniRYfMtmT3aXFStV3/DJ1/phrxiffW
YL/iWX3YLBj7Kd7UI/b6ffH1Izhf+XmOmltZgWPfkLccQ7yqh/nafj5T9ZpY
a/dnmvSVV2v3NyoerEV+qnd6nRkrb0DsrMPz4tE6ux8bxY566HNcz/Xot+6f
2wC9KL7yBuhF+dxqsOO/Pd6fRuhP9fI12vur4+pXkz0/d6Pk4ibEH1H/mhBv
H3nJcfSjV/08jvUw+ZFm7O9Wf5tR/yD5x2a7P96A+u1C/7rIR1zQo1/9P4H7
OsnvnUB/fdJDYt1LfrbFnj9Hh/TRYs9PWTv5rxb0wyO9nDSQATl8Eve3ST+t
mFc3eXerPU/J4uutOP8UefkpnCf2gEtaycluzLN4ixv9O0m+4rb1mCI2bbi/
hdzYhn6KJ3owDyfICz3wL3GeB3pwkWs8qLd40IN4xP+Cy5ql33asi3Pasf+4
9NxucnNzR5rIA+3wH/FouxmTl6uRPK8DemmQ3jvgF7Xkyg7kc1T6T6zXkO8k
9h/UPHhRHyc52wu/26f58GKeK8khL/r7mebFCz2Vk1N89nnzyzQ/PsRfSi71
4fxdmiefradF4hEf+i+e2Yl4S8jLOlFfcXEn9ovdnXb/hndq/jqhH/GjfviP
eIkf8ewgb/bjfSB2+ZH/dvJlP+pZrHntgp+IX+7C/G7T/HYh3iJyfRf8aavm
uQvzvIX8UADvl82a7wD85mPyBwHot1DzHkC++eRzAbzPP9T8B6G/jeQXgpiX
PPlBEPOYSz4Adq6XPwSR3zry/SD6uVZ+EYJeHeS1Iczfu/KPEOJdTY6GEM8q
+UnIrndFNvmpbviLeHU39KbnK7rt+s3ReeFu3LeG/Ec33k96PjWMer9DXhlG
fd6WH4WhnyyyH+t335Q/JfYvJ8/qQb7L5Fc9mN9M8o4ezPdr8q8e5LuY/EsP
8jXys14D2ZBf74XeXpK/9dp6urSI3NKLeBfK73rRrwXkqX2IJ13+14d5nE8u
7EP+z8gP+6C/NPLFxP4n5Y8W+j+HPNtCP1Pll5b9fO5s8lsW8psl/7RQvxnk
XRb6myw/tdCv6WSvBf+aKn+1kP8U8m8Wvg8flt8m1ieRZ0Swf4L8NwL/eHDj
f14aQb7/kHMiiO9v8rYI4r9HdkbQjz/Jp3B+1m3yAM5b8Dv55wj85QZ5NIJ6
jpCnR5H/r+R5Udx3jbw4ivfvVbIjas9b2mXypijeRxfJlYnzLpCbo4nvabIV
xft9iPwT1u+fJd9J7B8gT4kh3xh5bgz3W+SMGPwmTM6OQX9Bcn4M33t+cnkM
89RBrouh3m3kUAz1bCVfiCE+F/lW4vkm8qQ4zq8np8Thl8fIL8bhb4fJK+Lo
zyHyhjj04SSXxpHvPvJh7J9WSfbF4XcV5KE49L+HPBKHHj8hP4hjvkrIM/vx
PtlOfr4f38tbycv6Ed9m8vp+6LWQXNyP+uSP8X/7K4kX
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1HUcxm8ta8Nmy7HCNkkXa/ROuRlrO/ezN1/GFtDmS5ElpoHVOC3M
F8owGIgpiEjyKnC8i3hwB3ccB9z970hdUJYkvmCAJhkwVy6auVbd77l9H29j
7LP7vX6/z/P8bmFyWuLGu0wm0+Xgn/4vn7Bh6++TU08vDdEKVVpSMu8Or1Xj
O8Of+U3Ymwy+zu9T1XSCK/JXYZWmWpeN377G8VvV40n5xi/CY+n6+51XOX+H
MocNP3pFeEGGGrZaesa43m61K7x12ahwTCbWu8z19+A8I8LxWWr5+M6ii9wv
W7kis6fOC1ty9PrmYe6/VyUGB/wkXJCn9zt5luf5Sul/Q8K2/RhPVvnqr+ik
+zk/pUDXo5Icc1AtCn7OCd86qAYHBgbI3kK1KfjheXIP6fVn8bzxRSrfmGkk
RxzW8+Mu8H6HVbAcM+TGYt2/Et7f8rWu10uXhGOPoB5kUwnqxfqdKkF9WN+C
UhUs/zh5TRnu/zPrU47+sT/Xy9Efsq1CbTGHrWY/t1di/zv9PQo9jAvfXaW0
Hvl9SpU+XzjXG6hCvXiemGqM532KqpV/JnqE979VrbKnEmLJSTWq1mIOI3tr
oC9ylFWfd5ica0V9uP60Vdc7/Y7eavX+Fp7HUYv7sD4RdVof+Tx/Rp3Wayvv
N1anHsme+oH3f6UeeqM/GuvRf/J9Dag32dKgx39B/ww1QF9cL7YR65HLG+Fv
7m9qgn95vveaoGee/1QT+sX7PtWM87MeBc263kms15/N8D/1uuYY9EJ9e47h
e/pjQQvm009ZLdov9h+ppxbo+4xw3HFdj+jvqa/j6N+gcHgr1vuWegvxaeGR
VvjnJPV3AvnRL1x7AuczqEeb1o/LK7zYBv31Up821NcjXGrT+srrol5t8LNT
+F8b9OKgftuQN23CyW3Q+wnquU3rI6FF+Js21LOJ+m6DPuqFn2jH+a3Uezv8
Tz7QDr3UUP/t6Ge18M126LGKfrCj/0eFV9nRj0r6ww7/VQi77fBfOf1iR56X
CUc64IdS+seBfpQI73GgnkfoJ4fWu7VYeMIBPx+mvzqw/iHhlR3I20L6rQN5
WCDc2oHzH6D/MN+8X3huJ/y7j37sxP57hbd1It9y6M9O5EW28MUQf0m/OuHH
TOElTuhpN/3rRL58JlzjhL520c9O6HOH8D0uzP+U/nah/9uEN7ugv3T63aXz
e/0nwt+5kB8f0/9d6NcW4ee7oA8L86ALeZEmXNyF9+0j5kPo+w+Fb3dBn5uZ
F268HynC69y4z/vMDzf8sFHYcKPeG5gnbvhjvfBj3VjvHeZLN/T3tnBeN/T6
FvMmNH6t8I1u7P8m88eD/OD4RI+e/0ES88gD/XD9Tg/6uY755IG/3xV+uAd+
43njelDPZOHP8b3B+9l6MJ/3v9KD82xinvXCL6zXa73Yn/Xc3gu/pwo398If
5JHQeK4/pw9653lUH+rN+2ztw/vIetT2oR6rhc/1IR/eYD564bd44fle1CuO
eenF+ZYLv+5FHr/K/PTCv0uFM714j5YwT72o34vCdswfWcx8xXzzIuFrmF/5
LPM2tP+Twg/5sH8089cHP0UJr/BBzwuZxz689/OFd/lw/3nMZx/u/6DwcR/6
NZd57YMe5wiP+tDf2cxvH+p/r/ADhkJZmecGzmsSftnAef+ZlHw38F78LZxu
oF8zwgcM+OcP4QYD/r8h7DWQd5PCFwzk14TwTQN+uSo82498GRWO8sNfl4TN
fvTjvPAqP/JtSDjND7+eEc71h95v4Wo/+nda2O1HXvcLn/XjPTSEp/3Iv17h
WQHUr1s4MoDfn07hFwJ47+zC8QH4zyacGkC9W4T3BPB7pFG4LAB/1Ak7AsjX
auHBAPpTITwRwO+pUuH/QuOLhSP6Mb5Q+Ll+jM8XXtmP92Cf8IbQ+BzhjND4
rCD/D/pMm+M=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlwtM1WUYxs9MaSFpGiXVQrrMYctG0ZKt4b7IQh2bSptZo1ZE5aXiaFEI
pMCklGVAockllftFOB44Bzjcz/kfQCropsV0NMGSCojQwjHmsPM9p/dhsqn7
7f//f9/7Pu/zPR/eFxsf/fo8k8n0i+eP/ld+3FPBMQHjq57y0noV7jtQMscv
qOUZYz+QnbHKEZgxNvd8+42s4tUuzwJz7+++cb2hBP38+bnv9yjP48llwkEp
er2dZLVP9ff19d0pHJKm1g0n+ZOd6WplTFbEHcKb9ut6N/tzvwz9fdTtwuaP
VZYxFbyU+x/E/rcJZ2eq8c2OY4tZzyfKs1zYImHrITVQYm73Y31ZylPOIwuF
t2WrUnN45i2sNwf63Sw8naOuBscs9mH9n2H9+cIHPoc+89hPrnrD82MSDjgM
nh2T/g4rf0vkq9eEK4+g/xlh8xe63vBp4bCjur/Aq8KmPGWJHJ75R7g3D/Ve
Fs7O13pV/i28tUB5/k79SzioEPWOCf9RCD3+FLZ+iX5/F048pmI8C/4mrI7D
PxeF55/Q65vI28Cp5L4TqJccUgQ9fhXOLYJfyNNF2n8PcL+YYj1vM9lZrEJD
Q23kB0v0eiPkAyV6nr6XhMdLoB95UynWJ9tL4U9yQNmN/aaUab8a5KEy3U8S
eW051idXlkNPsl8F5s31zRV6v9wR4bMVKtnfcpp6h1VCT86jsBJ+G+X8q6AH
5xdXhXmP0w9V0IPzfrga9dEP2dWY/6Twv9V63ln0z9aTqOeKcNtJzIt+C6qB
vnx/f43u1zJBP9UonU+sJ6oW77N+ay30ZL/+FviF+iRacP7ph0EL6h+m/06p
aEfgggvCpacwr0H60Qq/nRd+wgo/n6M/rdo/oQPC+Vbo+RP9akV9Z4Rnrcif
H+nfOuj9vXBsHebzHf1cp+c93C/cU4c87aO/63S9Cd8IP1QPf3xNv3v5K+FP
6/F+L/1fj7w7LXylHvndw/NgQ73kLTbkWzfPhw3+IrfYtJ4ZXTwvNuhNDrTD
D26eHzvmRU7H80iy3Y7vySN2zIsc0ID5GMIbGlAPn6c0YF5kSwP6IQ81IC/J
SxvRH3ltI/KE/H6jys/Lu4v9VDZi3uTzjchPsl8T8pf6rGnS83WQzeAw6lvc
BL+QzzahPs7Hx4H7ihzmwPnnPHc4cB9y3oUO+Jn8rQN5R3+YmpE/9M9jzdCf
/oprRj7z+yPNOL+sr7dZn89B6j/TjHo7mRctmHer8Mst0MPB/GhBPXZhowV5
Wsc8aUF/tcIrWjH/auZLK/xcLpzZirwqZt60op7jwhOt0LeA+dOGfD0qHN2m
55uXyzxqw345wo1tmPch5lMb+j8ofHc79PuIedWO/tKF97bDP/uYX+04L8nC
F9sx3w+YZx3I1/eEn+2AnmbmWwfy7W3h6g78frKTeYfvB94SXtSJ/d9h/nUi
H+KFd3cij7h+aSfq2SX8cyf8+i7z0Qn/sL57ndA3gXnphH7sZyOeRyQyP53K
83fqHuE0J85HEvPUif2pj82JPPiQ+epE/3uFL+F9M/WddeI+ShVe5kJ+pjF/
XdCX81nvwv3C72NdqIf7J7ugF+vP9b7PfmtdmDf16vGuT70vuJBXO5jfLvjt
TeElBvSNY54bmN8rwk8b8PtLzHcD+faicIKB+W1h3hs4b88JVxjIp43MfwPn
OUr4nIH61vE+MJCHzwgvdMM/Ebwf3NhvjXC4G/U/yfvCDT+sFo53Y16P8/5w
o78Q4SI39F3F+8SN87xS+Iwb/z9YwfvFDX/cL7ygC/os533ThX7uEV4NTgrg
/eN97i+83ft8Ce8j7/NbhQu8z315P2G/KR/h/i747ybeV+DJ66P/8/Uu1H9N
OKAb9/u08KPd+H1nSnhDN/S5LPxaN/SbEE7phr6jHv4PQiuQ4g==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1VUYx2+lVmiaRqmtCKdzxLLQUqnEji/LNFfKH6YbtUnGsNogG2XK
TAnyZSZoaIGk8qK8iHiFy/sFfvdyMbfQMk3TbKGbziZrzsLMSrvn++v7dbLB
3Wfnuec8z/f5nucwKjkt8a07PR7Pz+Ff+8mflZE1X8f3jpvm0mxzNSZpyC1e
ZCJOlqZPJjvJpikq59IkrS81NbPOrhCbNNM7vylK7CwznX0xZyaSezJMbrCv
Quz5yJ6XK47ONGXpCRvE5mNTWFBQII5bY3IuzW8SO1nIRzwv25xdEfmkzu/J
MYnhAHH6WpOSknLhVv7rbX5Jqi9vA/IVR2+08SnSw/uZsR/PKr9ckxAWSJya
Zx4LJ/ic8t1sz+//PPnaZvN4Um5Q7GxBflPI6z43h7u75yaonnxb/8ip5BFb
kb+4Z6utt+YFcsU29Muo3i+s3jHTyPFf2vyOij0FqG86+VCBPb9bnFeI/GeQ
F263+1/WenSR1WO1+GIR+qv9vV/dns/yHSYybBjlb3aal8IFqN5+u1Cv9End
Zf11Xfp374J+6l9cMfz3DDm/2PZj9ATpXYz4p8hJJej3OOlfYsLLfbHkMaXo
R4z6UYr8xpJ7S9Hv0epPmXk6/DOK7CvDeVHq12744RFy5m7UP1L92w19hpNn
7oHeD6qfe+z5+cPIg8rRz/vV33Kcdx/5eLl5LyHitYHqdwX6dQ+5qAL3a4D6
Xwm9+pGXVJpwOm13yA+V2O/mpf/5iSrs9w85rwr39zr5jyrkd428cK+x86WP
7N+Lfv5Ojq6GflrProYfr5IvVqP+P8lz92E/7e/dh/79RY6sQT1/k5fX4D4p
3zM1Nj7jX7LZj/lyg1y2H/Wr3n5ezAMP9ZjkRf7SJ9ULf9xFLvSifunZ7bX7
JfQn3/AiH+kfdwD63k1OPgB/ql/5Lt9LPuhyhPx9AP5Sv2NrrT6zBsnvtXZe
xssfm2oxnwfL/7Xw2xDylVr4UzymDnrIbwvq0O+huh91yF/+bKnD/g/ovtRB
P3GUD9+P1P3xQR/5PcuH88U+H/r1EPmCz553UjyiHn5W/Jx63Cflk1kPP6ie
mnr4R3r11MNv0ntYg7Ef6tfMBvhD/f6gAe+L/FLRAH3k/9MN6K/8OqgR9cvv
Uxtx3mVyeiPuUy+5pBH1/ko+3gi/nScPaLL5rT5Hjgd7fiG/7a7/RC5y138k
H2nCvDxO9jTj/nxHntAM/Q6TlzRjHou3Yf2y+FAz3pMj5OvNeJ+/1bxowbzU
/m+0QM+jmh8t8MP35GAL+nlM88Rl5Tu2FfE/aL60Yr8T5A2tOO+k5k0r3iPV
/1sr3stTmj9+xJ8mJ/pRv/TL9sMv4gY/7ov4ot/mF6H9Hm7D+6F85rbhPVU9
q9pu19vbhvkh/c61wa/faJ61w2+HyC+63KX51o55EyRXteP+dWjetSM/P3lw
B85v0vzrgD/rycs64OdazcMO6LuffALfz6jWfHTg90ryow7O30Oe5OD/sxLy
qw78sZOc6pjw39VF5DWOfc+mF5ALHei9jVyH9eAWcrf7/VzyeQfzZCP5hgO/
riMPD8APOeS4APyQRZ7t8ifk5ICtZ0c2eWUA/dX38wOYf5+S9wVwX9aSDwaQ
r/iXAOa18rkWgL/EQ4PQbz05Ngh9xTOCOE+cFMT7Kc4IYn5qv03gxeLyIOpX
Pk4Q/Vb+p3D+DtV3xT1f9Q/shD+l15hOzJNV5IROzIMV5AWd8OeH5DQ3/n3y
Ojc+jVzsxr9LbulEf1PJx9z4JeReN34xuX8I8a+To0KIX0SeHEL8AvK8EPJJ
JC91418hZ4VQ78vk7W78LLIvhPs9g3zYjTfkCyHclynkm258PHlEF/o9kTy+
C/NnPHlOF/wxjvxmF/wVS87ssvfrnbFh/g8Q1Hll
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1gtMlWUcBnDmtBbazbFCK7LpnLpsFJvSBX295KVYAqViMUu8BNoGunSk
lMpkqUvBQhM0FQ8Koh4PVw+HA5wb2ha6VU5m0wWWREFmJo3Z0s770PO0xQbs
t+983/v+b+93nkrPSlk+KCIi4kr41/7nT35PcvzbvROnDWiuiYuLq/nPi0xC
ZPvod2hfuvlzXFqBHJFpnLM7b8smy6wI/yzR59eYJ/N7vpY71pp2R3ZCuu7/
wBQE+irkUbmmpLh4xFI9byPWk2M3mxR3zJBlen6edb6ctMWUZSdELtd6+WZO
5/oiOftju964FVp/mxmfVhCQC7ebKOfsJe9qP59gvQzatQP5kU2BCS+/KpPO
KES+Vmq/u2w+uuT+XaZzfZRzlfb/qbH/dH3rZ+ZcW1ub1k8qMr3J7gPaf/Ru
rKd8dOxGPpXfij023ijVL/tzEw6vL42O34v9vKn4i01ku+NGKv1lMfa/UPko
Qf7n06n7sN4bys9+u9/E1+nu/chnivL1BfIv5xyw9zfJ5iDW0/2DD5lwP7rl
jEOIV+u1HbL5j9N+YkuRvwV0USn6Te4vtf1UrHjSDmO/itd32Na7Ux7jsPuf
vkj1cJjVCZEL5V4H+ktOKjPBvnFpur+2DJ/XetFHbP4e1H5yj6CeiqfjCOql
eGcetfO0Pln1PIp6zaOHleP5r6m+5eiXRPpCuY0/+VXVu8Lmr2cuvb8C9Zyj
+h9DPmbTy45h/mapH45hvmfST1eiX2aoPyrRX9PpW5WIR049jnxOo73HMa9G
/XPCxtM+ld5ywtY/Xu4+gfNhCp14Ev0iu05iHhPoKKfZEC6onONE/l6iLzsR
v2xOYX9y2SnE86L60YXny5NcNv5sOQPX4+QSF+5/Qf3qQj/Ld1yorxxbhXmS
06uQ7+fVz1VYXz5ThfNV7q9CvuUJ1ZivePV7Nc4zeWc1nj9Z/V9t+3m7fLMa
/SqPqcH1SfSCGsxjnOajBvuPpT34fOREzUsN5nE8HVOL/I/V/NSi/0bTebW4
f5TmCdfbHqe7apGPEZqvOvRLNP1KnQn/3STn1qEesrMO+9f9HXXoP3l4PeIZ
qXmsx7zK6+rxPLmiHv3zGP1dPfpbHnYa9ZCnnMY8ytmnUT/Fd/h/1y8MXNd6
97jx/lI88W703yP0ygFHad7ddv8xw+nzbrzPHtL8NyD+++nnGux8OYbqPGhA
/9xH72nAfu7V+dCA+AbTtxtwHg7SeeHBeXG3518v9qD//6YLPbZeEX/RAY/N
79p++pYH89tHj23E+fYHndqIfrhBb2/E/q7T3kbMaw99vRH91E2P8qJ/uugU
L95fP9BbBtxJ13ttfJc76G4v6qHrI5sQz1U6sQn51vM+asLnf6RdTYjnGn21
CfOm/UQ12/Ps7E/0rGbMx890TjPm5xe6shnvO8V7uRnvt176gRb0h/JjWtCv
v9FrWtAPymdZi/2+8sxN+mILzp/f6cE+vI90/xM+zM+v9CQf+k/7mTfweeU/
w4fzUfnY7EP9lM8SH+p3ha7xoX6X6DYf8nmRvuaz+d/0DX3Hh3qdpx/1o95f
0bF+fD85S8/1Y/6CdLof7xMfvcGP88BLF/lxnrrpk37Us44+48f3vSr6ez/6
wUn3+zFflfTDAeTjKD0hgPPYQc8IIP8H6bQA+nMfvTaA9/deemcA+SuiywPo
p0LaF0B9dtCXApi/bfTNAPKdTw8Nwnn0mCDex5vpBFxP3EgvCCIfH9JZQfTf
BnprEOdpDl0aRH7X0Z4g+u99+tsgvg+spnuDyE8WPSSEfL5Hx4Tw+Ux6Mq53
rqCTQpinZXRmCOstofNCON8X0/tCiO8tujaE+FLpcwPX59NdA/en0HdDiH8e
Hd2KeiXSz7ain+bQr7RiHl+ml7bivJtO57ZifqeG/Q9iWWoJ
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx28m1dBpGiVaopYVkRpKEW1Rv+zFl1gJa6TbzRVqgVYghSky
E4JlrAQLNZCIV3kRzoM74DgO+N//TnINXe/MogJXzA1WzaTIlnW/7/V8HWzs
9tn//s/v+zzP93l+tyQlPWnbNIvF8n3gX3/Kn23NSHbB+PJHg7RO7YwPHcwn
b1J7w2xryEaKOjMwMPAWn6epFwN/ZJWu1o5kh5GNTMTLEx7OUkXmRAPZskf9
EWktIi/OUbUZ8YVk9ebU59G5KhDeRjbyVMFYoitXeEO+0h/7eV6Bfh63Tzjj
bejN4fnvqCRXREG2cHGh1l+ym3reVWWlpaW7hO3v4fnr1FeE9zOFU4tV6GBN
Rgb1HlKLAgJeFZ48pPOPfJn631fWIjOLfOAD1PsV5lOiz5/P98MP6/i/kYcP
6+9/ki7ccETFawHM9yj07RSO+1AFwr9AvZZSdbe1aPVrwqdL9fu3M7/iMtQz
S3jjMf3+CHlxuQqc1sP6XChHvd5gvT5CPVjP3RU4bw/r9zH8wvpPr9T9DyWn
VsIvjDdQqf2XwPOjq3R+IdRfUqXr/Tnzn6yCP1gvazX0Xq1/tQqkc3m78NIa
9CON/ahB/1KFx2vQ/5fYn1roITtrkS85vE77bZScU4f3GW+4Dt/neY8fV4F2
7aCehuNaX/YO4Zn1qC/1Z9QjH/rlq/qp/ohrgN9Yj/IG9J9+sDSq8URXBf2w
tRH9veqHRviB9V7WhPlhv4ubpvbnUpPWP8Z+bzyBeOy35wTyuTpfzfAX389v
Rnyed6EZ/aOehBbkR/32FswH8wuzIV/mv9sG/azXkA3+Yn3VSehjf2pPYn62
0Y929H+LcKxd+2PiefrTrvXv3yxcBrZY6Vc7+rlJ+Iod+zOZ/m2F/meFU1qV
byLSmkg/t2L/PS3c36piYmIcT9HfrYi3VjiqTb8/9AT93ob8VgsfDD5/hP5v
w/sPCV9sQ/wHOQ8O+DVWONmB/MgHHPDT/cJuB/x4H+fFgXqTI5yYlxjOjxN+
WCWc50T9V3KenOh/tPCoE/Hv5Xy14/kK4fXteH85560d8ZcJ29qxX+/h/LVj
f0QJz+3A/RLJeeyA3ruEd3WgfndwPjv0/fbcUuFvO7CPb+O8dsKPS4Qf7sR+
WcT57YT+hcLVnfr8Fbdynjt1vvHka13Yn+Q4F+438nYXziOXu5Af+awL+m/h
/HehXuRVXfAfeWsX+kc+0oV5X8D90IXzyZe70J/53Bdu7acY8mY39lc494cb
8zxP2HQjHvmSG/W6WfjObuyrm7hfunFemHBhN+p/I/dNkOcK/9KNes/h/vFA
zw3CSR7M62zuIw/6MUu4w4N5msn95MHvlRnCC3q0vohQ7qse1Ot64X3gyOu4
v3pwfojw+R7cR9dwn/Vi/0wTfrIX37dwv/Win1fG/uemXr0vZv8jPNSL+v8t
PKsP8f4SVn3Yt38KZ/bhPpoQrg3y78Lf9GGeyNMN1Ie80IC+X4VjDeQzJvxM
kC8Ipxq4r0eFcw348SfhMgPnnxd2GPDHsPCAofTHD8I/G+j3d8JXDPTnnPA8
L/IfFI72ol9fC6/z4v76QjjFq+fN/Ex4L75fcVa4xIvfVwPCLV749VPhfi/q
dVr4Ry/2ab/wZDC+X3iOiXnzCUeZyN8r/JiJ+vUJW034q1c4y9T12N8jfNCE
Po9wvQn/dwsbJu4f8rlgPLfwRRP+IM/woX7kpT7sf3K8D/mRk334/UNO92Ff
8rwDwefkKt9UvW4f+s18vvQhf/K4D/cX8w/xQz/rE+FH/w3hB/yYb9Zzgx/3
ATnNDz8wXp4f9wH1H/NDT6ew04/+OYTPBOPZhUf90Ncs/C84oVE4/BT8Xye8
EpxYLbw++LxCeEvw+THhnFOIfzTA/wEfl4bI
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlg9M1GUYx8mBK6Lsj5tYi6icU6eNohlbo97MaTJa4Jp/6rKJeoNc47RR
KqRIkkjKYaEFkomHcqCeB3fAAQfc/e5AqqNWOZlN19GKXDBXTozZwu793p5v
Qzd1n/1+7/M+z/f5Ps/vHsvJX7lpWkxMzOXIX/2//HEsH95RObboxSitUKWj
2R4rea3akh4/VCHsy1Fms3nkAJ/nqcD4vEv7hVW+GrJZuj/m+1tVvSW9vFw4
XKDmm6xL9vH8dsTbK5xcpExWo+Ajxtul4odsf+4RTtmt7zN9yPglyK9EOGuP
ujHPNIPPw6VT37fsVampqS5yzD5VU109m/Ery/V5Kzl5P+KVCjsPqLFsz1Gy
sup4qcw3txL5kFMOqpWepFLWN3EQ9Zcx/08UshAu+1QNhkIhclaVioSzUb/E
Q/r9YuobPqRmOpavp/72w/p8Jvtj+Uz3I539S/tc9zft//5W6/hPsP8D1dCH
5ytrcJ73rTmi8zeYf3It7mO9V2rVo6Wj31Nf5xfQf7fwtqPo907q9yX6XSQc
e0zXM7yDeh5D/YXCoWP6vJnvp9TpfiR9IFxVh/vJE3VKh+N9puPo9y7qf1wN
75jpIM+xQZ9i9sMGPchjNujFerLq0V+yux79JyeewH30Z9EJVRgpkBw+gXrI
S0+qSLjNZPtJ6EdOaEB+ZEuDru8m7zvfoKzGuJ2cZsf75Fo76mU9MY16PuPJ
GxuRH/UYaEQ+1G9hk55HC/WtbEJ+7Mf1Jh3/SfZrzSkw++k9hXh8nnwa+fL8
ntPwB+NfOT21X5ln4Dfm6zyD/rK+mQ74hfpsc8Cv9OMlB/rD+VZnsa/4fv1Z
1MP4sU7d3zjWv9iJ/cj8c524f7twjRP6vU+/OnV98wqEJ53q5Ygg79K/zeAt
wjnNeD+ffm5Gve8I9zeryL/Fm+lvPA/lCS9owflc+r1F61dtFq4Az95E/7fA
3xuEr7Wg/hzOgwvztV54lQv7+C3Ohwt6rhPudCGfNzkvLnwfTMJJbvj1Dc6P
G/4gl7ixD17nPLkRb63wiBt+Jie2oh9rhDNasV/JRa3w02phR6vWu4ocbtX5
ryY/0Ab9yEvbMB/k99qQ/yrO5238023vJ7RjX5Cfb0c/yZZ27A/y8Xbtn3Pk
8+3wB+uZ7sH8kNM82Hfktz2on/rUeuBv8rfR59Q3pgP6kp/uwD5iPzZ2wP/s
3+EO7A/ywG18swP6khd24vtPXteJfjB+JdjM/I1O1PMa90knvj/ZwnO7MN+v
cL904fucIVzeBf8s477pgv+WCF/tQv0vcP94sX+eE17pRbw07iMv4j0j3OaF
31O4n7zIb5HwQ934fTCf+6ob+s0V3tmNeh/n/upGv5OEf+mG/x7mPuuBfrOE
l/Xo/o8+yP3WAz/dJ9zUg34kcN/1oJ67hO/thX/iuP960f87hLf2Yh4nR2Uf
9uL+m8IXejH/N4RjffD/deFHfNCXzxf7oMffwq9G358QzvVh3zD+bh/m+R/h
Gh/21b/CLp+K/FvM/EI+/F64Jfxb9H7WM+mDX6YJz/JjPmO5f/1T9Vjhhx7T
uY/90ONO4UI/fh9Szyo/9IgXPoPzmdS/3w9/3SP8sx9+mMH97Uf97N/9BvzK
5wsM6M94Lxn4vcn7TdH3mX+BgX3CeisM+In6NBioj/r6DNTPflw04Jdx4Ws4
b/9L+O4Avm9XhecEoP8fwukBfA9/F14VwP76VTg/gHhh4bIA5ueycF0A839R
uBPx118Q/jGg53H8B+GxAOr9TjguiPtCwklB9H9A+Nkg/NEnnBXEPjKE83C+
KiBcEkS/g8JHoszz7ij3Cw9Gz58THgni+8v7bwUxD18JJ/Yhv6+Fn4ryN8IZ
UWY9G/oQb1C4qA/+0Of/A577iIs=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx6lFW+Yq60q0RJrOkdNGsSVro33KJuFoCW2G22WJaKEtkEYR
UCpxqcw8UEAPEPnNgXAe3B3cHRzcL9I/0M31w9loQStyg1UrcYw/rPu8r+fN
ug3Yi8/3+/k8z/t5P8/nns7Jz9p3b0xMzI+RH/1XPmtNs5nDc5tfjlK6qrdY
LEu8S5UabJfJ/hx1KHXZjaX1PHV1YmKCrPLVXKa7aen5Qv38W+SpIuWON816
+f6nymBL20NOKFORcNwe7ncYz7uFk46qLHd8LNlfrmxp04uDwjsqVCSf6y6e
Z1LtBamVTuGCY8ocnE908PwTarrEYOsXrqpUr0X+YWc8J9X+yMcmbP9KRdJv
62V8ZujTI/x+lQrNJ05aGW81uFN4oRp6tTP+0zi/Vfj4GRX5faSZ+dTo/dOa
hONq9XpMI/OrVcnJyQ6LsLUOep9lvmehT41wyjl1J9FoPs38Lfr95CrhKxat
f0o19ahXzxjNr/D57Aatb+YZ6tMIfbj/rUZ9Xkkt9ToPP9UJFzehvoxPXYA+
54Tva0Z+9dSzGfVqEJ5oRn7MP6lF+8F0XrimBXpQr4UWHd/MBWFjq45nVQv1
b9X1yKD+69ugfxvr0Yb6sF5zbdqv0x2sT7vW8+EuYWc79GP94zp0fsZu4bIO
ZTQHi+iXqQ7Ef1H41U6s01/WTtS/T3h5F/QiF3QhH/rz2y74i+spVvQP92u0
oj48L6Zb62tlfLnd2v81zOdKN+Jnvpt60H/Up6oH/U6/3u5Bvah/9kXox/qN
gJ+lXxN6cT79UdGr+2vdkp96sT/9mNGHfM30F9hyUthgw3ol/WbD+8eEJ22I
z0T/XYKe5PZLmG9f0o927f8g33/BDn2O0592+OeEcL0d/iBP2FE/xnPXDn+R
k/pRD3JOP/xDrumHftzv637Uk+cvRJnxbRxAfzF+4wD6k/mdGtD+mv+C/h/Q
7x8sF/5rAHocYT841I22gtTDwjsd0Psz9ocD86VU2OtAf5awXxyIp1g43qnr
Ef8J+8eJ+VwkXO7Efh+xn8AlhcIzTq1fzCH2lwvzLF94uwv1/ZD95kI/fCBs
c0H/g+w/F/I7IPzooI5nWR77cRD1fE/440HM+/3sz0H9vm+f8A9RzmW/DuH8
vcIvDaFeOezfIfiV3DoE/fawn4fg33eF73dDn3fY327cn+QDbvh3N/vdjf4l
X3OryPX159vsfw/8TH7eA7+Scz3od3KdB/erkfPBg/O5vuhBPjxvkxd+Iu/2
ot/5fpUX9yk56EW/kW97oRd5wzD8w/Oyh/9/fuUw9iePDMMvPP/3YfQDOWEE
+ZCzRpA/9awAXyYP4vlM1uPWCO4X8mof/MX6Zfgwz1jfz304j2z3Yf7THz/7
cN/SP4ZR6E9/bRuFn8jFo/AH/dgzivuDfp0cxTzh8w+NYX+er8Ywv5hfYZSp
d/sY9Ngl/P0Y+mUn56Mf8/xN4TV+1GcH56Uf8b8u/IYf9Uzn/PQjn23CR7Gf
bSvnKd43KWGHH35O5XyNnv+i8K9+1HsL5210/2ThlQH4PYnzN4D9NgunBxD/
Rs7jAPp/g3Ap1pvWcT4H0K8Jwn0BfB9Yw3kdgH9WCf8UwDx7gvM7gPgfE14R
xPeXFZznQejH9a1B+M/A+R5EPI8LFwURL/c/hfX4OOGuIOJlPH7sb1otfDMI
/Z/kfRCEfk8JPxhCPzO/9VGOF04Nwe9reV+E4Efulx+CHit5f4QwL5hPS0jP
p4JHeJ+EMA+WC38TwvfzB3i/hNDPscKxYczfe3jfhFGPu7P/8ZYw5sWi8I4w
9L4jnBeG3n8Ll4eh1x/CDWHMl1lhZxjz+Dfhq2H0zy/CM2HUZ0r4nzDm76Rw
3Dj68abwc+Pw53fC28cxX64L7x1HP18TLhvH/af5X6LahH8=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdl31M1VUYx1nT/iBns1iRTcRsjlw2rGX8Ee2ULrJYIX+YbrcX8SXQCqRw
hCyTpIxlQKHJiwjcC1zeLhfuBe77O0oFlmmSRgvacm6y1lo25h/VPd/fnm+7
3s3LPjvnPOd5vs/Lua4qKM7ffVtSUtLP8X/6r3z2Zye/HJ1f97RBm9X8Fldr
hLxd6W9yqEDZcuYqwlwvUn9nmO4kq2I1bS7xh7i/VOW70qrJs2UqxZazg5z0
ntL3k9Mr1Z74h6wOJZ7PPHyL/SplKclO5v15R3CePFut7U+TSz7Gff/H94mK
m79OrqvR9mqoR/qnqvr6lqyYsP2YMtVGbpBVLfwZFy6s03rUnqG/9So5vuGs
8EI97p+g/5+rg3FBvhI++oV6yFT7zNeMpwH8jXDqcTU1OZk7yfiOq+iNDNOU
sPUE7jvHeL9EPN8KZ51UcTnM3zH+Rm0/cl54olHrd/V76tGk9V98UXhbs4qH
n/ED9WmB/5eEr7Ugv9PU6xT8+VG4vBV8mfqdhv9XhBe1af9W/0Q927T+LvJk
G/QnZ7Ynrje0a/t/0N5Cu2pqbGzkfaYOfd8M/Qt1oD4Yz4Nm6HOB+TAjX9Rn
3oz7qW+eBflmPpwW+M/8pXaiPpj/yk7Ey3qZ7YS+rLdNXVrPs6xva5fW2xoQ
XtKNdR/zC87xCl802MN8W3U+5tzCLVbcx/WkHvhP3tWDeGlvogf2eN/DvVj3
sz56kU/691cv9A6yXvoS4/H1Kf2H/Zbej/jYn0f6tV7ZPH+tH/nh/bkDWv8y
+msf0Pfd5xJOsen+mBxhvdkwPxzCM1jPHWL9DSJfg8KWQcyTAdajHXr1CW+w
6/mY1sP6tKuV8QLsFm6yq7mKFFsn69WO+WER/seO+ulg/Q6B24ULhhA/uWEI
+rUJnxmCvuSFIehHXjuMeUY2DSNftPfZMPqbHBpWz81VNNCfP4cRj5n94EC8
9H+rA/6SjzqQH8brcaDeu9gvDvhHfdKc8N/K/nEiP9Szyon89rKfnJgn1P+q
E/nrZ3+NQF/m6/kR+Gtjv43o9+om2Yb1VuZ79pbzd42ifujPplHox3gOjGJ+
UC8r2HRa+Iqx3sx+HcP6SeGnxqBXA/t3DHrXC3eM4f5j7Ocx9F+N8O0u6PsR
+9ulHot/PhTe64Leh9jvLvRHpfA5F/q9nP3vVvq7TPhRN/p5P+eBG/PjLeET
bui/l/PBDX/2CN90433YyXnhQb5fE37Vg/lKrvMg368LRzywv4PzxAN7BcJr
vPi9QfvbvMgvucaL+t/FeeNFve8W/t2LeOhvug/rbwjn+3C+kPPIB/tFwqM+
3L+P88mH+fGm8HI/3mvqletH/b4t/L4f9V7M+eXHvCgR/tWv6+E89U8JoP+5
/mwA/Uf75QHdvyn0pzcAvej/TAD1RV4aRL0wHhVEfTCfpUHMO9qzBHEf+VIQ
+jDeRaHE+lgRQv0z3g0h1DvjfclgxlMYSoz3sMGlnKcGvyPsCKE/3uV8DeH3
C+v3t5COz3GA8zaE+uL5e8M4T38yw4n52xzG71vqVRDG/ayng2Hoy/psCKv4
9wevCA+EEd92zmtj/1bhX4z9+Zzfxv4XhZdFdD088gLneQT7c4Q3RrB/I+d7
BPaVcJmx/0nO+wj8zxLuNvY/zvkfQbzrhS8b+9fxPYhAn7XCd0Sxfw3fhyj0
fEA42+CVfC+iqO904eIo8rGK70cU/vB8exTzhOyJol5XC1+IIj7yPM5byYtj
mO/ktBj+P0B+IoZ+pv28GOY7uQjrFfSvKqbrfR/9b45BD8bnjOH+FcJThv37
+V5hPWO58L8Gp/L9GsfvjXuE14+j3+/mezaO+5cJ7xxHPy7l+2asL4nzfx6s
kx4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln1M1WUUx28GVuhqNbawLbLlGrlqFJvxD+2pWGa5Aiq1ojcyh9aCKAyB
FAgKmQEmkiAir/IiXC7cy+Xy/rsvENXF1bQohxNcEQU558KISvs937vz3fJu
cPfZ8zznOc8533POvTMpJeHNZRaL5Yz5p7/lk1jiWViYv++RAG1QJqdfIr+g
QibqL5CNJLXN/PzJ9e0q1Lp+mqxSlHchInGR+9PUuzEhE+SpdKz/xfO7cJ68
Olvfl7pEe3tUQ2pMyN/CkbnKdLeZbOSpcb9/4z/CcflKf/3L+wpUwVy8i5z6
iTKvy7zM+/eqLNOBK8KlRWo+3hVu+V382af3L5Ftn8Lfa4RVib7fv0w4uVTd
YwbwWuHI/cp8zmCQ8GKAg4WNz7B/uXDhAe3PF9cJx5UhftcLhx3U8Z+5QXjq
IPwLEW4u1/5XrxBO/Rzv4f7oQ6qyoqKC91kq1KWIxJvo31iFSnCFF/B9pZWI
J+Oz5TD0wXivroI+mL/ZKqxTD7YjOE99ZVTj/ovM71HE/4JwUI1eX3VeOLlG
mc+/a17YX6Pt5fxGPdSqO8wE/ypcVquioqLss8KLteqJ6cwycmKd1t8k2ajT
+Xyd59fU6/cH035hvZrODLWS5+t1/mLmqLcG7V892dGA/JLDGhEPcnYj9Eh7
U42IB++PPabM8L/1i3DzMejtJ+GVTXjvOeq5CXo5K3yqCf6dEY5uRjxOC1c1
6/qJ+IH6b4FevhPe2oL4nxQea0H8vhG+txV6OcF6AZd8LfxHYP1L6uU4zo8K
DxyHHn3UT5uOR7RXOL8N9c/12TbEf0R4Yzv0T3u2dtgbEw616nrZzPszrLp/
FH0lPGlFPOiv6kD9+YUbOnDfOPVoQ7z53nU25JucbMN5ciX2f0v2X8WXbegX
5MhO5I+c1Pl/e2Wd8Jc82on+R17sRHzJa7uU+T+HnNgFfZOLu7T9R8lGF/JN
vtil9TfH96+x437yJjvyQy60Q0/kPjvey3jO26F/crgD/Zwc58B7mb88B/xl
vh0O9De38IwDehtifXWjP/QLP9mN+uphvXVjPjiErd06XqGdrL9u1JdN+BYn
8s/1WCfmRZfwTifs2VmfTtij/dNO9Gvyyh7kp1v44R6cd7J+e3S+LPS3rgf5
JZ8K7HcJL3dh/pKjXdAT7e1wIR68r8qFfNHfEy7Y5/ssvfC3Q/jBXp2vhXb2
g170wzbh8l7kr5X9oRf+Nwsv9UI/jewXfdB3vfArfeh3tewfffg9cFTYg/VV
R9hPAucrhe/uR388xP7SD//KhYv6Yf8A+00/+sN+4fOB9WL2nwH0q33CCQPI
9172owHMi4+FnQPoV/nsTwPoL7nCtw1C/7vZrwahj2zh3ViP38X+NYjzO4XP
DaIe3mM/G0I+yY8P4fz77G9DOJ8u3DqE87Q3OYT4ZAjfOIx5y/vVMOopUzht
GHrIYj8cxv0fCn8/jHrm+4IM5GeP8O0G4s14rDOwP0/4GQN6/Yj900D/KBDO
NTA/yZUG9MDzdgN65v3+wP30/+fA/R+w34Krybe6kV/GI9KN+mI8Nrihb9pL
cqMfkLPA9zM+ZW78XiK3u1Ff5FE36p981o35TF50Y57Q/s0e5I/+rPXAHv19
zIP5xvckgieY/3QP/KM+ij2IV5pwkwf+pLL/Y7/1HeEfPeifb3MeBHiH8Aov
OJnzIcDbhGO8yN9Wzgsv8pMknOJFPb3G+eGFPl8VrsX5mJc5T7zQ50vCJ71K
f73I+RJY3yIc7IO+N3Pe+KCvTcIP+WD/ec4fn7aX85zwdh9+zz7LeeRDvyAf
9qH/kB1X8bgP8SXP+JAf8hUf5g05bAT1EC/8wAj09DTn2Qj0/JTwGyPQw3rO
txE9n6NiTf4PPKeghg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlntM1WUYx8+c1Iamaad0bREt1shVo9yKf2hvl0U6tpAtxO2sFZpDWwNd
NAJnyCCRKWACyiXlfhOOBw4HzhXODaQ6VqZJFiZ0YTSorKEj26zzfk/Pl3E2
cZ/9zu95v8/3ubznkczstLdXGAyGa+F/+n/5mJOn86N/e/KFCG1Ry3mHSrPH
lJC9mWp+m/300vM9qsBoPk9W2fr920vf368mWnKSVglP5apb8aYKsuEDFT3R
coMce0AFbsabVjPeh2pfUvQEOeGQMpqT37qH8YuUqcJ/k5xarF6dzq9aw/NK
1OOmihfXCucchj6y4YjW57lXuLIM+tZRz1G1O/xZL2w5pvNNvo/6KtTm8Mco
nFWpwnIfvZ96j2u/Yh4QXozwBur/WOczTS49Af/5fmqVas1JiuZ5G6tVXW1t
LfVOVSMe8+2s0frX0q+ckypsTzz9STwFP/h9Qy38ph/jtdrP3CU/6pb7kVGv
43XSj9gGHc9PfbMNOt4k/bB8gv5gPnmn0U9L/p1BfzD+ykbt9wz1ZTXifOYT
alTT+can2F8JTYh/t3BVE/KJot9NKnzc3AphUzP8NdD/Zq0n6s78/xzXov0u
+0e4tAV+/i08D664JZzaiucLwgOteP9P4Y1tiP+H8IE2nD8vPNWG/v9V+OV2
5Dcr3NmOes8Ir+5APj8L53Sg/34Svtyhwn8Lp4UTOzE/14UbOlXJ3LbEH4QN
Xfo886Twri7U43vh8S7U86rwE93Q861wZbfW886E8EI3/L8inHEW8/qNsPss
9F0Wju3R+q2XhIt74Bd5tgfz97VwSi/m5aKwpVf7l0M2mvX8G8l5ZnUhFAp9
JTxpxv4iq3OoJ7n1HPSQV1owz4z3rAX1ImdFmPrqLJhX5heyoD7M/45luT8J
fegX+pfZp+tjp79VfZgH+j/Wh/xYn8U+1Iv129QPv64Jm/qRH+td3o96sx+8
/erhkrmLU8J/9ev6GMhxVuxHxk+3Yj9QT6kV+4X5OK2IRz/mrej3L4VjBuBn
iPMzgH39uXAR2EgeGMC++Ex4ZgD9/ynny4Z9Rt5qg5/jnDcb9sN5YbMN98UY
58+G+SWvH8Q+HeU8Rjgo/P4gvh/gfA6i/j7h7waxD72c1yHoHxF+fgjzN8z5
HcJ8uYWbh9DPLs4z+IZD+C47+sHO+bbDXz7fa0f/OTnvdtSf/EXkOeMbHLre
heRnHPCXvMuh5yeF+mocun4t5HEH9JFvO5Cfh/vCiXzIbzgxf+RKJ/wi+53w
g7zgRL7kx1zQR85wYR+Qy1yoN9ntgl7y7y70LznWvVxvmhvxmU+xG/6RB93o
d/Is3rfTrwc9mHdyigfn0/+DHuw3ssWj9/N21u9HD/Yr62scxjwNCb8yjP4d
5H4bhn6bcPcw5qmP+24Y9ekVXjOC3y/d3H8j0NcuvH8Ev4+auQ9HoO+M8JUR
7I967kcv+umU8ENe7Psq7ksv/KkUfs2L+T7G/enF/XFE+BDilX3EfYrnc4eF
rV70I78f8kJPmfAvkfhHuW+9mA+et8GHfirn/vUhHvVt8UHvce5jH/bVCeEC
H/xlflU+nF8t3Bt5n8/HfPCT718H55MXfdjf5HX+5bzJr8J/C8kv+VFPssmP
/uR5uX7Ui3rK/eiPGuEOP/rzJPe/H/uT9bvqR/1qeR9Ezq8TXhVAv/B5XADf
Z/ykAPqB+tIDuE8rhLMD0Mf6lAbQz6XCTQH4W8L7BO9vLhK+FMB9fpD3SwD3
XYFwVFDrNeTxvglint4Tfi6I31f7eP8EsX/eFd4ThL69vI+C6L/dwvVB1G8n
76cg7oM3hS8E8fvYxPsqiP7aIfxvEPOXzvtrFPFeF356FPr5fOso9JF3jiKf
7bzfRjEvGWH+D09eiTk=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx8nQCp1Oo0RLxEmlpaa5jFZnj9YyG1vKH2Yba8usYf3BacOZ
WKGDRbcUNPzBD5EfhxwI58Fxx3Hc4f0y3TrdKqez4cJKojzNTBxRYd/nfX3e
28Um7rXn+T7P+/P+/HiYsyE/551xSUlJl4x/+n/5sa+6vH3FtYUr4rRaXd6e
alfkN1Rhqv3UC8KBDeDlXN+E/SZhla/0ec9z/xa9vug54YECdSYajT7L7z9U
s0uurs0Sztih5ueWhZbxvE+UKeXC3KeFF+9UnvSS95fy/F16vXGJ8Jpi6HuS
95Wo8PC8/oXC5k9VqiHwCd7/mdpsHDBfuNyiLjSa/Y9Rz+eqqrKy8hFhx27c
P5f6yhDfHOG8cr1+NZ169+L7h4VH9ur4Vs6k/n2IL0249Au11PiZwXgqEven
7YdfDzG+/epd44fn2w4oww7zLMZ7EOvUk3VIabtnM/5K6COfrkQ85PIq/f0g
z1tfDb28L6NGxdZ60qlvqEbnf3Q6/Tqs9dx4QHhbrcrxpI/nujqiXjEuZPzJ
dTq+rx+kn3Va34xU4Wgd4plKf+t1PJ7JwhX1OG8S/a5Xxu+i+4RzG5RRXsMT
6H8D1pOFMxuVsTxvHPPRiP13Yv9xLM7/CK+x6nox/S3cZYVfo8JpTcpqNqWQ
dzTp/Dr/FB5oQrzkl47qenyd+21HEf9fwpOacR7vMzdjnXrONaNexoSzbOhH
6q+xob6TmP8WnMd4N7bofsm9m/XQgv6mPwtasZ/+lbciH/cI32pF/93LejkG
P1OEfcf095aJrJ829AvzVdyG+mY+h9rg1xTh7HbEy/w72hHfNGFjdOl+v5/1
Zkd+WH/9dt3/b3FdHUe98DzrcdzH+5Md+J76ljmwznrKc6jb83KnMP4qB/yj
X1EH+usu4TEH/GF+FndgHjG/GzpQXyPCFXEeFv6yA/10U3ikA/H+Jvx4J+Zn
TDi3E/f/IrynE/NhUDjQiXnwo/BNrN+4LJzpRL65vs6Jfv9JuNSJeXVF2OtE
/fH8mFPP++yfhdO7kN8h9k+cqW9XnH9lP3Vpv1ZdFR7sgl7Gl+bCPLom/KoL
eq+z31zoR7LdhfqnXwMunb+yG8LT3Oi/39mPbtQb/d7qRr+SbW5l/C76Q/g7
t66nCvKkbugnL++GPrK5G/njeQ3d0Ec+143+I0/wJHKWJ3H/ex68Z+QaD+Yt
7zuL/SZyUk+i/qd6EB95Yw/eg1vCB3oQH/l0D+JhfY6CLeQFXvTHbeE3vXiv
yeVexEMOeeE/+ZY3sf4f7U30b30v3mPm09KL/mK9+Hoxf1hv13u1HyWs3wwf
6mNAOMeH+r0kXOzT9V57Udjt034lnRce8qHfvxGe6cd7dFY424/58pXwx370
3ylhhx9/D4WFf/BDb0A4tQ96fcIv92FeeIS39cFft3BrH/rTJdzfh/rtEp58
Av45hdUJzN8O4S0nMD8cwlbstxwXPo/1lXbh5ADy0yY8K4B5c0x4WQDzoVX4
tQDOtwnnBTAfmoV3gqNNwlXYv9Iq7MR5zgbhaAD9Xy98JYD6PCI8FkC+aoWn
B7XeghrO3yDmXZXw6iDek0rO4yD8OyRcGER/HOB8DuJ8cjvOMx/kvA6iv/n9
90HEy/tGgqiXauGpIeT/MOd5CPFQ/4sh3FfH+R7C+8v4C0Lwj/7sCaF/6V9z
CPVEfwMh9Euj8MUQ4uf5N0OYt9QzMYx8U29mOFGvKYz4qXddGPlmPvLDqE/q
LQ3jPuqt/9+6Nwx/eN63YcxT5i8WRrzM1/gI/KX/6RHcXyH8TATx7OP7E8H8
KRPeFMH9u/keRfA+WISrI/C/lO9TBPGWCJ+JoD938b2K4D0rEr4T1/MR36+T
0FMovOQk9Gzje3YS/m4Vfhts+4DvG/Yv2mzwv7ozh8o=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1WUUx28FttRyFiVaIgYZMXJkjWiNelIzMUqhzWhjbZE5rD8gN5op
q3SwzJVgoQkSAZeXy9vlwr1wL/eN+4ayhm4uFsthQSWjQDMCIyrq9/venS/r
buo+e57f85zzPd9zHtfn5me9cbPBYLis/dH/lV/a0mHjS1cffiZM6ao0MJuw
yK+oGwk5pVnCvlwVZX5uLJPr+9T2sYNRZJWvSiYzU3dx/371UE7p5p3Co4VY
f5Hfv6u0++NeEI4tUjlaAM/zvPfVsLHAs0M4+bC+XpjO84+oqUxHzHbhXcX6
+Y5tvK9EHdICfla44EOdz23h/R/p56dtFi47pudvUoznY5XliIl8WtjyiQrO
JuSkMb5SPX7jk8J5ZdDnCcZ7QlVWVKxOFZ47AT1SGP+naq/2e0z46Gf6fSWb
mE+5/n1FsnD0SaXJbd7I/E5CnyRh0ym1rmTyYiLz/Rx6Jginnka+DzL/CqWF
f/0B4QFwAbmsEnqRs8/oeldvoD5V4HjhiSr1tibIeur1BfyxTvhAtR5f5n3U
70t9vXy1cEQN/EDOq9Hz3bhGeLBGPar97qW+tWCeV16L/Wupdy38ESOcU6f7
eQXj8dVBH3K8EfrFsh5G1Jf5TBmhz/2sTz3uixO21aP+5OgG1JP6FDXAD9Rz
tAHnk7c2Qi/qa2qE38nLm3T/BMgFTYifPNSE71nfVNP/ucqktPDmud/QjPqS
9zQrLdy3yAPNOJ/xJbXA/4v+aIE/md9MC/qP+We3wq/Uy90KPahnbBvqR72L
2+Bn1muiDfOI9cxoh/6sv6Ud99MvUWbouYp+M2N+3S08YoZf76H/OqAH99d3
6P59edGPFj0+K/2XYlH1BWlL6bc8i17v1xhfZXg/4x+06HqNcH3BgngX/duJ
73lfbifmI+Mp74RfGP/ZTtx/F/0d5pXCiV2o9wr6vQv63i58vAv1W0b/dyGe
24Snu+DfW9kPVsSzRHi3FfpGsD+s6K9bhJ1WzM+b2C9WzF+DcIwN82ZhSvrH
Bn/8I3zEprS/P/hb2GaDPn8Jj9swP+aFo7tRrz+Fd3TDv3PCRd2YL38Im7vV
+cHBwRvCo93Ql3xnD/ptVnhrjz6fx2eE3wHvJZuwf/Z34Us9mF9cX25Hv5Kf
siN+nl9gx7wk19n1+DIYz5Ad/URe4kC8zCfVgXjIbzqgP7nKAf+RLzgUbCNs
6MU8JG/qhX/Ie3rhL/KpXtSP5w30Yn6Q53FeKTnJiXzIrzrxnpLLnHgPyQEn
9CbPOJEP89/gQj2pV7YL85d8zIV4qLfbBf+Qr7nQ76xXrBv+J2e54XdysRv1
mRbucevfHyRPuOF/8hoP7v9NOMODeUV+zwN9yRYP5t114R88iJcc5YVe5G1e
zK9fhQ940d/kFi/OuyY84oW+5Dv64KerwqoP8ZP398H/U8L14f2Twt/06f01
+YtwhA/+Ia/1wZ8/C6eE1yeEd/rQL+PCeT7odUX4sA/vw0/ClT7U90dha3j/
mPCgD/00KnwlvP6d8EL4+8vCq/zI55Jwsh9+GhZO92N+DAnn+qHfReFD2B91
QbjcD79+Jdzux/w/J3zWD7+EhL8Pn+cXnvOjvl7hlQHE7xRODEAPu/CWAL63
CecE4GeLcGEA87Rd+HgA86FFuCmA+jQJ+wL4/06j8Le4L9IkPB1A/ZqFlwUR
Hzk+iPzJaUH4ibw7iP7ifflYr24QPhpEfxiFa4N4f8jOIOYH938dRP0Y71QQ
9WW8kSG8T7w/JoR8W4UfD6HebXx/wFFm4X3h9Q6+R+H1TuEzOK+ii+8T7otj
Pc6HMK+6+V6F0J+s378h9KeD71c/8mO9H+nHvHbxPeuHHz3Cr/ej3vRLUT/m
rU/j/wBMk4kc
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy8D14hl2jWxEjHJkNRQm9IP7KOSBtlCKqPt1hb9mOYfkBuN
kJUyWcZKsFADyfgpPwQ6uOO4Ow64+96BrJ2uH06ycGErcoHNmTiy0u7zvp63
4zaOvfb9/Hie9/N+nu8tzM7JfGOGyWQ6F/rT/+UzscUZ++LFZevClKbM7Zte
fYH8shquy+19XtibrYrHtySTTdvVyWAwmCmsclToezfZu1PtCh1IHs1T5wvM
y8mmd6dzXOH09ep9ZSk18shJexDPzfOLVGVFxTzGk7FX1eemlJBHizVHMZ/c
D1Qo36M38/tQLbGUrmf+ZSWq1JhM4PO4j/T6WN5n/VhlOmMjMxhfqXo7JWr4
WeFtZerp8wXlzzDeAzg/TXjqgNb3/EbG/wnySxXe96nmyXXMp1xFhRJ+Ujjm
IPY/wfwOQq/HhJsOqVA4dWuY72EVWn7tEeHkz3S9Nq9k/hWI92HhoQrln0wY
WUo9KpF/onDWEf3c8iD1qdL1aydfqIIeCdTrc32+mfvzj2L/Q9TvC613E++L
qEa8y6hntVoQMhzjC1bjviTqW4P6Mp/yGuWMLd6xinrXwJ/M31KrVoU+q6l/
LfKnXvF1uD+Z9ahTb4Y+1HeiDuc9zvrU47wUYXs9zlvLejXgPNavsAH5s76j
DbqfnOuFU4+pqwmWWfRD0zH041PC0Y3Qi/7JbYQfNgmfboQ/6bfkJuiTLlzV
pPMZI5uadXwF9OvrzTofG3moGXqSl7bo+Eq5v6wF/cv7rrRAL8aTdRz1Y/ye
48hvA/3TinyU8N5W6En9LrSi3tR7cxv8+Cj91YZ4WE9zO/Rm/fPbEf8K4ZF2
+Hs5/fel9utL9F89eHgJ/Wid7vfVVn3eeDz9adV6F98vXGnF/IijX60KaQpf
t6L/FtK/HfAL92d34P5F9DOemx8QHuxAvy+mvzswPxhfYqeehxXsP0sn/MV8
9nfq/SfYj94wsx8vh9dTj3gb4mM/brVBL+q3z4b82J9uG/QgT9jgT3KsHfVn
/2bY4U9ykR3xcL3dDr3IY3bkx/tjuuBXxpfehfnO+Au74Efm196F+5n/aBfm
JfWa49C8iHqmOnAe9X/HgXqw/k2O6fX/wQH/sd7R3ZjfC4TXgi/NZ/92o//u
E67thh73sp+70R/zhGc6oX8M+9uJfOYKv+WEv+9mvztRT7PwKSfOu4v97wLP
EV7pwvrZnAcu1O9O4UMu+H8W54ML/REtfM2l33fGbZwXbugZKfyKG3rdwvnh
xjz6d+J/Ntzw9zXhK274b0p4cQ/88JdwVg/y5/qSHvQP2dOD+v4t/EcP9P5H
OM6D+Hl/pkf/vki5LrzXg36+IezwYP6YOJ888APzuacXPIPzKsy3Cr/Xi/0R
nF+9mJ/U5+de3D+T86wP+8kb+1Afrs/vw/uB3NIH/5BH+lAP3ndHvwp97yar
fuhJ3tmPepHr+1Fv5nemH+dTjwgv8qGe873Ih/VZ7cXvxavCz3mR35/C28J8
SXhPeP1F4crweb8L28L3/SYc9CKeX4R/9aK/RoWve+GHc8JzffDfj8JJPrzP
zwqn+XDe98LZPsRzRniXD345LVzuQ39/K9zmg75fCw+G+ZTwTz7M66DwlA/z
6Svh2QbqMSScaMB/g8IbDH2eKSBsMfT79RufcJ6BedUvvN/A+69XuNFAPj3C
XgP5uoTPYv24Q/iyAT3twrf78XvWJhzvR3ydwil+7O8Q3upHfnye40d+3L8P
63fw/Bo/4u8SdvsxfxjPd+H7nMITfujP+CMD6A+3cGwAenmE1wTgN+qREUA9
+oS3BzAPqV9RAPp6hY8EkB/1tmP/pCF8MvzcLzwW3s963Qjg/TUgHDOAecf6
rhjAenL6AH4PnRB+bQD9Ti68yf8B24Voag==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx6nACk3TriS3iMoaOmsUm7I13CezTGIJtBDrssQfA6k4KQyB
lTJYxCqo0ALJQEAI4Ty447g77uB73zvMP862VsvVaGFbzk36MRdFtrT7vG/P
m8Hmbi8/38/n8zzv5/083+89haV5u6+Pi4v7MfpP/8pfly2zYeevDz4Wo82q
ymL/co63KYt903myUaj2ZSaem1svVo3mTC9Zlaq76y7lzj1fhucLhafK1flK
y0PkuANqT/Rvh3BKtUo812l7mee9rUIzqdaXhNMOqelcT/J2nl+jVlkbTatw
Tq3mDS/wvjoVvb5zm7DtHeVJrru0lfe/q56KBpQv3NSgouleeY7xvKei4QS4
7nhf/ZVqbeR+1Yh4C4SLmnS+W3lf2ofqbCSS/bzwbIwZn/ERnmf89R/r+Epe
ZD7NKi/6H8w36TD0ph5Th7XeX1Ov3iNK/1Bf2ycqWo4M1iPjU8S7i/m36HrY
dwufaVFROWf2UI9WnX9mkXDBUaX9Ukx92lDfvcIX23R8qa9Qr8+0npWvClcc
0/lHXqN+n+v63GcTjm/X95fvo57t8GOZcKRdtba03PkG9e2Af8qFmzugz37q
3aH9M/mmsPU49DlA/WNcKbyyE34i13fCH1XC050qPT3dyfWcLr3/IM9zdeF+
3pfUjXwYX3U3znud9evWfj7G/DeeQH7Up/eEfr65RHhRD/ZTf1sP9rNe3/ag
XqxvRq+u9x/sr7Ze1Iv+ifsCfqffdoEr6cczMaZf1/Tp+ieSm/pQP/KffYiH
XHAS9eF5/pPoZ96X0g8/0t+1/ciX8V3sRz3o7+wB9C/zcQygfvS3xY51coUd
/Uo9JmPrZHUKetP/Xad0fdPJ8Q7tv03ktQ7ETy5yoL7kVgfuI0cc8/vrqgP9
Sk4bRL+RCwcRD+vZPIh6kk8Pws+Mf3YQ+rHfVw/p+5dQL+sQ5hf1/mAI8c7N
nyHMS86ry0OYr5xvK53wG+dhvhP1fpb94cT8yhX2OZHvFvaLE3o+I5zsgv7Z
7B8X8nlauMYFf5FdLsSbJXzBhfvJScN4npw1PH+9ehjzlGwfhv7kqWHEz/uW
uVEP8kY35h3j3e+G3pvZn268H58Q/sGN+b6B/Tqi569nvfD6EczHR9m/I/DL
OuHjI+jHdPbzCPonTXiBB/NzDfvbA31XCe/1oP/uZ7979Psj4V7hrzzQI5n9
78V5K4Qf8eK85ZwHXu3HltuEj3ih762cD16d/44lwle8yHcx54UPfiJv96G/
b+H8AFvIpg/3LeI88eF7gfzAKObBQs6XUdxPbhhV+ofsH8X7P1H4t1H0MznF
Dz/eLJznR73JtX7cT3b7oddNnE/YX0JeEYAfydkB3H+j8FsB9DPZEYD/Fwj/
HIDfyZYxfE/x+SfH4AeeXzGG+cz4+sZ0/geZ3+QY4qcei8fhB64rcB3PLxuH
vvGch+PIh/zdOPQlxxs4j3yXgXqS1xr4/iBvMaAXucjAvCAfMnB+AuepgfqS
nQb0J0cM1JN6/RJbJ181MK+Z3/Ig+pucFoTfqOfmIM6jnoVB9CO5Kgh/U79m
rFdS34Eg6ku/ng5CP/r7pyDev+TZIL4X2B9LTZzHflptYp6w3x430U9LOd9N
+JdcbuL7ZBnnvQk/sX97TMwfC+e/iXlI/t6Ev27n+wB8gbwwBH3u4PshBL+R
M0Pob3J+CPOSXIp1C7k+hHx5fkcIejAeX2j+/PkmhHnN/KZDiI/6JITRL9Qv
OYz91HtdGN+TrFdOGPOb9S0OQ0/6oybG9NvRMO67ge+n2P7rhM+G0c/XpuV9
FUa9/xO+Flv/VzhpAvv/EX54AvX4WzhrAvrMCO+cgD6XhasnoP/vUf4f9PxJ
VA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcx6lha2iaRomVSEmGTg2lKbVdfc2KYJRApbaYW6QG9sBpYQRk
QJCIxoMiykPIozwI58Edxx2Pd787zD+wrdViNVvSlmuTWnPhGG3Wfd/X573B
Buy1332/n6f35/27R9IyU/bdGRQU9LP/V/+Xn8kW88iBPzZsC1C8SnGGF79L
fkNpfE/Ynab2+3/e5/MMFeK/4ANhlaluRaWWZ/Lzh5S+3yx8LUtZ4qbmDvL8
J/q56UPhiDyc/4j3fabjXc8Sji5QuaGWuI95f6Gaygm1ZAsnFanampoVOYxX
jPtyhc1HdX0LPmX8Y8r/J/+IcEUpnucznxPoR4Gw9Ut935LPmV+5jldTJJxe
ocqNmagvmG+lKr6R7DwqPFuprkxMJB5j/ieVv5ypUuGSUyq13Mg6wXqqEK9M
OOw06i1nfafRj0rhjmr06yTrPYP8q4RjzyK/atZfo/OZOCN8uQbzrmE/ahG/
Tnh3nYqJibHVsz/16qApZFeD8O/1+vyNc+zXV6i3STi7AfEa2b9z888HN6I+
xktvhF7OCk80ol7mH92E/p8SrmpC/Ar2uwnx2b/UZrXW3+Dj7H8z4nMekS1q
OtkZznmVtKhV/gEWC0+3KFPI5GrOO6kV86Ue7K24nxzWhnzIeW3KOxN1lXyt
DfHJz5/HPhRynufRb+pxUTv0Qr2a2zHvPOHvA8+p/9gOxON+1Hfg84c5/07o
nfu1t1PXE8t9vNypWs2mUu7r+i6tzxnud0UX9MX9/7tL5xtDf9h9QZ8PoX8M
X1D6H/0lohv7Sv8p6tb5pmZQT93oZ7pwYg/6Rbb2YF7kUAvik7MtWu8d5KsW
HT+f96uL0A/jt17U8/6W+QVbMW/Ws8U6v950K/rJftRaoRf2a8KKfSbftmI+
PB/di3rYn7RexGd+VeDkd4Qv9erzb+2nvntRD3ldn+5HAzm1D/okl/Vh/8ju
PuiDfLMP9ZAjbdAveadt/vMSm85/kjxow7zI0zbdvxZyuF3vcw45yY59Jhfa
oUey3Y73xz7h63a8f8hh/djvNOGEfn3f13u4b/3YpzeFLf3wl13cv37M9zXh
ZQ710lROVRL30QF9vSx82IH45A6Hvm/jK8I/OeBX5EUDmOcO4WcGoEfebx6A
npKFmwcw3xTu8wDyf1X4Lif2hfnGOrGP5ANOzPd17rsT9/P5N07sI+8Lcs2P
v9mFeTPfvS7Mh/VUu/A+TaQ/uBAvQXjOpfUYFE+/GER/44T3DMJfXqB/DKK+
7cJGgLfRTwbxvnpWeM0Q3kcm+ssQ9Pi0cOkQ/DKWfjOE7ydbhP8cwn1P0n+G
MZ9NwinD2Ncn6EfD6NcGYccw/GId/WkY+ogSfnAEzx+jX40g39XCR0ag/wj6
1wj8YKXwryOo/yH62Sj0GCb84ijqvZ/+Nop+3ifcFfj8vfS7UezHYuHFY6j3
HvrfGPrF54cCz5fQD8cwz6XCP4wh3jL6oxv1MP5KN/Y1lH7pxj4/ILzDDT9b
Tv90w69YX4Fbz+uvFfRTN/THftgCn3+Y/or4c+zfb2746Sr6rRv+x34v92B/
HqX/enR9+ZxPvAf9jaQfe5DvGuFcD+p7nP7sgZ7WCvd45uvjkgf6WS/8iwf9
op5mPah3o/BSA/4STT834M/U53YD9cXQ3w3Mi3rOMjBv6r3MgB9uFW43tD8/
9xT938D+c39+NNBP7s9NA/3h+YVe7DPvj/SiX4xv8sIPmN9OL/S9WTjTi30h
l3jxfZP1NXkRn/s3GPg8+/VdIB77Pe1FvzmfBT7Ux3mG++Bn1MNWH/yL+kny
4fsC9ZbhQz+5X4U++AH1XufT+xXK/bDjvG2h8BUf5nM331c+1BMs/K8P/n8H
31/jqP/29P+8aRzn/xFOGMf7alb47XHo/5Zw3jjymfHzf+/4YZU=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcx1nT/rBWq7FFbREt16hZMymkFvZITIPRRCrBuiwQGVQbF4Uh
MA2CQioBBfQAEbgDjl/HHQfHcdzB/aL8A9tcLVejpW0xNqk1J435h3XP+/Z5
O9yUvXye7/N8frzfn4fHC0pzjtwVExPzW+Sv/il/njI0BZv+emZ3lDLUY/XX
9zeTD6pY295rZH+Bimwvb+F6iXrtWmXsaWFVqpKSkpxkf5n+Pv+M8NVy7G/l
98fUx6lbrpATqlUEzW0874SKXF/ZLry9RoXWEg1neX6turS4mHVOOLtORfJJ
M/G+elUVCaBD2PgV8uvk/SeVO77+wy7h5kaVE/mP84znGxUJ19YtbP8W8V5g
fE3KYkzd0itc3Iz7+xhvC+I3C6+3qCtmo8/C+E8r/WNAuOEM4h1kPq3q30RD
k1U4rk3nvzTE/NpUU3AtcUTY2o77RpnvWX3e92PCKedUh8n08DjzNyF/u/BF
E/rnYD06EB/353Wi3jw/oUufZ2I8K10q0r5/mI/9POJhvhXd+r7rrIe6gH70
C2/qwTq/L+7ZmP9ij4psTxlmfXtVUVHRMvNv7cX3jGe9V99/i+cZ+vR599+p
f5/ON4n922qGXtnvBjP0SL2smnHeHb1Z4Afqc9Ki9z9BPcf1g+mH6n7Ui366
2g990X/pA6gX2Tqg63OZfO8g6sHvjYNaf43040+DOI/3pVhRD/qvy4r60V8x
Q9qPrYy/cEjns0Z/XRxCPeinbcO6/4v0U/Ow1nMq/XNzGPqhf/JG4Heue0d0
v4p4XsKojsfN++tGtf82s34ro9pvucwvawz9OEV9jSHer4VjbfDfSerNhvy+
FF6yQS9fUH/jiL9G2DKO/cepRzvqVyWcbIc/j1Gfdu0/61HhDjv09Sn1aoff
y4RvY38i17c7oIdy4QIH5sln1LMDeqgQ/s6BeHj/ugP1YXxPT8Dv1dT7BPrN
fE5NoH4nqP8JxMv8b0zgvlr6wbmxXgec6D/3NzhxP8/3ODGfKukXJ/TDfOIn
8Z58Qv+A843CtdH1j+inScz7EuHlSczfI/TXFPRCzpxC/wrptynMO7JtCv45
TP9NQT8Fwg+6MN/I6S70J1/4qAv3v09/unA/+VcX/P4e/TqN+XJIeFeU36V/
p7HfINw3jfPeoZ+ncd9B4bvdiCeP/nYj3lzhD9yYv2/R7261ut/dfUD4B6wb
uT9mBvrneTtmoD/eVziDfpPbsd74NufDDPzGeG/NoJ7kbR7ojfkd8sA/zL/Z
A32Rgx4V+fdz1uumB/pkPZ+cRX/JeeBY1r9xFvGRvbOIh/z3LPTEfiZ4MX/I
OV7Un/2v827Ug8uL88krXvib/IgP+iVn+fBekI/7UF/qz+5DfuQ/fLifHDsH
v/P7PXPwN7liDnogD88hP/LSHM4n3ze/MV81j/eXXDYP/7JeFrCB/PM89MD6
b/Lr9+ZZ8qP+jf1L9mt9BNnffX7Ug3oo9mt9xpNr/JhX1E8Hvk+j3pxRph4X
o/dTv3/6kS/1fdsPfdEPDwXwPr7J+RvAe/SGcEYAesrhPA7gPcsWrgpAD/s4
nwPw5+vCY+DcLM7rAN7vTOHfA/BbBud3AO/HXuEHgtDHHs7zIOZjuvCrQegt
jfM9iHx3C5cHkc8rnPfR/anCg0HU+2XO/yD685LwL+A0rt+IrvP7e0JY5/lb
wUElnBrC+7aL70UIfuD5pVi37uT7EYKfnxfuDeH92cH3JAQ/kH8MYZ6TV0P4
/Yu8OQx9kePDuC9JeGcY84/3ZYfRrxeES8LwQzLfozD0z3g7w7gvhe9TGPP1
ReFL+P4y810Oo5+s539h6If1jFuAf1mv5xbgd9Y3cwH1Zn8PL2Cesv/VC6iP
1sf/CK1zAQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln1InWUYxg/h+sNGUQh9QGYUYbHGKlj+Yzz7aM2SplLN1WE128Ql5NnI
MpU1h6c52aZu6ubH3PQc9fh1PJ4vj+dD3/Nh84+zYDSSwiiDRJhFxBZjf6zO
cx3uK0yQw4/nfZ/nvq/7vu7nfbqsquTQfSaT6afUv/6Vv/Ly8pWLv7+4LU0F
KsXlXeR9KnPR9ifZKFN2S35zN9cPq+XarM09wqpKZTnfWCYbR9VacaCvV/iX
aux/ie9/qRZtlvw+4Zx6/Xz2Ze73lT4v84rwlgalf/q5/wnwgHBRoyoJZG+w
8Tyr6u7qetwubDmpXkn9DfL8U+op683iIeHWZpUKv3aY8ZxWLbHbDoew6wzy
G2F8Ldh/TLiiVcVv55rHGW8b8p8QvtOmAtnWm07Gf06ljs9zCTedh75TzKdd
77fkFn6sA/F7mV8HnvcJOzq1vit+5ntBPW9u2R4Qzruo/s41PzTN/Lt0Pge4
30KXrkeE57d2Q3+PcGkP8uPzOb26/k6ev9qr9bvL812XVF3qAJ5f06d2L9e2
z1C/y8iP6xlXwNyv4sr6/JNpnqS+/agH9W7vx/7/6d2P8/m8eUCZUwWl3sYA
6sv9n7Wtz6/JBr2Yz5pN6xmjfkV2vV818/Ha9X65IdZrEPGFhesHEd8s6zeI
+s0J7xxS15LJwgjrOQQ9g8Ibh/E+9bIMq/zMxWcY3w2wjfXKc8BPrGevQ+fT
wv4zjUAP9u/BEeTP/l4Y0f0ZoD82jerzs+in1lHdz5X0461R6EM/l45BD/o5
PIb46OeccfiH/m0cR3707+o49KdfCyegF+NxgTPpzyyn9r+V8dc4lf5hfktO
+Jv9oiaRP/vFPqnnnYX9kuGCX9kvW12YX+yXChf8SL27XciXzyddiJ/730vv
x/i2TK3Xt2xKx3uc+bdPYT5Sr2+mMI85T+9MYb5wPr/ght872e9uzINzwmfd
2L+F/e+G/qeF/3LDz030gwfnW4Xf86A/yU0enb/na+GgB/3B99c80PuUcLZX
HUk1QDP944V+PP+EF/15hn7yIv6zwitexNNKf/nwfJvwmz7MB+Zb70M92oWd
PtS3g/7zIX7q9Ygf+l6gH/14n/p+7oc/eP85/PA313/0w4/kjdOYD7xfX5tG
/tzfMg09yQPgJOO5MY35TL4/gPuNnBdA/zCfTwKoL7k3gPuN/G0AepNNM4iX
/PL/+OAM7ndy5wziJS/MID/y3RnMU/KmIPqdvD+I+47xtwbhd3IsiHlHvoX3
K6nPcyHsRy4NoZ7UtzkEfah/OLTeH3+E4A/WLyeMepNLwoif3y+NYfidfvOH
oQe/X1bDiJf8RETrfZ3zrzACP3H+HYsgX/rZhfXN5F8jqB+fz5pFP3O/XbOI
n1wzi/7l+aOz6FfyEtjB+B+cg/5kNYd+Y75H56An2T6H+UD+fg75Ua8MA/mQ
nzTQr+StBs4j7zFwH5ErDOzP+jQY6E/Wv9tAvueFPQb6j/5PGuhvzovfDO2v
vZwv99LrJ4UfjeJ7oJHzN4r4GoQLotDvGOdxFPOsTrguinp/wfkcRX0+E56I
4vvpCOd1VOfX9anwz1HoW8n5HUV+FcIPx3DeIc7zGObfAeEdMdR7P+d7DPP1
A+HqGPYr5byPwQ/vCg/HdP5Xizn/sW59W/iH9Ptv8T6I6X407RZ+II55s5P3
Qxz5bBPOj0Pf7bwvwFd3CFfFUb/XeX+Ak7uE++OoF88Lgq8XCH8XR30Z3xp4
sVB4QwLrzCcbvLhH+NX0OvMvSq+XCB9O4Px3eB8lED/160ng/tnL+ykBf1Pv
awn08/u8rxJav+Oszz8J9IuZ99c8+o31fGke8+ZD3mfzqM9Hwh/PY96yH+rn
8X1RluJ/AfPyjZg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1MW1UYxxvD/ICLRkPiYjLESAwuc0GXTL5gji9xzpDo+OAwaUzESZhm
oZtBkZEpEzKHbsDs2AqMAS1Q3rrS0tJXentvy1DLdE4lLqhjUYKCxizDkH2Y
9vyb81+6JoT8cu95Xv/Pee4jlTXlb99lMpl+Tv/J/+q3ujuQv/rXE89maJc4
UJq7Z4X8ulisz3P9qVirFKW584+STftE88ruwB+KRY0I5De/S9YOyucl5Ku1
OE82fSjtbyMXNIi5VKrstr2PYG9ZcXGj+LfI3LpE+0ekPftvil9tEq36mvMa
/TWLTpvNdlWx5ahw7Vys/4X+j8HfguK2FvFSOqArjOdz+Tw1r9h9HOd/YHyt
QtbvsuLqNtTjW8bbLg7luXZeVLzeDntfM/6T8P+l4k+/EI+bW/UZ5mMV29O/
hOJNp6S/njjzOyXkv5hiZ4dIu3szwnxPi3m7JRpUXHIG58kmm0i7WwspnrWJ
h9MJ8HxbJ/ofVVzRJcoD+Rvor6AbetEUL3ejH4zPfVZUVVUtTSuu65HxLYZZ
v3PCWCtaoP+cXuiD/qt75fkq+k/1or+0V9wH+4zH2ofz9L/eJ+2bdcXmfuGw
lLYYrH8/+sX6FtoRX5L9sKO+FxSv2pH/LPvjgD8+n3TI5808v2kA9aO/hgzf
7t8A+s/6vTAI+4zXOYj4eH7jkEiX10L7liFZjyL6/34I8TO+Eif0/5Xibif6
m2L/h2U9cqnPvcPQ3zfUw7DM/+NLireOQM/fUR8jch5u8vmNkez3K0ahd85D
ZBTx0X7BGPzRf9MY+j1HPY1Jfc1zXsrG5fzfx3zc45hX5pvnkvX5h/Wpc0Hv
rN+CC/Vi/cV53CfUk+M89Eh95rjhj/Oyw43zfurTjXy8ijvdmAcf9epG/nz/
llvm+1yA+p1Af2m/cgL26d86gfg5DzMT6BfjXZ9A/TkfWzzZ82X2yH5fov0T
HsQzRf17UF/Ge92DeWI+hV7o0aP4NS/uIzfnw4v72aU45IW+xzgvmfOjivMn
0d9hzs8k/A8pPgLeM8h5mkQ+DsVLk9CXnfPlw/7oV/yyT8az0st586G+5xS7
fFIv1h7Onw/zelbxA37Y7+Y8+qGPLsXv+2X+3k7Opx/3CZ9fyTzn+Y1TqD/t
PzMFfdK/ZUr6MzHe/in0t4/znGHmd3cA7zP/kgDyJb8TQH9Zr+4A9DOg+GIA
9yHrawpC36z/U0H0j7w3KPdHqVNxRxD5kWcz59nPm0H0j7w1hPqS3wih/uS2
EOpH1kPZ+rgRwjyQHwujnvRfEca+I7eEMb+MPxLG/Ur+O4z9wfwLIpgf1qc8
gvuN3BRBfKynP4L6st7LEeRPfiiK+5X9KosiX/bzcBTxsd/uKPTG59eimCee
z5tGfrT/4jT6x3jqMsx4R6az+7uQYeZ/bwzxsV4ill3fgzHoheyI4T7g+z/G
ED/t52ioL+PZrGHfMJ8dGvpFvb+iod6cl2oN+uY8NWqyHiZy5x3sveP9lIbv
L/LvGr43ybc05E9+MA49kovj2fO8K455IlfGUR/GeygOfZKteO4kj2fOk2dg
fzvvg1/j8nurlrwex/1Evl/H/UDeouP7gvfH8zr6Rzbr0Au5Vod98gnYs5CH
dPSLrOnQL/knHfNP/9fB28j3GNn3XaGB+FmvUkPOzwUb94UBe2cU1xiI5zT3
hwH/HYr7DMyLlfvEwPfpScWXDezPdu4XA9/jrYo3JKC/49w3CfTnM8VPJ/B9
eoz7JwF/RxXvS6B+zdxHCdwHnyjuwvt5jdxPCeyvw4rnEtgXDdxXmfP1iv9L
QP8fcH8lob9axU8m0c/3uM+SuH8PKH4riX7UcL8locf9af4fJ8Wm9w==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlltMXFUUhiem9QEbjYZENBFrJAZNNShJ5QWz1UatIRF4qJhMTMRKWn0A
m2Bq26glEJFooUqrXERgoAwUhrkxN+Zy5pwzLepQrcViK7XQKFahtSKYpg/q
2f9k/2QkAfJlX85a//rXOue+6trK126y2WwXrF/5X/0UFxf71q48/GSGtotc
17MLq+SXRCi/aekvxVq1eLM0Z3aF67tFq77m/FOxqBXGWqH9GvfvEXZrw1XF
8/WS66/w/Nty/9yS4s0HxMK+3Ed+533vikorgN8UFx3E88lag5h11JVyf3mj
aFqqCJHnm8R+KyHeX/c+8iHbPhDLFaGeZcVtLTL/Vxjf5g+FpU8x43d/JJ6z
AvyD8bXK+DYy311t4kErQa4XHRZWuPfzvuuHkT/j0z6W8cd+Vdz8ibDkv/Ez
82nH8y8pzjsCfS8yvyPQZ06x8yjyOcd8P4UeZxWXfCam0+n0GebfAT2/VTzV
gfpPU49OUVNTs/iV4qou6HeS+nSDTcWXu7E/Sb0+Fzmzjmu64r09qC/3iy+g
d0rxhl4xUFfacoJ69iIfPi/dKzo7OjqmqG8f9PxScXuf9GMh473eJ/V3kO39
yI+s9Yt7m5ZOkwscMp83yM0OGa+L9y874Hc+v3wA/uO6f0DW/ymezxuE/75W
fGAQ+9Os3yDipd7bjsn8c06xnsfQH+RNQ9DjG9Z3SMZfwfrNDEFvcokT+pxW
3O1E/mTbMOrxneKdw/AXeWpY1rOGvGVE+qmE/mkbwfNmFK+OQC/6reo4zv+g
OHpcxp9/nv4ZRX4/Km4clf3VfoF+GkV+9HvZGPRZoL/G0G/sj1wX4uf6Xhf8
/ZPiOfCL7BcxjuezXwbG4cdZ+tGdnd9Wt7D+vkc9drmlH++i3p1u9BvrmXbj
Ptb/H7f4u9B+G/1S5JH+OEm/V3vQz+yPdg/yZ/+c8GCeaPS3R86LfQnFD3nR
f1y3e2W/l/H8Ia+cJz6D/vcifvbfihf3MZ4CH/Rj/+3wYR4x/mYf+pV+j/ig
J/Nd9sFf1CPfDz/Sz+V+6EU/N2B9jXr6/dn+XPSjfvRf3gTiZX2en4B/vme/
TaBf6EdXhlnf+QnoTX/eEcD99MO2AOpFv74VQP+TnQH4mf49H0C9yZuCiI/8
RBD3k+uC0k82cn9Q+q2O988E0U+M5+YQ/M54S0KoJ/N5PSTjbWW+3SH0A/U4
FUK81MsWRr2o72NhzEvOh51h1Iv1OBqGH1mvqTDmHet5I4x5x3pviaD/Oe9e
jkB/+qMtgnrTP3pmP3k1s06/PTCJ8+SqSewnt0wiHnJ0MtuvV//Hm6OIl1wZ
zb6vMQo9yYEo9CdfjmbHd3cM9zP+shjmLdffiUFP9pM7hvqz/y7F4Ef2a24c
6+znZ+I4H+N8i+P+iOKROPo9xHkXhz8mFN+awPzwcf4l4C+34j0JvF9dnIcJ
9OeY4rMJ+IfrGzR8/4wrvkfDPOF9WzW87zyKX9DwfvVyfmqoJ+M5qMGPfs5T
rOcHFPs09FeQ81VD/Mz3Fw3fT2HOWw16TCq+M4nnRTl/k6gf9dyehL85T6uT
uJ/6709iHrA+7Thfz3k6lsT33Pq8TmJ+8nvoYhLfS+vzO5ld39t1vN/W57kO
PeOKn9YxDxmvXYffmU+9Dv8y30M65iH9MaTje4f6aDr8QD6nw+/UcwXnc8m3
GPAT9S8wkD+51IB+5B0G+otca2AekZsN+J3cZ0A/csSAHnz+mcx58rIBf5I3
mqgP88k3oQf5cRPxk8tN1IO824SfqVeDCX9wvcvE9w/Zb2Ke05/TmfP086KJ
ecr++NdEvUb5/krB707Fj6Yw/wf5Pkvhvn7Fr6bQnz18v6Xghy6L/wPITLpp

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYxy/D/iBXq7FFbRFN1sxZo9iMf2ifzEU6t5A/zLZbW2QO6w/I
jUbKSpksYiVYaIFk/FJ+iMcddxx3Bwffu/seUB0uJ0kaJlgSBZIRGFFp93mz
580ONtDXPt/7PM/zfp7n/b1Hc/Ky31hlsVguR3/1vzE/M088t/SfLepxa/mm
ZX5FvTi+r5Js5ChPUsnU8vkeNRSJbLtDWOWptLQ0J9nYqzLiR9auEh4rwH1k
y7uqMT8j/k7h5CIV/XuArN5XtszxRXLqQRU/0pAfx/uL1f4EWyY565B6OyP+
5eV4JeqRkqntzDf/AzW+L+HJW9cl/ofKWh6c/0e4okxFsflv4eSPcP9fwvaP
9f0jc8KqHPfPCudW6PwtfwinHlHZnqTVPF84outP+FPY+AT58L7ST6HnvHBW
pc6v4KZw4lHkx3zGjqpoeuMLws3HoPeicP5nanf0h/Wlf67j2f5l/VXQ+z/h
wSrky/OKanye9+08jv4yXnKN7scN5jdZg/jM3/4F6mG9hSfQP+qjvsQ8/C4c
V6uicnquU89aHX9iSjhSi/t/o7510GdSuLIOz09Q7zo9X2XXhK31Wq/Xfqb+
9aj/J+GUBtRzlf1oQL3k6QY9DwPkrEY1vd2TxM+7GvE8OfEk8mO8opMqNL/O
ynzGlpj5bj6F539hP0+p6qqqKta3pgnxf2V/m7Af1GO4ScdPm2a/m9E/6lnT
DL1n2P8W5Ev9d7VA/xuchxY8z35taMW8cp4rWnE/ea4V+0zeeRrzxM/3nNb+
8RbjJbdhHpjfoTbkz35Ptun9Osf6t52J1csOHqXeCTb0k3oX2nQ96Xx+1IZ9
p76qHftAPRvbkR/jx9kxb8xvox3xqF+uHf2hXtX2WD+I2KEH9/uWXftrkPuR
6kC+3OccB/Kl/1Q6MI/cv36HzqeB+7nggB70s/Ud8Bf6nbUD80I/PtyB+ac/
Gh24jzyL83FyilPX9yD9d4cTfkgudaJ/ZJ9T3VxnLSdPO3E/OckFvclZK7jY
Ffu8y4X9JU+40B9yYqeKhs8gb+3UelrIRZ2YZ9Zjw/N+6jHWifm/Lfrd78Y5
/XCzG35C/3zHjf6wH81u5E8/vORGP9jPNV3Ij/74bBfO2f98nPs5H/Vd6A95
uAvxyHd5oD853aP3q4T8pgf5kmvAuxnv7Aq2eNFfPv+0F3pxfnd5EY/7e8yr
/TzC/R304vsC92HRi/cT/WeDD/3gPr3qw/uA+1bhQ3+5j0Ef4tMf53yx+/1Y
N/ZhnP7SDf+7IlzWjf2+TL/phh4/CM90I/+L9J8ezNuIcHYP/Pc7+lEP9D8v
7O5B/G/pT0ufPyv8kB96RehXfuzH18Lv+aEP2e5HfuSrfrxPvqGf9cJPyC/0
aj0PkAt7MX/k1l7URx7txfc18j196AfzU33wJ/LeFdy44vkLfbH3xRmx8R42
oAd5o4H6yS8ZeH+Qcw34Des/aGAeyNW4by3ZaWBfv6K/gtPI1wzoO0i/NbQf
3Ut+IIB8Bui/Afhxv/CWAN5X5BycbwoL7w9gPkz6c0D360RI+EwA88rz/qXP
874rAfSL8RcC2D/mf18wtv71Qcw39Xo+CP8b4veZIPTj/BUE8f2X83k4iPfn
OeGmIPaP82wE8X4YFr4IzrwgPBuEPtyPu0M45/6kgAcuCWeEcP+o8I4Q4nMf
80LIj/taGoJ+PwrXLZ1zX30h9ON74fMh+APznQ7Bz1jfahP9ph5JJp6nns+Y
8Ffqn2Vi3tmvPSbmyxAuNnG/X/i4iXx9wi4T9XuFh0zMK3nCRD0e4dsm9OkS
TgwjX7fwU2Hc7xLeGkb9TuHXw9DfIVwUxjy0R/l//+6jZg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYxy8DKyRNu5IsiRZr5KxRbMY/tE/lMp1byB9G261NMob1B+RG
I2WlDBaxEiyyDsn4KT+E8+AOuDsO+N73DuMPbGuSZlGBTUaBZARGVNh93ux5
s8vNsRffz4/neT/v5/nwUFZuxmurLBbLD+H/+qf8e9RWbq6beeyZZdqpDlsd
X67wy6rKbreTjSx1qT4vbeX7AZWSkuJaK6xylWPH+OKdXH9Q3UiyrSOP5eP7
Gu5/W5VM7fHECCcUqgfDv7iD572rdHy3CScfVS+MH7Ku5vlFKjs7eyJKOL1Y
vZkW81I07yvR8faR895T03s88dxveV/FhBeQK8oQDznhA+WJL5kiOz9UDXlp
MYxHlSM/ck6F0j9W4j2uzg8PD3P/wnGd/6GV+D9SGZ74aHLpx/q+NxhveiX0
ZX5xn2h9vr6V+S3zKuHmEyosj+MW5vsp8rMIp34G/W5ek/zt0GNJeMiugvNJ
Nn6vqIIe3J95Evt5X0K1Cpcnn/FMVmv9LzFe5+e6fs8yv4JTqtycb17R7wvt
r/tY76garW8Z/ZBTE+mX4RroQz8l1ypreAH9V1kL/9xFvWvh5/XCtjr4927q
Xwe9rMKJ9dDjXtajHvFsFJ6u13pej2N9GvT5OzYJuxu0H8rvZ70acf4DwoWN
OG8z69cIvcjbT8M/5ObTyI/nxzZpP6Tw/rwm/X3fPcIjTdpPJRtY72YVPr6e
/VrdDL/E0v8t8DP13t+C81ifoRbth1HWc2ur1ucU61/Riv6kP+Za4Tf6J/MM
/Et/+c+gfuSENvQrubhN98tu8mSb1u9x8u526EN2tkO/f4WtDviVXOCA/uRR
B+Ihq7PwB7nhLOpLjnJq/R7mfduc0Iec44SfyVVO+JU87IQfqcfS8npycgf6
n/pldeB8cmUH5hf5XAf6hf290AG9yVs6UQ+yrTOyX491Yv6wX41O6Mt5M9uJ
erNfE13w6+3Ce13wH/1S6sJ8Y3/6XJgf7M9pF+Jhf8a7sZ5+THfD3+QiN/zF
9W436ke/Trh1/Y/w/rgu9B/j29WFecz4C7uQD/N1dOn3Ipt6jHVBf/KGbq1X
JfXbDraS3+qGHqxHczfeB9bzu27MO3JsD9bTD0/3RPotrwd++0e4DutjyCM9
uP9v4dUe5LconOqB3xaEX/cg3z+Fqz3w2w3hrzxaPwvZ4o38/qQX/uP+/V74
n+ef8CJf8pAX/vxLeNGL+cf4tvpwHuN/xQf/ML8KH/KlHqYP8ZPnfKg/9Xuk
N1K/zF7ME55X1ov+4H3+Xsw7xjfTi/oy/gR/ZL4Zfj0/UqlHsR/nzQt3+xHv
HOeTH3r+IbypD36a5bzqw/7fhd/pw/nXOb/6cP9vwlew3j7DedYPPa4JP9+P
fiUX9MNf08Kt/fo9np/ivOvHfCCvHcD3Xzn/BrCffHBA+yGJ3DAA/X4RvjiA
+pKjDMw38mYD+8nbDOhBftGA3yc5Pw34iXz0f9+rDOjL/S4D7zN52EC/ka8a
+HuEvGRg3pM3BnAe80sOIH7yzgD8Rs4KoH7U73AAepErA8iP+rcHIutxbnk/
6/XT8vnkhQDeO9Z7vYn6kLeYeL/pj+dMzFf6x2ZCD/or38Tfw+RjJvKnH5tM
xEe/Gib8Rz9fNvF+cv2sifrzvjVB9BvjSwxqPY9Qj7Qg4mP99gYxP64K5wYR
37hwKdaPjgnX4nv2FWFfEO/7z8IXgph//D4dxPzn/ugQ8vtROD6E/aPCT4Uw
f74XTg9B38vCB5a/fytcFML7dFH4ZAjz7hthdwjv2Yjw+RDqTZ4I4T27IHwT
5+0jxw1CL/ITg+gv8q5B9Af51UH4m+cXDqL+Op7/AHlpgqQ=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdl39M1HUYxy8DKyRNuxItEZMVEhJqIf/QPv1YpGML+cNsu7VJxrT+4HKj
kbJCBotYCRZaIBo/5YdyHtxxHMcB3/uB+cfZ1mqxmi2sSRTIzMSIGnafNz3v
G7EJe+37ve/ned7v9/N8zw15BbmvLzGZTD+E/+m/8pMZM7oxZXrzMwu0Q03t
cp+O8CsqZrT5+uPCRp5aXz65i2w6oEabrYPJwqpAbQv/kI2Dmh2bhMcK1SZL
1bNk0zvqrXABScIJxSr8u4Ss3lNXDplTyWlHlDu+fPIxPr9UX7eRc8pUbvgG
8li5Mtuy9pKt76tLoVA22fQB6iFXVy7mhA8X32//aPHzVNXi8/ZXo19y2jGV
n58/Tp49pqr8M0nsx/hY62slV3yiDpttX5BzapT2h3rFHVe3kixVET2Pa71M
1Lv9hLJU+QvJ1k+VLevKHDnjM9Qb8a9W1dXWrqHfF2tRP7m6Tvvz8mbhPSdx
Xir1qcf95Il67c+bT1CvU/AvTbjotK5vhqw+13r7twhHNeh6ardSzwbos004
1ID8PUl9G1UYM54SrmmEXunUu1G9GC5gu7ClSbVYM2MyqH8T7icnNkNfPq+i
WZ/3FeuZakb/rD+nBf1RH2cL9KLeca36/hL6X9wKvRLpX6v2I/oR4efP4Pp6
+nkGeVgnHNum+3U/RH/btL+H1gh/04Z8rabf7Zgvs3B9u+6/chX970C99wnv
64Cey5mHDj3fmbHCKZ06z/kxzEcn5v9u4ZudmJe7mJezep/ELxX2ntX9ZEUz
P+dQX5Rw2f944hzmkfdnd0EvPs/ehXyTzTbkmfUU2VDPPcKXbToPNaxfndfz
fGWZcMt59H8v82jH/dQj3Y59uIL5tCOPK4Xr7PCP+obsOk8rqP+8HfPxAPPb
DX8fFM7rhl5xzHM35pn+XujGvKxlvrvx/IeFk3tQD/Ni6YHf8cJHe5Af5svo
Qf8Jwjd6oOcGzoMD5zOfux24n5+vcCA/PM/jwL5jfVMOvE/YT7wT57PfHCf8
ph6lTvjF604n8s08jzuhP58X14t9xvN29kI/6lHcC71Yn60X+rP+sV7sB/a7
yoU8R+bRBf02Cr/tUoGZJAuvt7uQN37+exfO4/Nj+3A/9X+6D/qxPit4L+e5
qQ96ROa5D/lnv0vder7bqU+GG/uM+r3hRn/3c97dWs8Q8/klPp/EeTf1oz/m
e2s/3q+c9339yBPn40Q//OM8XezH/uS8zfVjXjiPKR7kk/P7qgfn3cn9sXB9
ibDfg/1v4j7xYL/evvYfPzqAPJD3DEAf3l85AD3u4L4ZwHyRpweQF56X4MV+
Yz25XvRPLvOiH+4jlxf7gf1MeOEXee0g9Gf/2YN435HfHUT93I/2hevknxY+
Tz3NQ3j/kF8Ywvcr6l80BD3JnUOoJ7LvhpBP7rvlw/Azsv+GUQ/54DDmldwy
jH1G/nYY80GOMpAH8joD+SSnG6iP/JKBvJP3G/CXfMTA/mD9dQb0JztwXgY5
ZMBf6nPVwP4gzxuYR+q72of8k9N8Kvy7hP7s8GFe6GeeD+8b8mEf9GceanzQ
k3np8qE/5uuCD+9L5u9HH/Yl8zrrQ/6Y55V+7KN54WS/3h+X/xF+Dtdr/ha2
+JH/OeFCP/bLrPBRP74//Snc5kfeZoQNP+q7KfydH/rx+o2Fev4QXhbAfF4X
TlzgaeHMAPyYEt4d0PqaJoULAvDvV+GKAPL+i3BjQO+T5qvCngD2/c/CXweQ
V16fCsAffj46iO9vE8LxQbwPfhPeHsT/F1hPThD1XBM+EET97Kc0CL/Y78kg
9sPvws4g6qE+l4LYP9RvPAh9bgnfxvmp9CduBPP0l/CWEehPf3eOwE/6/9oI
/GQ+ikegr87Tv7h5N/4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcxy8H1pBp2bWw1oWTDA0JvVL6cfaoJGK0kD+MtlubZA3rDy43
miErdbCIVYeFFkjGT0GE8+CO+8Vx973vHcUf2NZyuRotaMu5Sa45MaLC7nlf
z5udbupee57n+3w+n/f783ludXll6etLDAbDz/G/8n/15+G6q3s2XNuwLUFF
Iu1S5x855FfEYaPjG65r5WK62ujI5foBMbPHd/pxxaJSWOIfyOP+gyL+ed9G
xVNV4u34hk08/66Q/z6hOLNG7s9/kt97X8j4NivOOyqsdr2K69oxsWu6uonn
S2qF2Wx2mXlfnTz/He+zfYD8GI/hQ3neSG5sEOus9u2MP/Mj4SicrmZ+zo/F
pU7bKPMXdpwnVzTKfI6wXnnHkR957jjqxfpqnyI/cv1nwq7PZpNLmkRLc/Mq
csaJ5PWpE7KeL5N7T6L+ZNvnotRnSuX9+V8kx2doFjezrSsY/3gz9CI3tgif
qe4t5l92StbXvFifVtFls6Sxflda5f6rZOeXyXofOi0uTExMUB/xFfxF/VLa
sE59K9qgH/WfaMP3trC+7SI6mz2Zr7ipHeefYr3b4ZenFVs7oBdZ60B9uD+r
E/lwvb5T1r+Z6zOdsl52xlPSBf8xH3cX+oP1yeiW98+y3jXdqP9j1K9b3l+3
TnHBGeiZTT3PSD3XkNN74G+yrUf6oZfnL/agHuupd6+MJ5d+aO1FvIv6n0X+
1Hf/WcTH+MfBBuqX04d15tvYh/PU60Zfcn3KzqHe1Cd4Dv5nPTP7Ed8zimv7
4b9n6ad+6Y/CrYqLB+CH5+ivARFf3rdNsdEB/22n3xzo3wLFkw7ou5P+O496
FCruOo96F9GPTui5W/FmJ/xHrsB67i7FLU7U53n61Yl4Gc+CE/0s6N9BxG9R
XD4IPem/pkHMK/r968Hk+Tg3iPuoz/oh+J96WodwH/X+ZEi8Ef9Df2hDmGeP
Kr6e2P8I+8EFfdco3uuCH7LYHy4Z/zQ54II/eX7GhfmxVrHJjfO8r8QNfcjH
3Iif7Mb6PPnybZwxDD3Iu4dRD3LNcPJ9jmHZH1bGMzUs/dDAeFd60O/Mp8CD
+MnveOBnnu/1JNfvp8R+9mO6F/vZ71u92L84n73Qg/O2w4t5zP676E1+P5f6
ED/7L9+H/OiHN32Y/+y/Vh/6h/33rU/ed5n9Z/Bj/rD/Nvllf5rox/238Uk/
5hn7c9yPeUOe90M/ck4A/ie/GoBfyI0B6EnWA+g/3ncjgHzJa0egD7lsBP1O
bhjB+815ERxBP5Gv4fwqzo/MIPqfXBpM7s/aIM6TPUF8n/PmShD5kB8Yxfxj
vxePYv8Oxe+NIl+yE+s659OvifOcH8YQ5gPn1c4Q+p/z6lAI8XL+9IXgB86v
yRD0Ji8PJ88vEcb9Lyg+GIZ/ijkPw/Dni4p/CKMe5BQN/uH+hzT4bXFeapif
jPclDfkz3woNvydYr6Ma8qUeLYnv0x8uDfHRvxMa+ol+/02D39gfCxr8yX66
PwK9Fn+fRVAfzsOixDr7uTyC8+z/wxF8fzXncwT1MykeiCDfBzmvI/BrhuJf
IlKfI/dxfuO+fSsV36PLfCwrOM916JuueIeO/ruL813H76dUxVU63tclnPe6
fD9st37/n3uwv/AfxRr2m/5S/KMO/9xUfF2HPuRlUfTnn4qzoohvTrElwfze
3gTPK65MnP9bcX0U7yfjaY+iX/5VHIji99CC4u+j+D3HfGai6F+Dyjc1hnl5
B9+bGPRkPbbEMF9T+P7EcB/rdyCG92gp36MY3rM7FZ+K4T1m/d1YN6cpvhBD
fMv4XuH7OvW7FcPvj+V8v8Yw36j3xjH4526+Z2N4f+mP1xL77+X7NoZ8jXH+
DyYBMlw=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1MlWUYx8+a9oFcrcYWtkW2WDNnjmpDesFuX/ItSsBCrLO2yBrWB8jN
ZshKHSxzJVhkgWS8CiLggXOAw/EAz3nB/HBsa7lczRa2xdxgrjlpzA/Wuf/s
+bHj2ZT9dj/PfV/X//pf1/08Wlpe9O5dHo/nj+Q/+9f9Xa1MX7X6+pNr52mL
Se/bdHWBd5qZwuDJXJedUpN2ua3iWdZ3m4uJRP5zLptyk1zOg509piiYWcPz
k3vNE97aKPt5PjbJ425x3rIqUxudXQ6bT+16ZY7L2Qf1PuvOIbM5mQD7F1Qr
Ps6frDGP1Ez//LzLFZ+ZZ5K/PM7/XPmtcbnuiGmvyEszxPOFzl/rsu9Lu/8/
64iv1ryX/G1wuazOxGaXX3mJeI+ZD/PSdmxyee6Y4tlM/F9Jv60uH/7acuJl
8qk3+5MFecXljG8s//gq+Yk3FbjcdVz6FJLvt5bXbXc59zutv0b+DapXscsX
xKM70KPR1EwX5u50ueSE5eAb6NNkkv8feNPla022fl0l6PW98n3d5X0nVe8i
9PvB5KVdfoz4FzWn5lvWbJLh7kWfRLPqhZ7ZLVbfy+hf36L9qM9ci+J90WVv
q62Pl3o7raovnNVmknbqe4F6tJl/l3vvwz8zbfIb6wXtOg8/BdqlF/tldKi+
nF/VIb/gr8kO9Qf+2nBK+hF/1yn5Yb3LSzqtHrPkW9Fp9cjc6PKlTp2HPrld
yg+/NXUpvy3U/7SNZwp9d502jQ0NS/Pxw2lbv0LqsbLb6lGL/+q65cdtLt/s
tn7w4L+SM9KDeofPKH/8uKzH6lmPH6t7FB9+udZj+9WPP/N7pRf+9PWqH+H0
PukH7+tT/rx/pc/Wq43zzFnFQ3ztZ+VP8lnk0zwh/xyf+gV9ynzKn/VGn/Ti
/YRP8wB/3/alnpfdr/jRo7Rffif/+n7FQ/zn+7U//TXXL/+T74oBzS/YO6B5
x/tHB+QP9ncG1A/ocWPAJOX9gHiy/IqHeIv9tr4HqO9hv/xAfiG/9Cf/Gb/6
H79kBmz9FsMFgVR/HQqoX9E3EEjVeyogvzIfMwblF3jroOYDXHXHet+g9ocn
B+199zb+f2BI/UR/bBiyekzTTx8Nqd70W9eQ/Mm8/31I59GfS4Z1Hv27Zlj1
or8rhq2eHrh1WPkyDy4N23oeYV7cHVT+zJPcoPSD3w9qXjB/moK6f+Cfgpof
C/ffiPSCnx6RH+BdI7oveP/4/DrxXBjRfsR7a0Txku/KkPREn7dC0gv96kK6
n5hP0ZDiR/+bIcVPvR4/p+8T/FByTv2En46Ip/BfeH4dv14/p37Ez8vC2h//
F4VVX/qjOqz5RT8NhTU/6L9rYfUb9+FDo+of7sP8UeXvdfmTUd0frPtGVX/e
/2tU+bF/+pj05/yNYzqfft43Zt8/QLzdY/Iz+VwZ031KP987rnmwcP+O6/5C
nz3jipd+bp9fR89fx62/V6H3Ikf1o38fdqQ39clxNB+o3zZH+tJvZY70gw86
8hf1b3TUP/jD7ygeOOHY+6qB/vxbvBS+7Wge4bcHI9IDzo5o/uLPLRHpC5dG
lA+8PyI/wPUR1RPujWhe0//nI5of8J938Fwk9T6/P6rvDfZbEZXe8Pqo9IG9
er4W3htV/8BHo9KDfDuj8ifsROUv+Leovr/R70ZU9zN8T0zzG/2zYvIfnCf2
UL9iPV8Dl8eU38L3bkzzB26JyZ/4JRRL/R7+JZbqr5n58/Df4rj2gzPjqhd+
XR1PvY8K4tIDf++Op97/h+KKn344EZdf6ZeAnq+EL8bVv/BUPLXf/ovrewLO
mFD94KcmND/hrROp3wvvTMhvcJW43p73PxhhUVI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx28N+4NcrcYWtkW0XKNmDXMzVp09KokQJVAp1mV5IgOpOCkM
gfxBsIhVYF0WSMpPORHOwzsO7riD733vrvzjbGO5WI0WtuXYYK41bcw/qu/z
/u55M2RT9trzfT4/35/Pw8P2yqL9d1gslt+Mf/K3+tlg/FivP7HZpFxhoPc5
8m5hTZ55hKzZxT8ZttZneV4uxtOaFp5RLCpF00JhFs+1KmlvA+/PVeN82d9h
cTmRyN+kOL1e2qt4nvaOiu1Xa51CceZx8ZitVd9M+w1C/tqquKBRnm/Jpr8m
0eewtryg2PGJiN7MmN1G/58ivu2K21qQXy7j+UwY7m7mKfZ8Lu/b8hlfq6hL
cf/wkuKyNuS3g/GeEMZ1V4HipRNisXA8rYjxfyk62tvbX1Hc/JXMN+U15uNE
/jsVp36N82LmB3buVuw6Ke2teYP5fgP7NsVZ38L/HubfLvvb+5biS+0y3oy9
rEcH+k8uPiUeMhLk/fRO1I/25zuFEZ77TdbrO9yn/ZrTYqbXEeb34gz6w/iT
umCf+ZZ1IR/WJ9ElUtw5V5fr2436sh/ObtmvavZvqRt6YL9tPagf9aL1QD/U
19peUWQIkPprNpnni72yfqepv4I+5LNFsa8P8dF+ar/ML5n6q+9HvRjPXD/0
lKM4+6yM5xj16DqL/JjP6gHojXp0DGD+XlR8ZUDGu4p6zHKh3y8r7nTBP+tn
OSfjt1KfJeek/ZxC6sFk6nXdIOrJfrQNwt6rim8Mol/Ub/F5zA85dF7Oe4L9
TR/CvO1S3DgEf9T3/BDuk/OH8T314hmGv9cVp7gxD+QatzDacYs864a+OB/i
AuyR+y6gn+Qkj/x+mrzRg/jJZR7sS3KHB3ohJzyoL/lfD/TBeDJHhDF+DrJ9
BP1kfs4RxEv+HjzNeiyNrMz/8YuYd/qzgddwHr+4CP1yfjVw2tuK/zbPOe9r
vYiXvNNkznOzF/HSftAL/XG+F72Yf8aX5hMHrcm7GH+BD/WnHhp82M/Uk88H
fVFv13zoL/WZOor5on7zwC3Ue/0o8uc8uEdFaWnpNc7L3Cj6w/1xnx/7i5zt
xznvH/LjPtnlR73o71c/3i/O1+ox6JnxbRqT9p9k/I4xxMf56hnDfmK+V8Zk
fe5hPe4cR76cpyyTWb8DJnOeOk1mvX8cR3+oJ0tAyP/Zn6cCUo9/kUsC6Af1
dDKwcn9fCqAf7P8tfG+jvtYFkQ/1sieI++S2IPRN/elBzBf5RhD1ov4encC8
LL9HE9A7ueU2Dk3I+a8lX5/A+0xOD2Ge6K8ohL9HyI0h7F/G6w+h/8xvPoT6
kh8IY55Yj/ww9jXrdSS88v31hJEP7f8RRn3oP2US/bIr3jYJPe3jfpvE/PF8
cFLGV8r7s5PoH+O5e+q2/TeFv6eoj6op6J166sP309Tjz1PwR/0madA7+UEN
eqKeN+J8gbxDwz6nvTIN+qaej2uYd/rv0KAn6tmL71sZb0JD/NTzn6b/5X2r
IR/W//4I9jPrkRmB3tiP3AjmkfWzR1BP6qUuIvUzzno7I4i/RPGw+f1+7usI
4itV/HsE+7CM+9uMp1zxvTr0dYD7XIce31G8VYf/d7nfddirVFytoz4O7nsd
9ahSPKDj76P3uf9Nfx8o/kWX+33vIb4HutzXMx8qvisK/Rzm+xBF/WoVW8H5
9XwvzPOPFFea50f5fsDe9DHF3VG8Dw18T6LQ78eKf4qiXuTFKPrL71fFoDfa
S4uhHvT3dAz75Ajfnxj6w3jLY8ivju9RDP6Z76kY6lPD9ymG+rFel+G/oprv
VQx6Z73/iyF+9iM1Dr0dVLw+jv6yn3lx+HtP8b449in7Xx9H/SoM/h81zl1W

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVl9M21UYbczmAy4aTROZyRAjMbhMwyTZeMFc/8S5hUTGw8SkUddtFTaV
DmUywA0QHENHmXbTMpxAYRQGXaGllNKWX3+/svHQ+aKRaDAyEwnJyGKWzZA9
THtPc0/TLVnIyf3d757v+875vj5jrak49JDJZPoj9V/+Vf8sDv3uF7deeCWN
dgvjbqGlnfgdkTqvI9aswmazrbTxvFp4d91oIBY1IhWukFirlef3GH+5ToTy
2m9m3jsust7PbxI9LtfmTLyT4ENc1CKKi4v9mfitojRn8VnyK2+T73uIl9vF
8xbHq18qbD8lchbd/xCbTosbDWbvKYW7O5FPB/l8jfdPK+w7I9pv7i0hFg6x
6LZHGa+qG+cZvmcRv0Xh9bPI7yT5f4P3mhTu+FYcTSV0nPk45f0XP1M49xy+
/5T5nRONZu+1owp7zotBe2lODfP9TlxPJss+VLjke3neWc38XeBvU3jBhX4c
YD16wN+qcOUFWf/ig6xPr8w3dEjh1V70n/d9PyDeewrXXxRre0MX32f9fhRv
ph5g/A194Mf7VX1C/mH8ZJ/sn518i/qFOVWQDxR29ounU4SY33q/7L9+WGHL
AOrJemgD8n3nRwoXuPEe69fhlvH32xVec2fXu3wQ+X6icGBQVKQEzv7kDoFf
ncJNQ9AH+7k8JP4ttDjqFX79Er5n/z2XwLdR4U3D2XqxD6M/nyv8yzD6QVzi
kf1P8vtej9Sfi/FMI+DfoPDBEfAnn4URxDum8LZR5M/8ukdxXqvwnVHkw3pV
XkY/PlY4chn6ZP3zx3Cf/WobQ3/Zz9Ux6I39LxuX+snL6GtczpMj+xU2e+V8
slFf9V74n3jJC/4Z/V3BvOD9wSvwQ0aPPswLvrfDh36QT5UP/aAee3yIT/5J
H/gyv/vp76nHogk5X5aOKGydkO+XUo/OCfiF9bs6IdB26nsC/Hm+dRL1Y30t
k8if73VNYv5UUf+TiEf+tycxn5lvgT+73vv80A/93wG8mffDfvSf+a/50W/m
nxeQ7zWTT3kA84H5twbQP+YfCGAeMr+VgKzvLuafO4V9QD/umQIf+rFpCu9R
r94p7C/6cXkK9aEfnwjKfeLO+DGI/UU/HgtintI/niD6Q3/9HkR8+m/TNPTC
ef/yNPTaTP9O4z73w8A0/NpKP09Df9yPD4dQT+63khDmJ/fP4ZCs/2PcZ70h
1Jf4pxD0yf1mmsF+5z57aUb6f2Mn58EM+kF8fgZ8iRcewPce+H5bGPoifjeM
/Pledxh+Ix89jHqT750w/E/83Cz0zXwrZzE/WI/OWcwb7t/ILPiwnrdms+uf
H8H5CYUrIrjPfrZFMK85H4MR1Jf6WI3Av9TTU1HUg/ori0r9vk19noiivtwv
vij8S7/+FYW+6Q9zDPHppzdi4Mv5Ux+T9W2mH0dj8APPl2LYJ/Tno3PQD/0v
5jD/6c/auex5MTgH/vTnr3PYh+S7QQOmX7ekMf26Q8N95vuWlu3fKg3+YH1a
NNSX+6RHwzwi9mvY56xvUsP+pr//1lAf9uN+Oj7315Nx+Im4KI560f+74/AD
+2vFeTH935i+T+yMY/9SH+NxvM/5cDWO36fU059x9IN4PQ69cF48ruP3JvW4
Vcf85fx4Tcd8IbboeJ96rtPBn/OkS0e9qf9hHfOR80TTs+fLb/j+Gv1zW8/+
Pf2Igd9n9F+Bgffoz1ID/aef9xmoH/1eY0BvPO8wML94v98AH74XNtBv8vk5
HZ/nawb0QT4bE+DD+HkJIf9w/uxMYD99xf2TQH3PKFydQD27uI8S2MfdCl9I
QM8O7ifEb+b96wnsD8ZfSYA/8/8vgf4x39x56J38t8/jPea7Zx7x2b8D89gP
7HfTPOaT1MP/oaFzHA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm9MW1UYxhvD/ICLRkMiMxExEoPLNOiSyRfM8U+cW0hkfNhm0pjIZoVN
haFMBrgNBMdw489W2AoVgcIoDLr+A9pSyu1tmfvQmRiNRINRTCQkI4tZhiF8
mN7zkPM0l2QsD/eec973eX/ve+6zZZWlHz5ksVh+N/7J/9WPtUNf//rui69v
qX2iKHPxubR+T7xgvECtleF5K59XiNJQTst5pUWlsNlsK218v1quf+OC0n/W
iLUDof6LXH9KyPPblc5tEPVZnr2d3O+M6HU4HF1KFzQK47g7l7h/k9ht/NiV
LmkWnr3Ldd08rwXv83nVObFcl+Xhest5Ga+N53W2ieGqosx0PBeEEZ77G6W9
FxEf8xMdYtFVVcTn5Z3mfAu6xDMtdw4w340ucaIo8xD31y7J+I5zfetl6UcN
/S2xQ7cond0N3cT8uhH/GaXdPdi/gfleQTynlC68ivqdZP4OWb9tnyl9yyGM
9JYr6UevMMIPfaz04T7pT1sF/XGKxHq+1ab0qhN+fES/vpV6rlzp2n48P0b/
vsPz40pnDKCen9DPAdTrU6VTA5KfnCr6Oyj+zbd2nFDaPgiequn3IPz4XGnr
EParof9DkpdN+pHnQny1rIdLZBp/oH9rLvHOcp29jvUZBs/1SgeH8Zz+Z4+g
vl8q3TAied5xmvUbwXrqt64hfmr3NZnfY6zv9lHwzOdVoziP+udR+MP3C93I
/6zSTjf8amT9x9Df5OnoGM7/ijyMYT/yt2scPHEedI5LXj44p/T9cfhFfg9f
Rz9yPkSvg1/2T+4E+CH/zROy3/LZP6sTMv5F6uJJcTuVKmY/eSexP3WWR/Ja
SF3rwXlcv+QBXzxP3ADPjG/4BurBfDK8mG/Mf48X59Ofci/mBf3s9YJn1iPl
Rf3JwwMv6k9+Cnxynnz/hdJlPsRLPu0+yetL7M+bPsxX8r/hw/7kf6dfzpsf
yb/VDz/If7tf9r8rzb8ffPH8e374Sf7zAjiP/B8MYJ6R99YA8mV+kQDqx/zX
AuCTPOYEMW/oV0kQvJC/pqDkYYn+BoOYt/R/JYj+JX/ZU/CTvO2fMt9HDVPo
F/LmmUL86ftoCvONvDwxjf062I/Twvh9lvfDyWnMR95H7mnMi8tK/4b1Dt43
22dkfv/wPnptBvlcYf/OgLerSg9tve9gP89g/z6lHw4hPyf7O4T3qY+F0L98
3xlC/XqV/iEk+U1xf0sYPPD8V8K4Txjf0TD6v0fpnjB4ZX63wuh/5r8Zht/0
Z1cEfNK/9yPoZ95/nRFzv+oR9CP7834EPLOez8+i39LzZRb9TB7aZiVvWeQl
Oot516z03Vncf9S5UTNvpVHwRd0chT/U01HwQr0ahb/UT82Bf+5fPAd+qE/P
wR9q7xz8Zrx/bT2nzoqhH5nf2zHkx/lUG5P5B6jHY+Cb/izFwAP1o/PgM/29
Ng++2B/V8/CDenge8bMev2D9DvZPhobzqZ/WwDfruUdDvanf1TDvWf9yDf1E
3Yj3D7H/ejXwSh3AebvJU0rDfKH+W4N/1A808EUen4zDz/T3ZBzxU++Lm/u7
LC7zt/B7sT4O/6ntcfQH9WQc/lDfjGPeUf8RBy/cfyMOnqgf183x7dSRL/Wb
OvxkflYd85O6Bus36Ve7jvuEelQ3+63pqD/1rzr6j/W6p6PfWd9HEtifPOQl
kC91UQL3Ffk5mACP5K0yYf5+bk3ge4LrBxPm7+dIwszTT1v7Md61BOYP89uW
RL70IyeJfOjfq0l8z7MeJUnkx/lVkUS9qZuSyIfr+5LgkTqYNM+/2zh/nfNx
Zet8zs//kuCF8zZ7AfxxHr+8gO8Lzu/9C+CF8/3IAvjo5/22AB4HDP0/xsiH
CA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVll9MW2UYxhuDXqDRaEhEExEjMbhMgyOZ3NR86iJuIZFxMTFpTMRJ2LwA
l2CwI9oRiEiUFlfYCh2jtKzlXzmlpbSlLaenZe6iMzEuEg3GYSJZMrKYZRiy
i2m/pzlPPSQEfjnfeb/3fd5/54W2zpZPHjKZTL8XfuXf//3Yrtx55c3iv0eF
XdsLlPgD0d7evkNW28S2teJVP5+fMrLoFGcrgj/M8PwZyY0+nW92w/403/9C
lG96/57SubpXmMs3X7xMe1+JTW+X+ZLOdedgb4L2+8TA7eMNLp2b+8W4y/XM
Bd43IF622LUxnbu+FvLPRd7/DezzfceQKBzvHqc/38Jf3qd8J3aPxyZ5XthF
dq92i/Y7HOKfWssTTvo7Av9GdN4fEbGqgU+H6f/38rzdrvPgeelPysF4nNCH
71eOQu/zjG9UPu/ifYExvD/KeC8IX5e5nHo0XBQF+T4qxe/CecZzzQX9GK9j
XOplc+vcOoF6YD6q3eL5QoDM1y039GY+lUuIn/numZT+B73U7zLyzXopm5Ls
Zb11TEm9qwI658GTs9TXg/fndXZ6kK8F6u2BXkGdLdOivr4+vET9p8X1fD6v
6FzjRTx8PuhFPIs673ql/Vrab/Yhf3M6R3yoL/pXOSOCjdtW9kfvDPLB+G7O
wB/2x5EroqVQINQnUGTq95gf5z3Mrx/6kG/4jfo3BKAX2R2A/mTTLPJJPjmL
fqC9a7M4Tz44h/voj2MO8ZHvzeE8uXXe6H9yHvVMe9UL6B/e37+Aei7V04LM
x0+st6ZFGX8961FZlPUVY79WBJEP1nNPEPZZ71tBWd8usliCnmTfEvqX75cp
4t1tq5N8WEE98b4OBf6RxxWZfxv7J68Y/X2gQG9yXQj2GV9bCPpPsp5Dsl+3
yVdD0JP67IeQD+p3YNmYX8uyMZ/D4BRZXTb2591lY/5qwtK/CtbjiTDyQx4M
Y96TE8XzrOfdMPqJXBWB/+TmCO4j90XQj+RIBPkj70SgB7lyxfj82Ar8Ifeu
YJ6QgyuY76V9tIL4yU9F5Xy+zXiORJEf8udR5L/Un1HUH/X6LYp8l/p1Ff1H
vd9YlfVhKvXvqoy3ifmaXkX9Mr83VpEv5v+RGOJnvTTEEC/5dAzzhe+78byR
9n+MoV95vyluzPehOPxlfCfjeJ/Px+KIrzQf4lJ/C+3fjyN/vP9gQsZrI3+Y
gP5kRwL3kTU83yPfS2Bf0v5La0b9Wtcw78lDa9hvpXmzhv5gPHfWjPmtTiJ/
zH9LUuo3xH3Un0R8nNfRpPF751YS/nA/PZtC/OSmFOYN98GXKfjHfaGkjPvr
zxTmA7kiDX24b95Jo5+4j3rSuJ/7bS4NPchbaeSP++zxddQPWayjn7n/zqzL
+rhP9oGtIZ1/WUd+yGUq4lnW+TkV9Ug+rCK+sM7vqcg/uUNFfZPPqbifPK5i
30Z0DqvoF3JeRX2Q/yraJz+APSv56QziJddlxGfm8vfJRzOob3JbBvqSz2aw
X+mfM2OMZzGD7yfyVdgLU48/MpjH5P0M6o96PqlBL/IBTd5vYz7e1rBvmD+L
hn1F7takf28x/8OarKd21otfgx6sJ7Von/X2a/E56/Ouhvyyfh/Nwn/Wd00W
84b9YM4av/9PZGGP/dWZNfbjYNb4PeMp2me/J7LG+fdzFv3HebebxXzmvn04
h+8L7uuqHPTgfn89h/7m93pzDv7y+/lU8X1yXw755PkJnG/k93Qkh/ho/3oO
85T37+Qwb/h98G8O9cz9X7mB/DCe1zbwPuM9tmGchx9vIB7q1buB+OW8+w+V
X5xX
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1InWUYxw/h+mDRKIS2IDMaYbGGFSy/GHcvtBZCzg9lcAhyK9z2wdPA
MDdqG0omla7cSmdOPcd3PR7P+/t5znPOSYvjaMyylmNuMZG0NYbW2Ifquf8P
91+eA3r48Tz3fb39r+s6j9bWV797l81mu2z8yW/1ce+52jR+46kXTNoruru6
usbIb4FHFWu1onDB6Rjh84PC+Hd8WLGoF0XGhWTtiJjL5yv5/lKDOFrkntk8
/6HkPby/5Jh4pGX1All8LN4zPvSn7ISoDhdvob/aSfGs8SFXNcv3lzfttQiX
o6JtSLHjE/Hq1aYiF+1/Kv4utbf3K+5oE4b7d3rpz2fSn309ij2fi/crChfI
ol3Gb+P7dR3CePzYOfp7CvH1Kb59SubnHdrTvhT2dr1hQHHrVzK+Fifj6YR/
9HfbafAg4zttjW/kjLUejq+Fcd1h5qP8G8TD/Nq6hJGOXczvbJc1vx3dqAe5
5iz0MMH89OC+ScUrPTjvZr6+lfe7yY290MMU83cOeiEX9KHeHuYTvEzO98n8
vznN/PYLQ44Jcme/9G+7l/nuR/xk+wD8JWsD8Ifndzgl5/m81Sna9Y1Sn+I1
pzCOl5OrXNJ+Bdnvgh7J2wbhD/nYoKz3Bu9fGkQ/kF8eQj3JI0PiCXv7i+R7
h2U8q/TXMYz3yfPD0B+5fAT5Z/56wLvItlEZ3wjzf2AU/pJnR6FH1m/nGOrB
eneMQd/k9TFp30l91IxLPdrI8XHUj3oqmZD58lF/zRMynkLyygTqR71WTqI+
1LNnEvUgF7kRL/Xf6Eb9yIvmc/aLmEJ+ya4pxMf+KvBA7+TdHpHZKLWT6zyo
N7kb728n5z2YN+R/PagPuWwa+SPXTsv500TuxPMZ8nfTOE9/b0/L+zvJT3ph
n/HavdZ8fOGF/pkvzYt+ZX5veWGPvMMn1vaFe1mPN3zCsi9afehX1jfqw3yj
HtZMpn6K/dgf1FeVH/qiHk/6oR/q1++39uOyH/N5s78CyH9A8WsB6CXIfgsg
/pBidwD9F2b/BVD/qOIHgpivMfZjEPM+rviDIOqZZH8GMR/Jl4K4L8F+DWG+
8f7nQ/CP9h0hIb/o70AI+WZ88yHrfLo7jHoxf+Vh+Mf8HwpjHrJePSaz3ufD
8Id6sUXQH9TXMxHcx/1zIIJ8c/+ciUBfPD8bwTyhvu5ErP24M4r5SD29HcVz
+tcRhX3qSY/K/G9lPOtRzDvy4zHEQ33VxGT+jlNfbTHcz/zEY+hn8o2YVW8l
cdST+a2Oo9/JzeZz6i8Yhz3ySlzOg0XyQwnr/K9MoF/IHyWkf2GyJyH74Sb5
WkLWv9jPeZaEnsivJNFv5MYk4iGPJaEf8mIS9sj3paBXskjBPvlICvlnP7lS
1v76OYX5Ry7Q0C/khzXMD/JuDXqlvl/XMH/IdRr2D/mEhvnPfu3W8PuI7NPg
LzlvPmc/XTftRThvNcwT8oNp2Gc/lqXxPvt9bxrzhlybhh7Y/0fTsMf+7kwj
H+z/SZyvTHFem6wpvmLaT3N+p1FPXfH9OvSV4TzX4X9W8Us6/Mtxvuvwf0Zx
g45+m+W8x/OW7xUPm+d/4PzXobe84l91xDfHfaBDL+cV35NBf/3I/ZCB3i4o
rsigfhe5LzKIZ15xfQbz9yfujwz2wYLi/gz6/RfuE/P5JcUXzfO/cb+Y919W
vCUL+1e4b7Ko35Li57KYV9e4f7Kyv/TfFR/M4vfJde6jLPS2rPhsFnpf4X4y
7/tD8VwW+V3lvspi3v+p+D+c3/oX91cOv39uKn46B/u3uM9yMj7buuL9Oehh
g/stB339Y/D/Ezyh4Q==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1MW1UYxxuz+QEXFw2JaCJiXAwuc0FNlC+Y41ycW0gEPmwzaUzGJmH6
gboEg4yoIyMi0dEpm5bh5HW8l7KWtvT19t6WocJ0bg43mYIviII4cUxE3ez5
35w/KcnS/HbuOed5nv//ee69v7is6MVbLBbLleQ/+av+HrLWb4ksPPyUSdtF
unPbnjD5eWEsZVtDirVi8VjyL8j1/aKkpGRmWLEoE85t05V+Pn9A+DNr5ryK
p8rFRJstb4j7XxNpyf9wK86qEu22vLpBnveGKEoeMKA455C8r6Sf51eLen2p
q1dxwWHxSl7arj7eVyP3r+Xztrfk/WGy5W1hrdfLnYrtdaJmrjCX92W9I/NZ
IbvexX4X46tHfIy31C7Gx8byTzPeo+J6tnU981s+KuObIGvviUaHw+FRXPs+
4md9Chqwn/XLOCaSeumr9Twm6/uyT3HXcVm/NNbf9oGYL/SfJOd+KDmTelkc
4tnpygbyqEPWY4lsb4ReAcW7T+A+clYT9CbPNkFPsusjGe8WcsVJuX511S8f
Yz95TbP02yTjLW2W9bmbPNYspivTNzPfnBaRLOcDrEdDC/RiPZdbpF/drLe1
Ve53Uh+tVfp9mryhDfXj87Vt0IPnzbfB76v6tCNfxuNpF/KH+WR0SP3qmX9V
B/JhP011wL/st62n0F9R6nlK+tGvKV7XKZ/P1qlvJ/rVUHyhE34i53Yh3pji
pi7Um+dbutGfjGdfN/qL8Y52Qy/mt6kH5zN/ew/OY72u9SAf9sPuXnEwGSD7
JdSLflvtrz74i3y4L7XfZ/uQL/fn90Mfnu/qRz2pX7oTfmM8FU6cR/0mneK+
mrlzjF8MpPqpfQD9QL+tccFP1PNxF/zP+Vfqgn9Yv0YX5iXn6ZgL/c5633DJ
+wupR84g4qGexeDCOP08iP0JxSPgXWfob3N9VPHG07j/U/odPPmZ4iPm+jj9
b66fVbxorn/BfnBj/ZzinW7cf5794Ub8FxQH3Jh/F9kvbsyrCcWZHszXS+wf
D/xyWXG1B3pOsp/M579RPONBv33N/hpCP3+leMcQ/Pwl+w3rm5mPcwh+Zf5T
Q9KfZ1ivO72Yj6znVi/8w/q/6hXyh/3V5YUfqedlL/xBXudDftT3SR/eR9TX
5sPzPL/VBz1H2M8++Jnx3OrHPPiE/e1Hf1Dfl/yY92Psdz/qSX3P+uHvz9n/
w3i/UN9Hh/H+Zf32gdOo73FznfUeNdep74q5Tn02BbBOfV8IYB5STzt4/RXF
egDxfct5EkD8U4ofDGL+THO+BKHXD4rrgvJ90PYj500Q9ZlRvBCEX37m/AnB
H78oLgpB3185j0KYh2RvCPqQZ0Po1znF94SxTs4PY/+84tfDOP83zq8w4iV/
H0b/LHCeRfD874qfieD7g1yB9TevKu6JYP8fnHcR1GdR8e1RzDOyiKK//1R8
IIp+uMZ5GIXflhRfjKJ+1zkfNfj7L8X3mrzMeanh/fu34uc0xL/C+alhfvyj
+JCG/v2X81RDv9xQ7Mb52Tc5X7Few/WfNPjrP85bDX7ieXfFUG/elxNDfIxn
ewzxMN7iGL6HmM/BGO4nN8SgL/Pvj6XWZySG+Mnfmc+znssx+IX1vkPHfCVv
1PF+oT5P65hfZKsOfcnlOuKnvkd05E/uxHl7yJqO+Uq+pON7iryI/enk24xU
3mCk+ivPSD1vp4H3CbnMwHwg1xp4P5BbDNSL+QQM9Bf5vAF/kedxXhrrtTaO
7wtyZhx+Ij8RT61/gblO3h9HfalXdRzzifqeiENfsieO+OiHcexfIc/EES/9
dDOO+tNvGQnUj358JAG9yTsS8Cv9uzeB9x/9XZXA95P0//+fdcfZ
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln1MlWUYxk8m1pBp2Vl+NE84mCHDIl3GKuzJXKZzC/jDbGNtkjGsPyA3
GyGrZLKIlWChBZLxKR/C8cA5wOH7PR8o1cEyTabDFEuiIDQDIyvsPNfZfbkj
G5z9eN7nfu7nuq/7fs+ylPSk12eZTKYL/l/9KT8rkgvW/TSx8rkAbVTJBe6p
2/yKyh1LdP4sbKSoG1HJBVe4vkNZNwxnjQirdL1/1y98fqfy/31/VPjSLvXi
cFbRr9z/jhqszOj+TTg8WzktuWNjjPee8qcT9btw7B4V6t8wwfg52H9VOGGv
zm/+HzwvV8d787pwxgfKf1/3nzz/Qx3v2qRwYb5K8m+YYj4f4Xmy7WN9H9MN
5legz48npxWqqoz4fHLsfmX2C0Se3q/jrfuL+X+ihrPMVnLepyo+dDBimvcp
0lxJXnRArfb//M37HVC7zdYT5NqDet3O5zM+03qbGT/uc9SD9zEV6/rdpB79
xbg/9SosQT7Uc+sh9Zb/H9Q7vBT5sR6jpfAH62X7QpUUFxePC2ceRr636/ul
Xl9Mnl2G/fRDWhnqT/aVqdTU1BH6J7Yc8chF5agXebpcPZw7doqcXIH8yUaF
Xk8kR1bi/vRvXiX8SP+PV0KPy6xPlT5/w0VhR5XOL3WI9apGvHPC2dXQ6yzr
V438TwuvPwI/fsd6HsH9TwqH1cD/37C+Nahfv/CZGvjvBOtdi/pzvbRW+3Hb
V6x/HfT4Wnh7HdZ99EMd8hkQjqnHfb6lP+pRv1PCk/Xw8/f0y1Hoc0a46yj6
4Qf6pwHzY1B4bwPypV6jDfr+teeFNzeif6ivrVF5pqKGLgibrZg/rEemFfNg
WHjIinisnzqGeKxv1THE43ybbQueZ2tsiEe/pNkQj/4ssWEe0O8+G/RlP8zY
MI/YP7FNWs8Q9ldKE/qF/VfUpPV8lPPpeFPwPJpu0vFfZn9HN8Ov7P/kZuh7
U3hfM/IjG83wK/dfb8Z85nmRdsxX5rfFjvjs9zw76sX7dtihJ/UZt8OvfD9Y
HGo80XmY75cEhxrw+XyXhHMcSn/8yH5ywG+s74gD53N9UQv6l/s3tcB/rHd2
i+6HUJ5nbYG/We9LgedZ7wWt6Cfmu74VevH99XYr/MD71bYG1/98K+YN51lY
G/qH+qxtQ72pX0Yb/EQ/VLRhPpDPtEF/Pj/HiflHP8U5tZ4W8htO+IvnlTrh
F+Zz0gk/kU3tOI/5r2oPnrfb23E+73uwHX4h97ej/8k329E/1CumA/qQX+3A
fCIXdkBPsrsD+ZMn71hf3hm8f2tncPz8TvQbuaszuF8nOoPnfXgX7k9O6sL7
k/ff26W//8RRz1awk3qPBtZZryXdWL/GedUN/7Cf3w2s831rA8exny8H1vl9
wdyD9z37+YUe6EvO7IE+fP/X98AP7O+hHuhBnteL/v6H868X/fCv8M5enPcf
52Ev+mdG+CyeHybPNqDXLeGlBvrddFXmpYH9dwm/ZMA/5DQD55P3GEp/kEsM
1Ivx7Abuy/N8d6xfMTDvuH/GQH/PEl7oQv53C8e64N8Q4Y0uzNM5wiku6HWP
8G6sD94rXOSC3qHCjS74d67wcRf6J0z4ogt6zBOeRj7b5gvf70b97xOOdmO+
LhB+3g19HxBOdmPemIV3YX/cg8L73Ji3C4Vr3Jg/i4WNQLwlwufc8NdDwtfd
ej5vXio814N5YhGO9MAv4cLxHvTjMuEtHnxfihBO9yCfSOE8D/RfLlwOLn5E
uCOwvkL4dGA9Wngc8SwxwiFe9PNKYYsX8+wx4Se98GuscIIXeq0S3uHF97HV
wjle+OsJ4UNe+GeNsMML/eKEB7xKfzwlPOKFf54WvoX8IuKFF/Wh3muFH++D
v54V3tSHeFx/rQ/3fUY4uw/zXJ/3P6HQqTI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcxy8DKzRNY/ljiZRUZGoohVTDHtEyHVvAH0nbrS0yhvUHlxvN
lJU6WMRKsNAEifgpP4Tz4I7jDu7gez8o/jjbWi5XswVtOTYJjcCICrvnTZ83
OzZ2e+255/N8fr4/91BuQfabi0wm00/hf/0pf+NZrtq/JzbvnKe96p20mCuz
5FdV+DyObOSqmCuNlr94flCtL7n+7YywKlCPm8vTycYhFf6690/hkUJ1KRTK
IJveU3l5edduCccXqVuJ5nKy+gD2yEnHVZMlLYZsnFCB6cSr08KZxfr7fvJI
iSq5nuUiWz6MPDd9FGmvokzpD/oX/7G2b2Y8tk+0/yHGr8rV0VjrHuYvv0Lz
1//Q31OId0545hTye5v+f6rjXX7Hjf+59DMVNvc6zzMr1eiRWOu/wqtPwz/a
Hzmt7e1nfVrP6HzmkS2fwz79Sz2LeizUu0pZ94weob3hKp2vVL5XUa2yXXHR
9D/nHPwnx9fAP/o7VoP6mSQe2xcqnO5Cxne4Fv4tElZfqpfCBu4UjqpTYfMb
eD+/TiWH/+hPqA75ZnxJ9agP61VZj3immO96Fa526+/C5gbk7wbz36C/Pzsu
nNAIe+TSRt3/teTxRm0v8TfWpwn9R3Y0af8bJ1ivZv3eMb5X1KxccSVv32T9
mpEP+rf7PM4nWc/ziOcP4aUtOl+VjM/SovNjZz9fbkF92M+prYiX/VvTinwu
zG9bZL8caFMRejDchvjYH5vaVXVV1RrWv6Id+WL9p9pxn/XLuYD5Zv09F5A/
1ju+A3oSJVzcgXmNFh7rgP93CWd0ov53s7860W/3CMdaEX8M+80Kf5cKX7XC
33vZfxfh7zLhpot6/kaXsx9tuL9COMWGeVvJ/rRp/Si7X7jahvmKFQ7ZEC/P
52yo533CSV3QI/qT24V5WyJcifN0xvtVF+4zPzNdmD/O08Zu+M96mLsx/5yf
k/PMehrdiJ/nk93a3hbeT7AjHtbzFTv0jO+V2tEfrGefHf1E/8btur43FwvH
OeA/48l0YH+wviccWi+med/hQP7YH9cckfqxugf9T//29UDP6X9RD/qL8Vl7
0I/s75GeyP5f6YQecF52O3X9q6gv7zrRf5yvVifqxfn70Yl4Fua1F/XhPO/o
hT3Ou2WeqQcNvfCffLkX/pAXu9DfvJ/qgr7R/lsuxMP3a1zQV+rFNy74Qza5
oQf0f5sb+kU+4Fb6g/GecaP+5GG3jr+EPOuGP+RNfegf8mt92I8L+7YP/U/2
96Ge5Kk+5If8aL/25xg5px/xksv6I+vj6Uc/kyf6Mc8Lvzc8mAdytify90Cx
B/kjOz3YT+QxT+R7a73Yd+QML/SM/L4X/cJ+snnhP/kXL/qHHDugOYv9+OIA
6kf9PjyA+WA/tw9gnjnfVwfgP/V62SD0ivOhBlFf6vOhQcwL56tpMHK+vx9E
/TmfUQbi43yvM/B7kfOdYqA/qM8vG/CXnG/gffJxA/bJ1Qb0g2w3IvU9ZEDv
qJe/Gqgf9XTOgH5S31f54A/1PckHe9TjvT7MA/U914d9S/0+6sM8Ut8rfdjX
Dwh3+pCvVdRr2N+/RvhnH+q7lvoNznpQeIUf5+uo537cXy+8y49444XNfrz/
sHChH/5tED7px358RLjFj/o8Jmz4MW+Jwj/4kf+NwpN+6OUTwksCqNdm4YQA
5meLcFoA9p/kvghg/pKECwJaD9K2cn8E8N424foA9nMy90kA8T0l/F0A++Np
7he8X54iHB1E/2/nvgkivlTh7UHozzPcP0Hk81nhg0Hk7znuoyDmJ034HOwl
7+B+CqJ+zwtfCmL+FfdVEPq1U/h2EHqXzv01BL3l+dYh5IP39w0h/zx/Ywjx
7xIuGoJ/L4T5PySEhQ8=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVnFM1GUYvgysTtI0SrQ8McmQtEiXstbVp5KoYwv4o2y7tUXFsP7gcqOR
skIHi1gJFlqHRMIdciKcd9x13MEd/O53h/nH2dZysRotaMu5wao1acw/rPue
377ndmzAnn2/73vf73mf532/TdV1VW8vM5lMv6Z+5X/1857VPL3ir+17DHRQ
tOuLhfcTvyY8ZXPHViqsVYuNLfM/rOL6EZHavnm1wqJO2Nr1+jX8/qiYdtqj
Dyo8Wy9Clpb5XO7/QBzP9Xz3kML5jaKmpuYGsfhIbLW17yUuPiG/L+N+7STi
8/yKZuxnPrMt4sDcsc4HFLZ/LFrmK0vS+X8iriWTSd63o03erzKH+XyKdbPC
3s/kfaz3Mb92yZf7HoVrO4TLbjUvZ76nZT41WQovnQYfy5j/5yJ1nTfuUrj1
C2Gedv7N9YpOkfrbxP15Z+R9cnn+7JnM+O6zmfnZv0S9mH/JV5L/d3k/k0NU
hSzZrO9Vh+hyOBzkp6NL7Ez9kM/D5yT2E+d3o37cf7NbxBcLZ6gn79e4z70K
N/TI+5iYv/hGpPT36t0KZ50H/7xvrYGzFU6ex/dpfnvBH+/f2Svj2RlvqVfW
o4182PrEQmWoh3xofagH8y1wyvPmyE+rM5OfBSf4ID8VLsSnvgIu8W+hrZ38
5PVL/er0Q2O/9NPttB/6cR71XXoB+T/Mel4QqXJ71iqcMwA+81jfAexfr/D1
AfjvEdbbLfUeelThbjfib2D9L8JfGxV+66K8b0s+9YB1fZPC2wZRv83UxyD8
VKDwrUHo/XHq5RL436Jw5BL8+AT1MyTPaypUuHkI522lnoagR+LyYeRH7B1G
vbg/1wN98vwGj6y3hfFnPJn5isvy/HWPKey6DL+Qjywv6kG+dnklv4vku9aL
+7IeXV70C9Yz6UW/I77jhX9Zz2If/Mr91T7pH9s66tmH+Ix3xYf7s75LPuiN
9S0aAWa+thHpl2munzLWeZ42IvMtZ/x/RsAH9Vfgh96o11f8uB/13eqHvuiH
MT/0yn66YGD6yxLA9/RjRQD+oh9PBpAfvw8EwBfPuxGAHujHvG9RX/rvEHAP
82s01pm/x1jn/Jg11nnfNUGcz/qUBhGf9Xg/CD2TP3dQyH/k95cg/Ef+c0ah
T4vCL4yCb/rLPor+TX/1GZh6vD4KPoiXhzDviEtC4Jf73wlBT8TdIeiZ8b4P
IT9iUxj3J94RRv9O94Mw8iE+G4b+iK+GoU/i22HMF+JtY4hH/PoY+CPuGEP+
xPoY9Ep8C9+bmd+WcfiX+PA44hG3jaO/EEfG0Q+I/xxHPyPOj6D/E1dFoA/i
5gj6O3EwgnoT34zgfcR810fBN+tdHoW+iT+MQk/Uh9dYp35+j4J/6it3Anqk
/vZP4P1DvzZM4L1D/Q5OIB/2m5kJqZ9V1PvKSZzHeSQm8d6jX45Ogg/62TWJ
eUu//TSJfOnHLA180q8bNOiFft6l4Tz6/WUN/ZDrtRr8wHl7wtjP87s0xGM+
fi1z3ia1zPfIHxr0Qr/f0ZA/7782Jv3jTL8nY+hv5O9gDPM03Y9j0C/5Px5D
/2J9Oo397MfDMfDJ+l6JIV/W/7cY/Ey9LMUy9bdaBz/0b5EOvXDe7tMz55dN
x/04b+t15Mt5d0rPnLcDOvzGeanpqB/n6c869FfEeWDk86TCK+Ii9bdpO+dD
HP3jaYWtcfBTzHkRR347FK6L4/2xk/MjDj0+q3BvHP1rN+dJHPmUKPyjEf85
zpc4+uHzCmcn8B61ct4kMJ9fVHh3AvrYw/mTgB72KnwkgfilnEcJzLuXFD5n
rJdxPiWQH/E147z9nFcJ+I/7/0tAD/s4v6agH+JnpsAnvz80hfcvz3tzCv2X
8RqnZD2fOpDC/wNHEC2j
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx29N+4NcTXdLtDwxyYjQUErpx9kjkghRAhXSdmuLrGH9AbnR
DFkpg0WsPCy0Dsn4KT+E8+B+cBwcfO97d8UfZ5vL5Wo2oS3GBqvmpDH/qL7P
mz3v23mbstee5/l8P8/n/f58vt8t5ZUl79xjMpl+M/7Jv+rX6nA4LH9t37dC
+aK7ypoU5zdE0vWuqk2KtXLxuM2uP8z1o9hPFpXihNmZ9xD3HxMlfkvDRsUz
1eJKLBbbwPMfiQ+sSYfJKbXi4GxNC1l8kng+8xSeH49fJ4z8NzC/onph/H+S
+c80yPz/3qy46lNhpPfWFj7/MxFeSrvxiOLmJuSTynw+F5sbFq4+qtj1heTi
x5ifHetpiiuacf905ntGxrc9oXj5DPLLYP5fCru+1LddceNXuM8O3qcF+fB8
8lnxT5rNzufNnEU9mF/fOWGUa4H3qfoa8VIUZ38jDDmtrJfJgfxY32mHcObN
1qxnPVrleYdZcdl56LeO9WkT7xo/rs+3yfuZHmS9vsV5xjt+QczWmHfE9f1O
1usHPn9VO/KhnyraoR/zjbXDD9Qzs0P6xUw9WzqE1TjA+y93iCzjRz1tnfL+
QdZL65T1y6GeqV2oJ+vbCM6hnotdwpDfTz2KuqV+adTP0w3/Ur/kHlnPO08q
ru2Bf3ZSvx6xWOy/sEtx7kXpz9ks6nlR6v3A04rX9OI+u6lvL/Tco/haL+qb
Tb37oMczitv65Hk32dQv75P9rOIj/cifPN2PepEzBnCe3Dwg/fY++TZ4gfHL
LiE/8sQl9B/zSxnEfGH+9YMy35O83/wg6s37Fw4hHtk1hPuSzU70B/m4E/sZ
74YT+/k8cRnrzKf7MvJjvqtcifXZ7RKGPZZ4vsKF/Xxeqwv9QT1jLvgnU/G/
iOenXzKHEZ9+Kh9Gvem/lmEZr3Cb4u+H4Y+t9Pcw6kX/p4/Aj+wP24icz02c
h6dH0N9c10bQb5wPt0aQD+OlumW/rWY/lbrRr+RGN+Ixn4Bb+tnCflt0wy9k
iwfx2X9FHqmHk1zngd95X48H9SXPedAv5GQv8iEXeFEfcq1Xzqc5stMr5+l1
8owXepDX+TBfyLk+zHPyhz7oH5+3Psw38q8+9Cd5zSjy4/33jqL/yVWjyI/1
68T6VfK1Feb+e/1yvm1lPtl+6M/59Z4f7zP6p82PenN+/ehHf9BvpjE8n++j
XWPIn/PryBjic36dG8N96OfpMbz/6fc7WM/j/MoIwB9PKX4zgPcd+6U5gHjs
Tz0A/dhftwPIj/25bRz3i8+X8cT51DQO/Z7jvBlHvz+v+M9x+JGcMgG/WRWX
TKBfyfUT6A+y7y6ev4s3BhO5MIj5Rv44iPlKdgWhL/n3IPp3L+fZJPaTD4DN
L3C+TaKe5IFJzAvBeTcp9TPtU3z/FOpFFlOoV47iY1Pw537Owynkk6v45ynE
e5HzUYMe5E0a4h/gvNTQr3mKD2nw00HOTw39na/4lIb6F3Ce4rzlJcVuDe9T
ckxDPxcq/kNDPV7mvMX+mlcUrw/Bn4c4f0PQv0hxfgh6kMuxbi9WfGLlfAnn
cwjzgDwUwjx4lfM6hP57TfHNlfjk5RDu/7ritTr8T07X4adSxft1vF/INh39
elhxtY55Tz6toz7kXh3+KeP811Fv8i86vufIt3T4l3xfGO97cmoYfiFbw/je
JJeG8T3F51eG4U9yYxj9yPt0hKEv7x8IY96Rf8L+LNZvMYz+Zr1XR6An9bBE
UE/quSeC70PqXxTB9zX9cTQCPemnOsSz02/nI3ge/enB/mr690oE9eH63Arz
/H8RIf8wfnIU37dc3xmF3uSCKPzLeG9HE/ulNop+k/30P5+VN1c=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9MlHUcx28N+4NarcaWtnVhkCGpQ11EP86+/kiEKA8qxLosURloBVo0
U1bKYBErwULrEA04kAPhPO6O47gf8Nxzh/EHtrVarEZL22JusmpOGvMP675v
9n2zp9vg9trzfT7P58f7/XlueWll0b47TCbTr4k/+a0+s4WBc+l/rd64QHni
aIrr2zTyTrHt6pEUslYqEv+PPcLrFbhOFpVipa1JX87zh+T1FvKVatFVZWkk
mz4UrXa7nZxaY7xffCzPJzN+1nFRlviQtVqR4sq9SrbWiYC5/gDzvVIv/smw
3cv6qj5B/MV6P0U+jypubpTxdq9gPp/J85seU+z+XNRfL8zJYH5N4JWKy5vF
QUvyjkzme1LE5jKmH1c8fxLxVzP/L2S+19cobvgS58nWFtmfZVmKl56S121r
Wd8p0aTPOdcpdp4WifLm1rPer8TlycmCJxTnfI3z2azfjv7mKJ6wi+QpR9VT
7Ecr8nlacckZqY/cZ9mfNpE4HrEovtYm1ic+z7FfZ/E8ofjwOWFJnkrbxP59
I9mxWXFSO64/z3624/6tiifbRUJua7axvx2y/4E8xS0dmNcL7HeHrH+yQLGt
E/17if3vRP+3K053iIScjhRyHg7o52XFsw7k+wrn04X5Fyv2deF5Ozivbuh1
p+Kablx/jfPrRr7kLefRT553nsf8yHf3yHgzJZxvj8yvifxjD+KRc5yiKGBe
Qm5zSn1OMT9Tr5yXl7y3F34kT/TCH+RVfTJePbm5z3j9Zp/x/pILcl4ucvgC
9ENO7cf+eFVxXT/qKaKe+qUe/+Z8CgbQjxeprwEh91e+4hQXzudSby70g3qa
dmEfLervIuZPvXZdRHzqOcmN+T+jONst5Bf1X+42nm91Qx8bqNeF89T/bTf0
sJH6HcS+ZT6lg/DPFup5EP1k/pcGMU/WNz8o/V5NP2R6sA/pB5tHPJwQKP1w
woP9Rz9oHjyPfrjhgd8W/eDF/qEfir2YN+fT4EV99EPQi/3Bec56oVf6w+zD
fqQerT7UT33X+qT+La/TTz7ox6Z4xifnbd5Ffw1BL28qzh+S/r31Fv02hPdB
qWLXEPS/h/4bgj72Kb7fj+eV0Y9+6LNc8Qd+7IcK+tOPfu9X/Isf8d6mX4eh
h3cUbxhGvyrp32HsoyrFncPw40H6eRjzfk/xnQH07336O4D41Yr3B5Afz7cF
sG8Y/zucT3uX/h+R+Rw7oHjdCPzAeveOID/24zR4mv2bGIGedyu+hXgmzmNV
EHri/HYFcZ77rjmI/Uk96EHkR73cDGLfU18rQsiH+isJYV5WxY0h6Jn6DYfw
PuS++DMEfVD/qWHMi1wURn30S10Y+5jsD2Pe5GthPI/3PxjB/MgFEeO++iiC
/tBv7gjik3+PwF/MP2UU82Z9W0fRD/rx8CjisR99OD9Fnh5F//n+umcM+mA/
xRj2Mf16aAx6Z/+7xhCP/NOYcb8nadgvnN9DGvRKP2dr6Ad5u4b5cf7lGuZB
Pq7Bz/R/qwa/Uz9ezainSQ16eUPxHxryI99eyIf74oEo9EfOimIfkvOi2PfU
b2kU9ZGPRjEfcksUvz/IA1Hoh3wpivcR+bco6iXP/4/v0+E/cqYun/89ebMO
vZNtOuZJrtaxP8kndDyf9fXo6A9Z0+E/8s869gX7d0OH/sh3xaAH9j89hv6Q
LTHcz/kVgwvIlTHj75+GhfvJHTH0j3oJxoy/n36IoR7qbRZcRV4Sx/uG+jTH
kT/5yTj8Rj1b40a9V+D+MvqhNg790i9n4pgX/eSLY3+QL8exj+m/mTj6S/4X
z7eQl44b/bp2HPNnvPxxxGc+e8aN+deM03//AeVDU+s=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlX1MlWUYxlnD/iBXq50taotouUauGukiWuEekySIJVAp1sny+BFKjSOF
QyAFgkRSwTpqIBkfB/kQj+eL833gPe85lH8c21quVqMFbTE3WTWXjfmH9T7X
2XM5zqbst/d9nvu+r/u67/cRS03FrjvS0tJ+Nf7Jv+rnKJq/ueWvJ9enqFgU
ZPz0aCV5q4jfyDGTNYt8PnT7+R4hz5NFDd7fyvdrRaPJ8S15rk7sMy64ff6A
qAhkrWD87CbR29PzwBu87xD4NcW5LXi/nPe3ynizryouaxOL5YGzpYzXLuNt
KVFsPYx8ixj/iHh5vsH2kuLuTnk+awPzOYr7hGLnMfm+aR3z6xLG/83PK67q
FiYjQD7zPSHar5Xn5yleOiHs1oLOtcz/c+iRq7jjC2Hu0uvIZTZ5f9oaxZkn
l5+fO4l8nlE8egr9YTzrabHW+DGf/C/F40aA51h/j3jYSJD5X+pB/i9Qj15h
XGdlvZVnoD/1yO6DfusVX+2Df6if8ytZf6BQcf1ZcTmZLN1I/b5G/9iP9H7E
K6ae/aj/FcXJfsRjf3MHEI/9tw0g3ibqPSD9V0S/mAehdwX1HxS7jd/rilcN
Sf1v0H8dQ7LedvpzcUj8m2O+h34us0t/9ryp2GtHP8zs17Awjle/pbhpGPWQ
54Zxnu8XnkO/trGf56ReyXcUrxxBvtvZ3xH0Y4fiKyPw6072exT37VbcB/bw
edqYMOQu4PmdY9CH918ak/PS8K7iJ8YxH8ynexx+e1vxP+Oy3musr/I89KRe
kfPSfy9y/rMnlnPbhNS3i3x1Qvrhb3LpBenP7bzPCZ4nmxzwD/tR70C/mM+s
A/4gi4t4n/rbL0Iv1pPuRL/Yjzwn9CFXOaEn9eh1Qn/qlXSiHup5y4n5tdC/
LjD1t7jgb/bH5oK+uxR/45L9irKfSy7k857i1W7styr63S0M+XP2Kj7uxj6s
pv/dyO99xdfd2NcfcB48Mr+MGsWbPZhfK+fDA//uUxzySH8u1HJePNh/HynO
8iJeHefHi3rIrV7MM9nrhR48v+DF94CcOSmMcXN8qLhkEvWRmyYxj2THJPzC
/OYmsQ/J9/mQD7nQh/kj7/fB3+RRH/Ll/b/44CfySr/cr9+T1/nhd+Zv9UNv
8qAf/mb9V/yY7/2K7wwgP3J+QNb/FHlvAPmR+1LP6xV/h+fVBzj/QfirQfGa
IPzUyH0QRPyPFZ8K4r6D3A9B+OGQ4ptB5N/MfRGCHi2Kt4WwT1q5P0L43n2i
WA9hv7Vxn4Rwf7vix8Lw86fcL2H4ndwZhj6HuW/CiN+h+M8w/HOE+ycC/5Ar
IvBrJ/dR6jnZF4GfPuN+ikBP8oNRvE8ujcJv5INRIf8c5f6KYj+Rf49i3sim
Kew/nt84Bb+Q66cwT+RxPC8iz6bOM/+7p7FvyGIa9ZBrwTbqYcf7GeQfp9Ev
6pmuwS/U+yEN/iDnabLeZvZnk4Z5YD+rNPSD3KLBP+x/ryb7PUp/eDTUQ/8k
NfSL/IeG7zX9disVj368Pwb/kHNjyI/+LY6hX/S3JQY9yY0x7HvOgy2GeskX
Us+buK9j+L6Sf4stn6+lGOaBfK+O+8irdcwz53ODju8X2ayjX+Q6HfWQj+vo
F3lERzyypsM/5J915E++rkMP8l1x7DvmtyqO+SIXxLEvyZvj6A/rr4kv16cj
9Zz6DaTOk0NxzBf1/yEOv7Jfi3H0l7wiAT3Y36wE/EQ/PJtAP+iXsgTqob/2
JDCP9F9rAv6nP8+kmH72Ip6Jfr+cgL84HwsJ7HvOz38J7DfOW+YM8uW8Pj2D
7xHnv2QG++2Y4h0z0KuL37cZ9Lvb4P8BzZVePQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdll1M21UYxhvjvECj0ZCIJlaMi8FlkukS5QZz/IhzyxKBizm1TscYwmak
YpgMcAOkrkMHZQIO6BilZS1fpdAW/v2CfrHtgpkYjUSDkZlIlkDULJtZdqH2
PP+ch1SSjfxyPt73fd7nvH+eKK8pO3yXwWD4JfNP/lY/1xpyC8v/fOYlnXaL
p02dLx8kvyV2Zn7eVxwvF95d1+4c4Hq1KM5Zdr6rWNRIftLE/bXCZS5uf1vx
ap1YdpqLyYbjMl6SnN8kri4t7X2H950UuZmA5B0tIvN/8+b9rYjH+CVt4nHL
+nfkVQv2M1/zKWFZLy16j/FPi0z4W2Rbu6zXz3rzv5LrddTDdwbnqZfohB7k
KpusL3aI+XYhfoXi212o/zDzP4v4ZOvXItMPbyXr6RYfF+e8+YHivB7sJ6/2
QN8qxZ5eyTnVrPcb5E8uOif1XSIb+kSZZtxyRPGVPrFRqhnJtn7xeiYh8v4B
UVlZucbz+Xa53k2+bsd5su98dn71g+gn8xcXsJ989xD6z/qrhoRmtBylPktD
Ml8L9dzhkOcHqXe3A/1jP247RGOu9zL7ZxpG/E0/D8v+GMhbnfAT/WB1Sj+V
0j8bTsTf9JsL99OPAVe2//NG0E/ubxrBe+L9qyPSTxrjv3ox218esMb67nPj
PPUwu7P98oNb+mWZehZ5ZH67uG73ZK8bRkXm+ZrZr4pR+HnTD6PoB3n7mOjv
63uE/bSNIV/ef3MM/mJ/9o/L/q0z/+g4/EDOn4Ce5LYJnCdfn4D+vG/vJPrF
+n2TqIec68V55lPvza53xYv6mL+YkvoVsj7XFPx2lH70Qf8PFT/vw3v4iP70
Qb8axf0+kbpVsGKmX33Qv1bxPz7Mh0/o32noV6e4fBr+PUY/g3fWK76E/dpx
+nsa86RR8bYZ+LGJfp+B38kdM4hHjs9IPZt5/oZ+voHvwY/5QN7nRz2Mb8W6
hfmFsX75U74Xv/i7wPQA2RiQ+RxkfSUB+IPcGsD9vC8QEJlx52G8tQDuY755
QdnPBtazJ4j59BnfWxD+OanYG0R+zXx/QejRqvihWej/Od/jrIxfYFF8DOz5
gu9zFu/dqvhnsPM03+sc6uP+F+fwftr4fudQb4vi4TnUc4LveQ75sN57NOm3
v6hPkQb9qe8RDd8Lrts1+If6fath3rKfhhDy4f3P6Uw9K0Koj3r2hqAX87sS
QjzqeyeE/Knv9jD0YH0HwniP1NsWRj+pRzKMeUO9b2K9k/o9FcH5U5wvEeRH
vdsj+N61c95E0O8vFf8RQf1nOH+iyLdDcVkU93dyHkVRb5fi2Si+N2c5n6JC
/upW/GhM+q+yh/Mqhr9HehWfiOG9nuP8isFPfYp/i2G+DHCezSN/8mvzmE92
zrd59Ou84rF5zD/yyjz8Maj4/gXoe4HzbwHnhxTXLsCvZNcC/j5zKP5xAf0c
5nyMoz9OxY/FoaeL8zKO+Tii+I048r/I+amzW3GLvt/DearfN6rYr8cb43yN
I59xxb/HMV8nOG/jmH+Tih9OYJ5Ncf4mMP99incn5Pw2TXMeJ/C9mlHcmMD8
8nM+J9B/rk/iPi/vu6TvZ7xfE5gnXs7vBL5HzPfBJPzHerYloT/rfSWJ+qiH
SV+nXnVJfH+oZ0cS+ZHdSdRL/ePJ7P78pN/P/t1Iwh/ke1PwE/u9NYX7ycUp
6EV/7EvhvZFrUtl+sqbwXsmOFOYVOazfT/4+BX3ozw39PvKWNOYl2fg/fiGd
vb8kDb3I1enseK1p6EUeSMOv5IB+P/lqGv5ivWtp9J/8rx6fnLeIeqnfs4vw
D3kPuJD6H1rE95/ctIj3LPv3HzfJbAQ=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9MlHUcx1nT/iCXq7FlbREt16hZo9qKf2jfzGU2toQ/irZbW2QNsgIp
TIFUCFJJBfRA+aHymwPhOLgf3B133MNzB7I6XE4m0+kEm4wFWWvSmH9U932z
z5vhbcpee57v9/P7/Xmezc7L/OyhuLi4m7F/+q/8qswlW9WfL721QjtUeCn5
RjX5I9WenxZ/UtjIVhULGamn+DxXJdi3f2IVVnn6/cpavl+gZosS7HXCM4Xq
mYqFy6d5fr/6J9lSRU4qwXO+rw6qTG/ienJKqYr5m7x6f5l6wVK1lfZ3luvz
GfRvpkLtSYv/kP7nH1aT0Wh6De0fVdNt+WmMt7pSpcVPP8d8JB2D/RPCjuPI
zzH6V4X4fhLOqVb27bNFlfS3RhXHEnRUeLlGx7vxCP0/ift+FD5ySsdnq2A8
VtxXLrypFvH9wPhq1WuxX5mwrQ7+lzLe02oxw5t4SDj1DN4/yPjrtX3LAeGJ
en2+7XvmowHxk7MaNVeUMD9NsEeeb0I8xczXWdxH3ndOxf4/RFbn1eexH3ld
M+pDzmmGv+RoM/qRnNKi6ztdJGxtQf+Rl1vQL2RLK+q1n/lvRT3Im9vQL/tY
jzbk/zvhxRXey/q0o/8LhV3tsPct69WBfi4QLulAvHtYP/BcnvC2Ttj/mvXs
1PPm/VJ4Q5dqqK9/cjfr26UsVWZhrvBUF+qdw3rb1LuzRVY+b7Lp/MfxfFw3
/OH9u7qR36/YD93IL59v6cH79K+6B/flC9/r0fbPMb6sC5ivb4QDF9AfzE9S
L/qB+SzvRb6Y7/le5If1SO9TsfZbYL0cfbiP9U2wa3vB1X6zQ1/Ynzfs6C/2
s+pXsfb8i9zeD384D+scOr9L5NcdmD/OT44D+SU3OGCfHHVoe1Hyvw88TxlY
ez57APUnWweQX/L4yvv0ZxmcQH5xEP4zHssg/OXzE4O6X2d5nzGo48+nXvyN
83HUl81O5I/684ET/bWqV049n87Dwn4n9Jh6t+hE/1APE13oH+rnTpeep/vH
hctcmF/qr8sFe9TrORfml3q+yb1W/99zo3+4H0rcmE/uF7sb9T7D+XPr+14m
P+6BXvP8Ng/O095eD/JL/2we6BvjuY7zFxn/hiHoAffDm0Pwn+/nD0HfuF9a
h9AfvH9qCP4w/oe9iI/+pHrX7t8vvJgP+t/khV4x/kte6F0959+H+jcIv+pD
vfh8lw/zQq7zwT7zNeFDPcn3fdAP8hY/9Iv2P/ZDr8jVftSPbPpRb/I9P/YP
+flh9Au/B7Ie4Mph2Of7gWHsJ/LdYcSz+r0RWJufzADyTy4PwD7j8QSwL8nz
AcRHfioIe8xXelDrdT35QBDzynw7gtBL8u0g+rGRejaCfdsk/M4I9Ogs9W0E
+T8v3DOC+jVT70bQP63Cj4bgbxv1LwR7HcIFIfjTST0MwV+b8NUQ/OmmPhrI
f4/w04buv9291EsD+twn/L4BPeqnfhq6/qZDuNTAPAxSTw3Ml1PYacAfN/XV
gD8e4TsG5nuIemtgPnzCT4yi/uSUUdjn+zvAW3lfNt6PuoSLV96nP9ZRxM/n
faP4Pub5cTwv4v23Vs57qd+j6Fe/8GMm9H+Yem7iezAg/LYJe0Hqu4l8hoQL
V943qPcm+tcU7jKRjzD134Q/EeFrOJ88zn1gQv8vCj8Shv0J7ocw+u9n4bQw
9OEX7osw8jkpnBfGvrjE/RGGvV+FW8Lov8vcJ2F871wRvhLG/pvifglDz64K
r4/A32nuG/DGa8JvRHD+OvcPOOGGcG4E83qT+yiCeb4l3BiBfs9wP0VQ79vC
kxHk8zfuqwj67Y7wfxHMwxz31xjmZV74lTGl//zOfTYGfxeEPx2DP39wv41B
r+7G+H88x406
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVntMlXUYZk36g1ytxpa1RbRaI2eNYiv+of0yl9ncEv4o21hbZExrDaQw
BTIwKCQVUiC5iMDhfjkcOBfOOZwD37mAVAe7SJGFBVZkQeoMmvMP6/yeb+/D
cBP2+H3fe3ne531eH8jKyXjjlpiYmAvRv/q3/AmtJM2evPLoMybapuJmLLl1
xK+opXR3Qr1gI0tFfxYTx+xRGe6EWGKVg+f83shT2dnZC4w/l68eyazcvJrv
gM53lTixSP2blHnHarwPVGVwJalBcHIJvm9k/ENqb1rcy6cE7yhV7oSyt5qY
rwz1nBac+7GOX9nM/Id1f00tgqsqdL6uVtZzRKWkpNgtgm1HVZQefxvrq9T1
BNsF765ShfHWMx2s91M1FYlEOgVfN3EX6z8O3C24/AS+72E/1YjfK3hDDfL3
sb8aVbaY7u4X3FWL+q3s9zP0NyA49ST6t7H/OmXdOl8wKHiyTs8re4h81Ov6
ttsF72xQ8wXxjznIT6Nqy02Lcwq+1Ih5E9tOoT6X4P1N+v2KYfJ3Gu/z+bpm
FR8tiPl2NyutT9YbaVb3ly1+w36TW8Af+apuAX+rfLesnVdmK+rhvI1W3Y+V
ennIAv6ot3KLSosKlPpcsoDPGs6nTdXX1dUdF+wwcSXn1Q58RHCRiQ9zfu2I
95HgLR3I/yHn2QH9FQte3wk9vM/5doKfAsHTnSr6eOU9zrsL+5svuLFL85ee
x/l3q+fnC6pzBO/qBp9vUw/d2D8+39Sjoj+Lc6mPHry/V/Byj+7vnneol17s
57uCfb2YP+tJ7EN/+wSX9qHe/dRTH+Z3QPD2fq2P1wqpr35dTwz5iLeCz4PU
mxV+Qf5mrdBXCfU3gH7Id9uAnveDZdSjDXxzPk/akL+c+rQhf4Xgehv08gn1
iu83HxV8E9/PH6N+B5G/SnDWIPijnqoHodcTgicGwSf1d30Q/lkreOMQ9pt6
zRzC/Oinx4awH9S3MYR+6J/XhrQf3FjdBzv0Qb98yY79pz+W28EP/dFr13rM
pB8u2VEf/TDBoe9FGf1vhwPz5v4ecmAf6XcOB/RBf1xwrPXXDU7Nxwzzv+DU
/r/IeoucmA/7sTrBL/ufc8L/yM9dLvgZ78sWF/onP/tcqJf3pMuFfWW+H11r
+Vk/DD2yvqeHcV/5PHcY+0g/ah3Wek9jvGkTM9+tbvgx+0l1w69Z35tu1Mv6
G/F+hP2exfN44hgP6mP/T3g03yn8fpcHfDN+rQfzZT2THvgN673hwX6zv01e
7BP991Uv9pn6qPJCz/TroBd6oT6WvYhHfTw8gni8fztHEI/3oGIE8XjvfCOI
x/txeQTxeN8SfdgP3rMMH/TM+1XqQ7+8Vy4f+nXTn3zYN6/ge/2oz0e/8qM+
v+CDfsx7jP7lx/0zBF/0Q49B+tko9BgW/Nwo7sc4/W0U+c4I7gG2TNLvRqHX
LwTfPqaiP4u/pP+N4f2I4Lwx6HeKfjgGv+Lz78fQP79fZ4Avxr/PAF+f0y+B
Z1nfi4bW09YJ+qeBfWd/JQb+Pxminxrwp4BguwE/JH8RA3oeFfy7oevLJ/83
zfycz90B7ANxckDHS+X72wLYB84rKwD+ma8wgP3lvKoD8B/W12/GY/0TZjz2
90tA4Z/p3wHwRX7uDKI/zm9jEP2R32eDyE/+M4PYT84nP4h5n6Xfm+9/Jbgz
iHl9Tf83438r+HwQfJ/jPQhiPtOCbwth/t/xPoTgTzOC00Lw9x94L0Ko77zg
nBD4/In3IwQ/mxXcgucVF3hPzO9/FnwO8WPneF/M/POCY8OY/0XemzDq/1Xw
U2Hs22+8P2HcgwXBe8Ko5w/eozD6uSS4IYz5/Mn7FMa9+UvwVBj8L/FehbHv
fwv+z4x3mfdrHP5wRfDj4/Crq7xn4/Cna4JfH4de/uF9G4ffL0fx/8QMs90=

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln1Mm1UUxuuEqbhoNCSiiYiRGDTToCTKP5irLurMEoE/5pYQE3EuTP8A
l2DmRnQjI+KiwpRN+Rjjm/JVCi2lLf14+7ZsqDBFUXQyhZkRDDhxjomo096n
nmfpmkDzy/vee885z3PP6d2Fxfkvr7NYLGeif/pbPkt57sb6Xx94PEab1cT4
+JYrvF25UysW64SNQpVse3qObNmlpltL/HxfFasqc8XawPd3g48Jz5bi/Uau
f0OFVzJmjgunlam2kpykZu73ltoXPbBFOPOAupRRUNXK/cuxvk0496CqWMzL
7uB5Faqutra2U7jkbZXvTk3s4vnvqIIqs7RbuPoQ8u1hPO+qndFPn7D9Pc3z
NsZXpd9/1S5cVK33WxlgvIdV9P9+h/DqYfXM3N7kIcb/gcpJmm51CVd+iPjd
zKdG3VWxOOkRTjmC80aY3xHk4xe2HsV+Aeb7kbqvoOoJQzj7Y+gXYv61en1F
WHisVq+/Z5T1qNP1LTghvK1ex5MXYX0aoI8pvNCgXotuEGS9jqFePuE9jWDm
o45jP+ab0IT68HlRE/wzLDzehPhYr8xm+MkpXNMMPa/Uuxn7DwoXtICpj9GC
96lfeqvO52Q/9WiFHuSlVuRH/XPb4C+ysw31JKe063xqyGXtWg+TPNuu/Xwz
99/UoaLy7CVbOxTKKLyhU+n7Si7pxH1lPlOdqB/zzbbCz+QGK/zE+li6EA/r
tyPG9OdYF95nvTd2Qz/qUd0N/1Gvi91arwwv/dKj6/U8/errgf/Iab3Qg3yw
F+dz/UKviqbzIHlLH/zN8+x98X5JtqHe9NMem9bndvKMLd5Pqh/3g9zWr6Lb
LzPfBLvKyspykB+xQ19ykR33kVx3FY/btX77yZev2i9zQOu9Ri4cwH1jPDUD
8Bv5xAD6EfNZHYB/mP/9g9oP4+SCQfiF9Xt/EPGw3sYg/M/7eSHG7CfpDl2P
EvaTrQ7oz+eVDujD/bwO+JHxLeH9nfRTqhP+ph9znejn9Hu5E/H28j45oQ/7
77wz/v6lDGF/3odnh+BXctkQ+gX3tw0hf+43OwS92e9vdWE/zoNNLjy3Cr/u
gv6cJ1YX/M55c9oVP482DENvzqvHhtFP2nl/wW6ub4k953lTsfWcV+vdqDfj
zXbjPrBer7jhd9anwR1f31Nu+I31sXiQL/V42BPfH3Z49PlZ1O+oB/eLfh3z
oD7055oH+tN/G73x/nvBi35Ev1R7kS/9ZHrhD/rtIp67OU/uHcF5nGfbRqAv
58+hEfQTzjPfCPzMeXV+BPFzvqX5dD1tnG/5PsyTk+xHPsyDMWFXjD9hf/Kh
X30qfIcfen3GfuXHeePCb/rRHybYv/zI/5TwWT/yIycHsP5z4acC0PcL9rcA
/EjuDiAe8kwAepJvCiI/sgpCH/LuIO4XuS2IfCaFvwkivi/ZHw30qynhOw2c
9zX7JThvWvg5A/t/y/4ZW39a+ICB/vI9+6mB/nNG2GHAvz+wvxrIf1b4nIF5
cJb91sD9+En4thDuzzn23xDqNS+8OYR4F9iPQ4jnZ+F9Ifhpkf05hN+rvwj3
hXDeefbrEPRdFv4R+0/+xv4dgh9+F77FxDxdYT83oc8l4SdN7LfK/m6inn8K
l5qI7y/2exP1+Ee404Sel9n/TeRrWf6fv8P6lWuEL2B9zbXCN4ZxfqJwehjn
rxfOCeP864W3hjGfkoSLw/APuTKM/MjNYfRTsjeMet4g/FUY+ZCXsF8Jz0uM
wN/XCadGlP4iPxqB/ow3N4J+xXx2RfTvkxcThMtjzPzrI/g9s07YifNyWK+J
CPJlPefx/jTr/S+eV1GPlFHU82/hh0bhjzXOs1GcT31fAs/9wfmG9/O0P/4D
NAyqkQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx69CV0hZRoWWRIs1ctYoN+Mf2qdykY4t4A+zjbVF5rD+4HKj
FbJCJotYCRZaIBFwID+U8+CO4+64g+9971CqwzIpyijBkiiYMgpH1qz7vOl5
O7yNsdc+3+/n8zzv5/08n+99eQU5L19vsVh+jP7p//KLHbXNnrr40BOLtFkN
RyKZV/l59WBupfmVsJGn+UmyZad6LT129EthVaDsGRNFZGOX2hD9kccL9frl
k3z/TXVv2fQpclKxGrVZA2T1tn7fSU7ds3TdKMX55Ky9Sv+7el6ZKpvOTiNb
39HrJWTLuzifXFWBeJlf0ntqJttTT3a8r2pralZTH1WJdXJ+lZooin/4a8a7
H/qRF/arHdHfacb/gbqUkrtyRLj8QzxPzqqGnt8IJxyAHlwfP6Aqzfk27t92
UMdXw3itH+n9K6lP2sfIP8L8a1S0/tbPhYdqVLw948Uh6lGrdsfbTxwX3nYI
+pKT6hB/SHiqTj0zUVRtUK9PEE+/8Bv1qJ+f+n2qounO+4RjGuAvL/VsQH3I
kQaV40ks4/OpjdC7T7i6Ec+TFxqRH8/LbUL8AerfhP3IyTasM95yG94nz9iw
PzmrWeufMiDsatb5FJITWlAvcnGL1neCPN6C86jXpsNav3hy22H4jRzXCr3J
1lb0E/cbaUU/kNPaVBRt5Lo21Jdsacd55O3tqA/zG2rX+z1HXt+honJNU6+q
DuhD/hM8S723HdHPv0r2H1HN1vQKctJR+Ivv7z2q67GM8UxhPYP5ZnbCz0H6
q1OF5lPGTOF4O/wQpt/sWt+SQeExO+pH/6pjqB/93nwMfviMfnRgf/bHRgfm
Cfsn3wG/DwvXOuBn9lvEoc/LZj9eccAPnBepXagn50FeF/Rkf1d36XkcYf8f
70I8XF/o0vMnkf2/rhv14jzL7YbejHdft47fw/yMbviReszh+Vjql+yE/tR7
qxPrrEe5E/Fz3XfN+owT/mR9E13Qh/2Z5cI6+7vUhf087CcX6ukWnnQhPxf7
qwd+6Bbe0oP9u9hvPainU9jeA7/3sP960B/cf5Ub5/H8TW7oxfhed2M+Mf42
N+pDP59xo97sl7jepf34eK+uXy71svYu9W9TL/qT+o+AJ+jf5R68f4L9DR6j
f1/xQB/6tc6D+L4QPulB/PSrxYv86NdHvcifft3uXXq/HfQu9euQF/cT/XjZ
i3jp1/U+fE+MCr/g0/vbv+P88GG/M8KmD/7/gfME70fGhB/o0/W6/yfOlz6c
f1a4og/zZJzzpg/1Pid8oQ/6/cz548f99Itwjh/nnec88sOfk8JuP/ab4nzy
I/7fhNcE9P0+Sc4MIJ/fhd8KoB/JjgDmD/kc3t/B9+P7MT953tP98MevnG/9
yIfxdSw+z/jH+vF9wPxuGcC8IKsB+JN67LqGmweQH5//dgD9RI4xED/PW2tg
/pM3GvAn43vWgD8Yf76h9D/mu8dYqketAT2mhZ0G5ucM56uB++KC8PnF5y9y
3hqo56zwXUF9v6XPcf4Gsd8fwpuD8P885zHYfkl4N57fsMD5jP0Cfwl3BuH3
vzmvg8j/H+GzQfjhCud3EPFbZv/n20z48TrhdSbOu0H4KRP5xAjnmsh3uXCh
CT1vFN5nYj7eJNwKXrlC2DDh5zjh703MB/KcifuOvCIE/5CTQ6g390sPYZ6Q
t4bwPUQuCEEPcnkI8d8s3BhC/CuFfTiv/lbh0yHosUp4JoTv5duFl4Wh/x3C
ieDIncKPhZFPgnBWGP24Wngn1j1rhEvD8MfdwofCyOceYVcY9VsrPBxGP5In
F/cn/xvG9wI5YVDnW0J+ZBD3B3nLIO5T8kuDiIfnFw+iXpr/Awz7n3A=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVl21M1WUYxk8GVmiWxRIrEZOKSItiK77QnspVOraQD0LbWVtkTusD5EYj
ZaUMlrESLLRAMt6UIwIeOAc4HA5w3kBWYJEkaZhgSRSkRGJEhf2f63Rf7rAB
+43/cz/3y3Vf/8Oq9IyU1xaYTKZzxrf+LV9vJoalXr289ukArVejO8If+ZP8
kqrOTAybFXanK+P5IbJpm/LNxJjJKkM1PD+6g+fd2/X5AsYfyVLGz10zPP+2
2mJ8XRGOylFDVZmJfzDeu/p507Rw3G6dX8MU4+eqlfkTGy8LJ+epcCOB33hf
vuZXJoUz30P+v/L+95VxPOEX4aICdTXGXPgz8/lA1zd8Udj6oSotKVn+E/Mr
VDuNCy4Iby1SYUYBI8x3H+L9IDy7TxnXVw0z/49UfHy87azwno91Po7vWE8x
+LRwxH70hzyyH/0ZErYcQDxy5ic6vxODwgmfov4B1l+i+z92Uri3ROc/9SX7
UarMhd6ZXuG0g8oRmf8GOapM13fbF8LjZZgPz1s/w3z6hbMPIR7vU5/rfpZ8
LRxSjvq+YT/LMc9Twn3l0M+37G+F7udq1ltcoR4yLmD/ZiugT/bXXKn1Ofc9
+1+pXhjdUXxOOLpKGenFnOc8qnQ+HZznZBXq4byTq6GPH4Xt1dAz9RJxGP0d
E84Bbxnn/A7jPPW37gj0NMF5HkE/qd/FNdjHS5xvDeqj/gdr1ORGxyHuR4JF
5zvwu3CZBf3nPpmOIh73b3OAuZ+9R/E8eU0t+st9LqqF3rnvV2rRX3LaMewf
/cF1DPtAjqoL5rw61d/Xl0Qer0P+jJdUD72RrfXIl/mEN0DvrCe7AfHoJ8MN
0Bv7oY5jv9i/6uPYH/pHiFWlGILnPJ6wQp+c11Yr5sf5llrRD/pDH3hqVHje
ivlTX3GNqI9+kN6o74+nXosb0R/qu6dR5xNKnm2Ev3K/Y5u0nsO5P+Ym1POV
8N4mvf+p3Ed3E+JxX6eboHfud7RNGT939QhvskH/fu6HDfviFXbatD6eIU/a
0D+fcKQd9fJ8sh3nGT/XjnpOcJ/s6B/zGbNDT/SbiGb4GfPf0BzsNzngAfpN
A55Ppd+MNMNf6Id3tMDf6DfrWqBn9vetFsyD/mtpQf70m7Mt2I8z3NdW5Eu/
eapV99NEv8lsxb7y/VDZiv7RbwZbdT4T1M9CB/yKfpPggB7pN687gv2mLPA8
/eakA/Gvv//asN/U9+NteD9R/5vb0C/ux4E27Bv3p7cN9dJP5hAvi/u3xonP
E9zPl53Ij/tb5ES/ue9eJ/K57ifO4M8TD7RjHoyX1o59Ixe0Iz79ytUOfyRf
ag/2hygX9o2c4oI/0C/yXLiP9bW4EI887sK+sB93dyAeOakD+qQfv9Oh/aiP
bO2Afvj8hY5gvw7vhP/zvuc6oRfmlx1g5l/bifmx3uFOHd/C/izpQjz2U3XB
H9j/7V3ww7/ohwGeEz4d4L/pj26c/0d4hRv3/Uu/dKOf88IvuuEH1+ifbszf
NPU/73Zjf28QLnVDPwuEbTgfeqNwH54fIF8M3BciPO/GvEKFl3ngjwuF4zzQ
L3m9B/ncJJzugd5vFt7pQb/JxR7M7xbherCF3OPB55Mw4fMe+Ad51gO9k5d6
8b5aJBzrRT3kZ71435DNXtSzWDjLi/0m7/XifUOuwfPFZLcX/b1V+IwX/rtE
eNqL9+3twot8yGepcLRP9yPyTuHEwN/DhTf50L+7hDN86O8y4T0+7E+EcIUP
+7Zc2OlD/+4RPuVDvvcKTwb+vkI41A99RApH+qEP8pN+1L9SONkPfUQJb/Mj
/irhXD/qu0/4oB/7vVrY7kc90cL9fujpfuExP/6/eFD4GtgRIxzRjXnHCj/W
Df96WHhDN+axVvjVbuT3qHBON/QQZ/B/zIawbQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVl39M1GUcxy9DKzVNuxItzzPJkKmRlNIK9/Rjmc4t5A+jjbVFxrD+gNxs
hKzUyTJWgoUWSAYCcqKcB3fAcRzwve8dxh9nW6tFGiZYEgUpkRpZafe8r8+b
4abtte/3eb6f5/15vz/PtTgzJ+21KRaL5Vzkr/6v/BnIt678+/KKp6K0XpWX
lZVdJ7+kpvdWj/4lbGSq3urcFLJlq+YOsspRzw/kl3K9sU2vz+X+/dvV6XB4
4z9c/7YqNq/G/ytsL1BpXtvUG9zvXZWVlTVITtyl14dvcv/dKikpyW0Z/Z9T
96D+W4T7C1VNbkoRn+e+p5/P536W91Ev6ysp0u9P53nsHyivrfCNa8KuD9UO
q/OLP1hfMfb7XTi7RFmd6165xHr3q5SIAMPC4/tV8Gp83xDr/0hdi8+YPSi8
92NVOLwp+Ufh1FLs1y8ce0BF/t15jnoeUCObvIfPCjsOQp9e4dxP8Pw74eRP
VUaxuf0Mz1+mFkU+yPU9ZVrPpO+pR7nWx9onnH5IOdcNXCfbK9Af1jNUoff7
6gfq9Rn8cV4477CKbOfkedTn0GdAOKYS/btAPSu1PsXUI1yp/VH4E/Wtgh4X
hUujTD3Hq3S9+T8LZxwBT+h/BO//IhxXjf1/ZT+q4R/2b6Qafhlhf2pQ/2/C
nhr4kf2PrYVfLgsX1Op+Doyyf7X6+5Yx4WeP6n7Z6C/HUb1+3RXhmXXo31X2
t07nx0F/flOH/f9kvx3Yj36ucMBPE/k+hvrp/y3HtN+Hmc+eY/Aj87K8Hvow
fyX16DfzdaUe35sinH5c+yPrVmH/cdQbI2w/Ab9OFd5zAv6bJjx0Qi3LKH6a
729sgP7Mt6tBvRk5AOuzOuFX1p/nhL95/j4n/EW91EnoRb1rTuL7zHOMC+dl
P1e7kF/6IdsFfeifchfqo//CLsxP+veGC/OPfk9shF+Yl8xGzBPmq7QR/mNe
TzXq/Kxkvsejz5nvhCbkke9nNEE/5nlfE87P/Y0m1Mf8jjXBb8xrnBvvM6+b
3fAH69/rnjyvfG4V+Xcn8znihv+ZT5sH85V5TPXge8zjbg/WU0+PB/owj4Me
9Iv6xzbjvmD+NjRrPy9hvwqacV8xf85m6D+Rv2b4g/2e24LnE3lswXr6460W
7M88Olp0vRbm8SzWh8kzW9Ef+m1tK/RiPnNb4V/ykVbkZZx5Bg+Sp3kn+znZ
izyRX/dOvq8rvKiXef/SCz9M5L8N5yWvakM/yFvakAfywTb0j9zThvzze9fx
vIi83If15Jd9eJ/nKfHhfuJz06f1eJHz6IoPeebvg6Xt0Jd5T2+ffL8XteN8
nD/+dvSH8+NSO+4jzhu7H/fBbcJpfvT7Ds4jP/Tl8xY/+sX1Q36cj/sv6MD+
/P7GDswPzqt3osx6XdH3OU8vdCDfZGvn5PM+1wm9yHmdyCe5vhN5Ifd1wg/k
WV3Qh/urLtzH5G1dOA/rq8H7JvnbLviT54kx0B+ed6GBesmrDdzfnP8vGOgv
9co28PuPeu4ykGfO/3IDeSe7DdTDfoSx3nG78EXUU8r+3TB0/3dOF54XwO/R
GcKJAdyHM4XXB5CvO4UzA8jDLOEdAeR3tnBpAP26S7ghgPtvjvCpAH7fzRU+
H4Af7xYeRz2j5Dkm7hercIKJ+XmP8DMm+nWvcIaJ884T3m7i90Gs8D4Tes8X
rjPR3wXChon67hM+Y2LekMdM6H2/8Iwg/LZQOC4IPW3CKUHMk0XCm4PQxy6c
E4RfFgvvDWKePCBcFeUlwr4g9IwT/jqIfjwoPBJEf5cKTw1hvjwkbAvhvMuE
14TglwT+/wI4frnw1pDur3eF8O4QzvOw8KEQ7r9EYU8I/l4lfBrrkx8VHgxB
z8eEb4bQrzXCsd3Y/3HhR7rhjyeEN3RjPjwp/Go3+rtWuKAb51MR/g9kwI4Q

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVn9M1GUcvhmYnaZplGiJqGRoaOgVstrZK5oI0QL+MNpubdGPYf0BudEI
WSGDZawE67RAMn7KD+E87o7j7jjge9/vYfxxtrVcrkZL2mJssOacNOcf1r2P
e5/bdRvcnr3f7+fH8/k8z3tbSsuL311mMpl+j/7Jb/XprrCa19zcdeA+yhMf
Ws2vx/AbwmKxuIm1UrFY5Et5hOfHRGtLSwuxKMf5Wj5/XBT7UhqIb1SKhoUi
Xyz+x2Jzw8JPDyucWiOuRiKRlYz3KZ5/SOHMk4j3IOPXiRNJjtxEhQvrhfl6
181lzNcgov01Eld8Jhy5s9UPMP/nIhrugwSFmxvFe9EP46V+IaLh31qusPNL
nDO/aML7KxQua5b5K2L1nhHR/7Vmhe+cEf+k25rYn/aVaNKX+lYpfOprscPW
pJOPQrvMP7ta4eSzMp6JfN84K99PJ7995ySfRevY7zfI/6jC2d9inknsv0X2
M/eYwtMtmN968tGKfUhWuOS8ODJbbd9Aftrk+fWNCs+3yX3Y8CT5+g78bVK4
6gL6TSF/34tou0ubFU5ol/3nbCGf7ci3VeFIO/jYRn475H5kP6WwvQPz3k6+
O/D80wrbOvH8DvLfiXnsVDitS85z4RnOowv17FJ4sUvyc2E359Mt9+nuswp7
usHXHs6rB3zvVbimR9Znfo7z68E+Pa/woYvQA8/7LiI+31/Vi33L5Hx7oT/W
d60X/LKf7D7kZ/9tfSK6nuNpnH+/1M8P5PudfuTnfKb7hbGUPvOEwhkD4If7
0Dwg98v0uMK3B+S8krhvJZdkfgv3NXhJxrPF9D4oouvTRX3UD6J+6ml+EPGo
p4IhzI/PO4fk/lRST0kO9Ec9VTnAN/Uz44j3N3EZ+Vhf92XwTT0lOKEn9pPl
FNFyHNRPmRPx2X+rE/OhfiJO+Bn5uof3d1MvmcPYb/JbOgw+qRf7MOJxHleG
oTfq5c5wvF52ujBv6sXmkvxu47xPu7Av1IvmQv3cj1sumb82nXpwgw/q5agb
/hbThxv+kaFwwA29Ux+LbuwP9ZHiAZ/UR6EH/HC/6zzwc+6/xwM/pD7mPHK+
1n3U1wjuh2yF80ewby9QbyOY14sKO0bAh5X6G4Ge9yu8zgv/EtSjF/5wQOGP
vPL+STxIfXpxnxxS+Dcv7p+XqddR8JGr8P5R8E1cMYp9OKxw5yj0wfevjaI+
xl/uQ3zmz/aBH9b3vg/6ZT9tPsyH/f/owzzJl8kPfWUpvNcP/iz0Az/0Qr85
58d+0G+m/fF+c9cf77cZAfDJfXszgP64n80B6J/7rAdwH/D+uB3AvlAv28eg
b+qrZAz18v5qHMM+8P4LjuF96vvvMVm/iX6QGgR/9I/iIPqh39QHwRf9xhtE
fPrLPM6rGW/jOPyJ+QrG4/3kk3HUTz9x4rya9f+Jcyv7S5pAvbxvD0+gXvJR
hfNa8jWA8xz6xcwE9jVV4dWT8X4vJnFf8j49jvNczqt7Mt4ffpmEXukPCRre
5/w3afK8gH6QhXMz/eA1DfnpB2Uafs/RD05qqJ/716qhf+rfrYF/7mtEgx9x
n//SoG/q/54Gv+T+rw8hH/WfGYL+XlI4LwT9UP+lIfhvjsInQqiHerTfj0e9
DoUwb+r5Sgj7fkThP0LY9zz6dwjzzFd4rQ7/foV+ruP3QYHCB3X4KbFNl/60
5lWFK3XMm/i0Dr75fK8OPyLWEH+O+X7VoXfiW3p8fSsN8EucZmD+7MdqwJ/Y
71Ejvv9yA/tD/ztlYN+IOwzwT/4CBuol/tkA/8SLBvRK/hPD8f6ZEsbvWeJ9
YdTH+RWGkY/4WBj6JK4LY9+Iz//v3BPGfhFfDWP+xHNh7Bfz/4v8FcTJU4hH
vGcKfsn+8qdkv7XEb0/BH4lrgCslf/8B2ggq6w==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx29N+4NaTaNEyxPTDAkNtZRW2OOPRIgSqBDrskAkrD8gN5oh
K2SwjJWgoQWS8VMOhPPgDu43973v3Rl/nG0tl6vZgrYYm6w5J435h3XP+/a8
7WJz+NrzfZ7n83l/3p/Pw8qSioKD9xgMht+i/+Tv//zULr2xblvsv9mipzKz
MYm8TziNDR8sUayViCZ9LuURrh8SV7srfYmKRYXYFP15iN8flmxbpHiySqxo
uJ6/mPs/Fpasqdvk5BoxVZ1o4X7xKe7n+enHcP7DPL9OyF+MJ69eBOdSrpEn
G0T0Oifjr/xMzOY7z93N73Pky/ybG2U81csYzxciIZrgo4qtXyKexxhfE3i5
4vJmfG9kvCdx3grF8ydFQXRDMuM/Jf5OMTWtVHz8K8T3OPNpgR6rFCedFmtN
Tfpq5ndafJiZcPUJxeYzoqysbHoN8/0a+j6pOOMbmW/CWubfKtpaW5emKp5o
RX2foh5t0DtNcdFZqWfGOurTLuufuV7xTDvWn6Ze32J/uuIj52R+xg3U7zvE
s1Hxgg7ETy7vQP02KY50yHrXPkN9O3Hfs4pbOlF/8nwn6rFZsalL8g2y1iW/
N21RvLpb5m8mH+/GeeTZblnv6+S8nvh1e0/8/qRecTTRkkWu6UU+vH+yV0TL
Ocd4d55HfbluPi/3f8/1+/ugN/Ov7BPR46eo15U+6EN9M8zSXw9S/3az2D1V
3cJ6GfqxznqW9sOfrP9EP/xDv6QNyHirUuiPAazTb7cGpJ9a6ceiC9Kfe+lX
7wXUi35OHpT5bqff6wdxP/thZlDmYyDnDkE/9o91CHqTEy1yvvxIPmKB/7j/
mgXziiwuIh/e33MR84nxLbCKy5FILuPfbJV6FzO/civmB/Nvs6Je7LeIFfpS
vztW6e8y9lv6sDw/Qr1LhuP7q2UY/c96XRpGf7Ke82Az6506Ir9fz34xjUAv
+uXECPx41/8jmB/0580RzLPn2A826P+84kIb6vsC+8MGfbcqdtug/4vsFxvO
26bYaEe/72D/2BH/TsV1dui9i/1kR79lKZ62Y15ms79Gke/LinNGcX8u+20U
9X1VsSX2/R723yjmEdcXjyG+V9iPY8if5300hvmRw/4cQ3yM59cY72a/OtDf
jH+rA/FxvdIB//O8Lgf0IF9xoP7cf68T9aReGU70F/V834nzt7PfnfAr+Qen
7K+FZIML84b12ehCfcmlLvQj+cz/eMKF94p824X7yWluvC+8b78b9SA3u6EX
WXdjXjOfW27Ey3zXeKAHucgDf72kuNEDP9I/Xg/qSf3+8sT7KdmL+c16FMSY
9az3Yr6yHmNe1J9+m/HG+2WZD/6in3J9qA/99okP+uVxfvkwj/IV/+GDXwo4
z8YxD15XvGtc+rH2Dc63ccyPQsUD49C7iPNuHHruU/yAH/PpTc4/P/xvUnzY
j79X3uY89EOP/Yp/9uP9eZfzURPR8dFdrHi5Bj0OcF5quL9U8R4N8+Yg56cG
/7+n+JiG+pZznmJdJ9s01IPfRzS8P2WK/4zdT76jyfcukfctCUAfxpMeY8ab
HYAeJZzHAZnfKuZ3NAB/Mf+WAObpO4qHAvAj9boUQD9Tz98Dsn4G8nwAelP/
RTr8Q07VER95h477yCYd/iFX6bif55/QES/j6dMxP8iajnlL/kXH+8f9N3F+
Js+/Lwg93uL7EIS+9FNmEO8d/VYYjPdjRRD57eX7EcR99G9nEP1Bf7uD8Cv9
/1PsPvJsEP56TfHCEPzK/jGG0H/kLSH4h/2WF4L+5EMh1J9cF8I8Y7+eDeHv
J7Id5xWTL4egF3k6hPea/E/sfHJSOJ43hFEvck4Y9SEfCGN+kmvC8JfkfwHZ
4Uhp
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlnFMlGUcx29N+4NcrcaWtkW0WCNnjWpTauEelSSMEqgA67JENNAKpHCE
lGFQxFSg0ALJgDvkQDgP7jjujjt4770X84+zreVyNVrQlnODNeekMf+w3uf7
7vm66zZlnz3v+zy/3+/7fX6/9+HSysI9d9hstt/Nf/Kv+iW7c3a9du3xTRbl
isfsrfpt3iF5c5FirVQcyEq6TLZVCGdVVkuxYlEpCgMpTWStWiRddlSR52qE
ubyfbPtIuHPm68ip9WKxIHD69n6HxUNNCz+RMxrEC/N1ySXc/wj2I+c3iovx
eJw81yTM47N2KK76AvmRbV/K5/NeV9zWIvdbIKceled1vKHYc0wcMgtmZ3yt
Mv+kNxWXt6E+5Ix2YYbr3ql4uR31eovxfyXMcGreVtz8tdhr/nYxnw4h9SlV
vPoE1nczvxOob5li10lh/v/pHub7jejq7OzcqzjzW9G0UBB4h/l3ithS+my5
4gudUr+V+1iPLvl85n7FJadQ73dZn25hput4T/HVbuz3Puv1ndQzpUpx7WnR
qi+5uC6+F/+k21u5/4oe+IHxlPcgf+YT74FerEdGr3ja/LGeHb0y3zXUZ7kX
+VBvex/0pb+1PuhVqDjNAX9spx4O6JeneNEBf+ZSHyfi36rY50T9t1CvfuQj
FNf3Yz2L+vXDX88qzj4j9b2ygXqeQf0yFa8agF+eob4D8DvfvzQg9XjkOert
wvk8r9uF+7SR+g/iecZXNgg/baIfBuX9iWxWvG4Ifs+mP4agx/OKbwwl1qPk
LM7LURw+i/dZv9Rh9JdtihuHcf6L9NMw/Mv6540gnpforxH47WXFyW75/jXq
V+uW+d/MVzxrcQH9d07Wc4n6O89Jv82/Qj964IdXFa/3IB76p9wDf7IfdmF9
DftV3IN4ybc80m/F7E8Zo4ifXDoq61VAv3aMwn/k86OIn7yM9SfYr9aOJfYz
+xj2Ix8fQ/8ia2PwF/n6GPLn/mle6Eku8sr7m05uBrsYf8ib2J8XvYn9P8WH
/sN65fugF+t5xIf3yT4f7jfrf8UHv1Cf1ePIh/ptG8c69a0fR/+i/u5x6EOe
w3qAz9/nl3rYuX+2X8g/jOegH/2O8bv8OJ/5/uZHf+D6qgkw99toMc+vmsB+
9HPfhMzXS/9fwvMpXL8zgPlKv2cG0M/o930B6M18ugPYj/X5MSD1vIf1tAUx
T5jfU0H4lfGXBfE88zsZhN+p/4Ug9Kd/bgYRD+fluhD8wnm4M4T3OQ/bQuh/
7N96COdzHt7A8/Och49OQg/Ov5JJxMf51zIJfTkvwhZz/v1tPc/5lxrGfSIX
hjEPOH8aw8ivQrE/jPnH+Xg1jP7J+fVARPrhB3JeBH7ivPwkgv5O9kTQDzg/
/4wgf3LyFPol5+XWKfiNXDuF+0UemoI/yLP/47unE58X0+gX5Opp1IfsnE6M
55dp5ENeoUEf5vOglpjveg39k/XYruF+k8ut51nPBqx3sN5dGvzPda+G7ye+
H9egH8/7S4OfGf8tDXpWKr4/ivodYP+N4v5XK86Nwq8fsh9H0e9rFB+Kol99
wP4cRT58fySK701+75yPYl4znj+s8xjvchTfJ8znXh31YP5rddSP/tyio5/R
z3Zrnf6vsd7n/TiuIx9+Lw3o0J/3SdNRH/KvOurJ569b+3H/u2J4nvcrLYZ6
M76sGPJh/EUx3B/qV4n3i5l/cyzR370x+I16hWKoH/X6OYZ5wPovYn2Jeq00
0O8Oct4YeL9W8QYD+tRx/hiIt15xhYH7+zHnkQE/HlZ8ykA9GjifDNz/zxRf
NOCPRs4rnBf5XPG/BvzbzPk1g3q0KH5yBvsd5TybwX7HFO+ewX6tnG8z2K/d
5P8AelVrVw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1MW2UYbQzzBy4aDYm4RMRIDC7ToCaTP5jXaMQZEhk/BtM6HWMdbCoM
ZTLADRAcw42PrWwrMAa0QPnqCi3QlhZub8vcj87EaCQajGDismTELMtmyH5M
+56b95CSADl5733e53nOec5zny8uLzj4iMlk+iP+K/+rnwJf2pa9d15+y0C7
xHtrNdYi4r3i9fgPsVYsLBbLzUKel4l2/b6TWJSLG7FY3ubzlfI8k/FXq0S3
zfbMh3z/uFjf7Uv7SOH0OrFWk/KKmfFOiueab+/+WOGsBhH/W7+P8RvFsr0i
9InC+U1C1rOf9zWLoznJhcUKV5yS8V0HeP9pWW/KQYU7WoUrd63GwnzOCF9a
8+1DCrvPihRX7v4y5tcu8dphhUs7cP4Z8+1Evz5XeKNTJMcTLmf+52Q9pqMK
t5wX/2aa2ytZj1XkJC+/8JXCqV0i3g5fFevrQn++Vth5AflWs96LwlGR01qj
cPYl8FHH+m2Sr9g3Cl+3yfePnGQ/utHPEwoX9QhzPADjpfeiPt5/q1fm8xPz
dV8GP6yvug/9IRZXoB/Wm9SP+F+yn/2ITxzrB/98PmsAemI864DUq4f93RgA
/18obB6U/D4gP9qg7K/9iMIZdjxPPlvs0Af5XreLyP3MFeoh3wE9US9eB+aH
ekodQv9LFK4bwjn1tzqEfKnPd4bBH/XrHJb9yyHeOoJ+fUp+gTOJfxkRL8Ub
yHnIdkJvxL1OqZ9sYtMo6iMuGZX9NRFfHwX/xDvGEp/vGEuMd28M+iEuGkd9
xMFxxGO+6ROSXwtx0wT0Q3xrAn7C+vMmJT/LxO5J3Mf+pbhkv5PZ32oX5oV4
xYV+kA9xFf5GvhxXoQ/iJDfyIb873aiH/Je6pf5spQp3u8E39RJzy3qbqaeH
xjn1ljWFeacei6egR/qFdQr5U7/XplD/pr6nwBf1v30aeuB8mKelXs2cn7Zp
6I/zqU2jPvrJ3WmZzxOc5wwP5oF+sseD/I5zPjyJfhDwiNr4gNNf1o3n6S9p
XuRLf8n3Yp543mhgxvN6US/zuelN9JfUGfgX639/Rt7/A/tVN4N5YL9dM/Aj
8rU6Az7J91OzmOfNeZzFvFG/x2ZRD/eT08Dcb7/Pwq+It86Bb+63N+fAD/dZ
xRzy5z4bnIOeN+cZ7yczn0d9ifsr24f5YP6Hfbifeu31QX+s90cf9gn1aPKj
H+zPa37wTf2V+OW83GE/L/hRTwX9wY/9Tb098KOf1NuOAPRAfe0LgN9j9I8A
6qW+9ADmj/q6F8B9tQq/OA//oV6K5uX9fdxPrfOor55+A2xvUPgf4/xb+k8Q
500KFwSxT76jHwUxn6cUng0ivxb6UxD+1arwthD09j39KoR4ZxU+EcLzbfSv
EO5vV/ivEPTdQT9bAJ+dCr+7gO+Nc/S3BfT7vMJjC5h3K/1uAfoifnwR80os
FhPPK4HziB2L+B5i/F8XoQ/en6QhHvN9VsP9rGenBn5Y/wca5pP9KdUw36cV
bsD7K+x3t4GbFfZo6A/5ixnxyO/fGvRMf3mowT+pl6fDwNRTVhjPU2+7wuCP
flMcRn7Ub20Y88hza1jWX0X9TobBF+Ndw/uFvO9PIz79cSOM/UP9PqmjX8x/
u477WN/bOu5rpL/r0AP7UaWDP/arTYc+qOcRHXqkfjVdxP/Ws/+/6cifer6r
Y37PKPxYBH5IPjMiyI9850Sgb+phTwT1Ur/lEfgF9dQSQT3U20AEeuziPolg
Xi8q/LPx/CXulwj4tym8JQp/6OG+ieJ7s1fhN6Lwz8vcP1Hot0/hsii+t/q5
j6LwzwGFe6K4b5D7KYr6HQrfwHnuEPeV8f6wwv9F0Y8R7q8l2X/TqMKvLuF7
aoz7bAnfK+MKH1hC/ye435YwH5Nx/D+WFnsH
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm9Mm1UUxhuz+WEajYZENBFnthg0alCSyRfMVRfnFhKBDzoTYiL+CdMP
4BImA9wAwTHcBmzAVkAGtOM/paWl/6Dt27dlw1gW5+bmJnMw3WICMYsRs+zD
tPdpzrNgE0p+ee977znPec65fbq4tPDj+ywWy9Xkn/4vn0u2stz6Wy+8lqLt
Kjs7232P31O5Gy5tahA2itVbS5VtZMsupb+/Flalyp/R8BnZ2K0+T25AXixX
zxY1v36A7+/FeeSN1TivkfvtV51Wq5WcVavPTzvI/esQDzm/Xq9/vInnNej9
bOSyA6phuSDnG55/UD3VsHyO3NKkksvLDjGeQ9jvsLDzsKpKc5whq2adf80R
4ZKWtZzVivi5/narWinw93B/4yie8/zGY8peltvEePPboCfzS29Xul7UY7Fd
r99A/YY61HwikWB9yo6rwuQGrGfOCeT/FfO3qjTHtqVa4Tkrzq+hHp2q2VzN
3C+8swv5f0l9uvX7H1QL/9GtktvdqaRe36p/Moua9wpX9KC+FdTvpI7Hv0d4
Xa+uR0E59eyFX8iJXuzH9Vl9iP8L4bY+5MfzbvchH8ZT1I/1VdS/H3oyn802
1J/caNP1ymB+KzZdj2Xul29XsdXMBZ7nseM580s/hffJ1adUUbNZzngXwavM
Z+vA2vyGBqAH+cFBlbT/i+Sy//GFQV3/PHLOEPIndw8hXrJlGOsZz0fD6Afy
3DD0YPzPjyAf5tsyAj3Jf4+gn6nPzlH4m3rPjCIe6rlxDP6k3vVjyH8f/TSG
/qX/8sa1H0z60zkOvenfNAf6lf6ucEA/+n/Bgf3ZH2oC+XI+2SfwPvtrnVN9
kvyw/7Y44Vf2Z4lT7/cw+7kztZ79nnCiXzgP7jrh/xb61wU9WoWLXVrvW0fp
Z5een++2CZ92ab+G2ulvF/rzuPBzk9D7BP0+qfVd3yl8ZBLzhM+NSZzP/f6a
hN48f7Mb+TYLv+NGPsy30Q39qE/QvXber7jhN9YjwwNm/fI9mB/kOg/2Zz09
Hvib79/0ID/WM30K84/n7ZjS86eS87B6Cnqyno4p1Ofe/TAF/3L+PurV8RWx
flvBC6zfHi/iZf2GvHq/m6zfFS/0PcZ+9aG/Wb9XfSr5XdPB/vUhftaj34f8
rOxnH+rbJXy/H/XvZn/70b89wp/6Ec9J9rsfevQJn/Xj/rSx/wN6/yG78MsB
rf+2Ac6DAPQZFO4IYL9hzocA+mVU+E4AfhnjvAjCvw7h94PQY4LzI4j72yVs
BvX8yHZzngThL4/wM9OYR17Ol2n0n1+4aRr5BDhvpnF/TAv/OY16znD+zKBe
YeHCGcQX4TwCl0eFvTPQw+R8Sq2PCT8Rgv58nhfCvDGE94UwP3meMwS9GN/1
EPzF+NPCWO8TfjOM+5V6VIS1nyzUaySM+496LoR1/zio90MR5Mt6qIh+v2Zc
eHcE/cL62SNr63kxAv3I6wzoy/efNKAPeYuB83ne2wZ+/zCeEgP1cgrXGuh/
xt9pIN9JYbeB/Jh/As8rp4RvpN6nP+4a8Cf98VgU/qG+WVH8XgoKb4+i3+iP
4ijup5BwVRT1Zf3aosif9R2PYn7SL6ejqA/9cS2K+RLn/I7ivpwVfsTEPDjD
eW7CD3PCb5hY/x3nu4n9vxcuN9G/Cc57E/6bFx40ke9Zzv/UeT8IXzaRzzne
Byb0+lH4gRjm03neDzHMowvCuTH44yfeFzH46aJwaQzx/sz7I4bzLwv3xXBf
XeF9klr/i/D5GO578koM82FBeH0cfrvK+yaO+v0q/Eoc8/Ia75845sei8K44
fl+Q6+LIf0m4K7X+Ou+nOOpNno9jfv3G+wrsJv+L9Zt+5/01i/qQX5qFv8g7
ZuH3G8IfzsLv5OpZ5Kv5P8HcnEc=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1MW2UUx3HZ/IBGoyERTcQZF4NGF5Rk7gvm8SXOLSQCH3QmjYn4EqYf
wCWYuS0bIHUM3QobbONljJcChUEptJRSWnp7WzZUmOLm5iY6UIcYyNwWUIJx
s8+/nj/RJnDzy733ec75n/85z304Nz/nnVUJCQk/xP70VX7z2b6UQ9eefC5O
m9UfqRbbCr+uEi+0XCMbuWpXknPTYd7fpl6e3llFVvnqIevcBNnYrvSlSniq
UNXW1NxPTvhI2czFVPLa3Soj8cIjZLVXx3M3Oa1Y+VKscyvrl6j09HQ3OatU
vRv7kaesyl6QkUgu2Kf3r1nJb7+OP4lcUa7jLapkPJ+pyGLqZIWw6wDiIyub
vm+xCedVqMcstufJaZUqx5eyhs8vVaoPYguQjUM6fwf3Kzus4y1nPFlVOt/3
GX9yNfRaya9axcJfz/UcR8AHmO9RcLnwxmN4fx/zr1G6/qXCozXQo5h61EJ/
8tY6ZZ3L9pVQn3rkz/dn65HvJ9TruN7fyf12NGh/ZO+nfieUc9P0MuNb3Yjn
P6WejVrvFj4/Fmeul9aEeKzCVU0qZs/pj6l3E/JjvJZm7eeCIurfjOf3CK9r
gZ/JZS3w/17h+Rb4n3pk2REP1/fYkQ/3T27V9X6N8e1uRX7UZ6oVepUJv9iG
55mvow3PU58727E+9SloRzys97l2xH+Q9XbAv/RjvQP9R78ldGA/+u3tDvQ/
/TXaoWJyBdl/T3Tq/pqppj86Ef9R4YVOrH+MfjkJv9UIB+JcS/90oT51wqVd
WK+efupC/OTMbvTLcfqrW9fvzQbhJCf6/QT95kR9yJNO9EMj/deD+2R7D/Zv
oh9d8Dd5g0vH20DOc6GfybUupS/N9KsL84J806X9upGc1qvGx8Yyybm9qAe5
qhf5kU/97/4S3h9j/I/3oX+ph6UP/qC+B/uUxWYWko0+1JP63ujD+nx/nVu/
f5r6vepG/My3zI16MB6/G/W3s1/cmGetwikezMc29o8H/UUu8cDv7ewnj/b7
TofwjAfzo4P91Y94OoW39KO+J9lv/fBbl7Az/nw3+68f+juF7/Vi3vawH73o
J5fwh17o0cv+9KLebuFLXuTnYb8OoJ/6hZ8dwLzxsn8HEI9PuHkA+w2ynwd0
vRb9wrf74McA+9uH+geF3/Ppfs0Isd99OB8N4TM+6GOy/wehd0T4afD6Ec6D
Qbx/SvjIINYf5XwYhB6fCy8Pwj9fcl744f8x4Tf8mCfkCj/0Ghc2/diPvOCH
n88IPzqE/Mlbh+AvcvkQ+pMcGIL+5KtD6Afy2gD6n/vlBPD9wPhKA3oeWL8Q
9gbgP+Y/G9DxplOfB4LwPzkziPl2WnhP/D7fdwUx38g/BbE/9Uwahl7kl4bR
L+Qdw5h3jK9zGHqRJ4exH/muEOIhqxD6g7w9hPqS7SHoTT4f+q8eqw3ER37Q
UPrC+m8woBf5FQP1JecZiId6Fxv4PiPXGvAP6+OO70ceMzAfWc8rBvL/ivMW
+0+Q7wtj/a85f8Po9wnhzWHMg284j8Oo71nhXWHEc47zOYz4vxXujt8/z3kd
Rj9dEL4cht+/4/wOQ9+LwveYmHeXOM9N+PN74RdM5DPJ+W7ivPpRuNDE+pc5
73HfOiXcbqJfpzn/Tej1s/BFE/77heeBCb2vCN8RgZ9+5fkQQbyzwhkR+Pk3
nhcR9NuccH4E9Z/n+RGB/64KN0XQv7/zPInvd134bATz8QbPl/j9BeE1UdR3
kedNFPX4U/iZKObdEs+fKPy+LLwtCn3/4nkUhR5/C9dF8f11k+dTFPEkXP+X
x6PwyyrhGawfvE34VhTznpw8outl8v2nRuAH8pYR1Jf81gi+d2/xfBtRsf9F
mv8BgyWclQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlntMlXUcxk8GVkiaRUltES3WyFWj2Mp/aL/KVTq2lD+sNtYWFdP6g5Mb
jZSVMlnElIsCykXizuF2OHAunHM4B97znoNQocs0KcOJLskGc0RRxJp1fg/7
Pi42YJ+9v8v38nyf9300Jy/r/TUWi+VS9Ff/l58/U7M39C889eIqbVPzO71J
t/gttT/B/irZyFFt1ozSW8/3qPBS6jRZ5WG9g+v3qieyy03yTL56pHhu5wD3
f6K8ScVz5ORCVVdbWzvI8z7Deqdw2kH12pV9CS6eX6Ryc3NnyTsOqalWa9DN
+4pVRtxUq0fY+jni5XrLFzq+l3hfRSnuZz7Jh3F+r7DjiCo3l1K7GV+5fp7b
Kby7QsdX1cZ4KxFPs/BypYqW50oj4z+qorhSL1xyTOl+1DKfKvSjRjixWn2U
EfdGFfOrRr2rhW01+r4MrrceBx8X3nICfIL512I/75uoxfl1rEcd4mF8b9ar
05OTk9yf3KCfl/O+6w3oF+NznET8R4ULGlW0HQvlrN+XOO+IcEwT+nWY9WzC
eWXCk02oF/enNWN9pXBVsz4v8xjr3ayi8ltiPNktOp5Gxmu0IH/mk9KK+FiP
klbogfnPt0IvJ9mfNuiD/XS1YT6a2K92FZXr0y3Che3It5X9a9f3WduFt3bo
/XHUk60D+dmE4zvRP+rP2onzeoTPd2p9Z/ex3zbEZxdusOl5+5DzaOnCc87f
e13Yz3mb6NL1Gee8PNmt43mM81TRreubPyT8R7dKT093eqmXHsybTzjQg3n3
Uz+9mIdh4UO9er5sAeqpF/0JCmf26XrayY4+rdcpcoJdReXiJRfYoQfytB3z
yfNVP/TL+9v6UV/GF+PAfcznOQfqxfx3O/7vP3UO+B39ZNKh9bqP9b7pgH+x
H2kD0Bf7lzOA/ndRzwPoV4fwqQE9D2epn+UBxEd9bR5E/uTsQdSHXDao9D/u
NwZ1v9LJi4PoJznFif6Tdznhf/S3EifiJ/vBD1LP807ol5zkwvwynx0u5Ed9
F7kQL/N3udB/1mfWBX3RjxPd8BfWc7tbZUUPpH8XuqE31t/uhp+wPzNunEe9
3+tBf/j+2OrBfLLfH3tQD+rd5sH91PfF1fXUT/wQ/J/6emEI9acerUPwkxHh
Fjw/MMp5HkJ8hvBaL+YlxPn2Qi9h4Q+8mM8I592r9bBlTPiMF/ed4vz7wOPC
z/qghwn6gQ/9/Eq4xgc/JU/4kN/Xwis+6P0b+oUf8zEp/LYfz8/QP/x4v3wr
bPox/2fpJ37Ed0748WH4yXn6yzDOuyBcOox4f6DfDKMe5BvDOP97+k8Afs3z
swJaP7Hf0Y8C2M94PAH0g/FeD+B+8kNB6JmcGYQeyZ8GoW+yI4jvB55/NYj6
8/6EEfgR43tlBPcx/4IRnMd8ukcwL1P0uxG8H5j/+lGtn3cu0v9GMY8/Ce8d
xTxfoh+Oov6XhS+MYp5m6I8G1l8VftjA/T/TLw2cf034dQP1+4X+aSD/X4UP
GpinOfqpgfzmhZ0G/PsG/dXAPC8IXzMwD4v0W8Qz/rvwphD6sUT/DSHev4S3
4Xns3/RjPB9fEd6/uv8f+vPq/pvCfSHcb/lN/DqE+t8mfDmE983twsshxB8r
vNGEfu8Q3mxC73cKv2zi+yVOONtE/eKF8018b6wXLjPxPbNBuNPE+2GjsGGq
6N8D9wn/aCKf+4UXTcznJuF1YejvAeGUMOY7QTgjjO8HnrcLPM378sLwx3uE
S8I4n/E1hxHf3cL+MN5HzO9cGPOwTng+jHqxHrERnY/lLuGkCPyK9Xw+Aj2u
Fd4Rwf3kPRHMH/tRFMG8xAjXR/A+Y/9cEdR3jfDpCPpJno2g/1z/L9ZbeX7i
GO5nfM+MYT7Y7+1jqCfze3cM+mQ9Csfw/tf1+g/j0ZhZ
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVl31MlWUYxk8GtchZFiVaIiY1ctUoNuMf2tPHMh1byh9GG2uLjGn9AbnR
SFkpg2WsBAstPkS+vzkcOAc4HM6B97zngFRgWSZpmGKTKMiQwMgWdZ7rdF9M
N3f22/t83Pd1X/f9vqxPTU96fZnFYjkf+K9/5d+6vKntAzOPPh2kLeqthLDR
JX5ZhY1WZwwKG6nqhfG94Sf4fLfaF249QVbpKskZmTfE9XuU/vlc+GKmChy/
YWn/O6rAnI/hfVHZON/H895TaWlpE4Zw7AG9v7qP5+eokeHhRLfwtlwVbt08
3sP78vT+tG7hjPdVTUZCPtnygQos3+sULsxXKQVmJvdHfYj8XcK2j1QgvTd7
GV8B9nP9rkIwz489jPM6hRcO6/hetTP+j7V+m9uFD34CfdqYT5E+73qLcMQR
ne9wE/M7ovUqahBuOKp88zEpdcz3U1VSXLy6Rjj+M/18rJL5F+vnxceFh4qV
9sMx6lGCfEuFk0t1PfeXUZ8yNb3dWc71k2UqIJennHodQz14fla51j+M96vj
KnBdfJVwSAXqVU09KxAf4x+uQP611LdS+y20XrioUt+fQD0WKqF/o3BKlYqL
i7NTP6NK13emWTi6WgXs91gr61GN/K3C03huXapPjX4+ZRN21MDPHaxXLfJh
vbNroZeD9atFv9Efz9WpazEpd9A/DXXq4ZSCZ+jP5fXwI/2WUQ996M/T9dCf
/oxvQL3ZH2UNWo95D+vfCP36hXc2oj7st6Ege4UfaYIfyYVNqK8pPNeE+9m/
yc06nwK/sLtZ5/vSUr+3oN85X3JbME/Iky2oH+dFYqvWL5LzxdaK+8jhVvQX
502WVemfL4THrJgfZNWG+fGlcE0b8iOH2OCXYeFNNug/Qn/a4LeTwiU29NtX
9KsN55EXsX/ma/q3Hf45JZzajvp8Qz+3ww+nhQfb4c/v6O929PsZ4Y0dmAej
9HuH7udT3wsf6kB85+j/Dvj7B+HZDug/xn6wYx79KLzDjnpeYH/Ykd9FYZcd
511iv9gxv38SjnSgPpfZP+DxCeEcB/plkv3kgF6/CE84dD33T7G/OqHPb8Jb
O1HfK+y3TsyXGWFrJ/S4yv7rRLx/CN/VBb/Psx+7dD83XBN+uwt+WWB/diG+
v4TPdUH/v9mv3fDHP8JPdUOPRfZvN9Zbrv7PVcH1y4RPd8MfNwvf4kS/hwrH
OxHPrcJvOLU+ltuEy5w4j89POuGfEGFLD/rpJuEnetCPjG9nD/RgPkd7cD7z
Hwoy9boe5FnOCxf4d+FXXDhvmvPDhftYX9OF+Uk/zLkw/+ifh3rhH/otuRd+
PC+c34v3A/3t7sV8OCt8Jbiffo9yY/5xf5Ib851+z3Xjfcj7utzIh/6edMMf
jG+NB+vp70QP1v8s/K4H59PfNg/691fhSx74mfqE9+n8Tfr7+T7MH+qZ1Yf+
pJ+b+vA+of5jfdBnTnhFP/Skn1U/+vdP4T39mHf0c00/+pH1P9MPv9DPIQbe
L/TLWuNGP28y4E/6+UUDetN/uwzkRz8fMPD9RL+WGOhf+tluYD6GCQ8b0HO5
8GUD/bxCeNGAn+4UXuVF/60UjvViXtwtvMWLetwjnOrFvFwlvM8LfSOEi7zQ
d41wqxffc/cLD3pR/0jhC16dj3Od8IIX8a4XXmnivg3CG034N1r4WRPzkpxi
on4PCGea8A/PO2Si33lfvYn81gobWF9wn/BZE/NxtfCsCX8x39t9N+Yf7cP3
DPNP8MEvzH+HD/cz/3Qf6sd4DvqQH+Ot9OH7nPm7fOinB4W/xfMw8nQwHq4P
9cO/1CPSj/x4/pN++CtKeJsf/cR4dgeZ8eYE11OvUj/8zfwcfsRP/Uawf4Z6
TCCeOPK/fvx9RH0jBlBP6vn4APIlbx3APKP/XhvA9xM5ewB63hvg/wA0+pAy

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx69CV0iaRYmWSMkMDQ2l1Fq4T2qZjS3lD7ONtUXWsP6A3GiE
rJDJMlaChRZIxk/5IZwHdxwH3MH3vndnVIdlkqRhiqXRZKamZtaw+7yv573B
puy1z/f7fJ7n/byf58uDGVlpr91qsVhOhv7p3/IzEAymHrm48OkwrVVbo61r
viO/pMbWu2K/FTYyVOj54ADPN6u3UiJfDAqrLDVUm+35ms9v0c+nfiV8Ogfx
eG55R1nXjNwgx+Ur39WE4W8Y7z0V+r+A50nb1HMjedGMZxRqLvtSeN12leaK
nXSI9xWp10M/fuHs91XR+fUuk/d/gPsN4dJiFQq/qI/5fKjmhF7wCNs+UpGh
AnuYXwnYLZxZqtJLzBw+n7QL+fcKX9+l6rJTihnf+Bj58/4dn2h99nlZT5nO
x8p8Y3Yjfx/r263mhy5kfY170J8A6/1U53+Eeiz/TPdriHpZyqF3v3B/mKlv
aQWep/4b9yI++xNXifvZ/9FKlZycbKc/bJ+jnsPCuft0f4roJ/UF+kO/RVRp
/6TQj5lV6Pf3wsEqFbLnCDmpWoXSqz0qXFaNeIPUuxp++0E4vQb5k40a9OuY
cHwt7htiP2qhP3msFvn9yP7UoX6yA7zyOPtVj36R8+tViXk14QT7V4/+k1fv
1/lcJTfux/z8JBzVgHrJ2Q3afxfJgw3Ib5j9boTe5MpG1E+2NKlrCenTTgpv
asI8k/ub0D9yYrPW9xy5tBnz8rPwlWY9T3nkjQegD9l9QOlfp+ifFq3PcvL2
FswbebQF9ZNTW3X9c8m2VviB8aOtyJeca0V/ycNWzCtZHZz4fN1B7ANyhA3z
yvuW2rAfT9OfNvRzRLjCBj3O0K825P+L8LhN11/wK/3bBn3OCme0qYry8pm/
0c9t0HNU+FAb9P+d/m7T85p+XnhBO+Z3jH5v1/q8ckF4Zzve/4P+b4c+l4Qv
t2N//sl5sOt8yq8Ib7Dr+U6+xvmww09/CXfbVchub/7NebEj3j/CsQ6tV+O/
nB8H9BwXLnTo98/f5Dw5oP8tl/7ncw7oe5twTAf2U4Tw8x3Qa7Jwfgfm/3Zh
awf0vkP4dAfynSJ8txPzcKfwaif22VTht53Q+y7hRqfCa8InnJjPe4SjOlHf
vcIrOlHffcLZnfq+khjhmk7ow/PB8DnjTXahPt6/3IV9x3zfcGF+IoUrXcif
fDj8fJSwpQt+Y31LutDPacKburA/pgvv6cJ+YT79XdhX0cI3urAvmX9iN/Qk
v9yN/lGP0m7kw/dNnFsZ/0o39jF5Xg/8QL039qC/5OIe5M983T3Yr+QLPfA7
Oc6NfUBOc0+sd7sb+pGdbuwH8qgb+5L3z/LgfnKqB+fM/10P9CLbPPAL6z/j
gR7UJ7oX+5H6PduLfs0Qzu3FfNE/zb3w40zh4V6tV+Qs4al9eP9+YdWHeX5A
eEsf/D1buK4PesQKH+vD33dzhCMM1BMnPNtAvg8JLzV0PgVzhV8woE+8cKaB
/s0T3oZ4OQ8LVxj4+yVB2G7APwuEgwbm4xHhs+F8EoXHDdSzSHiGF/P/qHCS
F/UvFl7rxfdgiXCGF/59THirF/U8LlzmhR7Jwq1e+JPxDnlxP+875YU+C4Wv
e9EP5j/dRL/mCy8w0V/qsQrnxdQr3cR8UJ8cE37i+zvNifEbTOw76mOYqIf5
HDehL/W6bMK/5Ck++J/Px/uwD8gpYWb8DT70l/dn+bD/mN8OH+aL+Vcjfh7r
7Q7HY71Hw/F4PubD94zvT/IjHv0R60c85rPMj33Metb50d8k4c1+fD/Zv0I/
9jH7u9cPf7L/Dj/yWyY84Ef/nuD3yo/v05PCN/3oz1P8fgWwf1YILw4gnuL3
LIB4K4VfDSDeKn7fAoj3TIj/Az3Sfos=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx69CW0RR7ppoiVjMoWmRldIP7FFJxGgCa4SLapIxrT8kN5oh
K3SwzJVgoXZIBh4Kop4Hd8BxgNx97zC2TsskycIUS6MgUwIjWtQ9b/Z5N2MT
9trzfZ7P+/P+fD7P44ysdWmv3mgymc4G/+m/8mNL7M3rujJ30TglKd9wTM8p
8koVH9p9H9mTpd6ID33+K66vVZnFRu5JYbVOBX8XfMnv12P9C+Hzudh/gvvf
wvnHhaPylTko6HOe946aXtR/MiAcu0ltNNs+4/eezWCel1KojgcCgf/iFel4
3dST867Kzs6+RL2m97ReE/Mr2arKLJYp9CPqfVXUnxr3tbD9A+1P5mnqK1Zp
rsiibuE1Jao3z2z7hnq3w88zwiPb1bWYzPDvqP9DNSuzeHGP8JaP4NdZ5lOK
874XjtgBf84xvx3Q2ytcs1P7lXqB+e5SVTnxW38QjvtYxzN+ZP4WFTxu9KJw
p0XHe+An+lGm463qE87YrZb15pX+TH/Kcd4vwn3lKmhHfz/9+kR/b/5VeMMe
+HmZ/n0Kvb8Jh1To+mRfoZ8V8OOqcKBC680bpL+VWP9duLQS+4fod6Xuj8Rh
4cy9aiDVFXmN/u9FP5CjrdpPyx+shxV6R4QHrKrbmtNGTqmCX38KO6vQD+SI
ffienL8P/Uw+vw/9S07Yj/jkmv3oD3JYNb5n/JxqVWwMx5C7qlEv6o+rgT/M
r7xG1+d1+mE6oPXF06/VB9AP9LfzgPZrD/2fU4t8WZ+SWuTHeg7VQi/rnXEQ
88d+aD2ogr8L2C9Rh/S8JrOfCg/hfmC/9R1C/7Mfkw8jP7L9MPIhm23QQ95g
w/k8r8em5yGU8dQR1J9cdQTzSn0hdswb9c+3a/0m5rfGDv+Zf5kd9wP7OWCH
f/RrzI549DO2Dv3F/s2qw3yxHqV1KrTbeoX1OlYHf1jfkTrMH+s/ux71GWW/
1+v71fqX8LZ63Bd/s//rEW9MeLAe95PpqsyDQ3PxDcLp4PCbhLc4sD9E2O3A
+ROFBxyIf7NwpBP6bhFOcer8XaHCm53onzBhpxPzcpvwJSfqHy4c0QB/7hBe
3oD+miSc3wC9ZmFbA/TcJXy+QT0c/JksPKkR8xUhnNCIek4VfrMR99vdwjWN
iDdN+NtG3HfThcOa9PwNkxc2ob/uEc5pQv2mCO9tgh7G62pC/ow30YV5Zrw4
1/XxXnNBb5Rw+f/WT7jwPnK/qRn1pZ55zdjPeKubr9ezsxnnUW9ns0IZhEfH
mX7OceM+5vpLbrz3PK/EjfliPMON+4/6htzod+qf2YL4M4QzWuDPvcJbW5BP
tHBrC+Z/pvBlrIfHCEe1wo9Zwmmt2H+/cCHWk+cKN2I9/EHhvlbEjxWe2ob9
84ST2/C+PSL8dhv0zxe2t+F+XCB8oQ35PyZsPor8nxBeehTzFS+8AevdC4Vr
sW5Rwj3j+xcL394O/QnCqh39/rTw+na8r4nCVe14L5OET7frfnAsFw7xQE+y
8DQP6vus8HwP3kPyCg/eG/IaD+5v7t80vv8Z4bLx/YzvwLqV+gKIb6H+ix59
H+QsER7z4H5dJDzZi/eNfsV6cf88KZzkxXw9LpzlRf/HCW/E+vCjwqXjzHoe
9qLf+f0xL+ad9TznRT+wniNe9B/j32ng/qO+2QbyeUp4iYH+4Xqmcb3+XAN+
8vxtWI9jPtUG/KUejwE91HvGwPvEfhw0lP7D9Vt98J8c7UM/8Lx4H75n/HQf
+on61vnw/lL/Fp9+P2uYX6UPelgvt0/XfwLrecqHfNm/Az7Ua6nwBD/qtYzv
jR/vA/tnAdYd7K8UP/azH9f64dcKvkd+5JMqvNuPeUnj++THvD8nfNyPeUvn
e+XH/GQI/+PH+7GS71cH9Lwg/FCHjlfwIt+zDvz/9WXhVzpQ/1V83zpwf2YF
+V/GvHF6
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy9TKzVNoyRLxSRDQkMppRX1UclfWQIrpbrZxB8TrbjcaKas
1MkiVoKFFkgmgnIgnid3HHf8/N73juKPs63VcjVa0JZZkKGJERV1nzc9bwYb
uNe+n1/P+3k/z+OsjKy0LaMsFst34V/9r/zsiXCs+Kl33pIhWqUcK7p2D/Pz
qsDss5ONDPVa0rgLw98zlf57SVhl6fUxZGOnXr+e3Jmt1+8lW95QXbsjHOSo
HBXoi+kYPu8tdT3GOuln4fh9Sr+XbOxXad4ZueSUA/r7Z+TOXOz/Rdj2tgpv
30i2vKMulNuayYX5Khze7G6+5129v4DsfE/fN6aH7yvA/eRthbjvV773kD6v
nNx/SM21Fiy9zPe/r8Lbu8l5H6ieVO+x3xhPEfTrFY48rL/PuML4DmM/2X5E
n29eZbwf4v7fhRM/UhW2pPxrjL9YhZdn9wm3F6vwctt16lGiz9/xh3D6UXzv
pz6l2P+n8KVS6DFAvT5WJcXFxX8J7zqmcrtTvX9Tv0/UzNzuL/4RHn1cn9c3
SD2PI17Llf85dBz5v0E4vgz3jxIuKoNfbxTuL4OfRgtbT6iVYcONFTZOqPOh
0JqbhKPLoc/Nwnnl8NMtwj3lyP944ZQKvGeCsLsC8d8qHHkS+ycK55yEP24T
7jyp40+dLJx8Sr+vaIqw/RTq7XbhCZVaz7vuELZV6visdwp/VQn/TBVOtGu/
d0UKl9qh5zRhSxX23y28uQr5uke4vQr5mS4cV631GTdTuLAafo4SvlaNfMwS
Tj8N/90r3HRa6x2aLRxVg3xHCx+oQXxzhC/VaL8k3i+85gz0ihF2nlFbwz9z
hSMc8Ges8C4H+tkDwh1DHCeszuK984QrzuK8+cKjnfDHg8KLnLpfzY8X3uaE
HxYIlzihFznkRD4XCg864ZcE+vecfm8vOeMc+s1D9PM55Oth4U/Bx8j9WD9p
kXBsLeIhW2vhP/LBWrx3Mf1fC33JV2uhLznaBX+Q17nQj8h5Lt0/k8gNLviD
3OMaef8M98j3pbixnrzfjfgZn9ut8zVAPS668R5yZB38Rf1W16HeqXdOHeIl
O+qgJ/PTWYd5xXxO8eA7853sgR/ol9c98AP9ZvfAD/Trtx70F/p7Qj36Eevj
8XrozXqw1Y+shxP1mE/3sZ7r4RfWx1gv6oX7E704n/W23asSEhJcvK/Ui3xy
/ede+I33WXzod7xvoQ/zj/W22Yf5yHo74kP+WV/tPswf1teAD/XFeoprgD+p
54YG9BfqXdgA/ZkfswH/H2A+rzXoeBLohzmNmB/0S3ojvicK5zdi/yPsN42I
51Hhy42ox8fYf5oU0iKc1gT9n2A/akL8StjThPwuZX8aWr9MeFoz/JjMftUM
Pz4p/GYz/L6C/asZ/lkp/EMz+ukq9rMW5H+18PIW+Ocp9rcW+HWNcHUL8kHu
aIE/nhae2Ar/PsP+14r3kXe2Ir9r2Q9boTf561bUUwr7owF/kacbqHfyIgP1
nCq81oA/0tg/DbyXvM/A/CSXGNCf+12GrseLPD9kQE/yjwbyzfcOGvAH45vq
h37UI94P/anXKj/yS30z/KgX5mOPH+9hvor82j97mc8zQ+cvZ7/2Iz764Xs/
9KBf+v14H/002cT8oN9iTdxHPy4zsX4J+7sJv3N/ton4ed9BE/OC/qs0MV/5
XsPEexjPNyb0pN+umoiPeowPoB9Tr+gA5i31TQogP9R/XQD9mvnLCiA+5jcv
AH8/K1wWgN+e4zwJID/rhb8MIJ50zpcA3vuC8Jgg/PUi500Q77EKLw7Crxs4
f4LQ9yXhzCD028h5FER/zBA+GkQ+N3E+DZ23Rfh8EPnYynkVRP/bJvwv9u/I
5PxqQ71sF17Qhnp+mfOsDfq+IrxpaP2rnG9tyKctzP8BDL1g0Q==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx29N+4NcrnZbaIlY5tDUUAvpB/ZRScQogUqxqCaaQ6tx2nCE
TMG4ScwEFLRDIn4ccCCch3ccd3AH94vyj7PN5XI1W9KWY4O1atqaf1j3ed+e
N/M2YK997/v5PD/ez/thSVFJ/ocPGAyGX2I/+q986kJ3UhL/WrUxTtlqXewz
y7tU+E5KITlQpDISrnfOPt+v8j1JcxcIqxIV+11JDhxSzRbLgoXCN0vVEaP9
O7LhM/VPSmHd48LJFcqTZP7oCZ53TB3MSNi5SDi1CpzE84+rfbHPYuHcah2P
OZn3mdVkudG+RNh0Qn//1pO8/wul818qXF+rYumZnmY8JxHvMmHHlzr/p1IY
X52ymjJqlwsX16vC2IErGG8D4lsp/G+DrueNVYz/NPJ5VrjmjObrqcynEfVf
K5zYhPjXMb8mxPu8sO0s+rGe+Z5TWyfLG9OF07/S9Vj9IvO3qOWxgF8SvmzB
fRmsR7OyZ03e3SBccF7306JYnxZlns5L3yQ81YL8NrNeX0MPrwqXtaJ+Wazf
N+pKNBrdKjynDflsYz3boJ8c4Wgb+vE669uO728XbmzH9/NY73bUP1e4sAP9
foP170B+rwkv7UT82exHJ/rBeGc6lTH2AvPJter+J2QKu6w6vizWI7FL32dj
vSrAKa+wf11qsXn6Kuud2Y36vsx+dmM+2J95PdAz+2fqgd5eEL7Wg3zJ6TZd
fwO5xYb6UQ+GXj3vTvLeXuiBfLkX55NX9ul+5fC8+j4VK7+ffDv+nPEVXMD7
ZN8F3Md8kvsxr8y3uh/zz3pM9et676b+cgaQH+vnGND9K2d9jXbUbyP1Zkc+
7McNO+KhPtVF+B37ab2on5duoR4deJ/9T3PoeTJSH8WO+/Xa7ICeqaeoA/NG
vd5zID7qL3UQ80p9Fg3ifuq3cRDzni/87SDm8y3qexD6fFt4xSWtp7yd1Dv4
aoHwqfjzd6j/+PN3hf++BD96j/PgVDN5nlbyDif8n+/XxJ/zvhEn/IbxzTjh
j8wnyYV+Mf9cF/rNeh134X76gcul67+J/bnlwvzMzteQno/51MO2IfSX+qoY
wjxTv/Yh9JN+eXMI+dBfH3UjXvpxphv9Xi182I3z6ec2N+r3jPDPbtSD/j9v
GHrlftgwfP/+MA0jPu6XjmHUj/vn2rDW1598/qAH88L30z2Ij/cd8CAfxtPi
gb65b773IH/mY/BCD9w3a73wtzX0Ay/6w31z1ov8n6M/eFXsd2Wa8F0v9Dzr
FyPwL/rD++D57E/9CPLl/IfARs777fhz9nfZKN7nfBeMol/UQ+0o7qcf+0ah
N+rnj1GdzzTnO9mHeaLe8n2YX853tQ/7jfp0+9Bf7qMpn87fQD0v9MOvuI9y
/PBHzvdRP/YT59nhR33fFP7Nr+/zcH6MY9hPnO8tY4iH81Y2Bn1xvvvGoI9d
9Ls4c14fHsf3Oe9qHPUsFD40jnjI1nHkQ/5xHH7D9+cEoF+evygAf+P9aQGd
fwbj2x7Q9Uti/MUB1HuHcFX8fT5vDiB/vu8MQE+8LxpAPRjf7wHMC/3qXgD7
9wPhx4LIbzf9Nwh/3iOcHcT7e+nHQfRjn/CRoO53ZTH9OYh9f0B4IAj9fky/
DqI+nwj/GkQ8JfRv3Gc6KPxICPX6lH4ewv8XpcKbQ6j/Yfp7CPNeJlwawnnl
9Pv4eRXCPfHzjtL/4+cdE/4phPiquA9C2EefCz8Uhh+buR/CyPeEcEYY/lHD
fRHGvq8VLgmjfie5P8Lwn1PC7WHoo577JIx+NAj/EMY8neF+CUMPTcJzI5jn
c9w3EfTXIrw+Aj01c/9EoL8W4f0R+E0r91EE8bUJn48gn3buJ5xv7xC+EkE8
ndxXEcybVfi/CPTaxf01gXjIayagt27uswnotUd4zwT8w8b9Fv++5v8BOg5d
cA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1MW1UcxhvD/IBGoyERTUSMxOCiBiWZfKk5vkScIZERZVtsNsc2hE2l
Q5kMcBsIjuHGy1bYCozxUsZ7ubSltKUtt7dF96EzMRoXzYxg4rIEYuYixuyD
2vM05yFdwsiPe3vO/zz/5/mfPllWVXLwHpPJ9EviR/5W/+oznIX7/3zulSRt
F/n5+e4y8m7xd67lQbJeJtKvj1j38XmlOGJOv/6+YlElnmhZ20HWq0V0I/fG
XsUrNcJZuFpHNh0THcZGLjm7QfiyWtb2cL0T4hlLh0HOa5Tvj5P1JpHYfoRc
3CxW6zKc5JUWcS0ej5Otp+T+d8mm0yJRbgH372wTJYkCNus5IxLyrJK1s3K9
os3zdoiEft+QKzpxfuqT1yXKy8tvkv/pwvqbep6TeudT/9bzOD+52IbzHFCc
2S0SctQc5Pm6UU+54vEe+f7zH/C8F8SbiT9UKC64KPffUsnz24X8/5Diq0k+
TD168f6Hinf1YT0+z+4XvXa7nevfAj/KerRLYn2Hb4DnqR2Q/XqKeojLqf1K
GxQJe5kt1HMQ/dutOD4o9SzfSX2HUN+7im1D8G8J9R5Cf8iWYfj3Heo/LOvL
KlWcM4L9uH7rCPzK/ddHUP977I9D9vs71utxSP1O8jyZo+gH/dEwijzw/Cuj
8AP1ef0K/MD+jl9J1fP+MZm3nXxuHYP/6Y8fxtA/csG49NNhrt8PXtvM9wTO
Rz4wgf3IVyegB+t9dlLOgw5y5yT6Qf5rEn4k75qS+X2VHJyS/SgkZ0/LfO0j
N09DD/KtaemHELloBv1mfdqM1NNCznDifXKtMzVfN8BuspiF36iXYxb9Iadp
6Cf13qZhPfajQpN+uk3u1eQ88TF/cU04rOY25uNfDXoxf3lz0Iv5K5tDPcyX
bQ7zifn7Oskf0d9z0PdjxVtdqI/vW1zQh/u1u9Bv1qu70E/qcceFPNOvOW7o
QT+XulE/n7e64Sf2J+DGfOJ6626pn4n6ZXmwH/cv9sBv1KfJg/nOej0enId6
3PTgPuD5Mucxb3n+t+ZRbxXzNg//H1HsnMf8r2b+5uG3TxU/7MV8O8o8ejG/
PlN81Is8H2M+veh3neKfvehHA/O6gPx8rvjlBdR7gvldwP15UvHwAvrVxDwv
4P75QvG9PuSlhfn24bxfKj7kw3xoZd592P+04m99qO8r5t+PPJxR/KIf87Cd
88AP/3Yo7vGj352cD37k+Zziu/j8wHnOiwDyYVO8JwD/9nB+BODHC4qNAOq5
yHkSwPnsip9ehJ/6OF8W8f2kX3Hboqw3/RLnzSLmAfmPRcxLvp8dhL5cvySI
ellfcxB+4Xm8QcyfLs6nIPxCvR4L4X6gvkUh5Jn9OB5Cf9k/LQT/sd+/heAn
+iMjLPO0QT+9EcZ69FttGHmlPyfD0KOG8y6M89LvDywhv1bOvyQzP9VL0Iv5
cizJ89mYvx+XoA/nVZqO/pAf19Ffvr9Nx/cf8ts67mOuX6HDn5xnjTrWZz29
OvzIet3Yz8I8x/XU8/2e/PwnnLc69KIej0RwHuY7L4L6qN/2CN5nvssi0Jd6
10ewfj3ncwT+Z75nIvD/cc7rCPrHfv4awbxv5PxOvs/+P2TgfeZ9q4H16ZfX
DNTPvFsM+PeU4hoD84l5b8d6NW2Kxwz0l/7UDSF/nVX8E56b6ec7BvLJ/N8X
RT6Z/5wo5gHzYI5injMvpVHUz/xXRfH9q5v3B963M29DUfif8yAQxXzkPPge
n7/NvK5HUT/nwZZY6jzIiqEe5v+lJA/w/knyZcWVMeR5kPdR8vmQ4r4Y6h/m
/RSD3g7F12Lo3yjvqxj8Pqb4P6xvm+D9tYz8TSl+YRn5meF9tox5Nqt4/zLy
pvF+W8b3Z1eC/wfuj3tg
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1Mm2UUhhvD/IFGoyFxmogzLgaNGpRk8gfz+BF1hkTgh5kJMRE3hU2F
oUwGuAGCY2Qb4BiugAxogfJVSltKKS19+4FTU9TplGxBB34sSyBGjRiyH9M+
d3NuUkiW5cr7vs9z7nPuc07vLyot2HeTyWT6Kf5P/y9/b8b/9v316NMJ2q1e
XKlK2+RXVeqi5c+9wkaRir9+lWwqUd70xlWyKlUF3vRt/N4oV/HjHiMvV6jk
+w6rlvC6jbyjRiEmnndURdYzCsmZdWohFouRjXpVnWZ/4S3hvAY8Jy83qvjj
14uFy47h/BLef1zHZye3NuP9/YznhMpJXXzggLDjJPJBVi36/vNvCxe3Qs87
jLdN57P9XeGNNp2fxlLG/4mOp7ZMuOk0nh+knnb1b0ZhS7nw9jM6Hst71HdG
LVrKAu8L2zp0/CsV1Psp6vGBcPZZVRgPkO+bzLiP539hVtaynFTG09qJ+6ln
T5fm28k7upEf6rvWrePJoT7HZ6gfz6vsgV7qU+eQL96f0qvua1y9QH3FvYif
emK9qnE1P/sQ89uHfPB5e5/+Pp/6Nvqgh+cV9quH4gng/UZ/cv53WuAnxt9k
QT9Q35oFfme986zwG/3gtur4vPTP9gGVlZXlor9qBvCcflwegH/o1+cG0V/0
t21Q52+JfOuQ1tO86echfX4W77s4pA7GE8J4sm3Qx3p121Av6jMN437q3zuM
/tz0w7D+3sR8PjKiOs1mM/PdOoL+pr/+GYG+SvplVOf7mSph/yj8Wk3/jCH+
D4UbxnD+EfppDPk+Kpw7rv2SUUd/jaNe9cJpdtz3Ef1mR/0bhJfs8DNZTcAP
ZOsE7ienOOA/8i4HzuP5xQ7MD8bT6VDx9rvOeGOJ76nnhgP1of7MSdTnsHDR
ZHK/tk9q/QeY/88nk/27ge9NrOfDTvifXOhEPVnfU87k+WI4k/vvbyfiY7/s
dEEv6/2KC/3N/mtyab1VjNeH5wHWf80FPax/uhvxUX+eW63le3tqhOvdmE/0
g9ut+yuX+bzqRry17K8pxMf6vzSFfLE+NVOYJ6yffQrxf8z+m8J5x4Tv9Oj6
332c/eiBX5qFD3mg5wT704P6nRS+7EH9T7Ffp7Weilbhp8DrbezfxPPTwv3T
+L6d/TyN8zuEb/ZC71n2txf7xSy836vzmd7FfvdCX7fw117Mzx72/wz6/5zw
EzOY132cBzPov37hjhnEY+V8mMF8HBS+PoN+GOK88KEfh4Vf82GejXB++KB/
TDjsw36xc5744C8+f3AW9eV5e2axr3l/c4ItnDez8Fev8B+z2BfUu8MPP/B5
gR/5Jzf4Mb+ZD48f+WE+rvnxe4B8TwB6eH9uAPuYfCSA+5g/RwD9SP4lgPlJ
TptDP5Kfn0M9yJVbeGQO+4O8NAf/k28LJp+vgph35PIg8k22BqGX/GMQ9SSn
GJj/5HsN7Bfyri388pb3iw30N7nOQP7InQbyT3YZ2n+mAc5XA/GRfzegl3wD
nE9/3BVCfsiZIexT+nV3CPpsnMch9Dv9Vh2Cf8ntIcw7+nk8BP+Pcl4nmP69
EkL+xzm/Q/j9QL/fEYafJjjPw5hHk8LPhqHHyfkexnxyCVfg+QU3530Y88Aj
PBRGfqc5/xPve4UvhbGPfdwHuN88K3xLBPkIcD9EcN6ccE4E8Qe5LyLo15Bw
KXg1zP2ReB4V7sN56/PcJxFd79rzwt9HMP++5H6JoL+/Et4WRfwx7pso5tuC
8JNRzIdvuH+i6PdvhUui0Psd91EU/XpRuCuK+v/A/RRFfIvCC1H8PrnEfRVF
fS8L/4f7qpa4v+bRHz8LPz6PelzhPpvH+SvCb8yjf37lfptHPL/F+X+O6Ia9

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcx8nECk2nYwvbIlqsUatmsZX/0J7KRTq2gD/Mtltb9GOYf3C5
YQqkQFwiJaACdoDIb45fx3G/uDuO4+57h9VCl7MkCwtsMhdUSmJEpd33TZ93
8zaOvfZ8n+f5/Hh/3t97KCcv++0VMTExF6N/+n/5vJcWN7Hv2hPPL9NWNdFm
HCkgv6ZSU1MdhcLBHHAR13fi+Q+EVZ560DR7dj+f3608iabZA8JT+epGimFd
CffvU6bZrM2lwklF+vO7PuR5B1Q0vLYy4U0lKryQMmni+aVqLsuTeFA4s0y9
E/2U8z6Tmi6Itx4SNh5U1vTppQref0gVxlvTPxaurlCGKi2fnPSJyo4GRLYd
1vcXkFWVnn8aObdaj6eJ5286oqL1fZX3Lx7BfsYbPKqi17/BfMqPqSptIYX5
Z9bo69PFwgm1ev2qWN+pWr0fqeyHpQ71Zz+Nx1GP94U3f4rn9zJ/M9b5/Odm
xM/+V9ej3uz/jgbUm/1OasR+xnOlUZ0eHx8n206odmNaBZ/f24R6MV51Evrg
fSubVb3ZbGY8uc3oD+Mdb9b7s7CH9W1RUXkYmV9NC/rN5xdbcD7PM7Sivv/r
uRX7GU9yG/TNeMvboBfmM9emHjVUvcB+ZLajH9Szs13v9wT1nNCh6/dh6reo
A/ex31MdmJ+PhLd06nqLpX4tnXo/s6ifNV2368vYpdd/hvr7ugv5HWa/Lbiv
UrjRgvyq2P9uff1qtfBb3dh/lHro1vtvOCb8eA/yraE+evT59dQKX++BXuqo
l17067iwvxf5mamfPl0fcfXCZX1Yb6Ce+hAfOaMf+mqkvvoRzwnheKve/yeb
qDcr1smTVswzWQ3Aj8jtA9Arz1tpg17Jz9jQf3KuTb08XVBDrrehfjxv3Ab9
kG/aUI+T1O8g8m8RzhnUz4tvpZ4HoWfyqUHohbw4qN9nIT9mV9HvYrLBDv8h
V9qhR3LQjvry/nm7np9GTnYgP/J2B/RELnfo/cgg+xzwc/KcA/UgJzpxPznT
iX6RS52oL9nphD+SZ5y3x5Pggt+Rt7ngT8yvyAU/J1td8FPylAv1aRPe4IZ+
yVvceB+1C+9xQy8dnE839E/+zo37OjmvQ6hHl/BzQ+i3hfM7BH8itw4hn27O
8xD60SO8ygPu5Xx7dH/8rE/4XQ/8p5/z7sH5VuEzHsRv4/x78T4YFH7aCz+3
0w+88GOHcJ0X5zvpD1jf6BZe8qJfQ/QLH/TrEX7dh3hd9I/ldd6n+dDfAfqJ
D/omPzKM9wHj3TGMfnJ/xbCKfhczPv8w9MD4fh3G/DC+JD/8zSuc7ce8+uhH
fuTvF3b70c8A/Qn7J0eF7x/B+z1EvxpBfcLC+0dwf4T+NYL7TwlfGlEoK/0s
AL//QvilAObjS/pbAPmPC/cE4G9n6HcBzNtXwmtHUf+z9L9R9Puc8O5R6PMb
+uEo6n9e+Dz2p39LfwxCXxeEHwjCP7+nXwYx3xeFXwnCv3+gf2L/rinhEuyP
u0Q/xX7rT8IO7M+4TH9dvn9G+HIQfn+Ffrt8/8/C94Vw/yz9NwQ/+0V4awjz
8Rv9OIT35VXhwhDex/P05xD8/Hfh/hD0u0C/DkEvfwj/GML8LNK/Q9DLkvB6
DXr9m36uQS//CL+oYb5u0d816OWO+f84X8Pv5RXClRr0slK4S8PvhVjhoAa9
3CV8QYNf3yM8r0EvccKrw9DLGuHkMPq1VjgtDL2sE94ehl7WC+dh/8wG4fIw
/JfrLWHEw/2+MOp/r/C55f2rhefCqBfji43gvLuFEyOY31XCz0Ywr6xHZgT5
3im8M4J+sJ6lOG+C9W6IoJ83+X6KoN7s12nct/Evvq8i0MOfwrciiJf9TxhD
fjeEnxpD/NTPtjH8Hrou/OYY9ED9FWHddC3K/wJ6ip0c
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlntM1XUYxsmhLXSWRXlZIRYzZFpkrfyH9u2yTMcW8IfZxtqicph/QG40
Q5ZAkEjKJRE7iAoc7pfjOZzD4Vw48DsXlAptpkk6SnFFFFRGaMSadr4Pe5+t
szH22e97ed/3ed7391uTkZX27oKIiIjvw3/6v/wsm8fm9v254YV52qI055Pf
UOnlgZsFwkaGcsUUTxby+U71flLUyMfCKkuNmLN9RVy/W9WYTKZi4Ws5akf4
9wn3f6jGcqOf2C8cm6efj5PVPvXqWG5ViXBigXo6/DvA8wvVunCA5JQifX9S
Ke8rVuHwW8nZ+1WaK2bhp7z/gDo7PJx8ULiiVE2luk4cYjwHkX+ZsPUQ1lcw
vnJ1Kz793nLhzArkx/2JlWpvtGUzz5+txPm83/gM+8klh3X9cxlvSpUK3owf
ZX4rjuh84snXjuA+1qe1Wp9XzvplH0X+rPemz3W9LdQjwoTn1GvIhHpTz4oa
FRUuKPXefkzX+0X6IbYW8dMvE7VaHzv9ZD2OenP9nhM6n3Sep05iPe+LrMN5
jC+zDvcz/uE6tbp48jzzS6xXxZOpm1iPqnrUl/WbrVeN2UlRrH96g9Yzh/oY
DfAb9Y0zIz7qW2LWeg9XCk+Zkf9h6tMIv1cJOxrhz2rq1YR6HxXOa4J+JurX
pMLtY64RfrlZ82O11LMZ+RwXXtKiOeYk9W1Bf9UJX2zR+kU3UO9W+MEsXNsK
PZqofxvq0Sz8Thvq0UI/tMG/bcLr2+GPdvqjHf3XITzTDj910i8dSv/rEu7r
0HqU8nlsJ/Tl/qJOrOf5E50qfP1brcLJXVpvF+O1diFf5hNtQXzMd48F+1mP
UQv219N/pxAvufEU8idHWqEn9z9r1fHlkzOtyJ9cY8X8JA9boSfjuW3FfCIn
2rSfU8kZNpxPrrJhPjYKn7ah35nvrA3+ZD0SuuFP1iu9W+t3hvqVdeM+1tvo
Rr7UY7ob88fCfrCjvlbhbXb0q439Ydfz/3W7sMeO/B3sFzv87RSOccBPLvaP
Q+t/wy1c6IDfveyn+fU+4XEH5nE/+6sH5xvCW3uQX4D91gM/hYQtPejHQfZf
D/r9jPD9TsyLL9iPTvT3l8IfOPX7b9cw+9Op+2/lOeErTujxNfu1F/U8L/x8
L/r/Avu3F/P9onBDL/rjEvu5F/PtO+FFLuh1mf3twvl8/p4L76dv2e8uzItv
hM+5UD/GG+GGP74S3uhG/Yc4D9yYD6xXtfv/9R1yw58DwnNu1K+P88KDeKn3
mx7MHw/nhwf1p94BD/qT+2c8qC/1XuvVeubzvu1efI9Q/1IvzmN8fV7oERT+
3Yv+YD6xfdD3tHBaH+rN/IvALvrBifVJrNdEH/qffljlg19Z32Qf3lf0w0c+
zCP6weqD/6nPdR/yox+i+9F/9MMr/fDvCOdbP/KhH9r74acrnHf98Meo8NIB
nPcD598A+vmq8O4B9PMY5+EA/HJd+NIA3jc/cj4aqMe48CMG9P6Z89LA+/wX
4dcMzNNfOT+xfsekcIGBfp7iPDVQn9+E7Qby/YPzdX79DeGfDPhvmvPWgH//
El7uh19mOH/9uP+W8Bbw+N+cx1i/6x/hvX7UY47z2a/9XPyvcJcffr3Nee2H
XneEr/rhj7umZX7P37dAeFkA50UKJwQwLxYJvxSAn+8WTg8gv3uEcwLo98XC
ZQH09xLhlvn1S4WNAN5P9wlfDuB7fpnw9Hw8DwgvDqI/HhSOC0Kfh4STgriP
vC2I90G0cFYQ+fC8kiDO5/P6IOLnfk8Q/blc+EIQ/b1SeCoIPVYJLwzhe+dh
4ZgQ7osRfi6Efl0tnBKC39cI7wwhn0eFC0OIL074WAj6rhV24PzWx4XPhtAP
64THQ9ArQfhOCPGvF14xCP03CD81iO+hJ4W3DqJ+icJvDyKejcJ5g/D7M2H+
D6zmoUk=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcxy+nrrCsHE10iVjMoWmZNKQ16tvDKh2b6B9mG2uLjGn9AbnR
CFkpk2WsBBRQHlSeFOThPDjuuDvu4He/A6IGLosiCxMsiYIMSRxjld33fX3e
TjZgr30fPp/P+/Pw/a1KSdv+9jyLxXIp+Kv/y09tekJYyfX1z4doswobqpm6
za+r1NTUsWPCRopyReZOHOf6HpWcb86UCqs0pe8r5/69KiFs6NEK4ZEMtS/c
+soJnv9A20s/KRyVrSa3uU6e4n0f6f2fVwpvOKDWJOe/wHUjR41mhVt5X9JB
td0VueC2vVw10N+fWCac/rFez73t/yc4z3gL8vT+/iL686kKujt6RNj2GfQp
oH/5Khh+faHw7gLYP0p/C/X5N3nfbKEKhusrpv9HdLyR1PfQURX8u5/+JRXB
PvWNKNbnE6jvSDH0Yrz1Jfq8hXqmH4N96hV/HPapp6VUlZWWLqsW7ivV+cyo
oR5l0KNWeGc58nmG+lRgf53weAXyVU+9TqibMcn3NwhnnlTvJYS91kj9Tmn7
pU3C8yv1+lAz9axEPZ0T7q9UuRPb4m3UtwrxtQgXVUG/Vupdpe3n24WTq2Gv
jfpXq1dHs4ocwtE1OO9kPmpUYCYmuV14skbnO8bF/NQiP+S2WtSXm/k6jfg9
wtmncT955DTiJb90BvF2MJ9noDf53jrtbzg5vQ79yfODdYiXHF+P/eSKeuSL
/lnOqtjYWDv933UW+Wa8fSGmHusatP4u6lXQgPqnnjcaUF/Ue2cj+p3sbYQ+
5Kgm1APPH2yCf7x/vAn+0X5iM/qL/tqakX/GE26FfcabaUV/eYWHrSqYriwf
6+8c9O8Urj2n7cUarEebzkeeXzjOhnybrE8b9ncLl4X297Bebbp+hnuF/7Wh
fvpYvy3w5wvhlBbo/SXruQX+9wv3tkCfAdZ3aP954bWtqJevWO+tqLcLwodb
4f/XrP9WzNNB4elW5PNb9oMd9TMkvMOO/H3P/rBj/l8U9th1Pab+yH6xI/5h
4cg25Psn9g946LJwTmh9lP0UWr8iPNaGfvyF/eVAPFeFtzj0+/Tur+w3B/wb
F7Y6oMfv7D8H+nNSeIkT8/QP9qNTvw+P/yn8vlPrZU6xP53o12nhH5zw9xr7
tV3no2ZC+Nl2vHf0J70d85z+V7fDH8Y72A79qNdCF94r6hvvwjwjv+NCv11i
v7sQP8+fd8GfEfa/W60MNjTtbXRrfSzUd5cb9uhfiRv5ob59bvTjb8Jzof3U
d50H+aK+b3iwn/oUeLCf+poe9DP1veHB9wb3r+5A/TE/OztQ77w/r0PHc4H2
vR2Yh/TvWgf8of5RXujPeLZ70c9jnEfeO/Pj9MI/6jPuRb38LLzcB72pZ6IP
9Uj+0Ad9yTYf5hvr/YoP8ZHDO9Hv5Jc7MV/ImZ2Yx+SGTujL+4c7UW/kxV13
+qe68P7R/71d+F5ifLVd+D5g/N916Xk1R55v4HuIeq0wcD/1jDPgL/XfakBf
9sNuA/3L/B0I7We+ywy896wHu4H37jrnqwH//xK+amCezXDehvy7KbzUj/qf
5fz1o57nhDf70c9/cx778Z78I7zPDz1vcT77Mc/vmv6fm/3o13nCvX74N1/4
sh/6LhSe9SNfdws/aMLePcJrTeR/kfCLJubRfcLJJvpjsXCGifgeED5sol6X
CNeZyGe4sGFiXj0kfNFEvywVnjaRr2XCiwJK/1suHB1AviKEEwKwT94RQL9x
f1oA78nDwocCeL9WCFcFUP8rhT0B9N8q4W8CqL9HhCcDqP9o4QXdyM9q4chu
6BUjvAnrU2uEk7BufUx4Tzf6db1wTuj8E8LlWJ/YINwWOr9ReCBk/ynhsW7o
Fyd8qxv9sUk4ogf+Py38ZI/Wd/8zwlt6UM8Jwm/1oF6eE87ugX4qyP8BWsua
bQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx68SV1qWRYWViEmGhIx0qbVwH9MiHVvKH0Yba4uMYf0BudFI
WaHDZawECy0Qjd8cv44DjuOAO/jeD5AKLNMkDQtcMhrMksCICrvP+/a8N7uN
Y699Pz+e5/1+nud7y5PTEt641WQyXfL/6f/yGejvj6+7tnpTgLaq2AWD5bXk
V1RKSspojbCRrK5HJN1NNu3W61eYhVWamtjhCK3m+j0qwREaVCU8nKGWHRw/
U8H97+rz8sqFw7LUWv+njOe9j/UlwjH7cR6fGwfUqqS857h/e47yf2fz/OGD
arA83VUpnP6Bfm5ifKYPsZ/x5+fq8w8yv7CP1L5gyynqYf0Y+dczvjwd344G
4dR8VVRYWGhhvEeUdzpiqFF45gj0amL8n2h9U5qFD32q8jzT5hbmUwD9bcIh
R7HfzvyOqmBL3GttwuZjuN/BfD+Dfu3CGz5XFemxCzqZf6Hyh7/BKdxXiHhc
1KNIvTiyt6BLOPG4Xu/opj7FyM8QHitWlriRWTf1OqH3B3uFM0/q/CJ81O8L
+N0jPK9E+xXbSz1L4M8p4f7A8z7qW4r9XwoXlKL+vqLepcj3a+GkMuhJNspQ
H/3C4eV6fe4A/SiHv6eFJ8rh/zf0p0LH5yHbKpS/fN76ln5V4v4zwlmVOr6T
5OFK6PGd8JYq+E82V2k/l5wVvrMa9UlOr9b+j5DPVUOPc/TbrP3YSy42wz+y
qUbHO07eVQO/vmc91KA+yFG10IOcX4t6IU/VKr8cGeTEOuX/ziY76xA/Oawe
/U/OqUf9ksfqMY/I8Q06vxaytUH551c/Odii/Mt/J2daUA/nhYcsul6TyKoR
epMrGjFfBlmPVuRDXmdFfZNTreiPH4SLrKjXC6xXK867KDxnRb+QY5owX34U
Tg7wEOu5Sb3tF+CScG+Tjmf6J9Z3E+bBsHBkM+bBCOu9WfnttFwWPtys/TD9
wvoPrL8iPNmM+0fZDy3wf0x4ZwvO+5X90YL6HRfuCDyfYL8E9l8VDrWhX35j
/9h0fi9fEz5gQz1Osp9sqJcp4VEb/LzO/mrFeX8Kb2tFPn+x31qh/9/CllbE
9w/7rxX1PCd8rx39yfVb7Lqe0meE37Fj/kyzP+2In/FetCP+P9ivbVrvbK7f
2Ib+YrzpbYiH55e1oX5m2c9tqBfGM9+BeP5lfzswX24Iv+lAv5gmpd8dyP8W
4dNYn8v1pnbsZ/5rwLnUZ1f7zfoda8c8ob597eg35jPbjnlAf6I6MJ/o36sd
6D/qkw8eov+ejpvrYapD62fi+pWd6Feel9gJ/3hfbif6g/E4O+En473aCX2Z
T5gT7wPmm+BE/tQjx6n9iaaedifmDfUcc8KP24QfcuH9ECQc74K/84Xfc+n+
irtd2OrC/XcIX3ahXhYKB3dh/t8l/EIX5t8i4cwunHePcG0X9FwsPNSF+O4T
XtQNPe8XVt2Yvw8I7+nGfSHCFd2opyXC57vR7w8LzzOQ3yPCS8HRocLrAs+X
Cb9kYF4tF041MD8fFd5vIL5w4SID/fyYcIuB9/VK4X4D9RshfMWAHquE5wzk
Hyn8oBvz5AnhGDeeRwlvdeP9uVo42Y37yPvcuC9auOB/3ODGPOL6XjfmH/ln
N94nvG/GDb8Zz2IP8mW8kR7MO+az2YN4HhdO8iBf6pEReE79Dnug9wrhag/u
o/6GB78P6c8FD/ynf5Me6EN/F3rxfqb/4V74tVQ41ov65P6dXvweChNO86J+
6PchPB9nfKV4bqbfHYH9zPesF/VFPSa8mD/UK8iH+6lvqA/ziv6s92F+xwhv
9yH+NcK7fXj/rRU+4MM8eEr4uA/zZr2wzQe9nhYe8KH/nhEe9aF/nhW+4UM+
G4VDelBvSvjJHvy+2CS8rQf1tFn49R7E87xwVg/mZZyf/wNksH3Y
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlntQlGUUxjcDKyRN2wq7EBYVGRlqKV2wVzMJs0S6iLVjiUhQf0DO0Bgy
lY5MylRgoQWSyU0uwrqwCyz3vWH+gc04maRhgiVRMKYMGEOF7fvsnMchZoD5
zfd+533POc/7nG9OQmrcpikGg+GM91f/l5+A7pK0ny89vNRHMSoqoPveq7xO
Hevq6joj7EhQ9uCsd8iGFKX/klWqKk2Lyu7h+s3qcphpBrk3XXPOT3z/fb0+
gBySqeK8G5xmvA+VObpv/JRwxDalz0t2bFdJSUn9PwrH7lDu0TATuTdLc0+3
cNrHymiO3kA27NLxLp4Uzs3G/uSQT1APsuVTdXfW4PEfeL4c5ENOzsX+5Ijd
aqH3hzy2G/HIjs/V0Bp7MHnnF6ovwziPHJun91tDDtqD85F796itRvO35Iq9
iMfzpn2JfpAjv0K/ruafj+fko/l4n/XLLUB8cvw+3Y8M1j+kUHmPF8l+DRTq
8/mzn5av1bvehMlb9uv1dupBfaPrUUL9+B1Qz/Vl5FF/yQdQ37PCXT7uZX2L
VEF+fn6fcF6RynGNVpxjvYuw3y/CpmL071fWvxj9Py8cWgK9/sZ+lKB/A8JD
Jejv7+xPKfrxh7CtVK+3DrJfZVpvfUPCmWWIf4H9K1MPmnKW/Sm8/KAy5bjS
L7KfB5HPJeHAcuh5mP0tR7wR4RPlyns9okbZ7wrcl8vChRWo91/sfyXqMSac
WIn+jVMPldDj38LhVcj/H+qjCvn/KzxShfNOUC+H4B9XhFsPod6GYdFPNep1
jfCOauh9ivBANfK7VnhVDfInW2p0vm1+wkYz4vkLbzGj/1OFe8zQ83XC6jD8
43rh0sNaf8YAYT+LXh89TXiRBfclUDjZgvrdKFxg0fUyTxfusqCfM4QnLNDT
TcIRtdifnFALfc8UzqtF/WcJH6lFvuSxWpzvZuG5dVpPLrKpDu8bhT+rQ3yy
ow76JA/XwZ9uEQ616vu7lvyqFfefvNOKeORmK+4vecgKfZCDbTrfJHKsDf5B
3m5DPXkemw16YT36begf6xtUj/vP/qysR3z2M7Me8akHcz30TX311mM/6nVW
g/LVQe5jA/RMfb7XgHpQfxUNiMf4pxsm6y2wcfJ5ljTq886mvtIadfywG4SL
sb6f+jyB9fmMN9UOv+B+kXb0j+d52w69Mb9CO/yA/J0dfsz1hib4A+MtaEI+
3D+xSc+D/Tz/3ibUk+c/2oT7zfqPNyFf3ofwZsxv9mt9M/RCvec2Q2/Us6sZ
95f6HWlGvtTH/S3o163C8S2Y50HC2S36+2RwtnBrC+pxh/CFFpznTvpPq+73
R8HCcWBDCP3I93yOcEOrjjd6D/2pFd9DocK3t6Ef99Gv2nR9Vj0g/EEb8guj
f7XBb+YKn2tDPx6in7XjPocLr2iHH86jv7XDLx8RrmqHP0XQ79qhx/nC0zvQ
/wX0vw7cr4XCmzuQ36P0Q9/zx4RP+t5fRH90wO8WC9/lwPkj6ZcOfE88Lrza
gfOQk8GRTwhvc2A+kQscOA/Z6oB/Pkl/dWAekc/79idP4P108m3Oyc8j/scx
zsnrE5zwM/JWJ/In5zmhz6eEa3zPyUecuL9Rwmed0NMS+rePnxae6cJ+in7u
Qr2WCj/jgr6X0d9duD/LhdNduA/P0u/xvGSFcLnv/Wj6vwv1jBE+5YK/r+Q8
cEF/zwtPc+N7/QXOBzf096JwlBv5rua8cGNexwqnuqGHOM4PPDe9JFzke/9l
zhPEP/6K8Pe+/ddyvrjhb/HC/h7cx3WcNx7Ee014sQf5vM7544HfmoRTPPC/
9ZxHHtT3DeF9Huj1Tc4nD+73BuFjHsyHBM4rD/qxUfgK9ktK5PzqxPNNwvM7
8X4S51kn4r8lvLET/UrmfOvEPEnx8n8SNGAr
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcxy8TKyRNo0SbiGmFDk2lkh6wrw+ZGk1gTXExl/gwyBanhSlS
IsE0zEAD7ZAQOJ4fjoM74A7u4O53R/kHtrVcrGYL2nJsutZctOYf1X3ft8/b
yea51373+34/D+/P+3OLs3LT908zmUy/hP7p/+UvMBWfufz2ivVh2qrSXbER
CeRdaiI/2rZC2JelDiVH7nyWz3OU/lwtrHJVmTHVsobfP6wWldxMe054PE/Z
Xp+48zzfP6aSI8esa4XjCvT5Y2R1Qo1ZzV7yqpMqdJyL7CtSyzLLDHJqsYoO
XUAeL1F/x2fOThI2n1JXR0dTyKbP1K00Vw25vBTxkeM+VwdCfy8K28/ifLIq
U67YkoMvCWeXo34vM95zqAf5n3NK1/sVxn9eVVks85OFT3+J88mpFSoxMdGx
TjimUm2ZyK94lflV6njzlXDLBcSznvleRPwbhJO+wvONzN+CfMlXLPg+3y+v
0v37nvdnXNL1T2L8cdWoH+sxWY38WX/71ziP/T9ao+s/elcvl3V+idTT9Fqc
R/1l16oGc3Ik9Tlai3yfYX3rVEg+fy4VrqhDfk+y3uHni4Qz61Xos3Ah61+P
+j8hvNQKvcWwH1b9vvlx4VtW5B/N/jQgvrnCzgYVkuPUbParEfV9WLigUfcv
Oor9a4QeI4U3NWEeHmQ/mxDfA8JRzdBDBPvbrO/Lmy58rVnrZ8/97HcL4p8m
XN2Ceb6P/W9FPOR9rdCriXpoxXnkhDY9bxvI5W3qeOgL5L/aEA85ox3zSfa0
6/PjeV9cB+rH+Io7dP5LGP9kB+rN/FI6US/mb++EH80QjrZhvlivozbEz3pe
Dz9/iPrrgj+x/g1duv/JM6lHO+Jhv16wQ9/sZ7Zdn3edXGXX+o1l/0ftqMcj
wv/a4W9zqN9u5PeocFY3+k99VXTDv6i/b7r1/SXzqO9u6It6Xd6D+xZQ7+Ap
6vuL8PO7+u/B+7HCt3twfhznwYH7OU87HFqPliWcD8e98zfgwHwv5rw4kA/P
j3VifhlPqhP9Y/xFTvTjMc6TE3plPW44oTdyTC/8ifXb1ovn5IJevM/5tPWi
f+Tx8PfZj7l9iI/92tSHfNnPI304bxbnM8zs/899yJd6iepHPamndf3QH/Vm
7ke9+Ly+X4U+C3netX7og/fPcKHejC/JhfuYz7sunM/6VLsw39TPdy7cR/2Y
3Hr+SucLr3FjvtmffW4dj4l6ueDG/mU/r7ihJ+rljht+Tr0kDCBe6mX3APzl
KfrHAPYD/dwYwLwto58MYB/S/58evHc/ZAxivlcKl+J57Cr6zSDmk/vmj0H0
M5H+44H++Hsk3YN6cX8Ve6Av/h7o8+h5KOO+n/TAj7gPF3jhZ9yXKV6tr2+5
rz/xQg/cr3Yv6s39+5sX9X6NfjaEem8W3jyEem+hvw1p/a3cJtw2pOt54w36
3RDq9abwrGHku53+N4z5ThM+PAy/TqcfDuO+t4R/HIZ/76A/+uBnO4UX+qCn
XfRLH/TwtvB2H/qZSf8Mf3+38Ekf8nmHfupD/fcIO3yIZy/91Yd+7Rf+He/b
DtBvfahvtvA8P/SQQ//14/fCQeGtfvjhe/RjP/r1vvBxP+plpj/7oadDwp1+
6O8D+rUf8/mh8K9+1O8I/duPeD8SnmOgXsfo5wb6ny+80cB+KqC/G9DXx8J5
BvzzBP3eQL6Fws0G8i2i/xvI91Phnwzou4T7wMA8nhKeGUA8p7kfArivVDg5
gHk/w30RwHlnhXMD6G8Z90cAflQuXIf3zee5TwL4/VMh/EMA+qzkfgkgn4vC
EUHowcJ9E8T3q4TXBnF+NfdPEP2qEc4JQm+XuY+C6H+d8KUg/NjK/RTU999s
EL4aRL+buK+CmLcW4f+C0E8b99cI8m8XXj2C+zq5z0ag3y7hvSPol537bQT9
6Anx/3HYTLQ=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx28N+4NcrcbWjy2yVQ4rHWYh/cA+KokYqVAp1mWJRKArLgpD
IAWCNDKBPMkDJOBADoTz4A7uOA743g/KP862lovVaElbzk3XmpPW/KO6z5s9
bxYbsNe+9/18nh/v5/3cg3nFOW/fYjKZfon96v/yM2O3TDx7feX6BcpU3Za0
+EXepXyJdfufETby1Ptp8TNP83mR5p1kVawKCgoup/LzJSondgD5Uqmqu5qd
SjYdVPoveVmluhCNZi2ed1jFz9j/5P3J1arFZrM9x/Nr1Apzw4Z1wttrcf/z
vK9O51O/XthyRK2J/Wzk/Z8hn3ThxnrlzJgr38R4jqlr2b7EzcKuL5SuVybj
a1AJzow9LwoXNiKflxhvk36/favw3036/bTtjP9L3J8tfPSEztfyMvOxqr+S
zHeQ7zmJ/Pn+pZOIj+c7mnEf47F8pT9/L+NNPYV6MD+TTZkbQqXM/7wNz19g
PVpULDw7P5/bqusdymB92rQ+rrI+V9pw3xbW67R6INZwxlPWjvOzWL+vdb+j
rFdcB/Ldxnp2qPB8kpn5RjtUQ2jewXold+p+3cwRtnbivldY7041V57gfFXY
3IXzd7L+Xah3rvDDdvRjF/thh75eF75mx3lm9qcb9d8t7OlWm+fKrW+yXz1a
/0v2CFf2aH1U5bF/PYh/r3D6Gd2PeT53nEF9+P7SXq1f91vsby/qwfsu9iI+
xpPqgF7fEG5zaL3OMX5TH/pFzu+Dnpnv+T49r77XhB/v13p4iNzYD72xXjf6
9f2ryLlndT++Z30DZ+EH5GUDmHdy7YDOJ4l8ZUDXM4GcNYj+kV2DqD85wYl+
kcuc0Dd51ol8yOoc/I7xdp+D35HjXFp/s+QUF/RP/RS6dD9N1FeLC/5CPUZd
8Efq+R8X4qH+k4d0Pg2cz7wh1JPzZh3C/NGvvhlCvxX1vfA8TfjRYfgD/dI8
jPPXCh8fhr89Sf0Pa78sWC18fRj9WMV5cKOfjwnvcKP+SZwPN/r1iLDfDb0t
57y4cR4/n+iB/lZwfjyoB8+v8eD8lZwnD/JjPJc98M9kztcI5pXxbxnBeWs4
byM47ylh5wjmI4XzN4L4uH/uGsX+4P5JH4VeuQ8PjEL/rLdjFHrg/vl5FPPD
/iz1Qh8bhNd50V/20+JFPvTbLi/0xv5f9KJf9NdbfZgH+muqD35Af93nQz70
0zYf/Jn74Tsf8qGfmsYwP9TrE2M4j/smfwznUd/NY+jfDvrD2P/98+YY/G7R
L/zQH/1ktx/30Y8a/dAz/Srkh97obzfATvrf8nE8p1/mjuP9fOH6cZxfQL8Z
hx+/I/zHOPpRRP8JQP/7hHMC6Od++lEA/viu8GgA/vAe/SmA+IqF75tAvS30
qwm8XyJ8aAL9/oD+NYF99aHwbxPYd6X0s0k8PyC8aRLfnz6iv03Cv8qE+ydV
RYLzW/LsJPpzUPj2KfSnnP4HriOXTOH7Frl7Sp+XUSH84xT2NznOQL3I9xvI
n5xiIL5K4W0G5odcaKAe5GoD+ZNbDOif7DbQb3LUwLySfzfgvx/Tbw3oj3x3
EPkfov8GoQ9yZhD1PUw/DqIe5Iog8q2iPwfR/2rhwSDiq6FfB+GHnwj/GsT8
1NK/g9DHp8J3hpD/Efp5CPN4VHhjCPNfT38Pqdjfqs+FS0P4/nCMfg8uPS7c
i8+bGun/IdSnSfinEPpzgvsghPitwreFEV8z90MY9TwlnBZG/jbuizD2X6tw
8cLnT3N/hLGP24U7w5ivDu6TMOLpEv4B98/auV/C2Hc9wksiuK+X+yaCevUJ
r43g+0g/9w+eWweEixbed3IfRdAfl3BrBPcPcT9FsJ/cwhciiH+E+yoCPXqF
/43g+56P+2saevILr57GfAW4z6Yx/5PCe6fhbwb32zTmLRjj/wBltmY0
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1M21UUxhuz+QGNRkMimoiYLQaNGtRk8gVzfYlzZolA4sa0Tsc2hE2l
Q5kbQ8dwKMM5huuYvMh4H6+l0FLa0tL237JN081Ml+EWdDCVkEDMsohZ9mHa
+zTnaWgCzS/3/7/3nOc859w+ml+cu/0Ok8n0W+xPf8vHtnb21rYbT70Yp3Uq
aarDkuBNSq9vFQ7mq9dmy6xkU5Hal2xbS1bFqtOSlZR4vkTFlmfzhWdK9fNn
yKa9yzmtXIWX0qfJar/SX9wv44B6LvZJ7F+p4ysjZx9Uj1QtXCDPVKlYOlnM
x/KVft+RyO8Q1rcLH63B++S0w+pxc+1LZPs3qtZYSk/kWwt93hMuPIp8NjPe
Oh1/hVn4Zh3if4vxf4t8NwpXH0M+bzIfK/QkpxxXWbECbWB+x1XVQk5mnnBP
Pc7fxHxP6P3NbwtnfqcKCgrmGI+pQZlrjVLGe7YB+bxLPRpVrju1aotwXpPm
lcw/rRnr1HO+GfUqoF7fY//3hfe04PxC6ndS652zQ3hFq87HvZN6tmq/JX8o
HG2FPz+ivm26PkaxsLUNeu2i3m36/CWyuR3xWqh/u/o33Xwv31/doRZz3C08
r7pDxY5/+gPhxQ7oy3izO7W/txQJOzuhD/NL6YLfqEd5l86/gH6a6YKfqN8r
3dCL6z3dOt/rfP/uU8if+1vA13n+xfg69cvswTrjb+5Zrp+pV8XkWGD+23oR
H/U626vORaPREuEn+1CPT+iPPtS7VPifPu3PVeS8fviPz/v6UZ+P6Z8BxMPz
Dg7A34xnfgD6sR7rB1Ef5mcf1PHvZP7JNr2emvCbTfe3n/pO2zCvEvNlCOv0
e+cQ4n+HfrSjH9mva+zIh1xoh37kRjv8xX6L2uEf9tttO+YhOWMY+fK8/GHk
w360DmP+ML7TeH4V583NYfiX/fnECPzH/Mwjy/v1yAj0px7BEdXY0PAg/XZj
BPHSb6sduv7rqecGx3L/VTtQD+rvxfNR9seiA+fTf6lO6M96Zjt1PDX0Y6UT
85f1dzpRT/pjzon+oB9TRnEe/fT6KPqJ/isfxf67hW2jqNen7L9RtSsraeNe
4ftdmCdl7EcX5nW58G4X6vUZ+9MF/fYLX3Hhfqxgv46hPpXCL4Brv2D/xter
hNvH8P6X7Ocx7F8tfKcb5x9if7tRr6+Fd7jh58Psdzfqd0T4vBv3TS3734N6
1gk/60G9jnEeeFBfq3C9B/dNPeeDB/U6IXzLA/82cF544bcm4c1eXZ+eZs4P
L+JrETa8qM9JzhMv9GoTfmwc9ejgfBnX9ZvqFK4ZV7H/Fd2cN+Polx7hv8fh
l17OHx/y7xfO9UHvQc4jH/xgE3b5MB/tnE8+6DUi/JAfejk4r/zYb1T4cz/6
2cX55Yefydf8up42Pp88gf2cwq9OwM/cf88E5g3P75uAf4Y57yYQP+O9JwC/
kVUA821IuCSAepE7A8vzvxTQ+TSQVwRxHvnhIOY1eU0Q9y/5jSDmJ/cvBE+T
D+D5UsbXGIS/mY8jqOtrYr7RIH5PkP+K70d9bsfXqd8DIbxPvTNCmBdjwutC
uM/dnMch9JtHeF8I96mX8zmEevqEB+PP+zmvQ/BHQPgq3rcEOb9DiC8kfJ8B
fcKc5wb8HRF+Ob5+mvPdwH1yRrjUQP/9wHlvQP8fhU8Z8EuU89+AP88LXzbg
v594HxjI74LwXWHo+zPvhzDqdVE4K4zfB5d4X4Thhynh4jB+713m/YH3l64I
t+F96zTvkzDmze/Cv8TPv8r7JazrWTErvDKCev7B+yaCfv9T+PkI4p3j/RPB
/TIvXBTBPCNXRhA/n2+KwP/czxnB+deEz0VQ3xneVxHMC8b/XwT+Yn4pk2Dm
/8wk6vcr77NJ9Cf13DoJfah3+SR+L+t6/A99fYdA
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlmtM1WUcx8llL8zVamxRW2SLNWrVumzFG9pTuUrnFvLCbGNtYRFoxZHC
FMiApJBMIBHjInK/czhwDodzhf/5n4OxdqhZTLJ0giu6QGYoRlTWeb7s92XA
Buyz5/K7f5//3amZya+tiYqKOhf51f/lp9mSuG7n3INPLdEmdVfRzNZd5JfU
81M5FW8IG6l6/dSbXM9Q+nymsMpUj0V+LNyfpXKjrc/tFp7MVpHrE7J4fp9y
xRbNkDfkqcR1E/e8zfveV1M50VauP1yg15t4n1GI+2kv6YC2b3+L9oqU/kd/
LR/p+x5aju8gzmcIl5WosXB4y+v055BKKTWz04Rtn8A/rqtSFTk+RU4vU6Xm
fHs6/S1XkeUc3r9QrnYnrnuR+TY+VRNNlkT6U3xEn49nvpMqYI/+xxwFL8d3
FPEw/+2VuI/5sBxDPZmvhM9UJH2W5fxXqavxKaXM92iVro/rHeajWqWlpU1n
C2+vUdVVVbe/y/zU4v69wj/X6n4o2cd8Hdf5/TxHeG8d7OUyfydwnuvX16Ne
PJ9ej3zSXrhe3ZdS+vQe5rdB53OC/lY06H7axXgWGlBfxpvSqO/P57rRiPt5
Pq4J/jLe4ibcT3uzS0x/kpqxn/E7mtGf9D+mBf4wvrwWNbvVFcv4J1uQb/LG
VsxHHuvZqvfXkde3od/IljaV7Ipd+57w+CpOaFfB+fiz3F/bjnkmR3Wgn8iv
dqysz2gH7NH/BzrRb+SyzpXxXunU9THJ27uwzv2+LvQT79/QjXmgvwe6oS/7
2U/d2v+UfOEtPThfwP7qwXx9IBxthR4Vsd+syN+HwmetyG8x+69Xz3v4oHBz
r473lY/ZjzZ9/+Ih4cdtyM9h9qcN+SsTrrZBf8rZrzb06xHhazbYq2D/9kFv
KoVTweFj7Oc++FslfLJPz19VNfu7D/moEb6/X/t383H2e7+ud3Sd8OF+1JNs
9EPfTgjP9cM+Oc4OfSZvs+M8udiu9cZP9th1/xWRZ+2InxzrQD5pP8mBfJEL
HdAnssOBfiNPO7S/84wvZgDzR948gHqT8wbgD9k6gHjJk6v4VqeK/M0nb3Qi
3+Q9TsRLbndqfy+Rv3Ou9Hf9IPqT/OQg9INsGVyZn8ZB6AF5HJxQL3yDC/GS
E1zo1wbhnS70fyPn3YX7yF+6EG8T59+N96JZ+FE3+qeFeuBG/cmVbsxnK/XB
jXlvE150w1479cID7hB+2YP8dVI/POi3LmHTg37upp54oGdW4Xu9eB97qS9e
vB824RIv6t1HvfHCfr/wRS/6x0798SG/A8LJPtTfST3ywb9BYacP+u2mPvmQ
T4/wHX7s91Kv/PgeIu/3wx732/x4n8gX/Kgn90cPYd58ws8OoZ+GqG9D8McQ
7hyC/QD1bgjxBIVvGoY/I9S/YeT7pHDWMOZnlHo4DH3+Qvj0MPojTH000I9j
wncasPcV9dJAf50SfsHA/H9N/TRQn3HhAgP5PE09NeDvt8J2A/N2hvpq4Pvw
e+EfsW45R71dOn9e+LYAzk9SfwPQnwvCmwKw/wP1OIB6TQvnBuD/T9TnAPr5
F+GeAOKfoV4HMN+/CZ8PYD5/p34HUK9LwreYeJ/nqOcm8n9F+BkT9b5KfTdR
vz+Fs018z/xFvTeRj7+F20zo07/UfxPze034jIn3KOqyvAfYb71O+MYgeI1w
XBD1JycGkU/u3xbE/PK+zCDeI9orDqKf/hFuCGI+6b8nCL1kfN8s3T/P9wXn
Sy8Lrw3pfKT9wfcmhP5jvp8IwT7rkRRCP/wqnBFCPljPwhC+31jPmlXnHbjf
f1F4bMk+6zkdQnys538h+E9/Y0bwfcN4HhlBvhjv5hHke0F4xwj0bpHv2wj6
Udf3f13xnEE=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlntM1WUcxs8c2tLKcjQvK8JJRo7IajP/ob1dlunYQv6w2lhbVAz7B3Kj
IZACSSqlgALKReJ+53AO58I5cIDfuSBWB8s0ScPELkSDOdNwZCs773P2fVyd
jXP22fv+3vd7eb7Pj7WpGcnvLjKZTJdCf/pXPs+EPvnXn3g+TFtV6Ct/L/kN
VTS73bVH2EhV/vnYyQ+5vlMtnWi6liesMsC53L8LnCM8lQXezed3q7ntrihy
dJ4q8c23Z/O8verxlBIfeWOBeiQUEPcbhXie5yftU8muqMW8f6rov/Fk7leR
5i1XGK/poMqNNI8xn9Ji3M98oz9Voe05rIflkJpoykxgvVSJCoU3T04vVdVV
VVUFjLdMnxdbKLxQphJCAZGNI6o5M2HpR8IHjiI/clI5+kFeVaFeuZJTTp6q
0PkWkdsrdX9SyJnH9P5I8ubjyI/3m6p0POvIp6pwH+Mvrdb5DjG/12tQP9Yj
ulaFrp9lvWZqsc56Wk6gf6x3dh3yvaOXz5Av90fUo348L71epaWlTfO+YL3S
er1T3wbkz/jLG9T7oYSY70ID6l8knNKI/D5m/Rv1/Wf2C8c0Yf9B9qMJ+4uF
55pw/ifsT7MKlTf+kLC9GfEcZr9aMC8lwnkt2F/G/rVg/xHhl1oRz1H2sxX9
qRC+p03rObOS/W3DfB4TPtem9XrrOPvdrtc3VwvXtmu9ZtWw/x3QQ63wOx3I
7wT10IHz6oTjOnV/VtdTH53Ip0H4j07c10i9dIGbhD1dqG8z9dOtbsamLG8R
3teNfpNnuvX55lbhxB6tr7faqK8ezHu7cKQZ80HONuP8DuFJM/Inq141HgwG
yc290Gcn9WhB/ORNFr0/kZxu0fV6jVz9v/WgBXol/2NBPOSNVswL70+1Il9y
uRX+Qz5pxfnkBSvqSd7QB72QU/rgV+TDffr+ErLRB39gPNf7oFdyjA166BLe
YVP6p4fzYdP+ucUsPGBD/L2cFxv82SocZYf/9XF+7NCPXbjQDr9wcJ7sqG+/
8LQdfuvifDngFwPC2xzI18N5c6C+Q8Jmh+5v8Qjnz4H+eIVXOLHfx3l0Yn9A
+AMn9HCS8+mE/40JX3Qins85r/2oz5fCz/VjnoKc337M32nhxn7499ec537o
5RvhJS748VnOtwt+8K3wey70f4Lz7kL/vhM+7UI+Fzn/buQzKfy0G/lcoh+4
cT+50o37vqc/uPH+vCB8yw1/4H1xA3qe084LvzkAfZyjfwzg/cz8fFiPP0M/
CT//lfD6Qa2nunH6yyDyY32LBxHvF/SbQdT/lPDVQRX6zmf/oj3QG/ub7IGf
+OlHHryfqA+nB/FTPzMezM+w8JohzBf1lziE+aT+9oTXud8yhPx53o9D6D/v
ixxGfanHl4fRL8abPYx4RoU7h9F/6nFyGHpk/veNIF7WR4HLWb9d4XXWt3kE
z1Of50cwz9RnhAH9sl8PG5gn6nOTAb2y368a8C/qId3AvFGvBQb0RT1VG+gH
9WYzEA/1Ggzf94PwLzg/eJl+a0A/V4RXenX/TT/Rf73Q08/CW73wj2n6sRd+
+KtwLp7P/43+7EW9Z4V7vNDTHP3ai/uvCl/2Qp/X6N9eHb/td+EHfPC7G/Rz
H+KdF37RB/+8SX/3Qd8Lwlk+6OlP+r0PevtLuM0H/fxN/w+ff1v4As4bM92Q
90H4+UXCy/yIL0I4xo/8lwgn+OEfdwnv8CO/u4Uz/KjfMuEDfsR/r3AD1k3L
hQf80Nf9wmfD968QnvPjfR0pvDgAvT0oHBWAnlYKPxvAPK4WTgpAf2uEdwag
r4eECwOY/yjhmgD6Fy1sD0Bva4XHA/h/bp3wdEDr4YVHhW8HkN9jwqtGoZdY
4adGUZ8NwttGocc44bexbooXzgs//2SI/wVTVom4
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlmtsk3UUxhsyvAwEIVUuSgElZE5A0AT3ZeYvEhFCwuUDzmQxcaIB/UAl
mUEgOuYaLiIbMMCOARstrIzRdWvpbe369gZTC15ApziEqUx0E3GAEqJg/089
zwebLMsv7/ue/znPec5538llq5a+NsRkMp3P/un/8ut2WKMVg9OfzdF8VVqd
uLGB/JJ6Kvt7X9goU+55vWureH2lOpXJZGzCapUaWBK0bOT9q3H/JuGL5eqt
4vzuzXz+HWXrX1L0gfCk9arObrdvZbz3lP63TXjmBvV69lfN+JVqoq3/ixrh
xVUqW0/xDp5nU9lyXDuFrRvVC71rzbt4/mYdv2K3cM0WFbTY+vcwn60qeaOg
1C7s+VCtM7tP1jG/auhTL7yiRte/fx/z3a6c1uL8A8I3t2t9yxuY/w5lzgrU
KLxpp44/z8F6alU2XbdTeOwu5H+Y9e1CvCZh126db4+L9e6Bvs3CRR9B36Os
367yux1XW4S77LqfC93Uo05l2+VoFS7ZC394qE898m0Xvlyv86v1Uq99yMcn
vGY//OGnfgd0/a8EhPMaoF+QejbALyHhTAP07KC+jeh3RLi2Ef6IUu9Gff+W
TuHSg/BDjPofVI9lCzKEpzjgpzj74UD+CeEBB/qVZH+c4JSwz4l80+zXIfjl
hPD6Q+jnSfbvEPLrEp57GHp8zH4e1vfP+ER4eBP0J1ubEO9T4bNN8GuG/XbB
H+R6l87vRd5vOgJmvOVHMK88v+sI5pv5TWtGv8k1zVrvPtZzvVnPg5dcchT+
IUeO6n5FyZNaUA+5qgX+Y/zLLdCPvPAY6mN+nmNqadAylPmb3ciXvMaN81lv
j1v9WVBaTT1UK/iUsLMV/jtNP3r0/AQ/E57tQb8/pz89ep7GfSlc54GeZ+hX
D84/K3zbg3q/on/btN+WdAuXtUG/b+jnNszLOeETbcj3O/q7Tel/54UL29G/
7+l38K0Lwtva9f0VvfR/O/T7UXiwHfP7E+fBq/N/tE94mRf5/cz58MIPvwiH
vdDnV86LF/kMCFt80OsK58cHfX8XrvShv39wnnzIf1C4zwd9r3O+jqN+8oLj
2G/XOG/HoR/ZnbvOeBdzz5NH+9EPnj/Xj/uvCr/th7+Yr8uP/cl6zvmhJ3l4
APvqN+FnAjiPelgDmB/qdTCA+aCeZwM6nu2y8F1Bva/mUP+iIM6/JPxGEP5g
/+qD6B/7ezqIfcH+m0LYLxeFnwzBr/TP8hDmgf7ZHcJ88vmuEOph/Fsh+IPn
Twtjn9E/L4d1fiNZT00Y+5f1JsK6Hms/90kYfqF+UzuwD6hvSQf2G/uzpQP9
Zj8jufvZ/ysdiH+D+yeC+H8JL41A/5vcRxHkf0vYH0F//+Z+ikCvf4THR9Gf
O9xXUbw/TNf+43ejyHeIsCcKf+QJ/xCF3kOFzZ36fVVwt/DzndD3HuE1nXj/
5Qs3g6PDhHs68f6/T3hEDP0fIaxiqP9+4dUx3c+KUcLOGPIfLfx1DN87ZuE8
A/P9gPAEA/P8oPBsA/4eI7zIgH7jhFcY+J4ZL7zBgD8eEq4zsC/JXgN+eVg4
Y6CfE4Qv5eJbhG/j+XLymDj8QJ4Zx/ceef7/uCyO88jr4jiPXAu+yvOP4f45
5BO5+5nvhTjyYT0349hnrH9UAnpQn8IE+k39nkugn9S3NAH/sR/lCexL9mtb
Avmwn024vnaksJGAH+iPbxPY3/TPIK7PoL+GJfF9RP9NSWJfk4uT0P9e4WVJ
vB/4/CrwScbflHue5zcmUT/zC+N6D/15JonvN9Y3kIS+rH9oCvNAfSwpzNdY
4adTyJ/6Lk5h3tiPlSnd/zfZv8oU9J4ovDeF+iYL+3LxHhE+lYs3RbgvF2+q
8J1cvALhsWnEKxSelUa8x4UXpNHf6cKvplHvE8Lr06h3Vpb/BUv2j9E=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1w9MlGUcB/CbQTWynMUKaxIVlTozjGa0wj2mEzVKoFJs5JKwUFdeNoqQ
UhkUshI0tEAy8VAQ5Ty4A47jDu7eO5QKLdMkDVNcMgoqh38yaxTP9/r+mrkp
++x93+d53t+/F+9KX5mydJTJZDo58lf/5J/ysrJx3w09MCOouerShLTibvEi
FdZtOXeM9qariWnFT4hNy1SVOb7oW1qt1NeNo3L/KuWMLBg4Qp/OUinOyFCx
6W2l9/+GjspVg8nOyMOy3hpc/5qOWaf3C/tK1s/D+Q7SSfnqzoKBw12yX4Hq
zQm3fkmb38d5v5D916twa8KSz+mSIlUwkBzXKef5QMdjzAHa9iHep0POV4z9
AnRmieq2mD1+Oe9GFRsbazfoyxtx3Sfn34TnvXThR8qa0HulXd6nFOcRR2xG
ftrk/Tbjfg9ds0XHt0Bs/li//xRx3CeIl1vev0wd7OrqEneWqdXh1gPiknId
n15x6lY1Z2RBWS+qQvkvTkgT91cg/2Lbp/p94+W82duwvlh9puO5Qt4vZDvy
L/HI3I79xV3bkU+JX0wl8inxLa1UI9tnSfwvV6qXR/5IftJ2IN+SP2/Q++lo
C84j+S606PjmSD0MWhB/qZekKlVsXKyRenJU4f2k3iJ26v37pB5zd6J+D0n+
dur6iJV6nrVLvR4ftlDqvWaXGvl3rfTD6GrkW66bqxF/ef5oNepT+iGuBvkX
V9Sg/sSm3dhPzpOxG8+LO3cjnrL+5FrsLy6pxfnkPBdqrz5f6h5db2Y5v3sP
4iGO2ovzS//n70U9ivv3Yt7IvEisw/nFtjr0h8ybcCuui7OtOh8JMp96rHq/
nv/m1T7kV+ZZ1T4VH9Z9j8y/EBvuF0+z6XlUJvMy04Z6OU6X27DfCalXG/L7
PT1s0/UyoUfqtx75OUmn16NffpB6rkd+TtH763He01LfeN7aS09qQHzPSL03
YP0f6Q0NeP6s1H8D4t1HDzXgfP3SD3b010/0Aruuh4s/S3/Y0T+DtMuuz9v9
i/SLXc+35N/oSAf2Oyf948D1ITrPgefPSz859DzYdoHuc+j8WMQRjYj3JXpe
I+bb79JvjcjXH7Q1eP+f0n/B+/+ib27CfsPSj036vImm8//6zSalf4yia5oQ
/2voE02IRyg9uhnfj+vo6c2Yj9fT5mb0Vxi9oxnxH00fbcb8u5G+1qnnb+kY
Os6J9xlLL3fifLfQFU58f8LpQ07U6620qQXzNoJ+qAXxH0dntCD/d9BbWtCP
4+nOFtRDJH2lBfMwip7sQjzuphe78P2IpktcmJf30oYL8bifvuBCPCbS97Wi
HyfRqa0432S6qBXzYArtbkX8HqR/bcX8nkpHuXF/LJ3ixvoP0/luHc+10+gm
N+ZDHN3vRj4fpW/3YJ49Rid6EJ/H6Xc9OO902uZBPBR9xoP6m0GHtyE/M+nZ
bajnWXR2G+prNl3bhv5OoHvakM859E3tiOc8WrVjPj9Jr2pHfyXSVe3Iz1P0
sXb8vvI0HeJFP8+nx3uR/yR6mhff32R6vhffvxQ604t8iNd50Y/ici/m5zO0
3Yt6EnfhfrP47P88HNxffJsP81Qc40P/iOf6UN/idB/6X7zad/V6pT7kQ1yH
633i/cHnn6VP+RA/8WUf+vE5eqyB+lpATzIQD/FMA/lcSKcZiH8qnWWgfhfR
Gwx8j5+nqw3kP432GojnC/RxA/NsMT1kKP3jRfoGP+p7CR3tR32k0/F+5CuD
XuDHekvplX7s/wpdGLyeSVf60Y/LaVdw/RX0keD+r9KDfsTnNTo0gHoy05EB
fP9W0Y8EEK836KQA5k0WvSyA/2+8RecFsH82vTWA+sqhHQHkK5c+GEB+36H7
Avh9fA39dwDvt46O6MD58+ipHei/fHpeB/LzHv1SB85XSOd2YL/1I/4HkxOb
pw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlntQlGUUxjdTKzRN2xK7EKWVOuZgTMo0Ya95d5hEm8yaHRtRSa3J1YZS
ZAxJRrQENNRAvHBRVpR1YZdld13g228X8w9spjRJ0xRLsiQzvAxjk7XvY89x
ZAaY33y773vOc55zzvd02tJZC3tYLJYz0V/9nz/h68NsD159YfxtmqZKiouL
+wq/rXxxuZf6kI009VTupZnClsVqldX5dQxZLVXLkmPeEjaWK1uBef0B8rkM
lRzTViFsWanPf184PksNtxW8Jqw+Ve2Z1lHCCWtU9LhhwkaOioaTJJy6Vul8
7tyXq6a2ZxYJ29fp+Nru3L8e50u8hRvweeH4L9SNYbb+kq9rI54LqwLEI3ot
KlRHW1tbhRM2qejfbNG3e5Nqq7An95P4N6tKe3JMf3Lel8rqnNIunFqk9TAf
Isdu0fE6B0h+W6DnQLJjK/hhyXcbPm8lJ32l7298RPIv1vlY5fmRYn3/PDm/
sATfl3jnbEc9Jf/4UuQjel4sVbOiBe0teu2AHveSV+yEnveIfrvgl1td/3PP
3Yj/b/Ki3SqKV7rJrbtx3w1yQhnqcZVcVAa/XiF3l+n7Uy6TbeUqMTHRfYls
lKvOmb6438hDK+D/DnJeBZ7/Qu6sgB7t5NRK9MNZsqdS19tyhhy7B/U7Rc7a
g/N/IJ/bo+u/4QR54l7kc5zs2Kv97fuO3LdK+80hbK/S9397jHy8Cvd/T05y
wJ9yfqkD8baRLftU1G6ZEs+CfTrfnSfJR/bdHf/IapWent7xI7mwGv6VfK9V
476fyHP2o59Fn+B+9Oc5cvwBXV+76Ln2gI4/+zz54gHtl4KfySk10E/q4apB
vBfIVidY6rfCCT1/JZ92Qu+LZHUQ+Uv9Kw/C/7+LH12IX/wyxgU/dIo/XegH
4RIX+usP8asL/SD+u4XnyX+Kf2vhb+G0WuQn/i2qxXz7i3y4Fv0k3F2L/uki
j6jDfBO21cH/0h/5dfC/sFGHfrxG7qpDfYSHuqGn8Gw3/Cac50b+wgE3zrsu
/eLGfBGO89z9PNWj9b8p38/x3H2+x4N6yOc7PNBL+j+2Hn6R+TC9HvfdlH6r
R7/IPHHWo57/SP/VY97K/BnohR8snE8Tvah3D/LHXtRX5pnDq/shvRf5lBf9
cB+5bwP0vp88rgH6yn6xN2h/9JJ9UX7787Ivjjcgf9kHvX3QT+Zzkg/xyPxf
4kM/yTwv9el5OuRR8jc++GOQzH8/+mEw+UU//Pk4eYEf9X2CvNWP+Rcn+8KP
/OPJN/3Q6xnyyADuG0KeG0A/Piv7JQB/Pk82A9BvOPlaAO8XI8jPHUI/jZR9
dAj1HEXecEj7wZJADuK5OZp8Gc+zE2V/BfH9l8izgqjHWPLaIO5PInuD0Otl
2XdBxP8K+bFG1GccOaUR+b9KXt2I/h4v+7ER9Z1APt+Iek0iW5uwzyaTJzfB
H1NlnzbBr9PJ1U3IJ4V8ugl6vk7u14z+miH7txnxzCQvb0Y8b5Arm/F+9Cb5
RDP8MJvc04C+c8hPGtDnHfIYA/PJRp5hwB9z5X3JQH7vktcY2HfzyCUG6jWf
7Dag90Jyq6HjH/we+YKB/bSIfMuAXkvIg0I47wN5PwvhvA/J00I4z05OC+G8
ZeRVIZz3Ebno9nkZ5JoQ9usn5MMh5LuSfDaEfDPlfTCE/s0iDzCh32ryCBP6
ZZMnmNivOWSbiXp8Rs4w4ddccr6J+q4jV5no1/Xy/mliv3xOPmnC/xvJXbi/
LZ/cJ4x5WkgeGtb3Z2wmJ4f1/VOKyLPD0HMreWkY+W+T990w8i8ml4Wx77eT
A2H4cQf5WBh+3EXuDCt8jdwrAn+Xk+MieJ+sJI+NIN698n4dQbwO8uII4q0m
50Swb/aTt0fg9xqyJ4J5dpB8NAJ9a8kdEejrJv8bQT/Wy/t8C/aPlzy6Bf7y
kae3YN4FyPNbMN/95KwW+Kshyv8Bl015eg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxNlntM1WUYx1mT/qBWq7FMK8TBjCwdSkO6UK9pIUYJVF7WyQWpg2yBLIqA
FAgSSbnoAT1AxFUuwuHA4XLunBvmH8e2VovVaEVbzk3XmkVz/mGd93v2fItN
4bP39rzP8/0+729tflHuwTuioqJ+Cv/Tv//3U/Xanxu2Rv7MVCkpKdZc8j51
ORQK5Qh788HZHC9US+Wx5l3CqkiZM5bKX+X8Ej2+8RXhX0qx/mWu/1hz1k7h
+Eq10Ffs3sH9jqkd4Q0yhJOr1ZH0mD0vcv8alWuLq9smnF2r0mMW+rbyvDrE
97xw8XGMp/P8E6q/OL3hGeHmBnUo/PMU4zmJ+LcIW06p8HHXnmR8TardZDJt
Fi5o1vGnJzPeFh3vwgbhmy3Y/3HGfxr7JQnXn8H4Ot7HqALLSYsJwg+2qopY
c8Za3q8V94sTHmpTfycZ7n2Y9z2r9z+8SjjtnHrM0OR/gPc3IT7yJZOu362V
zEe7zlcC1+/tUGvqruWsZn46kb+HhK92Yn+eb/lC1yea8ZV1od5rmL8v1fUc
W1e88IpuFS7PH7xfQTfuy/uHulG/ROa3R+lfzJexB/l7lPnugd6YX0OvCoef
tp7571VN/uUh1iOxT9dzFetV36fz2bRR+Hqfvm8M65vdD/1tEp4CR6ewXgMY
p14qB7A+lfUbwP7U1/bzOJ/6GzqP+z4tfPcg9Pgs6zsIv1DP3w2iPtR72pAK
p29JCXcOqXB5Sl9g/Yehl+3CB4ZxHv11aRh6pv+eGIFe6M/mEexH//41Ar9m
US8X4A+y6wL0Tv/Hj0IP5NpRXe+vuN/VUfidnDWmz1vOpL7GoH9yrBn9h1xm
xnryohnnkdU48kXuH4dfyCss+j5GcqpFz/+GXGCBPxhfuwX1JocsiJd8G1zK
+yZPQC/MT/4E/EA2TiBe9s+LkfnsrzcnkC/y+knkm/3YMInz2K8bJ3U/MfzX
zyexP/v9jUn4je9BohXjrwvvtmL9G/SHVfu1eLewwwo976FfrHhP9grHTUGP
++ifKejlTeGaKZxnoJ+msN9bwlemkP/99Ne0zlfc28I7pxFPHv02jfzkC5un
Ua8D9N+0Cv9fdVD4/hndP64coh9nEE+B8Iczun/YCunPGd0/kg4L/ziD/L9H
v87ifu8LPzeLfllE/4Jjjgj3RsZL6OdZ+PMD4Ttt0GMp/W1Dv/hI+F0b/FtG
v9t0/lPKhb+2oT9X0P926P8T4c123P8o+4Ed+akSbrPjPjXsD3b471PhW3bo
p479woH9PhPe74A/6tk/HKhHg7DfgXp9zn7igB9PCa9zIh9N7C9O1KNZuMEJ
fZ5mv3HCL0bh352It5X9x4X5Z4VzXZhvYj9yQb/twjMu9JNO9icX/Epe7QZz
fpYb+j0nfNSNfLaxf7mhV8b3qxvvF+OP9Wi/5PF+L3kw3sj+5sH6k8IjHuSX
+Vz04H1jvu+ZQ/9mPdQc9MN6lcxhP9azfw5+rRb+fg71oB5WeLH+mPAjXtSb
ekr1Yn2l8C4v8ksu8CKf1GO1F9871Gu7F3onW73IHzmE803k3yLnk2/j/Dzu
v9Kn10fx/GQf/EDO9CFfjD8/wvRDRWQ+72v04XuF+RjzwW/0x0WcV8V8/uxD
PmrZv33wC+txnx/v+XH2cz++V04Ib4uMs74GP/oT61/qx/70S6Mf/Z9+GfTD
vy3s/37om3r7wQ8/UI83/KgX9XpXAP6hXxIDmE+/pAfgzw6+FwHki/4oCuB9
7uL7EUC+uoV7Avg+6OF7EkA/6xP+NoB6DvB9CaD/DwpHB3H/Ib43QawfEd6C
8bxRvj8YTzALFwZx/jjfoyDuOyHcEUQ+rXyfgvg+mha+HIS+ZvleBfH9aRP+
Jwg9O/h+zSN/LuFN84jHw/dsHuudwu/Mwy+cXzmP70E9/18jLWPW
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcx29N+4NarcYWtUW0WqNmzWor/qE9/VimoxQqULssUQm0AinM
kCkwSGQaoIjyQ+T3b47jOI6744C77x1Z7bRMkmlYYJMoqLWKxvijuud9+7wb
t3Hste/zfZ7Pr/f7uftTM5N23WQyma6F/vR/+eyNj0h57c9Hnw3TenVf8fzF
18lb1PlgMCFF2JuqDkRazm3m8ww12ZwVv1VYZari+UTnG1yfrWZyIx97U3g6
R7OFbPpY/R1rLiPH5KnQdz5ZHVItWfGl5LUFqsxY7CB7C5V/MXaKvKlILSQ6
o7fxvGJlLjNyyFmHsZ5sOqLzTXxLuLxUheoxSY45qiJCCb4tbD2mXgolsJ3x
lamHQweQ08sRfyrjrdD1WrdDeKkC8e1k/MeVZd3MMrnkhAotn9nFfCoRT5pw
1En05x3mF+Z04Y4q5JfBfE/p+H/fLRx3Wtcz4l3mX63rGfue8OfV6Pf7rEcN
6pcpvLlWxeuCsD51iG+v8Fyd7uftH7BeZ7Dfh8L769HvHNbvrH4e3Ce8qkHV
VFdX83l6w8r3gw0qLS1tNpv1bVTO6OI9PL+yEfVjvEuNqD/zMTfp+tczf2+T
zm+R9XmwWffzOdavpBnxst4Lzajv//1pQf3YP3uL7mcu+x/Vivw4P3mtWM/5
mm5dOf8vtGEeqJ+ONswf9XVrO+Kl/rLaVVKoANTnRLvuzwPJ7HcHzqe+6zqg
p1fZ/07dv5Qk4Z2d6snQJ5Hz0In9Ngmv6QJv5Hx0ab3HvSL8V5euj/llzku3
3m+A7OmG3vh+TA/y4f5FPeg/45nrwf6MP6EX/aU/WXtX5h9pgd9s4bxZoA/W
b8qC/pg5f33Ih37Q0od6sT+rrFhPfT9lxXrqOd2K/dn/GqsKfedTr0Er+k19
/mOFXjhfa/sR/x7h1H7Un3qs7Ee+nN/P+jEv1N9SP/yXenjEBr1Tf2Yb5p16
+tQGPX3E+bdh3vYL/2GDv+ZSDwPoV55w8oDOz3SQ+hjA+kPC7vD6AuplAP0t
FI62o79F1I8d/f1EuNCOeh6mnuxa72lHhGftyK+U+hqEPo4KbxhEvY5Rb4Oo
T5mwZRD9Kaf+BuFnFcJ3OlCv49SjA/ufEN7n0PHfXUl9OvA++aoD98NJ6nUI
/kl+ZgjzRc4awn1QJdwUXk+eGEI9yDc7Md+nqG+nPq+SvNup52n1aerdifkl
XwAvk00uzF+18BMu5FdDP3DhPidXuaDvWvqDC35fJ7zswu8D8ho3/OaM8DY3
/Kae/uGGPs4KG27E30A/cWt/nyc/NAz9NNJfhlHPJuHSYZzfTL8Jc4vwb8Oo
Zyv9x4P55PMkD87jfkUezBPPd3hwPuOf8yB+8j0jiIf5JIyg/oz34AjWMz7r
CO4Tnn99BPpuo5+N4v7qEH5xFP3rpL+Nwl+7hbtGcR/20u9G4Vd9wreN4Twr
/W8M82MTzh6DP9jph2P4veAQvjyG3ztD9EevCn3nu4Tv9UJvw/RLL+L1CG/0
Yp5G6Z9ezLtXuADP4wz6KZ4v+oUHwu+P01/D758TvhF+/wv6bfj8L4Xv8un4
RoL0Xx/ivyC83of7/2v6sQ/z+I3wAR/m6RL92Yf5/la41wf/m6Rf++AHV4R/
8KH+V+nfPvjNlPAdBvzue/q5Ab1PCz9voB4z9HcD+fwonGMgnxv0ewP9/Em4
3UA8P9P/Dej/F+ErBvKb531gQC8Lwrf4Ue9feT/44Y/keD/8kOuT/Yif+2X6
UR+eX+LHvDC+Rr9CG3mf+DHf14Uvhd9nPRb80Os14dUB6O073jcBzC/r/3QA
836Z908A/jshnBFA/Bd5HwUQ/1fCtQHMH+fHHsC8cL7OB1AvzuNsQPvHds7r
vwH0j/MdNQ69c/4fH8d51MeGcdx3Y8I7xtFvH++3cfRP6+M/JCWlww==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdl39M1HUYx5lJNaKYjhXWIluuUStHtZX/0D6Vq3RsIX+UbmRBSpA1kIYh
kAJBKqWIInqACBy/hfPgjuPuOI77hVaDflmWRQX9IEvmXEIZa9b3876et0M2
uL34fr6fz/M87+d5f+DujJzUzYsiIiK+M771p3xNFcZaXr704BNhWqOeNX5x
lTco40fJS8K+DGV5Zmp+I59nq9bcpEqyylFVgbkEsi9PxRovvCg8ma+Sor4y
X31/u6ozmZbxvOXF2C+d++1UacaGGcKJpXq/9E3cv0yNj42NbRZOKVePGF+v
8rwKnU9NlnDuLmUcfzGb5+9RRcaGW4T3V+p4TK8znvdVZmbm9BvC1r3KKM/K
HMZXpZzxFVtyhbP2I7+tjLca8eUJX67W68+/yfgP6PpG5AvvPgjexnxqkD85
7pC6q+L8Z28xv0OIt0C4sxb5bGe+h9VWIyDyqiPqvrSqJwuZv0n9mZBWRf7A
pOtnI++v03p2ktfX6/rlkpc36PdjyOca0C88z3pUnxdgfAWNiIfxq2PIh/kt
bkI/cH1WE/TmfmNNuv4WnpfYjH4sEq5p1vVOfpv1blYz65yNO4TTWqD/Tta/
BfUqFV5hxvoy6mHG+neEZ8xYX0F9WrH+XWF7K9bvol5tWL9HuLgNelVSvzb0
w3vCq9uVUd6kvdSzHfOwTzi6A/Wror4d+vz4auEvOnS/Zh6g3p3ox4PCDZ2Y
xxrq34V5rxXe1IV4D7MfuqD3EeEHujFPJvZHN/SoE57t1vEP17NfjkP/BmFP
mI+yf3rwfqNweQ/2P8Z+6kE+TcLJvZi/ZvZXL+aTHGtBvVrYbxbUxyw8AW4k
qxN6fVSrcOsJnEdebEX/kx+1quBcwgQ5y4r+I9dZVaozPrKN/XrN8ytW1J+c
2Id5I2f06XnPJ9f0IV/yyT7MC+O/3Af/Id/fr/QHOa1fx1PBeuwDR5J9WF/C
+v3RD79hvVfYsD/5eRvipz67bbofXyC7bfA76jkDTibH2/Gc+qfYdT3TyGV2
zA/7xW5HP5Cn8X4yOW4A/UteO4D42X/F17BlAP7C9ZMDyI+81LHw/NUO6M/4
tjkQD/PpdKB/mf83Dswz6xU9iHlivR8fxHxQn1xwEvulZRD1aec8D6IfO4Wv
d0K/bs63E/EdF37NqftjXS/n3Yn+swh/7ES8Vs6/C/XvF37YBT+30w9cOv5T
A8K1Lr1f4SD9wYX71iU870J8bvqFG/eNU3ijG/3toH+4MY88L4D1AcYz68a8
Md57h6AP81k/hPx6hCuHcD7r4Qlzl/CFIaU/Oug/HvQz653qwX58Xu5Bv/B9
h0cZ5V3F+p/D++k87/Zh3KeMJ3kY+VCPHcML9bAOYz/m9yOeF/bRz7wL6/G0
d6E+BV7oR326vdCX9Z3wIn/W/5YRxEu91Aj6kXrljcAvPfTDEfjHsPCZEfS3
l/7ow/z7hO/0oV/89Esf8gsKP+dDv4bonz6cd1K41If78RT91If5/lDY5kN9
P6K/gmPGhH8JPx+n34bf/0T4Nj/2/5T+68f5nwuv8eO+PE0/9sN/vxQu8ut8
nGfoz37M99fCvX7481n6tR/1/lb4Bz/qN0H/9kPv74WXBHAfTdLPA/CbKeGn
Ajq+e36ivweg98/C+eCV0/T78PNfhTvC7/9G/w9gvn4XPovn5hneBwH44wXh
m4LQ8yLvh6DCMuGkIPS/xPsiiPjnhHOC6Ne/eH8E8f/C38LNQfj1PO+TIPrz
H+HTQdzvV3i/BNF/EbP/c2QI+S0Sjg8hv+uEHwvpeEsihVNCOP8G4ewQ9LtR
uCwEfaKE68Pro4XtIfw9drPweAjxxQhPh1CvJcL/hqD/UuG4UfhfrPBDo/Dv
W4XXjqIf4oRfGUU9lgkXj8JP7zD4P6MWoIs=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcxy8TW8i03DWxJtlyjVy1iq34h/ZULtOxhf5htrG2yFrqCrSw
REokmETJj0QMROX3b46DO4674w7uvneHVGCZpGU6wRXZYM4SjKi0e963z7vB
Ju617/f7PJ/P+/1+Pg8PpKVvemOByWS6GP6n/5ef+/MnN26//uizEVqvio2Z
5h3kV9SN+NSlbwv70tQmZ1z+O3y+TenfGcIqXXPOTr6/C8/fFR7LxPfv8fs9
WH+38KpsVVlRUfE+19unkqLPPbhH+PH9ajzLbMni+rkqXH5itnBKntprtpz8
kPvlK93fPuGMA8psWTeew/0/UeFyduQKlxSq8OO5j1nPZ6g3X9h6EPUeYH3F
amqj83iB8FslWr/4QtZbqhISEmyfCs+WqnN1GUkHWf/nqLdIuOCQGhkeTi5h
P2VqZ1iAUuHYwyowE596iP0dRj9lws3l6s3wTzn7PaL7mzwinPgF+q1g/xV4
Xik8VIHvq6hHpeaJY8Jbjur9XjtBfapQX7XwlSrUX0u9jqnocMN1wh8cRz7I
6gT0IS+sVvUZSdH11LMa+pOHq3U+VjRQ3xr1cGqxQS6rwfuN1LsGejUJp9ZC
/2bqX6v3T2gRXl2n8/VYK/2ow/M24ak6vd9z7fSnHvnqELbXQ18L/WrQ/RR2
Cmc3IL9W+tegvz/dJby2UYXbmemmn43o1y4c04T9e+hvE/ZzCI82qRfHs8p6
6XezPh9Op3BVM/Liov8tWq+oPuGtLcivh3lo0flc5xV+pBX56Gc+WqH3gPB0
K86vj3lpg79+YU8b/DKYn3b0HxDOa9d+XQgyT+2oNySc3AEeZL468P5JYbMF
6w0xbxbs96XwBQv0/4r569Tnufhr4fpO5HWYebSi/xHhp6xaX/Mp5tOKesiV
VsyDb5hXqz4fL38rfNOKfJ9mfrtQDzmtC+fnO+a5C+uTB7vg9xnmGzxJXtON
8znKvHfr9YbJRd3w93vmv1uFf+eQ/+jGPCKvtunnprPCm204H+QCG/JPdtuw
P3nKhryQ4+zzn6fYoS851455T7bbtR/XWM+EHfcTObYH+pI39OD8sN/sHuST
bOlBP+SxHvhN/ZY5oBf1XuvQfsaRdzswT+hXswPnm/6ed6A++h/Ti/PHfDzT
q+ePl3nK6IX/zFtt7/w8jvZCL+Z1kRP6MM+Jzvn53+5EvzwfVU7Uz/Nzyon9
eN5MLvjJ8/ikS69fx/O71YW88nyXu+An58GQC/1wfsy5kEc354UbenCevOpG
P//PDzfmG/cz3LhPOC+m3ZhnrPehPpwP9rOlD/Wx/8I+5Jfn39On/c6hflf7
MP+p9yoP7nv6sckDv+hfngf5oN8OD/RiXq54cD8yT/d6oR/zm+xFXn4Q/siL
+XGe88uLvP0kfNkL/y5ynvWj3kvCL/Qj32Ocb/3Q97Jwaz/2+5nzrh9/r0wI
LxmAX79y/g1gnvwmvGsAfkxyHg5gfk4Jn428f5Xz0Yf1rwmv9CFfv3Ne+uDX
deGXfJhn05yfPt1P5g3h/T7tl2mW89QHPf4StkWe/835Gvn+H+FffDgP/3Le
+nB/3xJe7td+Z5mmZf76Ue9twuv9yM8C4bQI3y681w9/FwqX+TF/ooQ7/Nif
POjHvF0kfMkPP8mzfuhHvtvA/cnv1xjIF/d73sD5Yj2pBvxkvZkG/Gc/RQbu
Q/bfZCC/Nzn/jfn6/WjA7zneBwb0o/6LA8jfn7wfAuifnBTAeSFvDqB/+pke
wN8vXK8ggHnH/WoC8Jf1uME59PMM3l/KfqYC8IN+RgWhL/WIC87X6+kgzjf1
TQkiX3cIbwviPrtTODeI+blY+GhkvRhhe2S9JcIjQdwHdwlPBKHPMuFbQcxv
s3BsCPfbPcJPhKD/cuENIeizQvj1EPy9Tzg7BD9Xhvk/q1aYzA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlXtM1WUcxs9Mq5nldCy15onKSk0No5Au2OslEWOJ1Iwaa4uMaf0hudFM
XaGTZa4UiyyQDATkIhwPHC7nHDjwOxeUCi3TNB2m2CRLKudtzJZ1fg89T4sN
2Gfv733f7+V5vu/dWSvTXxvmcDhORn/t//zpWxPjOnBp+pwhSjGZW0NXesQv
mmPlOUliK8tU5CRt/lrrK8xd+ecPfUU2K01xUdEEsbXKxLiSX/mSfDrXDCzx
7uzW/rfNm0kjj+0nx64zruS+a/t03rtmYTRAcdx6nN+l8zfY8YyMkNM22vf1
hXRfvokeXx4k57xn3/eCpfvfN9HlCx3kgs32/WsCiucD1KON7P4Q+fgV31az
Nsa130teXmDfd2+r4t2G85rJg9tQL4/i/8hEj5/cSN70sYn+zXMrn0KTnZ3d
7yKP/8Tev6Re+YEP7SFXb0d8tcr3U9Snhpz4mTnQ09NTpfyLTHx8vGc3ubvI
7negUvUoRn0qyBk77P2p4tgS9K+cfK7EXJ2cuVXs/txMiRZQvHqnfV+8zjdf
oD+6f3ipvX90tepZatc/V/H3lJrwlcm9yi+uzD5/bh25sAznqT6DZXY9HXvJ
mbvQf9XX2mXXv7qBPKkc+vuvH+V2f5ObyAPlyE/9TKtA/VvITRWIX3oYX4n9
PvK6SuhB+jldiXilr/m70Z929XM36i89jqpCPzvV3yrbT07p+UiVidplhvSe
WI16yw8lQxxW/2vwvfyzrAbnyV/dNchH/ptWi3jEBbXIX/69XGuf55K/M/bY
9c+T/9v3QL+aD7F1uE/zZGMd9C4+V4fzNH9S6+37czSv3PUmelziQXKMC/0T
r3ZBf9+Qe12YX99Kf3uhh0Pkir3w43fSo9uke50jDpMT3Jgv4uVu9OsIudht
x+P9Xnp1w19HydeH+Jj02wC//UDOakA9j0vPDcbrzD9/gryvAfOwV/pugP5P
kqc2Ql8/Su+NiOcUeUuj3Q9Hn/TfCD+fIV9shB5/kh88+P4seakH86Vf/vBg
/v1M9nvQj1/kFw/89SvZ2YR+D8g/4J2/kTcMrf8hPzUhngvk/ib056L81Yz8
LpEXNaMeV+S3Zsynq2RXs13PNwblv2b09xp5bAvi+VN+bEE+f5HfasH8uS5/
tqDejsv/8gnsdw4jj2qF/m4gz27F/SPIOa3o503kXa3Qw83kI622H7JHkm/0
4vtR5EQvzr+V/LoX83I0ucSL92gM+aAX9RhLdvjghxjywz6897eTl/nw/o0j
b/fBjxPI3T7o4U7yNR/e54nkaX7c5yS/7Mf8jCUX+KG/e8ghP/oxiXzZj/zu
I9/fZusx7wFyRhvinULe3Ab/TyW3Yz0wjfw71tfMIMe2Y38cOb3doAzkjVgP
xJNbsJ73KPlcO/Q2i3xHAPE/Rk4NYD48Tn4ngPyfJLsDmIezyWcCqJ8hx3RA
b3PICzrgh3nk1R3Qx9Pk2g7M82Rybwf6t5B8WyfyWUQ2ncgnlbyqE+/Vs+SK
Trw3aeSjnchnCXm4hfufI08E96eTEyy7Hvnav9jCe6Lzl1t2vkXPkNdb0GsK
udiC3haQPRbqPZ/cY2Eeqz5nLej5KfJ1C/1NIo8Lor9PkOOC0GciOSUIvSWQ
s4LI9xHy2iDqKX0UBlGvmeT6oe8fIu8LIn/p7VQQ+ptOHgxifkmfY0J4n8VT
Q9Dzg+R5IehL65kh3C/OBe8XbwlhHui+qhD0pnisEPyneI+H0E/54WII/VF+
t4RRb+U/KYz5qPokhTE/5Y+lYcwr+WMluFD13hSG3uWPsjDeC/XHH/5//w6H
4Qf5ZSCMesovIyKYv3PJzgjqIb/MiqAe8ktaBHqTX1ZEoAf5ZUMEfpVfduC8
ZPmlKQI9Sc8HIujnYnL/0H3yy98R9Fd+Gd8FPT1PntmF/UvJi7Cem0F+tQv1
eIm8rgv3Z0b5H8YdgIg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlntQlGUUxndMq8GyMiqzUSmtyNFCK6UL9qrlLSaVJi9FlqjkpQm0MLxk
6GheSkFDE7wiKIi4LiyXXW5+fLuUf2AzTU2kYUKlMcmYo2LmlLbfsz1PzADz
m+/b9z3nOec8Zx9MSkmY08Xlcp0K/Tr/+TOubWnk6UuDR4ZpvIl0j535k3i6
CT12nyJbScY9tu1ai57PM8ebmuLFJsV0TPbt/lHvL8L7J8mtaSbQGZ0odi0x
/dac++YEOWq5w5PF5mOTnJx89gdyzEoTijdbbK3CeeJJq01zfmqcuHWNCR0X
K05di/PFrvUm9CdDnLXByadJHPWZk//jisez0WTanUX/x5dpngz9KJ+5WWZh
XESzOGazSfD1XSM9rm42y0ICSy9ri8nNyblf+q77HHqJJ2Ujf9Wj11Yn3xbV
q3WrU6+2VnLRNhO67lyb8v3Cub/bL+TY7SYUXv9flX8O6neGfCzHuX/pWemR
6+Tn/Y08bYeJaM6/0C59diL/38ntO/H5c9JrF/TsIKfvdvqj73nptwfv/0Hu
uhf6XZCee1HPi+SmvU78+Zekb565Ep14Ryc5Ow/nXZHeeYj3T3LiPkfP5L+k
/z7oeY08IN+5f+rfqge4+R9yR/j5DdWnAJ93Xf6PywswP13IvfajHjeRl+83
iZl2Wjdy637U5xbyiwfQ37eSiw6gXhHk2wpRj+7k1EL00+3k7wrRDz3IsUW4
707yziLo1ZPsOoh+vps8+yDOu4d87CD6717yoGIT+pvRi5xVjPh6ky8Xm8dC
Fz5AnnYIevch1x5Cvv3IUSW4P4q8ugT9+BC5vcSJv7M/Of6wMy85D5M9h537
Rj1KjnRD72hyutvJN3MgucUNPxhENkeQ32BywRG8/wS5qwfvDyEP80DfoeS5
Hrz/FDnXg3jFTR7o8zT5Oj4/UxxTinqKk0rhB8PI2aU4X/xl+Plw8tVS+LN4
YBn6M5acWGYKUuMiniFvKoPfiq0y+PWz5ItlqO9z5AFe1O958hQv/DaOvC7M
I8jV4fdfIHd40X+G3Lcc/T2SPKnc0dc3iryqHPUYrXkqR74vkc+Ww7/HaL4q
cN5Y8oQKzOM4zVsF/HsC2V2B/F7W/IXfjyf3rES9X9E8VqLfJpIXV6J/J2s+
Kx1/SU0gn6xEf7yqea1CPV4jj6iCH07R/FZh3qaR94G/mq55xvvxb5Bv9qF+
iZpvH86fQZ7vw/1vad59iG8m+Wufk79rlubfD/1mk4f6nXmMTpYf+B3/rXuH
vM2P++bJH/zw1/nka37067vyi2ro/x55RjXyT5F/VCO+hWS72okn8n35STX6
4wPyIzXot8XylxrUI528oQbzsER+U4N+WUY+X4P9ulz+U4t9soKcUIt9liE/
qoX/iytrMd96v70W8em83nWO/yxYKr+qQz6Kb0Ud3k+Tf9VBT+X7cx30TJWf
1eP7g/QbU4/zpG96PeZX9SiuR/1Ur5Z66KH69jiK/JLkf2Cv+mVR+Pmb8sOj
iPd18vdHsY/Vr10tzKv6u4+F+8TDLOQ3lTzRQvzq77kW5k/nr7RQD/V3roX+
UH97Lczn2/JXC/VXPmcszIf6+7qF+Z1Dvq8B/iR9YhqQr/Qb32Ccfwvkxw3o
V+m9rAHnqR7Z4fNUr8Ph8xbJr8PnqX9Ph89T/a82oH4fku+y0T/q34E28lX/
jrbh5x/J3230p/oxzYZ+6tdNNvx3FbnQxr5cLf+3UY9PyCds+Mda7QMb/bGe
3D2AfvxU+yGA+dpIjgtg32VqXwQwL1nklAD8bYv2RwD+k03OC0DPbdonAeS/
nfxtAPnnar8E0D87yN2C6L9d2jdBR/+MPeThQcSbp/0TxPfRfPK8IOIt0D4K
It4D5B1B1L9I+ymIehWTjwcxHyXaV0F833KTbwSh7xHtr0boW0oe0gh9vdpn
jfC7CvKsRvhplfZbI/rLH+J/AdFOeJc=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlntM1WUcxqmkP8jlamxRW2TLNWrlKErpgr0qqRglUHmpkyUqoVYcLZwK
UyFIJBVJJA+gcudwP3DgcIBz4NxQW9DVySyd6IrRoJsDx1hl531O3yc2OPvw
+73v+7083+c9DyanJW2+NSgo6LL/V3/KzyOGgiVLJx9fHKA49UDu+Lex5HUq
tGX5hmXCrmQVMlz1x3I+36L8f/bHCas0dSPCMOclvr9DTSTaT8ULj6SrAs9U
xCtcv1tFRUVZVwnPzVTDVcaYRO63T7MzSTgyS3mnIi6RXdk471XhhBwdfyJ5
JFdd3RPaQjYeUCv8/3iN5x/U6wvIR/NVicl07+uM55Dyb2cnWw6jHqsZXwHe
XyOcehTxkSMLcf5a4elCVW2MyV/H+D/T9TS+IZx3DPu/yXyK9H4Gg3DYcfBb
zO+4sofnblsvbC5GP95mvp/r+EzvCEefQD03MH+TSklJGU0WPmdCfTaxHiUq
wx/QZuG1pdg/hfUpw37vCo+VKaiC9TqJ9VuFd53S+xdtY/1O63yvvic8q1zr
IeoD1rNcJfkTTBMeLEe/+TyyAvXg+qIKvM/zpiuQf6qwoRLM+F2V6D/znVel
/OHsYT3yqtAP1m+iCvmw3gnVur/z2Z+OauiB/Qyr0fEEs/+ZNXr/GepppAbz
RH3G1iqDf0Cof3Mt6pkgPLsO/eH8GOu0PqM5X+frdD9TVrLfZszfCuEys9bL
OOc5qF7p+X9ReFM99Eo/OFePeV0i/FgD5lVRHw2YtxeEJxuQ7yLqpVENDQ4O
Pi/saNT7mZ+jfprQj2eFc5pUjL8gz1BPTTo+T7RwfDPqs5D6akb85NAWrF9A
vbXo/MPJl1oQ/9PUXyv0Q65uRf/Isyzoz1PCCyyYb3KqBfoll1jgXzxv0IL5
Ynz/WKB/5hfZhvhZj+Q29If1KmpDfVjPM23QH+s/3YZ6LBZ+tB35s3+GdvSH
/T3SDv397+ft6Af1cb1dbY8JWUP9zLOin9TXaivq9zLnw4r60b97rNrfQqjf
CSv8k34d3oF5ot8mdOB9+ml2B96nf3YE3qdfjgbepz+GdUKvnL+VnYif85nZ
qfQH57elE/Wh/410op4bhe+2of70g1gb/Jp+sdOGeaCfmG16/Vn63Q82zB/9
bXYXzn9feFEX+kn/MnbBP4zClV3Q+3bOcxfy+VD4djv09BHn2677n75TeKsd
5+3ivNsR/27hr+zwzwzOfzf8L1P4SfCcvfSDwPN9wsXdqH8W/aFbn7c/W3im
G3r8mH7Rg3rkCq/vwfeLT+gfPdB/nrCnB3o8SD/pgd99KvxwL/z5EP2lF/N4
WDgfbOBzRy/mMV/4t17MN8+b68B8M74kB+Jj/DkO+CfzszmgDz4fc6A+XH+f
E358gH7lxPs8b68T+zEeixPzyXivOTFvR+hnfbhfC4SX9aHfhfS3PujnmHBD
H/RRRL/rw3nFwnf2oz4n6H/9qEeJ8I5+5F9KP+xHfieFL/RrP48/TX90QQ8V
wve74PeV9Es8z68WXoXn8bX0z8B6s3BWYH09/dSF8xuFrS7Uq5n+6oI+WoV/
dul5GbbQb12Yt3bhe9zIv4P+69Z+8JBNOM6N+nXRj93wl27hDDe+r/XSn93o
t1O42a30Rz/92o15dglfcaMeHvq3G/n4hO/yoB9n6Oce3C9nhZd6EM8X9HcP
9PClcLoHeh+i33ugp6+F6zzo7zf0f5xn+k74ogfzep73Ac6bf0H4Di/uj2He
D17430XhGC/69SPvCy/qfVk4zQv/vML7wwu/GBGu8KJe13ifBPb7Sfj7wH6j
vF8C+40JB/uw3y+8b3zYb1x4oQ/7/cr7x4f75XfhLT7k+yfvIx/yvS5c6kO+
k7yffKjfDeEhH+o3zfvKB33MCN/0oR9/8f4agF7/Fn5iAPfTTd5nA+jvLVP/
8cYB+OVtwpkD0H+wn/8FTs18Xg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlntM1WUYx5mTWuRqNbasLbLlGjVjFFvxD+3NXKZjS+giFblELNQKpLAE
MnBQSCqgB5SLyJ3D7XA4FzgHzjmca1qDrhTlcIorssGclThGKzvvlz1fB5uy
z36/3/s+l+/zfXgwIzt154qIiIjz4X/6t/ykV/jnU6499swSbVJJUZMPvUh+
VT1QOvsd2Zuhok0bp28+36XfbyWrbBWYj02/+X6uen46P5p8MQ/fp/L7/eqR
cADkNYUqISHBSlafqIJo0xlyfLEaHxtLfonnH0R8LwtvKVF7k6K2buV9pZon
04RzPsPz13j/ITx/XbiyXJ+X8gbjOYz7twmbj+h417/J+CoQ73bhrErUbwfj
rVJtOUnlmcILVSpcrqs7Gf8x3Pe2cNlxFS6XKYv5GJT+tVt4dTXy38P8qnH+
O8LGGjXZmuN+l/meQL3fE048qXS/s5l/LeLJET5bi3ruZT3qcH6ucFq9qqut
vfd91qdBf59DvtyA98nmU9AD+aNGzVM8T53W70eRVzYhPsaT1aTmUhyNjHes
Cd/zeXyzCpcvkd8bmrXeDLxvoRn5fSCc3oJ672P9W9C/D4XXtkKv+9mPVh1P
Xr7wXCvuL2B/2nS9kz4WtrVhHg6wX+0q1RETWSRc2K4cMaV7itm/dt3PsYPC
Gzp0/+NK2M8OdT02vaJUeFUn8vmU/e2EHsqEJzpVuHzGQ+y3Efr5XLjBiPwP
s/9diPeIcGYXzj9KPXQhv0rhdd36vKIq6qMbejsmfK0b/TtOvfRgHqqFXT2I
t4b66UU9TgiX9OL8k9RTL/KvFU7uA9dRX314v1442qTeCv80UG8mxH9KeMoE
vTVSf/3wH3JbP74/TT2aUb8m4SfBReQsM+pFrjMjv2bq1Qw9kv8zw0/I8QM6
/1lyxoAKj+si2TCAepK/GMA8kxcGUH/yoxatt1JyugV+RT5qwXmM12vBfJH/
smCeyGut8APW4xWrvn87ucyK+Fm/YSv8gDxnxX2sf4xN55dP3mLDfJAP2uAf
7J/NBr8hz9igb/Z7tR35kTfbUR/qo9COepBNdj3vCeSLdsRPfd09CP8lbxhE
vOR9g9gfZOMg9EU+h+/jyKuGlvPTQ6gvOWcI80huGVp+38TQ8nhucUBv5EQH
8mc+ux2YZ3KDA37G+nwNNpAjnLr/MazvE04dn4Oc6US/2Z8aJ/rB/p51Yn/y
+aIT88Xv1w0jX8azbRj7gPNdOQx/pR/4h1X4/yID/WQY/aO/PDyC5/SjtBHo
jX5VPoJ+VNBvRqBvvn8F30fwvDUu5Ee/SnVhnnh/iQv1YXyDLvSHfnXZhX3A
fO5z437mm+zW9aplvQ+4Md+sj9mNerCel/C9m/MV7YF/cn6f86AeLfQ3D/Tb
KtztgT7b6XcenNchfMeonp9YI/1vFHroEs4dxTz20A9H0Z9e4Z9GtT/O9NEf
vYi/X/h+L/zCTL/0ar/baBF+wQu/tdI/vaiXXbjYC/0N0k/BiQ5h69JzJ/11
6fmI8G84z+2i3+K+9R7he3zw31H6rw/z5xPe5EM//fRjH/ZBULjAh/kL0Z99
0OMZ4T6f3k93fkm/9mEevxK+4EO8Y/RvH/b/uPBdfujxG/q5H/75rfCzfuy/
7+nvfvRzQjjPj/r+SL9fOm9SuNMP/f1M//dDn+eEf/EjvinuAz/qcV749gD0
f4H7IYD5mBZOCuD+S9wXAdTvV+HsAOozw/0RwN9fvws3B6CnP7hPAtDjrPAP
AfjhHPdLAHq/IhwZxPtXuW+CeP9P4aeCOP9v7p8g/GpeeFcQ+rrOfRRE/AvC
9UH43yL3UxB6+kd4PIj6/Mt9hfvjbgjfwP1TEfOyv0Lo5wrhx0OYl5XCm0Po
V6TwjhDyuVW4MIT4bgvz/7iymh0=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx5nTWmhWjiXWRCvmsLRZbMU/tE/lKh1b4B+Kk9lUMs0WaOEU
yICgkFRAAeWHCBy/hePgjuPuOODL945kDWoWkywtcGk2mWMOyqxZ93nfnrcz
Nri9+H6+n+fzPM/7eX/uqe0pG96dExIScjnwqz/lZ29s6PimmdWvBmmd2hn4
uceb1VuT6SVkY7tKKjTTEvl8t1oZ+MdmYZWi8m4kxGzh+n1q3JLalyQ8kaZG
R0bitvL9gyrM+ubkO8LLM1UA07dxv09VRXn5kh3Ca7JVdHS0PZn756hlgYA7
heNzVei4Zfo9xstTf0QlFe4WTv1CTaaHPb+H8Q/r989/IFxUoN9P/ZDnOaLf
fyRV2HZUv2/dy/MVIv5HwruKEP9jnrcY8fcL3y7W548+wPMfR/yDwvknED+D
+ZQg/ifC4aWIf4j5laKeWcLNZbp/17KZ70m1wRWR95lwzCkVaPczecy/HP35
XHi4XAX0sCmf9ahAPoeFEytVfWpswZesTxX2Oyp8vUoVmrNRx1iv03r/WD4/
UK3XW46wfmcQjzy3BvUk76pB/cgjNTqfedxvTS32I5fUaj1tY/zbtYhfKJxU
h/4Xsf5BLhaOtEC/x9kPC+p7QnjKgvkoYX/qUd9SYUe9zr+5jP1qQH9PCmc2
aH3fOcX+NaipBFdEhfDaRpURSKCS/WyEHqqEFzTpeSg/zf42oX/VwmNNmKcz
7Hez0h+1wlXNiFfH/rcgX4twcgvqX089tCDfBuFVrZj/RuqjFfk3Cc+0ol/N
1MtZ+EeLsPcsnrdSP23Q01nh3DZ93qw26qkN+bcLx7Ur32xUkpX6akd/O4TD
rPALG/VmhX7Jl6zwq07qrwPxu4TrO9BvO/Vo089DHcIv2VBv8i4b6tMtXBFc
76RebdAn+a4N899D/Xbq+rvI28ExLuq5E3oif9Wp6xnmpr470Q/ys11aP+fI
SV1Y7xE+1oX+ko0u9I98qwvxyJF21Iu80Q49k/P/xx474pOn7PArcoQD9SbH
O+4/T47j/vM6HIjPfK45UG9yeLfOf5b1Wd+N+4Oc2Y3+s77WbuiHPNGN+4T9
WeTEfLKfa53oB3m/E/7C/jc7VeBvFvXyoxP6pp4W9ICpt1d6sJ56TO3BftRv
XQ/0QX2P9eA8nIcHXDgv5yXGhXw4T++7sJ7zV+VCvTmf34BDOb8hbpyH8/6i
G/cH/SHZrev/Gv2jzI186C/DbvgN/eeOG+fj81UerK8R3upBPO5X5IF+Gc/0
oH/0o5ng+zzfil7ok36U2Av9MZ+CXtwPzN/bC3+g/9zsRfx7/uPV8z7Cem7w
4j6j3+R6sZ79cHpRH/bruhf6ZX+f6INe2f+4PuiHejnUh/pQT7bgc+rxSh/8
hfoN68d9wHl4o1/fl+O99Ld+FRjfPX3Crf3If4B+16/9vtoQXjiAepj0vwGt
n0s+4X0DyHeIfjiAepwTvjCAeg3THw3072vhpQbWj9AvDfRnVPhtA37zLf3T
gN7PC2cbqO939FMD5x8TtmO/hAv0VwN6/kH4qoH6X6TfGsjnJ+HFg6j3Zfrv
IPzjZ+F1g+jPBP14EPfPFeEMPI/+lf6M59NXhduD7/9Gv8b+ab8L/xKMf4P+
PYh5nRJ+zET/b9LPTdRrWvh1E3q4RX838f1wRjjNRL1n6fcmvi/8Kdxkwm/+
ov+b+L72t/BFE/n8w/sgeJ67wvN9OE/IrNwPPtyXc4Rjfbh/5wpv9MEf5gmn
+HAfPCic78O8PyRc64PfzBf2+JDfw8Lf+6DXhcJTPvjBo8Lz/Kj3IuEIP/YL
E37Zj/0eF473Y7/Fwrv92G+JcI4f53tSuNKP+i8VdvhxXy0THvVDv8uFr/mh
h6eF//WjfpHC4UPQ8wrhF4YwP1HC64fQj5XCO4ag7+eEM4fw/Wp1gP8DeVGT
VA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1w1MlHUcB3ByaEudldEkV6jTHDktjGWsRf3N8oXRfGkZNWYTldBaoo1C
ZYYM5ksJqIC8+YJ3yIlwvNxx3B138NxzB1KdlmmRDkt6IUoq56CcK+2e7/X9
5ea5z+55/s/v//v/fr/nnJG2edWGMREREVdCf41/+WdL4vi+z0fmLQxrmRpe
6Yz536+rs8Fg8jlaS1NR1iVrz8r3G1Xo/teCtNqsCq6tTPhMrt+qrEsGbn1C
X81SRfqopVfu36b6TJmJZ+jpOYa93bLeh8b1sQE6bpex3nZd1s/D9Rq9Il85
YwqudcrzCpQ5M3G8l87cjf11yPP3wi66eJ9aOrA9ql3i+Rjx2+nm/cZ++1ol
viIVutzaTGcUIz6rxHtAPZZa9EIDffOAWuWMGVsv8R9UO6KsZ+roPYdU6DO3
VvZTgvyY6OhS4/uIGtlfqbG+fpS2lBn73Vct+z2M86qkE8oRT7nsvwLnVUb3
VhjxLCmRfFSq0PJZB+mUKqMegsWSn2rlH41NLaKHqo31nIWSryOoH7k++6gR
z8AByd8xrH+IjjyO/JRKPo8b51Ei8QWPq1D6Z0r8cTUqPj7eVkGX1CBfVZLv
GuRH8pF6AvFIvjQ4eIyeZVLTQhuQ/O6Bz5+gh0243yznY8b5yXnZzXi+nGd0
LeKz0Dm1iF/O/2qt+jOUvtP0iydRb1IvlpPIr9TTxDrUe5Ocbx3qt4W+WId8
Sn0mWBCfja62qMqKiofa5PxPoT4c9PpTRnwmqf/eUyo9PX3QSc+tx/PcUh/1
yJf000i9Cn3meqReTqPfpf88pxGP9Of0BqzfRec3YP/Sz0MNRn7ulX5PbkT8
fqmvRuRT5kOUFfNC5kd22D10vxXXy7xRTbDMI3MT9ifzKrIZz/uUXtCM+SDz
LSNsmX+VYct8DIbvl/l5uxnPk/ka12LUR/wXdFoL+u+81HMLzudLuqcF+b0g
9d2C/F6k57Qa9dL/ldR7K/LXRxe2on6/kfpvRX9dom+0oj8vSz/YEF8/vdqG
+XJF+sOGefst7bahHq5Kv9gwDwboGDvO4wfpH7uR76M/0nl25GtQ+smO+H6m
B8Pf/yL91Yb7f6WT2rD+sPRbG57/G21tQ37/kP5rQ76u05MdKlT+mTekHx14
f4zQ7zvQH6PSnw7M07/oyw7U803p13ZjnhXcop9rR3x/S/+2Y778Q59ox/vj
jvRzO+rlrtH/PM6J68fQCU5cH0lvcmL9cXS1E/u7mz7nxLy5h45wYV5NoJ90
GfNjdCK93oX6mkSXuTCP7qN7Xaj3yfQtF+bpA/RcN/b/IL3GjXxNoYvd6Pdo
WnfjvKbSI27Ms4fp2R3G+/bxGDqlwziv69PoffjeOoP2dBj1+fZM+vfw/Y/S
0z2o39n0Kg/uj6XzPaiHObTDg36YSw95kK959FQv4n+CTvbifObTO73Yfzzd
7MX77in6ey/yt4CO6sR5JdCLO/F76xk6uxPz6lm6vhP1l0j3d2I/z9OTupDP
hbTqwvkvord2IZ6XaHMX4llMf92FflxKR2qYT0n0IxrqL5leoCE/L9PLNby/
ltMZGubJSnqXhvnxCl2pYX+v0jYN57WaDmrIdwr9k4Z6e4O+rWHepdJTfJgf
a+g4H/L1Jr3Mh/XW0mk+rLeO3uFDfBvoEh/ie4tu9CG+DLonvN4m+jsf9vsO
fdOH83yXvl9Hv2fSc3Tkbwu9SMfvmffoVB3nkUVn6TiPD+hCHfW6ja7Tcb47
aE3HPMmhL+H5pp30DR31n0tP8KN+8+hZfvR/Pp3oRz4L6NV+7H83vdmPfO6l
9/ix/4/oGj/qZz/t9mM+FNIX/OHfn/SwH/P/ID02gHhL6JgA4i2jnw4g3nJ6
RQDxVtAbA4i3is4L4LyO0FUB5PcYbQ8gvzX02QDya6IHA/j/gpm+E8A8PUlH
d6vQZ66Fnt+N+qqnk7pRDw30um7UQyOd0418NIX8L3S1n/o=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcx1nL/iBXq7FFlohJhoaGUkoPZ18fEjFKoDIscolYai3QRhky
FYMipoIJJIjKMyfCcXAH3B0H/O4prZ2u0mKWFrqiGqy1Js35R3Xf9+3z3mLj
2Ivfw/fz8P68Pzc7Jy9zyy0RERFXQr/6r/zMKp34eunUguVhSlUV3qn4x8kb
VORoc/4TwkaOMoX+8SSvb1OlExmOp4RVHtjE+3equtra2mXCYwUqypKy6Wk+
/4Fac7UwSgnHFqmkpCQbWe1V54LBtOXCicX6+atkY7/KrvAWrBBOL1F/x2ff
uZLnleJ95PyPlW8qPnsVz/8E9z8jXFmudD3IsQfUZIbjxGph60HUI4XxVej7
M9YIb61UocumVMZ7WJ+ftFb4RpifZfyf4v404bIjyPc55lOl3gj9PC8cXa0y
HTGl65hftQqVz5IubK5BfTKY72eo7wvCyUcR74vMv1Zfr3pJ+Gytrs/l9axH
HfSQJZx1TIVeX7iB9anX8QZfEf6tHvdns17HEe9rwrtOqBBObGT9TiLf14Vv
bYB+NrGeDVpvczYLBxt0vypyWd9G1GeLcFUjns9hvRtVS74pku/PbsL9jMdo
UvNCAmL8cc3/z7esGeexPpPNOv+bmexPC/TA+ttbkB/7F92q+S32u6hV63WK
ehlr1fGVU1+r2pAv9WluU7ujLGeo9+nt0DvnJ79d938h5+1iu47nT85rshn5
JQvXm6HnJez/KZz/qHDuKRX63LeYeghfTxRO6MD8L6Q+OtD/BOHrHaj3w9TL
abXDFPnyPGH3afTnIeqnE/HPFS7p1PMwFEc9dcIv5gindWk/ufcB6qsL9Y4V
jrLo80ZnUW8W6DlG+LIF/ZtJ/XVjHskt3dDr/dSjFfW8T3iJFfonb7XqesaQ
66w4bwb1aoX/kP+xon7kxB6tNzM5pwf1JFf16Him8f2f92B+yTd6UE/y/F7k
w/ize1FP8qFe+B/zNXrhf6zPX704nxxng15Yz/U26IP1LrNB37OFXTbMF/sz
Gb7O/sXY8Tz7m27HfnhQeL8d8VIPdjvqT72M2zGf1FN0H86bL7y2D35I/RX1
6fMiFghb+lA/6ncsfP8jwnf3ox6LOI/9mDfOw3v9+rzxJM5nP/T9mPD3/agf
52v6gJ7fFM7fsgHMI/drfvg692nTAJ7nPr04gHi5P29zwN85/8kO+A/9YbsD
+XLf1Tvg7/ST8w7MG/0mwgl/4T5b7MS8cX/lOvE++leNE3rgvjrr1Pms4H66
6UR9uJ8SXPAP7qONLuiT+6jShXnhPvK6MH/cP9fD99OP5w4if+6frEH486vC
5YPYp/R39yD0w33zxyDmj/sg1o3+cV9kuuFf3C8lbvSL+6XfDT28SX9yo57b
hGcMIf/t9KshnPe28J4hzN879K8h+Fm+8LUhfP/YQT8bRn7vCq8exr4soL8N
I973hTtwPbiLfofr5YXCd4xAb0X0vxE8v0d45wie30s/HMH5xcLfjUCPH9If
DXy/KBWeacB/P6JfGpjvMuF1BvRVTv80sO8OCBcb8POD9FMD81khbDNQ/8P0
VwP9PiL8iwG/rKbfGsinRvgeD+bhKP3Xg37UCad6EE89/diDeI4L7/bAb0/S
nz0q9LmvUbjLg/o2069xXlSr8E8e6LeN/u2B/5uF7/Iivw76uRfz1Sm80ot+
WejvXtS7W7jAC7310O+98AebcLsX9eqj/4ffNyB8Kfw+B/dB+H0u4dt9iM/N
/eBDfMPCJh/80+C+8GG+PcJ5PvTTx/3hwz4NCDf6oO8z3Cc+zMcXwhd86MeX
3C8+9CMoPM0PvZ/nvvFjvr8SXurH/viG+8eP7wMXhLf54Yffch/5od9R4WN+
7LNL3E9+1PMH4XM4P/IK95Uf+f8o/K8f+Y9xfwWgn2vCiwKYr5+5zwLQ47jw
5gC+P/7K/RZAvL+H+D8V62yv
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln1M1VUcxpmT2sjVamxZW2TLNWrWLLbiH9rJXCRRAi3DIlf4EuoKpDBF
SiQoJO1CgnoBkTflgnC53Av3BS6X+4ZYA5eTyXQ40aaxoHImxmhl9zy378OM
jbHPzvmd8315vs/hsczstI0LIiIiLoZ+9V/5ebRkKvW1madfCtMqNdaU059E
Xqu2JUS9TfZmqoSoscfn1zcrg38mlqyyVbQ58YP5/bkqdP4Z8kSeMidezp+/
byfOTxZeUgB+neftxv43hJfvQXyreX6RevVyfnSqcEox9qfxvhLljCmZelM4
52u1KfTzFu/fi/U1wuVl+D6d8exTzTkJUe8IW/ar6VRn3buMz6BC5Yt/Tzir
HPmuY7wVKioU8PvCsxWIN5Pxf6fi4uJs64VLDyD/jcynUuk/HwovrtL1b8pi
flVqZHg4eYuw6aC+7/pW5ntIVRuNxo+E4w+rJzMMK7KZvxH7c4RPGbE/l/Wo
xv5PhdNrUK881qcW+z8TnqxF/3ewXke0Pkzcv6MO9/F8dVTnH8f7F9brfAsZ
b1a92hVtHmJ+w/WoH/Nf3oD6bBKubFAZBn8e6zXboPt9jfszGhEfz/M26nqP
sV5Lm3T/Unl/aZOu7/DHwtPgZMab0oz4tgl3gxM/Yb+OYZ31KwAnbmf/wuus
38rjWN/JfoKH8oUXtWC9gP0FD30uPBpe381+m7BeKFxrQj+L2P9WzNOXwhta
oecS6qFVhcpt/kp4WRvmv5T6aNP9qNwrfLNNpTljIr+hXk5A//uE3SdQ7/3U
T7u+P8EgXNwOPZVTT+3QS4VwcgfiP0B9dej5LKsUjjajX1XUmxnxHBIeN0Nv
h6m/TsybUbi5U+t7azX1aIGeaoSftyCfWurTgu+PCFdbdL2eqaNe8f0M+R8L
5vco9duFfOqFM8F+cmUX4m0QPtmFfMmzXegv+Skr6kXOsCL/RuFvrUr/IXut
mA/uv2GFHshLbXp/IXmNDfogl9pUYCZ2nPH22uCf5GmbuhWbcR85phv9Zf4p
3dpPY8hF4DrWqzu8Tr4WXme9F/dgnZwErmN/CnqgV7K5B37Efk70IB/yA3bo
h/1facd7Qd5uRz3JJjvmg/q5YIe/kBc5EB/5RYdev0z95TjwPbnRgf6SRx3Q
I/kuJ/RGjnfCr8hb/se1TsRDPu2EnskRLvSD/JwLeiJvcEEvjP+gC3oln3Lp
/hrIcy7oibysF37Eeq3rRb7k8l70h/X3g5vIN3vx/wX790Sf7peTnN6HfNn/
sj7MG9ndd6eefgvvp96WuO/UZ5ob7ze52I36UO92N/rB+Zl0ox5Nwg/3I59m
+lU//n84JvxFv56PObKlH+/pceEr/ahfC/3MAzYJv+LB/lb6mwf5tgm3eXBf
O/3OA/11CN87AL2b6X8Den4zOoVzB3S/Cy30wwHMS5fwuQH4t5X+6MV93cKP
eFGPHvqlF35gF17tRf8c9E8v9OUS3hP+vpd+6oW++oRtXviNm/7qhd96hK/i
vMIB+m14v1f4QR/81E//9eH9Cgiv8sE/g/RjH+btpPAuH/xxiP7sQ7+/F+7w
Id4f6Nc+5DcsfAnn54zQv33wg9PC9/tx34/0cz/86Izwy37M01n6ux/vxahw
HnjFOfp9eH1MuCW8fp7+H16/IHw+fP443wM/5uGi8D0BxHeJ70MA8U8IJwSQ
3xW+FwHo/Sfh7AD87Srfj4Cer4d+Fm4IwB8m+Z4EEO8vwmdx/9gU35cA5vFX
4cgg/Pl3vjdBzO914ReC0P8Nvj9B5PeH8OYgzpvhexSEvv8UrgliHmb5PgVR
rznhEXw/9RffK3xf9rfw7SD0epvv1yDuj7j1Hz87CH9eIJw0iPosFF4/iH5F
ChcMIt67Q/wvxceHYA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlw9M1GUYx6nQFVaWY6k10YqZmjKyprZGvZkzNZrImlFRTUzmnxZooxBJ
ESH/JaACCogCB/L/OLjjuDsOuPvdgdYO+6PTaVhqk9k050yMudLu/dL32boN
2Ge/9/e+z/N9vs/zHk8npcSvuj8kJOR88Ef/5Wd6Yv7840OzXh+hxSrsjCn1
mPB7Kvgrq4/sScLzXnm+Rm0KN7/pJ6sUvT7EJ+s3qGvLHIe95AtpmiM88v5G
VZ0as6ubPCVTrY8JO+OW/bao29MSx3aSo7eqF4Mfp+yfrYLhxHSQ43JU7tVl
89rlvFycZyWnbleJ+caQRc7fqd/vMpMLdunnaU0SzzcqGM6zDWTLHhXUy6iV
+PLV5OCBNeTVBco3NG2gSuLdqzmxgjy8F/mVS/z79H7zy8g79quLGeHmg5JP
IfIvJk8oUo6I3HX7Jb8irf+xAnJdsSotKZmYJ/kewPrd5HkHtT6OHZJ/Cer1
Nfl4ieoPBGK3iR6latHFjMIsckIZ4v9K9DkEfTeRrxxCPhtFr3J9/tUMcvph
HV9Jpuh3BOs3k0MrsH6L6FmB87eSAxVYL/FFV2J9DrmwEusln+FK+EHyTaxS
Qbte3Cn6V8F/ok+kSesftUfqYUK+ouc1kwq+niF6x1Uj/31kWzX8JPWZUKPP
W1FEzqyB3gekfjXoD6n3gqOIt1TqeVT760fxx8O1qKf4J7UW+x0hn6pF/uK3
eXUqaPdp4sdDdai/SepfDz3Fv5/U6/oHjoof6uHvOvLMBuhRL/5owPNG8q0G
vC/9k9CI/aW/3I26f60t4p8m6NdKzmlCPdrET00qOTl5UPo3thn7SX9bmuEn
OzncjPUyD9LNqKfMiwEz9HOJ/1p0f5tkvlS3/H/+hFpUvCNilMynORbo2SP+
tCAemWelFvS7zLuABfPSIN+16HplyXyMbtX9nS/zM6kVfpD5Wtiqz6uT+dvX
ivrJfB5uhd4yv2e0wd/fit/btF/vfEfOa4PeAfF/G+Z3P/lmG+bfCekHK+bR
9+TlVp3PjR+kP6zw609kl1XrlXtS+sWKeXiKHGHD+tPSPzbke4acbdP1Dzsr
/WRDv50jD9pw/s/SX+2o53nyknY8/0X6rR35XCCb27X+IZek/9qh/2/kcXbo
c1n60Q6/DpK/sGM+XpH+tGP+/E4+Z4d/r0q/dsAvf5Bf7UC9rkv/diC+G+Sq
Dszvm9LPHZjvf5JHO+CnIelvB+L9i7zWgXkxLP3ugN/ukE84cH/+Lf3vRL/8
Q57tRD3uyTxwor/vu/0fFztRnwfIx524D0PJd5w4bzR5pgv1fpD8kQv370Pk
Ahf0HUM2XMjvEfItF/p3LHlqJ/R+jJzQCX+OI+/C83XhZDeeRz1Bvt4Jf4wn
T3Hj/InkeDfq8RQ5x434J5HtbvhnMvmKG/lPIT/Zhfo/Q47tgl8iyZu79HwO
n0q2dKE/niNf6sI8mk4O70Y+z5MXdqN+s8jp3ejvKHJDN+KJJg90w9+zyY/2
6Pn27ktk1YPvN3PIG3qg71xydQ/mzcvk0z2o7yvkUA/yiyFP8sC/r5HneOAv
RV7qgd7zyas96O8F5K0ezKOF5FIP9FpEto7st5gcGNnvLfJlD+J7m3x3JL6l
5PFexLeMHO1FvvHkxV7k+w45yYt5tpy8yQv9EsiFXuj3PrnZC39/QO7zoh4f
kn/14n7+mDzs1fkkryA/bqC+K8kzDNw/q8hvGLifksmJBvyympxmwL9ryXkG
9PyUXGsg/8/IHgP5p5DPGvj+sp5804CfPyeP8eF+SyNH+tBfX5JjfFr/kI3k
5T7Mowxyig/xZpJ3+FD/zeRKH+qVRXb5MN+yySd96N9t5Gs+6JtLHuWHvtvJ
EX70z07yXD/+X9hNjvPj+/Ue8ho/7s88crYffiggl/mhxz6yzQ89Csn9ftSv
mDzoR/0Oku9h/UAJeUIv5lcZ+YVe+K2cvKQXfjtCXon1UZXkzF7obQryv/Nh
gas=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx8nEFVqmXUWWiEmFDE2llF6wn+h8iyZQYS56I3KQayALZ2r5
EhQy9TTxBSQCDuT9PO4OuDs4uPvfYaywrdViNVvZlmuTtebEERV2v+/t+TZv
E/fZ/////Z/n+3yf5/nPzynIfHtKRETET6F/+n/5JYV+D15ftCpMG5TZGGue
S96i1l/aZZon7MtR1nWXdsXyer4KjMVfnC+sCtSIpTBlAe8v0s9XxAn/UqxM
oQMe5vPvq9Dxix8Vjt2jss1GcTzP26tKr2S4Fgov2a+vjyXw/AN4PlE4vURt
Df0W8X2lqqqysnKxcOEn6sLw8PBjfP9BlemKiVwqfLQc8S9jPIcQT5Kw7bAK
yeV4nPGZVdSI5c8nhPOO6utJKxjvMeiVLDx+TO02Wb94kvF/Cn2fFi47jvif
YT4VamEogBTh6BNqNMMV8yzzO6FCf/cp4eaT0HcV8z2l801bLZx8GnquYf6V
ut7xa4WHKvX5NeuoRxXi2yD88hl1PT7bvJH6VGuemSb8O9j8PPX6DM9vEt5Z
g3qkU7/PVUrUyIJM4am10PcF6lmr8099SXi4Vs0rvfJNFvWt0/oX8npFHfzG
88brdD29fH92vXLFlF5hvL56Hc/9zCfOAr2Yf5kF+lKvUQvOo77pDbq+EyuF
nQ3wD+sX3YjnWe89jfDfctavEfWkn9achd/ox+azantIIPp3RpOuXzL9XtiE
fmV/fNeEfNhPyc3Qm/1X3Yz3PcT6t+j+sbK/c1u0P9ex/4daoNcc4cRWnBdN
f7Tq+DbfK3ytFeeb6Jc29Oss4b42zIuZ9E878rtDuKQd16fTT+14/nbhtA74
9Tb6q0PHt22asMmKfplKv1nRj7cKXwxfv4X+O4d+ixBuOIfzb4yJH22YD5PC
y8P8r3CeDfn+I1xl0/Fn/y08bINfJoQnwSnkJZ3o17+Eczp1P1jIFZ2qoTCl
nHy+E/1FHu9Ev5AT7PAjOduOePi+I3boTfbZoR/jvWq/OZ84B+IjZzmQD/Mv
c8B/1McTZuo36kB81DfGif6l/ulOxDtF+IAT9WL9nE70Q6TwZSfqx3pHd8Hv
9MPGLtxPv+zpgp+ihK1d6O8Z7L8u5EP/ze5Gf9Gfa8Cuu4R3dKN+s9mf3Zjn
dwv/2K3zy7iH/dqj/XWZ/bGyB/uA/VPYg/nI/qrvQT8+wH7uQbzsx2ku9GMM
+9sFP3Afv+NC/Ozvahfqx338tQt++n//unE/58UyN+Ll/s11Y55y3550Yz5w
/gy5UT/u2wk34ud+TfSgvzjPXvPAX9ynRz3wI+ef4UE+nI/XPMif+/ORXvTf
U5wvvfAD92d5rwr93cd92YfrqdyXf+B6BOd3bB+eTxXO7MPznPcluJ7K/djd
h/ev53zqQ/25H+d4oe9znFde+IH78EPvzfvQ5oU/uQ9/9WL/cn+Z+qHfi8Jr
+/G9w/23sx/zcbNwaz/8vIXzrl/HW/qK8J0DiOdVzr8B9M/rwkUD8MsbnIcD
qGeO8PcD6K9c7msf9NkqPNeH74E84eU+1DdfeJMP820b97sP+/td4f0+9FeB
cJVP6xm1XdgRPq+I3wPh894T/i183g7hyfB5O4Xv8yO+Xfx+8EP/3cIb/Jhf
Hwjn+NGve4V3++H//fze8EO/j4Q7/OifEuHzfsyPj4V/9qMeZfw+8WN/lgvP
MrB/DgknGKjvYeHVBvxm5veMgX18TLjYwDw/LnzEQP4nhJsM6HmK3z8G8j8t
/IOBelcJXzVU6O++auHpAfinht9LAXy/1QqnBBBvnXBWAPFahAsC8HejcFkA
9WoSrgvATy3CngD6pU342wD0bRceDcDvVuHIIOaHjfsmqP38pl14RRD7xcn9
E4Qe3cL5QejRw30UhB5u4TNB1K+X+ymI+nmFL+D+xQPcV0GtX4Rf+AbuHzG4
vwbht6Dw0kHofZ77bBB6Dwm/hfvjv+R+G8T8/SrE/wGbJW6X
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlgtMlWUYx6m0Fjkro6k1ydIZWppKM2eir3k3ZqDlJYkZXgKdA5mYIimo
TGTKRdEE8QIH5aIgcA6Hcw4c+M7hILagZjkt0xldGEu6WRhzDfve/9n/cbEB
++287/M9z//5P893XoyJX7Lu4YCAgJvmr/7Pn/TbkY43746f5aeFqifSEfyA
V6psb2/ZNLIRozaHBS4XDojTn4cIq3jcf3A+UV2zJIQJf5+kquZ3Jj+4v121
9IbcEB6ZojlKnq92Kf1vOnlimo7nFjZ2qwWdyXlh5Ii9aokjOH2GPC9dlSSE
Zc4kJ+xDPUqev1/Xc20WOSdT3Q2JenK25HMA+cwhVx9UoaGh1rmSX7YqyM8f
Pp8cm4PnL5B8c3W99xaS+3JVVLY36W3J/xA+DydnHNb1pi6WevKQTwR52BFl
pmuJlPqOKLN/U5eSy46innel3k+VeTxhGXnqMa1X0AqpP1/fd6wkX8pHvatE
jwJdz8APyCuOK/N6VbToU4jzq8ndhVrvwBjR6wTiryFvO6nGmgIIq1MqyBRA
7g84jedJ/NjTut5Rkk/7abXDvCD5TyxS680f4bwi+OV90bsI/pD7UcU6/wlS
j1GsOtrb2+V5oy3KbN9GySfD8v96eizwj+QfUaLvh68j20q03n+sl36d0f7I
jyWnnME8bJD+ndH5d20kzzmr+529Sfp5FufjyYNKdX63E6S/pagvkXylFPps
kX6Xab/1JpELy+Cfj6X/5Zjn7eS15ah3h/ihHPOWQn61Av7dKf6owPynkv+u
QD/TxC/nkN8ecuM56JUu/jmPfu8j7z0Pf2SIn85jX2SSwyv1/IUeEH9VQu+D
5KAq+DNb/FaFfuaSb1Qh38PivwvQP49ccgH6HBU/Vut6PjxGnlINPxaIP/F5
53FyAT63nBC/+u+fIvf77xeJf2vw/GJyTA38VSJ+rkH+Z8kXa+DfMvF3Deov
J4+rxbydE7/XQr9Kclat1vetC+L/WuhfQ75Ti3molXmwwo828jIr/GKX+bBi
3zvILivqccq8WNGPBnKwDf5xy/zY4O9m8m4b8vHIPNmQj5fcZYOffDJfddD3
InlRHfp7SeatDvp8Rq6qg58/l/mrw77uIA+xqxdMAb+UebRjv18mb7Wjvq9k
Pu14H1whX7dD76syr/WYx2/IM+qxf6/L/NbDP9+Ri+uh102Z53rEu0V+1IF4
nTLfDsT7kbzBgXg/ybw7EK+L/IUD8bpl/p2I9wt5shPxemQfOFHvr+SjTtT7
u+wHpzL/pv5JvueEfn/JvnDBH73kaBf2113ZHy70o4/sdeF9fU/2iQvvl3/J
YxrQ337ZLw14f94nZzboetoe+of7pgH79xHybw2Yp4HkkY14fz5GXtKI/fc4
eW8jvp8Eku2N0HMQubsReg4mP+fGfnuKHO5G/UPIO93w4zPkajf23bPkH9zw
91ByUBPeb8PJ85qw/54nb2vCvIwgVzTh/R9MvtGEfTKSPLgZ+b5EVs3o12hy
YjP20xhySTPeHy+TrzZD37HkAQb0fYU8woC+48lTDMz3a+R3DPhrEjnWgL8m
k9MM7K/XyQUG/DCFbDUw71PJ7Qb0mEb+2YAe08n9BvQIIw/1oH8zyRM9yvyb
Oou80IP9Npsc44Hf5pJ3eOC3eeQ8j9bv8gJypQf7fxH5Is4nh5NveeCPxeQ+
nB8VQX7aC70jyeO82H9LybO92k8n3yNH4XzScnKSF/O8kpyF88GryKX++FFk
A+fbosnf+uOvJt/x4vtjDPmJFsRfSx7dgvjryWEtiP8ReRnOt8WR43H+5EZy
Bs4nbSIX+ePHk13++JvJX/vjJ5J7WqDPFvJAH+JvJQf7EH8b+Q0f9E8mR/ig
fwo5zof+fkLejfPtu8jHcd6SRrbhfPIecocP85RO7vLBP/vI933abwH7ycNa
4c9M8qRW+PMAeVEr3k9Z5DWt2Ic55BScn3DI5P8AHS6HwA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx5mTWlhZ7lZYE3U6R84Ic6m1cL/MIk0nsiZUVBNfQrNADV+A
FAl8TQE9URAROJAX4Ti447g7jpf732GusOZ0Wg5n1CSWzJn5lmvW/b70fTZv
Y7fP/r97/s/L9/v8mJicGr9yREhIyOXgn/7mJynfuN1158U3hmm+0twp/L5a
FxN2sYPcnaze6c8we+X5ajUj+Gknq1SVd22Jyy3n16uhJa4IF/mXdLUq+HHK
77eokuLiYgd5QpaOZ2+ReNvANnL0dh2vzCrxc3S+6Q3kuFx10ZIWUy/vy1Nh
Fy03ashpO5F/tbx/twqWG2khF+zB+8oln29Uf4Ypqoxs24f3H5X88lW8KyK0
mJxSgPqKJN9C9OMg+V4hzhdK/gfUmd7ehfvJuw6qO5FJ+XulHrN+3ruLHH5I
6a8dUt8h9P9rcm2RMlljl2VLvYcR7yvy7COoL0PqL1b+25F9m8inixE/XfpR
ooLjn7SenHhUvZCUPzdV+lOK960lD5bq+vJWS7+O6d9bVpE3l6ng489WSv+O
Qx+fkkeWq/F5186mSD/LVVVazJ415N5yzFfeF10BvX5ONlfoeVklv3sVmMc6
clIl6tkg/a9E/V+SJ1ugx40yD4vWf8Jm8pBF68ck/YurQr6ZZEfVw/0Or8Z8
t5GzqvXz0dtlftX4fQ553gn8PlfmeUI/XyLzfrwG7xc9pNXAn7vJ52uQv+hn
dq2uL2kfubQW9efL/Ot0fwYKyCvqtB9qD4ge6rR/0szkafVaz7NF3wX1yhrb
f/8w+Va91ochfkg8ifmJX7wnUc8x0U+DznfscXJug9ZTv/hvsAH5VJIXNiKf
KtFXI/I5QTZZFdomerPCP3XkPiv8f1L014T+NJKrmrAPmkSPNuwP2T8zbVp/
HbKfUmyoT/ZXiQ31yX7rtT28/x7YtP6vyX6MboYfZX8mN+v8s2XfmpuhH9nP
p5rRL5/ouxnzM8hTWxAvIHpvQbxT5P0tiHda9N+CeN+Rb7Yg3vfiBzvinSEv
tcPfP4o/7Kj3LNljR73nxC921HueHOFA/y6Ifxzo30/kHAf8dkn85MA8+sgD
Dvj9svirVWWarN9eIS9oxXz7xW+t8P9vZGsr9HJV/NeKffw7eYwTfhoUPzqx
v/4gb3TivhkSfzr1+2Ovky850c8b4tc29PNP8pw23Ad/iX/bUP9tcmUb9HhX
/NyG++dv8iMu+O2++NsFff9DXuPC/fRA/O6CX0Lu/s8/uLC/R5BD3NgnI8kv
u5FvKHmFG/k+Si5yI9/HyKfdyHcU+b4b+T5BnuZBf0eTP/agv0+RCzzw9xiy
4dH1ZZjItzzQ6zPkKe3QVzg5sR16GEve0w49PE/2tmMfjiNfb8f9M548wYt+
TCTHe9GPSeRcL/oxmez0Qr9TyINe7OtI8nMduA+nkhd2QG/TyFs7dP/Cosg2
nO9/ifxrB/w2nWzqRL9nkN/uRL9fIW/uxP0/i1zfiX6/Su7D+b7XyE924X58
nay64Oc55PVd8J8iV+F81FzyhS6lv+aRR3Zjnm+Rx3Ujfix5Zrc+nz2fvBjn
E94lp3TD34vI23E+ZDG5ZDh+HNk+HD+e3Dsc/z3y1eH4S8kPcD4qkfysD/E/
IEf7EP9D8nwf4n9ETvahP5+QM3E+YRnZjPNRy8mNOB+6knzKh/6vIl/xYb4p
5Hu+4f9vyE8bmO9a8lQD8/2C/KYB/aSRkwzoZx053YBfN5D3G9BnOrnGwD7c
RO428P/UFvLPBvSfSb5pYH9nkUf5cb9vJU/2w1/Z5Bg//JVDXorzc3PJqTg/
dgd5lx/3605yhR/+3U32+LF/95LP+bEf9pGH/Lh/8smhAeipkBwRwLwPkmcF
MG8zOS6AeReRVwcw7yPknADmUUI+GsA8SsmOAOZRRj4TwDyOkwcCmEcF+d8A
7icLObwH/aomT+9Bv2rIC3rQrzry8h70q56c1YN+NQT5Pwjdewg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxNlgtQ1GUUxRnTmrS0nJ3SGlFHx5B8m88R+8InSiHkkBZZQBKaBVIYig9k
IBVT1EBbJOMpD2Vd2AV2FxZ2/7uYTVhjOVamY9TIOMlYWaQ5jbXfoXOLGQZ/
s5/3/91zzr3/HZ2QErO2X1BQ0OXAr/77v5+s8bcmPtP3zwhlsizpChFerTle
2JOgYhzBA/77fJ3KNFk+eYKsUlS+0Vst7ElTYQO/Lhf+Pl2Nj8s3hIM2q8Dj
7giP2qrOdnZGSn21Q+Vej3YIT9mpebbc15Otz3cKr8hRgfLpofK8XDU98PMk
OXUX7j9Bnr8H/QofyFMjc6+fmyj3eR/1J5Gt+9TGQEOT5X75yhGce30KOfmA
qkgNGzhN7nsQz59Ovn1Qn3/jKbn/Ieg1g7z7A9SbKf0UoN/Z5GGF6o+QuPw5
0l+hSkpK6p5Lrj6s/VgyT/o9orq2mCxh5Nkfqp5oR/DT0r8Z9RT5jBn6hIse
RUrnYwF51VHNQYtEn2J8vph8rRj9LxW9PlJLu7YURJAzjuH5y0W/j3G/SHL/
Ep2P8OdEzxLoHUXuLFGBOKVGi76leN7z5IJS6LlS9C6FHrHkuDLo+4LoX4b+
V5PHlsOvl8SPcuXrDbkUR+4p1/rkrhF/KvT9J71KtlfgfLz4Vanvl5dI3loJ
P9eKf5XwL4m88LgqMpvNyeLncczDevIDVdB/g/hbpe9re5N8vgr5ShG/q6H3
RnJxNfRME/9r4M875Ndq8LxNkoca5CGDPKEW87tZ8lEL/zPJv9eqgD1h2yQv
JzDf28mtJzDPWZKfk5jXbHLOSeiTI3nC57255Mg6/P9dkq86XX/LHrLJgufv
lbxZoNc+8iUL7r9f8ncK/hwgV5xC/4ckj1adjyEF5JlW6Fco+bRqfY8dIRdZ
sS/NklerzmPIUfJdq87vL8WS33r0c4ycUA89SyTP9chvGfl0Pe5TIfmuR94q
yaEN2LdVkvcG5KGGvL8B+p6Q/DdAnzryzQbsO4vMgw15tJJjbeivQebDhvzb
yS4b/G6UebHh/dBMDrYjb06ZHzvqtZCz7ajnlnmyo14buduOeh6Zr0bUM8jL
GlHPL/PWiHk+TbY0ot8zMn+N6PdT8tAm+PmZzGMT9DtL3tQE/b6Q+WzC/jlH
vtgEP76UeW3GPjpPnt+MvF6Q+W2Gv9+Qy5q13sMvyjw3Y199R77Xgbxclvl2
IL9XyOsd+vlxXTLvDuj5I/lzB/q/KvPvxPuumzzNifxck33gxL79iXzYif3c
I/vBqfU33SDfcWKf/Sz7wqXn0f0reY0L+/Y32R8u+NVLNlzw65bsExf2z5/k
cS2YvzuyX1qg71/kvBbdX9Zd2Tctur/ooNv/8o0W3d+YfuRRrdgv95BjWpGH
AeScVuThPnJTK/S4n3ytFf4NIj/mhn8PkiPdmPfB5O1u7J+HyFacNw8l/+BG
3kxkUxv22SPkxW3Qexg5ow35GE6uxXn34+RLOF8wgjy4XfuTNJKs2lF/NDmt
HftlDLkC57vHki/gvHscub8HfoaQR3hQP5Q804P6E8hROD9kEjkZ57snk3fi
vHsquciD+08n2/rqzyB39tWfRb6K86Y55Lse6DOX/KgX+s8jT/Gi/nxyhBf6
K3ICzoeHkzO98HchucALfxeR67zYT0vIp73ITwT5ihfvu+Xk2168b54lP2zg
fR1FDjWQzxXkBQbyGUOOMzCvK8npBvZLLHm/gfyvIlcZeB+9SPYYCmXI3xqY
r5fJNw18P3uFPMiH7z/x5LE+zG8iOczX9/2GHOuD36+TU3zwO5m82we/15NL
ffBjA9nlgx9vkb/ywY9Uco8PfqSRB/ih19vkYD/0SifP8kOvd8kr/NBrM3md
H3plkrP90Gsb+agf+2gH2e7Hvs8in/Xj+1g2uduP/ZxD/tuP/L5HHtaB/O4m
T+1AfvPIyzqQ373kxA7kax95awfylR/gfwByWnae
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979838.5315},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 11000.}, {979945.64, 982087.81}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.75942736970368*^9, 3.759427408245843*^9, 
  3.7594276303278666`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Linesmt", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", 
        RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "11000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6897563694622307`*^9, 3.689756387670404*^9}, {
   3.689756446931783*^9, 3.689756448760599*^9}, {3.6897582592374463`*^9, 
   3.6897582599405603`*^9}, {3.6900347042932234`*^9, 3.690034713926163*^9}, 
   3.690746444579601*^9, {3.6937734051374702`*^9, 3.6937734358784947`*^9}, {
   3.6937735004785967`*^9, 3.6937735397440205`*^9}, {3.759169582653611*^9, 
   3.7591696330239077`*^9}, {3.7591712253765883`*^9, 3.759171245343167*^9}, {
   3.7594201415974803`*^9, 3.759420141805921*^9}, 3.759427262115546*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmC1uEOuwqNAUMUiQxfMeMejKnaTaRNbQiN0kZlhukIw0Z
CZOFZoJKGKAEHMqLcB7cCcfdAXf/O8i2s2Y6TKOUnBcqNTM0Mifd88XvE5uy
z/78n+f39jx305LTEjaP8vPz+9n3T/7mT1zAxfDxN6NfHdFKUVpSUjJB+W1R
nR4XEEQ7koVhRV/mRPV8i0hJSfE+QYs0EZp3a+2T6u+3CR8tT9FXM8TAWktI
sHr/E+H7b/ckOixLuO5G9k5W630q34+dQsfkiHuRSQVT1fq5QucLKISO3yPm
+X7C1H55iHcanf6ZmJlUoD2r9t8rEiwhYyPown1il2/B51Q8+xHfdNr4hVzf
NEPFV4D8I+nUQhnfhCgV70HE8zw9dBD1maXiPyQsIXkfRtP5hxHvbJVPkaz/
vhfo4C/hGJXfiOfQtcWId67K9wjWn0fHfoX956v8S0Rfpm72AvpMiXzfb6Gq
R6msxzfK68tkvfIWqfocRX9i6f6j6J+y8RjyWUzvLMc8vajq9zXiVx5Tgf2X
qHpWyP5uVM89FZgntX9MJdZT8RdVIj+V/1Al5kXVL6kK/f+//lUi4KL+9kw6
Qi/nf5Lqb74e+an5GNBjfTVP8dWy/ylq/szVcr30Z1S/jiN/Ne9ZI1bn4+px
4QsnQ52nZSfQL3X+ak8g/0A6sEac9XhWP6b6W4P58qcv1CD+0arftXK/+8M3
HvlorfjId+Af0H51sv+Gf+hNdejvPfpMnfz7dX/Rs+qFvC9u04X1qN8APViP
/tyg159Evl7aflL4yhN3jQ5rQHxX6D0NeL+X7m9APS/RqxtFgXY3soc2NmLe
fqB1BvT7e3qnQfZ7qYfuNSDeM7Q4hfuui64+hb/X6DFG2Y9bHfRCo3i9L7PI
RqcaMR8WutSI+pppjxH5N9EPjeiPgY5pwn1STyc3Yb5q6KIm7K+nu5vQnwp6
qAnrHaOjmtHPEjqpGfkU0weaEd8h2tGM+S2g7zSjH5/TESacz3w60STz1+XR
+SY5D/oc2mrCfZJND5jQz0w6xIx4dtDxZtwv2+lcM/JPp81mxLuV9pplv5O2
0MGncf9vpledRj7JdBbs3UAbRp6/S18deb6OntiC52/Ry2BvPP3xyPM36doW
7L+SvgxvXE4HtmI+l9Ivt+I8vUKnt8p8zy2hq1pxvmPpC624r+bT/hacnzl0
rAXzE01/YMH5iFLn3SI/b8un099Z0L9wdf7b0N9Qem6bkL+mqPugDfdTMF3c
hnro1P3Qhn4E0ffbZPyeceq+sCLeAHqDFfPpr+4PK74PjKY1K87vcD/vEyvi
eUBPt+E+GKLX21DfQXqfDfX7k7bbMH+/03/YcH/dpMPsOM9eOsGO/a7Re+y4
j6/QLXbM4090vx3z/CM9uV3Wv/YCvbod9T5HZ7fL9XefpY3tqOe39K/tmP9u
WteB+DV6eQfi76R3dqB/Nrq+A/dbK93bgXkz0+M7ZT/ajbToxHqN9LZOrFdH
V3diveN0TyfWq6LHOLBeOT3VgX6W0QsduK+O0GscuM8O06kO9KuQznFgnvfT
pQ7Uby9tcmAe82iPA/3Poa8jnrhs+iHiKc+kn3aivzvoGCfO63Z6pRPnLY1O
dqI+W+ldTuSTShc50b9NdKMT3x830t14X/8efQXvj32HHsL7KYl0kIb9E+go
DfuvoV/TMD9v0Eka7p8VdIaG/JfRBzTkL+gaDff7S7RDQz8X05c0zNsC+o6G
+s+lH3fh/M2mI1w471F0nAv3zww60YV6hdNpLsQbSue7EO8UutKFz+Ng2uqS
/b6ro8+7cD6C6AEX7pNx9Fg3vg8G0CFu9NefXuTGvI6i4934/Bz+7ZG3uJHf
v3SuG/n9TZe5kd8gbXajH7fps27M4wDtdeP72Q162I377Tod3IX56aPndKEe
v9CrulCPy/T7XTiPPXRWF+btvM//Aes3XeI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1g9M1GUYB3BsWk1dTncztElazJF/kqAQs7M3YhJqdjIzrJsWKCpmootG
yhJJJjITVNBANJBTEOE8uAPuDg5+9wdjE22VWZkWNDNSKua/kSvt936v7+uM
zXOf3e/3/nme533em5SyPmnlAyEhIRf1f/J//g3/tmpg7ZXpLwWVKHRnvKu8
VKSlpV1W1lLEU+bCuHXq+zXild5NxcpivTjd3d2trG0U5kLfTeWeTGHJMA5/
T73/4f2emC3nH7g33hY5n085cqvQP3PujZ8r+hc5w5RN20TvJoNVrbcnD98r
Z2yX68m8t98dIu/qImc6XVQg/DcjLqxR69kpnGF5V1fTtk+EwZrQu0qtr1Do
4fKk0auLRJL+wkq13t0iWv9bQQ/uFpsN1s9T1Pr3SCe8Q+fvlc/bl6v9FMvx
hi2jQ0vwvFntrwT5epOu2SfjWZCs9rsf+VlCx36K7xer/Zfi/SS6qxT5Nal4
lCE/C+nkA8jHfBWfchmftYl0XznWm6DidRDzx9NZh0RZaem4OBW/z8StCHPh
i/TQCpnfEKOKZ4Wsv7TZdHcF4q0cWYnnX6CLK2U+Y5UHK2U+zcrmw9ivsvY/
h1fd/3x+FfKn3F+FelbzmyzCqA+g7LDI9RmVQ49gvc/T2UeE/nqEcs8RoZfT
pll0/FHUY6zK51HU40x6ZDXOY4zKb7XYoC/gOfpsNernWZXvGtR7NF1eg/MQ
pfJ/DM9H0ivg6BmqHo4hf9PpabWYf6qqj1qMN4W+UYv6jFD1clyu743JdFvQ
4ap+6lBvT9Db6jDeRFVPdZhvAr2gXn5/6DFVX/WYbxxtsOL5sarerMivgb4A
D4xW9XcC9TWKtpxA/xqp6tGGfA2nY2yI50OqPm3I71C6zCbzeXuIqleb7EdP
3/3tP9+xob7+piMbhP6Z8xed0iDPR+kturgB/ew6fbIB9TFADzZg/t/pKY3w
FdrciOd/pXc1YrxLtNaI+Xrpa43oXz/S4XbE5wd6iR3x/o7Ot8v6f/Ib2m3H
/r+k++2I5xk6zIH5TtEmB8bvonMdiFcn7XAgX176sgP12k6HNiG/rfS8JuTL
SWc3oV87aGsT6rmB7mnCfqz0mGac71o6vhnnu5r+oFk8rgfUQtcEn6+gzzej
Pg/SI1tQ32X0nBbU5z46owXx3ksfbkE8i+izLcjnTvpBJ+pnBx3rRHzy6HQn
+nsuXe7EedpCn3EifpvpEBf2n0VHudBP3qdXuJCfDfQ+V/A+p7tcWH86fdsl
+/moVfQ0N/KdSi9zY39v00Vuma8aM+1zo/8spW+4Ub+v05Nb0V+T6ORW3EcL
6QI4bj7dFvw+gf6jFfuNpye24T4WdFIb3jfS22DfLLq5DfPH0H2wJ4oe78H9
M4Ne4EG8p9IfeVDfEbTNg/oKp3/2IF+TaEM76nUCPbcd9/F4Oqtd6J85Y+na
duRnDH2hHffzKPqRDpyHEbToQD9+mN7YgXgMpS0d2M8Q+lwH+sc/feyPGtZ7
m56g4T6/Rcdocn0h1+nXNKznT3q1hvvtKr1Vk/1iQR9dpiH/l2i7hvrppbs1
xOci/UtwvvP0neB85+hHvajvr+hIL/L9BZ3oxf5O0SleOb6hi97sRbwDdLEX
vw81ut6L/uChT3pRHy76Jy/W30wPenFeG+nRPpxnKz3Fh/wcp1/2Ybxq2uzD
eBY604fxKuhdwfHK6ergeKW0FhyvhP7eh3zuoa/5cL530SP86F8FdLgf+dpO
G/2I38f0Ej/6QQ693o/7M5vO9yMfWXSlH/WWSbv96B8b6K/9uF/W0f1+9MN0
elgg+HucDgtgP6n0zADyt5w2BVB/b9Fr8L4xmc7F+4cW0wcCmN9EO/C++VX6
dAD1mkhfDuD37lz6bgD7j6NDO7H/OfQzneh/s+l5nThPM+nUTuQzms7uRPwj
df8LYsBreQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmpE2zsrrlSxO1nKmp016MzZFPWpKMprJput1yoZJaC3XD
iTJfEFNJERTUQzQQlBflPLgX7vAO/ve/P+oKbfZi5XBCTUZKzUzT2Ubd8z2/
P9ic+3j3/z/P8/t9fw+OTc9MWzkgLi7uevSP/ps/9v3mfePWlHdimqe6Ntmm
hsVLlc2Z/LHYSFdVa5Py+z9frb/vFKtMdam9vb3/++tVRkZGt7gzSzmTux71
P5+t3zfYpMfkqFKHY4RYbVXR7U0QT9uudt5emCg2ctVE+/7Z4gV5anT0C+LO
nXr9DPHaXSp63ixx3B71z4Tov9CF+Xq9mv797FWbbc4LYtc+5U/Yebt/f/vV
+9ECROhVhdiPeFqRGvxT5VrxwyK8X2wc0PXtEu8+qHoX+hMsOU8x6i8eXqKS
oi8Ud5ZgP+KaQ+r16E+bnPewrvcmceIRvT9THOdA/c/TFx2on7iwVPfDIV5y
VK2LbkA8pgz9ukD3lKEe8rnrmN7vy7K/jcexv/76faWi5UmS/A0s1/VObpF6
luv1PgzS7eXoZ7PUtwL99NPFFeinT+pdgXp7aPsJ9LNR6n8C9XPR4ypxnrPS
j0qd59R6urdSpUUfOC39qULea2lPFZ6vkX6dRP9P0TkndX2vVEn/TiIvlfS7
p3S+/RXSTzixnB5Sjf0fl/5Wq8j9CfZj9A/VSv9VJv2uwXyW0mU1yJND+l+L
vB2hV9RiXg9JHmqxnxJ6ch3mv1jyUYd+HKTv1aF/ByQvpzG/RXTwtO7PM4WS
nzO4DwrovDOYh32SpzOo7146tV7nx/2l5Kse+cynbU7kfY/kzYn87KY7nLjf
dkn+zqJeX9BVZ7FenuTRhTztoGe4kIdcyacLz2+nS13I21bJqwv12EL3uXS/
OnIkvw2o32Y6vQHnz5Y8N2D/G+nzDXpeQhsk3w2Ytyx6UiPma73kvRHzl0kX
NKL+n0n+G/X83F9F323EfK+UeXCj3un0Yjf6v0zmw4382elmN/q9VObFjfcv
ohM82H+azI9H12/bfDrXg3lIlXnC53Hz6G4P8viezJcX8zWbTvHivLNk3ryY
t5m004v1EmX+vMjDm/RzPpx/usyjD9+fSm/w4f2vynz6MI+v0Nd86Oc4mdcm
fV/Ej6XfbsL9PUrmtwn330j6RBPWf0HmuUnfT58+Tz/hRz2Gynz7df+Lh9Br
/Kj/IJl3P+oVT1/2I48DZP4DWK/v98d+LYD74V96RQD34wP6UAD37T36YgD7
+Yt+FMD9+Ac9uRl5u0V/1Iz9dtOFsO032mzGPN+g78EjOujx5/D5z/QSeMSP
dH7s8yt0MPb5ZfrPc1j/a3pMEPu7QKcFke8InRdE/wzaF0QegnRPEPeXnx4Z
Qh69dGoI92kDvSWEeXHSrhDyWUf/GkJ/qmlbC+alkp7bgvkupze2IE9ldF0L
6umgO1pwnhL66Vbst4hWrchXAb2+FfdTPl3Viv3soq+2Ik876IEG5mEbPcpA
fXPoGQbykU3PN7BeFr3KwHrr6O0G1vucLjVw/6yh3Qb6+QndbiBvy+mbhq7/
nWV0n4H7004PC+P/P0voaWHMyyJ6Xhj7X0inh1GvD+jNYcxHCl0cxvzPpevD
uE/m0Odj75tF34i9byb9MPa+RPpZE+97g55kYn/T6Tkmfh9Noe0mzjuRzjJx
3vF0gYl+vURXm6jfaNowdX+2vUj/YuL3zzD6ron72EY/GUHehtLjIpiPp+ik
CO6/QfTiCM4TT2dGcJ4B9O4I8tnX89gVEdw3j+hmPJ/8gP4ez9f8TffG1r9D
x1tYv5dOsLB+D/2WhbzepBdYOH8XvdrC+a/TuRbu52v0UQv3y1XaY6Gf39GX
LNT/W7rbQn6/of+zcN9cpIe3YR4senob9mvQKW3Yb4he3ob9BuicNsyPN+r/
AWFSdIo=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g1M1GUcB3DGpBVZlrum5SItc+q0yEpcDfdEmeFsAjVfimySMnxZ+DKc
oVkwKCQTX1ADScFDQJTz5I7juDvgf29IE3OmiRamWBIoK+fUyJp2z/f6/pxu
yj7+//c8v+f5vRyj0jJTFkVGREScC/3VP/nHGZO/9Mrlia+FlajyryQ773qe
iu40XxUbaaq0pOTxfnm+WHVnm54Tq0z1YuiP2Fip4qM7nxFfyFKW6d237q7/
iRqXWuQTj1yn91suVp+pyuXx0eLYHHVzbGrRZVk/V+kf4qQ8tSI+ek6f7Jev
+pOdu3vp5V+qYx0dHb/L/htUenp6Tw+9uVCF7uPKJYlnozKFAv6Ntn6tQuE1
/yrxFen4Ci/SGZv1eRK6Jd4tWO88PbBFpYT+4xeJf6s+z5BzdME2rPeznKdY
ha7nxll6+Hac74ycb7sKPa45TdfsQL5OyXl3Ij8n6Snf6POmn5Dzl+A+j9Pt
Jcj/MbmPUr1f51F67i6s/53cT5k+T1Q73VumngotcETu61ucV7xmt64Pm1jt
Uf4bY7vEg8pRH+KMctyPrN9RjvoTx1bc6+KKe98fqMD9yXqpe5F/sbFXvdWd
XSwebb43/gIzPt9G95txX+KkSv15k9heifMGJV/7UD8Bet0+na+x4gv7kE8/
/UaV3i/LJ/ms0veR7aUHV+t6WmpIfqtRb630qWrko0XyXaPzb/HQZTV43y35
3496bqIX7ke/OqUe9iMeBz2hFvmzS33UIn/19PVa1LtV6uUAbKE9B/D+Qamf
g6i3WjrvoAr9+3mN1BOeT6miZ9ahX81SX3V4v4I2WTAv9ki9wYVldJdFvx9R
KvV3CP2wk648hPsolnq0op620pOtqI8iqU88L9pIl1oxzzZIvVpx/i/o21bE
lyf1exj3nUOnHcb8XC/1fFjHE7+Wbgt7jdR32Fn0+HqcZ5XUez3mwwp6Uz3u
P1Pqvx718jF9rR7xLJN+sOH+l9CzbdgvQ/rDhnjTaZcNn18o/WLD+ml0jB37
fyj9Y9fvmz+gc+2I/33pJzv6ex7dY1drTZYjs6W/GvD+u/SMBuQ3RfqtAfmf
RVsakM+3pf/Cz2fQQx2YP9OlHx1Yfxq92oH9E6Q/Hfr7JUbRPznw/RUv/dqI
+n6FntqI9eOkfxtxfy/TexvR35Oknxsxn56n73OiPidIfzsxX8bRS5xYf4z0
uxPnHU1/70S8o6T/mzCPYuhJTfi+GCHzIOzh9I7w+4/JfGjCekPpW02Yh0Nk
XriQj8H0fBf64X6ZHy7dTyeiaJ8L8yVS5okL/XWn73+PceN+/qXnujHP/qYL
3dj/Ju1xY15co/9wY/0/6ZEezNd+OsWD9froPA/qt4d2eJD/i3Qvnuefp59o
xue76JnNyMcZen0z5vGPtLUZ9fUDfbEZ8R+nTS3Y7yj9ZgvmcTu9pgX3H6Rr
w+976a4W1GML/XAr1nfTqhX12UivbNX9mWqnK1sRv5U+3ar7saSOHmSgfmvp
Jw3ks4qebCBfZnqWgXoopzMMrFdG5xiotxK61MA83U7bsH7yVrrDQP1voi8Z
OO9X9O3wfgX0MC/qKY+O9WK+5NCJXsyjT+k0L+LJptd6cV+r6WIv5uEqus6L
eDPpNq/Ox/Rl9Hkvfv/IoAe8OM8i+lEf7m8BPR5Onk+/Hn7+Hp0afj6Hzgo/
f4feFH6eRFf7sP9M2vAhvkT6rA/xT6Ov+XC+BPpBP84/lR7tR/5fpeP9+L6J
o2f7UZ8v0Zl+5DuWLvBjPk2kK/zop3G0y4/fv56lT/pRT0/T/X7kP4aOCuC8
I+iYAM4zjI4L4PvMRCcFEO8j9OIA6uEhOjeAeB6gdwUQTxRtD6B/I+lj2P/E
7V5+X2H/hH/oOwH0/1/08CD2u06/EMT30VV6RhD79dMfBfV5F/TR64LI56WQ
/wNkk4XM
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g9MlGUcB3ByaIu0zK5ETUQlQ1NDM6XZ6eOfVJgudM5oslxozj8r0UUZ
MkOS+ScDVNRANBCQE/Q4ODgOuIP3/qCunS2ni2Vk4pJpMGcOi+lG3fPV78+8
TfCzl3uf37/ned/RyZuWfdwvJCTkt+A//ft/nwzVNWnOw//GKZN1Ycdjf6DG
J+XMFRvJapkzImu2XF+vfPei22fRapPaFryB2Niifc5MX0tVm81h74tDvlT6
pzgyXWV1LXW+I/f7CuuJY3aotcGP2MjE/cQJO3U8SeJrWSqsrSRFnLJLLepI
yxOH7EF84ty9er3+j+PZ92S8tm8Rn1jlKHNY21jJd12uKsjPzxfH7FfdS50R
Uq/e/SrHe88iNg48Wd/dB3V+neKEPPV3dFLOHDr8EP5+ruR3CPWbR1sO6+te
ccoRVZpi3jufjv0O+bwr+efreKIX0OfzVbD998W5BepCIBBYSCce1fkcXyT1
KUQ/4uibhTr/YfFSr2Ooh3jrcRVsh1usvtc2i0OLUC+537oifF/WDxShPhJ/
TDHWk/zyijF/Up/eYhUsR6rUM+mE7lfJ4/k8oevRJv2PKtH1fn6m9KNEjQo2
/G26uwT5z5D+lOr733uLri1FfadJv8owX1Pp9DL0b4r0rwz1fYOefxL1nCz9
PKn7FzaJHliO/r4u/S3H/phAXy7H+uOl3xb1ZvATTRdaMK+vSf9PoX7j6DWn
cP1VmYdT+H4UPbEC9Rgr81Gh5yVtDN1TgfkeLfNSifMkknZV4v7iyNPIdxS9
87Rezx4h83Ra6V/ixWew/kiZrzPo5yu0yYp+jJB5s2IexO1W7P/hMn9ViG8Y
XVqlOtJMk8WhNpwf4fR0m75uHSrzacM8vkwX2PT9TeKADfP9Et1nw/lkkvmt
VsH2bXyRTq7GvA6Rea5GfQbTZ6tR70Ey39Xofxg9oQZ+Wua9RtcvI5TOrkE+
T8n81yCevj8f+W4N5vMBHWVHv3rpFXacDz30bjvm9y+60Y79cZvutiP+Ljqi
FvW9SSfU6nju/EFn4rq1g66txfev0p21OB9+pcPr9DxcbKPj65DvZTq9Dutd
pK112O8X6GsP//4HeogD+Z6j5zuwf3305w7EY9AWB54XbvqKA/k30APr9fMi
1kHPqke9auiUetyvij5Rj/mtpC/X4/y20AOc2K9ldKwT+62Y3uDEfj1OFzpx
XhTQPzr1+ouP0CENqN9BemoD5iGXXtOA/bGPPtyAePfQ5+HOLPp+A+Y5k57Y
qN21nf4Q3riNzn14/Qva24j7f0b3wJ0p9LgmHc9Hn9CJTXj/WE/vbcL5t5Z2
NaHeyfTtJpwHq+hIF55HK+llLtQvkd7pQn2X0w4X5m8pfdOF82QJPdyNeYin
F7uxXxfQ293Idy5tc6Pes+nrbsQ7kzY14/yIpRc0Y39Mo7c2I54pdEUz5mUS
3d6M/Tqefq4F9R1Hqxb0fwy9pQXrjaJLW5D/CPrnFpxv4XSooYI/M0z0SAP5
DaanGzivB9HvGaj3M/Q6A/ttAL3DQPz96AID+6Hv1iPbDdTrAR0wMN//0DcM
vM/00H0G3p/u0EM9uF83HePB/W7RcR7Ed4NO9iC+6/Q2D87Xq3SeB/leoc94
sL/a6LMePM8u0b97UL+f6F7EkxqgX/DifDpPT/Di/Gil53nxPuShk7zor5tO
9SKfRjrbi3wcdLkX82KnDS/6V0X/gu+3V9J38X2zhX7Wh/VL6Sgf1i+izT7s
v2P0Ch/el/PpTT7kf5je7UP+B+hiH+Yxm2704fz+hr7kw3zsort9OB++pvv7
8fzKoCP8OI/T6Rl+xLuVTvAj3lR6vR/92kxn+vE++Cl91I/zawNd68fzYS19
AetFrKY7sV7aKvpfrNe2kg5vRX6J9JRW5Lecjm9Ffgn06lb0Ywmd3op+xAX9
Hy+WYo0=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1n1MlVUcB3ByaoXMl2RJtkgnc0SaKEtxhTu+JEKYwJraYm6SMs0/IDea
KUtlsshZoKHJi8g7F5TrvdwL3AsXeO4Lyhy0LEozneCKaWg5BuastHu+d9+f
0w3vPnue+zzn9zvfc86dm56Zun1CUFDQdf+f/uS/tALP+MqRhSsDSlD3I9Om
PfEH6nJ1VpzYSFfrhvYWPbm+U2VkZAyLVabKG0mJXSX371apjvA88WC2ejVv
5JI46DN1J8URvpqek6P8t+8Sq/0qJibGJo4+qPTHGnl+rurv60sSJx/SzysX
D+ap4MvV98RZX6h9oeb4d+T9X+J+ceFhPH+tjOeI8o5HpoktX6nX/A0TqwLl
b19kPL2jEP0RRx/V9U9aRz84qvxfzxYbx3S9I+L8b5R/eFsTpJ4i9Ulc8GVx
2HHdv5REqe+4rr9PbDqB+t6Ver/FeMWxJzGfSVJ/Mfor7i1WQ3tD31gv/ShB
f8SbS5GP96Q/ZcocP7RXfKsMeRBbTmE8G+g95cpfTrVYndb9GBdPrNDjXZUs
/axAfsR9FXr8neLoSvRPXFSJ8aVIvysxP+K0Kl1vjNioQr3iiGpVUlz8kji/
GuOT59+pRj/FyTWoX2yv0fXNE4fVYrxSXw4cJx6s1e83S7/W1KmarLhgsakO
8y39D6lHP2S+surRT5nfgXrMp+Qh1qTrN0l+yky6PwWSt6AG5E3yuq0B61Hy
3duAfMn6WdD49PosbFRP7R9jjXq9ZSnJyxnkdwXtOoN+x0l+zuL+t+hDZ1HP
csnTWfR7GZ3UhP3jTclXE8YXQ4eaUf9iyZsZ/VpEXzMjjwslf+cw/ii65hzW
b6Tk0YJ+zKeXWnQ+iudJPi1Y33PpEgv6GS55tWB+X6YfWZDXMMmvFc9/kU63
YnwzJc9W7Bcz6PNWvb4ypku+rdj/ptFRzcjfVMl7M/a/EPrrZoxniuS/Gftb
MD3arPP88DlZDzbk5Vl6o033J3SyrA+bzuvhiXS7Df2cIOvFhvE9Q4fb0b/H
f3D92DGf/9G5dqU//qXtdtTzkB62Y/0+oMNacN7cpxNbcH2MzmlBf0dpcwvq
+4sebEF+7tIvtKLeEXpNK8Z/m/60Fd8fpk2t2B9/o6+24v036ZA25PcGvaIN
83udzgpcv0pXtWF9XKEH2tCvn+jJDvT3BzrWgfF9T3/swP39dJlD53HoIv2d
A/3opYOcen1u6qGXOLFePPQ2J/LSTZ9wYr5cdK8TeXbSD52YvzZ6QTv2Yzu9
pR37q5UubMd4zLQn4DP0WOB+Ez2/A8+rpTd34H1V9OEO5L2cdnVg/yml/+zA
fnySnuNCv47TqS6st2P0IRf23wK61YU8HqFv4f7xfHp2J+Yzj07qRJ5y6c87
0e/9tKUT9eXQNzv1ery2hw7twviy6bVd+P5uek8X+pFJN3bh/bvoa104n3bQ
U7txHm6nVTfet5Xe3Y3530LXdCPPH9I/B+7fRE80dP8PvE+/YqA/KfRSQ+f9
wnp6g4HzI5HeYeC8i6cPGjivVtMlBn4PKNpm4P1v030G5ms5/XvgeUvpRwbW
5xJ6lhv1LKKj3Rjf63SCG/2NpNPd+D0TQe9z431z6SI39v9wusmN+Z5Nn3dj
fmfRN9w432bSD9yYj+n0DA/OrxA6yoP97Xl6tQf5nUSnedCfCXQ27Hl0m/u9
B/vNP3Q9fOFv2ghcH6N/CVy/R48Gnn+XnuLF82/TEV78nhmm47x6vI6b9EYv
+n2DzvRiP/mVzvei/it0pRfzNUC3e9G/S/SPXvS3n77jRf8v0pN8yPt5OtyH
/cBDL/Ph/Oymk33YHzronT7spw4614d+2+lSH/ZnK233YbxNdL8P67GRHvYp
//8H6ujHgfFU0WE9OH9P04t7cB6V0ok9mP+T9Ec9WB9FdE4PzuOjfv8PvWZt
PA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlg1MlWUUx8l52ySWfbBhudDMnDhtGA2pRB8/8gMpgRKlbqaIBLkCLQgR
CxwsciaaaIFk8iUXRLxwL3C9fL33vRe1DVtNF6usxKXDYOVMzdlG3edP/+OS
Ddhv732fc87//M+5z+PJGQkbxwQEBPzk/9X/+bNsILc0b2jWglFarrw3pp+/
w0mqJjM6cDvZSFYl5o3pwgHpaiA3+ClhlaGG412hdz6/RTUtHbgt513IUv3V
mV13zt+qXKFFm4Qn56kEV6hFWH2ouWgbObxAf34oV87foc+LFo4rVNYSM2ur
xCtS5WVlZTnkzI9UdGB/9fsS/2M8zybv2anzzc2SfHapbcFNS98j2z9Bfu9K
fiVaD9tmctoe5JMp+e5VYf6E3iHf2quKhuKj3pb8P9V6HdpELt6n87+RLvWU
4rw08oT9yv83P1Xq268iIiIcKWTbAeVPdyBZ6v0M+a4nR32u63/iDam/TOe3
8HXy6TLdf+troke58suVmURec1DdnG4tWS36VOh6XKvIgxXo98ui1xd4P4Gc
cwh6xot+X0KfOPLYw+ivcNph9EM+33cYesh54ZXwm8QrrdT5jX9F9B5lyc9a
BU4U/at0/x+ReqZWw99rpB/VWt8IqX+4Gvm/Kv2pUZujA1eLXs4a+Nkq/apF
v0TfvFql522t9K8W/pF+LD4CPddJP4+oM319fdK/oLq7+lun9b26gXyuTscL
2Cj9tqFe8UuFTZ8XKxxQD/3EPyn18J/EO12P+JLfzAbkK/XsadD7YafUf73h
Lr8c1fmuF307j0Iv6cfkRjXJX7D0r7AR/pN+DzZinleSY49hXl8Ufx1DfivI
wU1a3+AY8VsT+rGMfL5Jx+9fIv47jnxeINccV6mpqZcXiR/t8PtCcqQd+i0Q
f9qhnyKX2zFv88WvdvRjHnkE542PFv82w19zycnNyPd58TOeO54jn2zG+8K3
muGvZ8kzWhBP2NoCv0WRd7dg/wgbLZi3OeRrLYgnPNWB/Suc6EB+wsUO9FfY
fRcPO+AH4VAn9BSOc+L7QHiHE/4Tdjr/n+9lJ/wmPKEV/RKOaUV/pP68VuwX
4SbwQtHvQque51PCD7XBf6L/4jbkI5zdBv9Jv2xt2AfSzx/asP+Eg9oxz9L/
ee3YZ+KPzHa8L/6pasc+En+da8d8C9/rgr7CUS70T+K95YLeUk+FC/lEkr92
wS8RMv8n4Jdw8tMn0O+Zsg/AljDygdHnT8p+GH0+hXwb5+WHyr5w4/yJ5LVu
1B8i+8ON+h4mm2746wHZJ27suyDytA70Z5zslw69P761kHd2QM8xsm864K+R
3/7j3ztwX/mbPLkT94G/yAmd2B/XyYWdqPcqua0TfhgmD3Zq/6VeIT/ahXwu
kWO74LeL5A+6MF8/k+1d2B8/ki92wd/95OBuxDtLXtKN/n9DzunG/usjN3Rj
Xr4in+/G/aKXfH8P7nMmWfXAL93kLT24/7nJNT3Iv538XQ/2v4M81sA+spMf
M7CvG8mRBs6zkVcaOK+WnGbgvEpygYH8DpHLDeRXTnYY0PcAuc9AvfvIlwzM
Zwl5xID/dpFDPNCvmBzuwX4oJC/34H5UQE72oP/byds82DdbyaUe+C2bfMyD
eraQT+J9Swb5F7yfuol8C++fepP8oIn4KeQZJuKvIy8yMQ9WstWEnknkLBP9
XkXebWL+48l1JubnJbJhYj/FkL834f+l5Gsm9F9Evs8Lv80nT/XivjSXHO1F
vlHkRC/yfYac4cX9bTa52It+zSJXerEPwshuxIudRj6LeLYp5GHEs0wiW3yo
byI51If6QshzfPBrMDnON7pvyOk++CGIvMOH+RxHPuiDvy1kpw963EM+44Me
I1f4feXT/su/Tf7Hh/vHTfKEXuyjP8mzezH/f5BjeqHfEHlDL/w+SM7rxffp
r37+F2zUX8M=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx5nL1rTlcrSoFllZIyuH0dS1UR9/pIA2kT9It6slkoFUIIUp
ogLBJDIQQxNEBQ4BEc6DO47jjoPvfTmstrPVbLqcLmxlTpgrp43ZRt3n/e15
M7qNsdc+P5/3836ez/fJjNy0d2dERUVdifzp//KbddH+R9/Yi8ssSlZXC6MX
TvFGleaNLfcIGxkqgmO9HM/WnENWucqx+updN+fnq/H13uPk0QK1LXHWm+So
nXo8ljyvSNmqzTsu7rdXRUc2JMeX6PUXyUbp9PHUsunrR8tVfV3dI9w/b596
zla9fOr8z/T8AvKBSpWQkOCaus9+pfUhO7+APlPxVk+PP+sA4iXH16iL9rwA
eaJG7Yp2fE02DqrIddvJFV+q4TtxNnJqrXqifOwHnh9zSOl/U3oeQj56hNsP
63jruhnvV6olL3GWU3jpEb3fegfjr9Px5XUKf1MHPTqoR73aEvm1C284Cv1a
qU+DSooI0iJ8vQH5aaJex/R47QnhHcfVuXB47THqdwJ+qRe+pxF6HKGejfDL
YeFwI+Kvpb5NmF8jXNuE/aupdxP8sF/Y1oz8VFL/Zp2P1RXC8+3IdznzYcf8
T4XH7di/hPlpwX32Crtb4J8i5usk/FEoXHRSReR5egfzdxL+LRBe2YrzPmI+
W/X4pm3C97dhfS7z24b8vy/8YxvO38p8t+v7FWcJN7SjHt5j/k9hP45nnoK/
s+mHU3q/BO73Qgc4h/6wmOfftvgD+uW0zk/ch8IDp1HvvP+8TvVXnG1OnnBZ
J/RkvNc7tf+ukdd2af3D+fRXl76vg3pFO7TfKz+m3xzQj/pediC+7fTfGfiP
3HIG9foJ/eiEfszXYqeKlM/SnfSnE/cj1zvhd+Y77IQeu4Qnnahncnw36ot+
yeiG/8i13ajH3cJnrXHyhLV+j/CCHuxPtvXgfPqzqgf6kI0e3W8uk2/1ID/F
rAcX6o+c7sJ6coUL+pN9Lt0fTPL4/zjWjf5ETnXD/zy/1I16Znxui6nnNTf0
YH5iehEf853Si3qgn4p6cR796OhF/6KfR635W4TnerQfqzezHj3wyzvC2z3w
n4316YH+G4UveRRkYr32wQ9pwq/2oR7WsX77tJ+8a4Sb+9CPkljPfeinK4Xv
9eL85axvL+p9hfBWL+Ll/AYv3u/Xhb/zQr9VrP9+3H+18Ev9eH94fmY/3otk
4cP90C+F/aEf+vD+d/vx3qxlv/DhvuS3fajHN9g/fOh3ZNOH+iLf9qE/cP2z
fozz/A1+1APvX+lHPIx3wI96pl43/XgPXmP/GYDfE4XTBvT8xFfYjwbQ75cI
ewZQDy+zP1m8SPjRAPRayH4VgF7PC+8JwK9x7F8B9ONnhH8JwD9PsZ8Noj5j
hVcNwi+Psb8Nwq8xwh2D0Pch9rtBnDdX+IEh7D+H/W8I3yOzhfOHUN/3sR8O
If6ZwheGkI8Z7I8G1k/e+I8fN+C3v4UXG8jXhPA6A/m6LZxlIP9/CpcY0O+m
cL2B/nxD2GWgH/wuHLbm/yr8m4H8jgpPGqiHK8IPB5HfS8LxQeh7QTg5qM8r
PC+cEUR+vhfeFUS9hYVrg9DnW+GuIN6DEeGz1n6m8M9BfC8NCU8E9ftr9ws/
aEIvr/ACE/q6hVeY8Fu3sM3EeV3CBSa+5zqEq0zo1yrcZiI/dmHDRD4bhX8y
oVeD8C0T9VEnPHsY9z0kPH8Y/eygcCK4vUo4fRj94XPhXLBjn3CFNV4m3GSN
Fwv7rPHdwuet/XcKj1vnbxeeGcL98oVjQ9b3hvCSEOLLEU4NIR9Zwtkh+D9T
uDSk9Zq5SfhoCPl8S9gdgp83Cp8Lof+kC18LwV9pwv+E4Nd1wjEjeB/XCC8a
Qf6ThFNGEO9K4c0j8OMy4aIR3Dcxwv8CFnZ7Wg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1GUcx5nT1rTpbGyam0TTGlk5ys3cGu0pLdK5Eluo7eYmFsNcg1g6
RVQkmUQFWucL+BKvciIeB3ccd8cB/3sBtcAymy6nS2oxp9acpSPXMv7f6/vl
NsY+e/7P8/xevr/v//9ETv7K9yckJSVdHfuz//NXU11dPXjzuVcStNQ0FmRM
HhKvMY6q6CaxlWNid9OujK9vME87ql49Rzb5JmPypQaxVWjsf9+Rr20yye7M
deKkreZSQ0GPOLXYjMXz2Pc6b6dxZw4XidN34X6xVYr7z5NX7DbDRclu8bUy
nPcDuWCPuZfmqBInfWpWBlImXSDvrbDjLRGnfo566HnPF2ZocHD5eHxV5o3h
IqfyzdtrAillN1XP9H3m8bKbWd+SR8Hnzyr+L5HfGXL5V+ajjMmrTisfpxkr
Z8EAeeZ++/7BfuW3H+ti1wHsFxccxPniRYfMtmT3aXFStV3/DJ1/phrxiffW
YL/iWX3YLBj7Kd7UI/b6ffH1Izhf+XmOmltZgWPfkLccQ7yqh/nafj5T9ZpY
a/dnmvSVV2v3NyoerEV+qnd6nRkrb0DsrMPz4tE6ux8bxY566HNcz/Xot+6f
2wC9KL7yBuhF+dxqsOO/Pd6fRuhP9fI12vur4+pXkz0/d6Pk4ibEH1H/mhBv
H3nJcfSjV/08jvUw+ZFm7O9Wf5tR/yD5x2a7P96A+u1C/7rIR1zQo1/9P4H7
OsnvnUB/fdJDYt1LfrbFnj9Hh/TRYs9PWTv5rxb0wyO9nDSQATl8Eve3ST+t
mFc3eXerPU/J4uutOP8UefkpnCf2gEtaycluzLN4ixv9O0m+4rb1mCI2bbi/
hdzYhn6KJ3owDyfICz3wL3GeB3pwkWs8qLd40IN4xP+Cy5ql33asi3Pasf+4
9NxucnNzR5rIA+3wH/FouxmTl6uRPK8DemmQ3jvgF7Xkyg7kc1T6T6zXkO8k
9h/UPHhRHyc52wu/26f58GKeK8khL/r7mebFCz2Vk1N89nnzyzQ/PsRfSi71
4fxdmiefradF4hEf+i+e2Yl4S8jLOlFfcXEn9ovdnXb/hndq/jqhH/GjfviP
eIkf8ewgb/bjfSB2+ZH/dvJlP+pZrHntgp+IX+7C/G7T/HYh3iJyfRf8aavm
uQvzvIX8UADvl82a7wD85mPyBwHot1DzHkC++eRzAbzPP9T8B6G/jeQXgpiX
PPlBEPOYSz4Adq6XPwSR3zry/SD6uVZ+EYJeHeS1Iczfu/KPEOJdTY6GEM8q
+UnIrndFNvmpbviLeHU39KbnK7rt+s3ReeFu3LeG/Ec33k96PjWMer9DXhlG
fd6WH4WhnyyyH+t335Q/JfYvJ8/qQb7L5Fc9mN9M8o4ezPdr8q8e5LuY/EsP
8jXys14D2ZBf74XeXpK/9dp6urSI3NKLeBfK73rRrwXkqX2IJ13+14d5nE8u
7EP+z8gP+6C/NPLFxP4n5Y8W+j+HPNtCP1Pll5b9fO5s8lsW8psl/7RQvxnk
XRb6myw/tdCv6WSvBf+aKn+1kP8U8m8Wvg8flt8m1ieRZ0Swf4L8NwL/eHDj
f14aQb7/kHMiiO9v8rYI4r9HdkbQjz/Jp3B+1m3yAM5b8Dv55wj85QZ5NIJ6
jpCnR5H/r+R5Udx3jbw4ivfvVbIjas9b2mXypijeRxfJlYnzLpCbo4nvabIV
xft9iPwT1u+fJd9J7B8gT4kh3xh5bgz3W+SMGPwmTM6OQX9Bcn4M33t+cnkM
89RBrouh3m3kUAz1bCVfiCE+F/lW4vkm8qQ4zq8np8Thl8fIL8bhb4fJK+Lo
zyHyhjj04SSXxpHvPvJh7J9WSfbF4XcV5KE49L+HPBKHHj8hP4hjvkrIM/vx
PtlOfr4f38tbycv6Ed9m8vp+6LWQXNyP+uSP8X/7K4kX
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1HUcxm8ta8Nmy7HCNkkXa/ROuRlrO/ezN1/GFtDmS5ElpoHVOC3M
F8owGIgpiEjyKnC8i3hwB3ccB9z970hdUJYkvmCAJhkwVy6auVbd77l9H29j
7LP7vX6/z/P8bmFyWuLGu0wm0+Xgn/4vn7Bh6++TU08vDdEKVVpSMu8Or1Xj
O8Of+U3Ymwy+zu9T1XSCK/JXYZWmWpeN377G8VvV40n5xi/CY+n6+51XOX+H
MocNP3pFeEGGGrZaesa43m61K7x12ahwTCbWu8z19+A8I8LxWWr5+M6ii9wv
W7kis6fOC1ty9PrmYe6/VyUGB/wkXJCn9zt5luf5Sul/Q8K2/RhPVvnqr+ik
+zk/pUDXo5Icc1AtCn7OCd86qAYHBgbI3kK1KfjheXIP6fVn8bzxRSrfmGkk
RxzW8+Mu8H6HVbAcM+TGYt2/Et7f8rWu10uXhGOPoB5kUwnqxfqdKkF9WN+C
UhUs/zh5TRnu/zPrU47+sT/Xy9Efsq1CbTGHrWY/t1di/zv9PQo9jAvfXaW0
Hvl9SpU+XzjXG6hCvXiemGqM532KqpV/JnqE979VrbKnEmLJSTWq1mIOI3tr
oC9ylFWfd5ica0V9uP60Vdc7/Y7eavX+Fp7HUYv7sD4RdVof+Tx/Rp3Wayvv
N1anHsme+oH3f6UeeqM/GuvRf/J9Dag32dKgx39B/ww1QF9cL7YR65HLG+Fv
7m9qgn95vveaoGee/1QT+sX7PtWM87MeBc263kms15/N8D/1uuYY9EJ9e47h
e/pjQQvm009ZLdov9h+ppxbo+4xw3HFdj+jvqa/j6N+gcHgr1vuWegvxaeGR
VvjnJPV3AvnRL1x7AuczqEeb1o/LK7zYBv31Up821NcjXGrT+srrol5t8LNT
+F8b9OKgftuQN23CyW3Q+wnquU3rI6FF+Js21LOJ+m6DPuqFn2jH+a3Uezv8
Tz7QDr3UUP/t6Ge18M126LGKfrCj/0eFV9nRj0r6ww7/VQi77fBfOf1iR56X
CUc64IdS+seBfpQI73GgnkfoJ4fWu7VYeMIBPx+mvzqw/iHhlR3I20L6rQN5
WCDc2oHzH6D/MN+8X3huJ/y7j37sxP57hbd1It9y6M9O5EW28MUQf0m/OuHH
TOElTuhpN/3rRL58JlzjhL520c9O6HOH8D0uzP+U/nah/9uEN7ugv3T63aXz
e/0nwt+5kB8f0/9d6NcW4ee7oA8L86ALeZEmXNyF9+0j5kPo+w+Fb3dBn5uZ
F268HynC69y4z/vMDzf8sFHYcKPeG5gnbvhjvfBj3VjvHeZLN/T3tnBeN/T6
FvMmNH6t8I1u7P8m88eD/OD4RI+e/0ES88gD/XD9Tg/6uY755IG/3xV+uAd+
43njelDPZOHP8b3B+9l6MJ/3v9KD82xinvXCL6zXa73Yn/Xc3gu/pwo398If
5JHQeK4/pw9653lUH+rN+2ztw/vIetT2oR6rhc/1IR/eYD564bd44fle1CuO
eenF+ZYLv+5FHr/K/PTCv0uFM714j5YwT72o34vCdswfWcx8xXzzIuFrmF/5
LPM2tP+Twg/5sH8089cHP0UJr/BBzwuZxz689/OFd/lw/3nMZx/u/6DwcR/6
NZd57YMe5wiP+tDf2cxvH+p/r/ADhkJZmecGzmsSftnAef+ZlHw38F78LZxu
oF8zwgcM+OcP4QYD/r8h7DWQd5PCFwzk14TwTQN+uSo82498GRWO8sNfl4TN
fvTjvPAqP/JtSDjND7+eEc71h95v4Wo/+nda2O1HXvcLn/XjPTSEp/3Iv17h
WQHUr1s4MoDfn07hFwJ47+zC8QH4zyacGkC9W4T3BPB7pFG4LAB/1Ak7AsjX
auHBAPpTITwRwO+pUuH/QuOLhSP6Mb5Q+Ll+jM8XXtmP92Cf8IbQ+BzhjND4
rCD/D/pMm+M=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlwtM1WUYxs9MaSFpGiXVQrrMYctG0ZKt4b7IQh2bSptZo1ZE5aXiaFEI
pMCklGVAockllftFOB44Bzjcz/kfQCropsV0NMGSCojQwjHmsPM9p/dhsqn7
7f//f9/7Pu/zPR/eFxsf/fo8k8n0i+eP/ld+3FPBMQHjq57y0noV7jtQMscv
qOUZYz+QnbHKEZgxNvd8+42s4tUuzwJz7+++cb2hBP38+bnv9yjP48llwkEp
er2dZLVP9ff19d0pHJKm1g0n+ZOd6WplTFbEHcKb9ut6N/tzvwz9fdTtwuaP
VZYxFbyU+x/E/rcJZ2eq8c2OY4tZzyfKs1zYImHrITVQYm73Y31ZylPOIwuF
t2WrUnN45i2sNwf63Sw8naOuBscs9mH9n2H9+cIHPoc+89hPrnrD82MSDjgM
nh2T/g4rf0vkq9eEK4+g/xlh8xe63vBp4bCjur/Aq8KmPGWJHJ75R7g3D/Ve
Fs7O13pV/i28tUB5/k79SzioEPWOCf9RCD3+FLZ+iX5/F048pmI8C/4mrI7D
PxeF55/Q65vI28Cp5L4TqJccUgQ9fhXOLYJfyNNF2n8PcL+YYj1vM9lZrEJD
Q23kB0v0eiPkAyV6nr6XhMdLoB95UynWJ9tL4U9yQNmN/aaUab8a5KEy3U8S
eW051idXlkNPsl8F5s31zRV6v9wR4bMVKtnfcpp6h1VCT86jsBJ+G+X8q6AH
5xdXhXmP0w9V0IPzfrga9dEP2dWY/6Twv9V63ln0z9aTqOeKcNtJzIt+C6qB
vnx/f43u1zJBP9UonU+sJ6oW77N+ay30ZL/+FviF+iRacP7ph0EL6h+m/06p
aEfgggvCpacwr0H60Qq/nRd+wgo/n6M/rdo/oQPC+Vbo+RP9akV9Z4Rnrcif
H+nfOuj9vXBsHebzHf1cp+c93C/cU4c87aO/63S9Cd8IP1QPf3xNv3v5K+FP
6/F+L/1fj7w7LXylHvndw/NgQ73kLTbkWzfPhw3+IrfYtJ4ZXTwvNuhNDrTD
D26eHzvmRU7H80iy3Y7vySN2zIsc0ID5GMIbGlAPn6c0YF5kSwP6IQ81IC/J
SxvRH3ltI/KE/H6jys/Lu4v9VDZi3uTzjchPsl8T8pf6rGnS83WQzeAw6lvc
BL+QzzahPs7Hx4H7ihzmwPnnPHc4cB9y3oUO+Jn8rQN5R3+YmpE/9M9jzdCf
/oprRj7z+yPNOL+sr7dZn89B6j/TjHo7mRctmHer8Mst0MPB/GhBPXZhowV5
Wsc8aUF/tcIrWjH/auZLK/xcLpzZirwqZt60op7jwhOt0LeA+dOGfD0qHN2m
55uXyzxqw345wo1tmPch5lMb+j8ofHc79PuIedWO/tKF97bDP/uYX+04L8nC
F9sx3w+YZx3I1/eEn+2AnmbmWwfy7W3h6g78frKTeYfvB94SXtSJ/d9h/nUi
H+KFd3cij7h+aSfq2SX8cyf8+i7z0Qn/sL57ndA3gXnphH7sZyOeRyQyP53K
83fqHuE0J85HEvPUif2pj82JPPiQ+epE/3uFL+F9M/WddeI+ShVe5kJ+pjF/
XdCX81nvwv3C72NdqIf7J7ugF+vP9b7PfmtdmDf16vGuT70vuJBXO5jfLvjt
TeElBvSNY54bmN8rwk8b8PtLzHcD+faicIKB+W1h3hs4b88JVxjIp43MfwPn
OUr4nIH61vE+MJCHzwgvdMM/Ebwf3NhvjXC4G/U/yfvCDT+sFo53Y16P8/5w
o78Q4SI39F3F+8SN87xS+Iwb/z9YwfvFDX/cL7ygC/os533ThX7uEV4NTgrg
/eN97i+83ft8Ce8j7/NbhQu8z315P2G/KR/h/i747ybeV+DJ66P/8/Uu1H9N
OKAb9/u08KPd+H1nSnhDN/S5LPxaN/SbEE7phr6jHv4PQiuQ4g==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1VUYx2+lVmiaRqmtCKdzxLLQUqnEji/LNFfKH6YbtUnGsNogG2XK
TAnyZSZoaIGk8qK8iHiFy/sFfvdyMbfQMk3TbKGbziZrzsLMSrvn++v7dbLB
3Wfnuec8z/f5nucwKjkt8a07PR7Pz+Ff+8mflZE1X8f3jpvm0mxzNSZpyC1e
ZCJOlqZPJjvJpikq59IkrS81NbPOrhCbNNM7vylK7CwznX0xZyaSezJMbrCv
Quz5yJ6XK47ONGXpCRvE5mNTWFBQII5bY3IuzW8SO1nIRzwv25xdEfmkzu/J
MYnhAHH6WpOSknLhVv7rbX5Jqi9vA/IVR2+08SnSw/uZsR/PKr9ckxAWSJya
Zx4LJ/ic8t1sz+//PPnaZvN4Um5Q7GxBflPI6z43h7u75yaonnxb/8ip5BFb
kb+4Z6utt+YFcsU29Muo3i+s3jHTyPFf2vyOij0FqG86+VCBPb9bnFeI/GeQ
F263+1/WenSR1WO1+GIR+qv9vV/dns/yHSYybBjlb3aal8IFqN5+u1Cv9End
Zf11Xfp374J+6l9cMfz3DDm/2PZj9ATpXYz4p8hJJej3OOlfYsLLfbHkMaXo
R4z6UYr8xpJ7S9Hv0epPmXk6/DOK7CvDeVHq12744RFy5m7UP1L92w19hpNn
7oHeD6qfe+z5+cPIg8rRz/vV33Kcdx/5eLl5LyHitYHqdwX6dQ+5qAL3a4D6
Xwm9+pGXVJpwOm13yA+V2O/mpf/5iSrs9w85rwr39zr5jyrkd428cK+x86WP
7N+Lfv5Ojq6GflrProYfr5IvVqP+P8lz92E/7e/dh/79RY6sQT1/k5fX4D4p
3zM1Nj7jX7LZj/lyg1y2H/Wr3n5ezAMP9ZjkRf7SJ9ULf9xFLvSifunZ7bX7
JfQn3/AiH+kfdwD63k1OPgB/ql/5Lt9LPuhyhPx9AP5Sv2NrrT6zBsnvtXZe
xssfm2oxnwfL/7Xw2xDylVr4UzymDnrIbwvq0O+huh91yF/+bKnD/g/ovtRB
P3GUD9+P1P3xQR/5PcuH88U+H/r1EPmCz553UjyiHn5W/Jx63Cflk1kPP6ie
mnr4R3r11MNv0ntYg7Ef6tfMBvhD/f6gAe+L/FLRAH3k/9MN6K/8OqgR9cvv
Uxtx3mVyeiPuUy+5pBH1/ko+3gi/nScPaLL5rT5Hjgd7fiG/7a7/RC5y138k
H2nCvDxO9jTj/nxHntAM/Q6TlzRjHou3Yf2y+FAz3pMj5OvNeJ+/1bxowbzU
/m+0QM+jmh8t8MP35GAL+nlM88Rl5Tu2FfE/aL60Yr8T5A2tOO+k5k0r3iPV
/1sr3stTmj9+xJ8mJ/pRv/TL9sMv4gY/7ov4ot/mF6H9Hm7D+6F85rbhPVU9
q9pu19vbhvkh/c61wa/faJ61w2+HyC+63KX51o55EyRXteP+dWjetSM/P3lw
B85v0vzrgD/rycs64OdazcMO6LuffALfz6jWfHTg90ryow7O30Oe5OD/sxLy
qw78sZOc6pjw39VF5DWOfc+mF5ALHei9jVyH9eAWcrf7/VzyeQfzZCP5hgO/
riMPD8APOeS4APyQRZ7t8ifk5ICtZ0c2eWUA/dX38wOYf5+S9wVwX9aSDwaQ
r/iXAOa18rkWgL/EQ4PQbz05Ngh9xTOCOE+cFMT7Kc4IYn5qv03gxeLyIOpX
Pk4Q/Vb+p3D+DtV3xT1f9Q/shD+l15hOzJNV5IROzIMV5AWd8OeH5DQ3/n3y
Ojc+jVzsxr9LbulEf1PJx9z4JeReN34xuX8I8a+To0KIX0SeHEL8AvK8EPJJ
JC91418hZ4VQ78vk7W78LLIvhPs9g3zYjTfkCyHclynkm258PHlEF/o9kTy+
C/NnPHlOF/wxjvxmF/wVS87ssvfrnbFh/g8Q1Hll
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1gtMlWUcBnDmtBbazbFCK7LpnLpsFJvSBX295KVYAqViMUu8BNoGunSk
lMpkqUvBQhM0FQ8Koh4PVw+HA5wb2ha6VU5m0wWWREFmJo3Z0s770PO0xQbs
t+983/v+b+93nkrPSlk+KCIi4kr41/7nT35PcvzbvROnDWiuiYuLq/nPi0xC
ZPvod2hfuvlzXFqBHJFpnLM7b8smy6wI/yzR59eYJ/N7vpY71pp2R3ZCuu7/
wBQE+irkUbmmpLh4xFI9byPWk2M3mxR3zJBlen6edb6ctMWUZSdELtd6+WZO
5/oiOftju964FVp/mxmfVhCQC7ebKOfsJe9qP59gvQzatQP5kU2BCS+/KpPO
KES+Vmq/u2w+uuT+XaZzfZRzlfb/qbH/dH3rZ+ZcW1ub1k8qMr3J7gPaf/Ru
rKd8dOxGPpXfij023ijVL/tzEw6vL42O34v9vKn4i01ku+NGKv1lMfa/UPko
Qf7n06n7sN4bys9+u9/E1+nu/chnivL1BfIv5xyw9zfJ5iDW0/2DD5lwP7rl
jEOIV+u1HbL5j9N+YkuRvwV0USn6Te4vtf1UrHjSDmO/itd32Na7Ux7jsPuf
vkj1cJjVCZEL5V4H+ktOKjPBvnFpur+2DJ/XetFHbP4e1H5yj6CeiqfjCOql
eGcetfO0Pln1PIp6zaOHleP5r6m+5eiXRPpCuY0/+VXVu8Lmr2cuvb8C9Zyj
+h9DPmbTy45h/mapH45hvmfST1eiX2aoPyrRX9PpW5WIR049jnxOo73HMa9G
/XPCxtM+ld5ywtY/Xu4+gfNhCp14Ev0iu05iHhPoKKfZEC6onONE/l6iLzsR
v2xOYX9y2SnE86L60YXny5NcNv5sOQPX4+QSF+5/Qf3qQj/Ld1yorxxbhXmS
06uQ7+fVz1VYXz5ThfNV7q9CvuUJ1ZivePV7Nc4zeWc1nj9Z/V9t+3m7fLMa
/SqPqcH1SfSCGsxjnOajBvuPpT34fOREzUsN5nE8HVOL/I/V/NSi/0bTebW4
f5TmCdfbHqe7apGPEZqvOvRLNP1KnQn/3STn1qEesrMO+9f9HXXoP3l4PeIZ
qXmsx7zK6+rxPLmiHv3zGP1dPfpbHnYa9ZCnnMY8ytmnUT/Fd/h/1y8MXNd6
97jx/lI88W703yP0ygFHad7ddv8xw+nzbrzPHtL8NyD+++nnGux8OYbqPGhA
/9xH72nAfu7V+dCA+AbTtxtwHg7SeeHBeXG3518v9qD//6YLPbZeEX/RAY/N
79p++pYH89tHj23E+fYHndqIfrhBb2/E/q7T3kbMaw99vRH91E2P8qJ/uugU
L95fP9BbBtxJ13ttfJc76G4v6qHrI5sQz1U6sQn51vM+asLnf6RdTYjnGn21
CfOm/UQ12/Ps7E/0rGbMx890TjPm5xe6shnvO8V7uRnvt176gRb0h/JjWtCv
v9FrWtAPymdZi/2+8sxN+mILzp/f6cE+vI90/xM+zM+v9CQf+k/7mTfweeU/
w4fzUfnY7EP9lM8SH+p3ha7xoX6X6DYf8nmRvuaz+d/0DX3Hh3qdpx/1o95f
0bF+fD85S8/1Y/6CdLof7xMfvcGP88BLF/lxnrrpk37Us44+48f3vSr6ez/6
wUn3+zFflfTDAeTjKD0hgPPYQc8IIP8H6bQA+nMfvTaA9/deemcA+SuiywPo
p0LaF0B9dtCXApi/bfTNAPKdTw8Nwnn0mCDex5vpBFxP3EgvCCIfH9JZQfTf
BnprEOdpDl0aRH7X0Z4g+u99+tsgvg+spnuDyE8WPSSEfL5Hx4Tw+Ux6Mq53
rqCTQpinZXRmCOstofNCON8X0/tCiO8tujaE+FLpcwPX59NdA/en0HdDiH8e
Hd2KeiXSz7ain+bQr7RiHl+ml7bivJtO57ZifqeG/Q9iWWoJ
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx28m1dBpGiVaopYVkRpKEW1Rv+zFl1gJa6TbzRVqgVYghSky
E4JlrAQLNZCIV3kRzoM74DgO+N//TnINXe/MogJXzA1WzaTIlnW/7/V8HWzs
9tn//s/v+zzP93l+tyQlPWnbNIvF8n3gX3/Kn23NSHbB+PJHg7RO7YwPHcwn
b1J7w2xryEaKOjMwMPAWn6epFwN/ZJWu1o5kh5GNTMTLEx7OUkXmRAPZskf9
EWktIi/OUbUZ8YVk9ebU59G5KhDeRjbyVMFYoitXeEO+0h/7eV6Bfh63Tzjj
bejN4fnvqCRXREG2cHGh1l+ym3reVWWlpaW7hO3v4fnr1FeE9zOFU4tV6GBN
Rgb1HlKLAgJeFZ48pPOPfJn631fWIjOLfOAD1PsV5lOiz5/P98MP6/i/kYcP
6+9/ki7ccETFawHM9yj07RSO+1AFwr9AvZZSdbe1aPVrwqdL9fu3M7/iMtQz
S3jjMf3+CHlxuQqc1sP6XChHvd5gvT5CPVjP3RU4bw/r9zH8wvpPr9T9DyWn
VsIvjDdQqf2XwPOjq3R+IdRfUqXr/Tnzn6yCP1gvazX0Xq1/tQqkc3m78NIa
9CON/ahB/1KFx2vQ/5fYn1roITtrkS85vE77bZScU4f3GW+4Dt/neY8fV4F2
7aCehuNaX/YO4Zn1qC/1Z9QjH/rlq/qp/ohrgN9Yj/IG9J9+sDSq8URXBf2w
tRH9veqHRviB9V7WhPlhv4ubpvbnUpPWP8Z+bzyBeOy35wTyuTpfzfAX389v
Rnyed6EZ/aOehBbkR/32FswH8wuzIV/mv9sG/azXkA3+Yn3VSehjf2pPYn62
0Y929H+LcKxd+2PiefrTrvXv3yxcBrZY6Vc7+rlJ+Iod+zOZ/m2F/meFU1qV
byLSmkg/t2L/PS3c36piYmIcT9HfrYi3VjiqTb8/9AT93ob8VgsfDD5/hP5v
w/sPCV9sQ/wHOQ8O+DVWONmB/MgHHPDT/cJuB/x4H+fFgXqTI5yYlxjOjxN+
WCWc50T9V3KenOh/tPCoE/Hv5Xy14/kK4fXteH85560d8ZcJ29qxX+/h/LVj
f0QJz+3A/RLJeeyA3ruEd3WgfndwPjv0/fbcUuFvO7CPb+O8dsKPS4Qf7sR+
WcT57YT+hcLVnfr8Fbdynjt1vvHka13Yn+Q4F+438nYXziOXu5Af+awL+m/h
/HehXuRVXfAfeWsX+kc+0oV5X8D90IXzyZe70J/53Bdu7acY8mY39lc494cb
8zxP2HQjHvmSG/W6WfjObuyrm7hfunFemHBhN+p/I/dNkOcK/9KNes/h/vFA
zw3CSR7M62zuIw/6MUu4w4N5msn95MHvlRnCC3q0vohQ7qse1Ot64X3gyOu4
v3pwfojw+R7cR9dwn/Vi/0wTfrIX37dwv/Win1fG/uemXr0vZv8jPNSL+v8t
PKsP8f4SVn3Yt38KZ/bhPpoQrg3y78Lf9GGeyNMN1Ie80IC+X4VjDeQzJvxM
kC8Ipxq4r0eFcw348SfhMgPnnxd2GPDHsPCAofTHD8I/G+j3d8JXDPTnnPA8
L/IfFI72ol9fC6/z4v76QjjFq+fN/Ex4L75fcVa4xIvfVwPCLV749VPhfi/q
dVr4Ry/2ab/wZDC+X3iOiXnzCUeZyN8r/JiJ+vUJW034q1c4y9T12N8jfNCE
Po9wvQn/dwsbJu4f8rlgPLfwRRP+IM/woX7kpT7sf3K8D/mRk334/UNO92Ff
8rwDwefkKt9UvW4f+s18vvQhf/K4D/cX8w/xQz/rE+FH/w3hB/yYb9Zzgx/3
ATnNDz8wXp4f9wH1H/NDT6ew04/+OYTPBOPZhUf90Ncs/C84oVE4/BT8Xye8
EpxYLbw++LxCeEvw+THhnFOIfzTA/wEfl4bI
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlg9M1GUYx8mBK6Lsj5tYi6icU6eNohlbo97MaTJa4Jp/6rKJeoNc47RR
KqRIkkjKYaEFkomHcqCeB3fAAQfc/e5AqqNWOZlN19GKXDBXTozZwu793p5v
Qzd1n/1+7/M+z/f5Ps/vHsvJX7lpWkxMzOXIX/2//HEsH95RObboxSitUKWj
2R4rea3akh4/VCHsy1Fms3nkAJ/nqcD4vEv7hVW+GrJZuj/m+1tVvSW9vFw4
XKDmm6xL9vH8dsTbK5xcpExWo+Ajxtul4odsf+4RTtmt7zN9yPglyK9EOGuP
ujHPNIPPw6VT37fsVampqS5yzD5VU109m/Ery/V5Kzl5P+KVCjsPqLFsz1Gy
sup4qcw3txL5kFMOqpWepFLWN3EQ9Zcx/08UshAu+1QNhkIhclaVioSzUb/E
Q/r9YuobPqRmOpavp/72w/p8Jvtj+Uz3I539S/tc9zft//5W6/hPsP8D1dCH
5ytrcJ73rTmi8zeYf3It7mO9V2rVo6Wj31Nf5xfQf7fwtqPo907q9yX6XSQc
e0zXM7yDeh5D/YXCoWP6vJnvp9TpfiR9IFxVh/vJE3VKh+N9puPo9y7qf1wN
75jpIM+xQZ9i9sMGPchjNujFerLq0V+yux79JyeewH30Z9EJVRgpkBw+gXrI
S0+qSLjNZPtJ6EdOaEB+ZEuDru8m7zvfoKzGuJ2cZsf75Fo76mU9MY16PuPJ
GxuRH/UYaEQ+1G9hk55HC/WtbEJ+7Mf1Jh3/SfZrzSkw++k9hXh8nnwa+fL8
ntPwB+NfOT21X5ln4Dfm6zyD/rK+mQ74hfpsc8Cv9OMlB/rD+VZnsa/4fv1Z
1MP4sU7d3zjWv9iJ/cj8c524f7twjRP6vU+/OnV98wqEJ53q5Ygg79K/zeAt
wjnNeD+ffm5Gve8I9zeryL/Fm+lvPA/lCS9owflc+r1F61dtFq4Az95E/7fA
3xuEr7Wg/hzOgwvztV54lQv7+C3Ohwt6rhPudCGfNzkvLnwfTMJJbvj1Dc6P
G/4gl7ixD17nPLkRb63wiBt+Jie2oh9rhDNasV/JRa3w02phR6vWu4ocbtX5
ryY/0Ab9yEvbMB/k99qQ/yrO5238023vJ7RjX5Cfb0c/yZZ27A/y8Xbtn3Pk
8+3wB+uZ7sH8kNM82Hfktz2on/rUeuBv8rfR59Q3pgP6kp/uwD5iPzZ2wP/s
3+EO7A/ywG18swP6khd24vtPXteJfjB+JdjM/I1O1PMa90knvj/ZwnO7MN+v
cL904fucIVzeBf8s477pgv+WCF/tQv0vcP94sX+eE17pRbw07iMv4j0j3OaF
31O4n7zIb5HwQ934fTCf+6ob+s0V3tmNeh/n/upGv5OEf+mG/x7mPuuBfrOE
l/Xo/o8+yP3WAz/dJ9zUg34kcN/1oJ67hO/thX/iuP960f87hLf2Yh4nR2Uf
9uL+m8IXejH/N4RjffD/deFHfNCXzxf7oMffwq9G358QzvVh3zD+bh/m+R/h
Gh/21b/CLp+K/FvM/EI+/F64Jfxb9H7WM+mDX6YJz/JjPmO5f/1T9Vjhhx7T
uY/90ONO4UI/fh9Szyo/9IgXPoPzmdS/3w9/3SP8sx9+mMH97Uf97N/9BvzK
5wsM6M94Lxn4vcn7TdH3mX+BgX3CeisM+In6NBioj/r6DNTPflw04Jdx4Ws4
b/9L+O4Avm9XhecEoP8fwukBfA9/F14VwP76VTg/gHhh4bIA5ueycF0A839R
uBPx118Q/jGg53H8B+GxAOr9TjguiPtCwklB9H9A+Nkg/NEnnBXEPjKE83C+
KiBcEkS/g8JHoszz7ij3Cw9Gz58THgni+8v7bwUxD18JJ/Yhv6+Fn4ryN8IZ
UWY9G/oQb1C4qA/+0Of/A577iIs=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx6lFW+Yq60q0RJrOkdNGsSVro33KJuFoCW2G22WJaKEtkEYR
UCpxqcw8UEAPEPnNgXAe3B3cHRzcL9I/0M31w9loQStyg1UrcYw/rPu8r+fN
ug3Yi8/3+/k8z/t5P8/nns7Jz9p3b0xMzI+RH/1XPmtNs5nDc5tfjlK6qrdY
LEu8S5UabJfJ/hx1KHXZjaX1PHV1YmKCrPLVXKa7aen5Qv38W+SpIuWON816
+f6nymBL20NOKFORcNwe7ncYz7uFk46qLHd8LNlfrmxp04uDwjsqVCSf6y6e
Z1LtBamVTuGCY8ocnE908PwTarrEYOsXrqpUr0X+YWc8J9X+yMcmbP9KRdJv
62V8ZujTI/x+lQrNJ05aGW81uFN4oRp6tTP+0zi/Vfj4GRX5faSZ+dTo/dOa
hONq9XpMI/OrVcnJyQ6LsLUOep9lvmehT41wyjl1J9FoPs38Lfr95CrhKxat
f0o19ahXzxjNr/D57Aatb+YZ6tMIfbj/rUZ9Xkkt9ToPP9UJFzehvoxPXYA+
54Tva0Z+9dSzGfVqEJ5oRn7MP6lF+8F0XrimBXpQr4UWHd/MBWFjq45nVQv1
b9X1yKD+69ugfxvr0Yb6sF5zbdqv0x2sT7vW8+EuYWc79GP94zp0fsZu4bIO
ZTQHi+iXqQ7Ef1H41U6s01/WTtS/T3h5F/QiF3QhH/rz2y74i+spVvQP92u0
oj48L6Zb62tlfLnd2v81zOdKN+Jnvpt60H/Up6oH/U6/3u5Bvah/9kXox/qN
gJ+lXxN6cT79UdGr+2vdkp96sT/9mNGHfM30F9hyUthgw3ol/WbD+8eEJ22I
z0T/XYKe5PZLmG9f0o927f8g33/BDn2O0592+OeEcL0d/iBP2FE/xnPXDn+R
k/pRD3JOP/xDrumHftzv637Uk+cvRJnxbRxAfzF+4wD6k/mdGtD+mv+C/h/Q
7x8sF/5rAHocYT841I22gtTDwjsd0Psz9ocD86VU2OtAf5awXxyIp1g43qnr
Ef8J+8eJ+VwkXO7Efh+xn8AlhcIzTq1fzCH2lwvzLF94uwv1/ZD95kI/fCBs
c0H/g+w/F/I7IPzooI5nWR77cRD1fE/440HM+/3sz0H9vm+f8A9RzmW/DuH8
vcIvDaFeOezfIfiV3DoE/fawn4fg33eF73dDn3fY327cn+QDbvh3N/vdjf4l
X3OryPX159vsfw/8TH7eA7+Scz3od3KdB/erkfPBg/O5vuhBPjxvkxd+Iu/2
ot/5fpUX9yk56EW/kW97oRd5wzD8w/Oyh/9/fuUw9iePDMMvPP/3YfQDOWEE
+ZCzRpA/9awAXyYP4vlM1uPWCO4X8mof/MX6Zfgwz1jfz304j2z3Yf7THz/7
cN/SP4ZR6E9/bRuFn8jFo/AH/dgzivuDfp0cxTzh8w+NYX+er8Ywv5hfYZSp
d/sY9Ngl/P0Y+mUn56Mf8/xN4TV+1GcH56Uf8b8u/IYf9Uzn/PQjn23CR7Gf
bSvnKd43KWGHH35O5XyNnv+i8K9+1HsL5210/2ThlQH4PYnzN4D9NgunBxD/
Rs7jAPp/g3Ap1pvWcT4H0K8Jwn0BfB9Yw3kdgH9WCf8UwDx7gvM7gPgfE14R
xPeXFZznQejH9a1B+M/A+R5EPI8LFwURL/c/hfX4OOGuIOJlPH7sb1otfDMI
/Z/kfRCEfk8JPxhCPzO/9VGOF04Nwe9reV+E4Efulx+CHit5f4QwL5hPS0jP
p4JHeJ+EMA+WC38TwvfzB3i/hNDPscKxYczfe3jfhFGPu7P/8ZYw5sWi8I4w
9L4jnBeG3n8Ll4eh1x/CDWHMl1lhZxjz+Dfhq2H0zy/CM2HUZ0r4nzDm76Rw
3Dj68abwc+Pw53fC28cxX64L7x1HP18TLhvH/af5X6LahH8=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdl31M1VUYx1nT/iBns1iRTcRsjlw2rGX8Ee2ULrJYIX+YbrcX8SXQCqRw
hCyTpIxlQKHJiwjcC1zeLhfuBe77O0oFlmmSRgvacm6y1lo25h/VPd/fnm+7
3s3LPjvnPOd5vs/Lua4qKM7ffVtSUtLP8X/6r3z2Zye/HJ1f97RBm9X8Fldr
hLxd6W9yqEDZcuYqwlwvUn9nmO4kq2I1bS7xh7i/VOW70qrJs2UqxZazg5z0
ntL3k9Mr1Z74h6wOJZ7PPHyL/SplKclO5v15R3CePFut7U+TSz7Gff/H94mK
m79OrqvR9mqoR/qnqvr6lqyYsP2YMtVGbpBVLfwZFy6s03rUnqG/9So5vuGs
8EI97p+g/5+rg3FBvhI++oV6yFT7zNeMpwH8jXDqcTU1OZk7yfiOq+iNDNOU
sPUE7jvHeL9EPN8KZ51UcTnM3zH+Rm0/cl54olHrd/V76tGk9V98UXhbs4qH
n/ED9WmB/5eEr7Ugv9PU6xT8+VG4vBV8mfqdhv9XhBe1af9W/0Q927T+LvJk
G/QnZ7Ynrje0a/t/0N5Cu2pqbGzkfaYOfd8M/Qt1oD4Yz4Nm6HOB+TAjX9Rn
3oz7qW+eBflmPpwW+M/8pXaiPpj/yk7Ey3qZ7YS+rLdNXVrPs6xva5fW2xoQ
XtKNdR/zC87xCl802MN8W3U+5tzCLVbcx/WkHvhP3tWDeGlvogf2eN/DvVj3
sz56kU/691cv9A6yXvoS4/H1Kf2H/Zbej/jYn0f6tV7ZPH+tH/nh/bkDWv8y
+msf0Pfd5xJOsen+mBxhvdkwPxzCM1jPHWL9DSJfg8KWQcyTAdajHXr1CW+w
6/mY1sP6tKuV8QLsFm6yq7mKFFsn69WO+WER/seO+ulg/Q6B24ULhhA/uWEI
+rUJnxmCvuSFIehHXjuMeUY2DSNftPfZMPqbHBpWz81VNNCfP4cRj5n94EC8
9H+rA/6SjzqQH8brcaDeu9gvDvhHfdKc8N/K/nEiP9Szyon89rKfnJgn1P+q
E/nrZ3+NQF/m6/kR+Gtjv43o9+om2Yb1VuZ79pbzd42ifujPplHox3gOjGJ+
UC8r2HRa+Iqx3sx+HcP6SeGnxqBXA/t3DHrXC3eM4f5j7Ocx9F+N8O0u6PsR
+9ulHot/PhTe64Leh9jvLvRHpfA5F/q9nP3vVvq7TPhRN/p5P+eBG/PjLeET
bui/l/PBDX/2CN90433YyXnhQb5fE37Vg/lKrvMg368LRzywv4PzxAN7BcJr
vPi9QfvbvMgvucaL+t/FeeNFve8W/t2LeOhvug/rbwjn+3C+kPPIB/tFwqM+
3L+P88mH+fGm8HI/3mvqletH/b4t/L4f9V7M+eXHvCgR/tWv6+E89U8JoP+5
/mwA/Uf75QHdvyn0pzcAvej/TAD1RV4aRL0wHhVEfTCfpUHMO9qzBHEf+VIQ
+jDeRaHE+lgRQv0z3g0h1DvjfclgxlMYSoz3sMGlnKcGvyPsCKE/3uV8DeH3
C+v3t5COz3GA8zaE+uL5e8M4T38yw4n52xzG71vqVRDG/ayng2Hoy/psCKv4
9wevCA+EEd92zmtj/1bhX4z9+Zzfxv4XhZdFdD088gLneQT7c4Q3RrB/I+d7
BPaVcJmx/0nO+wj8zxLuNvY/zvkfQbzrhS8b+9fxPYhAn7XCd0Sxfw3fhyj0
fEA42+CVfC+iqO904eIo8rGK70cU/vB8exTzhOyJol5XC1+IIj7yPM5byYtj
mO/ktBj+P0B+IoZ+pv28GOY7uQjrFfSvKqbrfR/9b45BD8bnjOH+FcJThv37
+V5hPWO58L8Gp/L9GsfvjXuE14+j3+/mezaO+5cJ7xxHPy7l+2asL4nzfx6s
kx4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlWts02UUxhsz/DCJRtNEMHFqRDOJmukS3JeaV12cF6JsKhett4nNRCMT
HeKGOJAZJGbT2BA3EdZ1Y93Yut4v6739d6J2RAM6JTM4ohNZQ4hxZuGD2vdp
zpPIB+h+ef/vOec9l+fc1Ly16eXLTCZTsPRP/56rsN/i2XRYlf40XSjecZ/+
NVX0q77e3pXnhVv6laVy5uaicKFff995TrjGoW7oWmj8Q9juULW1tf6zwksO
9dBcu51sHVC5xepZcnpAmd0NL/L+KqdqilQto/19TjXXbnaTi04142y1LAiv
G9TxOcmBQX2eIK8YUtaebBt555AqhRuhvV+G9Ht76b/+iIpUdb36u7DriI5v
7lfh5cN47xnh1mHVYXZ/eVr45DDi+1m4zoV8nBI+6FI92cXqH4VNI6rYGDn0
vfDmEeT/hPCxEeTvW+HbR9Xf1darjgt/DO75Rviv8vlXwhuP4v6UcPyo9ldl
CN84pvNRlxPeO6ZK6Wzl+dkx5D8vvHZc2Wy2edrzjMPeMWGzW71hqdxA/zvc
arDVsv9r4Vk38sF41YS6rVSggvDgBPxNsx89yDffu8aDepNbPLhP7sP335EL
l/A/HjVdKBTINV7Uj9zs/b89uxfxkqe8un4u8pIX+SWv9qnS/51kqw/9Te72
afv3k9M+1Jv8p0/33wLfv8oP/+T1ftSHvM+PfiJP+vFe5rPoR/+TqwK6HpXk
dQG8l/XbE0C8rHcgoErtfzEjPB9AvyU5X0HoQ0z4kSDmK8x5C+p8rw0Iu4M6
X2Yv5y+I+fIIXxNC/XleH9L+233C20Ow5+d8hmCP9k+FdP/NkJeHUZ+g8L1h
3A9xfsO6XibGOxBGfckny99HhC+P6P63kesi6Cfa2xJBPujvYAT1YrzHI7DP
95miiHdC+O6ortfiOPUgCj0cEz4QRf1GqQ9RxO8SvhhF/wxRLybR307h5yah
dw7qx6TWY+th4SzOV35BPSnf7xO+NQZ9/Iz6EkN8B4T3x2D/U+pNDPrwifD5
8nk39ScOvfpIuCmOen9IPYpjX3wgHIpDr/ZSn+LQl93C1yXQ/7uoVwn0x07h
XThvfIf6lcD97cJnEpiHN6lnSdST/GAS99+iviVxv014NIn7tDebRH52CF+Z
0vlsoH+Vwjy1C29LoR86qIcp+H9X+IcU5pnvq0ijPu8JX59GvpmPNWl8v0f4
8TT69X3qZxr60SW8O439Se5Lox94359GP9N/oeyf8f9W9v829RZ8iHxtBvVl
PmoymC/m4+EM+pv2mjPQA3IH+E7mx57R+e0ij2cwX+SpDOaffDqD/UxeymCf
0P7VWdSP8azOwh7jfSCL/cb3WMEzrH9bFvGxP7qzyNc24eEs4mml/uN79+vC
P2Whn69xH5R5i/AVOXAL90OZbcKWHOq3mfsih/o0C2/NYZ5e4P7IoT+fF3bg
vuVZ7pMc+vMZ4RM5pX+e5n4pn28UXmagvzdw3xjor/XC9xiw/xT3j6HtdT4p
/Iqh83XhCe4jA3pB/tyA/pADl/C0gfyS5w3Uh/yvgX1DXpHHPDQK35VHPz3G
fZZHPz8q/FIe/dDA/ZbX+7m2vsT/Ab9k1K4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlmtoW2UYx4M4P1RRlIAiWisOqUNFHei+VF4vWB0FXcGuQhB3cehE1oqT
0cqoY9FatKlYp+1Ecb2lWZvlnpP7yTknbdVMnZurc9WtXkqlRausMvZBzfsP
zx8aaNMf7znP+3/uvXX7nubnL3O5XP7Kj/4+WzfdftNfw6ryp2tl+a6H9Lfr
hhHVbNSu+1P49REVbJzvWBY+P6JqZodWfhd+dFTNd7jvXhT2j6rBgYGBBeGr
xpRR6136VbhtTG2sfH4RPjWm7++aF97kV+0NNbPnhD/2K+/Slk0/CbvG9X3B
OeGd42p2qK3hrPDMuLJX6+fOCN8ZgJ7vhfsCWs9Ls8IXAvp5z2nh1qPKHWzc
9p1w9ij0nRKum9D6oyeFD04gXuTFCbWr8vlWuGlS25s/IRya1PFrI7uD6vGK
Q+R9QXW8XC5/IzwXVMtbjE/I6pj6p97jIw8fgx7y5SFVCd9ttHd/CPkiv1Bl
6hsMqeG2hhr6Vw4hP/T/39Da+NwT1s/3MH7bwzo/BuPbH9b+LzD+U2H4x/xc
DCNfzN+GCOL1o7AnAv+Y794I8s16MCPqFu/SifPCf0d0flzk9VFtP0f7LVHl
8Vl7qac7qnzWaj39SUdhj/FYjqLevxaujSGeZeGnYtqf/i+FD4Dd5FhM14P3
C+GFGOr/c/ZXXN3h8T1M3hxHPGfYb3HV6Q5OTwsH41r/6hT7L67jcw35uoSu
j9oS+7HKjvBrCTxvsz8TyH9R+IeE1mOZ7Nck9BeEH0yi//Ls3yT6Kyt8JIl6
zrCfwSsp4SsM1IPB/jYQX57vNlB/afa7gfyTv6qe074rpfPdRb4vhfiSd6Z0
/zRR36GUzt8QeSYFfeRLKfiX47xIwx/ys2n0H7kvjXiRrTTiQb6Qhr/k2zPQ
R27NYB6QezLINzmbgV7yHxnUL7kuu1Zvcxb26c/BLOJHTmRR7+RFvG8wXjfm
0O/kphzuZ/z35zDfyKGcns9bmb+fc5ivzK87j35KCj+WR/0mON/y0B8XDuTR
T2HOuzzyMyl8dUHHpzHA+VeAvlHhVwq6ni4d4TwsQN+nwqcLmB+HOR9N1NNH
wjebmPf9nJcm4tMn/KSJ/n6X89PE/nhb+A3Y63mT8xTnS28JR03UI58vm9DT
I/xb1f47nLcm+oP3XV9EPfVy/hZhj/qeKELve5zHRcyr94U7i4gv/esv4v4P
hCer7/N8qoh48v1z4A7yxSLmN/laay1vsFTldxf5EQv5JHss1Cfv22shX9TT
a6E+DgmPWajPDzn/LcxP5u+MhfwNcB9U7x8UvtJGvfB8vY3nab/BRj1QX4uN
feoT3mNDH/PTbaOeu4U/sxFfL/cJ3t94QPikjX2+n/vFxr7rFF7naL2ufdw3
DvrpVeEHHPx/1c7942D+vCz8ogN9u7mPHNTfLuHDDvK3g/vJwT54Tvi4o+eD
38N95aC+nhH+z0H/tXB/lWDvaeF7S9DP880l6CPvKMGfrdxvJfRLa4X/B09c
j0k=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ3buyW2/X140OQCbDhze6jiCa4cdGh8NfNe68h/G1
NjloxvQfegPjx2xymDVz5syXMH7fJgeu64sLnsH4BzY5tL4OtHgM438Cy394
COOrbHZYUmDLBZcP2+zwJnCH3BMYv2OzgzEQPIXxd20G2e8EN//NZoezZ874
PIfx5bY4yAMtfAHjB0D4cPc1QfivYPwtWxyqRda5v4bxn20BuxfuP4mtDrZc
15XfwvheW8HufQfj12x1SEtLewbnr9vqAPT+XlB4zVka23lr71Z4eAIAkh6A
Yg==
      "]], LineBox[CompressedData["
1:eJxd019oUlEcB3CJejEoAqE/kBX1YEWjCKoX4ZdBqxgsfYgefDKSoodZsRha
USNhCCWEVLparRkbq2zhGpJXvffca3uYCyrYGixqUWOg1AgWvfTnnl98D5Qg
+uHee8739/uduyHUFji+yOFwBOyv/I2G3m792Vok+69jvrFtr/x1HC1SwR0/
9RVOFCnmyo3WYa1ISbHgmYO/FClgP/AJXq9ROBye/QAHNNocTPrewVc0avgL
PVPwiMb7T8BzGpkLnuBreE2J4nV/4SXcUqIDM1HXGHyxRM7JvsgoPFSi8Vqt
ZsIfS5xXh11lzqvB+8vkyjXPFOCOMn33BJePwINlmdf9DJ4uUyadXj0ML6tQ
NuJ15mGqyP7Vn8JnKrJ+MQRn+f7EE3iCr/ty8GKd7NsXHsFrdblf+iG8S6ed
9mcQbtV5/QH4hC7rb+mHL7NrD+AM3+/LwnleL38frunkdU5u7IU/67Lfqbvw
L53n1QOvNGTe9tvwdkPOYz4DHzTIbm80DYcM7t8tOGbQunj91Q04ZfD6yo95
vchN+IUhz8e0ev69wfWq/X4YfF664RWC538H3iK4HpV/n+D97sFBIc9vWNXf
Lrh/qj/XBNnHr0n1r1/weVL91QW/L33wlOD61frfhMy3R+VZavK8Vd5N5r95
vSbXr/IeMXneah5tJp9PlbfL5P1U3t7/rj83uT9qvTemzNus5tcwuV41ryUW
91f1323x/il4t8X1XIcPW7I/uSR80uL9r8Kdlny/kgm42+L+d8HDFtcbh8ct
fj874VlLnhf/Jfj33zwX4FVVzhODd1Q5Twd8qMr9PQcfYw+chc/z/U2nbf8B
JSnC1A==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw900tIVFEYB/BLNJuMIrikLZqIWlhQFEKthK+EyghKF61mZTQULQxBiLFF
BUKrZuNmDIRQ81FOD40GwzvncW9CjIEUSmGPoRyqmR4ERriwzvku/zNwufPj
nPs97nfuzo7O9vPrPM9rMZe9X9torq0Bmb/er9q+I/buHQuo1lYY+AlfCajJ
/JzHA1ocvDzzA14KaE8qe9R5U5F6q22F7zAVbbykc1eRUlnVXYOH4v1VeKFI
hWRv9Ru8XtCfxtRm5+2C+nO5bV/hQ/H6F/i0sPFXKvAFQT1+fnYZvi6o3ST4
DPcLKmf8/Z/gyXh/GS4J2mEK/Agvx+vv4bX4+XdwveR+3sIHJJ0oZ/oW4VZp
+7v0Gu6Q/P7m4R7e77+E+ySl0+nKC3hC2nlMzsLPJeWPlzMh/CGOJ+G/0vab
COAtiuufhvcqfh9P4RbFz0/BKWXjrz6Eu5XtNz8B31K2vvQ4PKJ4PiOwUPb9
zd+F33C+xCj8W/H8xuA6zfU579bcv3Oz5vPkfFbbfDmXr5PXB4bhm5o2mAM7
CN/R5JuGnKc1zZVKp9z+V5rn5+qtaZ6vqzcRUrMJ6PInQ+73Hnw45Hnfh8+w
/Tx8MV5/AN+I1x/Btzle7jE8xfl2uXnMhWSO9+gTuBLy9+nm9y/k77MAN0Tc
n5v3wYj0SuPSM/hkxOdxBj4X8bzdebka2flkhfF/0CJ3zw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF0TtIHFEUBuBBSLNWASFWK0IKI0QUEW0WjlqEiIVaWG0TxYBYaAqbmCIR
FqxcC5tVEETBNBF8hfWZ+xoVGYNRiZEgRogK7goiLCQQ1Lln+W8Ghjsf9zHn
/Le0o7etq8DzvJrwteNI7d/xf92Cwk/vJvu83o7eB0GJTGvdNTwm6OxtUcUV
vCAo25qOXsKBoOm+WOQ3fC4ocjR18wu+E/QmFjk6gZ9IaktHEz/hSkm7QRAc
wy8ln/cD7pBcz3d4QJLOlcUP4VFp/9e3D3+Stp/3e/Bm3l/hU0nxpOoP4D+S
XofPDvxY2Xqat+FyRUmVK9uEGxXnZeC4opJE5puE+5XNZ+ILPKwobLdnHZ5R
3M8qLBT3uwwf8/rMZ/hWcZ6LcKGmZ/FkwwL8VHN983BM8/45uF1zf26+V3N/
bv8Qr+9x509qrn8JXtFUNPvizNVzkP9fGs5qzt/V/8jY/tIrcNRwXmtwraFw
eczl0WL4PjbgbmPP/+jyGzScr4DHDffn8l7k/TkF7+bnNXyR3+/u697QWCqV
8uFinwbCBt39Vvm83rnJp+rw2YI7fZvHK+d3//0AaI4rMg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[{{10992.088607594727`, 980600.}, {11000., 980599.75}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 11000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.759427369910127*^9, 3.759427408474264*^9, 
  3.759427630547282*^9}]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{"Plotting", " ", "the", " ", "experimental", " ", "data"}], " ", 
   "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.6897567537802124`*^9, 3.6897567636844306`*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.6897578179773455`*^9, 3.689757817980341*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P2", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980231.540"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"621.024701", ",", "980241.640"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1035.041169", ",", "980273.110"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1035.041169", ",", "980243.600"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"1449.057636", ",", "980246.300"}], " ", "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"2484.098805", ",", "980253.920"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"3105.123506", ",", "980303.000"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"5899.734661", ",", "980383.900"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"8383.833466", ",", "980413.000"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"10867.932271", ",", "980451.000"}], "}"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "11000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.689757585999817*^9, 3.6897575917459784`*^9}, {
   3.689757886597496*^9, 3.6897582658466754`*^9}, {3.690015782400165*^9, 
   3.690015782803361*^9}, {3.690034720006461*^9, 3.6900347204742064`*^9}, 
   3.6907464263075123`*^9, 3.6973096398888464`*^9, 3.6973106315501456`*^9, {
   3.6973115267541857`*^9, 3.697311526851513*^9}, {3.759169685981502*^9, 
   3.7591696883297825`*^9}, {3.759169776476486*^9, 3.759169956205823*^9}, {
   3.7591700100346127`*^9, 3.759170025304873*^9}, {3.7591704201994023`*^9, 
   3.759170562093877*^9}, 3.75934776699139*^9, {3.759347874589635*^9, 
   3.759347920478758*^9}, {3.759347965752324*^9, 3.7593480943488317`*^9}, {
   3.7594201472134595`*^9, 3.759420147326192*^9}, 3.759427264806058*^9, 
   3.7594275788620377`*^9, {3.759427623583782*^9, 3.7594276265140157`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       GraphicsBox[
        {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
         CircleBox[{0, 0}]},
        ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{621.024701, 
      980241.64}}, {{1035.041169, 980273.11}}, {{1035.041169, 980243.6}}, {{
      1449.057636, 980246.3}}, {{2484.098805, 980253.92}}, {{3105.123506, 
      980303.}}, {{5899.734661, 980383.9}}, {{8383.833466, 980413.}}, {{
      10867.932271, 980451.}}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 11000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.759427369957688*^9, 3.759427408525096*^9, 
  3.759427630600114*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Merging", " ", "the", " ", "two", " ", "former", " ", "plots"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6897583017759314`*^9, 3.689758322098931*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"P1", ",", "P2"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.6897582701715727`*^9, 3.689758280789153*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmC1uEOuwqNAUMUiQxfMeMejKnaTaRNbQiN0kZlhukIw0Z
CZOFZoJKGKAEHMqLcB7cCcfdAXf/O8i2s2Y6TKOUnBcqNTM0Mifd88XvE5uy
z/78n+f39jx305LTEjaP8vPz+9n3T/7mT1zAxfDxN6NfHdFKUVpSUjJB+W1R
nR4XEEQ7koVhRV/mRPV8i0hJSfE+QYs0EZp3a+2T6u+3CR8tT9FXM8TAWktI
sHr/E+H7b/ckOixLuO5G9k5W630q34+dQsfkiHuRSQVT1fq5QucLKISO3yPm
+X7C1H55iHcanf6ZmJlUoD2r9t8rEiwhYyPown1il2/B51Q8+xHfdNr4hVzf
NEPFV4D8I+nUQhnfhCgV70HE8zw9dBD1maXiPyQsIXkfRtP5hxHvbJVPkaz/
vhfo4C/hGJXfiOfQtcWId67K9wjWn0fHfoX956v8S0Rfpm72AvpMiXzfb6Gq
R6msxzfK68tkvfIWqfocRX9i6f6j6J+y8RjyWUzvLMc8vajq9zXiVx5Tgf2X
qHpWyP5uVM89FZgntX9MJdZT8RdVIj+V/1Al5kXVL6kK/f+//lUi4KL+9kw6
Qi/nf5Lqb74e+an5GNBjfTVP8dWy/ylq/szVcr30Z1S/jiN/Ne9ZI1bn4+px
4QsnQ52nZSfQL3X+ak8g/0A6sEac9XhWP6b6W4P58qcv1CD+0arftXK/+8M3
HvlorfjId+Af0H51sv+Gf+hNdejvPfpMnfz7dX/Rs+qFvC9u04X1qN8APViP
/tyg159Evl7aflL4yhN3jQ5rQHxX6D0NeL+X7m9APS/RqxtFgXY3soc2NmLe
fqB1BvT7e3qnQfZ7qYfuNSDeM7Q4hfuui64+hb/X6DFG2Y9bHfRCo3i9L7PI
RqcaMR8WutSI+pppjxH5N9EPjeiPgY5pwn1STyc3Yb5q6KIm7K+nu5vQnwp6
qAnrHaOjmtHPEjqpGfkU0weaEd8h2tGM+S2g7zSjH5/TESacz3w60STz1+XR
+SY5D/oc2mrCfZJND5jQz0w6xIx4dtDxZtwv2+lcM/JPp81mxLuV9pplv5O2
0MGncf9vpledRj7JdBbs3UAbRp6/S18deb6OntiC52/Ry2BvPP3xyPM36doW
7L+SvgxvXE4HtmI+l9Ivt+I8vUKnt8p8zy2hq1pxvmPpC624r+bT/hacnzl0
rAXzE01/YMH5iFLn3SI/b8un099Z0L9wdf7b0N9Qem6bkL+mqPugDfdTMF3c
hnro1P3Qhn4E0ffbZPyeceq+sCLeAHqDFfPpr+4PK74PjKY1K87vcD/vEyvi
eUBPt+E+GKLX21DfQXqfDfX7k7bbMH+/03/YcH/dpMPsOM9eOsGO/a7Re+y4
j6/QLXbM4090vx3z/CM9uV3Wv/YCvbod9T5HZ7fL9XefpY3tqOe39K/tmP9u
WteB+DV6eQfi76R3dqB/Nrq+A/dbK93bgXkz0+M7ZT/ajbToxHqN9LZOrFdH
V3diveN0TyfWq6LHOLBeOT3VgX6W0QsduK+O0GscuM8O06kO9KuQznFgnvfT
pQ7Uby9tcmAe82iPA/3Poa8jnrhs+iHiKc+kn3aivzvoGCfO63Z6pRPnLY1O
dqI+W+ldTuSTShc50b9NdKMT3x830t14X/8efQXvj32HHsL7KYl0kIb9E+go
DfuvoV/TMD9v0Eka7p8VdIaG/JfRBzTkL+gaDff7S7RDQz8X05c0zNsC+o6G
+s+lH3fh/M2mI1w471F0nAv3zww60YV6hdNpLsQbSue7EO8UutKFz+Ng2uqS
/b6ro8+7cD6C6AEX7pNx9Fg3vg8G0CFu9NefXuTGvI6i4934/Bz+7ZG3uJHf
v3SuG/n9TZe5kd8gbXajH7fps27M4wDtdeP72Q162I377Tod3IX56aPndKEe
v9CrulCPy/T7XTiPPXRWF+btvM//Aes3XeI=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxd1g9M1GUYB3BsWk1dTncztElazJF/kqAQs7M3YhJqdjIzrJsWKCpmootG
yhJJJjITVNBANJBTEOE8uAPuDg5+9wdjE22VWZkWNDNSKua/kSvt936v7+uM
zXOf3e/3/nme533em5SyPmnlAyEhIRf1f/J//g3/tmpg7ZXpLwWVKHRnvKu8
VKSlpV1W1lLEU+bCuHXq+zXild5NxcpivTjd3d2trG0U5kLfTeWeTGHJMA5/
T73/4f2emC3nH7g33hY5n085cqvQP3PujZ8r+hc5w5RN20TvJoNVrbcnD98r
Z2yX68m8t98dIu/qImc6XVQg/DcjLqxR69kpnGF5V1fTtk+EwZrQu0qtr1Do
4fKk0auLRJL+wkq13t0iWv9bQQ/uFpsN1s9T1Pr3SCe8Q+fvlc/bl6v9FMvx
hi2jQ0vwvFntrwT5epOu2SfjWZCs9rsf+VlCx36K7xer/Zfi/SS6qxT5Nal4
lCE/C+nkA8jHfBWfchmftYl0XznWm6DidRDzx9NZh0RZaem4OBW/z8StCHPh
i/TQCpnfEKOKZ4Wsv7TZdHcF4q0cWYnnX6CLK2U+Y5UHK2U+zcrmw9ivsvY/
h1fd/3x+FfKn3F+FelbzmyzCqA+g7LDI9RmVQ49gvc/T2UeE/nqEcs8RoZfT
pll0/FHUY6zK51HU40x6ZDXOY4zKb7XYoC/gOfpsNernWZXvGtR7NF1eg/MQ
pfJ/DM9H0ivg6BmqHo4hf9PpabWYf6qqj1qMN4W+UYv6jFD1clyu743JdFvQ
4ap+6lBvT9Db6jDeRFVPdZhvAr2gXn5/6DFVX/WYbxxtsOL5sarerMivgb4A
D4xW9XcC9TWKtpxA/xqp6tGGfA2nY2yI50OqPm3I71C6zCbzeXuIqleb7EdP
3/3tP9+xob7+piMbhP6Z8xed0iDPR+kturgB/ew6fbIB9TFADzZg/t/pKY3w
FdrciOd/pXc1YrxLtNaI+Xrpa43oXz/S4XbE5wd6iR3x/o7Ot8v6f/Ib2m3H
/r+k++2I5xk6zIH5TtEmB8bvonMdiFcn7XAgX176sgP12k6HNiG/rfS8JuTL
SWc3oV87aGsT6rmB7mnCfqz0mGac71o6vhnnu5r+oFk8rgfUQtcEn6+gzzej
Pg/SI1tQ32X0nBbU5z46owXx3ksfbkE8i+izLcjnTvpBJ+pnBx3rRHzy6HQn
+nsuXe7EedpCn3EifpvpEBf2n0VHudBP3qdXuJCfDfQ+V/A+p7tcWH86fdsl
+/moVfQ0N/KdSi9zY39v00Vuma8aM+1zo/8spW+4Ub+v05Nb0V+T6ORW3EcL
6QI4bj7dFvw+gf6jFfuNpye24T4WdFIb3jfS22DfLLq5DfPH0H2wJ4oe78H9
M4Ne4EG8p9IfeVDfEbTNg/oKp3/2IF+TaEM76nUCPbcd9/F4Oqtd6J85Y+na
duRnDH2hHffzKPqRDpyHEbToQD9+mN7YgXgMpS0d2M8Q+lwH+sc/feyPGtZ7
m56g4T6/Rcdocn0h1+nXNKznT3q1hvvtKr1Vk/1iQR9dpiH/l2i7hvrppbs1
xOci/UtwvvP0neB85+hHvajvr+hIL/L9BZ3oxf5O0SleOb6hi97sRbwDdLEX
vw81ut6L/uChT3pRHy76Jy/W30wPenFeG+nRPpxnKz3Fh/wcp1/2Ybxq2uzD
eBY604fxKuhdwfHK6ergeKW0FhyvhP7eh3zuoa/5cL530SP86F8FdLgf+dpO
G/2I38f0Ej/6QQ693o/7M5vO9yMfWXSlH/WWSbv96B8b6K/9uF/W0f1+9MN0
elgg+HucDgtgP6n0zADyt5w2BVB/b9Fr8L4xmc7F+4cW0wcCmN9EO/C++VX6
dAD1mkhfDuD37lz6bgD7j6NDO7H/OfQzneh/s+l5nThPM+nUTuQzms7uRPwj
df8LYsBreQ==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmpE2zsrrlSxO1nKmp016MzZFPWpKMprJput1yoZJaC3XD
iTJfEFNJERTUQzQQlBflPLgX7vAO/ve/P+oKbfZi5XBCTUZKzUzT2Ubd8z2/
P9ic+3j3/z/P8/t9fw+OTc9MWzkgLi7uevSP/ps/9v3mfePWlHdimqe6Ntmm
hsVLlc2Z/LHYSFdVa5Py+z9frb/vFKtMdam9vb3/++tVRkZGt7gzSzmTux71
P5+t3zfYpMfkqFKHY4RYbVXR7U0QT9uudt5emCg2ctVE+/7Z4gV5anT0C+LO
nXr9DPHaXSp63ixx3B71z4Tov9CF+Xq9mv797FWbbc4LYtc+5U/Yebt/f/vV
+9ECROhVhdiPeFqRGvxT5VrxwyK8X2wc0PXtEu8+qHoX+hMsOU8x6i8eXqKS
oi8Ud5ZgP+KaQ+r16E+bnPewrvcmceIRvT9THOdA/c/TFx2on7iwVPfDIV5y
VK2LbkA8pgz9ukD3lKEe8rnrmN7vy7K/jcexv/76faWi5UmS/A0s1/VObpF6
luv1PgzS7eXoZ7PUtwL99NPFFeinT+pdgXp7aPsJ9LNR6n8C9XPR4ypxnrPS
j0qd59R6urdSpUUfOC39qULea2lPFZ6vkX6dRP9P0TkndX2vVEn/TiIvlfS7
p3S+/RXSTzixnB5Sjf0fl/5Wq8j9CfZj9A/VSv9VJv2uwXyW0mU1yJND+l+L
vB2hV9RiXg9JHmqxnxJ6ch3mv1jyUYd+HKTv1aF/ByQvpzG/RXTwtO7PM4WS
nzO4DwrovDOYh32SpzOo7146tV7nx/2l5Kse+cynbU7kfY/kzYn87KY7nLjf
dkn+zqJeX9BVZ7FenuTRhTztoGe4kIdcyacLz2+nS13I21bJqwv12EL3uXS/
OnIkvw2o32Y6vQHnz5Y8N2D/G+nzDXpeQhsk3w2Ytyx6UiPma73kvRHzl0kX
NKL+n0n+G/X83F9F323EfK+UeXCj3un0Yjf6v0zmw4382elmN/q9VObFjfcv
ohM82H+azI9H12/bfDrXg3lIlXnC53Hz6G4P8viezJcX8zWbTvHivLNk3ryY
t5m004v1EmX+vMjDm/RzPpx/usyjD9+fSm/w4f2vynz6MI+v0Nd86Oc4mdcm
fV/Ej6XfbsL9PUrmtwn330j6RBPWf0HmuUnfT58+Tz/hRz2Gynz7df+Lh9Br
/Kj/IJl3P+oVT1/2I48DZP4DWK/v98d+LYD74V96RQD34wP6UAD37T36YgD7
+Yt+FMD9+Ac9uRl5u0V/1Iz9dtOFsO032mzGPN+g78EjOujx5/D5z/QSeMSP
dH7s8yt0MPb5ZfrPc1j/a3pMEPu7QKcFke8InRdE/wzaF0QegnRPEPeXnx4Z
Qh69dGoI92kDvSWEeXHSrhDyWUf/GkJ/qmlbC+alkp7bgvkupze2IE9ldF0L
6umgO1pwnhL66Vbst4hWrchXAb2+FfdTPl3Viv3soq+2Ik876IEG5mEbPcpA
fXPoGQbykU3PN7BeFr3KwHrr6O0G1vucLjVw/6yh3Qb6+QndbiBvy+mbhq7/
nWV0n4H7004PC+P/P0voaWHMyyJ6Xhj7X0inh1GvD+jNYcxHCl0cxvzPpevD
uE/m0Odj75tF34i9byb9MPa+RPpZE+97g55kYn/T6Tkmfh9Noe0mzjuRzjJx
3vF0gYl+vURXm6jfaNowdX+2vUj/YuL3zzD6ron72EY/GUHehtLjIpiPp+ik
CO6/QfTiCM4TT2dGcJ4B9O4I8tnX89gVEdw3j+hmPJ/8gP4ez9f8TffG1r9D
x1tYv5dOsLB+D/2WhbzepBdYOH8XvdrC+a/TuRbu52v0UQv3y1XaY6Gf39GX
LNT/W7rbQn6/of+zcN9cpIe3YR4senob9mvQKW3Yb4he3ob9BuicNsyPN+r/
AWFSdIo=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g1M1GUcB3DGpBVZlrum5SItc+q0yEpcDfdEmeFsAjVfimySMnxZ+DKc
oVkwKCQTX1ADScFDQJTz5I7juDvgf29IE3OmiRamWBIoK+fUyJp2z/f6/pxu
yj7+//c8v+f5vRyj0jJTFkVGREScC/3VP/nHGZO/9Mrlia+FlajyryQ773qe
iu40XxUbaaq0pOTxfnm+WHVnm54Tq0z1YuiP2Fip4qM7nxFfyFKW6d237q7/
iRqXWuQTj1yn91suVp+pyuXx0eLYHHVzbGrRZVk/V+kf4qQ8tSI+ek6f7Jev
+pOdu3vp5V+qYx0dHb/L/htUenp6Tw+9uVCF7uPKJYlnozKFAv6Ntn6tQuE1
/yrxFen4Ci/SGZv1eRK6Jd4tWO88PbBFpYT+4xeJf6s+z5BzdME2rPeznKdY
ha7nxll6+Hac74ycb7sKPa45TdfsQL5OyXl3Ij8n6Snf6POmn5Dzl+A+j9Pt
Jcj/MbmPUr1f51F67i6s/53cT5k+T1Q73VumngotcETu61ucV7xmt64Pm1jt
Uf4bY7vEg8pRH+KMctyPrN9RjvoTx1bc6+KKe98fqMD9yXqpe5F/sbFXvdWd
XSwebb43/gIzPt9G95txX+KkSv15k9heifMGJV/7UD8Bet0+na+x4gv7kE8/
/UaV3i/LJ/ms0veR7aUHV+t6WmpIfqtRb630qWrko0XyXaPzb/HQZTV43y35
3496bqIX7ke/OqUe9iMeBz2hFvmzS33UIn/19PVa1LtV6uUAbKE9B/D+Qamf
g6i3WjrvoAr9+3mN1BOeT6miZ9ahX81SX3V4v4I2WTAv9ki9wYVldJdFvx9R
KvV3CP2wk648hPsolnq0op620pOtqI8iqU88L9pIl1oxzzZIvVpx/i/o21bE
lyf1exj3nUOnHcb8XC/1fFjHE7+Wbgt7jdR32Fn0+HqcZ5XUez3mwwp6Uz3u
P1Pqvx718jF9rR7xLJN+sOH+l9CzbdgvQ/rDhnjTaZcNn18o/WLD+ml0jB37
fyj9Y9fvmz+gc+2I/33pJzv6ex7dY1drTZYjs6W/GvD+u/SMBuQ3RfqtAfmf
RVsakM+3pf/Cz2fQQx2YP9OlHx1Yfxq92oH9E6Q/Hfr7JUbRPznw/RUv/dqI
+n6FntqI9eOkfxtxfy/TexvR35Oknxsxn56n73OiPidIfzsxX8bRS5xYf4z0
uxPnHU1/70S8o6T/mzCPYuhJTfi+GCHzIOzh9I7w+4/JfGjCekPpW02Yh0Nk
XriQj8H0fBf64X6ZHy7dTyeiaJ8L8yVS5okL/XWn73+PceN+/qXnujHP/qYL
3dj/Ju1xY15co/9wY/0/6ZEezNd+OsWD9froPA/qt4d2eJD/i3Qvnuefp59o
xue76JnNyMcZen0z5vGPtLUZ9fUDfbEZ8R+nTS3Y7yj9ZgvmcTu9pgX3H6Rr
w+976a4W1GML/XAr1nfTqhX12UivbNX9mWqnK1sRv5U+3ar7saSOHmSgfmvp
Jw3ks4qebCBfZnqWgXoopzMMrFdG5xiotxK61MA83U7bsH7yVrrDQP1voi8Z
OO9X9O3wfgX0MC/qKY+O9WK+5NCJXsyjT+k0L+LJptd6cV+r6WIv5uEqus6L
eDPpNq/Ox/Rl9Hkvfv/IoAe8OM8i+lEf7m8BPR5Onk+/Hn7+Hp0afj6Hzgo/
f4feFH6eRFf7sP9M2vAhvkT6rA/xT6Ov+XC+BPpBP84/lR7tR/5fpeP9+L6J
o2f7UZ8v0Zl+5DuWLvBjPk2kK/zop3G0y4/fv56lT/pRT0/T/X7kP4aOCuC8
I+iYAM4zjI4L4PvMRCcFEO8j9OIA6uEhOjeAeB6gdwUQTxRtD6B/I+lj2P/E
7V5+X2H/hH/oOwH0/1/08CD2u06/EMT30VV6RhD79dMfBfV5F/TR64LI56WQ
/wNkk4XM
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g9MlGUcB3ByaIu0zK5ETUQlQ1NDM6XZ6eOfVJgudM5oslxozj8r0UUZ
MkOS+ScDVNRANBCQE/Q4ODgOuIP3/qCunS2ni2Vk4pJpMGcOi+lG3fPV78+8
TfCzl3uf37/ned/RyZuWfdwvJCTkt+A//ft/nwzVNWnOw//GKZN1Ycdjf6DG
J+XMFRvJapkzImu2XF+vfPei22fRapPaFryB2Niifc5MX0tVm81h74tDvlT6
pzgyXWV1LXW+I/f7CuuJY3aotcGP2MjE/cQJO3U8SeJrWSqsrSRFnLJLLepI
yxOH7EF84ty9er3+j+PZ92S8tm8Rn1jlKHNY21jJd12uKsjPzxfH7FfdS50R
Uq/e/SrHe88iNg48Wd/dB3V+neKEPPV3dFLOHDr8EP5+ruR3CPWbR1sO6+te
ccoRVZpi3jufjv0O+bwr+efreKIX0OfzVbD998W5BepCIBBYSCce1fkcXyT1
KUQ/4uibhTr/YfFSr2Ooh3jrcRVsh1usvtc2i0OLUC+537oifF/WDxShPhJ/
TDHWk/zyijF/Up/eYhUsR6rUM+mE7lfJ4/k8oevRJv2PKtH1fn6m9KNEjQo2
/G26uwT5z5D+lOr733uLri1FfadJv8owX1Pp9DL0b4r0rwz1fYOefxL1nCz9
PKn7FzaJHliO/r4u/S3H/phAXy7H+uOl3xb1ZvATTRdaMK+vSf9PoX7j6DWn
cP1VmYdT+H4UPbEC9Rgr81Gh5yVtDN1TgfkeLfNSifMkknZV4v7iyNPIdxS9
87Rezx4h83Ra6V/ixWew/kiZrzPo5yu0yYp+jJB5s2IexO1W7P/hMn9ViG8Y
XVqlOtJMk8WhNpwf4fR0m75uHSrzacM8vkwX2PT9TeKADfP9Et1nw/lkkvmt
VsH2bXyRTq7GvA6Rea5GfQbTZ6tR70Ey39Xofxg9oQZ+Wua9RtcvI5TOrkE+
T8n81yCevj8f+W4N5vMBHWVHv3rpFXacDz30bjvm9y+60Y79cZvutiP+Ljqi
FvW9SSfU6nju/EFn4rq1g66txfev0p21OB9+pcPr9DxcbKPj65DvZTq9Dutd
pK112O8X6GsP//4HeogD+Z6j5zuwf3305w7EY9AWB54XbvqKA/k30APr9fMi
1kHPqke9auiUetyvij5Rj/mtpC/X4/y20AOc2K9ldKwT+62Y3uDEfj1OFzpx
XhTQPzr1+ouP0CENqN9BemoD5iGXXtOA/bGPPtyAePfQ5+HOLPp+A+Y5k57Y
qN21nf4Q3riNzn14/Qva24j7f0b3wJ0p9LgmHc9Hn9CJTXj/WE/vbcL5t5Z2
NaHeyfTtJpwHq+hIF55HK+llLtQvkd7pQn2X0w4X5m8pfdOF82QJPdyNeYin
F7uxXxfQ293Idy5tc6Pes+nrbsQ7kzY14/yIpRc0Y39Mo7c2I54pdEUz5mUS
3d6M/Tqefq4F9R1Hqxb0fwy9pQXrjaJLW5D/CPrnFpxv4XSooYI/M0z0SAP5
DaanGzivB9HvGaj3M/Q6A/ttAL3DQPz96AID+6Hv1iPbDdTrAR0wMN//0DcM
vM/00H0G3p/u0EM9uF83HePB/W7RcR7Ed4NO9iC+6/Q2D87Xq3SeB/leoc94
sL/a6LMePM8u0b97UL+f6F7EkxqgX/DifDpPT/Di/Gil53nxPuShk7zor5tO
9SKfRjrbi3wcdLkX82KnDS/6V0X/gu+3V9J38X2zhX7Wh/VL6Sgf1i+izT7s
v2P0Ch/el/PpTT7kf5je7UP+B+hiH+Yxm2704fz+hr7kw3zsort9OB++pvv7
8fzKoCP8OI/T6Rl+xLuVTvAj3lR6vR/92kxn+vE++Cl91I/zawNd68fzYS19
AetFrKY7sV7aKvpfrNe2kg5vRX6J9JRW5Lecjm9Ffgn06lb0Ywmd3op+xAX9
Hy+WYo0=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1n1MlVUcB3ByaoXMl2RJtkgnc0SaKEtxhTu+JEKYwJraYm6SMs0/IDea
KUtlsshZoKHJi8g7F5TrvdwL3AsXeO4Lyhy0LEozneCKaWg5BuastHu+d9+f
0w3vPnue+zzn9zvfc86dm56Zun1CUFDQdf+f/uS/tALP+MqRhSsDSlD3I9Om
PfEH6nJ1VpzYSFfrhvYWPbm+U2VkZAyLVabKG0mJXSX371apjvA88WC2ejVv
5JI46DN1J8URvpqek6P8t+8Sq/0qJibGJo4+qPTHGnl+rurv60sSJx/SzysX
D+ap4MvV98RZX6h9oeb4d+T9X+J+ceFhPH+tjOeI8o5HpoktX6nX/A0TqwLl
b19kPL2jEP0RRx/V9U9aRz84qvxfzxYbx3S9I+L8b5R/eFsTpJ4i9Ulc8GVx
2HHdv5REqe+4rr9PbDqB+t6Ver/FeMWxJzGfSVJ/Mfor7i1WQ3tD31gv/ShB
f8SbS5GP96Q/ZcocP7RXfKsMeRBbTmE8G+g95cpfTrVYndb9GBdPrNDjXZUs
/axAfsR9FXr8neLoSvRPXFSJ8aVIvysxP+K0Kl1vjNioQr3iiGpVUlz8kji/
GuOT59+pRj/FyTWoX2yv0fXNE4fVYrxSXw4cJx6s1e83S7/W1KmarLhgsakO
8y39D6lHP2S+surRT5nfgXrMp+Qh1qTrN0l+yky6PwWSt6AG5E3yuq0B61Hy
3duAfMn6WdD49PosbFRP7R9jjXq9ZSnJyxnkdwXtOoN+x0l+zuL+t+hDZ1HP
csnTWfR7GZ3UhP3jTclXE8YXQ4eaUf9iyZsZ/VpEXzMjjwslf+cw/ii65hzW
b6Tk0YJ+zKeXWnQ+iudJPi1Y33PpEgv6GS55tWB+X6YfWZDXMMmvFc9/kU63
YnwzJc9W7Bcz6PNWvb4ypku+rdj/ptFRzcjfVMl7M/a/EPrrZoxniuS/Gftb
MD3arPP88DlZDzbk5Vl6o033J3SyrA+bzuvhiXS7Df2cIOvFhvE9Q4fb0b/H
f3D92DGf/9G5dqU//qXtdtTzkB62Y/0+oMNacN7cpxNbcH2MzmlBf0dpcwvq
+4sebEF+7tIvtKLeEXpNK8Z/m/60Fd8fpk2t2B9/o6+24v036ZA25PcGvaIN
83udzgpcv0pXtWF9XKEH2tCvn+jJDvT3BzrWgfF9T3/swP39dJlD53HoIv2d
A/3opYOcen1u6qGXOLFePPQ2J/LSTZ9wYr5cdK8TeXbSD52YvzZ6QTv2Yzu9
pR37q5UubMd4zLQn4DP0WOB+Ez2/A8+rpTd34H1V9OEO5L2cdnVg/yml/+zA
fnySnuNCv47TqS6st2P0IRf23wK61YU8HqFv4f7xfHp2J+Yzj07qRJ5y6c87
0e/9tKUT9eXQNzv1ery2hw7twviy6bVd+P5uek8X+pFJN3bh/bvoa104n3bQ
U7txHm6nVTfet5Xe3Y3530LXdCPPH9I/B+7fRE80dP8PvE+/YqA/KfRSQ+f9
wnp6g4HzI5HeYeC8i6cPGjivVtMlBn4PKNpm4P1v030G5ms5/XvgeUvpRwbW
5xJ6lhv1LKKj3Rjf63SCG/2NpNPd+D0TQe9z431z6SI39v9wusmN+Z5Nn3dj
fmfRN9w432bSD9yYj+n0DA/OrxA6yoP97Xl6tQf5nUSnedCfCXQ27Hl0m/u9
B/vNP3Q9fOFv2ghcH6N/CVy/R48Gnn+XnuLF82/TEV78nhmm47x6vI6b9EYv
+n2DzvRiP/mVzvei/it0pRfzNUC3e9G/S/SPXvS3n77jRf8v0pN8yPt5OtyH
/cBDL/Ph/Oymk33YHzronT7spw4614d+2+lSH/ZnK233YbxNdL8P67GRHvYp
//8H6ujHgfFU0WE9OH9P04t7cB6V0ok9mP+T9Ec9WB9FdE4PzuOjfv8PvWZt
PA==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlg1MlWUUx8l52ySWfbBhudDMnDhtGA2pRB8/8gMpgRKlbqaIBLkCLQgR
CxwsciaaaIFk8iUXRLxwL3C9fL33vRe1DVtNF6usxKXDYOVMzdlG3edP/+OS
Ddhv732fc87//M+5z+PJGQkbxwQEBPzk/9X/+bNsILc0b2jWglFarrw3pp+/
w0mqJjM6cDvZSFYl5o3pwgHpaiA3+ClhlaGG412hdz6/RTUtHbgt513IUv3V
mV13zt+qXKFFm4Qn56kEV6hFWH2ouWgbObxAf34oV87foc+LFo4rVNYSM2ur
xCtS5WVlZTnkzI9UdGB/9fsS/2M8zybv2anzzc2SfHapbcFNS98j2z9Bfu9K
fiVaD9tmctoe5JMp+e5VYf6E3iHf2quKhuKj3pb8P9V6HdpELt6n87+RLvWU
4rw08oT9yv83P1Xq268iIiIcKWTbAeVPdyBZ6v0M+a4nR32u63/iDam/TOe3
8HXy6TLdf+troke58suVmURec1DdnG4tWS36VOh6XKvIgxXo98ui1xd4P4Gc
cwh6xot+X0KfOPLYw+ivcNph9EM+33cYesh54ZXwm8QrrdT5jX9F9B5lyc9a
BU4U/at0/x+ReqZWw99rpB/VWt8IqX+4Gvm/Kv2pUZujA1eLXs4a+Nkq/apF
v0TfvFql522t9K8W/pF+LD4CPddJP4+oM319fdK/oLq7+lun9b26gXyuTscL
2Cj9tqFe8UuFTZ8XKxxQD/3EPyn18J/EO12P+JLfzAbkK/XsadD7YafUf73h
Lr8c1fmuF307j0Iv6cfkRjXJX7D0r7AR/pN+DzZinleSY49hXl8Ufx1DfivI
wU1a3+AY8VsT+rGMfL5Jx+9fIv47jnxeINccV6mpqZcXiR/t8PtCcqQd+i0Q
f9qhnyKX2zFv88WvdvRjHnkE542PFv82w19zycnNyPd58TOeO54jn2zG+8K3
muGvZ8kzWhBP2NoCv0WRd7dg/wgbLZi3OeRrLYgnPNWB/Suc6EB+wsUO9FfY
fRcPO+AH4VAn9BSOc+L7QHiHE/4Tdjr/n+9lJ/wmPKEV/RKOaUV/pP68VuwX
4SbwQtHvQque51PCD7XBf6L/4jbkI5zdBv9Jv2xt2AfSzx/asP+Eg9oxz9L/
ee3YZ+KPzHa8L/6pasc+En+da8d8C9/rgr7CUS70T+K95YLeUk+FC/lEkr92
wS8RMv8n4Jdw8tMn0O+Zsg/AljDygdHnT8p+GH0+hXwb5+WHyr5w4/yJ5LVu
1B8i+8ON+h4mm2746wHZJ27suyDytA70Z5zslw69P761kHd2QM8xsm864K+R
3/7j3ztwX/mbPLkT94G/yAmd2B/XyYWdqPcqua0TfhgmD3Zq/6VeIT/ahXwu
kWO74LeL5A+6MF8/k+1d2B8/ki92wd/95OBuxDtLXtKN/n9DzunG/usjN3Rj
Xr4in+/G/aKXfH8P7nMmWfXAL93kLT24/7nJNT3Iv538XQ/2v4M81sA+spMf
M7CvG8mRBs6zkVcaOK+WnGbgvEpygYH8DpHLDeRXTnYY0PcAuc9AvfvIlwzM
Zwl5xID/dpFDPNCvmBzuwX4oJC/34H5UQE72oP/byds82DdbyaUe+C2bfMyD
eraQT+J9Swb5F7yfuol8C++fepP8oIn4KeQZJuKvIy8yMQ9WstWEnknkLBP9
XkXebWL+48l1JubnJbJhYj/FkL834f+l5Gsm9F9Evs8Lv80nT/XivjSXHO1F
vlHkRC/yfYac4cX9bTa52It+zSJXerEPwshuxIudRj6LeLYp5GHEs0wiW3yo
byI51If6QshzfPBrMDnON7pvyOk++CGIvMOH+RxHPuiDvy1kpw963EM+44Me
I1f4feXT/su/Tf7Hh/vHTfKEXuyjP8mzezH/f5BjeqHfEHlDL/w+SM7rxffp
r37+F2zUX8M=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1HUYx5nL1rTlcrSoFllZIyuH0dS1UR9/pIA2kT9It6slkoFUIIUp
ogLBJDIQQxNEBQ4BEc6DO47jjoPvfTmstrPVbLqcLmxlTpgrp43ZRt3n/e15
M7qNsdc+P5/3836ez/fJjNy0d2dERUVdifzp//KbddH+R9/Yi8ssSlZXC6MX
TvFGleaNLfcIGxkqgmO9HM/WnENWucqx+updN+fnq/H13uPk0QK1LXHWm+So
nXo8ljyvSNmqzTsu7rdXRUc2JMeX6PUXyUbp9PHUsunrR8tVfV3dI9w/b596
zla9fOr8z/T8AvKBSpWQkOCaus9+pfUhO7+APlPxVk+PP+sA4iXH16iL9rwA
eaJG7Yp2fE02DqrIddvJFV+q4TtxNnJqrXqifOwHnh9zSOl/U3oeQj56hNsP
63jruhnvV6olL3GWU3jpEb3fegfjr9Px5XUKf1MHPTqoR73aEvm1C284Cv1a
qU+DSooI0iJ8vQH5aaJex/R47QnhHcfVuXB47THqdwJ+qRe+pxF6HKGejfDL
YeFwI+Kvpb5NmF8jXNuE/aupdxP8sF/Y1oz8VFL/Zp2P1RXC8+3IdznzYcf8
T4XH7di/hPlpwX32Crtb4J8i5usk/FEoXHRSReR5egfzdxL+LRBe2YrzPmI+
W/X4pm3C97dhfS7z24b8vy/8YxvO38p8t+v7FWcJN7SjHt5j/k9hP45nnoK/
s+mHU3q/BO73Qgc4h/6wmOfftvgD+uW0zk/ch8IDp1HvvP+8TvVXnG1OnnBZ
J/RkvNc7tf+ukdd2af3D+fRXl76vg3pFO7TfKz+m3xzQj/pediC+7fTfGfiP
3HIG9foJ/eiEfszXYqeKlM/SnfSnE/cj1zvhd+Y77IQeu4Qnnahncnw36ot+
yeiG/8i13ajH3cJnrXHyhLV+j/CCHuxPtvXgfPqzqgf6kI0e3W8uk2/1ID/F
rAcX6o+c7sJ6coUL+pN9Lt0fTPL4/zjWjf5ETnXD/zy/1I16Znxui6nnNTf0
YH5iehEf853Si3qgn4p6cR796OhF/6KfR635W4TnerQfqzezHj3wyzvC2z3w
n4316YH+G4UveRRkYr32wQ9pwq/2oR7WsX77tJ+8a4Sb+9CPkljPfeinK4Xv
9eL85axvL+p9hfBWL+Ll/AYv3u/Xhb/zQr9VrP9+3H+18Ev9eH94fmY/3otk
4cP90C+F/aEf+vD+d/vx3qxlv/DhvuS3fajHN9g/fOh3ZNOH+iLf9qE/cP2z
fozz/A1+1APvX+lHPIx3wI96pl43/XgPXmP/GYDfE4XTBvT8xFfYjwbQ75cI
ewZQDy+zP1m8SPjRAPRayH4VgF7PC+8JwK9x7F8B9ONnhH8JwD9PsZ8Noj5j
hVcNwi+Psb8Nwq8xwh2D0Pch9rtBnDdX+IEh7D+H/W8I3yOzhfOHUN/3sR8O
If6ZwheGkI8Z7I8G1k/e+I8fN+C3v4UXG8jXhPA6A/m6LZxlIP9/CpcY0O+m
cL2B/nxD2GWgH/wuHLbm/yr8m4H8jgpPGqiHK8IPB5HfS8LxQeh7QTg5qM8r
PC+cEUR+vhfeFUS9hYVrg9DnW+GuIN6DEeGz1n6m8M9BfC8NCU8E9ftr9ws/
aEIvr/ACE/q6hVeY8Fu3sM3EeV3CBSa+5zqEq0zo1yrcZiI/dmHDRD4bhX8y
oVeD8C0T9VEnPHsY9z0kPH8Y/eygcCK4vUo4fRj94XPhXLBjn3CFNV4m3GSN
Fwv7rPHdwuet/XcKj1vnbxeeGcL98oVjQ9b3hvCSEOLLEU4NIR9Zwtkh+D9T
uDSk9Zq5SfhoCPl8S9gdgp83Cp8Lof+kC18LwV9pwv+E4Nd1wjEjeB/XCC8a
Qf6ThFNGEO9K4c0j8OMy4aIR3Dcxwv8CFnZ7Wg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1GUcx5nT1rTpbGyam0TTGlk5ys3cGu0pLdK5Eluo7eYmFsNcg1g6
RVQkmUQFWucL+BKvciIeB3ccd8cB/3sBtcAymy6nS2oxp9acpSPXMv7f6/vl
NsY+e/7P8/xevr/v//9ETv7K9yckJSVdHfuz//NXU11dPXjzuVcStNQ0FmRM
HhKvMY6q6CaxlWNid9OujK9vME87ql49Rzb5JmPypQaxVWjsf9+Rr20yye7M
deKkreZSQ0GPOLXYjMXz2Pc6b6dxZw4XidN34X6xVYr7z5NX7DbDRclu8bUy
nPcDuWCPuZfmqBInfWpWBlImXSDvrbDjLRGnfo566HnPF2ZocHD5eHxV5o3h
IqfyzdtrAillN1XP9H3m8bKbWd+SR8Hnzyr+L5HfGXL5V+ajjMmrTisfpxkr
Z8EAeeZ++/7BfuW3H+ti1wHsFxccxPniRYfMtmT3aXFStV3/DJ1/phrxiffW
YL/iWX3YLBj7Kd7UI/b6ffH1Izhf+XmOmltZgWPfkLccQ7yqh/nafj5T9ZpY
a/dnmvSVV2v3NyoerEV+qnd6nRkrb0DsrMPz4tE6ux8bxY566HNcz/Xot+6f
2wC9KL7yBuhF+dxqsOO/Pd6fRuhP9fI12vur4+pXkz0/d6Pk4ibEH1H/mhBv
H3nJcfSjV/08jvUw+ZFm7O9Wf5tR/yD5x2a7P96A+u1C/7rIR1zQo1/9P4H7
OsnvnUB/fdJDYt1LfrbFnj9Hh/TRYs9PWTv5rxb0wyO9nDSQATl8Eve3ST+t
mFc3eXerPU/J4uutOP8UefkpnCf2gEtaycluzLN4ixv9O0m+4rb1mCI2bbi/
hdzYhn6KJ3owDyfICz3wL3GeB3pwkWs8qLd40IN4xP+Cy5ql33asi3Pasf+4
9NxucnNzR5rIA+3wH/FouxmTl6uRPK8DemmQ3jvgF7Xkyg7kc1T6T6zXkO8k
9h/UPHhRHyc52wu/26f58GKeK8khL/r7mebFCz2Vk1N89nnzyzQ/PsRfSi71
4fxdmiefradF4hEf+i+e2Yl4S8jLOlFfcXEn9ovdnXb/hndq/jqhH/GjfviP
eIkf8ewgb/bjfSB2+ZH/dvJlP+pZrHntgp+IX+7C/G7T/HYh3iJyfRf8aavm
uQvzvIX8UADvl82a7wD85mPyBwHot1DzHkC++eRzAbzPP9T8B6G/jeQXgpiX
PPlBEPOYSz4Adq6XPwSR3zry/SD6uVZ+EYJeHeS1Iczfu/KPEOJdTY6GEM8q
+UnIrndFNvmpbviLeHU39KbnK7rt+s3ReeFu3LeG/Ec33k96PjWMer9DXhlG
fd6WH4WhnyyyH+t335Q/JfYvJ8/qQb7L5Fc9mN9M8o4ezPdr8q8e5LuY/EsP
8jXys14D2ZBf74XeXpK/9dp6urSI3NKLeBfK73rRrwXkqX2IJ13+14d5nE8u
7EP+z8gP+6C/NPLFxP4n5Y8W+j+HPNtCP1Pll5b9fO5s8lsW8psl/7RQvxnk
XRb6myw/tdCv6WSvBf+aKn+1kP8U8m8Wvg8flt8m1ieRZ0Swf4L8NwL/eHDj
f14aQb7/kHMiiO9v8rYI4r9HdkbQjz/Jp3B+1m3yAM5b8Dv55wj85QZ5NIJ6
jpCnR5H/r+R5Udx3jbw4ivfvVbIjas9b2mXypijeRxfJlYnzLpCbo4nvabIV
xft9iPwT1u+fJd9J7B8gT4kh3xh5bgz3W+SMGPwmTM6OQX9Bcn4M33t+cnkM
89RBrouh3m3kUAz1bCVfiCE+F/lW4vkm8qQ4zq8np8Thl8fIL8bhb4fJK+Lo
zyHyhjj04SSXxpHvPvJh7J9WSfbF4XcV5KE49L+HPBKHHj8hP4hjvkrIM/vx
PtlOfr4f38tbycv6Ed9m8vp+6LWQXNyP+uSP8X/7K4kX
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1HUcxm8ta8Nmy7HCNkkXa/ROuRlrO/ezN1/GFtDmS5ElpoHVOC3M
F8owGIgpiEjyKnC8i3hwB3ccB9z970hdUJYkvmCAJhkwVy6auVbd77l9H29j
7LP7vX6/z/P8bmFyWuLGu0wm0+Xgn/4vn7Bh6++TU08vDdEKVVpSMu8Or1Xj
O8Of+U3Ymwy+zu9T1XSCK/JXYZWmWpeN377G8VvV40n5xi/CY+n6+51XOX+H
MocNP3pFeEGGGrZaesa43m61K7x12ahwTCbWu8z19+A8I8LxWWr5+M6ii9wv
W7kis6fOC1ty9PrmYe6/VyUGB/wkXJCn9zt5luf5Sul/Q8K2/RhPVvnqr+ik
+zk/pUDXo5Icc1AtCn7OCd86qAYHBgbI3kK1KfjheXIP6fVn8bzxRSrfmGkk
RxzW8+Mu8H6HVbAcM+TGYt2/Et7f8rWu10uXhGOPoB5kUwnqxfqdKkF9WN+C
UhUs/zh5TRnu/zPrU47+sT/Xy9Efsq1CbTGHrWY/t1di/zv9PQo9jAvfXaW0
Hvl9SpU+XzjXG6hCvXiemGqM532KqpV/JnqE979VrbKnEmLJSTWq1mIOI3tr
oC9ylFWfd5ica0V9uP60Vdc7/Y7eavX+Fp7HUYv7sD4RdVof+Tx/Rp3Wayvv
N1anHsme+oH3f6UeeqM/GuvRf/J9Dag32dKgx39B/ww1QF9cL7YR65HLG+Fv
7m9qgn95vveaoGee/1QT+sX7PtWM87MeBc263kms15/N8D/1uuYY9EJ9e47h
e/pjQQvm009ZLdov9h+ppxbo+4xw3HFdj+jvqa/j6N+gcHgr1vuWegvxaeGR
VvjnJPV3AvnRL1x7AuczqEeb1o/LK7zYBv31Up821NcjXGrT+srrol5t8LNT
+F8b9OKgftuQN23CyW3Q+wnquU3rI6FF+Js21LOJ+m6DPuqFn2jH+a3Uezv8
Tz7QDr3UUP/t6Ge18M126LGKfrCj/0eFV9nRj0r6ww7/VQi77fBfOf1iR56X
CUc64IdS+seBfpQI73GgnkfoJ4fWu7VYeMIBPx+mvzqw/iHhlR3I20L6rQN5
WCDc2oHzH6D/MN+8X3huJ/y7j37sxP57hbd1It9y6M9O5EW28MUQf0m/OuHH
TOElTuhpN/3rRL58JlzjhL520c9O6HOH8D0uzP+U/nah/9uEN7ugv3T63aXz
e/0nwt+5kB8f0/9d6NcW4ee7oA8L86ALeZEmXNyF9+0j5kPo+w+Fb3dBn5uZ
F268HynC69y4z/vMDzf8sFHYcKPeG5gnbvhjvfBj3VjvHeZLN/T3tnBeN/T6
FvMmNH6t8I1u7P8m88eD/OD4RI+e/0ES88gD/XD9Tg/6uY755IG/3xV+uAd+
43njelDPZOHP8b3B+9l6MJ/3v9KD82xinvXCL6zXa73Yn/Xc3gu/pwo398If
5JHQeK4/pw9653lUH+rN+2ztw/vIetT2oR6rhc/1IR/eYD564bd44fle1CuO
eenF+ZYLv+5FHr/K/PTCv0uFM714j5YwT72o34vCdswfWcx8xXzzIuFrmF/5
LPM2tP+Twg/5sH8089cHP0UJr/BBzwuZxz689/OFd/lw/3nMZx/u/6DwcR/6
NZd57YMe5wiP+tDf2cxvH+p/r/ADhkJZmecGzmsSftnAef+ZlHw38F78LZxu
oF8zwgcM+OcP4QYD/r8h7DWQd5PCFwzk14TwTQN+uSo82498GRWO8sNfl4TN
fvTjvPAqP/JtSDjND7+eEc71h95v4Wo/+nda2O1HXvcLn/XjPTSEp/3Iv17h
WQHUr1s4MoDfn07hFwJ47+zC8QH4zyacGkC9W4T3BPB7pFG4LAB/1Ak7AsjX
auHBAPpTITwRwO+pUuH/QuOLhSP6Mb5Q+Ll+jM8XXtmP92Cf8IbQ+BzhjND4
rCD/D/pMm+M=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlwtM1WUYxs9MaSFpGiXVQrrMYctG0ZKt4b7IQh2bSptZo1ZE5aXiaFEI
pMCklGVAockllftFOB44Bzjcz/kfQCropsV0NMGSCojQwjHmsPM9p/dhsqn7
7f//f9/7Pu/zPR/eFxsf/fo8k8n0i+eP/ld+3FPBMQHjq57y0noV7jtQMscv
qOUZYz+QnbHKEZgxNvd8+42s4tUuzwJz7+++cb2hBP38+bnv9yjP48llwkEp
er2dZLVP9ff19d0pHJKm1g0n+ZOd6WplTFbEHcKb9ut6N/tzvwz9fdTtwuaP
VZYxFbyU+x/E/rcJZ2eq8c2OY4tZzyfKs1zYImHrITVQYm73Y31ZylPOIwuF
t2WrUnN45i2sNwf63Sw8naOuBscs9mH9n2H9+cIHPoc+89hPrnrD82MSDjgM
nh2T/g4rf0vkq9eEK4+g/xlh8xe63vBp4bCjur/Aq8KmPGWJHJ75R7g3D/Ve
Fs7O13pV/i28tUB5/k79SzioEPWOCf9RCD3+FLZ+iX5/F048pmI8C/4mrI7D
PxeF55/Q65vI28Cp5L4TqJccUgQ9fhXOLYJfyNNF2n8PcL+YYj1vM9lZrEJD
Q23kB0v0eiPkAyV6nr6XhMdLoB95UynWJ9tL4U9yQNmN/aaUab8a5KEy3U8S
eW051idXlkNPsl8F5s31zRV6v9wR4bMVKtnfcpp6h1VCT86jsBJ+G+X8q6AH
5xdXhXmP0w9V0IPzfrga9dEP2dWY/6Twv9V63ln0z9aTqOeKcNtJzIt+C6qB
vnx/f43u1zJBP9UonU+sJ6oW77N+ay30ZL/+FviF+iRacP7ph0EL6h+m/06p
aEfgggvCpacwr0H60Qq/nRd+wgo/n6M/rdo/oQPC+Vbo+RP9akV9Z4Rnrcif
H+nfOuj9vXBsHebzHf1cp+c93C/cU4c87aO/63S9Cd8IP1QPf3xNv3v5K+FP
6/F+L/1fj7w7LXylHvndw/NgQ73kLTbkWzfPhw3+IrfYtJ4ZXTwvNuhNDrTD
D26eHzvmRU7H80iy3Y7vySN2zIsc0ID5GMIbGlAPn6c0YF5kSwP6IQ81IC/J
SxvRH3ltI/KE/H6jys/Lu4v9VDZi3uTzjchPsl8T8pf6rGnS83WQzeAw6lvc
BL+QzzahPs7Hx4H7ihzmwPnnPHc4cB9y3oUO+Jn8rQN5R3+YmpE/9M9jzdCf
/oprRj7z+yPNOL+sr7dZn89B6j/TjHo7mRctmHer8Mst0MPB/GhBPXZhowV5
Wsc8aUF/tcIrWjH/auZLK/xcLpzZirwqZt60op7jwhOt0LeA+dOGfD0qHN2m
55uXyzxqw345wo1tmPch5lMb+j8ofHc79PuIedWO/tKF97bDP/uYX+04L8nC
F9sx3w+YZx3I1/eEn+2AnmbmWwfy7W3h6g78frKTeYfvB94SXtSJ/d9h/nUi
H+KFd3cij7h+aSfq2SX8cyf8+i7z0Qn/sL57ndA3gXnphH7sZyOeRyQyP53K
83fqHuE0J85HEvPUif2pj82JPPiQ+epE/3uFL+F9M/WddeI+ShVe5kJ+pjF/
XdCX81nvwv3C72NdqIf7J7ugF+vP9b7PfmtdmDf16vGuT70vuJBXO5jfLvjt
TeElBvSNY54bmN8rwk8b8PtLzHcD+faicIKB+W1h3hs4b88JVxjIp43MfwPn
OUr4nIH61vE+MJCHzwgvdMM/Ebwf3NhvjXC4G/U/yfvCDT+sFo53Y16P8/5w
o78Q4SI39F3F+8SN87xS+Iwb/z9YwfvFDX/cL7ygC/os533ThX7uEV4NTgrg
/eN97i+83ft8Ce8j7/NbhQu8z315P2G/KR/h/i747ybeV+DJ66P/8/Uu1H9N
OKAb9/u08KPd+H1nSnhDN/S5LPxaN/SbEE7phr6jHv4PQiuQ4g==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln1M1VUYx2+lVmiaRqmtCKdzxLLQUqnEji/LNFfKH6YbtUnGsNogG2XK
TAnyZSZoaIGk8qK8iHiFy/sFfvdyMbfQMk3TbKGbziZrzsLMSrvn++v7dbLB
3Wfnuec8z/f5nucwKjkt8a07PR7Pz+Ff+8mflZE1X8f3jpvm0mxzNSZpyC1e
ZCJOlqZPJjvJpikq59IkrS81NbPOrhCbNNM7vylK7CwznX0xZyaSezJMbrCv
Quz5yJ6XK47ONGXpCRvE5mNTWFBQII5bY3IuzW8SO1nIRzwv25xdEfmkzu/J
MYnhAHH6WpOSknLhVv7rbX5Jqi9vA/IVR2+08SnSw/uZsR/PKr9ckxAWSJya
Zx4LJ/ic8t1sz+//PPnaZvN4Um5Q7GxBflPI6z43h7u75yaonnxb/8ip5BFb
kb+4Z6utt+YFcsU29Muo3i+s3jHTyPFf2vyOij0FqG86+VCBPb9bnFeI/GeQ
F263+1/WenSR1WO1+GIR+qv9vV/dns/yHSYybBjlb3aal8IFqN5+u1Cv9End
Zf11Xfp374J+6l9cMfz3DDm/2PZj9ATpXYz4p8hJJej3OOlfYsLLfbHkMaXo
R4z6UYr8xpJ7S9Hv0epPmXk6/DOK7CvDeVHq12744RFy5m7UP1L92w19hpNn
7oHeD6qfe+z5+cPIg8rRz/vV33Kcdx/5eLl5LyHitYHqdwX6dQ+5qAL3a4D6
Xwm9+pGXVJpwOm13yA+V2O/mpf/5iSrs9w85rwr39zr5jyrkd428cK+x86WP
7N+Lfv5Ojq6GflrProYfr5IvVqP+P8lz92E/7e/dh/79RY6sQT1/k5fX4D4p
3zM1Nj7jX7LZj/lyg1y2H/Wr3n5ezAMP9ZjkRf7SJ9ULf9xFLvSifunZ7bX7
JfQn3/AiH+kfdwD63k1OPgB/ql/5Lt9LPuhyhPx9AP5Sv2NrrT6zBsnvtXZe
xssfm2oxnwfL/7Xw2xDylVr4UzymDnrIbwvq0O+huh91yF/+bKnD/g/ovtRB
P3GUD9+P1P3xQR/5PcuH88U+H/r1EPmCz553UjyiHn5W/Jx63Cflk1kPP6ie
mnr4R3r11MNv0ntYg7Ef6tfMBvhD/f6gAe+L/FLRAH3k/9MN6K/8OqgR9cvv
Uxtx3mVyeiPuUy+5pBH1/ko+3gi/nScPaLL5rT5Hjgd7fiG/7a7/RC5y138k
H2nCvDxO9jTj/nxHntAM/Q6TlzRjHou3Yf2y+FAz3pMj5OvNeJ+/1bxowbzU
/m+0QM+jmh8t8MP35GAL+nlM88Rl5Tu2FfE/aL60Yr8T5A2tOO+k5k0r3iPV
/1sr3stTmj9+xJ8mJ/pRv/TL9sMv4gY/7ov4ot/mF6H9Hm7D+6F85rbhPVU9
q9pu19vbhvkh/c61wa/faJ61w2+HyC+63KX51o55EyRXteP+dWjetSM/P3lw
B85v0vzrgD/rycs64OdazcMO6LuffALfz6jWfHTg90ryow7O30Oe5OD/sxLy
qw78sZOc6pjw39VF5DWOfc+mF5ALHei9jVyH9eAWcrf7/VzyeQfzZCP5hgO/
riMPD8APOeS4APyQRZ7t8ifk5ICtZ0c2eWUA/dX38wOYf5+S9wVwX9aSDwaQ
r/iXAOa18rkWgL/EQ4PQbz05Ngh9xTOCOE+cFMT7Kc4IYn5qv03gxeLyIOpX
Pk4Q/Vb+p3D+DtV3xT1f9Q/shD+l15hOzJNV5IROzIMV5AWd8OeH5DQ3/n3y
Ojc+jVzsxr9LbulEf1PJx9z4JeReN34xuX8I8a+To0KIX0SeHEL8AvK8EPJJ
JC91418hZ4VQ78vk7W78LLIvhPs9g3zYjTfkCyHclynkm258PHlEF/o9kTy+
C/NnPHlOF/wxjvxmF/wVS87ssvfrnbFh/g8Q1Hll
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxd1gtMlWUcBnDmtBbazbFCK7LpnLpsFJvSBX295KVYAqViMUu8BNoGunSk
lMpkqUvBQhM0FQ8Koh4PVw+HA5wb2ha6VU5m0wWWREFmJo3Z0s770PO0xQbs
t+983/v+b+93nkrPSlk+KCIi4kr41/7nT35PcvzbvROnDWiuiYuLq/nPi0xC
ZPvod2hfuvlzXFqBHJFpnLM7b8smy6wI/yzR59eYJ/N7vpY71pp2R3ZCuu7/
wBQE+irkUbmmpLh4xFI9byPWk2M3mxR3zJBlen6edb6ctMWUZSdELtd6+WZO
5/oiOftju964FVp/mxmfVhCQC7ebKOfsJe9qP59gvQzatQP5kU2BCS+/KpPO
KES+Vmq/u2w+uuT+XaZzfZRzlfb/qbH/dH3rZ+ZcW1ub1k8qMr3J7gPaf/Ru
rKd8dOxGPpXfij023ijVL/tzEw6vL42O34v9vKn4i01ku+NGKv1lMfa/UPko
Qf7n06n7sN4bys9+u9/E1+nu/chnivL1BfIv5xyw9zfJ5iDW0/2DD5lwP7rl
jEOIV+u1HbL5j9N+YkuRvwV0USn6Te4vtf1UrHjSDmO/itd32Na7Ux7jsPuf
vkj1cJjVCZEL5V4H+ktOKjPBvnFpur+2DJ/XetFHbP4e1H5yj6CeiqfjCOql
eGcetfO0Pln1PIp6zaOHleP5r6m+5eiXRPpCuY0/+VXVu8Lmr2cuvb8C9Zyj
+h9DPmbTy45h/mapH45hvmfST1eiX2aoPyrRX9PpW5WIR049jnxOo73HMa9G
/XPCxtM+ld5ywtY/Xu4+gfNhCp14Ev0iu05iHhPoKKfZEC6onONE/l6iLzsR
v2xOYX9y2SnE86L60YXny5NcNv5sOQPX4+QSF+5/Qf3qQj/Ld1yorxxbhXmS
06uQ7+fVz1VYXz5ThfNV7q9CvuUJ1ZivePV7Nc4zeWc1nj9Z/V9t+3m7fLMa
/SqPqcH1SfSCGsxjnOajBvuPpT34fOREzUsN5nE8HVOL/I/V/NSi/0bTebW4
f5TmCdfbHqe7apGPEZqvOvRLNP1KnQn/3STn1qEesrMO+9f9HXXoP3l4PeIZ
qXmsx7zK6+rxPLmiHv3zGP1dPfpbHnYa9ZCnnMY8ytmnUT/Fd/h/1y8MXNd6
97jx/lI88W703yP0ygFHad7ddv8xw+nzbrzPHtL8NyD+++nnGux8OYbqPGhA
/9xH72nAfu7V+dCA+AbTtxtwHg7SeeHBeXG3518v9qD//6YLPbZeEX/RAY/N
79p++pYH89tHj23E+fYHndqIfrhBb2/E/q7T3kbMaw99vRH91E2P8qJ/uugU
L95fP9BbBtxJ13ttfJc76G4v6qHrI5sQz1U6sQn51vM+asLnf6RdTYjnGn21
CfOm/UQ12/Ps7E/0rGbMx890TjPm5xe6shnvO8V7uRnvt176gRb0h/JjWtCv
v9FrWtAPymdZi/2+8sxN+mILzp/f6cE+vI90/xM+zM+v9CQf+k/7mTfweeU/
w4fzUfnY7EP9lM8SH+p3ha7xoX6X6DYf8nmRvuaz+d/0DX3Hh3qdpx/1o95f
0bF+fD85S8/1Y/6CdLof7xMfvcGP88BLF/lxnrrpk37Us44+48f3vSr6ez/6
wUn3+zFflfTDAeTjKD0hgPPYQc8IIP8H6bQA+nMfvTaA9/deemcA+SuiywPo
p0LaF0B9dtCXApi/bfTNAPKdTw8Nwnn0mCDex5vpBFxP3EgvCCIfH9JZQfTf
BnprEOdpDl0aRH7X0Z4g+u99+tsgvg+spnuDyE8WPSSEfL5Hx4Tw+Ux6Mq53
rqCTQpinZXRmCOstofNCON8X0/tCiO8tujaE+FLpcwPX59NdA/en0HdDiH8e
Hd2KeiXSz7ain+bQr7RiHl+ml7bivJtO57ZifqeG/Q9iWWoJ
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1HUYx28m1dBpGiVaopYVkRpKEW1Rv+zFl1gJa6TbzRVqgVYghSky
E4JlrAQLNZCIV3kRzoM74DgO+N//TnINXe/MogJXzA1WzaTIlnW/7/V8HWzs
9tn//s/v+zzP93l+tyQlPWnbNIvF8n3gX3/Kn23NSHbB+PJHg7RO7YwPHcwn
b1J7w2xryEaKOjMwMPAWn6epFwN/ZJWu1o5kh5GNTMTLEx7OUkXmRAPZskf9
EWktIi/OUbUZ8YVk9ebU59G5KhDeRjbyVMFYoitXeEO+0h/7eV6Bfh63Tzjj
bejN4fnvqCRXREG2cHGh1l+ym3reVWWlpaW7hO3v4fnr1FeE9zOFU4tV6GBN
Rgb1HlKLAgJeFZ48pPOPfJn631fWIjOLfOAD1PsV5lOiz5/P98MP6/i/kYcP
6+9/ki7ccETFawHM9yj07RSO+1AFwr9AvZZSdbe1aPVrwqdL9fu3M7/iMtQz
S3jjMf3+CHlxuQqc1sP6XChHvd5gvT5CPVjP3RU4bw/r9zH8wvpPr9T9DyWn
VsIvjDdQqf2XwPOjq3R+IdRfUqXr/Tnzn6yCP1gvazX0Xq1/tQqkc3m78NIa
9CON/ahB/1KFx2vQ/5fYn1roITtrkS85vE77bZScU4f3GW+4Dt/neY8fV4F2
7aCehuNaX/YO4Zn1qC/1Z9QjH/rlq/qp/ohrgN9Yj/IG9J9+sDSq8URXBf2w
tRH9veqHRviB9V7WhPlhv4ubpvbnUpPWP8Z+bzyBeOy35wTyuTpfzfAX389v
Rnyed6EZ/aOehBbkR/32FswH8wuzIV/mv9sG/azXkA3+Yn3VSehjf2pPYn62
0Y929H+LcKxd+2PiefrTrvXv3yxcBrZY6Vc7+rlJ+Iod+zOZ/m2F/meFU1qV
byLSmkg/t2L/PS3c36piYmIcT9HfrYi3VjiqTb8/9AT93ob8VgsfDD5/hP5v
w/sPCV9sQ/wHOQ8O+DVWONmB/MgHHPDT/cJuB/x4H+fFgXqTI5yYlxjOjxN+
WCWc50T9V3KenOh/tPCoE/Hv5Xy14/kK4fXteH85560d8ZcJ29qxX+/h/LVj
f0QJz+3A/RLJeeyA3ruEd3WgfndwPjv0/fbcUuFvO7CPb+O8dsKPS4Qf7sR+
WcT57YT+hcLVnfr8Fbdynjt1vvHka13Yn+Q4F+438nYXziOXu5Af+awL+m/h
/HehXuRVXfAfeWsX+kc+0oV5X8D90IXzyZe70J/53Bdu7acY8mY39lc494cb
8zxP2HQjHvmSG/W6WfjObuyrm7hfunFemHBhN+p/I/dNkOcK/9KNes/h/vFA
zw3CSR7M62zuIw/6MUu4w4N5msn95MHvlRnCC3q0vohQ7qse1Ot64X3gyOu4
v3pwfojw+R7cR9dwn/Vi/0wTfrIX37dwv/Win1fG/uemXr0vZv8jPNSL+v8t
PKsP8f4SVn3Yt38KZ/bhPpoQrg3y78Lf9GGeyNMN1Ie80IC+X4VjDeQzJvxM
kC8Ipxq4r0eFcw348SfhMgPnnxd2GPDHsPCAofTHD8I/G+j3d8JXDPTnnPA8
L/IfFI72ol9fC6/z4v76QjjFq+fN/Ex4L75fcVa4xIvfVwPCLV749VPhfi/q
dVr4Ry/2ab/wZDC+X3iOiXnzCUeZyN8r/JiJ+vUJW034q1c4y9T12N8jfNCE
Po9wvQn/dwsbJu4f8rlgPLfwRRP+IM/woX7kpT7sf3K8D/mRk334/UNO92Ff
8rwDwefkKt9UvW4f+s18vvQhf/K4D/cX8w/xQz/rE+FH/w3hB/yYb9Zzgx/3
ATnNDz8wXp4f9wH1H/NDT6ew04/+OYTPBOPZhUf90Ncs/C84oVE4/BT8Xye8
EpxYLbw++LxCeEvw+THhnFOIfzTA/wEfl4bI
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlg9M1GUYx8mBK6Lsj5tYi6icU6eNohlbo97MaTJa4Jp/6rKJeoNc47RR
KqRIkkjKYaEFkomHcqCeB3fAAQfc/e5AqqNWOZlN19GKXDBXTozZwu793p5v
Qzd1n/1+7/M+z/f5Ps/vHsvJX7lpWkxMzOXIX/2//HEsH95RObboxSitUKWj
2R4rea3akh4/VCHsy1Fms3nkAJ/nqcD4vEv7hVW+GrJZuj/m+1tVvSW9vFw4
XKDmm6xL9vH8dsTbK5xcpExWo+Ajxtul4odsf+4RTtmt7zN9yPglyK9EOGuP
ujHPNIPPw6VT37fsVampqS5yzD5VU109m/Ery/V5Kzl5P+KVCjsPqLFsz1Gy
sup4qcw3txL5kFMOqpWepFLWN3EQ9Zcx/08UshAu+1QNhkIhclaVioSzUb/E
Q/r9YuobPqRmOpavp/72w/p8Jvtj+Uz3I539S/tc9zft//5W6/hPsP8D1dCH
5ytrcJ73rTmi8zeYf3It7mO9V2rVo6Wj31Nf5xfQf7fwtqPo907q9yX6XSQc
e0zXM7yDeh5D/YXCoWP6vJnvp9TpfiR9IFxVh/vJE3VKh+N9puPo9y7qf1wN
75jpIM+xQZ9i9sMGPchjNujFerLq0V+yux79JyeewH30Z9EJVRgpkBw+gXrI
S0+qSLjNZPtJ6EdOaEB+ZEuDru8m7zvfoKzGuJ2cZsf75Fo76mU9MY16PuPJ
GxuRH/UYaEQ+1G9hk55HC/WtbEJ+7Mf1Jh3/SfZrzSkw++k9hXh8nnwa+fL8
ntPwB+NfOT21X5ln4Dfm6zyD/rK+mQ74hfpsc8Cv9OMlB/rD+VZnsa/4fv1Z
1MP4sU7d3zjWv9iJ/cj8c524f7twjRP6vU+/OnV98wqEJ53q5Ygg79K/zeAt
wjnNeD+ffm5Gve8I9zeryL/Fm+lvPA/lCS9owflc+r1F61dtFq4Az95E/7fA
3xuEr7Wg/hzOgwvztV54lQv7+C3Ohwt6rhPudCGfNzkvLnwfTMJJbvj1Dc6P
G/4gl7ixD17nPLkRb63wiBt+Jie2oh9rhDNasV/JRa3w02phR6vWu4ocbtX5
ryY/0Ab9yEvbMB/k99qQ/yrO5238023vJ7RjX5Cfb0c/yZZ27A/y8Xbtn3Pk
8+3wB+uZ7sH8kNM82Hfktz2on/rUeuBv8rfR59Q3pgP6kp/uwD5iPzZ2wP/s
3+EO7A/ywG18swP6khd24vtPXteJfjB+JdjM/I1O1PMa90knvj/ZwnO7MN+v
cL904fucIVzeBf8s477pgv+WCF/tQv0vcP94sX+eE17pRbw07iMv4j0j3OaF
31O4n7zIb5HwQ934fTCf+6ob+s0V3tmNeh/n/upGv5OEf+mG/x7mPuuBfrOE
l/Xo/o8+yP3WAz/dJ9zUg34kcN/1oJ67hO/thX/iuP960f87hLf2Yh4nR2Uf
9uL+m8IXejH/N4RjffD/deFHfNCXzxf7oMffwq9G358QzvVh3zD+bh/m+R/h
Gh/21b/CLp+K/FvM/EI+/F64Jfxb9H7WM+mDX6YJz/JjPmO5f/1T9Vjhhx7T
uY/90ONO4UI/fh9Szyo/9IgXPoPzmdS/3w9/3SP8sx9+mMH97Uf97N/9BvzK
5wsM6M94Lxn4vcn7TdH3mX+BgX3CeisM+In6NBioj/r6DNTPflw04Jdx4Ws4
b/9L+O4Avm9XhecEoP8fwukBfA9/F14VwP76VTg/gHhh4bIA5ueycF0A839R
uBPx118Q/jGg53H8B+GxAOr9TjguiPtCwklB9H9A+Nkg/NEnnBXEPjKE83C+
KiBcEkS/g8JHoszz7ij3Cw9Gz58THgni+8v7bwUxD18JJ/Yhv6+Fn4ryN8IZ
UWY9G/oQb1C4qA/+0Of/A577iIs=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln9M1HUYx6lFW+Yq60q0RJrOkdNGsSVro33KJuFoCW2G22WJaKEtkEYR
UCpxqcw8UEAPEPnNgXAe3B3cHRzcL9I/0M31w9loQStyg1UrcYw/rPu8r+fN
ug3Yi8/3+/k8z/t5P8/nns7Jz9p3b0xMzI+RH/1XPmtNs5nDc5tfjlK6qrdY
LEu8S5UabJfJ/hx1KHXZjaX1PHV1YmKCrPLVXKa7aen5Qv38W+SpIuWON816
+f6nymBL20NOKFORcNwe7ncYz7uFk46qLHd8LNlfrmxp04uDwjsqVCSf6y6e
Z1LtBamVTuGCY8ocnE908PwTarrEYOsXrqpUr0X+YWc8J9X+yMcmbP9KRdJv
62V8ZujTI/x+lQrNJ05aGW81uFN4oRp6tTP+0zi/Vfj4GRX5faSZ+dTo/dOa
hONq9XpMI/OrVcnJyQ6LsLUOep9lvmehT41wyjl1J9FoPs38Lfr95CrhKxat
f0o19ahXzxjNr/D57Aatb+YZ6tMIfbj/rUZ9Xkkt9ToPP9UJFzehvoxPXYA+
54Tva0Z+9dSzGfVqEJ5oRn7MP6lF+8F0XrimBXpQr4UWHd/MBWFjq45nVQv1
b9X1yKD+69ugfxvr0Yb6sF5zbdqv0x2sT7vW8+EuYWc79GP94zp0fsZu4bIO
ZTQHi+iXqQ7Ef1H41U6s01/WTtS/T3h5F/QiF3QhH/rz2y74i+spVvQP92u0
oj48L6Zb62tlfLnd2v81zOdKN+Jnvpt60H/Up6oH/U6/3u5Bvah/9kXox/qN
gJ+lXxN6cT79UdGr+2vdkp96sT/9mNGHfM30F9hyUthgw3ol/WbD+8eEJ22I
z0T/XYKe5PZLmG9f0o927f8g33/BDn2O0592+OeEcL0d/iBP2FE/xnPXDn+R
k/pRD3JOP/xDrumHftzv637Uk+cvRJnxbRxAfzF+4wD6k/mdGtD+mv+C/h/Q
7x8sF/5rAHocYT841I22gtTDwjsd0Psz9ocD86VU2OtAf5awXxyIp1g43qnr
Ef8J+8eJ+VwkXO7Efh+xn8AlhcIzTq1fzCH2lwvzLF94uwv1/ZD95kI/fCBs
c0H/g+w/F/I7IPzooI5nWR77cRD1fE/440HM+/3sz0H9vm+f8A9RzmW/DuH8
vcIvDaFeOezfIfiV3DoE/fawn4fg33eF73dDn3fY327cn+QDbvh3N/vdjf4l
X3OryPX159vsfw/8TH7eA7+Scz3od3KdB/erkfPBg/O5vuhBPjxvkxd+Iu/2
ot/5fpUX9yk56EW/kW97oRd5wzD8w/Oyh/9/fuUw9iePDMMvPP/3YfQDOWEE
+ZCzRpA/9awAXyYP4vlM1uPWCO4X8mof/MX6Zfgwz1jfz304j2z3Yf7THz/7
cN/SP4ZR6E9/bRuFn8jFo/AH/dgzivuDfp0cxTzh8w+NYX+er8Ywv5hfYZSp
d/sY9Ngl/P0Y+mUn56Mf8/xN4TV+1GcH56Uf8b8u/IYf9Uzn/PQjn23CR7Gf
bSvnKd43KWGHH35O5XyNnv+i8K9+1HsL5210/2ThlQH4PYnzN4D9NgunBxD/
Rs7jAPp/g3Ap1pvWcT4H0K8Jwn0BfB9Yw3kdgH9WCf8UwDx7gvM7gPgfE14R
xPeXFZznQejH9a1B+M/A+R5EPI8LFwURL/c/hfX4OOGuIOJlPH7sb1otfDMI
/Z/kfRCEfk8JPxhCPzO/9VGOF04Nwe9reV+E4Efulx+CHit5f4QwL5hPS0jP
p4JHeJ+EMA+WC38TwvfzB3i/hNDPscKxYczfe3jfhFGPu7P/8ZYw5sWi8I4w
9L4jnBeG3n8Ll4eh1x/CDWHMl1lhZxjz+Dfhq2H0zy/CM2HUZ0r4nzDm76Rw
3Dj68abwc+Pw53fC28cxX64L7x1HP18TLhvH/af5X6LahH8=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdl31M1VUYx1nT/iBns1iRTcRsjlw2rGX8Ee2ULrJYIX+YbrcX8SXQCqRw
hCyTpIxlQKHJiwjcC1zeLhfuBe77O0oFlmmSRgvacm6y1lo25h/VPd/fnm+7
3s3LPjvnPOd5vs/Lua4qKM7ffVtSUtLP8X/6r3z2Zye/HJ1f97RBm9X8Fldr
hLxd6W9yqEDZcuYqwlwvUn9nmO4kq2I1bS7xh7i/VOW70qrJs2UqxZazg5z0
ntL3k9Mr1Z74h6wOJZ7PPHyL/SplKclO5v15R3CePFut7U+TSz7Gff/H94mK
m79OrqvR9mqoR/qnqvr6lqyYsP2YMtVGbpBVLfwZFy6s03rUnqG/9So5vuGs
8EI97p+g/5+rg3FBvhI++oV6yFT7zNeMpwH8jXDqcTU1OZk7yfiOq+iNDNOU
sPUE7jvHeL9EPN8KZ51UcTnM3zH+Rm0/cl54olHrd/V76tGk9V98UXhbs4qH
n/ED9WmB/5eEr7Ugv9PU6xT8+VG4vBV8mfqdhv9XhBe1af9W/0Q927T+LvJk
G/QnZ7Ynrje0a/t/0N5Cu2pqbGzkfaYOfd8M/Qt1oD4Yz4Nm6HOB+TAjX9Rn
3oz7qW+eBflmPpwW+M/8pXaiPpj/yk7Ey3qZ7YS+rLdNXVrPs6xva5fW2xoQ
XtKNdR/zC87xCl802MN8W3U+5tzCLVbcx/WkHvhP3tWDeGlvogf2eN/DvVj3
sz56kU/691cv9A6yXvoS4/H1Kf2H/Zbej/jYn0f6tV7ZPH+tH/nh/bkDWv8y
+msf0Pfd5xJOsen+mBxhvdkwPxzCM1jPHWL9DSJfg8KWQcyTAdajHXr1CW+w
6/mY1sP6tKuV8QLsFm6yq7mKFFsn69WO+WER/seO+ulg/Q6B24ULhhA/uWEI
+rUJnxmCvuSFIehHXjuMeUY2DSNftPfZMPqbHBpWz81VNNCfP4cRj5n94EC8
9H+rA/6SjzqQH8brcaDeu9gvDvhHfdKc8N/K/nEiP9Szyon89rKfnJgn1P+q
E/nrZ3+NQF/m6/kR+Gtjv43o9+om2Yb1VuZ79pbzd42ifujPplHox3gOjGJ+
UC8r2HRa+Iqx3sx+HcP6SeGnxqBXA/t3DHrXC3eM4f5j7Ocx9F+N8O0u6PsR
+9ulHot/PhTe64Leh9jvLvRHpfA5F/q9nP3vVvq7TPhRN/p5P+eBG/PjLeET
bui/l/PBDX/2CN90433YyXnhQb5fE37Vg/lKrvMg368LRzywv4PzxAN7BcJr
vPi9QfvbvMgvucaL+t/FeeNFve8W/t2LeOhvug/rbwjn+3C+kPPIB/tFwqM+
3L+P88mH+fGm8HI/3mvqletH/b4t/L4f9V7M+eXHvCgR/tWv6+E89U8JoP+5
/mwA/Uf75QHdvyn0pzcAvej/TAD1RV4aRL0wHhVEfTCfpUHMO9qzBHEf+VIQ
+jDeRaHE+lgRQv0z3g0h1DvjfclgxlMYSoz3sMGlnKcGvyPsCKE/3uV8DeH3
C+v3t5COz3GA8zaE+uL5e8M4T38yw4n52xzG71vqVRDG/ayng2Hoy/psCKv4
9wevCA+EEd92zmtj/1bhX4z9+Zzfxv4XhZdFdD088gLneQT7c4Q3RrB/I+d7
BPaVcJmx/0nO+wj8zxLuNvY/zvkfQbzrhS8b+9fxPYhAn7XCd0Sxfw3fhyj0
fEA42+CVfC+iqO904eIo8rGK70cU/vB8exTzhOyJol5XC1+IIj7yPM5byYtj
mO/ktBj+P0B+IoZ+pv28GOY7uQjrFfSvKqbrfR/9b45BD8bnjOH+FcJThv37
+V5hPWO58L8Gp/L9GsfvjXuE14+j3+/mezaO+5cJ7xxHPy7l+2asL4nzfx6s
kx4=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlWts02UUxhsz/DCJRtNEMHFqRDOJmukS3JeaV12cF6JsKhett4nNRCMT
HeKGOJAZJGbT2BA3EdZ1Y93Yut4v6739d6J2RAM6JTM4ohNZQ4hxZuGD2vdp
zpPIB+h+ef/vOec9l+fc1Ly16eXLTCZTsPRP/56rsN/i2XRYlf40XSjecZ/+
NVX0q77e3pXnhVv6laVy5uaicKFff995TrjGoW7oWmj8Q9juULW1tf6zwksO
9dBcu51sHVC5xepZcnpAmd0NL/L+KqdqilQto/19TjXXbnaTi04142y1LAiv
G9TxOcmBQX2eIK8YUtaebBt555AqhRuhvV+G9Ht76b/+iIpUdb36u7DriI5v
7lfh5cN47xnh1mHVYXZ/eVr45DDi+1m4zoV8nBI+6FI92cXqH4VNI6rYGDn0
vfDmEeT/hPCxEeTvW+HbR9Xf1darjgt/DO75Rviv8vlXwhuP4v6UcPyo9ldl
CN84pvNRlxPeO6ZK6Wzl+dkx5D8vvHZc2Wy2edrzjMPeMWGzW71hqdxA/zvc
arDVsv9r4Vk38sF41YS6rVSggvDgBPxNsx89yDffu8aDepNbPLhP7sP335EL
l/A/HjVdKBTINV7Uj9zs/b89uxfxkqe8un4u8pIX+SWv9qnS/51kqw/9Te72
afv3k9M+1Jv8p0/33wLfv8oP/+T1ftSHvM+PfiJP+vFe5rPoR/+TqwK6HpXk
dQG8l/XbE0C8rHcgoErtfzEjPB9AvyU5X0HoQ0z4kSDmK8x5C+p8rw0Iu4M6
X2Yv5y+I+fIIXxNC/XleH9L+233C20Ow5+d8hmCP9k+FdP/NkJeHUZ+g8L1h
3A9xfsO6XibGOxBGfckny99HhC+P6P63kesi6Cfa2xJBPujvYAT1YrzHI7DP
95miiHdC+O6ortfiOPUgCj0cEz4QRf1GqQ9RxO8SvhhF/wxRLybR307h5yah
dw7qx6TWY+th4SzOV35BPSnf7xO+NQZ9/Iz6EkN8B4T3x2D/U+pNDPrwifD5
8nk39ScOvfpIuCmOen9IPYpjX3wgHIpDr/ZSn+LQl93C1yXQ/7uoVwn0x07h
XThvfIf6lcD97cJnEpiHN6lnSdST/GAS99+iviVxv014NIn7tDebRH52CF+Z
0vlsoH+Vwjy1C29LoR86qIcp+H9X+IcU5pnvq0ijPu8JX59GvpmPNWl8v0f4
8TT69X3qZxr60SW8O439Se5Lox94359GP9N/oeyf8f9W9v829RZ8iHxtBvVl
PmoymC/m4+EM+pv2mjPQA3IH+E7mx57R+e0ij2cwX+SpDOaffDqD/UxeymCf
0P7VWdSP8azOwh7jfSCL/cb3WMEzrH9bFvGxP7qzyNc24eEs4mml/uN79+vC
P2Whn69xH5R5i/AVOXAL90OZbcKWHOq3mfsih/o0C2/NYZ5e4P7IoT+fF3bg
vuVZ7pMc+vMZ4RM5pX+e5n4pn28UXmagvzdw3xjor/XC9xiw/xT3j6HtdT4p
/Iqh83XhCe4jA3pB/tyA/pADl/C0gfyS5w3Uh/yvgX1DXpHHPDQK35VHPz3G
fZZHPz8q/FIe/dDA/ZbX+7m2vsT/Ab9k1K4=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlmtoW2UYx4M4P1RRlIAiWisOqUNFHei+VF4vWB0FXcGuQhB3cehE1oqT
0cqoY9FatKlYp+1Ecb2lWZvlnpP7yTknbdVMnZurc9WtXkqlRausMvZBzfsP
zx8aaNMf7znP+3/uvXX7nubnL3O5XP7Kj/4+WzfdftNfw6ryp2tl+a6H9Lfr
hhHVbNSu+1P49REVbJzvWBY+P6JqZodWfhd+dFTNd7jvXhT2j6rBgYGBBeGr
xpRR6136VbhtTG2sfH4RPjWm7++aF97kV+0NNbPnhD/2K+/Slk0/CbvG9X3B
OeGd42p2qK3hrPDMuLJX6+fOCN8ZgJ7vhfsCWs9Ls8IXAvp5z2nh1qPKHWzc
9p1w9ij0nRKum9D6oyeFD04gXuTFCbWr8vlWuGlS25s/IRya1PFrI7uD6vGK
Q+R9QXW8XC5/IzwXVMtbjE/I6pj6p97jIw8fgx7y5SFVCd9ttHd/CPkiv1Bl
6hsMqeG2hhr6Vw4hP/T/39Da+NwT1s/3MH7bwzo/BuPbH9b+LzD+U2H4x/xc
DCNfzN+GCOL1o7AnAv+Y794I8s16MCPqFu/SifPCf0d0flzk9VFtP0f7LVHl
8Vl7qac7qnzWaj39SUdhj/FYjqLevxaujSGeZeGnYtqf/i+FD4Dd5FhM14P3
C+GFGOr/c/ZXXN3h8T1M3hxHPGfYb3HV6Q5OTwsH41r/6hT7L67jcw35uoSu
j9oS+7HKjvBrCTxvsz8TyH9R+IeE1mOZ7Nck9BeEH0yi//Ls3yT6Kyt8JIl6
zrCfwSsp4SsM1IPB/jYQX57vNlB/afa7gfyTv6qe074rpfPdRb4vhfiSd6Z0
/zRR36GUzt8QeSYFfeRLKfiX47xIwx/ys2n0H7kvjXiRrTTiQb6Qhr/k2zPQ
R27NYB6QezLINzmbgV7yHxnUL7kuu1Zvcxb26c/BLOJHTmRR7+RFvG8wXjfm
0O/kphzuZ/z35zDfyKGcns9bmb+fc5ivzK87j35KCj+WR/0mON/y0B8XDuTR
T2HOuzzyMyl8dUHHpzHA+VeAvlHhVwq6ni4d4TwsQN+nwqcLmB+HOR9N1NNH
wjebmPf9nJcm4tMn/KSJ/n6X89PE/nhb+A3Y63mT8xTnS28JR03UI58vm9DT
I/xb1f47nLcm+oP3XV9EPfVy/hZhj/qeKELve5zHRcyr94U7i4gv/esv4v4P
hCer7/N8qoh48v1z4A7yxSLmN/laay1vsFTldxf5EQv5JHss1Cfv22shX9TT
a6E+DgmPWajPDzn/LcxP5u+MhfwNcB9U7x8UvtJGvfB8vY3nab/BRj1QX4uN
feoT3mNDH/PTbaOeu4U/sxFfL/cJ3t94QPikjX2+n/vFxr7rFF7naL2ufdw3
DvrpVeEHHPx/1c7942D+vCz8ogN9u7mPHNTfLuHDDvK3g/vJwT54Tvi4o+eD
38N95aC+nhH+z0H/tXB/lWDvaeF7S9DP880l6CPvKMGfrdxvJfRLa4X/B09c
j0k=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ3buyW2/X140OQCbDhze6jiCa4cdGh8NfNe68h/G1
NjloxvQfegPjx2xymDVz5syXMH7fJgeu64sLnsH4BzY5tL4OtHgM438Cy394
COOrbHZYUmDLBZcP2+zwJnCH3BMYv2OzgzEQPIXxd20G2e8EN//NZoezZ874
PIfx5bY4yAMtfAHjB0D4cPc1QfivYPwtWxyqRda5v4bxn20BuxfuP4mtDrZc
15XfwvheW8HufQfj12x1SEtLewbnr9vqAPT+XlB4zVka23lr71Z4eAIAkh6A
Yg==
       "]], LineBox[CompressedData["
1:eJxd019oUlEcB3CJejEoAqE/kBX1YEWjCKoX4ZdBqxgsfYgefDKSoodZsRha
USNhCCWEVLparRkbq2zhGpJXvffca3uYCyrYGixqUWOg1AgWvfTnnl98D5Qg
+uHee8739/uduyHUFji+yOFwBOyv/I2G3m792Vok+69jvrFtr/x1HC1SwR0/
9RVOFCnmyo3WYa1ISbHgmYO/FClgP/AJXq9ROBye/QAHNNocTPrewVc0avgL
PVPwiMb7T8BzGpkLnuBreE2J4nV/4SXcUqIDM1HXGHyxRM7JvsgoPFSi8Vqt
ZsIfS5xXh11lzqvB+8vkyjXPFOCOMn33BJePwINlmdf9DJ4uUyadXj0ML6tQ
NuJ15mGqyP7Vn8JnKrJ+MQRn+f7EE3iCr/ty8GKd7NsXHsFrdblf+iG8S6ed
9mcQbtV5/QH4hC7rb+mHL7NrD+AM3+/LwnleL38frunkdU5u7IU/67Lfqbvw
L53n1QOvNGTe9tvwdkPOYz4DHzTIbm80DYcM7t8tOGbQunj91Q04ZfD6yo95
vchN+IUhz8e0ev69wfWq/X4YfF664RWC538H3iK4HpV/n+D97sFBIc9vWNXf
Lrh/qj/XBNnHr0n1r1/weVL91QW/L33wlOD61frfhMy3R+VZavK8Vd5N5r95
vSbXr/IeMXneah5tJp9PlbfL5P1U3t7/rj83uT9qvTemzNus5tcwuV41ryUW
91f1323x/il4t8X1XIcPW7I/uSR80uL9r8Kdlny/kgm42+L+d8HDFtcbh8ct
fj874VlLnhf/Jfj33zwX4FVVzhODd1Q5Twd8qMr9PQcfYw+chc/z/U2nbf8B
JSnC1A==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw900tIVFEYB/BLNJuMIrikLZqIWlhQFEKthK+EyghKF61mZTQULQxBiLFF
BUKrZuNmDIRQ81FOD40GwzvncW9CjIEUSmGPoRyqmR4ERriwzvku/zNwufPj
nPs97nfuzo7O9vPrPM9rMZe9X9torq0Bmb/er9q+I/buHQuo1lYY+AlfCajJ
/JzHA1ocvDzzA14KaE8qe9R5U5F6q22F7zAVbbykc1eRUlnVXYOH4v1VeKFI
hWRv9Ru8XtCfxtRm5+2C+nO5bV/hQ/H6F/i0sPFXKvAFQT1+fnYZvi6o3ST4
DPcLKmf8/Z/gyXh/GS4J2mEK/Agvx+vv4bX4+XdwveR+3sIHJJ0oZ/oW4VZp
+7v0Gu6Q/P7m4R7e77+E+ySl0+nKC3hC2nlMzsLPJeWPlzMh/CGOJ+G/0vab
COAtiuufhvcqfh9P4RbFz0/BKWXjrz6Eu5XtNz8B31K2vvQ4PKJ4PiOwUPb9
zd+F33C+xCj8W/H8xuA6zfU579bcv3Oz5vPkfFbbfDmXr5PXB4bhm5o2mAM7
CN/R5JuGnKc1zZVKp9z+V5rn5+qtaZ6vqzcRUrMJ6PInQ+73Hnw45Hnfh8+w
/Tx8MV5/AN+I1x/Btzle7jE8xfl2uXnMhWSO9+gTuBLy9+nm9y/k77MAN0Tc
n5v3wYj0SuPSM/hkxOdxBj4X8bzdebka2flkhfF/0CJ3zw==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF0TtIHFEUBuBBSLNWASFWK0IKI0QUEW0WjlqEiIVaWG0TxYBYaAqbmCIR
FqxcC5tVEETBNBF8hfWZ+xoVGYNRiZEgRogK7goiLCQQ1Lln+W8Ghjsf9zHn
/Le0o7etq8DzvJrwteNI7d/xf92Cwk/vJvu83o7eB0GJTGvdNTwm6OxtUcUV
vCAo25qOXsKBoOm+WOQ3fC4ocjR18wu+E/QmFjk6gZ9IaktHEz/hSkm7QRAc
wy8ln/cD7pBcz3d4QJLOlcUP4VFp/9e3D3+Stp/3e/Bm3l/hU0nxpOoP4D+S
XofPDvxY2Xqat+FyRUmVK9uEGxXnZeC4opJE5puE+5XNZ+ILPKwobLdnHZ5R
3M8qLBT3uwwf8/rMZ/hWcZ6LcKGmZ/FkwwL8VHN983BM8/45uF1zf26+V3N/
bv8Qr+9x509qrn8JXtFUNPvizNVzkP9fGs5qzt/V/8jY/tIrcNRwXmtwraFw
eczl0WL4PjbgbmPP/+jyGzScr4DHDffn8l7k/TkF7+bnNXyR3+/u697QWCqV
8uFinwbCBt39Vvm83rnJp+rw2YI7fZvHK+d3//0AaI4rMg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{10992.088607594727`, 980600.}, {11000., 
       980599.75}}]}}, {}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        GraphicsBox[
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          CircleBox[{0, 0}]},
         ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{621.024701, 
       980241.64}}, {{1035.041169, 980273.11}}, {{1035.041169, 980243.6}}, {{
       1449.057636, 980246.3}}, {{2484.098805, 980253.92}}, {{3105.123506, 
       980303.}}, {{5899.734661, 980383.9}}, {{8383.833466, 980413.}}, {{
       10867.932271, 980451.}}}]}, {}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{722., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 11000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.759427369983618*^9, 3.7594274085540185`*^9, 
  3.759427630634033*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "Reading", " ", "the", " ", "transition", " ", "dipole", " ", "moments"}],
     " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"dipsp", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmjp1.dat\>\"", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dipsm", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmjm1.dat\>\"", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dippi", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmj0.dat\>\"", "]"}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6897592221440983`*^9, 3.6897592413914747`*^9}, {
   3.68975954032098*^9, 3.689759548367297*^9}, {3.689764112346964*^9, 
   3.689764115230762*^9}, 3.689774888878646*^9, 3.6897749367364206`*^9, {
   3.6899640179244328`*^9, 3.689964031089351*^9}, {3.689964066721018*^9, 
   3.6899641013962336`*^9}, {3.69002244193467*^9, 3.6900224435811825`*^9}, {
   3.6907454330874147`*^9, 3.6907454382989826`*^9}, {3.690747682584258*^9, 
   3.6907476899205484`*^9}, {3.6908273080090957`*^9, 3.690827314859447*^9}, {
   3.690830426408503*^9, 3.6908304322346735`*^9}, {3.693600307513239*^9, 
   3.6936003135252028`*^9}, {3.6936010332555923`*^9, 3.6936010656688967`*^9}, 
   3.6936015844264574`*^9, 3.693602565062847*^9, {3.697309662718015*^9, 
   3.6973096734027777`*^9}, {3.6973108096281304`*^9, 
   3.6973108286040792`*^9}, {3.697311240130667*^9, 3.697311252319934*^9}, {
   3.759171303032524*^9, 3.7591713483048463`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Defining", " ", "the", " ", "transition", " ", "dipole", " ", "moments", 
    " ", "for", " ", "parallel", " ", "and", " ", "perpendicular", " ", 
    "polarizations", " ", "of", " ", "the", " ", "magnetic", " ", "and", " ", 
    "microwave", " ", "fields"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dippsp", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dipsp", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dippsm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dipsm", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dipppi", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dippi", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.689861501031513*^9, 3.689861519598536*^9}, {
  3.6898615849604497`*^9, 3.689861655790004*^9}, {3.6898619343171005`*^9, 
  3.689862039326576*^9}, {3.6898620856502132`*^9, 3.6898620917303567`*^9}, {
  3.6898627666458206`*^9, 3.6898627707020783`*^9}, {3.689863069023759*^9, 
  3.689863071424223*^9}, {3.689964108403802*^9, 3.689964115417404*^9}, {
  3.6936010737843122`*^9, 3.693601089437233*^9}, {3.697309679390211*^9, 
  3.6973096962263947`*^9}, {3.6973108471173515`*^9, 3.697310889202569*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{
   "Rescaling", " ", "the", " ", "transition", " ", "dipole", " ", "moment", 
    " ", "so", " ", "as", " ", "to", " ", "make", " ", "its", " ", "small", 
    " ", "values", " ", "easier", " ", "to", " ", "appreciate", " ", "in", 
    " ", "the", " ", "plot"}], " ", "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.689778129989788*^9, 3.6897781934657187`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", "x", "]"}]}], "+", "1"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "==", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "=", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "=", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Log", "[", 
                RowBox[{
                 RowBox[{"dippar", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", "1"}], 
             ")"}]}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"dipper", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", "1"}], 
            ")"}]}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.689773813616861*^9, 3.689773853850999*^9}, {
  3.689777120649235*^9, 3.689777151997178*^9}, {3.6897772145737605`*^9, 
  3.6897772506990986`*^9}, {3.6897773507014713`*^9, 3.6897773635452323`*^9}, {
  3.6897774176814575`*^9, 3.689777481993497*^9}, {3.689777542089142*^9, 
  3.6897775700610666`*^9}, {3.6897781992553186`*^9, 3.6897782603028364`*^9}, {
  3.689778328488655*^9, 3.6897783294853973`*^9}, {3.6898621077171373`*^9, 
  3.6898621428792686`*^9}, {3.689863075186725*^9, 3.6898630795651646`*^9}, {
  3.6898709573414035`*^9, 3.689870959555177*^9}, {3.689964119927258*^9, 
  3.6899641251592093`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Plotting", " ", "some", " ", "the", " ", "theoretical", " ", "data", " ", 
   "with", " ", "a", " ", "shading", " ", "proportional", " ", "to", " ", 
   "the", " ", "transition", " ", "dipole", " ", "moment", " ", 
   RowBox[{"(", 
    RowBox[{
    "the", " ", "larger", " ", "the", " ", "dipole", " ", "the", " ", "more", 
     " ", "intense", " ", "the", " ", "color"}], ")"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.689778283700467*^9, 3.689778292090191*^9}, {
  3.6897785965540504`*^9, 3.6897786684251847`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Linesmt", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Large", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"1", ",", "1", ",", "1", ",", 
            RowBox[{
             RowBox[{"dippsp", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "11000"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ni"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.689765442976636*^9, 3.689765482363874*^9}, {
   3.689765758476636*^9, 3.6897657802485404`*^9}, {3.689765865502999*^9, 
   3.6897658671462183`*^9}, {3.6897659408154545`*^9, 
   3.6897659823164263`*^9}, {3.6897661125561743`*^9, 
   3.6897661517897444`*^9}, {3.6897663388946514`*^9, 3.689766375055061*^9}, {
   3.689766410129312*^9, 3.6897664251633506`*^9}, {3.689767019465727*^9, 
   3.6897670485743003`*^9}, 3.689775158755275*^9, {3.6897758729539986`*^9, 
   3.6897758936783495`*^9}, {3.6897759287794333`*^9, 
   3.6897759541271763`*^9}, {3.689776681404955*^9, 3.6897766820303097`*^9}, {
   3.6897767615147*^9, 3.6897768002217093`*^9}, 3.689776838045933*^9, 
   3.6897770379006095`*^9, 3.689777589197672*^9, {3.6898621550612965`*^9, 
   3.6898621561497765`*^9}, {3.690015800845811*^9, 3.6900158011354685`*^9}, {
   3.690025848382267*^9, 3.6900258484990807`*^9}, {3.690746382962504*^9, 
   3.6907463891885943`*^9}, {3.6936011149898386`*^9, 
   3.6936011164132757`*^9}, {3.693773573433371*^9, 3.693773574334342*^9}, {
   3.697309706995324*^9, 3.69730970933099*^9}, 3.6973108531540985`*^9, {
   3.7591713736244164`*^9, 3.7591713831950502`*^9}, 3.7594202041801357`*^9, 
   3.7594272668686247`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P4", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980231.540"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"621.024701", ",", "980.241640"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"1035.041169", ",", "980273.110"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1035.041169", ",", "980243.600"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"1449.057636", ",", "980246.300"}], " ", "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"2484.098805", ",", "980253.920"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"3105.123506", ",", "980303.000"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"5899.734661", ",", "980383.900"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"8383.833466", ",", "980413.000"}], "}"}], ",", "\n", 
      RowBox[{"{", 
       RowBox[{"10867.932271", ",", "980451.000"}], "}"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "11000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.690745482406515*^9, 3.6907454824075174`*^9}, {
   3.6907455276637845`*^9, 3.690745748047203*^9}, {3.6907459744814377`*^9, 
   3.690746085269845*^9}, {3.690746129904201*^9, 3.6907462273336515`*^9}, 
   3.6907463743074493`*^9, 3.697309649120573*^9, 3.697309930336913*^9, {
   3.6973102169768295`*^9, 3.6973102669898157`*^9}, {3.697310329541659*^9, 
   3.697310343859923*^9}, {3.697310562069584*^9, 3.6973106164171777`*^9}, {
   3.6973115625457244`*^9, 3.697311562708366*^9}, 3.7591714978802547`*^9, 
   3.759171541383729*^9, 3.7593488455891542`*^9, {3.7594201621624775`*^9, 
   3.759420162289172*^9}, 3.759427268976124*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       GraphicsBox[
        {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
         CircleBox[{0, 0}]},
        ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{621.024701, 
      980.24164}}, {{1035.041169, 980273.11}}, {{1035.041169, 980243.6}}, {{
      1449.057636, 980246.3}}, {{2484.098805, 980253.92}}, {{3105.123506, 
      980303.}}, {{5899.734661, 980383.9}}, {{8383.833466, 980413.}}, {{
      10867.932271, 980451.}}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 11000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7594275883525553`*^9, 3.7594278125021553`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  SuperscriptBox["\[Sigma]", "+"], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.697311101221385*^9, 3.6973111038859215`*^9}, {
  3.6973111400141726`*^9, 3.6973111567567396`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"P1", ",", "P4", ",", "P3"}], "]"}]], "Input",
 CellChangeTimes->{{3.6897662670344133`*^9, 3.689766320858626*^9}, {
   3.6897756833393536`*^9, 3.689775684090374*^9}, {3.689777005257166*^9, 
   3.6897770103794265`*^9}, {3.6936011255754614`*^9, 3.693601132503233*^9}, {
   3.6937730601264687`*^9, 3.6937730606205654`*^9}, {3.6973107292470455`*^9, 
   3.6973107303162956`*^9}, 3.6973115663829412`*^9, {3.759172328471125*^9, 
   3.7591723290636673`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmC1uEOuwqNAUMUiQxfMeMejKnaTaRNbQiN0kZlhukIw0Z
CZOFZoJKGKAEHMqLcB7cCcfdAXf/O8i2s2Y6TKOUnBcqNTM0Mifd88XvE5uy
z/78n+f39jx305LTEjaP8vPz+9n3T/7mT1zAxfDxN6NfHdFKUVpSUjJB+W1R
nR4XEEQ7koVhRV/mRPV8i0hJSfE+QYs0EZp3a+2T6u+3CR8tT9FXM8TAWktI
sHr/E+H7b/ckOixLuO5G9k5W630q34+dQsfkiHuRSQVT1fq5QucLKISO3yPm
+X7C1H55iHcanf6ZmJlUoD2r9t8rEiwhYyPown1il2/B51Q8+xHfdNr4hVzf
NEPFV4D8I+nUQhnfhCgV70HE8zw9dBD1maXiPyQsIXkfRtP5hxHvbJVPkaz/
vhfo4C/hGJXfiOfQtcWId67K9wjWn0fHfoX956v8S0Rfpm72AvpMiXzfb6Gq
R6msxzfK68tkvfIWqfocRX9i6f6j6J+y8RjyWUzvLMc8vajq9zXiVx5Tgf2X
qHpWyP5uVM89FZgntX9MJdZT8RdVIj+V/1Al5kXVL6kK/f+//lUi4KL+9kw6
Qi/nf5Lqb74e+an5GNBjfTVP8dWy/ylq/szVcr30Z1S/jiN/Ne9ZI1bn4+px
4QsnQ52nZSfQL3X+ak8g/0A6sEac9XhWP6b6W4P58qcv1CD+0arftXK/+8M3
HvlorfjId+Af0H51sv+Gf+hNdejvPfpMnfz7dX/Rs+qFvC9u04X1qN8APViP
/tyg159Evl7aflL4yhN3jQ5rQHxX6D0NeL+X7m9APS/RqxtFgXY3soc2NmLe
fqB1BvT7e3qnQfZ7qYfuNSDeM7Q4hfuui64+hb/X6DFG2Y9bHfRCo3i9L7PI
RqcaMR8WutSI+pppjxH5N9EPjeiPgY5pwn1STyc3Yb5q6KIm7K+nu5vQnwp6
qAnrHaOjmtHPEjqpGfkU0weaEd8h2tGM+S2g7zSjH5/TESacz3w60STz1+XR
+SY5D/oc2mrCfZJND5jQz0w6xIx4dtDxZtwv2+lcM/JPp81mxLuV9pplv5O2
0MGncf9vpledRj7JdBbs3UAbRp6/S18deb6OntiC52/Ry2BvPP3xyPM36doW
7L+SvgxvXE4HtmI+l9Ivt+I8vUKnt8p8zy2hq1pxvmPpC624r+bT/hacnzl0
rAXzE01/YMH5iFLn3SI/b8un099Z0L9wdf7b0N9Qem6bkL+mqPugDfdTMF3c
hnro1P3Qhn4E0ffbZPyeceq+sCLeAHqDFfPpr+4PK74PjKY1K87vcD/vEyvi
eUBPt+E+GKLX21DfQXqfDfX7k7bbMH+/03/YcH/dpMPsOM9eOsGO/a7Re+y4
j6/QLXbM4090vx3z/CM9uV3Wv/YCvbod9T5HZ7fL9XefpY3tqOe39K/tmP9u
WteB+DV6eQfi76R3dqB/Nrq+A/dbK93bgXkz0+M7ZT/ajbToxHqN9LZOrFdH
V3diveN0TyfWq6LHOLBeOT3VgX6W0QsduK+O0GscuM8O06kO9KuQznFgnvfT
pQ7Uby9tcmAe82iPA/3Poa8jnrhs+iHiKc+kn3aivzvoGCfO63Z6pRPnLY1O
dqI+W+ldTuSTShc50b9NdKMT3x830t14X/8efQXvj32HHsL7KYl0kIb9E+go
DfuvoV/TMD9v0Eka7p8VdIaG/JfRBzTkL+gaDff7S7RDQz8X05c0zNsC+o6G
+s+lH3fh/M2mI1w471F0nAv3zww60YV6hdNpLsQbSue7EO8UutKFz+Ng2uqS
/b6ro8+7cD6C6AEX7pNx9Fg3vg8G0CFu9NefXuTGvI6i4934/Bz+7ZG3uJHf
v3SuG/n9TZe5kd8gbXajH7fps27M4wDtdeP72Q162I377Tod3IX56aPndKEe
v9CrulCPy/T7XTiPPXRWF+btvM//Aes3XeI=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxd1g9M1GUYB3BsWk1dTncztElazJF/kqAQs7M3YhJqdjIzrJsWKCpmootG
yhJJJjITVNBANJBTEOE8uAPuDg5+9wdjE22VWZkWNDNSKua/kSvt936v7+uM
zXOf3e/3/nme533em5SyPmnlAyEhIRf1f/J//g3/tmpg7ZXpLwWVKHRnvKu8
VKSlpV1W1lLEU+bCuHXq+zXild5NxcpivTjd3d2trG0U5kLfTeWeTGHJMA5/
T73/4f2emC3nH7g33hY5n085cqvQP3PujZ8r+hc5w5RN20TvJoNVrbcnD98r
Z2yX68m8t98dIu/qImc6XVQg/DcjLqxR69kpnGF5V1fTtk+EwZrQu0qtr1Do
4fKk0auLRJL+wkq13t0iWv9bQQ/uFpsN1s9T1Pr3SCe8Q+fvlc/bl6v9FMvx
hi2jQ0vwvFntrwT5epOu2SfjWZCs9rsf+VlCx36K7xer/Zfi/SS6qxT5Nal4
lCE/C+nkA8jHfBWfchmftYl0XznWm6DidRDzx9NZh0RZaem4OBW/z8StCHPh
i/TQCpnfEKOKZ4Wsv7TZdHcF4q0cWYnnX6CLK2U+Y5UHK2U+zcrmw9ivsvY/
h1fd/3x+FfKn3F+FelbzmyzCqA+g7LDI9RmVQ49gvc/T2UeE/nqEcs8RoZfT
pll0/FHUY6zK51HU40x6ZDXOY4zKb7XYoC/gOfpsNernWZXvGtR7NF1eg/MQ
pfJ/DM9H0ivg6BmqHo4hf9PpabWYf6qqj1qMN4W+UYv6jFD1clyu743JdFvQ
4ap+6lBvT9Db6jDeRFVPdZhvAr2gXn5/6DFVX/WYbxxtsOL5sarerMivgb4A
D4xW9XcC9TWKtpxA/xqp6tGGfA2nY2yI50OqPm3I71C6zCbzeXuIqleb7EdP
3/3tP9+xob7+piMbhP6Z8xed0iDPR+kturgB/ew6fbIB9TFADzZg/t/pKY3w
FdrciOd/pXc1YrxLtNaI+Xrpa43oXz/S4XbE5wd6iR3x/o7Ot8v6f/Ib2m3H
/r+k++2I5xk6zIH5TtEmB8bvonMdiFcn7XAgX176sgP12k6HNiG/rfS8JuTL
SWc3oV87aGsT6rmB7mnCfqz0mGac71o6vhnnu5r+oFk8rgfUQtcEn6+gzzej
Pg/SI1tQ32X0nBbU5z46owXx3ksfbkE8i+izLcjnTvpBJ+pnBx3rRHzy6HQn
+nsuXe7EedpCn3EifpvpEBf2n0VHudBP3qdXuJCfDfQ+V/A+p7tcWH86fdsl
+/moVfQ0N/KdSi9zY39v00Vuma8aM+1zo/8spW+4Ub+v05Nb0V+T6ORW3EcL
6QI4bj7dFvw+gf6jFfuNpye24T4WdFIb3jfS22DfLLq5DfPH0H2wJ4oe78H9
M4Ne4EG8p9IfeVDfEbTNg/oKp3/2IF+TaEM76nUCPbcd9/F4Oqtd6J85Y+na
duRnDH2hHffzKPqRDpyHEbToQD9+mN7YgXgMpS0d2M8Q+lwH+sc/feyPGtZ7
m56g4T6/Rcdocn0h1+nXNKznT3q1hvvtKr1Vk/1iQR9dpiH/l2i7hvrppbs1
xOci/UtwvvP0neB85+hHvajvr+hIL/L9BZ3oxf5O0SleOb6hi97sRbwDdLEX
vw81ut6L/uChT3pRHy76Jy/W30wPenFeG+nRPpxnKz3Fh/wcp1/2Ybxq2uzD
eBY604fxKuhdwfHK6ergeKW0FhyvhP7eh3zuoa/5cL530SP86F8FdLgf+dpO
G/2I38f0Ej/6QQ693o/7M5vO9yMfWXSlH/WWSbv96B8b6K/9uF/W0f1+9MN0
elgg+HucDgtgP6n0zADyt5w2BVB/b9Fr8L4xmc7F+4cW0wcCmN9EO/C++VX6
dAD1mkhfDuD37lz6bgD7j6NDO7H/OfQzneh/s+l5nThPM+nUTuQzms7uRPwj
df8LYsBreQ==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1g1M1GUcB3DmpE2zsrrlSxO1nKmp016MzZFPWpKMprJput1yoZJaC3XD
iTJfEFNJERTUQzQQlBflPLgX7vAO/ve/P+oKbfZi5XBCTUZKzUzT2Ubd8z2/
P9ic+3j3/z/P8/t9fw+OTc9MWzkgLi7uevSP/ps/9v3mfePWlHdimqe6Ntmm
hsVLlc2Z/LHYSFdVa5Py+z9frb/vFKtMdam9vb3/++tVRkZGt7gzSzmTux71
P5+t3zfYpMfkqFKHY4RYbVXR7U0QT9uudt5emCg2ctVE+/7Z4gV5anT0C+LO
nXr9DPHaXSp63ixx3B71z4Tov9CF+Xq9mv797FWbbc4LYtc+5U/Yebt/f/vV
+9ECROhVhdiPeFqRGvxT5VrxwyK8X2wc0PXtEu8+qHoX+hMsOU8x6i8eXqKS
oi8Ud5ZgP+KaQ+r16E+bnPewrvcmceIRvT9THOdA/c/TFx2on7iwVPfDIV5y
VK2LbkA8pgz9ukD3lKEe8rnrmN7vy7K/jcexv/76faWi5UmS/A0s1/VObpF6
luv1PgzS7eXoZ7PUtwL99NPFFeinT+pdgXp7aPsJ9LNR6n8C9XPR4ypxnrPS
j0qd59R6urdSpUUfOC39qULea2lPFZ6vkX6dRP9P0TkndX2vVEn/TiIvlfS7
p3S+/RXSTzixnB5Sjf0fl/5Wq8j9CfZj9A/VSv9VJv2uwXyW0mU1yJND+l+L
vB2hV9RiXg9JHmqxnxJ6ch3mv1jyUYd+HKTv1aF/ByQvpzG/RXTwtO7PM4WS
nzO4DwrovDOYh32SpzOo7146tV7nx/2l5Kse+cynbU7kfY/kzYn87KY7nLjf
dkn+zqJeX9BVZ7FenuTRhTztoGe4kIdcyacLz2+nS13I21bJqwv12EL3uXS/
OnIkvw2o32Y6vQHnz5Y8N2D/G+nzDXpeQhsk3w2Ytyx6UiPma73kvRHzl0kX
NKL+n0n+G/X83F9F323EfK+UeXCj3un0Yjf6v0zmw4382elmN/q9VObFjfcv
ohM82H+azI9H12/bfDrXg3lIlXnC53Hz6G4P8viezJcX8zWbTvHivLNk3ryY
t5m004v1EmX+vMjDm/RzPpx/usyjD9+fSm/w4f2vynz6MI+v0Nd86Oc4mdcm
fV/Ej6XfbsL9PUrmtwn330j6RBPWf0HmuUnfT58+Tz/hRz2Gynz7df+Lh9Br
/Kj/IJl3P+oVT1/2I48DZP4DWK/v98d+LYD74V96RQD34wP6UAD37T36YgD7
+Yt+FMD9+Ac9uRl5u0V/1Iz9dtOFsO032mzGPN+g78EjOujx5/D5z/QSeMSP
dH7s8yt0MPb5ZfrPc1j/a3pMEPu7QKcFke8InRdE/wzaF0QegnRPEPeXnx4Z
Qh69dGoI92kDvSWEeXHSrhDyWUf/GkJ/qmlbC+alkp7bgvkupze2IE9ldF0L
6umgO1pwnhL66Vbst4hWrchXAb2+FfdTPl3Viv3soq+2Ik876IEG5mEbPcpA
fXPoGQbykU3PN7BeFr3KwHrr6O0G1vucLjVw/6yh3Qb6+QndbiBvy+mbhq7/
nWV0n4H7004PC+P/P0voaWHMyyJ6Xhj7X0inh1GvD+jNYcxHCl0cxvzPpevD
uE/m0Odj75tF34i9byb9MPa+RPpZE+97g55kYn/T6Tkmfh9Noe0mzjuRzjJx
3vF0gYl+vURXm6jfaNowdX+2vUj/YuL3zzD6ron72EY/GUHehtLjIpiPp+ik
CO6/QfTiCM4TT2dGcJ4B9O4I8tnX89gVEdw3j+hmPJ/8gP4ez9f8TffG1r9D
x1tYv5dOsLB+D/2WhbzepBdYOH8XvdrC+a/TuRbu52v0UQv3y1XaY6Gf39GX
LNT/W7rbQn6/of+zcN9cpIe3YR4senob9mvQKW3Yb4he3ob9BuicNsyPN+r/
AWFSdIo=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g1M1GUcB3DGpBVZlrum5SItc+q0yEpcDfdEmeFsAjVfimySMnxZ+DKc
oVkwKCQTX1ADScFDQJTz5I7juDvgf29IE3OmiRamWBIoK+fUyJp2z/f6/pxu
yj7+//c8v+f5vRyj0jJTFkVGREScC/3VP/nHGZO/9Mrlia+FlajyryQ773qe
iu40XxUbaaq0pOTxfnm+WHVnm54Tq0z1YuiP2Fip4qM7nxFfyFKW6d237q7/
iRqXWuQTj1yn91suVp+pyuXx0eLYHHVzbGrRZVk/V+kf4qQ8tSI+ek6f7Jev
+pOdu3vp5V+qYx0dHb/L/htUenp6Tw+9uVCF7uPKJYlnozKFAv6Ntn6tQuE1
/yrxFen4Ci/SGZv1eRK6Jd4tWO88PbBFpYT+4xeJf6s+z5BzdME2rPeznKdY
ha7nxll6+Hac74ycb7sKPa45TdfsQL5OyXl3Ij8n6Snf6POmn5Dzl+A+j9Pt
Jcj/MbmPUr1f51F67i6s/53cT5k+T1Q73VumngotcETu61ucV7xmt64Pm1jt
Uf4bY7vEg8pRH+KMctyPrN9RjvoTx1bc6+KKe98fqMD9yXqpe5F/sbFXvdWd
XSwebb43/gIzPt9G95txX+KkSv15k9heifMGJV/7UD8Bet0+na+x4gv7kE8/
/UaV3i/LJ/ms0veR7aUHV+t6WmpIfqtRb630qWrko0XyXaPzb/HQZTV43y35
3496bqIX7ke/OqUe9iMeBz2hFvmzS33UIn/19PVa1LtV6uUAbKE9B/D+Qamf
g6i3WjrvoAr9+3mN1BOeT6miZ9ahX81SX3V4v4I2WTAv9ki9wYVldJdFvx9R
KvV3CP2wk648hPsolnq0op620pOtqI8iqU88L9pIl1oxzzZIvVpx/i/o21bE
lyf1exj3nUOnHcb8XC/1fFjHE7+Wbgt7jdR32Fn0+HqcZ5XUez3mwwp6Uz3u
P1Pqvx718jF9rR7xLJN+sOH+l9CzbdgvQ/rDhnjTaZcNn18o/WLD+ml0jB37
fyj9Y9fvmz+gc+2I/33pJzv6ex7dY1drTZYjs6W/GvD+u/SMBuQ3RfqtAfmf
RVsakM+3pf/Cz2fQQx2YP9OlHx1Yfxq92oH9E6Q/Hfr7JUbRPznw/RUv/dqI
+n6FntqI9eOkfxtxfy/TexvR35Oknxsxn56n73OiPidIfzsxX8bRS5xYf4z0
uxPnHU1/70S8o6T/mzCPYuhJTfi+GCHzIOzh9I7w+4/JfGjCekPpW02Yh0Nk
XriQj8H0fBf64X6ZHy7dTyeiaJ8L8yVS5okL/XWn73+PceN+/qXnujHP/qYL
3dj/Ju1xY15co/9wY/0/6ZEezNd+OsWD9froPA/qt4d2eJD/i3Qvnuefp59o
xue76JnNyMcZen0z5vGPtLUZ9fUDfbEZ8R+nTS3Y7yj9ZgvmcTu9pgX3H6Rr
w+976a4W1GML/XAr1nfTqhX12UivbNX9mWqnK1sRv5U+3ar7saSOHmSgfmvp
Jw3ks4qebCBfZnqWgXoopzMMrFdG5xiotxK61MA83U7bsH7yVrrDQP1voi8Z
OO9X9O3wfgX0MC/qKY+O9WK+5NCJXsyjT+k0L+LJptd6cV+r6WIv5uEqus6L
eDPpNq/Ox/Rl9Hkvfv/IoAe8OM8i+lEf7m8BPR5Onk+/Hn7+Hp0afj6Hzgo/
f4feFH6eRFf7sP9M2vAhvkT6rA/xT6Ov+XC+BPpBP84/lR7tR/5fpeP9+L6J
o2f7UZ8v0Zl+5DuWLvBjPk2kK/zop3G0y4/fv56lT/pRT0/T/X7kP4aOCuC8
I+iYAM4zjI4L4PvMRCcFEO8j9OIA6uEhOjeAeB6gdwUQTxRtD6B/I+lj2P/E
7V5+X2H/hH/oOwH0/1/08CD2u06/EMT30VV6RhD79dMfBfV5F/TR64LI56WQ
/wNkk4XM
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g9MlGUcB3ByaIu0zK5ETUQlQ1NDM6XZ6eOfVJgudM5oslxozj8r0UUZ
MkOS+ScDVNRANBCQE/Q4ODgOuIP3/qCunS2ni2Vk4pJpMGcOi+lG3fPV78+8
TfCzl3uf37/ned/RyZuWfdwvJCTkt+A//ft/nwzVNWnOw//GKZN1Ycdjf6DG
J+XMFRvJapkzImu2XF+vfPei22fRapPaFryB2Niifc5MX0tVm81h74tDvlT6
pzgyXWV1LXW+I/f7CuuJY3aotcGP2MjE/cQJO3U8SeJrWSqsrSRFnLJLLepI
yxOH7EF84ty9er3+j+PZ92S8tm8Rn1jlKHNY21jJd12uKsjPzxfH7FfdS50R
Uq/e/SrHe88iNg48Wd/dB3V+neKEPPV3dFLOHDr8EP5+ruR3CPWbR1sO6+te
ccoRVZpi3jufjv0O+bwr+efreKIX0OfzVbD998W5BepCIBBYSCce1fkcXyT1
KUQ/4uibhTr/YfFSr2Ooh3jrcRVsh1usvtc2i0OLUC+537oifF/WDxShPhJ/
TDHWk/zyijF/Up/eYhUsR6rUM+mE7lfJ4/k8oevRJv2PKtH1fn6m9KNEjQo2
/G26uwT5z5D+lOr733uLri1FfadJv8owX1Pp9DL0b4r0rwz1fYOefxL1nCz9
PKn7FzaJHliO/r4u/S3H/phAXy7H+uOl3xb1ZvATTRdaMK+vSf9PoX7j6DWn
cP1VmYdT+H4UPbEC9Rgr81Gh5yVtDN1TgfkeLfNSifMkknZV4v7iyNPIdxS9
87Rezx4h83Ra6V/ixWew/kiZrzPo5yu0yYp+jJB5s2IexO1W7P/hMn9ViG8Y
XVqlOtJMk8WhNpwf4fR0m75uHSrzacM8vkwX2PT9TeKADfP9Et1nw/lkkvmt
VsH2bXyRTq7GvA6Rea5GfQbTZ6tR70Ey39Xofxg9oQZ+Wua9RtcvI5TOrkE+
T8n81yCevj8f+W4N5vMBHWVHv3rpFXacDz30bjvm9y+60Y79cZvutiP+Ljqi
FvW9SSfU6nju/EFn4rq1g66txfev0p21OB9+pcPr9DxcbKPj65DvZTq9Dutd
pK112O8X6GsP//4HeogD+Z6j5zuwf3305w7EY9AWB54XbvqKA/k30APr9fMi
1kHPqke9auiUetyvij5Rj/mtpC/X4/y20AOc2K9ldKwT+62Y3uDEfj1OFzpx
XhTQPzr1+ouP0CENqN9BemoD5iGXXtOA/bGPPtyAePfQ5+HOLPp+A+Y5k57Y
qN21nf4Q3riNzn14/Qva24j7f0b3wJ0p9LgmHc9Hn9CJTXj/WE/vbcL5t5Z2
NaHeyfTtJpwHq+hIF55HK+llLtQvkd7pQn2X0w4X5m8pfdOF82QJPdyNeYin
F7uxXxfQ293Idy5tc6Pes+nrbsQ7kzY14/yIpRc0Y39Mo7c2I54pdEUz5mUS
3d6M/Tqefq4F9R1Hqxb0fwy9pQXrjaJLW5D/CPrnFpxv4XSooYI/M0z0SAP5
DaanGzivB9HvGaj3M/Q6A/ttAL3DQPz96AID+6Hv1iPbDdTrAR0wMN//0DcM
vM/00H0G3p/u0EM9uF83HePB/W7RcR7Ed4NO9iC+6/Q2D87Xq3SeB/leoc94
sL/a6LMePM8u0b97UL+f6F7EkxqgX/DifDpPT/Di/Gil53nxPuShk7zor5tO
9SKfRjrbi3wcdLkX82KnDS/6V0X/gu+3V9J38X2zhX7Wh/VL6Sgf1i+izT7s
v2P0Ch/el/PpTT7kf5je7UP+B+hiH+Yxm2704fz+hr7kw3zsort9OB++pvv7
8fzKoCP8OI/T6Rl+xLuVTvAj3lR6vR/92kxn+vE++Cl91I/zawNd68fzYS19
AetFrKY7sV7aKvpfrNe2kg5vRX6J9JRW5Lecjm9Ffgn06lb0Ywmd3op+xAX9
Hy+WYo0=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1n1MlVUcB3ByaoXMl2RJtkgnc0SaKEtxhTu+JEKYwJraYm6SMs0/IDea
KUtlsshZoKHJi8g7F5TrvdwL3AsXeO4Lyhy0LEozneCKaWg5BuastHu+d9+f
0w3vPnue+zzn9zvfc86dm56Zun1CUFDQdf+f/uS/tALP+MqRhSsDSlD3I9Om
PfEH6nJ1VpzYSFfrhvYWPbm+U2VkZAyLVabKG0mJXSX371apjvA88WC2ejVv
5JI46DN1J8URvpqek6P8t+8Sq/0qJibGJo4+qPTHGnl+rurv60sSJx/SzysX
D+ap4MvV98RZX6h9oeb4d+T9X+J+ceFhPH+tjOeI8o5HpoktX6nX/A0TqwLl
b19kPL2jEP0RRx/V9U9aRz84qvxfzxYbx3S9I+L8b5R/eFsTpJ4i9Ulc8GVx
2HHdv5REqe+4rr9PbDqB+t6Ver/FeMWxJzGfSVJ/Mfor7i1WQ3tD31gv/ShB
f8SbS5GP96Q/ZcocP7RXfKsMeRBbTmE8G+g95cpfTrVYndb9GBdPrNDjXZUs
/axAfsR9FXr8neLoSvRPXFSJ8aVIvysxP+K0Kl1vjNioQr3iiGpVUlz8kji/
GuOT59+pRj/FyTWoX2yv0fXNE4fVYrxSXw4cJx6s1e83S7/W1KmarLhgsakO
8y39D6lHP2S+surRT5nfgXrMp+Qh1qTrN0l+yky6PwWSt6AG5E3yuq0B61Hy
3duAfMn6WdD49PosbFRP7R9jjXq9ZSnJyxnkdwXtOoN+x0l+zuL+t+hDZ1HP
csnTWfR7GZ3UhP3jTclXE8YXQ4eaUf9iyZsZ/VpEXzMjjwslf+cw/ii65hzW
b6Tk0YJ+zKeXWnQ+iudJPi1Y33PpEgv6GS55tWB+X6YfWZDXMMmvFc9/kU63
YnwzJc9W7Bcz6PNWvb4ypku+rdj/ptFRzcjfVMl7M/a/EPrrZoxniuS/Gftb
MD3arPP88DlZDzbk5Vl6o033J3SyrA+bzuvhiXS7Df2cIOvFhvE9Q4fb0b/H
f3D92DGf/9G5dqU//qXtdtTzkB62Y/0+oMNacN7cpxNbcH2MzmlBf0dpcwvq
+4sebEF+7tIvtKLeEXpNK8Z/m/60Fd8fpk2t2B9/o6+24v036ZA25PcGvaIN
83udzgpcv0pXtWF9XKEH2tCvn+jJDvT3BzrWgfF9T3/swP39dJlD53HoIv2d
A/3opYOcen1u6qGXOLFePPQ2J/LSTZ9wYr5cdK8TeXbSD52YvzZ6QTv2Yzu9
pR37q5UubMd4zLQn4DP0WOB+Ez2/A8+rpTd34H1V9OEO5L2cdnVg/yml/+zA
fnySnuNCv47TqS6st2P0IRf23wK61YU8HqFv4f7xfHp2J+Yzj07qRJ5y6c87
0e/9tKUT9eXQNzv1ery2hw7twviy6bVd+P5uek8X+pFJN3bh/bvoa104n3bQ
U7txHm6nVTfet5Xe3Y3530LXdCPPH9I/B+7fRE80dP8PvE+/YqA/KfRSQ+f9
wnp6g4HzI5HeYeC8i6cPGjivVtMlBn4PKNpm4P1v030G5ms5/XvgeUvpRwbW
5xJ6lhv1LKKj3Rjf63SCG/2NpNPd+D0TQe9z431z6SI39v9wusmN+Z5Nn3dj
fmfRN9w432bSD9yYj+n0DA/OrxA6yoP97Xl6tQf5nUSnedCfCXQ27Hl0m/u9
B/vNP3Q9fOFv2ghcH6N/CVy/R48Gnn+XnuLF82/TEV78nhmm47x6vI6b9EYv
+n2DzvRiP/mVzvei/it0pRfzNUC3e9G/S/SPXvS3n77jRf8v0pN8yPt5OtyH
/cBDL/Ph/Oymk33YHzronT7spw4614d+2+lSH/ZnK233YbxNdL8P67GRHvYp
//8H6ujHgfFU0WE9OH9P04t7cB6V0ok9mP+T9Ec9WB9FdE4PzuOjfv8PvWZt
PA==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlg1MlWUUx8l52ySWfbBhudDMnDhtGA2pRB8/8gMpgRKlbqaIBLkCLQgR
CxwsciaaaIFk8iUXRLxwL3C9fL33vRe1DVtNF6usxKXDYOVMzdlG3edP/+OS
Ddhv732fc87//M+5z+PJGQkbxwQEBPzk/9X/+bNsILc0b2jWglFarrw3pp+/
w0mqJjM6cDvZSFYl5o3pwgHpaiA3+ClhlaGG412hdz6/RTUtHbgt513IUv3V
mV13zt+qXKFFm4Qn56kEV6hFWH2ouWgbObxAf34oV87foc+LFo4rVNYSM2ur
xCtS5WVlZTnkzI9UdGB/9fsS/2M8zybv2anzzc2SfHapbcFNS98j2z9Bfu9K
fiVaD9tmctoe5JMp+e5VYf6E3iHf2quKhuKj3pb8P9V6HdpELt6n87+RLvWU
4rw08oT9yv83P1Xq268iIiIcKWTbAeVPdyBZ6v0M+a4nR32u63/iDam/TOe3
8HXy6TLdf+troke58suVmURec1DdnG4tWS36VOh6XKvIgxXo98ui1xd4P4Gc
cwh6xot+X0KfOPLYw+ivcNph9EM+33cYesh54ZXwm8QrrdT5jX9F9B5lyc9a
BU4U/at0/x+ReqZWw99rpB/VWt8IqX+4Gvm/Kv2pUZujA1eLXs4a+Nkq/apF
v0TfvFql522t9K8W/pF+LD4CPddJP4+oM319fdK/oLq7+lun9b26gXyuTscL
2Cj9tqFe8UuFTZ8XKxxQD/3EPyn18J/EO12P+JLfzAbkK/XsadD7YafUf73h
Lr8c1fmuF307j0Iv6cfkRjXJX7D0r7AR/pN+DzZinleSY49hXl8Ufx1DfivI
wU1a3+AY8VsT+rGMfL5Jx+9fIv47jnxeINccV6mpqZcXiR/t8PtCcqQd+i0Q
f9qhnyKX2zFv88WvdvRjHnkE542PFv82w19zycnNyPd58TOeO54jn2zG+8K3
muGvZ8kzWhBP2NoCv0WRd7dg/wgbLZi3OeRrLYgnPNWB/Suc6EB+wsUO9FfY
fRcPO+AH4VAn9BSOc+L7QHiHE/4Tdjr/n+9lJ/wmPKEV/RKOaUV/pP68VuwX
4SbwQtHvQque51PCD7XBf6L/4jbkI5zdBv9Jv2xt2AfSzx/asP+Eg9oxz9L/
ee3YZ+KPzHa8L/6pasc+En+da8d8C9/rgr7CUS70T+K95YLeUk+FC/lEkr92
wS8RMv8n4Jdw8tMn0O+Zsg/AljDygdHnT8p+GH0+hXwb5+WHyr5w4/yJ5LVu
1B8i+8ON+h4mm2746wHZJ27suyDytA70Z5zslw69P761kHd2QM8xsm864K+R
3/7j3ztwX/mbPLkT94G/yAmd2B/XyYWdqPcqua0TfhgmD3Zq/6VeIT/ahXwu
kWO74LeL5A+6MF8/k+1d2B8/ki92wd/95OBuxDtLXtKN/n9DzunG/usjN3Rj
Xr4in+/G/aKXfH8P7nMmWfXAL93kLT24/7nJNT3Iv538XQ/2v4M81sA+spMf
M7CvG8mRBs6zkVcaOK+WnGbgvEpygYH8DpHLDeRXTnYY0PcAuc9AvfvIlwzM
Zwl5xID/dpFDPNCvmBzuwX4oJC/34H5UQE72oP/byds82DdbyaUe+C2bfMyD
eraQT+J9Swb5F7yfuol8C++fepP8oIn4KeQZJuKvIy8yMQ9WstWEnknkLBP9
XkXebWL+48l1JubnJbJhYj/FkL834f+l5Gsm9F9Evs8Lv80nT/XivjSXHO1F
vlHkRC/yfYac4cX9bTa52It+zSJXerEPwshuxIudRj6LeLYp5GHEs0wiW3yo
byI51If6QshzfPBrMDnON7pvyOk++CGIvMOH+RxHPuiDvy1kpw963EM+44Me
I1f4feXT/su/Tf7Hh/vHTfKEXuyjP8mzezH/f5BjeqHfEHlDL/w+SM7rxffp
r37+F2zUX8M=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1HUYx5nL1rTlcrSoFllZIyuH0dS1UR9/pIA2kT9It6slkoFUIIUp
ogLBJDIQQxNEBQ4BEc6DO47jjoPvfTmstrPVbLqcLmxlTpgrp43ZRt3n/e15
M7qNsdc+P5/3836ez/fJjNy0d2dERUVdifzp//KbddH+R9/Yi8ssSlZXC6MX
TvFGleaNLfcIGxkqgmO9HM/WnENWucqx+updN+fnq/H13uPk0QK1LXHWm+So
nXo8ljyvSNmqzTsu7rdXRUc2JMeX6PUXyUbp9PHUsunrR8tVfV3dI9w/b596
zla9fOr8z/T8AvKBSpWQkOCaus9+pfUhO7+APlPxVk+PP+sA4iXH16iL9rwA
eaJG7Yp2fE02DqrIddvJFV+q4TtxNnJqrXqifOwHnh9zSOl/U3oeQj56hNsP
63jruhnvV6olL3GWU3jpEb3fegfjr9Px5XUKf1MHPTqoR73aEvm1C284Cv1a
qU+DSooI0iJ8vQH5aaJex/R47QnhHcfVuXB47THqdwJ+qRe+pxF6HKGejfDL
YeFwI+Kvpb5NmF8jXNuE/aupdxP8sF/Y1oz8VFL/Zp2P1RXC8+3IdznzYcf8
T4XH7di/hPlpwX32Crtb4J8i5usk/FEoXHRSReR5egfzdxL+LRBe2YrzPmI+
W/X4pm3C97dhfS7z24b8vy/8YxvO38p8t+v7FWcJN7SjHt5j/k9hP45nnoK/
s+mHU3q/BO73Qgc4h/6wmOfftvgD+uW0zk/ch8IDp1HvvP+8TvVXnG1OnnBZ
J/RkvNc7tf+ukdd2af3D+fRXl76vg3pFO7TfKz+m3xzQj/pediC+7fTfGfiP
3HIG9foJ/eiEfszXYqeKlM/SnfSnE/cj1zvhd+Y77IQeu4Qnnahncnw36ot+
yeiG/8i13ajH3cJnrXHyhLV+j/CCHuxPtvXgfPqzqgf6kI0e3W8uk2/1ID/F
rAcX6o+c7sJ6coUL+pN9Lt0fTPL4/zjWjf5ETnXD/zy/1I16Znxui6nnNTf0
YH5iehEf853Si3qgn4p6cR796OhF/6KfR635W4TnerQfqzezHj3wyzvC2z3w
n4316YH+G4UveRRkYr32wQ9pwq/2oR7WsX77tJ+8a4Sb+9CPkljPfeinK4Xv
9eL85axvL+p9hfBWL+Ll/AYv3u/Xhb/zQr9VrP9+3H+18Ev9eH94fmY/3otk
4cP90C+F/aEf+vD+d/vx3qxlv/DhvuS3fajHN9g/fOh3ZNOH+iLf9qE/cP2z
fozz/A1+1APvX+lHPIx3wI96pl43/XgPXmP/GYDfE4XTBvT8xFfYjwbQ75cI
ewZQDy+zP1m8SPjRAPRayH4VgF7PC+8JwK9x7F8B9ONnhH8JwD9PsZ8Noj5j
hVcNwi+Psb8Nwq8xwh2D0Pch9rtBnDdX+IEh7D+H/W8I3yOzhfOHUN/3sR8O
If6ZwheGkI8Z7I8G1k/e+I8fN+C3v4UXG8jXhPA6A/m6LZxlIP9/CpcY0O+m
cL2B/nxD2GWgH/wuHLbm/yr8m4H8jgpPGqiHK8IPB5HfS8LxQeh7QTg5qM8r
PC+cEUR+vhfeFUS9hYVrg9DnW+GuIN6DEeGz1n6m8M9BfC8NCU8E9ftr9ws/
aEIvr/ACE/q6hVeY8Fu3sM3EeV3CBSa+5zqEq0zo1yrcZiI/dmHDRD4bhX8y
oVeD8C0T9VEnPHsY9z0kPH8Y/eygcCK4vUo4fRj94XPhXLBjn3CFNV4m3GSN
Fwv7rPHdwuet/XcKj1vnbxeeGcL98oVjQ9b3hvCSEOLLEU4NIR9Zwtkh+D9T
uDSk9Zq5SfhoCPl8S9gdgp83Cp8Lof+kC18LwV9pwv+E4Nd1wjEjeB/XCC8a
Qf6ThFNGEO9K4c0j8OMy4aIR3Dcxwv8CFnZ7Wg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1GUcx5nT1rTpbGyam0TTGlk5ys3cGu0pLdK5Eluo7eYmFsNcg1g6
RVQkmUQFWucL+BKvciIeB3ccd8cB/3sBtcAymy6nS2oxp9acpSPXMv7f6/vl
NsY+e/7P8/xevr/v//9ETv7K9yckJSVdHfuz//NXU11dPXjzuVcStNQ0FmRM
HhKvMY6q6CaxlWNid9OujK9vME87ql49Rzb5JmPypQaxVWjsf9+Rr20yye7M
deKkreZSQ0GPOLXYjMXz2Pc6b6dxZw4XidN34X6xVYr7z5NX7DbDRclu8bUy
nPcDuWCPuZfmqBInfWpWBlImXSDvrbDjLRGnfo566HnPF2ZocHD5eHxV5o3h
IqfyzdtrAillN1XP9H3m8bKbWd+SR8Hnzyr+L5HfGXL5V+ajjMmrTisfpxkr
Z8EAeeZ++/7BfuW3H+ti1wHsFxccxPniRYfMtmT3aXFStV3/DJ1/phrxiffW
YL/iWX3YLBj7Kd7UI/b6ffH1Izhf+XmOmltZgWPfkLccQ7yqh/nafj5T9ZpY
a/dnmvSVV2v3NyoerEV+qnd6nRkrb0DsrMPz4tE6ux8bxY566HNcz/Xot+6f
2wC9KL7yBuhF+dxqsOO/Pd6fRuhP9fI12vur4+pXkz0/d6Pk4ibEH1H/mhBv
H3nJcfSjV/08jvUw+ZFm7O9Wf5tR/yD5x2a7P96A+u1C/7rIR1zQo1/9P4H7
OsnvnUB/fdJDYt1LfrbFnj9Hh/TRYs9PWTv5rxb0wyO9nDSQATl8Eve3ST+t
mFc3eXerPU/J4uutOP8UefkpnCf2gEtaycluzLN4ixv9O0m+4rb1mCI2bbi/
hdzYhn6KJ3owDyfICz3wL3GeB3pwkWs8qLd40IN4xP+Cy5ql33asi3Pasf+4
9NxucnNzR5rIA+3wH/FouxmTl6uRPK8DemmQ3jvgF7Xkyg7kc1T6T6zXkO8k
9h/UPHhRHyc52wu/26f58GKeK8khL/r7mebFCz2Vk1N89nnzyzQ/PsRfSi71
4fxdmiefradF4hEf+i+e2Yl4S8jLOlFfcXEn9ovdnXb/hndq/jqhH/GjfviP
eIkf8ewgb/bjfSB2+ZH/dvJlP+pZrHntgp+IX+7C/G7T/HYh3iJyfRf8aavm
uQvzvIX8UADvl82a7wD85mPyBwHot1DzHkC++eRzAbzPP9T8B6G/jeQXgpiX
PPlBEPOYSz4Adq6XPwSR3zry/SD6uVZ+EYJeHeS1Iczfu/KPEOJdTY6GEM8q
+UnIrndFNvmpbviLeHU39KbnK7rt+s3ReeFu3LeG/Ec33k96PjWMer9DXhlG
fd6WH4WhnyyyH+t335Q/JfYvJ8/qQb7L5Fc9mN9M8o4ezPdr8q8e5LuY/EsP
8jXys14D2ZBf74XeXpK/9dp6urSI3NKLeBfK73rRrwXkqX2IJ13+14d5nE8u
7EP+z8gP+6C/NPLFxP4n5Y8W+j+HPNtCP1Pll5b9fO5s8lsW8psl/7RQvxnk
XRb6myw/tdCv6WSvBf+aKn+1kP8U8m8Wvg8flt8m1ieRZ0Swf4L8NwL/eHDj
f14aQb7/kHMiiO9v8rYI4r9HdkbQjz/Jp3B+1m3yAM5b8Dv55wj85QZ5NIJ6
jpCnR5H/r+R5Udx3jbw4ivfvVbIjas9b2mXypijeRxfJlYnzLpCbo4nvabIV
xft9iPwT1u+fJd9J7B8gT4kh3xh5bgz3W+SMGPwmTM6OQX9Bcn4M33t+cnkM
89RBrouh3m3kUAz1bCVfiCE+F/lW4vkm8qQ4zq8np8Thl8fIL8bhb4fJK+Lo
zyHyhjj04SSXxpHvPvJh7J9WSfbF4XcV5KE49L+HPBKHHj8hP4hjvkrIM/vx
PtlOfr4f38tbycv6Ed9m8vp+6LWQXNyP+uSP8X/7K4kX
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1HUcxm8ta8Nmy7HCNkkXa/ROuRlrO/ezN1/GFtDmS5ElpoHVOC3M
F8owGIgpiEjyKnC8i3hwB3ccB9z970hdUJYkvmCAJhkwVy6auVbd77l9H29j
7LP7vX6/z/P8bmFyWuLGu0wm0+Xgn/4vn7Bh6++TU08vDdEKVVpSMu8Or1Xj
O8Of+U3Ymwy+zu9T1XSCK/JXYZWmWpeN377G8VvV40n5xi/CY+n6+51XOX+H
MocNP3pFeEGGGrZaesa43m61K7x12ahwTCbWu8z19+A8I8LxWWr5+M6ii9wv
W7kis6fOC1ty9PrmYe6/VyUGB/wkXJCn9zt5luf5Sul/Q8K2/RhPVvnqr+ik
+zk/pUDXo5Icc1AtCn7OCd86qAYHBgbI3kK1KfjheXIP6fVn8bzxRSrfmGkk
RxzW8+Mu8H6HVbAcM+TGYt2/Et7f8rWu10uXhGOPoB5kUwnqxfqdKkF9WN+C
UhUs/zh5TRnu/zPrU47+sT/Xy9Efsq1CbTGHrWY/t1di/zv9PQo9jAvfXaW0
Hvl9SpU+XzjXG6hCvXiemGqM532KqpV/JnqE979VrbKnEmLJSTWq1mIOI3tr
oC9ylFWfd5ica0V9uP60Vdc7/Y7eavX+Fp7HUYv7sD4RdVof+Tx/Rp3Wayvv
N1anHsme+oH3f6UeeqM/GuvRf/J9Dag32dKgx39B/ww1QF9cL7YR65HLG+Fv
7m9qgn95vveaoGee/1QT+sX7PtWM87MeBc263kms15/N8D/1uuYY9EJ9e47h
e/pjQQvm009ZLdov9h+ppxbo+4xw3HFdj+jvqa/j6N+gcHgr1vuWegvxaeGR
VvjnJPV3AvnRL1x7AuczqEeb1o/LK7zYBv31Up821NcjXGrT+srrol5t8LNT
+F8b9OKgftuQN23CyW3Q+wnquU3rI6FF+Js21LOJ+m6DPuqFn2jH+a3Uezv8
Tz7QDr3UUP/t6Ge18M126LGKfrCj/0eFV9nRj0r6ww7/VQi77fBfOf1iR56X
CUc64IdS+seBfpQI73GgnkfoJ4fWu7VYeMIBPx+mvzqw/iHhlR3I20L6rQN5
WCDc2oHzH6D/MN+8X3huJ/y7j37sxP57hbd1It9y6M9O5EW28MUQf0m/OuHH
TOElTuhpN/3rRL58JlzjhL520c9O6HOH8D0uzP+U/nah/9uEN7ugv3T63aXz
e/0nwt+5kB8f0/9d6NcW4ee7oA8L86ALeZEmXNyF9+0j5kPo+w+Fb3dBn5uZ
F268HynC69y4z/vMDzf8sFHYcKPeG5gnbvhjvfBj3VjvHeZLN/T3tnBeN/T6
FvMmNH6t8I1u7P8m88eD/OD4RI+e/0ES88gD/XD9Tg/6uY755IG/3xV+uAd+
43njelDPZOHP8b3B+9l6MJ/3v9KD82xinvXCL6zXa73Yn/Xc3gu/pwo398If
5JHQeK4/pw9653lUH+rN+2ztw/vIetT2oR6rhc/1IR/eYD564bd44fle1CuO
eenF+ZYLv+5FHr/K/PTCv0uFM714j5YwT72o34vCdswfWcx8xXzzIuFrmF/5
LPM2tP+Twg/5sH8089cHP0UJr/BBzwuZxz689/OFd/lw/3nMZx/u/6DwcR/6
NZd57YMe5wiP+tDf2cxvH+p/r/ADhkJZmecGzmsSftnAef+ZlHw38F78LZxu
oF8zwgcM+OcP4QYD/r8h7DWQd5PCFwzk14TwTQN+uSo82498GRWO8sNfl4TN
fvTjvPAqP/JtSDjND7+eEc71h95v4Wo/+nda2O1HXvcLn/XjPTSEp/3Iv17h
WQHUr1s4MoDfn07hFwJ47+zC8QH4zyacGkC9W4T3BPB7pFG4LAB/1Ak7AsjX
auHBAPpTITwRwO+pUuH/QuOLhSP6Mb5Q+Ll+jM8XXtmP92Cf8IbQ+BzhjND4
rCD/D/pMm+M=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlwtM1WUYxs9MaSFpGiXVQrrMYctG0ZKt4b7IQh2bSptZo1ZE5aXiaFEI
pMCklGVAockllftFOB44Bzjcz/kfQCropsV0NMGSCojQwjHmsPM9p/dhsqn7
7f//f9/7Pu/zPR/eFxsf/fo8k8n0i+eP/ld+3FPBMQHjq57y0noV7jtQMscv
qOUZYz+QnbHKEZgxNvd8+42s4tUuzwJz7+++cb2hBP38+bnv9yjP48llwkEp
er2dZLVP9ff19d0pHJKm1g0n+ZOd6WplTFbEHcKb9ut6N/tzvwz9fdTtwuaP
VZYxFbyU+x/E/rcJZ2eq8c2OY4tZzyfKs1zYImHrITVQYm73Y31ZylPOIwuF
t2WrUnN45i2sNwf63Sw8naOuBscs9mH9n2H9+cIHPoc+89hPrnrD82MSDjgM
nh2T/g4rf0vkq9eEK4+g/xlh8xe63vBp4bCjur/Aq8KmPGWJHJ75R7g3D/Ve
Fs7O13pV/i28tUB5/k79SzioEPWOCf9RCD3+FLZ+iX5/F048pmI8C/4mrI7D
PxeF55/Q65vI28Cp5L4TqJccUgQ9fhXOLYJfyNNF2n8PcL+YYj1vM9lZrEJD
Q23kB0v0eiPkAyV6nr6XhMdLoB95UynWJ9tL4U9yQNmN/aaUab8a5KEy3U8S
eW051idXlkNPsl8F5s31zRV6v9wR4bMVKtnfcpp6h1VCT86jsBJ+G+X8q6AH
5xdXhXmP0w9V0IPzfrga9dEP2dWY/6Twv9V63ln0z9aTqOeKcNtJzIt+C6qB
vnx/f43u1zJBP9UonU+sJ6oW77N+ay30ZL/+FviF+iRacP7ph0EL6h+m/06p
aEfgggvCpacwr0H60Qq/nRd+wgo/n6M/rdo/oQPC+Vbo+RP9akV9Z4Rnrcif
H+nfOuj9vXBsHebzHf1cp+c93C/cU4c87aO/63S9Cd8IP1QPf3xNv3v5K+FP
6/F+L/1fj7w7LXylHvndw/NgQ73kLTbkWzfPhw3+IrfYtJ4ZXTwvNuhNDrTD
D26eHzvmRU7H80iy3Y7vySN2zIsc0ID5GMIbGlAPn6c0YF5kSwP6IQ81IC/J
SxvRH3ltI/KE/H6jys/Lu4v9VDZi3uTzjchPsl8T8pf6rGnS83WQzeAw6lvc
BL+QzzahPs7Hx4H7ihzmwPnnPHc4cB9y3oUO+Jn8rQN5R3+YmpE/9M9jzdCf
/oprRj7z+yPNOL+sr7dZn89B6j/TjHo7mRctmHer8Mst0MPB/GhBPXZhowV5
Wsc8aUF/tcIrWjH/auZLK/xcLpzZirwqZt60op7jwhOt0LeA+dOGfD0qHN2m
55uXyzxqw345wo1tmPch5lMb+j8ofHc79PuIedWO/tKF97bDP/uYX+04L8nC
F9sx3w+YZx3I1/eEn+2AnmbmWwfy7W3h6g78frKTeYfvB94SXtSJ/d9h/nUi
H+KFd3cij7h+aSfq2SX8cyf8+i7z0Qn/sL57ndA3gXnphH7sZyOeRyQyP53K
83fqHuE0J85HEvPUif2pj82JPPiQ+epE/3uFL+F9M/WddeI+ShVe5kJ+pjF/
XdCX81nvwv3C72NdqIf7J7ugF+vP9b7PfmtdmDf16vGuT70vuJBXO5jfLvjt
TeElBvSNY54bmN8rwk8b8PtLzHcD+faicIKB+W1h3hs4b88JVxjIp43MfwPn
OUr4nIH61vE+MJCHzwgvdMM/Ebwf3NhvjXC4G/U/yfvCDT+sFo53Y16P8/5w
o78Q4SI39F3F+8SN87xS+Iwb/z9YwfvFDX/cL7ygC/os533ThX7uEV4NTgrg
/eN97i+83ft8Ce8j7/NbhQu8z315P2G/KR/h/i747ybeV+DJ66P/8/Uu1H9N
OKAb9/u08KPd+H1nSnhDN/S5LPxaN/SbEE7phr6jHv4PQiuQ4g==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln1M1VUYx2+lVmiaRqmtCKdzxLLQUqnEji/LNFfKH6YbtUnGsNogG2XK
TAnyZSZoaIGk8qK8iHiFy/sFfvdyMbfQMk3TbKGbziZrzsLMSrvn++v7dbLB
3Wfnuec8z/f5nucwKjkt8a07PR7Pz+Ff+8mflZE1X8f3jpvm0mxzNSZpyC1e
ZCJOlqZPJjvJpikq59IkrS81NbPOrhCbNNM7vylK7CwznX0xZyaSezJMbrCv
Quz5yJ6XK47ONGXpCRvE5mNTWFBQII5bY3IuzW8SO1nIRzwv25xdEfmkzu/J
MYnhAHH6WpOSknLhVv7rbX5Jqi9vA/IVR2+08SnSw/uZsR/PKr9ckxAWSJya
Zx4LJ/ic8t1sz+//PPnaZvN4Um5Q7GxBflPI6z43h7u75yaonnxb/8ip5BFb
kb+4Z6utt+YFcsU29Muo3i+s3jHTyPFf2vyOij0FqG86+VCBPb9bnFeI/GeQ
F263+1/WenSR1WO1+GIR+qv9vV/dns/yHSYybBjlb3aal8IFqN5+u1Cv9End
Zf11Xfp374J+6l9cMfz3DDm/2PZj9ATpXYz4p8hJJej3OOlfYsLLfbHkMaXo
R4z6UYr8xpJ7S9Hv0epPmXk6/DOK7CvDeVHq12744RFy5m7UP1L92w19hpNn
7oHeD6qfe+z5+cPIg8rRz/vV33Kcdx/5eLl5LyHitYHqdwX6dQ+5qAL3a4D6
Xwm9+pGXVJpwOm13yA+V2O/mpf/5iSrs9w85rwr39zr5jyrkd428cK+x86WP
7N+Lfv5Ojq6GflrProYfr5IvVqP+P8lz92E/7e/dh/79RY6sQT1/k5fX4D4p
3zM1Nj7jX7LZj/lyg1y2H/Wr3n5ezAMP9ZjkRf7SJ9ULf9xFLvSifunZ7bX7
JfQn3/AiH+kfdwD63k1OPgB/ql/5Lt9LPuhyhPx9AP5Sv2NrrT6zBsnvtXZe
xssfm2oxnwfL/7Xw2xDylVr4UzymDnrIbwvq0O+huh91yF/+bKnD/g/ovtRB
P3GUD9+P1P3xQR/5PcuH88U+H/r1EPmCz553UjyiHn5W/Jx63Cflk1kPP6ie
mnr4R3r11MNv0ntYg7Ef6tfMBvhD/f6gAe+L/FLRAH3k/9MN6K/8OqgR9cvv
Uxtx3mVyeiPuUy+5pBH1/ko+3gi/nScPaLL5rT5Hjgd7fiG/7a7/RC5y138k
H2nCvDxO9jTj/nxHntAM/Q6TlzRjHou3Yf2y+FAz3pMj5OvNeJ+/1bxowbzU
/m+0QM+jmh8t8MP35GAL+nlM88Rl5Tu2FfE/aL60Yr8T5A2tOO+k5k0r3iPV
/1sr3stTmj9+xJ8mJ/pRv/TL9sMv4gY/7ov4ot/mF6H9Hm7D+6F85rbhPVU9
q9pu19vbhvkh/c61wa/faJ61w2+HyC+63KX51o55EyRXteP+dWjetSM/P3lw
B85v0vzrgD/rycs64OdazcMO6LuffALfz6jWfHTg90ryow7O30Oe5OD/sxLy
qw78sZOc6pjw39VF5DWOfc+mF5ALHei9jVyH9eAWcrf7/VzyeQfzZCP5hgO/
riMPD8APOeS4APyQRZ7t8ifk5ICtZ0c2eWUA/dX38wOYf5+S9wVwX9aSDwaQ
r/iXAOa18rkWgL/EQ4PQbz05Ngh9xTOCOE+cFMT7Kc4IYn5qv03gxeLyIOpX
Pk4Q/Vb+p3D+DtV3xT1f9Q/shD+l15hOzJNV5IROzIMV5AWd8OeH5DQ3/n3y
Ojc+jVzsxr9LbulEf1PJx9z4JeReN34xuX8I8a+To0KIX0SeHEL8AvK8EPJJ
JC91418hZ4VQ78vk7W78LLIvhPs9g3zYjTfkCyHclynkm258PHlEF/o9kTy+
C/NnPHlOF/wxjvxmF/wVS87ssvfrnbFh/g8Q1Hll
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxd1gtMlWUcBnDmtBbazbFCK7LpnLpsFJvSBX295KVYAqViMUu8BNoGunSk
lMpkqUvBQhM0FQ8Koh4PVw+HA5wb2ha6VU5m0wWWREFmJo3Z0s770PO0xQbs
t+983/v+b+93nkrPSlk+KCIi4kr41/7nT35PcvzbvROnDWiuiYuLq/nPi0xC
ZPvod2hfuvlzXFqBHJFpnLM7b8smy6wI/yzR59eYJ/N7vpY71pp2R3ZCuu7/
wBQE+irkUbmmpLh4xFI9byPWk2M3mxR3zJBlen6edb6ctMWUZSdELtd6+WZO
5/oiOftju964FVp/mxmfVhCQC7ebKOfsJe9qP59gvQzatQP5kU2BCS+/KpPO
KES+Vmq/u2w+uuT+XaZzfZRzlfb/qbH/dH3rZ+ZcW1ub1k8qMr3J7gPaf/Ru
rKd8dOxGPpXfij023ijVL/tzEw6vL42O34v9vKn4i01ku+NGKv1lMfa/UPko
Qf7n06n7sN4bys9+u9/E1+nu/chnivL1BfIv5xyw9zfJ5iDW0/2DD5lwP7rl
jEOIV+u1HbL5j9N+YkuRvwV0USn6Te4vtf1UrHjSDmO/itd32Na7Ux7jsPuf
vkj1cJjVCZEL5V4H+ktOKjPBvnFpur+2DJ/XetFHbP4e1H5yj6CeiqfjCOql
eGcetfO0Pln1PIp6zaOHleP5r6m+5eiXRPpCuY0/+VXVu8Lmr2cuvb8C9Zyj
+h9DPmbTy45h/mapH45hvmfST1eiX2aoPyrRX9PpW5WIR049jnxOo73HMa9G
/XPCxtM+ld5ywtY/Xu4+gfNhCp14Ev0iu05iHhPoKKfZEC6onONE/l6iLzsR
v2xOYX9y2SnE86L60YXny5NcNv5sOQPX4+QSF+5/Qf3qQj/Ld1yorxxbhXmS
06uQ7+fVz1VYXz5ThfNV7q9CvuUJ1ZivePV7Nc4zeWc1nj9Z/V9t+3m7fLMa
/SqPqcH1SfSCGsxjnOajBvuPpT34fOREzUsN5nE8HVOL/I/V/NSi/0bTebW4
f5TmCdfbHqe7apGPEZqvOvRLNP1KnQn/3STn1qEesrMO+9f9HXXoP3l4PeIZ
qXmsx7zK6+rxPLmiHv3zGP1dPfpbHnYa9ZCnnMY8ytmnUT/Fd/h/1y8MXNd6
97jx/lI88W703yP0ygFHad7ddv8xw+nzbrzPHtL8NyD+++nnGux8OYbqPGhA
/9xH72nAfu7V+dCA+AbTtxtwHg7SeeHBeXG3518v9qD//6YLPbZeEX/RAY/N
79p++pYH89tHj23E+fYHndqIfrhBb2/E/q7T3kbMaw99vRH91E2P8qJ/uugU
L95fP9BbBtxJ13ttfJc76G4v6qHrI5sQz1U6sQn51vM+asLnf6RdTYjnGn21
CfOm/UQ12/Ps7E/0rGbMx890TjPm5xe6shnvO8V7uRnvt176gRb0h/JjWtCv
v9FrWtAPymdZi/2+8sxN+mILzp/f6cE+vI90/xM+zM+v9CQf+k/7mTfweeU/
w4fzUfnY7EP9lM8SH+p3ha7xoX6X6DYf8nmRvuaz+d/0DX3Hh3qdpx/1o95f
0bF+fD85S8/1Y/6CdLof7xMfvcGP88BLF/lxnrrpk37Us44+48f3vSr6ez/6
wUn3+zFflfTDAeTjKD0hgPPYQc8IIP8H6bQA+nMfvTaA9/deemcA+SuiywPo
p0LaF0B9dtCXApi/bfTNAPKdTw8Nwnn0mCDex5vpBFxP3EgvCCIfH9JZQfTf
BnprEOdpDl0aRH7X0Z4g+u99+tsgvg+spnuDyE8WPSSEfL5Hx4Tw+Ux6Mq53
rqCTQpinZXRmCOstofNCON8X0/tCiO8tujaE+FLpcwPX59NdA/en0HdDiH8e
Hd2KeiXSz7ain+bQr7RiHl+ml7bivJtO57ZifqeG/Q9iWWoJ
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1HUYx28m1dBpGiVaopYVkRpKEW1Rv+zFl1gJa6TbzRVqgVYghSky
E4JlrAQLNZCIV3kRzoM74DgO+N//TnINXe/MogJXzA1WzaTIlnW/7/V8HWzs
9tn//s/v+zzP93l+tyQlPWnbNIvF8n3gX3/Kn23NSHbB+PJHg7RO7YwPHcwn
b1J7w2xryEaKOjMwMPAWn6epFwN/ZJWu1o5kh5GNTMTLEx7OUkXmRAPZskf9
EWktIi/OUbUZ8YVk9ebU59G5KhDeRjbyVMFYoitXeEO+0h/7eV6Bfh63Tzjj
bejN4fnvqCRXREG2cHGh1l+ym3reVWWlpaW7hO3v4fnr1FeE9zOFU4tV6GBN
Rgb1HlKLAgJeFZ48pPOPfJn631fWIjOLfOAD1PsV5lOiz5/P98MP6/i/kYcP
6+9/ki7ccETFawHM9yj07RSO+1AFwr9AvZZSdbe1aPVrwqdL9fu3M7/iMtQz
S3jjMf3+CHlxuQqc1sP6XChHvd5gvT5CPVjP3RU4bw/r9zH8wvpPr9T9DyWn
VsIvjDdQqf2XwPOjq3R+IdRfUqXr/Tnzn6yCP1gvazX0Xq1/tQqkc3m78NIa
9CON/ahB/1KFx2vQ/5fYn1roITtrkS85vE77bZScU4f3GW+4Dt/neY8fV4F2
7aCehuNaX/YO4Zn1qC/1Z9QjH/rlq/qp/ohrgN9Yj/IG9J9+sDSq8URXBf2w
tRH9veqHRviB9V7WhPlhv4ubpvbnUpPWP8Z+bzyBeOy35wTyuTpfzfAX389v
Rnyed6EZ/aOehBbkR/32FswH8wuzIV/mv9sG/azXkA3+Yn3VSehjf2pPYn62
0Y929H+LcKxd+2PiefrTrvXv3yxcBrZY6Vc7+rlJ+Iod+zOZ/m2F/meFU1qV
byLSmkg/t2L/PS3c36piYmIcT9HfrYi3VjiqTb8/9AT93ob8VgsfDD5/hP5v
w/sPCV9sQ/wHOQ8O+DVWONmB/MgHHPDT/cJuB/x4H+fFgXqTI5yYlxjOjxN+
WCWc50T9V3KenOh/tPCoE/Hv5Xy14/kK4fXteH85560d8ZcJ29qxX+/h/LVj
f0QJz+3A/RLJeeyA3ruEd3WgfndwPjv0/fbcUuFvO7CPb+O8dsKPS4Qf7sR+
WcT57YT+hcLVnfr8Fbdynjt1vvHka13Yn+Q4F+438nYXziOXu5Af+awL+m/h
/HehXuRVXfAfeWsX+kc+0oV5X8D90IXzyZe70J/53Bdu7acY8mY39lc494cb
8zxP2HQjHvmSG/W6WfjObuyrm7hfunFemHBhN+p/I/dNkOcK/9KNes/h/vFA
zw3CSR7M62zuIw/6MUu4w4N5msn95MHvlRnCC3q0vohQ7qse1Ot64X3gyOu4
v3pwfojw+R7cR9dwn/Vi/0wTfrIX37dwv/Win1fG/uemXr0vZv8jPNSL+v8t
PKsP8f4SVn3Yt38KZ/bhPpoQrg3y78Lf9GGeyNMN1Ie80IC+X4VjDeQzJvxM
kC8Ipxq4r0eFcw348SfhMgPnnxd2GPDHsPCAofTHD8I/G+j3d8JXDPTnnPA8
L/IfFI72ol9fC6/z4v76QjjFq+fN/Ex4L75fcVa4xIvfVwPCLV749VPhfi/q
dVr4Ry/2ab/wZDC+X3iOiXnzCUeZyN8r/JiJ+vUJW034q1c4y9T12N8jfNCE
Po9wvQn/dwsbJu4f8rlgPLfwRRP+IM/woX7kpT7sf3K8D/mRk334/UNO92Ff
8rwDwefkKt9UvW4f+s18vvQhf/K4D/cX8w/xQz/rE+FH/w3hB/yYb9Zzgx/3
ATnNDz8wXp4f9wH1H/NDT6ew04/+OYTPBOPZhUf90Ncs/C84oVE4/BT8Xye8
EpxYLbw++LxCeEvw+THhnFOIfzTA/wEfl4bI
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlg9M1GUYx8mBK6Lsj5tYi6icU6eNohlbo97MaTJa4Jp/6rKJeoNc47RR
KqRIkkjKYaEFkomHcqCeB3fAAQfc/e5AqqNWOZlN19GKXDBXTozZwu793p5v
Qzd1n/1+7/M+z/f5Ps/vHsvJX7lpWkxMzOXIX/2//HEsH95RObboxSitUKWj
2R4rea3akh4/VCHsy1Fms3nkAJ/nqcD4vEv7hVW+GrJZuj/m+1tVvSW9vFw4
XKDmm6xL9vH8dsTbK5xcpExWo+Ajxtul4odsf+4RTtmt7zN9yPglyK9EOGuP
ujHPNIPPw6VT37fsVampqS5yzD5VU109m/Ery/V5Kzl5P+KVCjsPqLFsz1Gy
sup4qcw3txL5kFMOqpWepFLWN3EQ9Zcx/08UshAu+1QNhkIhclaVioSzUb/E
Q/r9YuobPqRmOpavp/72w/p8Jvtj+Uz3I539S/tc9zft//5W6/hPsP8D1dCH
5ytrcJ73rTmi8zeYf3It7mO9V2rVo6Wj31Nf5xfQf7fwtqPo907q9yX6XSQc
e0zXM7yDeh5D/YXCoWP6vJnvp9TpfiR9IFxVh/vJE3VKh+N9puPo9y7qf1wN
75jpIM+xQZ9i9sMGPchjNujFerLq0V+yux79JyeewH30Z9EJVRgpkBw+gXrI
S0+qSLjNZPtJ6EdOaEB+ZEuDru8m7zvfoKzGuJ2cZsf75Fo76mU9MY16PuPJ
GxuRH/UYaEQ+1G9hk55HC/WtbEJ+7Mf1Jh3/SfZrzSkw++k9hXh8nnwa+fL8
ntPwB+NfOT21X5ln4Dfm6zyD/rK+mQ74hfpsc8Cv9OMlB/rD+VZnsa/4fv1Z
1MP4sU7d3zjWv9iJ/cj8c524f7twjRP6vU+/OnV98wqEJ53q5Ygg79K/zeAt
wjnNeD+ffm5Gve8I9zeryL/Fm+lvPA/lCS9owflc+r1F61dtFq4Az95E/7fA
3xuEr7Wg/hzOgwvztV54lQv7+C3Ohwt6rhPudCGfNzkvLnwfTMJJbvj1Dc6P
G/4gl7ixD17nPLkRb63wiBt+Jie2oh9rhDNasV/JRa3w02phR6vWu4ocbtX5
ryY/0Ab9yEvbMB/k99qQ/yrO5238023vJ7RjX5Cfb0c/yZZ27A/y8Xbtn3Pk
8+3wB+uZ7sH8kNM82Hfktz2on/rUeuBv8rfR59Q3pgP6kp/uwD5iPzZ2wP/s
3+EO7A/ywG18swP6khd24vtPXteJfjB+JdjM/I1O1PMa90knvj/ZwnO7MN+v
cL904fucIVzeBf8s477pgv+WCF/tQv0vcP94sX+eE17pRbw07iMv4j0j3OaF
31O4n7zIb5HwQ934fTCf+6ob+s0V3tmNeh/n/upGv5OEf+mG/x7mPuuBfrOE
l/Xo/o8+yP3WAz/dJ9zUg34kcN/1oJ67hO/thX/iuP960f87hLf2Yh4nR2Uf
9uL+m8IXejH/N4RjffD/deFHfNCXzxf7oMffwq9G358QzvVh3zD+bh/m+R/h
Gh/21b/CLp+K/FvM/EI+/F64Jfxb9H7WM+mDX6YJz/JjPmO5f/1T9Vjhhx7T
uY/90ONO4UI/fh9Szyo/9IgXPoPzmdS/3w9/3SP8sx9+mMH97Uf97N/9BvzK
5wsM6M94Lxn4vcn7TdH3mX+BgX3CeisM+In6NBioj/r6DNTPflw04Jdx4Ws4
b/9L+O4Avm9XhecEoP8fwukBfA9/F14VwP76VTg/gHhh4bIA5ueycF0A839R
uBPx118Q/jGg53H8B+GxAOr9TjguiPtCwklB9H9A+Nkg/NEnnBXEPjKE83C+
KiBcEkS/g8JHoszz7ij3Cw9Gz58THgni+8v7bwUxD18JJ/Yhv6+Fn4ryN8IZ
UWY9G/oQb1C4qA/+0Of/A577iIs=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln9M1HUYx6lFW+Yq60q0RJrOkdNGsSVro33KJuFoCW2G22WJaKEtkEYR
UCpxqcw8UEAPEPnNgXAe3B3cHRzcL9I/0M31w9loQStyg1UrcYw/rPu8r+fN
ug3Yi8/3+/k8z/t5P8/nns7Jz9p3b0xMzI+RH/1XPmtNs5nDc5tfjlK6qrdY
LEu8S5UabJfJ/hx1KHXZjaX1PHV1YmKCrPLVXKa7aen5Qv38W+SpIuWON816
+f6nymBL20NOKFORcNwe7ncYz7uFk46qLHd8LNlfrmxp04uDwjsqVCSf6y6e
Z1LtBamVTuGCY8ocnE908PwTarrEYOsXrqpUr0X+YWc8J9X+yMcmbP9KRdJv
62V8ZujTI/x+lQrNJ05aGW81uFN4oRp6tTP+0zi/Vfj4GRX5faSZ+dTo/dOa
hONq9XpMI/OrVcnJyQ6LsLUOep9lvmehT41wyjl1J9FoPs38Lfr95CrhKxat
f0o19ahXzxjNr/D57Aatb+YZ6tMIfbj/rUZ9Xkkt9ToPP9UJFzehvoxPXYA+
54Tva0Z+9dSzGfVqEJ5oRn7MP6lF+8F0XrimBXpQr4UWHd/MBWFjq45nVQv1
b9X1yKD+69ugfxvr0Yb6sF5zbdqv0x2sT7vW8+EuYWc79GP94zp0fsZu4bIO
ZTQHi+iXqQ7Ef1H41U6s01/WTtS/T3h5F/QiF3QhH/rz2y74i+spVvQP92u0
oj48L6Zb62tlfLnd2v81zOdKN+Jnvpt60H/Up6oH/U6/3u5Bvah/9kXox/qN
gJ+lXxN6cT79UdGr+2vdkp96sT/9mNGHfM30F9hyUthgw3ol/WbD+8eEJ22I
z0T/XYKe5PZLmG9f0o927f8g33/BDn2O0592+OeEcL0d/iBP2FE/xnPXDn+R
k/pRD3JOP/xDrumHftzv637Uk+cvRJnxbRxAfzF+4wD6k/mdGtD+mv+C/h/Q
7x8sF/5rAHocYT841I22gtTDwjsd0Psz9ocD86VU2OtAf5awXxyIp1g43qnr
Ef8J+8eJ+VwkXO7Efh+xn8AlhcIzTq1fzCH2lwvzLF94uwv1/ZD95kI/fCBs
c0H/g+w/F/I7IPzooI5nWR77cRD1fE/440HM+/3sz0H9vm+f8A9RzmW/DuH8
vcIvDaFeOezfIfiV3DoE/fawn4fg33eF73dDn3fY327cn+QDbvh3N/vdjf4l
X3OryPX159vsfw/8TH7eA7+Scz3od3KdB/erkfPBg/O5vuhBPjxvkxd+Iu/2
ot/5fpUX9yk56EW/kW97oRd5wzD8w/Oyh/9/fuUw9iePDMMvPP/3YfQDOWEE
+ZCzRpA/9awAXyYP4vlM1uPWCO4X8mof/MX6Zfgwz1jfz304j2z3Yf7THz/7
cN/SP4ZR6E9/bRuFn8jFo/AH/dgzivuDfp0cxTzh8w+NYX+er8Ywv5hfYZSp
d/sY9Ngl/P0Y+mUn56Mf8/xN4TV+1GcH56Uf8b8u/IYf9Uzn/PQjn23CR7Gf
bSvnKd43KWGHH35O5XyNnv+i8K9+1HsL5210/2ThlQH4PYnzN4D9NgunBxD/
Rs7jAPp/g3Ap1pvWcT4H0K8Jwn0BfB9Yw3kdgH9WCf8UwDx7gvM7gPgfE14R
xPeXFZznQejH9a1B+M/A+R5EPI8LFwURL/c/hfX4OOGuIOJlPH7sb1otfDMI
/Z/kfRCEfk8JPxhCPzO/9VGOF04Nwe9reV+E4Efulx+CHit5f4QwL5hPS0jP
p4JHeJ+EMA+WC38TwvfzB3i/hNDPscKxYczfe3jfhFGPu7P/8ZYw5sWi8I4w
9L4jnBeG3n8Ll4eh1x/CDWHMl1lhZxjz+Dfhq2H0zy/CM2HUZ0r4nzDm76Rw
3Dj68abwc+Pw53fC28cxX64L7x1HP18TLhvH/af5X6LahH8=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdl31M1VUYx1nT/iBns1iRTcRsjlw2rGX8Ee2ULrJYIX+YbrcX8SXQCqRw
hCyTpIxlQKHJiwjcC1zeLhfuBe77O0oFlmmSRgvacm6y1lo25h/VPd/fnm+7
3s3LPjvnPOd5vs/Lua4qKM7ffVtSUtLP8X/6r3z2Zye/HJ1f97RBm9X8Fldr
hLxd6W9yqEDZcuYqwlwvUn9nmO4kq2I1bS7xh7i/VOW70qrJs2UqxZazg5z0
ntL3k9Mr1Z74h6wOJZ7PPHyL/SplKclO5v15R3CePFut7U+TSz7Gff/H94mK
m79OrqvR9mqoR/qnqvr6lqyYsP2YMtVGbpBVLfwZFy6s03rUnqG/9So5vuGs
8EI97p+g/5+rg3FBvhI++oV6yFT7zNeMpwH8jXDqcTU1OZk7yfiOq+iNDNOU
sPUE7jvHeL9EPN8KZ51UcTnM3zH+Rm0/cl54olHrd/V76tGk9V98UXhbs4qH
n/ED9WmB/5eEr7Ugv9PU6xT8+VG4vBV8mfqdhv9XhBe1af9W/0Q927T+LvJk
G/QnZ7Ynrje0a/t/0N5Cu2pqbGzkfaYOfd8M/Qt1oD4Yz4Nm6HOB+TAjX9Rn
3oz7qW+eBflmPpwW+M/8pXaiPpj/yk7Ey3qZ7YS+rLdNXVrPs6xva5fW2xoQ
XtKNdR/zC87xCl802MN8W3U+5tzCLVbcx/WkHvhP3tWDeGlvogf2eN/DvVj3
sz56kU/691cv9A6yXvoS4/H1Kf2H/Zbej/jYn0f6tV7ZPH+tH/nh/bkDWv8y
+msf0Pfd5xJOsen+mBxhvdkwPxzCM1jPHWL9DSJfg8KWQcyTAdajHXr1CW+w
6/mY1sP6tKuV8QLsFm6yq7mKFFsn69WO+WER/seO+ulg/Q6B24ULhhA/uWEI
+rUJnxmCvuSFIehHXjuMeUY2DSNftPfZMPqbHBpWz81VNNCfP4cRj5n94EC8
9H+rA/6SjzqQH8brcaDeu9gvDvhHfdKc8N/K/nEiP9Szyon89rKfnJgn1P+q
E/nrZ3+NQF/m6/kR+Gtjv43o9+om2Yb1VuZ79pbzd42ifujPplHox3gOjGJ+
UC8r2HRa+Iqx3sx+HcP6SeGnxqBXA/t3DHrXC3eM4f5j7Ocx9F+N8O0u6PsR
+9ulHot/PhTe64Leh9jvLvRHpfA5F/q9nP3vVvq7TPhRN/p5P+eBG/PjLeET
bui/l/PBDX/2CN90433YyXnhQb5fE37Vg/lKrvMg368LRzywv4PzxAN7BcJr
vPi9QfvbvMgvucaL+t/FeeNFve8W/t2LeOhvug/rbwjn+3C+kPPIB/tFwqM+
3L+P88mH+fGm8HI/3mvqletH/b4t/L4f9V7M+eXHvCgR/tWv6+E89U8JoP+5
/mwA/Uf75QHdvyn0pzcAvej/TAD1RV4aRL0wHhVEfTCfpUHMO9qzBHEf+VIQ
+jDeRaHE+lgRQv0z3g0h1DvjfclgxlMYSoz3sMGlnKcGvyPsCKE/3uV8DeH3
C+v3t5COz3GA8zaE+uL5e8M4T38yw4n52xzG71vqVRDG/ayng2Hoy/psCKv4
9wevCA+EEd92zmtj/1bhX4z9+Zzfxv4XhZdFdD088gLneQT7c4Q3RrB/I+d7
BPaVcJmx/0nO+wj8zxLuNvY/zvkfQbzrhS8b+9fxPYhAn7XCd0Sxfw3fhyj0
fEA42+CVfC+iqO904eIo8rGK70cU/vB8exTzhOyJol5XC1+IIj7yPM5byYtj
mO/ktBj+P0B+IoZ+pv28GOY7uQjrFfSvKqbrfR/9b45BD8bnjOH+FcJThv37
+V5hPWO58L8Gp/L9GsfvjXuE14+j3+/mezaO+5cJ7xxHPy7l+2asL4nzfx6s
kx4=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlWts02UUxhsz/DCJRtNEMHFqRDOJmukS3JeaV12cF6JsKhett4nNRCMT
HeKGOJAZJGbT2BA3EdZ1Y93Yut4v6739d6J2RAM6JTM4ohNZQ4hxZuGD2vdp
zpPIB+h+ef/vOec9l+fc1Ly16eXLTCZTsPRP/56rsN/i2XRYlf40XSjecZ/+
NVX0q77e3pXnhVv6laVy5uaicKFff995TrjGoW7oWmj8Q9juULW1tf6zwksO
9dBcu51sHVC5xepZcnpAmd0NL/L+KqdqilQto/19TjXXbnaTi04142y1LAiv
G9TxOcmBQX2eIK8YUtaebBt555AqhRuhvV+G9Ht76b/+iIpUdb36u7DriI5v
7lfh5cN47xnh1mHVYXZ/eVr45DDi+1m4zoV8nBI+6FI92cXqH4VNI6rYGDn0
vfDmEeT/hPCxEeTvW+HbR9Xf1darjgt/DO75Rviv8vlXwhuP4v6UcPyo9ldl
CN84pvNRlxPeO6ZK6Wzl+dkx5D8vvHZc2Wy2edrzjMPeMWGzW71hqdxA/zvc
arDVsv9r4Vk38sF41YS6rVSggvDgBPxNsx89yDffu8aDepNbPLhP7sP335EL
l/A/HjVdKBTINV7Uj9zs/b89uxfxkqe8un4u8pIX+SWv9qnS/51kqw/9Te72
afv3k9M+1Jv8p0/33wLfv8oP/+T1ftSHvM+PfiJP+vFe5rPoR/+TqwK6HpXk
dQG8l/XbE0C8rHcgoErtfzEjPB9AvyU5X0HoQ0z4kSDmK8x5C+p8rw0Iu4M6
X2Yv5y+I+fIIXxNC/XleH9L+233C20Ow5+d8hmCP9k+FdP/NkJeHUZ+g8L1h
3A9xfsO6XibGOxBGfckny99HhC+P6P63kesi6Cfa2xJBPujvYAT1YrzHI7DP
95miiHdC+O6ortfiOPUgCj0cEz4QRf1GqQ9RxO8SvhhF/wxRLybR307h5yah
dw7qx6TWY+th4SzOV35BPSnf7xO+NQZ9/Iz6EkN8B4T3x2D/U+pNDPrwifD5
8nk39ScOvfpIuCmOen9IPYpjX3wgHIpDr/ZSn+LQl93C1yXQ/7uoVwn0x07h
XThvfIf6lcD97cJnEpiHN6lnSdST/GAS99+iviVxv014NIn7tDebRH52CF+Z
0vlsoH+Vwjy1C29LoR86qIcp+H9X+IcU5pnvq0ijPu8JX59GvpmPNWl8v0f4
8TT69X3qZxr60SW8O439Se5Lox94359GP9N/oeyf8f9W9v829RZ8iHxtBvVl
PmoymC/m4+EM+pv2mjPQA3IH+E7mx57R+e0ij2cwX+SpDOaffDqD/UxeymCf
0P7VWdSP8azOwh7jfSCL/cb3WMEzrH9bFvGxP7qzyNc24eEs4mml/uN79+vC
P2Whn69xH5R5i/AVOXAL90OZbcKWHOq3mfsih/o0C2/NYZ5e4P7IoT+fF3bg
vuVZ7pMc+vMZ4RM5pX+e5n4pn28UXmagvzdw3xjor/XC9xiw/xT3j6HtdT4p
/Iqh83XhCe4jA3pB/tyA/pADl/C0gfyS5w3Uh/yvgX1DXpHHPDQK35VHPz3G
fZZHPz8q/FIe/dDA/ZbX+7m2vsT/Ab9k1K4=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlmtoW2UYx4M4P1RRlIAiWisOqUNFHei+VF4vWB0FXcGuQhB3cehE1oqT
0cqoY9FatKlYp+1Ecb2lWZvlnpP7yTknbdVMnZurc9WtXkqlRausMvZBzfsP
zx8aaNMf7znP+3/uvXX7nubnL3O5XP7Kj/4+WzfdftNfw6ryp2tl+a6H9Lfr
hhHVbNSu+1P49REVbJzvWBY+P6JqZodWfhd+dFTNd7jvXhT2j6rBgYGBBeGr
xpRR6136VbhtTG2sfH4RPjWm7++aF97kV+0NNbPnhD/2K+/Slk0/CbvG9X3B
OeGd42p2qK3hrPDMuLJX6+fOCN8ZgJ7vhfsCWs9Ls8IXAvp5z2nh1qPKHWzc
9p1w9ij0nRKum9D6oyeFD04gXuTFCbWr8vlWuGlS25s/IRya1PFrI7uD6vGK
Q+R9QXW8XC5/IzwXVMtbjE/I6pj6p97jIw8fgx7y5SFVCd9ttHd/CPkiv1Bl
6hsMqeG2hhr6Vw4hP/T/39Da+NwT1s/3MH7bwzo/BuPbH9b+LzD+U2H4x/xc
DCNfzN+GCOL1o7AnAv+Y794I8s16MCPqFu/SifPCf0d0flzk9VFtP0f7LVHl
8Vl7qac7qnzWaj39SUdhj/FYjqLevxaujSGeZeGnYtqf/i+FD4Dd5FhM14P3
C+GFGOr/c/ZXXN3h8T1M3hxHPGfYb3HV6Q5OTwsH41r/6hT7L67jcw35uoSu
j9oS+7HKjvBrCTxvsz8TyH9R+IeE1mOZ7Nck9BeEH0yi//Ls3yT6Kyt8JIl6
zrCfwSsp4SsM1IPB/jYQX57vNlB/afa7gfyTv6qe074rpfPdRb4vhfiSd6Z0
/zRR36GUzt8QeSYFfeRLKfiX47xIwx/ys2n0H7kvjXiRrTTiQb6Qhr/k2zPQ
R27NYB6QezLINzmbgV7yHxnUL7kuu1Zvcxb26c/BLOJHTmRR7+RFvG8wXjfm
0O/kphzuZ/z35zDfyKGcns9bmb+fc5ivzK87j35KCj+WR/0mON/y0B8XDuTR
T2HOuzzyMyl8dUHHpzHA+VeAvlHhVwq6ni4d4TwsQN+nwqcLmB+HOR9N1NNH
wjebmPf9nJcm4tMn/KSJ/n6X89PE/nhb+A3Y63mT8xTnS28JR03UI58vm9DT
I/xb1f47nLcm+oP3XV9EPfVy/hZhj/qeKELve5zHRcyr94U7i4gv/esv4v4P
hCer7/N8qoh48v1z4A7yxSLmN/laay1vsFTldxf5EQv5JHss1Cfv22shX9TT
a6E+DgmPWajPDzn/LcxP5u+MhfwNcB9U7x8UvtJGvfB8vY3nab/BRj1QX4uN
feoT3mNDH/PTbaOeu4U/sxFfL/cJ3t94QPikjX2+n/vFxr7rFF7naL2ufdw3
DvrpVeEHHPx/1c7942D+vCz8ogN9u7mPHNTfLuHDDvK3g/vJwT54Tvi4o+eD
38N95aC+nhH+z0H/tXB/lWDvaeF7S9DP880l6CPvKMGfrdxvJfRLa4X/B09c
j0k=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ3buyW2/X140OQCbDhze6jiCa4cdGh8NfNe68h/G1
NjloxvQfegPjx2xymDVz5syXMH7fJgeu64sLnsH4BzY5tL4OtHgM438Cy394
COOrbHZYUmDLBZcP2+zwJnCH3BMYv2OzgzEQPIXxd20G2e8EN//NZoezZ874
PIfx5bY4yAMtfAHjB0D4cPc1QfivYPwtWxyqRda5v4bxn20BuxfuP4mtDrZc
15XfwvheW8HufQfj12x1SEtLewbnr9vqAPT+XlB4zVka23lr71Z4eAIAkh6A
Yg==
       "]], LineBox[CompressedData["
1:eJxd019oUlEcB3CJejEoAqE/kBX1YEWjCKoX4ZdBqxgsfYgefDKSoodZsRha
USNhCCWEVLparRkbq2zhGpJXvffca3uYCyrYGixqUWOg1AgWvfTnnl98D5Qg
+uHee8739/uduyHUFji+yOFwBOyv/I2G3m792Vok+69jvrFtr/x1HC1SwR0/
9RVOFCnmyo3WYa1ISbHgmYO/FClgP/AJXq9ROBye/QAHNNocTPrewVc0avgL
PVPwiMb7T8BzGpkLnuBreE2J4nV/4SXcUqIDM1HXGHyxRM7JvsgoPFSi8Vqt
ZsIfS5xXh11lzqvB+8vkyjXPFOCOMn33BJePwINlmdf9DJ4uUyadXj0ML6tQ
NuJ15mGqyP7Vn8JnKrJ+MQRn+f7EE3iCr/ty8GKd7NsXHsFrdblf+iG8S6ed
9mcQbtV5/QH4hC7rb+mHL7NrD+AM3+/LwnleL38frunkdU5u7IU/67Lfqbvw
L53n1QOvNGTe9tvwdkPOYz4DHzTIbm80DYcM7t8tOGbQunj91Q04ZfD6yo95
vchN+IUhz8e0ev69wfWq/X4YfF664RWC538H3iK4HpV/n+D97sFBIc9vWNXf
Lrh/qj/XBNnHr0n1r1/weVL91QW/L33wlOD61frfhMy3R+VZavK8Vd5N5r95
vSbXr/IeMXneah5tJp9PlbfL5P1U3t7/rj83uT9qvTemzNus5tcwuV41ryUW
91f1323x/il4t8X1XIcPW7I/uSR80uL9r8Kdlny/kgm42+L+d8HDFtcbh8ct
fj874VlLnhf/Jfj33zwX4FVVzhODd1Q5Twd8qMr9PQcfYw+chc/z/U2nbf8B
JSnC1A==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw900tIVFEYB/BLNJuMIrikLZqIWlhQFEKthK+EyghKF61mZTQULQxBiLFF
BUKrZuNmDIRQ81FOD40GwzvncW9CjIEUSmGPoRyqmR4ERriwzvku/zNwufPj
nPs97nfuzo7O9vPrPM9rMZe9X9torq0Bmb/er9q+I/buHQuo1lYY+AlfCajJ
/JzHA1ocvDzzA14KaE8qe9R5U5F6q22F7zAVbbykc1eRUlnVXYOH4v1VeKFI
hWRv9Ru8XtCfxtRm5+2C+nO5bV/hQ/H6F/i0sPFXKvAFQT1+fnYZvi6o3ST4
DPcLKmf8/Z/gyXh/GS4J2mEK/Agvx+vv4bX4+XdwveR+3sIHJJ0oZ/oW4VZp
+7v0Gu6Q/P7m4R7e77+E+ySl0+nKC3hC2nlMzsLPJeWPlzMh/CGOJ+G/0vab
COAtiuufhvcqfh9P4RbFz0/BKWXjrz6Eu5XtNz8B31K2vvQ4PKJ4PiOwUPb9
zd+F33C+xCj8W/H8xuA6zfU579bcv3Oz5vPkfFbbfDmXr5PXB4bhm5o2mAM7
CN/R5JuGnKc1zZVKp9z+V5rn5+qtaZ6vqzcRUrMJ6PInQ+73Hnw45Hnfh8+w
/Tx8MV5/AN+I1x/Btzle7jE8xfl2uXnMhWSO9+gTuBLy9+nm9y/k77MAN0Tc
n5v3wYj0SuPSM/hkxOdxBj4X8bzdebka2flkhfF/0CJ3zw==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF0TtIHFEUBuBBSLNWASFWK0IKI0QUEW0WjlqEiIVaWG0TxYBYaAqbmCIR
FqxcC5tVEETBNBF8hfWZ+xoVGYNRiZEgRogK7goiLCQQ1Lln+W8Ghjsf9zHn
/Le0o7etq8DzvJrwteNI7d/xf92Cwk/vJvu83o7eB0GJTGvdNTwm6OxtUcUV
vCAo25qOXsKBoOm+WOQ3fC4ocjR18wu+E/QmFjk6gZ9IaktHEz/hSkm7QRAc
wy8ln/cD7pBcz3d4QJLOlcUP4VFp/9e3D3+Stp/3e/Bm3l/hU0nxpOoP4D+S
XofPDvxY2Xqat+FyRUmVK9uEGxXnZeC4opJE5puE+5XNZ+ILPKwobLdnHZ5R
3M8qLBT3uwwf8/rMZ/hWcZ6LcKGmZ/FkwwL8VHN983BM8/45uF1zf26+V3N/
bv8Qr+9x509qrn8JXtFUNPvizNVzkP9fGs5qzt/V/8jY/tIrcNRwXmtwraFw
eczl0WL4PjbgbmPP/+jyGzScr4DHDffn8l7k/TkF7+bnNXyR3+/u697QWCqV
8uFinwbCBt39Vvm83rnJp+rw2YI7fZvHK+d3//0AaI4rMg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{10992.088607594727`, 980600.}, {11000., 
       980599.75}}]}}, {}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        GraphicsBox[
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          CircleBox[{0, 0}]},
         ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{621.024701, 
       980.24164}}, {{1035.041169, 980273.11}}, {{1035.041169, 980243.6}}, {{
       1449.057636, 980246.3}}, {{2484.098805, 980253.92}}, {{3105.123506, 
       980303.}}, {{5899.734661, 980383.9}}, {{8383.833466, 980413.}}, {{
       10867.932271, 980451.}}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980231.07}, {0., 980231.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980277.97}, {0., 980277.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980320.48}, {0., 980320.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980341.71}, {0., 980341.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980384.25}, {0., 980384.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[1.], 
      PointBox[{{0., 980384.98}, {0., 980384.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980414.29}, {0., 980414.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980443.97}, {0., 980443.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980454.3}, {0., 980454.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980469.47}, {0., 980469.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980492.18}, {0., 980492.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980508.39}, {0., 980508.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980527.61}, {0., 980527.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980546.74}, {0., 980546.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980552.24}, {0., 980552.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980573.66}, {0., 980573.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980577.67}, {0., 980577.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980602.98}, {0., 980602.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980613.24}, {0., 980613.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980640.74}, {0., 980640.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980649.82}, {0., 980649.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980650.56}, {0., 980650.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980657.77}, {0., 980657.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980661.37}, {0., 980661.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980679.88}, {0., 980679.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980684.45}, {0., 980684.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980726.06}, {0., 980726.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980730.85}, {0., 980730.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980736.}, {0., 980736.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980743.88}, {0., 980743.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980758.07}, {0., 980758.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980758.66}, {0., 980758.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980763.59}, {0., 980763.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980766.6}, {0., 980766.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980801.98}, {0., 980801.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980803.48}, {0., 980803.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980819.25}, {0., 980819.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980821.74}, {0., 980821.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980831.13}, {0., 980831.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980849.63}, {0., 980849.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980861.81}, {0., 980861.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980869.92}, {0., 980869.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980879.3}, {0., 980879.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980882.31}, {0., 980882.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980907.99}, {0., 980907.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980913.09}, {0., 980913.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980935.83}, {0., 980935.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980940.43}, {0., 980940.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980941.81}, {0., 980941.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980968.97}, {0., 980968.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980987.17}, {0., 980987.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980989.59}, {0., 980989.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980999.52}, {0., 980999.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981004.75}, {0., 981004.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981034.69}, {0., 981034.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981036.51}, {0., 981036.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981058.12}, {0., 981058.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981065.06}, {0., 981065.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981079.53}, {0., 981079.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981090.66}, {0., 981090.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981096.65}, {0., 981096.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981098.24}, {0., 981098.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981107.64}, {0., 981107.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981132.08}, {0., 981132.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981169.64}, {0., 981169.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981170.7}, {0., 981170.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981180.92}, {0., 981180.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981183.99}, {0., 981183.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981195.02}, {0., 981195.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981205.65}, {0., 981205.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981231.22}, {0., 981231.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981269.18}, {0., 981269.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981277.87}, {0., 981277.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981298.49}, {0., 981298.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981301.02}, {0., 981301.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981312.1}, {0., 981312.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981312.37}, {0., 981312.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981356.05}, {0., 981356.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981382.68}, {0., 981382.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981417.75}, {0., 981417.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981418.17}, {0., 981418.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981424.34}, {0., 981424.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981429.16}, {0., 981429.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981478.84}, {0., 981478.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981487.54}, {0., 981487.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981537.63}, {0., 981537.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981544.98}, {0., 981544.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981547.92}, {0., 981547.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981607.92}, {0., 981607.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981659.91}, {0., 981659.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981669.66}, {0., 981669.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981732.13}, {0., 981732.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981774.1}, {0., 981774.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981789.86}, {0., 981789.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981855.98}, {0., 981855.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981908.75}, {0., 981908.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980231.8}, {50., 980231.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.000060724173], 
      PointBox[{{50., 980278.22}, {50., 980278.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00022144867], 
      PointBox[{{50., 980320.59}, {50., 980320.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980341.86}, {50., 980341.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980384.44}, {50., 980384.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99971496], 
      PointBox[{{50., 980384.53}, {50., 980384.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980414.43}, {50., 980414.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980443.59}, {50., 980443.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980454.52}, {50., 980454.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980469.05}, {50., 980469.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980492.32}, {50., 980492.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.9933175*^-16], 
      PointBox[{{50., 980508.03}, {50., 980508.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980527.85}, {50., 980527.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980546.42}, {50., 980546.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980551.86}, {50., 980551.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980573.8}, {50., 980573.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980577.31}, {50., 980577.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980603.23}, {50., 980603.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3818466*^-14], 
      PointBox[{{50., 980613.24}, {50., 980613.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980640.34}, {50., 980640.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980649.58}, {50., 980649.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980650.19}, {50., 980650.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980657.89}, {50., 980657.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.7176735*^-14], 
      PointBox[{{50., 980661.76}, {50., 980661.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980680.16}, {50., 980680.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980684.7}, {50., 980684.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980725.67}, {50., 980725.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980730.44}, {50., 980730.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980736.13}, {50., 980736.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980743.89}, {50., 980743.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.0434863*^-15], 
      PointBox[{{50., 980758.31}, {50., 980758.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980758.47}, {50., 980758.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980763.94}, {50., 980763.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980766.35}, {50., 980766.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980802.68}, {50., 980802.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980803.07}, {50., 980803.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980819.33}, {50., 980819.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980821.3}, {50., 980821.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980830.69}, {50., 980830.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980849.98}, {50., 980849.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980861.42}, {50., 980861.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980870.58}, {50., 980870.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980879.02}, {50., 980879.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980881.89}, {50., 980881.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980908.07}, {50., 980908.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980912.63}, {50., 980912.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980936.43}, {50., 980936.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980940.72}, {50., 980940.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980941.65}, {50., 980941.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980968.65}, {50., 980968.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980987.59}, {50., 980987.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980989.3}, {50., 980989.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980999.67}, {50., 980999.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981004.27}, {50., 981004.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981034.88}, {50., 981034.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981036.29}, {50., 981036.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981058.35}, {50., 981058.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981065.28}, {50., 981065.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981079.56}, {50., 981079.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981090.92}, {50., 981090.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981096.14}, {50., 981096.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981097.93}, {50., 981097.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981107.74}, {50., 981107.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981132.1}, {50., 981132.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981169.35}, {50., 981169.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981170.54}, {50., 981170.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981181.37}, {50., 981181.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981184.49}, {50., 981184.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981195.47}, {50., 981195.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981205.32}, {50., 981205.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981231.07}, {50., 981231.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981270.01}, {50., 981270.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981277.52}, {50., 981277.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981298.22}, {50., 981298.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981301.66}, {50., 981301.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981311.75}, {50., 981311.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981312.98}, {50., 981312.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981355.78}, {50., 981355.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981382.3}, {50., 981382.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981417.35}, {50., 981417.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981418.91}, {50., 981418.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981424.04}, {50., 981424.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981429.83}, {50., 981429.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981478.48}, {50., 981478.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981487.19}, {50., 981487.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981538.41}, {50., 981538.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981545.57}, {50., 981545.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981547.7}, {50., 981547.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981607.56}, {50., 981607.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981660.58}, {50., 981660.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981669.37}, {50., 981669.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981731.72}, {50., 981731.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981774.83}, {50., 981774.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981789.56}, {50., 981789.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981855.48}, {50., 981855.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981908.44}, {50., 981908.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980232.52}, {100., 980232.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00025383978], 
      PointBox[{{100., 980278.45}, {100., 980278.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00087976364], 
      PointBox[{{100., 980320.69}, {100., 980320.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980341.97}, {100., 980341.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99885435], 
      PointBox[{{100., 980384.13}, {100., 980384.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980384.62}, {100., 980384.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980414.52}, {100., 980414.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980443.26}, {100., 980443.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980454.73}, {100., 980454.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980468.59}, {100., 980468.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980492.41}, {100., 980492.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7772765*^-15], 
      PointBox[{{100., 980507.72}, {100., 980507.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980528.07}, {100., 980528.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980546.14}, {100., 980546.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980551.42}, {100., 980551.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980573.89}, {100., 980573.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980577.}, {100., 980577.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980603.47}, {100., 980603.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.3846027*^-14], 
      PointBox[{{100., 980613.26}, {100., 980613.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980639.89}, {100., 980639.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980649.28}, {100., 980649.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980649.87}, {100., 980649.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980657.94}, {100., 980657.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.9409734*^-14], 
      PointBox[{{100., 980662.21}, {100., 980662.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980680.44}, {100., 980680.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980684.97}, {100., 980684.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980725.34}, {100., 980725.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980729.96}, {100., 980729.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980736.29}, {100., 980736.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980743.8}, {100., 980743.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.9934976*^-14], 
      PointBox[{{100., 980757.97}, {100., 980757.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980758.89}, {100., 980758.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980764.31}, {100., 980764.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980766.07}, {100., 980766.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980802.73}, {100., 980802.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980803.38}, {100., 980803.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980819.45}, {100., 980819.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980820.8}, {100., 980820.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980830.18}, {100., 980830.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980850.36}, {100., 980850.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980861.06}, {100., 980861.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980871.24}, {100., 980871.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980878.72}, {100., 980878.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980881.54}, {100., 980881.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980908.18}, {100., 980908.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980912.1}, {100., 980912.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980937.02}, {100., 980937.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980941.06}, {100., 980941.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980941.46}, {100., 980941.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980968.38}, {100., 980968.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980988.02}, {100., 980988.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980988.97}, {100., 980988.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980999.85}, {100., 980999.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981003.71}, {100., 981003.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981035.13}, {100., 981035.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981036.1}, {100., 981036.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981058.57}, {100., 981058.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981065.47}, {100., 981065.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981079.64}, {100., 981079.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981091.22}, {100., 981091.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981095.56}, {100., 981095.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981097.57}, {100., 981097.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981107.83}, {100., 981107.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981132.18}, {100., 981132.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981169.03}, {100., 981169.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981170.47}, {100., 981170.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981181.85}, {100., 981181.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981184.98}, {100., 981184.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981195.95}, {100., 981195.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981204.95}, {100., 981204.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981230.9}, {100., 981230.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981270.84}, {100., 981270.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981277.21}, {100., 981277.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981297.99}, {100., 981297.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981302.29}, {100., 981302.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981311.36}, {100., 981311.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981313.6}, {100., 981313.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981355.47}, {100., 981355.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981381.96}, {100., 981381.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981416.9}, {100., 981416.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981419.65}, {100., 981419.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981423.75}, {100., 981423.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981430.53}, {100., 981430.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981478.12}, {100., 981478.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981486.84}, {100., 981486.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981539.19}, {100., 981539.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981545.91}, {100., 981545.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981547.79}, {100., 981547.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981607.15}, {100., 981607.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981661.22}, {100., 981661.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981669.17}, {100., 981669.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981731.25}, {100., 981731.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981775.54}, {100., 981775.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981789.33}, {100., 981789.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981854.92}, {100., 981854.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981908.19}, {100., 981908.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980233.24}, {150., 980233.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00059648022], 
      PointBox[{{150., 980278.63}, {150., 980278.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0019609333], 
      PointBox[{{150., 980320.77}, {150., 980320.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980342.05}, {150., 980342.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99741517], 
      PointBox[{{150., 980383.76}, {150., 980383.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980384.79}, {150., 980384.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980414.58}, {150., 980414.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980442.96}, {150., 980442.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980454.93}, {150., 980454.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980468.09}, {150., 980468.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980492.46}, {150., 980492.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.2018006*^-15], 
      PointBox[{{150., 980507.46}, {150., 980507.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980528.28}, {150., 980528.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980545.9}, {150., 980545.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980550.95}, {150., 980550.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980573.92}, {150., 980573.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980576.74}, {150., 980576.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980603.7}, {150., 980603.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1809171*^-13], 
      PointBox[{{150., 980613.31}, {150., 980613.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980639.39}, {150., 980639.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.9040435*^-16], 
      PointBox[{{150., 980648.94}, {150., 980648.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980649.61}, {150., 980649.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980657.92}, {150., 980657.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5733492*^-13], 
      PointBox[{{150., 980662.7}, {150., 980662.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980680.73}, {150., 980680.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980685.27}, {150., 980685.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980725.07}, {150., 980725.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980729.42}, {150., 980729.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980736.46}, {150., 980736.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980743.62}, {150., 980743.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.4313284*^-14], 
      PointBox[{{150., 980757.66}, {150., 980757.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980759.34}, {150., 980759.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980764.72}, {150., 980764.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980765.78}, {150., 980765.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980802.45}, {150., 980802.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980804.07}, {150., 980804.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980819.59}, {150., 980819.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980820.22}, {150., 980820.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980829.6}, {150., 980829.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980850.78}, {150., 980850.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980860.72}, {150., 980860.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980871.91}, {150., 980871.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980878.38}, {150., 980878.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980881.25}, {150., 980881.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980908.32}, {150., 980908.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980911.49}, {150., 980911.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980937.61}, {150., 980937.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980941.25}, {150., 980941.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980941.44}, {150., 980941.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980968.13}, {150., 980968.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980988.42}, {150., 980988.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980988.62}, {150., 980988.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981000.06}, {150., 981000.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981003.08}, {150., 981003.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981035.42}, {150., 981035.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981035.95}, {150., 981035.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981058.79}, {150., 981058.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981065.64}, {150., 981065.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981079.77}, {150., 981079.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981091.54}, {150., 981091.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981094.9}, {150., 981094.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981097.17}, {150., 981097.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981107.92}, {150., 981107.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981132.32}, {150., 981132.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981168.72}, {150., 981168.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981170.45}, {150., 981170.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981182.35}, {150., 981182.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981185.46}, {150., 981185.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981196.46}, {150., 981196.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981204.53}, {150., 981204.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981230.71}, {150., 981230.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981271.67}, {150., 981271.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981276.92}, {150., 981276.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981297.79}, {150., 981297.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981302.91}, {150., 981302.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981310.93}, {150., 981310.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981314.24}, {150., 981314.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981355.13}, {150., 981355.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981381.66}, {150., 981381.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981416.4}, {150., 981416.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981420.39}, {150., 981420.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981423.49}, {150., 981423.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981431.26}, {150., 981431.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981477.77}, {150., 981477.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981486.49}, {150., 981486.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981539.97}, {150., 981539.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981545.94}, {150., 981545.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981548.23}, {150., 981548.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981606.69}, {150., 981606.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981661.82}, {150., 981661.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981669.07}, {150., 981669.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981730.72}, {150., 981730.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981776.24}, {150., 981776.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981789.17}, {150., 981789.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981854.29}, {150., 981854.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981908.01}, {150., 981908.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980233.95}, {200., 980233.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0011065892], 
      PointBox[{{200., 980278.79}, {200., 980278.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0034443585], 
      PointBox[{{200., 980320.84}, {200., 980320.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980342.09}, {200., 980342.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99540015], 
      PointBox[{{200., 980383.43}, {200., 980383.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980384.95}, {200., 980384.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980414.59}, {200., 980414.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980442.71}, {200., 980442.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9158353*^-17], 
      PointBox[{{200., 980455.13}, {200., 980455.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980467.56}, {200., 980467.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980492.46}, {200., 980492.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.6605166*^-14], 
      PointBox[{{200., 980507.24}, {200., 980507.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980528.49}, {200., 980528.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980545.7}, {200., 980545.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2121656*^-16], 
      PointBox[{{200., 980550.43}, {200., 980550.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980573.9}, {200., 980573.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980576.53}, {200., 980576.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980603.94}, {200., 980603.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.3674779*^-13], 
      PointBox[{{200., 980613.39}, {200., 980613.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980638.84}, {200., 980638.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4556042*^-15], 
      PointBox[{{200., 980648.54}, {200., 980648.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980649.4}, {200., 980649.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980657.83}, {200., 980657.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.7671173*^-13], 
      PointBox[{{200., 980663.22}, {200., 980663.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980681.04}, {200., 980681.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980685.59}, {200., 980685.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980724.86}, {200., 980724.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980728.83}, {200., 980728.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980736.65}, {200., 980736.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980743.35}, {200., 980743.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.6657156*^-14], 
      PointBox[{{200., 980757.37}, {200., 980757.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980759.81}, {200., 980759.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980765.15}, {200., 980765.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980765.46}, {200., 980765.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980802.24}, {200., 980802.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980804.76}, {200., 980804.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980819.59}, {200., 980819.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980819.75}, {200., 980819.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980828.95}, {200., 980828.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980851.24}, {200., 980851.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980860.41}, {200., 980860.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980872.57}, {200., 980872.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980878.02}, {200., 980878.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980881.04}, {200., 980881.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980908.49}, {200., 980908.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980910.82}, {200., 980910.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980938.19}, {200., 980938.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980941.01}, {200., 980941.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980941.87}, {200., 980941.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980967.92}, {200., 980967.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980988.18}, {200., 980988.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980988.87}, {200., 980988.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981000.3}, {200., 981000.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981002.37}, {200., 981002.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981035.77}, {200., 981035.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981035.83}, {200., 981035.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981059.}, {200., 981059.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981065.79}, {200., 981065.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981079.93}, {200., 981079.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981091.89}, {200., 981091.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981094.17}, {200., 981094.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981096.73}, {200., 981096.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981108.}, {200., 981108.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981132.51}, {200., 981132.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981168.42}, {200., 981168.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981170.46}, {200., 981170.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981182.87}, {200., 981182.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981185.92}, {200., 981185.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981196.98}, {200., 981196.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981204.07}, {200., 981204.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981230.5}, {200., 981230.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981272.5}, {200., 981272.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981276.67}, {200., 981276.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981297.64}, {200., 981297.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981303.52}, {200., 981303.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981310.47}, {200., 981310.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981314.9}, {200., 981314.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981354.77}, {200., 981354.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981381.39}, {200., 981381.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981415.84}, {200., 981415.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981421.12}, {200., 981421.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981423.27}, {200., 981423.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981432.}, {200., 981432.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981477.41}, {200., 981477.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981486.15}, {200., 981486.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981540.75}, {200., 981540.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981545.82}, {200., 981545.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981548.88}, {200., 981548.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981606.17}, {200., 981606.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981662.36}, {200., 981662.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981669.08}, {200., 981669.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981730.14}, {200., 981730.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981776.93}, {200., 981776.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981789.08}, {200., 981789.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981853.6}, {200., 981853.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981907.89}, {200., 981907.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980234.66}, {250., 980234.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0018026637], 
      PointBox[{{250., 980278.9}, {250., 980278.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0053031071], 
      PointBox[{{250., 980320.9}, {250., 980320.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980342.1}, {250., 980342.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99281778], 
      PointBox[{{250., 980383.14}, {250., 980383.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980385.11}, {250., 980385.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980414.56}, {250., 980414.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980442.49}, {250., 980442.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.9523122*^-17], 
      PointBox[{{250., 980455.32}, {250., 980455.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980466.99}, {250., 980466.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980492.42}, {250., 980492.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.4428809*^-14], 
      PointBox[{{250., 980507.06}, {250., 980507.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980528.7}, {250., 980528.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980545.54}, {250., 980545.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9406855*^-16], 
      PointBox[{{250., 980549.87}, {250., 980549.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980573.81}, {250., 980573.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980576.37}, {250., 980576.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980604.18}, {250., 980604.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.1747746*^-13], 
      PointBox[{{250., 980613.49}, {250., 980613.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980638.24}, {250., 980638.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.6656998*^-15], 
      PointBox[{{250., 980648.11}, {250., 980648.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980649.25}, {250., 980649.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980657.66}, {250., 980657.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7959496*^-13], 
      PointBox[{{250., 980663.78}, {250., 980663.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980681.35}, {250., 980681.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980685.94}, {250., 980685.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980724.71}, {250., 980724.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980728.18}, {250., 980728.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980736.85}, {250., 980736.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980742.99}, {250., 980742.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.1830164*^-14], 
      PointBox[{{250., 980757.1}, {250., 980757.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980760.32}, {250., 980760.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980765.12}, {250., 980765.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980765.61}, {250., 980765.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980802.08}, {250., 980802.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980805.45}, {250., 980805.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980818.89}, {250., 980818.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980819.94}, {250., 980819.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980828.24}, {250., 980828.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980851.73}, {250., 980851.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980860.13}, {250., 980860.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980873.23}, {250., 980873.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980877.64}, {250., 980877.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980880.88}, {250., 980880.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980908.68}, {250., 980908.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980910.07}, {250., 980910.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980938.77}, {250., 980938.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980940.75}, {250., 980940.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980942.33}, {250., 980942.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980967.74}, {250., 980967.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980987.74}, {250., 980987.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980989.29}, {250., 980989.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981000.56}, {250., 981000.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981001.6}, {250., 981001.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981035.76}, {250., 981035.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981036.15}, {250., 981036.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981059.21}, {250., 981059.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981065.91}, {250., 981065.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981080.14}, {250., 981080.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981092.26}, {250., 981092.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981093.37}, {250., 981093.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981096.25}, {250., 981096.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981108.08}, {250., 981108.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981132.75}, {250., 981132.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981168.16}, {250., 981168.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981170.51}, {250., 981170.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981183.41}, {250., 981183.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981186.37}, {250., 981186.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981197.52}, {250., 981197.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981203.56}, {250., 981203.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981230.27}, {250., 981230.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981273.33}, {250., 981273.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981276.45}, {250., 981276.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981297.52}, {250., 981297.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981304.1}, {250., 981304.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981309.97}, {250., 981309.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981315.56}, {250., 981315.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981354.38}, {250., 981354.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981381.17}, {250., 981381.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981415.24}, {250., 981415.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981421.86}, {250., 981421.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981423.08}, {250., 981423.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981432.75}, {250., 981432.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981477.05}, {250., 981477.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981485.81}, {250., 981485.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981541.53}, {250., 981541.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981545.68}, {250., 981545.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981549.61}, {250., 981549.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981605.61}, {250., 981605.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981662.86}, {250., 981662.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981669.19}, {250., 981669.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981729.5}, {250., 981729.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981777.62}, {250., 981777.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981789.06}, {250., 981789.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981852.86}, {250., 981852.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981907.83}, {250., 981907.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980235.36}, {300., 980235.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0027034599], 
      PointBox[{{300., 980278.98}, {300., 980278.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0075043508], 
      PointBox[{{300., 980320.95}, {300., 980320.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980342.07}, {300., 980342.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9896822], 
      PointBox[{{300., 980382.89}, {300., 980382.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980385.26}, {300., 980385.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980414.49}, {300., 980414.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980442.31}, {300., 980442.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4040089*^-16], 
      PointBox[{{300., 980455.5}, {300., 980455.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980466.38}, {300., 980466.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980492.32}, {300., 980492.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0610797*^-13], 
      PointBox[{{300., 980506.93}, {300., 980506.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980528.91}, {300., 980528.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980545.42}, {300., 980545.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.0494748*^-16], 
      PointBox[{{300., 980549.27}, {300., 980549.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980573.67}, {300., 980573.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980576.26}, {300., 980576.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980604.42}, {300., 980604.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.3301474*^-13], 
      PointBox[{{300., 980613.62}, {300., 980613.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980637.59}, {300., 980637.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.7723586*^-15], 
      PointBox[{{300., 980647.63}, {300., 980647.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980649.14}, {300., 980649.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980657.42}, {300., 980657.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0710502*^-13], 
      PointBox[{{300., 980664.37}, {300., 980664.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980681.69}, {300., 980681.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980686.31}, {300., 980686.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980724.61}, {300., 980724.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980727.48}, {300., 980727.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980737.07}, {300., 980737.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980742.53}, {300., 980742.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.019033*^-13], 
      PointBox[{{300., 980756.85}, {300., 980756.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980760.86}, {300., 980760.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980764.76}, {300., 980764.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980766.1}, {300., 980766.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980801.99}, {300., 980801.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980806.13}, {300., 980806.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980818.14}, {300., 980818.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980820.15}, {300., 980820.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980827.46}, {300., 980827.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980852.25}, {300., 980852.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980859.87}, {300., 980859.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980873.87}, {300., 980873.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980877.26}, {300., 980877.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980880.79}, {300., 980880.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980908.89}, {300., 980908.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980909.27}, {300., 980909.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980939.34}, {300., 980939.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980940.45}, {300., 980940.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980942.83}, {300., 980942.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980967.6}, {300., 980967.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980987.27}, {300., 980987.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980989.72}, {300., 980989.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981000.76}, {300., 981000.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981000.85}, {300., 981000.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981035.72}, {300., 981035.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981036.58}, {300., 981036.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981059.42}, {300., 981059.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981066.}, {300., 981066.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981080.38}, {300., 981080.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981092.5}, {300., 981092.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981092.65}, {300., 981092.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981095.73}, {300., 981095.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981108.17}, {300., 981108.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981133.05}, {300., 981133.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981167.93}, {300., 981167.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981170.59}, {300., 981170.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981183.96}, {300., 981183.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981186.8}, {300., 981186.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981198.07}, {300., 981198.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981203.01}, {300., 981203.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981230.03}, {300., 981230.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981274.16}, {300., 981274.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981276.26}, {300., 981276.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981297.44}, {300., 981297.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981304.64}, {300., 981304.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981309.47}, {300., 981309.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981316.24}, {300., 981316.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981353.96}, {300., 981353.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981380.98}, {300., 981380.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981414.59}, {300., 981414.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981422.59}, {300., 981422.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981422.94}, {300., 981422.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981433.5}, {300., 981433.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981476.69}, {300., 981476.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981485.49}, {300., 981485.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981542.31}, {300., 981542.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981545.54}, {300., 981545.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981550.37}, {300., 981550.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981604.99}, {300., 981604.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981663.3}, {300., 981663.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981669.41}, {300., 981669.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981728.81}, {300., 981728.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981778.29}, {300., 981778.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981789.12}, {300., 981789.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981852.06}, {300., 981852.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981907.82}, {300., 981907.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980236.06}, {350., 980236.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0038276061], 
      PointBox[{{350., 980279.02}, {350., 980279.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.010010062], 
      PointBox[{{350., 980320.99}, {350., 980320.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980341.99}, {350., 980341.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.98601282], 
      PointBox[{{350., 980382.67}, {350., 980382.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980385.41}, {350., 980385.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980414.37}, {350., 980414.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980442.17}, {350., 980442.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5263876*^-16], 
      PointBox[{{350., 980455.69}, {350., 980455.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980465.74}, {350., 980465.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980492.17}, {350., 980492.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4285181*^-13], 
      PointBox[{{350., 980506.83}, {350., 980506.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980529.12}, {350., 980529.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980545.33}, {350., 980545.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1101835*^-15], 
      PointBox[{{350., 980548.63}, {350., 980548.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980573.46}, {350., 980573.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980576.19}, {350., 980576.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980604.68}, {350., 980604.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.816679*^-13], 
      PointBox[{{350., 980613.78}, {350., 980613.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980636.9}, {350., 980636.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.461755*^-14], 
      PointBox[{{350., 980647.11}, {350., 980647.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980649.09}, {350., 980649.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980657.09}, {350., 980657.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.596669*^-13], 
      PointBox[{{350., 980664.99}, {350., 980664.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980682.04}, {350., 980682.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980686.7}, {350., 980686.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980724.57}, {350., 980724.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980726.73}, {350., 980726.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980737.29}, {350., 980737.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980741.99}, {350., 980741.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3663588*^-13], 
      PointBox[{{350., 980756.63}, {350., 980756.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980761.42}, {350., 980761.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980764.38}, {350., 980764.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980766.61}, {350., 980766.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980801.96}, {350., 980801.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980806.81}, {350., 980806.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980817.33}, {350., 980817.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980820.39}, {350., 980820.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980826.62}, {350., 980826.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980852.79}, {350., 980852.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980859.65}, {350., 980859.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980874.46}, {350., 980874.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980876.9}, {350., 980876.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980880.77}, {350., 980880.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980908.42}, {350., 980908.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980909.12}, {350., 980909.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980939.91}, {350., 980939.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980940.13}, {350., 980940.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980943.37}, {350., 980943.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980967.49}, {350., 980967.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980986.75}, {350., 980986.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980990.15}, {350., 980990.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980999.86}, {350., 980999.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981001.16}, {350., 981001.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981035.71}, {350., 981035.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981037.05}, {350., 981037.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981059.63}, {350., 981059.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981066.05}, {350., 981066.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981080.66}, {350., 981080.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981091.57}, {350., 981091.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981093.06}, {350., 981093.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981095.17}, {350., 981095.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981108.25}, {350., 981108.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981133.39}, {350., 981133.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981167.74}, {350., 981167.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981170.7}, {350., 981170.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981184.53}, {350., 981184.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981187.2}, {350., 981187.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981198.64}, {350., 981198.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981202.41}, {350., 981202.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981229.78}, {350., 981229.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981274.99}, {350., 981274.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981276.11}, {350., 981276.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981297.39}, {350., 981297.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981305.11}, {350., 981305.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981308.97}, {350., 981308.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981316.92}, {350., 981316.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981353.51}, {350., 981353.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981380.82}, {350., 981380.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981413.9}, {350., 981413.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981422.84}, {350., 981422.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981423.32}, {350., 981423.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981434.26}, {350., 981434.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981476.31}, {350., 981476.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981485.18}, {350., 981485.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981543.08}, {350., 981543.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981545.44}, {350., 981545.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981551.15}, {350., 981551.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981604.33}, {350., 981604.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981663.69}, {350., 981663.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981669.74}, {350., 981669.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981728.06}, {350., 981728.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981778.94}, {350., 981778.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981789.24}, {350., 981789.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981851.2}, {350., 981851.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981907.88}, {350., 981907.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980236.75}, {400., 980236.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0051931677], 
      PointBox[{{400., 980279.02}, {400., 980279.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.012777893], 
      PointBox[{{400., 980321.02}, {400., 980321.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980341.88}, {400., 980341.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.98183394], 
      PointBox[{{400., 980382.5}, {400., 980382.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980385.56}, {400., 980385.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980414.21}, {400., 980414.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980442.06}, {400., 980442.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.1752875*^-16], 
      PointBox[{{400., 980455.87}, {400., 980455.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980465.07}, {400., 980465.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980491.97}, {400., 980491.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8437623*^-13], 
      PointBox[{{400., 980506.78}, {400., 980506.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980529.33}, {400., 980529.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980545.28}, {400., 980545.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8734875*^-15], 
      PointBox[{{400., 980547.95}, {400., 980547.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980573.19}, {400., 980573.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980576.17}, {400., 980576.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980604.94}, {400., 980604.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2618687*^-12], 
      PointBox[{{400., 980613.97}, {400., 980613.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980636.16}, {400., 980636.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5164168*^-14], 
      PointBox[{{400., 980646.57}, {400., 980646.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980649.09}, {400., 980649.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980656.7}, {400., 980656.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.3767175*^-13], 
      PointBox[{{400., 980665.62}, {400., 980665.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980682.42}, {400., 980682.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980687.12}, {400., 980687.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980724.59}, {400., 980724.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980725.93}, {400., 980725.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980737.52}, {400., 980737.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980741.36}, {400., 980741.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.7579582*^-13], 
      PointBox[{{400., 980756.42}, {400., 980756.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980762.}, {400., 980762.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980763.99}, {400., 980763.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980767.15}, {400., 980767.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980801.98}, {400., 980801.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980807.48}, {400., 980807.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980816.47}, {400., 980816.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980820.64}, {400., 980820.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980825.72}, {400., 980825.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980853.37}, {400., 980853.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980859.45}, {400., 980859.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980874.89}, {400., 980874.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980876.67}, {400., 980876.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980880.8}, {400., 980880.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980907.51}, {400., 980907.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980909.38}, {400., 980909.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980939.78}, {400., 980939.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980940.47}, {400., 980940.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980943.93}, {400., 980943.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980967.41}, {400., 980967.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980986.2}, {400., 980986.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980990.58}, {400., 980990.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980998.91}, {400., 980998.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981001.49}, {400., 981001.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981035.74}, {400., 981035.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981037.56}, {400., 981037.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981059.85}, {400., 981059.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981066.08}, {400., 981066.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981080.96}, {400., 981080.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981090.58}, {400., 981090.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981093.49}, {400., 981093.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981094.57}, {400., 981094.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981108.34}, {400., 981108.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981133.78}, {400., 981133.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981167.58}, {400., 981167.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981170.83}, {400., 981170.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981185.11}, {400., 981185.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981187.59}, {400., 981187.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981199.22}, {400., 981199.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981201.78}, {400., 981201.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981229.52}, {400., 981229.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981275.82}, {400., 981275.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981276.}, {400., 981276.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981297.39}, {400., 981297.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981305.46}, {400., 981305.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981308.56}, {400., 981308.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981317.61}, {400., 981317.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981353.05}, {400., 981353.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981380.71}, {400., 981380.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981413.15}, {400., 981413.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981422.78}, {400., 981422.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981424.05}, {400., 981424.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981435.03}, {400., 981435.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981475.92}, {400., 981475.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981484.91}, {400., 981484.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981543.85}, {400., 981543.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981545.38}, {400., 981545.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981551.94}, {400., 981551.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981603.62}, {400., 981603.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981664.04}, {400., 981664.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981670.17}, {400., 981670.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981727.27}, {400., 981727.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981779.59}, {400., 981779.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981789.43}, {400., 981789.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981850.3}, {400., 981850.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981907.99}, {400., 981907.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980237.43}, {450., 980237.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0068171613], 
      PointBox[{{450., 980278.97}, {450., 980278.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.015762222], 
      PointBox[{{450., 980321.05}, {450., 980321.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980341.72}, {450., 980341.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.97717416], 
      PointBox[{{450., 980382.36}, {450., 980382.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980385.71}, {450., 980385.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980414.01}, {450., 980414.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980441.98}, {450., 980441.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.4632146*^-16], 
      PointBox[{{450., 980456.05}, {450., 980456.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980464.37}, {450., 980464.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980491.71}, {450., 980491.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3037034*^-13], 
      PointBox[{{450., 980506.77}, {450., 980506.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980529.55}, {450., 980529.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980545.27}, {450., 980545.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9648554*^-15], 
      PointBox[{{450., 980547.23}, {450., 980547.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980572.86}, {450., 980572.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980576.2}, {450., 980576.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980605.22}, {450., 980605.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5721739*^-12], 
      PointBox[{{450., 980614.18}, {450., 980614.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980635.38}, {450., 980635.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0471398*^-14], 
      PointBox[{{450., 980645.98}, {450., 980645.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980649.14}, {450., 980649.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980656.22}, {450., 980656.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.4148548*^-13], 
      PointBox[{{450., 980666.28}, {450., 980666.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980682.82}, {450., 980682.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980687.56}, {450., 980687.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980724.65}, {450., 980724.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980725.09}, {450., 980725.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980737.75}, {450., 980737.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980740.66}, {450., 980740.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.1916079*^-13], 
      PointBox[{{450., 980756.25}, {450., 980756.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980762.61}, {450., 980762.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980763.58}, {450., 980763.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980767.71}, {450., 980767.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980802.05}, {450., 980802.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980808.14}, {450., 980808.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980815.57}, {450., 980815.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980820.91}, {450., 980820.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980824.77}, {450., 980824.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980853.96}, {450., 980853.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980859.28}, {450., 980859.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980874.95}, {450., 980874.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980876.79}, {450., 980876.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980880.88}, {450., 980880.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980906.55}, {450., 980906.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980909.65}, {450., 980909.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980939.41}, {450., 980939.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980941.03}, {450., 980941.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980944.52}, {450., 980944.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980967.37}, {450., 980967.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980985.62}, {450., 980985.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980991.01}, {450., 980991.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980997.9}, {450., 980997.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981001.84}, {450., 981001.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981035.81}, {450., 981035.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981038.09}, {450., 981038.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981060.07}, {450., 981060.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981066.07}, {450., 981066.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981081.3}, {450., 981081.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981089.54}, {450., 981089.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981093.93}, {450., 981093.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981093.94}, {450., 981093.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981108.43}, {450., 981108.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981134.21}, {450., 981134.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981167.46}, {450., 981167.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981171.}, {450., 981171.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981185.71}, {450., 981185.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981187.95}, {450., 981187.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981199.81}, {450., 981199.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981201.1}, {450., 981201.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981229.26}, {450., 981229.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981275.92}, {450., 981275.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981276.65}, {450., 981276.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981297.43}, {450., 981297.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981305.57}, {450., 981305.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981308.33}, {450., 981308.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981318.3}, {450., 981318.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981352.56}, {450., 981352.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981380.63}, {450., 981380.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981412.37}, {450., 981412.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981422.75}, {450., 981422.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981424.77}, {450., 981424.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981435.8}, {450., 981435.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981475.49}, {450., 981475.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981484.66}, {450., 981484.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981544.62}, {450., 981544.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981545.35}, {450., 981545.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981552.74}, {450., 981552.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981602.87}, {450., 981602.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981664.35}, {450., 981664.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981670.67}, {450., 981670.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981726.42}, {450., 981726.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981780.23}, {450., 981780.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981789.68}, {450., 981789.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981849.35}, {450., 981849.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981908.15}, {450., 981908.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980238.11}, {500., 980238.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0087150379], 
      PointBox[{{500., 980278.88}, {500., 980278.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.018915326], 
      PointBox[{{500., 980321.08}, {500., 980321.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980341.52}, {500., 980341.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.97206571], 
      PointBox[{{500., 980382.26}, {500., 980382.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980385.85}, {500., 980385.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980413.76}, {500., 980413.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980441.94}, {500., 980441.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.4979668*^-16], 
      PointBox[{{500., 980456.24}, {500., 980456.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980463.64}, {500., 980463.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980491.4}, {500., 980491.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.8049656*^-13], 
      PointBox[{{500., 980506.8}, {500., 980506.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980529.78}, {500., 980529.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980545.28}, {500., 980545.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.459538*^-15], 
      PointBox[{{500., 980546.47}, {500., 980546.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980572.46}, {500., 980572.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980576.26}, {500., 980576.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980605.52}, {500., 980605.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.9112663*^-12], 
      PointBox[{{500., 980614.42}, {500., 980614.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980634.57}, {500., 980634.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.1667205*^-14], 
      PointBox[{{500., 980645.37}, {500., 980645.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980649.23}, {500., 980649.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980655.68}, {500., 980655.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1714511*^-12], 
      PointBox[{{500., 980666.95}, {500., 980666.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980683.24}, {500., 980683.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980688.02}, {500., 980688.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980724.21}, {500., 980724.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980724.76}, {500., 980724.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980737.99}, {500., 980737.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980739.88}, {500., 980739.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00020337329], 
      PointBox[{{500., 980756.09}, {500., 980756.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980763.16}, {500., 980763.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980763.24}, {500., 980763.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980768.29}, {500., 980768.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980802.18}, {500., 980802.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980808.8}, {500., 980808.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980814.62}, {500., 980814.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980821.2}, {500., 980821.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980823.76}, {500., 980823.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980854.58}, {500., 980854.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980859.13}, {500., 980859.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980874.63}, {500., 980874.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980877.26}, {500., 980877.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980881.02}, {500., 980881.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980905.55}, {500., 980905.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980909.94}, {500., 980909.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980939.01}, {500., 980939.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980941.58}, {500., 980941.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980945.14}, {500., 980945.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980967.35}, {500., 980967.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980985.}, {500., 980985.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980991.45}, {500., 980991.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980996.86}, {500., 980996.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981002.21}, {500., 981002.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981035.91}, {500., 981035.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981038.66}, {500., 981038.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981060.3}, {500., 981060.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981066.03}, {500., 981066.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981081.66}, {500., 981081.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981088.45}, {500., 981088.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981093.25}, {500., 981093.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981094.41}, {500., 981094.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981108.53}, {500., 981108.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981134.67}, {500., 981134.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981167.38}, {500., 981167.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981171.18}, {500., 981171.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981186.32}, {500., 981186.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981188.29}, {500., 981188.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981200.39}, {500., 981200.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981200.41}, {500., 981200.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981228.99}, {500., 981228.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981275.87}, {500., 981275.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981277.47}, {500., 981277.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981297.5}, {500., 981297.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981305.34}, {500., 981305.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981308.38}, {500., 981308.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981319.}, {500., 981319.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981352.05}, {500., 981352.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981380.59}, {500., 981380.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981411.54}, {500., 981411.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981422.77}, {500., 981422.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981425.48}, {500., 981425.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981436.57}, {500., 981436.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981475.04}, {500., 981475.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981484.45}, {500., 981484.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981545.37}, {500., 981545.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981545.39}, {500., 981545.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981553.55}, {500., 981553.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981602.08}, {500., 981602.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981664.65}, {500., 981664.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981671.24}, {500., 981671.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981725.53}, {500., 981725.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981780.86}, {500., 981780.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981790.}, {500., 981790.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981848.35}, {500., 981848.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981908.36}, {500., 981908.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980238.78}, {550., 980238.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.010900158], 
      PointBox[{{550., 980278.75}, {550., 980278.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.022188619], 
      PointBox[{{550., 980321.11}, {550., 980321.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980341.28}, {550., 980341.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.96654377], 
      PointBox[{{550., 980382.2}, {550., 980382.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980386.}, {550., 980386.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980413.46}, {550., 980413.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980441.92}, {550., 980441.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3379122*^-15], 
      PointBox[{{550., 980456.43}, {550., 980456.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980462.88}, {550., 980462.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980491.04}, {550., 980491.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.3438972*^-13], 
      PointBox[{{550., 980506.86}, {550., 980506.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980530.01}, {550., 980530.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980545.34}, {550., 980545.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.4371416*^-15], 
      PointBox[{{550., 980545.68}, {550., 980545.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980572.01}, {550., 980572.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980576.37}, {550., 980576.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980605.83}, {550., 980605.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2779563*^-12], 
      PointBox[{{550., 980614.69}, {550., 980614.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980633.71}, {550., 980633.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.9918091*^-14], 
      PointBox[{{550., 980644.73}, {550., 980644.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980649.37}, {550., 980649.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980655.06}, {550., 980655.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4278885*^-12], 
      PointBox[{{550., 980667.64}, {550., 980667.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980683.68}, {550., 980683.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980688.5}, {550., 980688.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980723.28}, {550., 980723.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980724.92}, {550., 980724.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980738.22}, {550., 980738.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980739.04}, {550., 980739.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00024522958], 
      PointBox[{{550., 980755.96}, {550., 980755.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980762.73}, {550., 980762.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980763.88}, {550., 980763.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980768.88}, {550., 980768.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980802.35}, {550., 980802.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980809.46}, {550., 980809.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980813.64}, {550., 980813.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980821.51}, {550., 980821.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980822.7}, {550., 980822.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980855.22}, {550., 980855.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980859.02}, {550., 980859.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980874.14}, {550., 980874.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980877.88}, {550., 980877.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980881.2}, {550., 980881.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980904.51}, {550., 980904.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980910.25}, {550., 980910.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980938.58}, {550., 980938.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980942.13}, {550., 980942.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980945.78}, {550., 980945.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980967.37}, {550., 980967.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980984.34}, {550., 980984.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980991.9}, {550., 980991.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980995.76}, {550., 980995.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981002.6}, {550., 981002.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981036.04}, {550., 981036.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981039.25}, {550., 981039.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981060.54}, {550., 981060.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981065.96}, {550., 981065.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981082.04}, {550., 981082.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981087.32}, {550., 981087.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981092.54}, {550., 981092.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981094.89}, {550., 981094.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981108.64}, {550., 981108.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981135.17}, {550., 981135.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981167.33}, {550., 981167.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981171.4}, {550., 981171.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981186.93}, {550., 981186.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981188.6}, {550., 981188.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981199.63}, {550., 981199.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981201.01}, {550., 981201.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981228.72}, {550., 981228.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981275.86}, {550., 981275.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981278.3}, {550., 981278.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981297.6}, {550., 981297.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981304.82}, {550., 981304.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981308.66}, {550., 981308.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981319.7}, {550., 981319.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981351.52}, {550., 981351.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981380.58}, {550., 981380.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981410.67}, {550., 981410.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981422.83}, {550., 981422.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981426.19}, {550., 981426.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981437.34}, {550., 981437.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981474.55}, {550., 981474.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981484.29}, {550., 981484.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981545.43}, {550., 981545.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981546.15}, {550., 981546.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981554.35}, {550., 981554.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981601.24}, {550., 981601.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981664.94}, {550., 981664.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981671.87}, {550., 981671.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981724.6}, {550., 981724.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981781.48}, {550., 981781.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981790.37}, {550., 981790.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981847.31}, {550., 981847.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981908.61}, {550., 981908.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980239.44}, {600., 980239.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.013383288], 
      PointBox[{{600., 980278.56}, {600., 980278.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.025533898], 
      PointBox[{{600., 980321.13}, {600., 980321.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980341.}, {600., 980341.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.96064568], 
      PointBox[{{600., 980382.17}, {600., 980382.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980386.15}, {600., 980386.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980413.12}, {600., 980413.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980441.94}, {600., 980441.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8195442*^-15], 
      PointBox[{{600., 980456.63}, {600., 980456.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980462.09}, {600., 980462.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980490.63}, {600., 980490.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.916552*^-13], 
      PointBox[{{600., 980506.96}, {600., 980506.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980530.26}, {600., 980530.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.9809196*^-15], 
      PointBox[{{600., 980544.86}, {600., 980544.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980545.42}, {600., 980545.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980571.49}, {600., 980571.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980576.52}, {600., 980576.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980606.15}, {600., 980606.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.6711833*^-12], 
      PointBox[{{600., 980614.98}, {600., 980614.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980632.82}, {600., 980632.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2639574*^-13], 
      PointBox[{{600., 980644.06}, {600., 980644.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980649.55}, {600., 980649.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980654.38}, {600., 980654.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.7110932*^-12], 
      PointBox[{{600., 980668.34}, {600., 980668.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980684.15}, {600., 980684.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980689.}, {600., 980689.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980722.32}, {600., 980722.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980725.12}, {600., 980725.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980738.14}, {600., 980738.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980738.45}, {600., 980738.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00029071277], 
      PointBox[{{600., 980755.84}, {600., 980755.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980762.29}, {600., 980762.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980764.54}, {600., 980764.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980769.5}, {600., 980769.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980802.57}, {600., 980802.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980810.1}, {600., 980810.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980812.61}, {600., 980812.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980821.6}, {600., 980821.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980821.83}, {600., 980821.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980855.87}, {600., 980855.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980858.93}, {600., 980858.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980873.57}, {600., 980873.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980878.55}, {600., 980878.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980881.44}, {600., 980881.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980903.43}, {600., 980903.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980910.57}, {600., 980910.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980938.13}, {600., 980938.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980942.67}, {600., 980942.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980946.43}, {600., 980946.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980967.42}, {600., 980967.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980983.66}, {600., 980983.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980992.35}, {600., 980992.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980994.64}, {600., 980994.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981003.}, {600., 981003.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981036.21}, {600., 981036.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981039.87}, {600., 981039.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981060.79}, {600., 981060.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981065.85}, {600., 981065.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981082.45}, {600., 981082.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981086.15}, {600., 981086.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981091.79}, {600., 981091.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981095.39}, {600., 981095.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981108.76}, {600., 981108.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981135.7}, {600., 981135.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981167.32}, {600., 981167.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981171.64}, {600., 981171.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981187.56}, {600., 981187.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981188.88}, {600., 981188.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981198.84}, {600., 981198.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981201.63}, {600., 981201.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981228.45}, {600., 981228.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981275.88}, {600., 981275.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981279.13}, {600., 981279.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981297.74}, {600., 981297.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981304.14}, {600., 981304.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981309.06}, {600., 981309.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981320.41}, {600., 981320.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981350.97}, {600., 981350.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981380.61}, {600., 981380.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981409.76}, {600., 981409.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981422.93}, {600., 981422.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981426.9}, {600., 981426.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981438.11}, {600., 981438.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981474.02}, {600., 981474.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981484.18}, {600., 981484.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981545.53}, {600., 981545.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981546.91}, {600., 981546.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981555.16}, {600., 981555.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981600.37}, {600., 981600.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981665.23}, {600., 981665.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981672.54}, {600., 981672.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981723.62}, {600., 981723.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981782.09}, {600., 981782.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981790.79}, {600., 981790.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981846.23}, {600., 981846.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981908.9}, {600., 981908.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980240.1}, {650., 980240.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.016172144], 
      PointBox[{{650., 980278.34}, {650., 980278.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.028904545], 
      PointBox[{{650., 980321.16}, {650., 980321.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980340.67}, {650., 980340.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.95441022], 
      PointBox[{{650., 980382.18}, {650., 980382.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980386.31}, {650., 980386.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980412.73}, {650., 980412.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980441.98}, {650., 980441.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.4023249*^-15], 
      PointBox[{{650., 980456.84}, {650., 980456.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980461.29}, {650., 980461.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980490.16}, {650., 980490.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.5186553*^-13], 
      PointBox[{{650., 980507.09}, {650., 980507.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980530.52}, {650., 980530.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2177312*^-14], 
      PointBox[{{650., 980544.}, {650., 980544.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980545.53}, {650., 980545.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980570.91}, {650., 980570.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980576.7}, {650., 980576.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980606.5}, {650., 980606.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0900179*^-12], 
      PointBox[{{650., 980615.29}, {650., 980615.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980631.89}, {650., 980631.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.722397*^-13], 
      PointBox[{{650., 980643.36}, {650., 980643.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980649.77}, {650., 980649.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980653.63}, {650., 980653.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.0213357*^-12], 
      PointBox[{{650., 980669.05}, {650., 980669.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980684.63}, {650., 980684.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980689.51}, {650., 980689.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980721.33}, {650., 980721.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980725.36}, {650., 980725.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980737.17}, {650., 980737.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980738.67}, {650., 980738.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00033972387], 
      PointBox[{{650., 980755.76}, {650., 980755.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980761.85}, {650., 980761.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980765.22}, {650., 980765.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980770.13}, {650., 980770.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980802.83}, {650., 980802.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980810.74}, {650., 980810.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980811.55}, {650., 980811.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980820.45}, {650., 980820.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980822.17}, {650., 980822.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980856.53}, {650., 980856.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980858.88}, {650., 980858.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980872.95}, {650., 980872.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980879.25}, {650., 980879.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980881.71}, {650., 980881.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980902.31}, {650., 980902.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980910.91}, {650., 980910.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980937.66}, {650., 980937.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980943.21}, {650., 980943.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980947.11}, {650., 980947.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980967.5}, {650., 980967.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980982.94}, {650., 980982.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980992.8}, {650., 980992.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980993.47}, {650., 980993.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981003.43}, {650., 981003.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981036.4}, {650., 981036.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981040.51}, {650., 981040.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981061.05}, {650., 981061.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981065.7}, {650., 981065.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981082.87}, {650., 981082.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981084.94}, {650., 981084.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981091.01}, {650., 981091.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981095.9}, {650., 981095.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981108.89}, {650., 981108.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981136.26}, {650., 981136.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981167.34}, {650., 981167.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981171.9}, {650., 981171.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981188.2}, {650., 981188.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981189.12}, {650., 981189.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981198.01}, {650., 981198.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981202.25}, {650., 981202.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981228.18}, {650., 981228.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981275.94}, {650., 981275.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981279.95}, {650., 981279.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981297.91}, {650., 981297.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981303.35}, {650., 981303.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981309.51}, {650., 981309.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981321.12}, {650., 981321.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981350.41}, {650., 981350.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981380.68}, {650., 981380.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981408.82}, {650., 981408.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981423.06}, {650., 981423.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981427.6}, {650., 981427.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981438.89}, {650., 981438.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981473.44}, {650., 981473.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981484.12}, {650., 981484.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981545.66}, {650., 981545.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981547.67}, {650., 981547.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981555.97}, {650., 981555.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981599.46}, {650., 981599.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981665.53}, {650., 981665.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981673.24}, {650., 981673.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981722.61}, {650., 981722.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981782.7}, {650., 981782.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981791.26}, {650., 981791.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981845.12}, {650., 981845.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981909.23}, {650., 981909.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980240.74}, {700., 980240.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.019271012], 
      PointBox[{{700., 980278.06}, {700., 980278.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.032256623], 
      PointBox[{{700., 980321.2}, {700., 980321.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980340.31}, {700., 980340.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.94787688], 
      PointBox[{{700., 980382.22}, {700., 980382.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980386.47}, {700., 980386.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980412.3}, {700., 980412.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980442.05}, {700., 980442.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0925741*^-15], 
      PointBox[{{700., 980457.05}, {700., 980457.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980460.46}, {700., 980460.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980489.65}, {700., 980489.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.1455515*^-13], 
      PointBox[{{700., 980507.26}, {700., 980507.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980530.79}, {700., 980530.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5543538*^-13], 
      PointBox[{{700., 980543.11}, {700., 980543.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980545.68}, {700., 980545.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980570.27}, {700., 980570.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980576.92}, {700., 980576.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980606.86}, {700., 980606.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.533664*^-12], 
      PointBox[{{700., 980615.63}, {700., 980615.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980630.93}, {700., 980630.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2851466*^-13], 
      PointBox[{{700., 980642.64}, {700., 980642.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980650.02}, {700., 980650.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980652.82}, {700., 980652.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3588608*^-12], 
      PointBox[{{700., 980669.78}, {700., 980669.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980685.14}, {700., 980685.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980690.05}, {700., 980690.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980720.3}, {700., 980720.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980725.64}, {700., 980725.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980736.16}, {700., 980736.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980738.87}, {700., 980738.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00039215729], 
      PointBox[{{700., 980755.69}, {700., 980755.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980761.41}, {700., 980761.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980765.91}, {700., 980765.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980770.77}, {700., 980770.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980803.13}, {700., 980803.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980810.46}, {700., 980810.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980811.38}, {700., 980811.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980819.27}, {700., 980819.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980822.51}, {700., 980822.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980857.21}, {700., 980857.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980858.86}, {700., 980858.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980872.29}, {700., 980872.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980879.97}, {700., 980879.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980882.03}, {700., 980882.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980901.17}, {700., 980901.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980911.25}, {700., 980911.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980937.17}, {700., 980937.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980943.75}, {700., 980943.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980947.8}, {700., 980947.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980967.61}, {700., 980967.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980982.19}, {700., 980982.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980992.27}, {700., 980992.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980993.27}, {700., 980993.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981003.86}, {700., 981003.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981036.62}, {700., 981036.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981041.17}, {700., 981041.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981061.32}, {700., 981061.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981065.52}, {700., 981065.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981083.32}, {700., 981083.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981083.7}, {700., 981083.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981090.2}, {700., 981090.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981096.42}, {700., 981096.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981109.03}, {700., 981109.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981136.84}, {700., 981136.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981167.4}, {700., 981167.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981172.19}, {700., 981172.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981188.84}, {700., 981188.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981189.33}, {700., 981189.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981197.15}, {700., 981197.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981202.87}, {700., 981202.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981227.93}, {700., 981227.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981276.03}, {700., 981276.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981280.77}, {700., 981280.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981298.12}, {700., 981298.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981302.5}, {700., 981302.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981309.97}, {700., 981309.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981321.83}, {700., 981321.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981349.84}, {700., 981349.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981380.79}, {700., 981380.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981407.84}, {700., 981407.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981423.23}, {700., 981423.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981428.29}, {700., 981428.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981439.66}, {700., 981439.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981472.82}, {700., 981472.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981484.11}, {700., 981484.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981545.84}, {700., 981545.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981548.42}, {700., 981548.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981556.78}, {700., 981556.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981598.52}, {700., 981598.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981665.85}, {700., 981665.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981673.96}, {700., 981673.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981721.56}, {700., 981721.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981783.3}, {700., 981783.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981791.77}, {700., 981791.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981843.97}, {700., 981843.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981909.6}, {700., 981909.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980241.38}, {750., 980241.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.022680487], 
      PointBox[{{750., 980277.73}, {750., 980277.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.03554981], 
      PointBox[{{750., 980321.23}, {750., 980321.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980339.9}, {750., 980339.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.94108515], 
      PointBox[{{750., 980382.29}, {750., 980382.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980386.64}, {750., 980386.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980411.82}, {750., 980411.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980442.13}, {750., 980442.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.8953159*^-15], 
      PointBox[{{750., 980457.28}, {750., 980457.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980459.62}, {750., 980459.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980489.08}, {750., 980489.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.7921287*^-13], 
      PointBox[{{750., 980507.45}, {750., 980507.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980531.08}, {750., 980531.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.2919732*^-13], 
      PointBox[{{750., 980542.2}, {750., 980542.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980545.85}, {750., 980545.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980569.58}, {750., 980569.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980577.17}, {750., 980577.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980607.24}, {750., 980607.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0014631*^-12], 
      PointBox[{{750., 980615.99}, {750., 980615.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980629.94}, {750., 980629.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9616045*^-13], 
      PointBox[{{750., 980641.89}, {750., 980641.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980650.31}, {750., 980650.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980651.96}, {750., 980651.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7238878*^-12], 
      PointBox[{{750., 980670.51}, {750., 980670.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980685.66}, {750., 980685.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980690.6}, {750., 980690.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980719.24}, {750., 980719.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980725.96}, {750., 980725.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980735.09}, {750., 980735.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980739.06}, {750., 980739.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00044790163], 
      PointBox[{{750., 980755.65}, {750., 980755.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980760.97}, {750., 980760.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980766.6}, {750., 980766.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980771.43}, {750., 980771.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980803.47}, {750., 980803.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980809.34}, {750., 980809.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980812.}, {750., 980812.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980818.04}, {750., 980818.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980822.87}, {750., 980822.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980857.88}, {750., 980857.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980858.88}, {750., 980858.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980871.61}, {750., 980871.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980880.69}, {750., 980880.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980882.38}, {750., 980882.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980899.99}, {750., 980899.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980911.61}, {750., 980911.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980936.65}, {750., 980936.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980944.28}, {750., 980944.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980948.51}, {750., 980948.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980967.75}, {750., 980967.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980981.42}, {750., 980981.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980991.05}, {750., 980991.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980993.74}, {750., 980993.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981004.31}, {750., 981004.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981036.88}, {750., 981036.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981041.84}, {750., 981041.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981061.61}, {750., 981061.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981065.3}, {750., 981065.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981082.43}, {750., 981082.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981083.77}, {750., 981083.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981089.36}, {750., 981089.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981096.95}, {750., 981096.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981109.19}, {750., 981109.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981137.45}, {750., 981137.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981167.49}, {750., 981167.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981172.5}, {750., 981172.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981189.49}, {750., 981189.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981189.51}, {750., 981189.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981196.26}, {750., 981196.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981203.5}, {750., 981203.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981227.69}, {750., 981227.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981276.15}, {750., 981276.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981281.6}, {750., 981281.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981298.35}, {750., 981298.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981301.59}, {750., 981301.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981310.44}, {750., 981310.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981322.54}, {750., 981322.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981349.27}, {750., 981349.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981380.92}, {750., 981380.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981406.82}, {750., 981406.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981423.43}, {750., 981423.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981428.97}, {750., 981428.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981440.44}, {750., 981440.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981472.17}, {750., 981472.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981484.16}, {750., 981484.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981546.04}, {750., 981546.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981549.17}, {750., 981549.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981557.59}, {750., 981557.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981597.56}, {750., 981597.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981666.18}, {750., 981666.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981674.7}, {750., 981674.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981720.48}, {750., 981720.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981783.9}, {750., 981783.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981792.33}, {750., 981792.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981842.79}, {750., 981842.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981910.01}, {750., 981910.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980242.01}, {800., 980242.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.026397317], 
      PointBox[{{800., 980277.36}, {800., 980277.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.038748149], 
      PointBox[{{800., 980321.28}, {800., 980321.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980339.45}, {800., 980339.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.93407395], 
      PointBox[{{800., 980382.39}, {800., 980382.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980386.81}, {800., 980386.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980411.3}, {800., 980411.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980442.23}, {800., 980442.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.814367*^-15], 
      PointBox[{{800., 980457.51}, {800., 980457.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980458.76}, {800., 980458.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980488.47}, {800., 980488.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.452715*^-13], 
      PointBox[{{800., 980507.68}, {800., 980507.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980531.38}, {800., 980531.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.1660796*^-13], 
      PointBox[{{800., 980541.26}, {800., 980541.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980546.05}, {800., 980546.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980568.84}, {800., 980568.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980577.46}, {800., 980577.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980607.64}, {800., 980607.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.4929009*^-12], 
      PointBox[{{800., 980616.37}, {800., 980616.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980628.92}, {800., 980628.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.759315*^-13], 
      PointBox[{{800., 980641.12}, {800., 980641.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980650.63}, {800., 980650.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980651.04}, {800., 980651.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.1166114*^-12], 
      PointBox[{{800., 980671.25}, {800., 980671.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980686.21}, {800., 980686.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980691.16}, {800., 980691.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980718.15}, {800., 980718.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980726.31}, {800., 980726.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980733.98}, {800., 980733.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980739.22}, {800., 980739.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00050684054], 
      PointBox[{{800., 980755.63}, {800., 980755.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980760.54}, {800., 980760.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980767.31}, {800., 980767.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980772.1}, {800., 980772.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980803.84}, {800., 980803.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980808.2}, {800., 980808.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980812.62}, {800., 980812.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980816.78}, {800., 980816.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980823.23}, {800., 980823.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980858.47}, {800., 980858.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980859.02}, {800., 980859.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980870.9}, {800., 980870.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980881.43}, {800., 980881.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980882.77}, {800., 980882.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980898.79}, {800., 980898.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980911.98}, {800., 980911.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980936.12}, {800., 980936.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980944.81}, {800., 980944.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980949.23}, {800., 980949.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980967.91}, {800., 980967.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980980.61}, {800., 980980.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980989.79}, {800., 980989.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980994.21}, {800., 980994.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981004.77}, {800., 981004.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981037.15}, {800., 981037.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981042.54}, {800., 981042.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981061.91}, {800., 981061.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981065.04}, {800., 981065.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981081.13}, {800., 981081.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981084.24}, {800., 981084.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981088.49}, {800., 981088.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981097.5}, {800., 981097.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981109.37}, {800., 981109.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981138.08}, {800., 981138.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981167.61}, {800., 981167.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981172.84}, {800., 981172.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981189.64}, {800., 981189.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981190.15}, {800., 981190.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981195.34}, {800., 981195.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981204.13}, {800., 981204.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981227.47}, {800., 981227.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981276.31}, {800., 981276.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981282.42}, {800., 981282.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981298.62}, {800., 981298.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981300.64}, {800., 981300.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981310.89}, {800., 981310.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981323.25}, {800., 981323.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981348.69}, {800., 981348.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981381.09}, {800., 981381.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981405.77}, {800., 981405.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981423.66}, {800., 981423.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981429.64}, {800., 981429.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981441.21}, {800., 981441.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981471.47}, {800., 981471.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981484.25}, {800., 981484.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981546.28}, {800., 981546.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981549.92}, {800., 981549.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981558.41}, {800., 981558.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981596.56}, {800., 981596.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981666.53}, {800., 981666.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981675.46}, {800., 981675.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981719.37}, {800., 981719.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981784.51}, {800., 981784.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981792.92}, {800., 981792.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981841.58}, {800., 981841.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981910.44}, {800., 981910.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980242.64}, {850., 980242.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.030414403], 
      PointBox[{{850., 980276.93}, {850., 980276.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.041820576], 
      PointBox[{{850., 980321.33}, {850., 980321.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980338.96}, {850., 980338.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.92688102], 
      PointBox[{{850., 980382.51}, {850., 980382.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980387.}, {850., 980387.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980410.74}, {850., 980410.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980442.35}, {850., 980442.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.8524799*^-15], 
      PointBox[{{850., 980457.75}, {850., 980457.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980457.89}, {850., 980457.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980487.81}, {850., 980487.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.1209386*^-13], 
      PointBox[{{850., 980507.93}, {850., 980507.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980531.69}, {850., 980531.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.1892026*^-13], 
      PointBox[{{850., 980540.29}, {850., 980540.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980546.28}, {850., 980546.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980568.04}, {850., 980568.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980577.77}, {850., 980577.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980608.06}, {850., 980608.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.0076162*^-12], 
      PointBox[{{850., 980616.78}, {850., 980616.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980627.87}, {850., 980627.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.6832148*^-13], 
      PointBox[{{850., 980640.33}, {850., 980640.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980650.08}, {850., 980650.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980650.99}, {850., 980650.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.5372025*^-12], 
      PointBox[{{850., 980672.01}, {850., 980672.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980686.76}, {850., 980686.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980691.74}, {850., 980691.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980717.04}, {850., 980717.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980726.69}, {850., 980726.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980732.83}, {850., 980732.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980739.36}, {850., 980739.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00056885352], 
      PointBox[{{850., 980755.63}, {850., 980755.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980760.13}, {850., 980760.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980768.02}, {850., 980768.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980772.78}, {850., 980772.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980804.24}, {850., 980804.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980807.02}, {850., 980807.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980813.23}, {850., 980813.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980815.49}, {850., 980815.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980823.61}, {850., 980823.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980858.76}, {850., 980858.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980859.5}, {850., 980859.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980870.16}, {850., 980870.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980882.17}, {850., 980882.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980883.19}, {850., 980883.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980897.56}, {850., 980897.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980912.35}, {850., 980912.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980935.57}, {850., 980935.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980945.33}, {850., 980945.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980949.96}, {850., 980949.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980968.1}, {850., 980968.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980979.78}, {850., 980979.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980988.52}, {850., 980988.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980994.7}, {850., 980994.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981005.24}, {850., 981005.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981037.46}, {850., 981037.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981043.24}, {850., 981043.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981062.22}, {850., 981062.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981064.75}, {850., 981064.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981079.8}, {850., 981079.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981084.73}, {850., 981084.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981087.59}, {850., 981087.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981098.05}, {850., 981098.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981109.57}, {850., 981109.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981138.72}, {850., 981138.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981167.76}, {850., 981167.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981173.19}, {850., 981173.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981189.73}, {850., 981189.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981190.81}, {850., 981190.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981194.4}, {850., 981194.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981204.76}, {850., 981204.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981227.26}, {850., 981227.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981276.49}, {850., 981276.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981283.24}, {850., 981283.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981298.91}, {850., 981298.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981299.65}, {850., 981299.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981311.33}, {850., 981311.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981323.96}, {850., 981323.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981348.11}, {850., 981348.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981381.29}, {850., 981381.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981404.7}, {850., 981404.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981423.92}, {850., 981423.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981430.3}, {850., 981430.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981441.99}, {850., 981441.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981470.74}, {850., 981470.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981484.4}, {850., 981484.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981546.55}, {850., 981546.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981550.66}, {850., 981550.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981559.22}, {850., 981559.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981595.54}, {850., 981595.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981666.91}, {850., 981666.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981676.24}, {850., 981676.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981718.23}, {850., 981718.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981785.12}, {850., 981785.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981793.53}, {850., 981793.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981840.35}, {850., 981840.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981910.91}, {850., 981910.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980243.25}, {900., 980243.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.034720932], 
      PointBox[{{900., 980276.46}, {900., 980276.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.044741225], 
      PointBox[{{900., 980321.39}, {900., 980321.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980338.44}, {900., 980338.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.91954252], 
      PointBox[{{900., 980382.67}, {900., 980382.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980387.18}, {900., 980387.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980410.14}, {900., 980410.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980442.47}, {900., 980442.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980457.02}, {900., 980457.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.0115235*^-15], 
      PointBox[{{900., 980458.}, {900., 980458.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980487.11}, {900., 980487.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.7895433*^-13], 
      PointBox[{{900., 980508.2}, {900., 980508.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980532.01}, {900., 980532.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.3741565*^-13], 
      PointBox[{{900., 980539.3}, {900., 980539.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980546.53}, {900., 980546.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980567.2}, {900., 980567.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980578.11}, {900., 980578.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980608.49}, {900., 980608.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.9095639*^-12], 
      PointBox[{{900., 980617.2}, {900., 980617.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980626.8}, {900., 980626.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.7346611*^-13], 
      PointBox[{{900., 980639.51}, {900., 980639.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980649.06}, {900., 980649.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980651.37}, {900., 980651.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.9858097*^-12], 
      PointBox[{{900., 980672.76}, {900., 980672.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980687.34}, {900., 980687.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980692.33}, {900., 980692.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980715.9}, {900., 980715.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980727.1}, {900., 980727.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980731.64}, {900., 980731.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980739.46}, {900., 980739.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00063381678], 
      PointBox[{{900., 980755.65}, {900., 980755.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980759.74}, {900., 980759.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980768.74}, {900., 980768.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980773.48}, {900., 980773.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980804.68}, {900., 980804.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980805.83}, {900., 980805.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980813.83}, {900., 980813.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980814.16}, {900., 980814.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980823.99}, {900., 980823.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980858.88}, {900., 980858.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980860.18}, {900., 980860.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980869.4}, {900., 980869.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980882.91}, {900., 980882.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980883.63}, {900., 980883.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980896.31}, {900., 980896.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980912.73}, {900., 980912.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980935.01}, {900., 980935.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980945.85}, {900., 980945.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980950.7}, {900., 980950.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980968.31}, {900., 980968.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980978.93}, {900., 980978.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980987.21}, {900., 980987.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980995.19}, {900., 980995.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981005.72}, {900., 981005.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981037.79}, {900., 981037.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981043.96}, {900., 981043.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981062.55}, {900., 981062.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981064.43}, {900., 981064.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981078.45}, {900., 981078.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981085.22}, {900., 981085.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981086.66}, {900., 981086.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981098.61}, {900., 981098.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981109.78}, {900., 981109.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981139.39}, {900., 981139.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981167.94}, {900., 981167.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981173.57}, {900., 981173.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981189.76}, {900., 981189.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981191.48}, {900., 981191.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981193.44}, {900., 981193.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981205.39}, {900., 981205.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981227.07}, {900., 981227.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981276.7}, {900., 981276.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981284.06}, {900., 981284.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981298.63}, {900., 981298.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981299.23}, {900., 981299.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981311.74}, {900., 981311.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981324.68}, {900., 981324.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981347.53}, {900., 981347.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981381.53}, {900., 981381.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981403.59}, {900., 981403.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981424.22}, {900., 981424.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981430.95}, {900., 981430.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981442.76}, {900., 981442.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981469.98}, {900., 981469.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981484.59}, {900., 981484.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981546.86}, {900., 981546.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981551.39}, {900., 981551.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981560.03}, {900., 981560.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981594.49}, {900., 981594.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981667.31}, {900., 981667.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981677.02}, {900., 981677.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981717.07}, {900., 981717.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981785.73}, {900., 981785.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981794.18}, {900., 981794.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981839.09}, {900., 981839.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981911.4}, {900., 981911.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980243.85}, {950., 980243.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.039302641], 
      PointBox[{{950., 980275.94}, {950., 980275.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.047489513], 
      PointBox[{{950., 980321.46}, {950., 980321.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980337.87}, {950., 980337.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.91209256], 
      PointBox[{{950., 980382.86}, {950., 980382.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980387.38}, {950., 980387.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980409.51}, {950., 980409.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980442.59}, {950., 980442.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980456.15}, {950., 980456.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.2926858*^-15], 
      PointBox[{{950., 980458.26}, {950., 980458.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980486.37}, {950., 980486.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.4501463*^-13], 
      PointBox[{{950., 980508.5}, {950., 980508.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980532.35}, {950., 980532.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.7342521*^-13], 
      PointBox[{{950., 980538.29}, {950., 980538.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980546.81}, {950., 980546.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980566.32}, {950., 980566.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980578.48}, {950., 980578.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980608.94}, {950., 980608.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.7907946*^-12], 
      PointBox[{{950., 980617.64}, {950., 980617.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980625.71}, {950., 980625.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.9101381*^-13], 
      PointBox[{{950., 980638.68}, {950., 980638.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980648.01}, {950., 980648.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980651.78}, {950., 980651.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.462561*^-12], 
      PointBox[{{950., 980673.53}, {950., 980673.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980687.92}, {950., 980687.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980692.94}, {950., 980692.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980714.74}, {950., 980714.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980727.54}, {950., 980727.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980730.42}, {950., 980730.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980739.52}, {950., 980739.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00070160405], 
      PointBox[{{950., 980755.69}, {950., 980755.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980759.37}, {950., 980759.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980769.47}, {950., 980769.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980774.18}, {950., 980774.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980804.61}, {950., 980804.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980805.14}, {950., 980805.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980812.81}, {950., 980812.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980814.42}, {950., 980814.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980824.37}, {950., 980824.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980859.}, {950., 980859.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980860.9}, {950., 980860.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980868.62}, {950., 980868.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980883.66}, {950., 980883.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980884.11}, {950., 980884.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980895.04}, {950., 980895.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980913.11}, {950., 980913.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980934.43}, {950., 980934.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980946.37}, {950., 980946.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980951.45}, {950., 980951.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980968.55}, {950., 980968.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980978.05}, {950., 980978.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980985.89}, {950., 980985.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980995.7}, {950., 980995.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981006.21}, {950., 981006.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981038.14}, {950., 981038.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981044.69}, {950., 981044.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981062.89}, {950., 981062.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981064.07}, {950., 981064.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981077.08}, {950., 981077.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981085.71}, {950., 981085.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981085.72}, {950., 981085.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981099.18}, {950., 981099.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981110.01}, {950., 981110.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981140.07}, {950., 981140.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981168.15}, {950., 981168.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981173.97}, {950., 981173.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981189.74}, {950., 981189.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981192.15}, {950., 981192.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981192.47}, {950., 981192.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981206.03}, {950., 981206.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981226.91}, {950., 981226.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981276.94}, {950., 981276.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981284.87}, {950., 981284.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981297.58}, {950., 981297.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981299.57}, {950., 981299.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981312.12}, {950., 981312.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981325.39}, {950., 981325.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981346.96}, {950., 981346.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981381.79}, {950., 981381.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981402.46}, {950., 981402.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981424.54}, {950., 981424.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981431.59}, {950., 981431.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981443.53}, {950., 981443.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981469.19}, {950., 981469.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981484.83}, {950., 981484.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981547.19}, {950., 981547.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981552.13}, {950., 981552.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981560.84}, {950., 981560.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981593.42}, {950., 981593.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981667.72}, {950., 981667.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981677.81}, {950., 981677.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981715.88}, {950., 981715.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981786.35}, {950., 981786.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981794.85}, {950., 981794.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981837.81}, {950., 981837.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981911.92}, {950., 981911.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980244.45}, {1000., 980244.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.044142194], 
      PointBox[{{1000., 980275.37}, {1000., 980275.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.050050021], 
      PointBox[{{1000., 980321.54}, {1000., 980321.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980337.27}, {1000., 980337.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.90456286], 
      PointBox[{{1000., 980383.07}, {1000., 980383.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980387.58}, {1000., 980387.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980408.83}, {1000., 980408.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980442.71}, {1000., 980442.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980455.29}, {1000., 980455.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.6966841*^-15], 
      PointBox[{{1000., 980458.53}, {1000., 980458.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980485.59}, {1000., 980485.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.0929216*^-13], 
      PointBox[{{1000., 980508.82}, {1000., 980508.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980532.71}, {1000., 980532.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.2835948*^-13], 
      PointBox[{{1000., 980537.26}, {1000., 980537.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980547.1}, {1000., 980547.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980565.39}, {1000., 980565.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980578.87}, {1000., 980578.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980609.4}, {1000., 980609.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.7209471*^-12], 
      PointBox[{{1000., 980618.1}, {1000., 980618.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980624.59}, {1000., 980624.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.1994781*^-13], 
      PointBox[{{1000., 980637.82}, {1000., 980637.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980646.92}, {1000., 980646.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980652.22}, {1000., 980652.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.9675655*^-12], 
      PointBox[{{1000., 980674.3}, {1000., 980674.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980688.52}, {1000., 980688.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980693.55}, {1000., 980693.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980713.56}, {1000., 980713.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980728.01}, {1000., 980728.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980729.16}, {1000., 980729.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980739.53}, {1000., 980739.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00077208738], 
      PointBox[{{1000., 980755.76}, {1000., 980755.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980759.04}, {1000., 980759.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980770.2}, {1000., 980770.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980774.89}, {1000., 980774.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980803.37}, {1000., 980803.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980805.62}, {1000., 980805.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980811.43}, {1000., 980811.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980815.}, {1000., 980815.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980824.76}, {1000., 980824.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980859.12}, {1000., 980859.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980861.64}, {1000., 980861.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980867.83}, {1000., 980867.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980884.41}, {1000., 980884.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980884.61}, {1000., 980884.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980893.75}, {1000., 980893.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980913.49}, {1000., 980913.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980933.84}, {1000., 980933.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980946.88}, {1000., 980946.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980952.21}, {1000., 980952.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980968.81}, {1000., 980968.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980977.14}, {1000., 980977.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980984.55}, {1000., 980984.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980996.21}, {1000., 980996.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981006.71}, {1000., 981006.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981038.52}, {1000., 981038.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981045.44}, {1000., 981045.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981063.25}, {1000., 981063.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981063.68}, {1000., 981063.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981075.7}, {1000., 981075.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981084.74}, {1000., 981084.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981086.22}, {1000., 981086.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981099.76}, {1000., 981099.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981110.26}, {1000., 981110.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981140.77}, {1000., 981140.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981168.39}, {1000., 981168.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981174.39}, {1000., 981174.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981189.62}, {1000., 981189.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981191.53}, {1000., 981191.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981192.83}, {1000., 981192.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981206.66}, {1000., 981206.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981226.78}, {1000., 981226.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981277.21}, {1000., 981277.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981285.69}, {1000., 981285.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981296.49}, {1000., 981296.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981299.94}, {1000., 981299.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981312.48}, {1000., 981312.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981326.1}, {1000., 981326.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981346.41}, {1000., 981346.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981382.08}, {1000., 981382.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981401.3}, {1000., 981401.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981424.88}, {1000., 981424.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981432.21}, {1000., 981432.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981444.31}, {1000., 981444.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981468.39}, {1000., 981468.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981485.1}, {1000., 981485.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981547.55}, {1000., 981547.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981552.85}, {1000., 981552.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981561.66}, {1000., 981561.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981592.34}, {1000., 981592.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981668.16}, {1000., 981668.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981678.61}, {1000., 981678.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981714.66}, {1000., 981714.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981786.97}, {1000., 981786.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981795.55}, {1000., 981795.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981836.51}, {1000., 981836.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981912.46}, {1000., 981912.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980245.03}, {1050., 980245.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.049219658], 
      PointBox[{{1050., 980274.76}, {1050., 980274.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.052412212], 
      PointBox[{{1050., 980321.63}, {1050., 980321.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980336.63}, {1050., 980336.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.89698251], 
      PointBox[{{1050., 980383.3}, {1050., 980383.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980387.79}, {1050., 980387.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980408.12}, {1050., 980408.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980442.81}, {1050., 980442.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980454.46}, {1050., 980454.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1223972*^-14], 
      PointBox[{{1050., 980458.81}, {1050., 980458.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980484.77}, {1050., 980484.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.7061876*^-13], 
      PointBox[{{1050., 980509.16}, {1050., 980509.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980533.07}, {1050., 980533.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1037488*^-12], 
      PointBox[{{1050., 980536.22}, {1050., 980536.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980547.42}, {1050., 980547.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980564.43}, {1050., 980564.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980579.28}, {1050., 980579.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980609.88}, {1050., 980609.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0702842*^-11], 
      PointBox[{{1050., 980618.57}, {1050., 980618.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980623.46}, {1050., 980623.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.5833372*^-13], 
      PointBox[{{1050., 980636.94}, {1050., 980636.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980645.79}, {1050., 980645.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980652.67}, {1050., 980652.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.5009149*^-12], 
      PointBox[{{1050., 980675.08}, {1050., 980675.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980689.13}, {1050., 980689.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980694.18}, {1050., 980694.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980712.36}, {1050., 980712.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980727.88}, {1050., 980727.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980728.5}, {1050., 980728.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980739.5}, {1050., 980739.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00084513787], 
      PointBox[{{1050., 980755.85}, {1050., 980755.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980758.75}, {1050., 980758.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980770.93}, {1050., 980770.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980775.61}, {1050., 980775.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980802.11}, {1050., 980802.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980806.13}, {1050., 980806.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980810.03}, {1050., 980810.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980815.57}, {1050., 980815.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980825.15}, {1050., 980825.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980859.27}, {1050., 980859.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980862.39}, {1050., 980862.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980867.02}, {1050., 980867.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980885.14}, {1050., 980885.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980885.17}, {1050., 980885.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980892.44}, {1050., 980892.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980913.87}, {1050., 980913.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980933.24}, {1050., 980933.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980947.39}, {1050., 980947.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980952.98}, {1050., 980952.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980969.09}, {1050., 980969.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980976.22}, {1050., 980976.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980983.19}, {1050., 980983.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980996.72}, {1050., 980996.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981007.22}, {1050., 981007.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981038.92}, {1050., 981038.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981046.19}, {1050., 981046.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981063.25}, {1050., 981063.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981063.63}, {1050., 981063.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981074.29}, {1050., 981074.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981083.74}, {1050., 981083.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981086.73}, {1050., 981086.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981100.34}, {1050., 981100.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981110.53}, {1050., 981110.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981141.48}, {1050., 981141.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981168.66}, {1050., 981168.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981174.83}, {1050., 981174.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981189.31}, {1050., 981189.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981190.7}, {1050., 981190.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981193.51}, {1050., 981193.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981207.3}, {1050., 981207.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981226.68}, {1050., 981226.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981277.51}, {1050., 981277.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981286.5}, {1050., 981286.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981295.39}, {1050., 981295.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981300.33}, {1050., 981300.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981312.8}, {1050., 981312.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981326.81}, {1050., 981326.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981345.87}, {1050., 981345.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981382.4}, {1050., 981382.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981400.12}, {1050., 981400.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981425.25}, {1050., 981425.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981432.82}, {1050., 981432.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981445.08}, {1050., 981445.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981467.57}, {1050., 981467.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981485.42}, {1050., 981485.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981547.93}, {1050., 981547.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981553.57}, {1050., 981553.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981562.47}, {1050., 981562.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981591.24}, {1050., 981591.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981668.62}, {1050., 981668.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981679.41}, {1050., 981679.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981713.43}, {1050., 981713.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981787.6}, {1050., 981787.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981796.26}, {1050., 981796.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981835.2}, {1050., 981835.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981913.02}, {1050., 981913.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980245.6}, {1100., 980245.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.05451303], 
      PointBox[{{1100., 980274.1}, {1100., 980274.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.054570006], 
      PointBox[{{1100., 980321.72}, {1100., 980321.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980335.96}, {1100., 980335.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.8893776], 
      PointBox[{{1100., 980383.56}, {1100., 980383.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980388.01}, {1100., 980388.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980407.38}, {1100., 980407.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980442.87}, {1100., 980442.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980453.66}, {1100., 980453.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2874933*^-14], 
      PointBox[{{1100., 980459.1}, {1100., 980459.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980483.91}, {1100., 980483.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0275868*^-12], 
      PointBox[{{1100., 980509.51}, {1100., 980509.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980533.45}, {1100., 980533.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3012969*^-12], 
      PointBox[{{1100., 980535.16}, {1100., 980535.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980547.76}, {1100., 980547.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980563.43}, {1100., 980563.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980579.72}, {1100., 980579.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980610.37}, {1100., 980610.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.174058*^-11], 
      PointBox[{{1100., 980619.06}, {1100., 980619.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980622.3}, {1100., 980622.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1029502*^-12], 
      PointBox[{{1100., 980636.05}, {1100., 980636.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980644.63}, {1100., 980644.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980653.15}, {1100., 980653.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.0626856*^-12], 
      PointBox[{{1100., 980675.86}, {1100., 980675.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980689.74}, {1100., 980689.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980694.81}, {1100., 980694.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980711.14}, {1100., 980711.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980726.57}, {1100., 980726.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980729.01}, {1100., 980729.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980739.4}, {1100., 980739.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0009206264], 
      PointBox[{{1100., 980755.95}, {1100., 980755.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980758.5}, {1100., 980758.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980771.67}, {1100., 980771.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980776.33}, {1100., 980776.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980800.84}, {1100., 980800.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980806.66}, {1100., 980806.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980808.61}, {1100., 980808.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980816.14}, {1100., 980816.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980825.53}, {1100., 980825.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980859.44}, {1100., 980859.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980863.15}, {1100., 980863.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980866.2}, {1100., 980866.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980885.68}, {1100., 980885.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6471335*^-13], 
      PointBox[{{1100., 980885.93}, {1100., 980885.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980891.11}, {1100., 980891.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980914.25}, {1100., 980914.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980932.64}, {1100., 980932.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980947.9}, {1100., 980947.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980953.75}, {1100., 980953.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980969.38}, {1100., 980969.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980975.28}, {1100., 980975.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980981.82}, {1100., 980981.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980997.25}, {1100., 980997.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981007.74}, {1100., 981007.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981039.34}, {1100., 981039.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981046.95}, {1100., 981046.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981062.8}, {1100., 981062.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981064.01}, {1100., 981064.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981072.87}, {1100., 981072.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981082.73}, {1100., 981082.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981087.25}, {1100., 981087.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981100.93}, {1100., 981100.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981110.82}, {1100., 981110.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981142.2}, {1100., 981142.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981168.95}, {1100., 981168.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981175.29}, {1100., 981175.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981188.67}, {1100., 981188.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981190.14}, {1100., 981190.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981194.19}, {1100., 981194.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981207.93}, {1100., 981207.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981226.6}, {1100., 981226.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981277.83}, {1100., 981277.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981287.31}, {1100., 981287.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981294.25}, {1100., 981294.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981300.74}, {1100., 981300.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981313.08}, {1100., 981313.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981327.52}, {1100., 981327.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981345.35}, {1100., 981345.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981382.75}, {1100., 981382.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981398.92}, {1100., 981398.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981425.64}, {1100., 981425.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981433.4}, {1100., 981433.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981445.85}, {1100., 981445.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981466.74}, {1100., 981466.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981485.76}, {1100., 981485.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981548.34}, {1100., 981548.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981554.27}, {1100., 981554.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981563.28}, {1100., 981563.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981590.13}, {1100., 981590.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981669.1}, {1100., 981669.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981680.22}, {1100., 981680.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981712.18}, {1100., 981712.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981788.24}, {1100., 981788.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981796.99}, {1100., 981796.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981833.86}, {1100., 981833.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981913.6}, {1100., 981913.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980246.16}, {1150., 980246.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0599988], 
      PointBox[{{1150., 980273.39}, {1150., 980273.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.056521265], 
      PointBox[{{1150., 980321.83}, {1150., 980321.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980335.26}, {1150., 980335.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.88177096], 
      PointBox[{{1150., 980383.83}, {1150., 980383.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980388.23}, {1150., 980388.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980406.61}, {1150., 980406.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980442.89}, {1150., 980442.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980452.91}, {1150., 980452.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4650063*^-14], 
      PointBox[{{1150., 980459.4}, {1150., 980459.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980483.03}, {1150., 980483.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0784788*^-12], 
      PointBox[{{1150., 980509.88}, {1150., 980509.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980533.84}, {1150., 980533.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5229514*^-12], 
      PointBox[{{1150., 980534.08}, {1150., 980534.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980548.13}, {1150., 980548.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980562.4}, {1150., 980562.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980580.17}, {1150., 980580.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980610.87}, {1150., 980610.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.284009*^-11], 
      PointBox[{{1150., 980619.56}, {1150., 980619.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980621.13}, {1150., 980621.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2487327*^-12], 
      PointBox[{{1150., 980635.13}, {1150., 980635.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980643.44}, {1150., 980643.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980653.65}, {1150., 980653.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.6529397*^-12], 
      PointBox[{{1150., 980676.65}, {1150., 980676.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980690.37}, {1150., 980690.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980695.46}, {1150., 980695.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980709.9}, {1150., 980709.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980725.23}, {1150., 980725.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980729.54}, {1150., 980729.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980739.24}, {1150., 980739.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.00099842428], 
      PointBox[{{1150., 980756.08}, {1150., 980756.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980758.31}, {1150., 980758.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980772.41}, {1150., 980772.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980777.06}, {1150., 980777.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980799.55}, {1150., 980799.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980807.17}, {1150., 980807.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980807.21}, {1150., 980807.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980816.69}, {1150., 980816.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980825.92}, {1150., 980825.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980859.63}, {1150., 980859.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980863.92}, {1150., 980863.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980865.37}, {1150., 980865.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980886.25}, {1150., 980886.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.922838*^-13], 
      PointBox[{{1150., 980886.69}, {1150., 980886.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980889.77}, {1150., 980889.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980914.62}, {1150., 980914.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980932.03}, {1150., 980932.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980948.4}, {1150., 980948.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980954.54}, {1150., 980954.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980969.7}, {1150., 980969.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980974.32}, {1150., 980974.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980980.43}, {1150., 980980.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980997.78}, {1150., 980997.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981008.26}, {1150., 981008.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981039.77}, {1150., 981039.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981047.72}, {1150., 981047.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981062.31}, {1150., 981062.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981064.42}, {1150., 981064.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981071.44}, {1150., 981071.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981081.69}, {1150., 981081.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981087.77}, {1150., 981087.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981101.53}, {1150., 981101.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981111.13}, {1150., 981111.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981142.93}, {1150., 981142.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981169.26}, {1150., 981169.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981175.76}, {1150., 981175.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981187.74}, {1150., 981187.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981189.81}, {1150., 981189.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981194.87}, {1150., 981194.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981208.57}, {1150., 981208.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981226.57}, {1150., 981226.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981278.18}, {1150., 981278.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981288.12}, {1150., 981288.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981293.1}, {1150., 981293.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981301.17}, {1150., 981301.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981313.32}, {1150., 981313.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981328.23}, {1150., 981328.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981344.87}, {1150., 981344.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981383.12}, {1150., 981383.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981397.7}, {1150., 981397.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981426.06}, {1150., 981426.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981433.96}, {1150., 981433.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981446.62}, {1150., 981446.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981465.91}, {1150., 981465.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981486.14}, {1150., 981486.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981548.77}, {1150., 981548.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981554.97}, {1150., 981554.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981564.1}, {1150., 981564.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981589.01}, {1150., 981589.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981669.6}, {1150., 981669.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981681.04}, {1150., 981681.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981710.92}, {1150., 981710.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981788.89}, {1150., 981788.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981797.73}, {1150., 981797.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981832.51}, {1150., 981832.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981914.21}, {1150., 981914.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980246.71}, {1200., 980246.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065652514], 
      PointBox[{{1200., 980272.64}, {1200., 980272.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.058267222], 
      PointBox[{{1200., 980321.94}, {1200., 980321.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980334.53}, {1200., 980334.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.87418167], 
      PointBox[{{1200., 980384.13}, {1200., 980384.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980388.46}, {1200., 980388.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980405.81}, {1200., 980405.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980442.83}, {1200., 980442.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980452.24}, {1200., 980452.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6550124*^-14], 
      PointBox[{{1200., 980459.7}, {1200., 980459.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980482.11}, {1200., 980482.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1211765*^-12], 
      PointBox[{{1200., 980510.26}, {1200., 980510.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.770995*^-12], 
      PointBox[{{1200., 980533.}, {1200., 980533.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980534.23}, {1200., 980534.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980548.5}, {1200., 980548.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980561.34}, {1200., 980561.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980580.64}, {1200., 980580.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980611.38}, {1200., 980611.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980619.94}, {1200., 980619.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4009979*^-11], 
      PointBox[{{1200., 980620.07}, {1200., 980620.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3879098*^-12], 
      PointBox[{{1200., 980634.2}, {1200., 980634.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980642.23}, {1200., 980642.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980654.17}, {1200., 980654.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.2717268*^-12], 
      PointBox[{{1200., 980677.44}, {1200., 980677.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980691.}, {1200., 980691.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980696.11}, {1200., 980696.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980708.65}, {1200., 980708.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980723.87}, {1200., 980723.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980730.09}, {1200., 980730.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980739.01}, {1200., 980739.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0010784039], 
      PointBox[{{1200., 980756.22}, {1200., 980756.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980758.16}, {1200., 980758.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980773.15}, {1200., 980773.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980777.8}, {1200., 980777.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980798.24}, {1200., 980798.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980805.71}, {1200., 980805.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980807.78}, {1200., 980807.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980817.23}, {1200., 980817.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980826.3}, {1200., 980826.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980859.84}, {1200., 980859.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980864.53}, {1200., 980864.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980864.69}, {1200., 980864.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980886.83}, {1200., 980886.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2259926*^-13], 
      PointBox[{{1200., 980887.46}, {1200., 980887.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980888.42}, {1200., 980888.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980914.98}, {1200., 980914.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980931.43}, {1200., 980931.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980948.9}, {1200., 980948.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980955.32}, {1200., 980955.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980970.03}, {1200., 980970.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980973.35}, {1200., 980973.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980979.03}, {1200., 980979.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980998.33}, {1200., 980998.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981008.78}, {1200., 981008.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981040.23}, {1200., 981040.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981048.5}, {1200., 981048.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981061.8}, {1200., 981061.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981064.83}, {1200., 981064.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981069.99}, {1200., 981069.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981080.64}, {1200., 981080.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981088.29}, {1200., 981088.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981102.13}, {1200., 981102.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981111.46}, {1200., 981111.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981143.67}, {1200., 981143.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981169.6}, {1200., 981169.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981176.25}, {1200., 981176.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981186.69}, {1200., 981186.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981189.53}, {1200., 981189.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981195.56}, {1200., 981195.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981209.2}, {1200., 981209.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981226.56}, {1200., 981226.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981278.55}, {1200., 981278.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981288.92}, {1200., 981288.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981291.93}, {1200., 981291.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981301.62}, {1200., 981301.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981313.52}, {1200., 981313.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981328.94}, {1200., 981328.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981344.41}, {1200., 981344.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981383.52}, {1200., 981383.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981396.46}, {1200., 981396.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981426.49}, {1200., 981426.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981434.5}, {1200., 981434.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981447.39}, {1200., 981447.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981465.08}, {1200., 981465.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981486.55}, {1200., 981486.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981549.22}, {1200., 981549.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981555.66}, {1200., 981555.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981564.91}, {1200., 981564.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981587.89}, {1200., 981587.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981670.12}, {1200., 981670.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981681.85}, {1200., 981681.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981709.63}, {1200., 981709.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981789.54}, {1200., 981789.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981798.49}, {1200., 981798.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981831.15}, {1200., 981831.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981914.83}, {1200., 981914.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980247.24}, {1250., 980247.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.071449313], 
      PointBox[{{1250., 980271.85}, {1250., 980271.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.059811887], 
      PointBox[{{1250., 980322.06}, {1250., 980322.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980333.77}, {1250., 980333.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.86662454], 
      PointBox[{{1250., 980384.45}, {1250., 980384.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980388.69}, {1250., 980388.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980404.98}, {1250., 980404.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980442.68}, {1250., 980442.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980451.67}, {1250., 980451.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8576291*^-14], 
      PointBox[{{1250., 980460.01}, {1250., 980460.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980481.17}, {1250., 980481.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1530443*^-12], 
      PointBox[{{1250., 980510.65}, {1250., 980510.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.0481627*^-12], 
      PointBox[{{1250., 980531.9}, {1250., 980531.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980534.64}, {1250., 980534.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980548.9}, {1250., 980548.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980560.25}, {1250., 980560.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980581.13}, {1250., 980581.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980611.89}, {1250., 980611.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980618.74}, {1250., 980618.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5262899*^-11], 
      PointBox[{{1250., 980620.6}, {1250., 980620.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5086292*^-12], 
      PointBox[{{1250., 980633.26}, {1250., 980633.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980640.98}, {1250., 980640.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980654.71}, {1250., 980654.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.9190849*^-12], 
      PointBox[{{1250., 980678.23}, {1250., 980678.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980691.64}, {1250., 980691.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980696.77}, {1250., 980696.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980707.38}, {1250., 980707.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980722.49}, {1250., 980722.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980730.65}, {1250., 980730.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980738.71}, {1250., 980738.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0011604391], 
      PointBox[{{1250., 980756.39}, {1250., 980756.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980758.08}, {1250., 980758.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980773.9}, {1250., 980773.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980778.54}, {1250., 980778.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980796.92}, {1250., 980796.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980804.23}, {1250., 980804.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980808.37}, {1250., 980808.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980817.76}, {1250., 980817.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980826.67}, {1250., 980826.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980860.07}, {1250., 980860.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980863.69}, {1250., 980863.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980865.47}, {1250., 980865.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980887.05}, {1250., 980887.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980887.43}, {1250., 980887.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5605275*^-13], 
      PointBox[{{1250., 980888.23}, {1250., 980888.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980915.34}, {1250., 980915.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980930.83}, {1250., 980930.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980949.39}, {1250., 980949.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980956.11}, {1250., 980956.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980970.38}, {1250., 980970.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980972.36}, {1250., 980972.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980977.61}, {1250., 980977.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980998.88}, {1250., 980998.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981009.31}, {1250., 981009.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981040.7}, {1250., 981040.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981049.28}, {1250., 981049.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981061.27}, {1250., 981061.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981065.27}, {1250., 981065.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981068.53}, {1250., 981068.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981079.57}, {1250., 981079.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981088.81}, {1250., 981088.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981102.73}, {1250., 981102.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981111.81}, {1250., 981111.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981144.42}, {1250., 981144.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981169.96}, {1250., 981169.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981176.76}, {1250., 981176.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981185.58}, {1250., 981185.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981189.24}, {1250., 981189.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981196.25}, {1250., 981196.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981209.83}, {1250., 981209.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981226.59}, {1250., 981226.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981278.94}, {1250., 981278.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981289.72}, {1250., 981289.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981290.74}, {1250., 981290.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981302.08}, {1250., 981302.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981313.66}, {1250., 981313.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981329.64}, {1250., 981329.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981343.99}, {1250., 981343.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981383.94}, {1250., 981383.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981395.2}, {1250., 981395.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981426.94}, {1250., 981426.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981435.}, {1250., 981435.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981448.15}, {1250., 981448.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981464.25}, {1250., 981464.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981486.99}, {1250., 981486.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981549.69}, {1250., 981549.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981556.34}, {1250., 981556.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981565.72}, {1250., 981565.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981586.75}, {1250., 981586.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981670.65}, {1250., 981670.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981682.67}, {1250., 981682.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981708.34}, {1250., 981708.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981790.2}, {1250., 981790.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981799.25}, {1250., 981799.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981829.78}, {1250., 981829.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981915.46}, {1250., 981915.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980247.77}, {1300., 980247.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.077364425], 
      PointBox[{{1300., 980271.01}, {1300., 980271.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.061161463], 
      PointBox[{{1300., 980322.19}, {1300., 980322.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980332.98}, {1300., 980332.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.859109], 
      PointBox[{{1300., 980384.78}, {1300., 980384.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980388.92}, {1300., 980388.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980404.12}, {1300., 980404.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980442.41}, {1300., 980442.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980451.22}, {1300., 980451.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.0730267*^-14], 
      PointBox[{{1300., 980460.33}, {1300., 980460.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980480.2}, {1300., 980480.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1707836*^-12], 
      PointBox[{{1300., 980511.05}, {1300., 980511.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3577864*^-12], 
      PointBox[{{1300., 980530.81}, {1300., 980530.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980535.05}, {1300., 980535.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980549.32}, {1300., 980549.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980559.14}, {1300., 980559.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980581.63}, {1300., 980581.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980612.42}, {1300., 980612.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980617.52}, {1300., 980617.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.073919*^-11], 
      PointBox[{{1300., 980621.13}, {1300., 980621.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5927269*^-12], 
      PointBox[{{1300., 980632.3}, {1300., 980632.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980639.72}, {1300., 980639.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980655.26}, {1300., 980655.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.5950402*^-12], 
      PointBox[{{1300., 980679.03}, {1300., 980679.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980692.28}, {1300., 980692.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980697.43}, {1300., 980697.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980706.1}, {1300., 980706.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980721.1}, {1300., 980721.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980731.23}, {1300., 980731.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980738.35}, {1300., 980738.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0012444062], 
      PointBox[{{1300., 980756.57}, {1300., 980756.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980758.05}, {1300., 980758.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980774.64}, {1300., 980774.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980779.29}, {1300., 980779.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980795.59}, {1300., 980795.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980802.73}, {1300., 980802.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980808.97}, {1300., 980808.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980818.28}, {1300., 980818.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980827.03}, {1300., 980827.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980860.32}, {1300., 980860.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980862.84}, {1300., 980862.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980866.25}, {1300., 980866.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980885.67}, {1300., 980885.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980888.05}, {1300., 980888.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9293123*^-13], 
      PointBox[{{1300., 980889.}, {1300., 980889.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980915.67}, {1300., 980915.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980930.24}, {1300., 980930.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980949.88}, {1300., 980949.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980956.91}, {1300., 980956.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980970.74}, {1300., 980970.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980971.36}, {1300., 980971.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980976.19}, {1300., 980976.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980999.44}, {1300., 980999.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981009.84}, {1300., 981009.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981041.19}, {1300., 981041.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981050.07}, {1300., 981050.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981060.71}, {1300., 981060.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981065.71}, {1300., 981065.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981067.06}, {1300., 981067.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981078.49}, {1300., 981078.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981089.34}, {1300., 981089.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981103.34}, {1300., 981103.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981112.17}, {1300., 981112.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981145.18}, {1300., 981145.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981170.34}, {1300., 981170.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981177.28}, {1300., 981177.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981184.44}, {1300., 981184.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981188.93}, {1300., 981188.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981196.94}, {1300., 981196.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981210.45}, {1300., 981210.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981226.66}, {1300., 981226.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981279.35}, {1300., 981279.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981289.53}, {1300., 981289.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981290.52}, {1300., 981290.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981302.57}, {1300., 981302.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981313.75}, {1300., 981313.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981330.34}, {1300., 981330.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981343.61}, {1300., 981343.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981384.38}, {1300., 981384.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981393.93}, {1300., 981393.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981427.42}, {1300., 981427.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981435.48}, {1300., 981435.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981448.92}, {1300., 981448.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981463.45}, {1300., 981463.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981487.45}, {1300., 981487.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981550.18}, {1300., 981550.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981557.}, {1300., 981557.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981566.53}, {1300., 981566.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981585.62}, {1300., 981585.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981671.2}, {1300., 981671.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981683.5}, {1300., 981683.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981707.03}, {1300., 981707.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981790.88}, {1300., 981790.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981800.03}, {1300., 981800.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981828.4}, {1300., 981828.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981916.11}, {1300., 981916.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980248.27}, {1350., 980248.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.083373601], 
      PointBox[{{1350., 980270.14}, {1350., 980270.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0623238], 
      PointBox[{{1350., 980322.32}, {1350., 980322.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980332.17}, {1350., 980332.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.85163751], 
      PointBox[{{1350., 980385.13}, {1350., 980385.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980389.16}, {1350., 980389.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980403.25}, {1350., 980403.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980442.}, {1350., 980442.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980450.9}, {1350., 980450.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3014392*^-14], 
      PointBox[{{1350., 980460.65}, {1350., 980460.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980479.2}, {1350., 980479.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1702648*^-12], 
      PointBox[{{1350., 980511.45}, {1350., 980511.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7039634*^-12], 
      PointBox[{{1350., 980529.71}, {1350., 980529.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980535.47}, {1350., 980535.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980549.75}, {1350., 980549.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980558.}, {1350., 980558.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980582.15}, {1350., 980582.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980612.95}, {1350., 980612.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980616.3}, {1350., 980616.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1523727*^-11], 
      PointBox[{{1350., 980621.66}, {1350., 980621.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.612112*^-12], 
      PointBox[{{1350., 980631.34}, {1350., 980631.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980638.44}, {1350., 980638.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980655.83}, {1350., 980655.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.2996062*^-12], 
      PointBox[{{1350., 980679.84}, {1350., 980679.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980692.93}, {1350., 980692.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980698.1}, {1350., 980698.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980704.81}, {1350., 980704.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980719.68}, {1350., 980719.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980731.83}, {1350., 980731.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980737.91}, {1350., 980737.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0013301835], 
      PointBox[{{1350., 980756.78}, {1350., 980756.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980758.08}, {1350., 980758.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980775.39}, {1350., 980775.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980780.04}, {1350., 980780.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980794.24}, {1350., 980794.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980801.23}, {1350., 980801.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980809.59}, {1350., 980809.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980818.78}, {1350., 980818.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980827.38}, {1350., 980827.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980860.6}, {1350., 980860.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980862.}, {1350., 980862.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980867.04}, {1350., 980867.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980884.28}, {1350., 980884.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980888.68}, {1350., 980888.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.3291222*^-13], 
      PointBox[{{1350., 980889.77}, {1350., 980889.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980915.98}, {1350., 980915.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980929.66}, {1350., 980929.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980950.37}, {1350., 980950.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980957.71}, {1350., 980957.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980970.35}, {1350., 980970.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980971.12}, {1350., 980971.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980974.75}, {1350., 980974.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981000.}, {1350., 981000.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981010.38}, {1350., 981010.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981041.7}, {1350., 981041.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981050.86}, {1350., 981050.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981060.12}, {1350., 981060.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981065.58}, {1350., 981065.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981066.17}, {1350., 981066.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981077.4}, {1350., 981077.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981089.86}, {1350., 981089.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981103.94}, {1350., 981103.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981112.56}, {1350., 981112.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981145.95}, {1350., 981145.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981170.73}, {1350., 981170.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981177.82}, {1350., 981177.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981183.28}, {1350., 981183.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981188.58}, {1350., 981188.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981197.62}, {1350., 981197.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981211.07}, {1350., 981211.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981226.76}, {1350., 981226.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981279.79}, {1350., 981279.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981288.3}, {1350., 981288.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981291.32}, {1350., 981291.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981303.07}, {1350., 981303.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981313.79}, {1350., 981313.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981331.04}, {1350., 981331.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981343.28}, {1350., 981343.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981384.84}, {1350., 981384.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981392.64}, {1350., 981392.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981427.91}, {1350., 981427.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981435.91}, {1350., 981435.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981449.68}, {1350., 981449.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981462.66}, {1350., 981462.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981487.93}, {1350., 981487.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981550.68}, {1350., 981550.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981557.65}, {1350., 981557.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981567.34}, {1350., 981567.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981584.5}, {1350., 981584.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981671.76}, {1350., 981671.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981684.32}, {1350., 981684.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981705.71}, {1350., 981705.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981791.56}, {1350., 981791.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981800.82}, {1350., 981800.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981827.}, {1350., 981827.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981916.78}, {1350., 981916.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980248.77}, {1400., 980248.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.089453479], 
      PointBox[{{1400., 980269.22}, {1400., 980269.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.06330789], 
      PointBox[{{1400., 980322.46}, {1400., 980322.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980331.33}, {1400., 980331.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.84420263], 
      PointBox[{{1400., 980385.5}, {1400., 980385.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980389.4}, {1400., 980389.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980402.35}, {1400., 980402.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980441.46}, {1400., 980441.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980450.72}, {1400., 980450.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5431738*^-14], 
      PointBox[{{1400., 980460.98}, {1400., 980460.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980478.19}, {1400., 980478.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1463608*^-12], 
      PointBox[{{1400., 980511.84}, {1400., 980511.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0917206*^-12], 
      PointBox[{{1400., 980528.62}, {1400., 980528.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980535.89}, {1400., 980535.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980550.19}, {1400., 980550.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980556.85}, {1400., 980556.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980582.68}, {1400., 980582.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980613.49}, {1400., 980613.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980615.06}, {1400., 980615.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2345647*^-11], 
      PointBox[{{1400., 980622.2}, {1400., 980622.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5233157*^-12], 
      PointBox[{{1400., 980630.37}, {1400., 980630.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980637.14}, {1400., 980637.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980656.41}, {1400., 980656.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.003278*^-11], 
      PointBox[{{1400., 980680.64}, {1400., 980680.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980693.58}, {1400., 980693.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980698.77}, {1400., 980698.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980703.5}, {1400., 980703.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980718.26}, {1400., 980718.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980732.44}, {1400., 980732.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980737.41}, {1400., 980737.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0014176528], 
      PointBox[{{1400., 980757.}, {1400., 980757.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980758.17}, {1400., 980758.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980776.14}, {1400., 980776.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980780.79}, {1400., 980780.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980792.89}, {1400., 980792.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980799.7}, {1400., 980799.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980810.22}, {1400., 980810.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980819.27}, {1400., 980819.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980827.71}, {1400., 980827.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980860.89}, {1400., 980860.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980861.17}, {1400., 980861.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980867.83}, {1400., 980867.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980882.88}, {1400., 980882.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980889.33}, {1400., 980889.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.7625888*^-13], 
      PointBox[{{1400., 980890.54}, {1400., 980890.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980916.27}, {1400., 980916.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980929.1}, {1400., 980929.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980950.86}, {1400., 980950.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980958.51}, {1400., 980958.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980969.33}, {1400., 980969.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980971.5}, {1400., 980971.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980973.31}, {1400., 980973.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981000.58}, {1400., 981000.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981010.92}, {1400., 981010.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981042.22}, {1400., 981042.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981051.66}, {1400., 981051.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981059.52}, {1400., 981059.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981064.09}, {1400., 981064.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981066.64}, {1400., 981066.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981076.29}, {1400., 981076.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981090.38}, {1400., 981090.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981104.55}, {1400., 981104.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981112.96}, {1400., 981112.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981146.72}, {1400., 981146.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981171.15}, {1400., 981171.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981178.37}, {1400., 981178.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981182.1}, {1400., 981182.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981188.2}, {1400., 981188.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981198.31}, {1400., 981198.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981211.69}, {1400., 981211.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981226.89}, {1400., 981226.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981280.24}, {1400., 981280.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981287.06}, {1400., 981287.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981292.11}, {1400., 981292.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981303.59}, {1400., 981303.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981313.76}, {1400., 981313.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981331.73}, {1400., 981331.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981342.99}, {1400., 981342.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981385.32}, {1400., 981385.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981391.34}, {1400., 981391.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981428.41}, {1400., 981428.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981436.3}, {1400., 981436.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981450.44}, {1400., 981450.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981461.91}, {1400., 981461.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981488.44}, {1400., 981488.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981551.21}, {1400., 981551.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981558.27}, {1400., 981558.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981568.15}, {1400., 981568.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981583.38}, {1400., 981583.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981672.34}, {1400., 981672.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981685.15}, {1400., 981685.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981704.39}, {1400., 981704.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981792.25}, {1400., 981792.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981801.61}, {1400., 981801.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981825.6}, {1400., 981825.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981917.45}, {1400., 981917.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980249.25}, {1450., 980249.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.095581871], 
      PointBox[{{1450., 980268.27}, {1450., 980268.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.064123432], 
      PointBox[{{1450., 980322.6}, {1450., 980322.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980330.47}, {1450., 980330.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.83678188], 
      PointBox[{{1450., 980385.88}, {1450., 980385.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980389.64}, {1450., 980389.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980401.44}, {1450., 980401.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980440.8}, {1450., 980440.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980450.67}, {1450., 980450.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7986186*^-14], 
      PointBox[{{1450., 980461.3}, {1450., 980461.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980477.16}, {1450., 980477.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0928677*^-12], 
      PointBox[{{1450., 980512.22}, {1450., 980512.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.5270919*^-12], 
      PointBox[{{1450., 980527.54}, {1450., 980527.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980536.32}, {1450., 980536.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980550.65}, {1450., 980550.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980555.67}, {1450., 980555.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980583.22}, {1450., 980583.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980613.81}, {1450., 980613.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980614.03}, {1450., 980614.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3195494*^-11], 
      PointBox[{{1450., 980622.72}, {1450., 980622.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2622438*^-12], 
      PointBox[{{1450., 980629.41}, {1450., 980629.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980635.82}, {1450., 980635.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980657.}, {1450., 980657.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0794532*^-11], 
      PointBox[{{1450., 980681.45}, {1450., 980681.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980694.24}, {1450., 980694.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980699.45}, {1450., 980699.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980702.19}, {1450., 980702.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980716.81}, {1450., 980716.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980733.07}, {1450., 980733.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980736.84}, {1450., 980736.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0015066988], 
      PointBox[{{1450., 980757.23}, {1450., 980757.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980758.32}, {1450., 980758.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980776.88}, {1450., 980776.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980781.55}, {1450., 980781.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980791.52}, {1450., 980791.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980798.17}, {1450., 980798.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980810.87}, {1450., 980810.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980819.75}, {1450., 980819.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980828.02}, {1450., 980828.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980860.35}, {1450., 980860.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980861.2}, {1450., 980861.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980868.62}, {1450., 980868.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980881.46}, {1450., 980881.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980889.98}, {1450., 980889.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.2308258*^-13], 
      PointBox[{{1450., 980891.32}, {1450., 980891.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980916.52}, {1450., 980916.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980928.57}, {1450., 980928.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980951.33}, {1450., 980951.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980959.32}, {1450., 980959.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980968.3}, {1450., 980968.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980971.85}, {1450., 980971.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980971.9}, {1450., 980971.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981001.16}, {1450., 981001.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981011.45}, {1450., 981011.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981042.75}, {1450., 981042.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981052.46}, {1450., 981052.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981058.9}, {1450., 981058.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981062.59}, {1450., 981062.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981067.12}, {1450., 981067.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981075.18}, {1450., 981075.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981090.9}, {1450., 981090.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981105.16}, {1450., 981105.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981113.38}, {1450., 981113.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981147.51}, {1450., 981147.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981171.59}, {1450., 981171.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981178.94}, {1450., 981178.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981180.91}, {1450., 981180.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981187.78}, {1450., 981187.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981199.}, {1450., 981199.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981212.3}, {1450., 981212.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981227.06}, {1450., 981227.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981280.71}, {1450., 981280.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981285.81}, {1450., 981285.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981292.89}, {1450., 981292.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981304.12}, {1450., 981304.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981313.68}, {1450., 981313.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981332.43}, {1450., 981332.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981342.76}, {1450., 981342.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981385.82}, {1450., 981385.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981390.03}, {1450., 981390.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981428.93}, {1450., 981428.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981436.64}, {1450., 981436.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981451.2}, {1450., 981451.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981461.19}, {1450., 981461.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981488.96}, {1450., 981488.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981551.75}, {1450., 981551.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981558.87}, {1450., 981558.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981568.95}, {1450., 981568.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981582.27}, {1450., 981582.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981672.94}, {1450., 981672.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981685.97}, {1450., 981685.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981703.05}, {1450., 981703.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981792.94}, {1450., 981792.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981802.42}, {1450., 981802.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981824.19}, {1450., 981824.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981918.14}, {1450., 981918.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980249.71}, {1500., 980249.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.10173799], 
      PointBox[{{1500., 980267.29}, {1500., 980267.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.064780456], 
      PointBox[{{1500., 980322.74}, {1500., 980322.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980329.59}, {1500., 980329.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.82932837], 
      PointBox[{{1500., 980386.27}, {1500., 980386.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980389.88}, {1500., 980389.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980400.51}, {1500., 980400.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980440.02}, {1500., 980440.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980450.74}, {1500., 980450.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0682505*^-14], 
      PointBox[{{1500., 980461.63}, {1500., 980461.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980476.12}, {1500., 980476.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0027311*^-12], 
      PointBox[{{1500., 980512.58}, {1500., 980512.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0168873*^-12], 
      PointBox[{{1500., 980526.48}, {1500., 980526.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980536.76}, {1500., 980536.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980551.12}, {1500., 980551.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980554.49}, {1500., 980554.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980583.77}, {1500., 980583.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980612.56}, {1500., 980612.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980614.58}, {1500., 980614.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4015964*^-11], 
      PointBox[{{1500., 980623.2}, {1500., 980623.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5598527*^-15], 
      PointBox[{{1500., 980628.48}, {1500., 980628.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980634.49}, {1500., 980634.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980657.61}, {1500., 980657.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1584786*^-11], 
      PointBox[{{1500., 980682.26}, {1500., 980682.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980694.89}, {1500., 980694.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980700.13}, {1500., 980700.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980700.87}, {1500., 980700.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980715.36}, {1500., 980715.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980733.7}, {1500., 980733.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980736.22}, {1500., 980736.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0015972098], 
      PointBox[{{1500., 980757.49}, {1500., 980757.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980758.51}, {1500., 980758.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980777.63}, {1500., 980777.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980782.3}, {1500., 980782.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980790.15}, {1500., 980790.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980796.63}, {1500., 980796.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980811.52}, {1500., 980811.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980820.21}, {1500., 980820.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980828.31}, {1500., 980828.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980859.54}, {1500., 980859.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980861.53}, {1500., 980861.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980869.41}, {1500., 980869.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980880.05}, {1500., 980880.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980890.65}, {1500., 980890.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.7347844*^-13], 
      PointBox[{{1500., 980892.1}, {1500., 980892.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980916.73}, {1500., 980916.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980928.06}, {1500., 980928.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980951.81}, {1500., 980951.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980960.13}, {1500., 980960.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980967.28}, {1500., 980967.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980970.39}, {1500., 980970.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980972.31}, {1500., 980972.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981001.75}, {1500., 981001.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981011.99}, {1500., 981011.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981043.3}, {1500., 981043.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981053.27}, {1500., 981053.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981058.26}, {1500., 981058.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981061.09}, {1500., 981061.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981067.62}, {1500., 981067.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981074.05}, {1500., 981074.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981091.41}, {1500., 981091.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981105.77}, {1500., 981105.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981113.82}, {1500., 981113.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981148.29}, {1500., 981148.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981172.04}, {1500., 981172.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981179.51}, {1500., 981179.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981179.7}, {1500., 981179.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981187.33}, {1500., 981187.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981199.69}, {1500., 981199.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981212.91}, {1500., 981212.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981227.27}, {1500., 981227.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981281.2}, {1500., 981281.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981284.55}, {1500., 981284.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981293.68}, {1500., 981293.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981304.66}, {1500., 981304.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981313.54}, {1500., 981313.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981333.11}, {1500., 981333.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981342.59}, {1500., 981342.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981386.34}, {1500., 981386.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981388.71}, {1500., 981388.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981429.47}, {1500., 981429.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981436.92}, {1500., 981436.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981451.96}, {1500., 981451.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981460.52}, {1500., 981460.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981489.51}, {1500., 981489.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981552.3}, {1500., 981552.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981559.44}, {1500., 981559.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981569.76}, {1500., 981569.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981581.19}, {1500., 981581.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981673.54}, {1500., 981673.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981686.8}, {1500., 981686.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981701.71}, {1500., 981701.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981793.65}, {1500., 981793.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981803.22}, {1500., 981803.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981822.78}, {1500., 981822.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981918.84}, {1500., 981918.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980250.16}, {1550., 980250.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.10790259], 
      PointBox[{{1550., 980266.27}, {1550., 980266.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065289011], 
      PointBox[{{1550., 980322.88}, {1550., 980322.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980328.7}, {1550., 980328.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.82175302], 
      PointBox[{{1550., 980386.67}, {1550., 980386.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980390.12}, {1550., 980390.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980399.57}, {1550., 980399.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980439.16}, {1550., 980439.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980450.89}, {1550., 980450.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.3526423*^-14], 
      PointBox[{{1550., 980461.96}, {1550., 980461.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980475.06}, {1550., 980475.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.6910553*^-13], 
      PointBox[{{1550., 980512.91}, {1550., 980512.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.5676275*^-12], 
      PointBox[{{1550., 980525.45}, {1550., 980525.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980537.19}, {1550., 980537.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980551.61}, {1550., 980551.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980553.28}, {1550., 980553.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980584.32}, {1550., 980584.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980611.3}, {1550., 980611.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980615.13}, {1550., 980615.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4547052*^-11], 
      PointBox[{{1550., 980623.61}, {1550., 980623.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.565987*^-13], 
      PointBox[{{1550., 980627.62}, {1550., 980627.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980633.15}, {1550., 980633.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980658.22}, {1550., 980658.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.240337*^-11], 
      PointBox[{{1550., 980683.08}, {1550., 980683.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980695.55}, {1550., 980695.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980699.53}, {1550., 980699.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980700.81}, {1550., 980700.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980713.9}, {1550., 980713.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980734.34}, {1550., 980734.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980735.54}, {1550., 980735.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0016890779], 
      PointBox[{{1550., 980757.76}, {1550., 980757.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980758.75}, {1550., 980758.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980778.38}, {1550., 980778.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980783.06}, {1550., 980783.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980788.77}, {1550., 980788.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980795.07}, {1550., 980795.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980812.19}, {1550., 980812.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980820.66}, {1550., 980820.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980828.56}, {1550., 980828.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980858.75}, {1550., 980858.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980861.87}, {1550., 980861.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980870.21}, {1550., 980870.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980878.62}, {1550., 980878.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980891.33}, {1550., 980891.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.2753185*^-13], 
      PointBox[{{1550., 980892.88}, {1550., 980892.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980916.9}, {1550., 980916.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980927.6}, {1550., 980927.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980952.28}, {1550., 980952.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980960.94}, {1550., 980960.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980966.25}, {1550., 980966.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980968.92}, {1550., 980968.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980972.73}, {1550., 980972.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981002.35}, {1550., 981002.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981012.52}, {1550., 981012.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981043.86}, {1550., 981043.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981054.08}, {1550., 981054.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981057.61}, {1550., 981057.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981059.58}, {1550., 981059.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981068.12}, {1550., 981068.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981072.93}, {1550., 981072.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981091.92}, {1550., 981091.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981106.38}, {1550., 981106.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981114.27}, {1550., 981114.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981149.09}, {1550., 981149.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981172.51}, {1550., 981172.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981178.48}, {1550., 981178.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981180.1}, {1550., 981180.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981186.84}, {1550., 981186.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981200.37}, {1550., 981200.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981213.52}, {1550., 981213.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981227.5}, {1550., 981227.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981281.71}, {1550., 981281.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981283.27}, {1550., 981283.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981294.45}, {1550., 981294.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981305.22}, {1550., 981305.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981313.33}, {1550., 981313.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981333.8}, {1550., 981333.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981342.47}, {1550., 981342.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981386.87}, {1550., 981386.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981387.38}, {1550., 981387.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981430.02}, {1550., 981430.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981437.13}, {1550., 981437.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981452.71}, {1550., 981452.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981459.9}, {1550., 981459.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981490.07}, {1550., 981490.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981552.87}, {1550., 981552.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981559.98}, {1550., 981559.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981570.57}, {1550., 981570.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981580.13}, {1550., 981580.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981674.16}, {1550., 981674.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981687.63}, {1550., 981687.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981700.36}, {1550., 981700.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981794.36}, {1550., 981794.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981804.04}, {1550., 981804.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981821.35}, {1550., 981821.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981919.56}, {1550., 981919.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980250.59}, {1600., 980250.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.11405808], 
      PointBox[{{1600., 980265.22}, {1600., 980265.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065658927], 
      PointBox[{{1600., 980323.02}, {1600., 980323.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980327.78}, {1600., 980327.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.81388933], 
      PointBox[{{1600., 980387.08}, {1600., 980387.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980390.35}, {1600., 980390.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980398.63}, {1600., 980398.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980438.22}, {1600., 980438.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980451.12}, {1600., 980451.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.6524694*^-14], 
      PointBox[{{1600., 980462.29}, {1600., 980462.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980473.99}, {1600., 980473.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5841084*^-13], 
      PointBox[{{1600., 980513.2}, {1600., 980513.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.182528*^-12], 
      PointBox[{{1600., 980524.47}, {1600., 980524.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980537.63}, {1600., 980537.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980552.07}, {1600., 980552.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980552.1}, {1600., 980552.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980584.88}, {1600., 980584.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980610.03}, {1600., 980610.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980615.68}, {1600., 980615.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3859248*^-11], 
      PointBox[{{1600., 980623.8}, {1600., 980623.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2638333*^-12], 
      PointBox[{{1600., 980626.97}, {1600., 980626.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980631.79}, {1600., 980631.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980658.84}, {1600., 980658.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3249896*^-11], 
      PointBox[{{1600., 980683.9}, {1600., 980683.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980696.21}, {1600., 980696.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980698.19}, {1600., 980698.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980701.48}, {1600., 980701.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980712.42}, {1600., 980712.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980734.75}, {1600., 980734.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980735.06}, {1600., 980735.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0017821991], 
      PointBox[{{1600., 980758.05}, {1600., 980758.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980759.03}, {1600., 980759.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980779.12}, {1600., 980779.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980783.82}, {1600., 980783.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980787.37}, {1600., 980787.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980793.51}, {1600., 980793.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980812.87}, {1600., 980812.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980821.09}, {1600., 980821.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980828.79}, {1600., 980828.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980857.99}, {1600., 980857.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980862.24}, {1600., 980862.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980871.01}, {1600., 980871.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980877.18}, {1600., 980877.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980892.02}, {1600., 980892.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.8531924*^-13], 
      PointBox[{{1600., 980893.66}, {1600., 980893.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980917.01}, {1600., 980917.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980927.18}, {1600., 980927.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980952.74}, {1600., 980952.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980961.76}, {1600., 980961.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980965.22}, {1600., 980965.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980967.45}, {1600., 980967.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980973.16}, {1600., 980973.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981002.95}, {1600., 981002.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981013.05}, {1600., 981013.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981044.43}, {1600., 981044.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981054.9}, {1600., 981054.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981056.94}, {1600., 981056.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981058.06}, {1600., 981058.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981068.64}, {1600., 981068.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981071.8}, {1600., 981071.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981092.43}, {1600., 981092.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981106.99}, {1600., 981106.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981114.73}, {1600., 981114.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981149.88}, {1600., 981149.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981173.}, {1600., 981173.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981177.26}, {1600., 981177.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981180.7}, {1600., 981180.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981186.33}, {1600., 981186.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981201.05}, {1600., 981201.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981214.11}, {1600., 981214.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981227.77}, {1600., 981227.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981281.99}, {1600., 981281.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981282.23}, {1600., 981282.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981295.23}, {1600., 981295.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981305.78}, {1600., 981305.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981313.07}, {1600., 981313.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981334.47}, {1600., 981334.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981342.4}, {1600., 981342.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981386.04}, {1600., 981386.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981387.42}, {1600., 981387.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981430.58}, {1600., 981430.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981437.28}, {1600., 981437.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981453.46}, {1600., 981453.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981459.35}, {1600., 981459.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981490.65}, {1600., 981490.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981553.45}, {1600., 981553.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981560.47}, {1600., 981560.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981571.37}, {1600., 981571.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981579.11}, {1600., 981579.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981674.79}, {1600., 981674.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981688.47}, {1600., 981688.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981699.}, {1600., 981699.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981795.08}, {1600., 981795.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981804.86}, {1600., 981804.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981819.93}, {1600., 981819.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981920.28}, {1600., 981920.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980251.}, {1650., 980251.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.12018853], 
      PointBox[{{1650., 980264.13}, {1650., 980264.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.06589962], 
      PointBox[{{1650., 980323.16}, {1650., 980323.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980326.86}, {1650., 980326.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.80541993], 
      PointBox[{{1650., 980387.49}, {1650., 980387.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980390.59}, {1650., 980390.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980397.68}, {1650., 980397.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980437.23}, {1650., 980437.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980451.41}, {1650., 980451.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.9685172*^-14], 
      PointBox[{{1650., 980462.62}, {1650., 980462.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980472.91}, {1650., 980472.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2979729*^-13], 
      PointBox[{{1650., 980513.4}, {1650., 980513.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.8546558*^-12], 
      PointBox[{{1650., 980523.57}, {1650., 980523.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980538.07}, {1650., 980538.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980550.85}, {1650., 980550.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980552.61}, {1650., 980552.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980585.45}, {1650., 980585.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980608.76}, {1650., 980608.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980616.23}, {1650., 980616.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0885815*^-11], 
      PointBox[{{1650., 980623.59}, {1650., 980623.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.5482061*^-12], 
      PointBox[{{1650., 980626.72}, {1650., 980626.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980630.43}, {1650., 980630.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980659.48}, {1650., 980659.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4123455*^-11], 
      PointBox[{{1650., 980684.71}, {1650., 980684.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980696.85}, {1650., 980696.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980696.87}, {1650., 980696.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980702.16}, {1650., 980702.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980710.94}, {1650., 980710.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980734.01}, {1650., 980734.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980735.68}, {1650., 980735.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0018764734], 
      PointBox[{{1650., 980758.35}, {1650., 980758.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980759.36}, {1650., 980759.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980779.87}, {1650., 980779.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980784.58}, {1650., 980784.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980785.98}, {1650., 980785.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980791.94}, {1650., 980791.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980813.55}, {1650., 980813.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980821.51}, {1650., 980821.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980828.98}, {1650., 980828.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980857.26}, {1650., 980857.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980862.61}, {1650., 980862.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980871.8}, {1650., 980871.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980875.74}, {1650., 980875.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980892.72}, {1650., 980892.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.469079*^-13], 
      PointBox[{{1650., 980894.44}, {1650., 980894.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980917.06}, {1650., 980917.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980926.82}, {1650., 980926.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980953.2}, {1650., 980953.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980962.57}, {1650., 980962.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980964.19}, {1650., 980964.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980965.97}, {1650., 980965.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980973.6}, {1650., 980973.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981003.56}, {1650., 981003.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981013.58}, {1650., 981013.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981045.01}, {1650., 981045.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981055.71}, {1650., 981055.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981056.27}, {1650., 981056.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981056.54}, {1650., 981056.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981069.17}, {1650., 981069.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981070.66}, {1650., 981070.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981092.93}, {1650., 981092.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981107.59}, {1650., 981107.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981115.22}, {1650., 981115.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981150.68}, {1650., 981150.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981173.5}, {1650., 981173.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981176.02}, {1650., 981176.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981181.31}, {1650., 981181.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981185.79}, {1650., 981185.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981201.73}, {1650., 981201.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981214.7}, {1650., 981214.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981228.06}, {1650., 981228.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981280.7}, {1650., 981280.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981282.77}, {1650., 981282.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981295.99}, {1650., 981295.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981306.36}, {1650., 981306.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981312.75}, {1650., 981312.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981335.15}, {1650., 981335.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981342.39}, {1650., 981342.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981384.69}, {1650., 981384.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981387.99}, {1650., 981387.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981431.15}, {1650., 981431.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981437.35}, {1650., 981437.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981454.2}, {1650., 981454.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981458.87}, {1650., 981458.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981491.24}, {1650., 981491.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981554.04}, {1650., 981554.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981560.91}, {1650., 981560.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981572.17}, {1650., 981572.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981578.14}, {1650., 981578.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981675.43}, {1650., 981675.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981689.3}, {1650., 981689.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981697.65}, {1650., 981697.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981795.81}, {1650., 981795.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981805.68}, {1650., 981805.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981818.5}, {1650., 981818.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981921.01}, {1650., 981921.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980251.39}, {1700., 980251.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.12627971], 
      PointBox[{{1700., 980263.02}, {1700., 980263.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.066019958], 
      PointBox[{{1700., 980323.3}, {1700., 980323.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980325.92}, {1700., 980325.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.79571321], 
      PointBox[{{1700., 980387.9}, {1700., 980387.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980390.81}, {1700., 980390.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0081261261], 
      PointBox[{{1700., 980396.72}, {1700., 980396.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980436.2}, {1700., 980436.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980451.74}, {1700., 980451.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.3016876*^-14], 
      PointBox[{{1700., 980462.94}, {1700., 980462.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980471.83}, {1700., 980471.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.3864494*^-14], 
      PointBox[{{1700., 980513.51}, {1700., 980513.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.554878*^-12], 
      PointBox[{{1700., 980522.78}, {1700., 980522.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980538.5}, {1700., 980538.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980549.62}, {1700., 980549.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980553.13}, {1700., 980553.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980586.01}, {1700., 980586.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980607.5}, {1700., 980607.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980616.78}, {1700., 980616.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.6381755*^-12], 
      PointBox[{{1700., 980622.95}, {1700., 980622.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0578103*^-11], 
      PointBox[{{1700., 980626.89}, {1700., 980626.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980629.06}, {1700., 980629.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980660.12}, {1700., 980660.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5021715*^-11], 
      PointBox[{{1700., 980685.53}, {1700., 980685.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980695.5}, {1700., 980695.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980697.52}, {1700., 980697.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980702.84}, {1700., 980702.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980709.45}, {1700., 980709.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980733.2}, {1700., 980733.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980736.36}, {1700., 980736.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0019718052], 
      PointBox[{{1700., 980758.67}, {1700., 980758.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980759.71}, {1700., 980759.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980780.61}, {1700., 980780.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980784.57}, {1700., 980784.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980785.34}, {1700., 980785.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980790.36}, {1700., 980790.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980814.25}, {1700., 980814.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980821.91}, {1700., 980821.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980829.12}, {1700., 980829.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980856.57}, {1700., 980856.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980863.01}, {1700., 980863.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980872.6}, {1700., 980872.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980874.3}, {1700., 980874.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980893.43}, {1700., 980893.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.1235556*^-13], 
      PointBox[{{1700., 980895.22}, {1700., 980895.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980917.04}, {1700., 980917.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980926.51}, {1700., 980926.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980953.65}, {1700., 980953.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980963.18}, {1700., 980963.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980963.39}, {1700., 980963.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980964.48}, {1700., 980964.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980974.04}, {1700., 980974.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981004.17}, {1700., 981004.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981014.1}, {1700., 981014.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981045.61}, {1700., 981045.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981055.01}, {1700., 981055.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981055.58}, {1700., 981055.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981056.53}, {1700., 981056.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981069.53}, {1700., 981069.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981069.71}, {1700., 981069.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981093.42}, {1700., 981093.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981108.19}, {1700., 981108.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981115.71}, {1700., 981115.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981151.49}, {1700., 981151.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981174.01}, {1700., 981174.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981174.78}, {1700., 981174.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981181.93}, {1700., 981181.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981185.22}, {1700., 981185.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981202.4}, {1700., 981202.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981215.29}, {1700., 981215.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981228.39}, {1700., 981228.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981279.41}, {1700., 981279.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981283.32}, {1700., 981283.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981296.76}, {1700., 981296.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981306.95}, {1700., 981306.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981312.37}, {1700., 981312.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981335.82}, {1700., 981335.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981342.44}, {1700., 981342.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981383.34}, {1700., 981383.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981388.57}, {1700., 981388.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981431.73}, {1700., 981431.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981437.33}, {1700., 981437.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981454.95}, {1700., 981454.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981458.47}, {1700., 981458.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981491.85}, {1700., 981491.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981554.64}, {1700., 981554.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981561.27}, {1700., 981561.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981572.97}, {1700., 981572.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981577.23}, {1700., 981577.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981676.08}, {1700., 981676.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981690.13}, {1700., 981690.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981696.29}, {1700., 981696.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981796.54}, {1700., 981796.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981806.51}, {1700., 981806.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981817.07}, {1700., 981817.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981921.75}, {1700., 981921.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980251.76}, {1750., 980251.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.13231901], 
      PointBox[{{1750., 980261.88}, {1750., 980261.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.066028168], 
      PointBox[{{1750., 980323.42}, {1750., 980323.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980324.97}, {1750., 980324.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.78343454], 
      PointBox[{{1750., 980388.31}, {1750., 980388.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980391.03}, {1750., 980391.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.014083504], 
      PointBox[{{1750., 980395.78}, {1750., 980395.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980435.13}, {1750., 980435.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980452.1}, {1750., 980452.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.6530072*^-14], 
      PointBox[{{1750., 980463.26}, {1750., 980463.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980470.75}, {1750., 980470.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.4930613*^-14], 
      PointBox[{{1750., 980513.47}, {1750., 980513.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.2196099*^-12], 
      PointBox[{{1750., 980522.12}, {1750., 980522.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980538.94}, {1750., 980538.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980548.38}, {1750., 980548.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980553.66}, {1750., 980553.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980586.58}, {1750., 980586.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980606.23}, {1750., 980606.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980617.33}, {1750., 980617.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.7175944*^-12], 
      PointBox[{{1750., 980622.07}, {1750., 980622.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5294395*^-11], 
      PointBox[{{1750., 980627.31}, {1750., 980627.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980627.68}, {1750., 980627.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980660.77}, {1750., 980660.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5937798*^-11], 
      PointBox[{{1750., 980686.35}, {1750., 980686.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980694.15}, {1750., 980694.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980698.18}, {1750., 980698.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980703.51}, {1750., 980703.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980707.96}, {1750., 980707.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980732.35}, {1750., 980732.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980737.04}, {1750., 980737.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0020681027], 
      PointBox[{{1750., 980759.}, {1750., 980759.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980760.1}, {1750., 980760.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980781.36}, {1750., 980781.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980783.16}, {1750., 980783.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980786.1}, {1750., 980786.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980788.77}, {1750., 980788.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980814.95}, {1750., 980814.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980822.3}, {1750., 980822.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980829.21}, {1750., 980829.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980855.92}, {1750., 980855.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980863.42}, {1750., 980863.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980872.85}, {1750., 980872.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980873.4}, {1750., 980873.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980894.14}, {1750., 980894.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.817099*^-13], 
      PointBox[{{1750., 980896.01}, {1750., 980896.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980916.95}, {1750., 980916.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980926.26}, {1750., 980926.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980954.09}, {1750., 980954.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980962.16}, {1750., 980962.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980963.}, {1750., 980963.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980964.21}, {1750., 980964.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980974.49}, {1750., 980974.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981004.79}, {1750., 981004.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981014.61}, {1750., 981014.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981046.21}, {1750., 981046.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981053.48}, {1750., 981053.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981054.89}, {1750., 981054.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981057.36}, {1750., 981057.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981068.4}, {1750., 981068.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981070.25}, {1750., 981070.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981093.9}, {1750., 981093.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981108.79}, {1750., 981108.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981116.22}, {1750., 981116.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981152.3}, {1750., 981152.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981173.54}, {1750., 981173.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981174.53}, {1750., 981174.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981182.56}, {1750., 981182.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981184.63}, {1750., 981184.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981203.07}, {1750., 981203.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981215.86}, {1750., 981215.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981228.74}, {1750., 981228.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981278.11}, {1750., 981278.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981283.88}, {1750., 981283.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981297.51}, {1750., 981297.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981307.55}, {1750., 981307.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981311.94}, {1750., 981311.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981336.48}, {1750., 981336.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981342.54}, {1750., 981342.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981381.98}, {1750., 981381.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981389.16}, {1750., 981389.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981432.32}, {1750., 981432.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981437.22}, {1750., 981437.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981455.69}, {1750., 981455.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981458.15}, {1750., 981458.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981492.47}, {1750., 981492.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981555.25}, {1750., 981555.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981561.55}, {1750., 981561.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981573.77}, {1750., 981573.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981576.4}, {1750., 981576.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981676.74}, {1750., 981676.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981690.96}, {1750., 981690.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981694.92}, {1750., 981694.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981797.28}, {1750., 981797.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981807.34}, {1750., 981807.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981815.63}, {1750., 981815.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981922.5}, {1750., 981922.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980252.11}, {1800., 980252.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.1382954], 
      PointBox[{{1800., 980260.71}, {1800., 980260.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065931785], 
      PointBox[{{1800., 980323.55}, {1800., 980323.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980324.01}, {1800., 980324.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.76555351], 
      PointBox[{{1800., 980388.7}, {1800., 980388.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980391.24}, {1800., 980391.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.025796095], 
      PointBox[{{1800., 980394.86}, {1800., 980394.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980434.04}, {1800., 980434.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980452.49}, {1800., 980452.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.0236339*^-14], 
      PointBox[{{1800., 980463.57}, {1800., 980463.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980469.67}, {1800., 980469.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.5875968*^-13], 
      PointBox[{{1800., 980513.25}, {1800., 980513.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.7584753*^-12], 
      PointBox[{{1800., 980521.65}, {1800., 980521.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980539.37}, {1800., 980539.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980547.15}, {1800., 980547.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980554.2}, {1800., 980554.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980587.14}, {1800., 980587.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980604.97}, {1800., 980604.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980617.88}, {1800., 980617.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.0752655*^-12], 
      PointBox[{{1800., 980621.06}, {1800., 980621.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980626.31}, {1800., 980626.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8686292*^-11], 
      PointBox[{{1800., 980627.84}, {1800., 980627.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980661.42}, {1800., 980661.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6846371*^-11], 
      PointBox[{{1800., 980687.17}, {1800., 980687.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980692.8}, {1800., 980692.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980698.84}, {1800., 980698.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980704.17}, {1800., 980704.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980706.46}, {1800., 980706.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980731.47}, {1800., 980731.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980737.73}, {1800., 980737.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0021652788], 
      PointBox[{{1800., 980759.35}, {1800., 980759.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980760.52}, {1800., 980760.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980781.75}, {1800., 980781.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980782.1}, {1800., 980782.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980786.86}, {1800., 980786.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980787.18}, {1800., 980787.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980815.66}, {1800., 980815.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980822.66}, {1800., 980822.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980829.24}, {1800., 980829.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980855.32}, {1800., 980855.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980863.84}, {1800., 980863.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980871.39}, {1800., 980871.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980874.2}, {1800., 980874.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980894.87}, {1800., 980894.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.5500798*^-13], 
      PointBox[{{1800., 980896.79}, {1800., 980896.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980916.79}, {1800., 980916.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980926.07}, {1800., 980926.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980954.52}, {1800., 980954.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980961.14}, {1800., 980961.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980961.53}, {1800., 980961.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980965.03}, {1800., 980965.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980974.95}, {1800., 980974.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981005.42}, {1800., 981005.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981015.12}, {1800., 981015.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981046.82}, {1800., 981046.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981051.95}, {1800., 981051.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981054.19}, {1800., 981054.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981058.18}, {1800., 981058.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981067.28}, {1800., 981067.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981070.81}, {1800., 981070.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981094.38}, {1800., 981094.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981109.38}, {1800., 981109.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981116.73}, {1800., 981116.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981153.11}, {1800., 981153.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981172.3}, {1800., 981172.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981175.07}, {1800., 981175.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981183.2}, {1800., 981183.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981184.03}, {1800., 981184.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981203.73}, {1800., 981203.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981216.43}, {1800., 981216.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981229.11}, {1800., 981229.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981276.81}, {1800., 981276.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981284.46}, {1800., 981284.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981298.26}, {1800., 981298.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981308.16}, {1800., 981308.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981311.46}, {1800., 981311.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981337.14}, {1800., 981337.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981342.68}, {1800., 981342.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981380.62}, {1800., 981380.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981389.77}, {1800., 981389.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981432.92}, {1800., 981432.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981437.03}, {1800., 981437.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981456.42}, {1800., 981456.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981457.92}, {1800., 981457.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981493.1}, {1800., 981493.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981555.87}, {1800., 981555.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981561.72}, {1800., 981561.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981574.57}, {1800., 981574.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981575.68}, {1800., 981575.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981677.4}, {1800., 981677.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981691.8}, {1800., 981691.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981693.56}, {1800., 981693.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981798.03}, {1800., 981798.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981808.18}, {1800., 981808.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981814.19}, {1800., 981814.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981923.25}, {1800., 981923.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980252.43}, {1850., 980252.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.14419934], 
      PointBox[{{1850., 980259.51}, {1850., 980259.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980323.04}, {1850., 980323.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065737622], 
      PointBox[{{1850., 980323.66}, {1850., 980323.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.73471369], 
      PointBox[{{1850., 980389.05}, {1850., 980389.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980391.45}, {1850., 980391.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.050621307], 
      PointBox[{{1850., 980393.99}, {1850., 980393.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980432.92}, {1850., 980432.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980452.89}, {1850., 980452.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.4148657*^-14], 
      PointBox[{{1850., 980463.88}, {1850., 980463.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980468.59}, {1850., 980468.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8911393*^-13], 
      PointBox[{{1850., 980512.83}, {1850., 980512.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.1010668*^-12], 
      PointBox[{{1850., 980521.38}, {1850., 980521.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980539.8}, {1850., 980539.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980545.91}, {1850., 980545.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980554.74}, {1850., 980554.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980587.69}, {1850., 980587.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980603.73}, {1850., 980603.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980618.43}, {1850., 980618.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0028338*^-12], 
      PointBox[{{1850., 980619.99}, {1850., 980619.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980624.92}, {1850., 980624.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.1321228*^-11], 
      PointBox[{{1850., 980628.42}, {1850., 980628.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980662.08}, {1850., 980662.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.7609491*^-11], 
      PointBox[{{1850., 980687.96}, {1850., 980687.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980691.47}, {1850., 980691.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980699.49}, {1850., 980699.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980704.82}, {1850., 980704.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980704.95}, {1850., 980704.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980730.57}, {1850., 980730.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980738.42}, {1850., 980738.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0022632503], 
      PointBox[{{1850., 980759.71}, {1850., 980759.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980760.96}, {1850., 980760.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980780.33}, {1850., 980780.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980782.84}, {1850., 980782.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980785.58}, {1850., 980785.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980787.62}, {1850., 980787.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980816.38}, {1850., 980816.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980823.01}, {1850., 980823.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980829.22}, {1850., 980829.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980854.78}, {1850., 980854.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980864.28}, {1850., 980864.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980869.93}, {1850., 980869.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980875.}, {1850., 980875.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980895.6}, {1850., 980895.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.3227559*^-13], 
      PointBox[{{1850., 980897.57}, {1850., 980897.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980916.56}, {1850., 980916.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980925.93}, {1850., 980925.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980954.95}, {1850., 980954.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980959.92}, {1850., 980959.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980960.29}, {1850., 980960.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980965.84}, {1850., 980965.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980975.41}, {1850., 980975.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981006.05}, {1850., 981006.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981015.61}, {1850., 981015.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981047.43}, {1850., 981047.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981050.41}, {1850., 981050.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981053.49}, {1850., 981053.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981059.01}, {1850., 981059.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981066.16}, {1850., 981066.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981071.37}, {1850., 981071.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981094.85}, {1850., 981094.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981109.96}, {1850., 981109.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981117.26}, {1850., 981117.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981153.93}, {1850., 981153.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981171.05}, {1850., 981171.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981175.62}, {1850., 981175.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981183.4}, {1850., 981183.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981183.85}, {1850., 981183.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981204.39}, {1850., 981204.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981216.99}, {1850., 981216.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981229.51}, {1850., 981229.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981275.51}, {1850., 981275.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981285.05}, {1850., 981285.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981299.}, {1850., 981299.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981308.77}, {1850., 981308.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981310.94}, {1850., 981310.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981337.79}, {1850., 981337.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981342.88}, {1850., 981342.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981379.26}, {1850., 981379.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981390.38}, {1850., 981390.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981433.53}, {1850., 981433.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981436.75}, {1850., 981436.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981457.15}, {1850., 981457.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981457.78}, {1850., 981457.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981493.74}, {1850., 981493.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981556.5}, {1850., 981556.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981561.77}, {1850., 981561.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981575.08}, {1850., 981575.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981575.36}, {1850., 981575.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981678.08}, {1850., 981678.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981692.19}, {1850., 981692.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981692.63}, {1850., 981692.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981798.78}, {1850., 981798.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981809.02}, {1850., 981809.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981812.76}, {1850., 981812.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981924.02}, {1850., 981924.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980252.74}, {1900., 980252.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.15002267], 
      PointBox[{{1900., 980258.29}, {1900., 980258.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980322.07}, {1900., 980322.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065451633], 
      PointBox[{{1900., 980323.76}, {1900., 980323.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.67313201], 
      PointBox[{{1900., 980389.3}, {1900., 980389.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980391.64}, {1900., 980391.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.10634415], 
      PointBox[{{1900., 980393.22}, {1900., 980393.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980431.79}, {1900., 980431.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980453.31}, {1900., 980453.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.8281475*^-14], 
      PointBox[{{1900., 980464.17}, {1900., 980464.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980467.53}, {1900., 980467.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4191365*^-13], 
      PointBox[{{1900., 980512.22}, {1900., 980512.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.247818*^-12], 
      PointBox[{{1900., 980521.29}, {1900., 980521.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980540.22}, {1900., 980540.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980544.68}, {1900., 980544.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980555.3}, {1900., 980555.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980588.22}, {1900., 980588.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980602.5}, {1900., 980602.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.6167285*^-12], 
      PointBox[{{1900., 980618.89}, {1900., 980618.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980618.97}, {1900., 980618.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980623.54}, {1900., 980623.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3540878*^-11], 
      PointBox[{{1900., 980629.04}, {1900., 980629.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980662.74}, {1900., 980662.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6561681*^-11], 
      PointBox[{{1900., 980688.65}, {1900., 980688.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.4363999*^-14], 
      PointBox[{{1900., 980690.24}, {1900., 980690.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980700.14}, {1900., 980700.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980703.45}, {1900., 980703.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980705.47}, {1900., 980705.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980729.65}, {1900., 980729.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980739.13}, {1900., 980739.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0023619381], 
      PointBox[{{1900., 980760.09}, {1900., 980760.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980761.42}, {1900., 980761.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980778.91}, {1900., 980778.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980783.57}, {1900., 980783.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980783.98}, {1900., 980783.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980788.37}, {1900., 980788.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980817.11}, {1900., 980817.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980823.34}, {1900., 980823.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980829.13}, {1900., 980829.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980854.3}, {1900., 980854.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980864.73}, {1900., 980864.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980868.47}, {1900., 980868.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980875.8}, {1900., 980875.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980896.33}, {1900., 980896.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0135265*^-12], 
      PointBox[{{1900., 980898.36}, {1900., 980898.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980916.27}, {1900., 980916.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980925.82}, {1900., 980925.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980955.36}, {1900., 980955.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980958.45}, {1900., 980958.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980959.3}, {1900., 980959.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980966.66}, {1900., 980966.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980975.87}, {1900., 980975.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981006.69}, {1900., 981006.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981016.1}, {1900., 981016.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981048.06}, {1900., 981048.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981048.87}, {1900., 981048.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981052.78}, {1900., 981052.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981059.84}, {1900., 981059.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981065.06}, {1900., 981065.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981071.94}, {1900., 981071.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981095.31}, {1900., 981095.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981110.54}, {1900., 981110.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981117.8}, {1900., 981117.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981154.75}, {1900., 981154.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981169.81}, {1900., 981169.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981176.18}, {1900., 981176.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981182.77}, {1900., 981182.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981184.51}, {1900., 981184.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981205.03}, {1900., 981205.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981217.54}, {1900., 981217.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981229.92}, {1900., 981229.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981274.2}, {1900., 981274.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981285.66}, {1900., 981285.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981299.73}, {1900., 981299.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981309.39}, {1900., 981309.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981310.38}, {1900., 981310.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981338.43}, {1900., 981338.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981343.12}, {1900., 981343.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981377.9}, {1900., 981377.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981391.01}, {1900., 981391.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981434.15}, {1900., 981434.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981436.38}, {1900., 981436.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981457.72}, {1900., 981457.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981457.88}, {1900., 981457.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981494.4}, {1900., 981494.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981557.14}, {1900., 981557.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981561.68}, {1900., 981561.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981574.62}, {1900., 981574.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981576.15}, {1900., 981576.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981678.76}, {1900., 981678.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981690.83}, {1900., 981690.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981693.46}, {1900., 981693.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981799.54}, {1900., 981799.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981809.86}, {1900., 981809.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981811.32}, {1900., 981811.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981924.79}, {1900., 981924.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980253.02}, {1950., 980253.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.15575853], 
      PointBox[{{1950., 980257.05}, {1950., 980257.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980321.1}, {1950., 980321.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.065079543], 
      PointBox[{{1950., 980323.85}, {1950., 980323.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.55027624], 
      PointBox[{{1950., 980389.37}, {1950., 980389.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980391.82}, {1950., 980391.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.22349776], 
      PointBox[{{1950., 980392.64}, {1950., 980392.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980430.65}, {1950., 980430.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980453.72}, {1950., 980453.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.2650791*^-14], 
      PointBox[{{1950., 980464.46}, {1950., 980464.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980466.48}, {1950., 980466.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.7233865*^-14], 
      PointBox[{{1950., 980511.44}, {1950., 980511.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.2608599*^-12], 
      PointBox[{{1950., 980521.37}, {1950., 980521.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980540.63}, {1950., 980540.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980543.45}, {1950., 980543.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980555.86}, {1950., 980555.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980588.72}, {1950., 980588.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980601.3}, {1950., 980601.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.3450267*^-12], 
      PointBox[{{1950., 980617.76}, {1950., 980617.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980619.51}, {1950., 980619.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980622.16}, {1950., 980622.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5523727*^-11], 
      PointBox[{{1950., 980629.68}, {1950., 980629.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980663.4}, {1950., 980663.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.1918636*^-14], 
      PointBox[{{1950., 980688.4}, {1950., 980688.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6416457*^-11], 
      PointBox[{{1950., 980689.96}, {1950., 980689.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980700.79}, {1950., 980700.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980701.94}, {1950., 980701.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980706.09}, {1950., 980706.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980728.72}, {1950., 980728.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980739.83}, {1950., 980739.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0024612676], 
      PointBox[{{1950., 980760.48}, {1950., 980760.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980761.9}, {1950., 980761.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980777.49}, {1950., 980777.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980782.37}, {1950., 980782.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980784.31}, {1950., 980784.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980789.12}, {1950., 980789.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980817.84}, {1950., 980817.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980823.65}, {1950., 980823.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980828.97}, {1950., 980828.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980853.89}, {1950., 980853.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980865.2}, {1950., 980865.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980867.}, {1950., 980867.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980876.59}, {1950., 980876.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980897.07}, {1950., 980897.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0987618*^-12], 
      PointBox[{{1950., 980899.15}, {1950., 980899.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980915.94}, {1950., 980915.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980925.75}, {1950., 980925.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980955.77}, {1950., 980955.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980956.95}, {1950., 980956.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980958.37}, {1950., 980958.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980967.48}, {1950., 980967.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980976.34}, {1950., 980976.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981007.33}, {1950., 981007.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981016.56}, {1950., 981016.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981047.33}, {1950., 981047.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981048.69}, {1950., 981048.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981052.07}, {1950., 981052.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981060.66}, {1950., 981060.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981063.97}, {1950., 981063.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981072.52}, {1950., 981072.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981095.76}, {1950., 981095.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981111.11}, {1950., 981111.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981118.36}, {1950., 981118.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981155.57}, {1950., 981155.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981168.57}, {1950., 981168.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981176.75}, {1950., 981176.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981182.12}, {1950., 981182.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981185.18}, {1950., 981185.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981205.67}, {1950., 981205.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981218.08}, {1950., 981218.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981230.36}, {1950., 981230.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981272.9}, {1950., 981272.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981286.27}, {1950., 981286.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981300.45}, {1950., 981300.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981309.78}, {1950., 981309.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981310.02}, {1950., 981310.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981339.06}, {1950., 981339.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981343.39}, {1950., 981343.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981376.53}, {1950., 981376.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981391.65}, {1950., 981391.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981434.78}, {1950., 981434.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981435.92}, {1950., 981435.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981457.75}, {1950., 981457.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981458.6}, {1950., 981458.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981495.06}, {1950., 981495.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981557.79}, {1950., 981557.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981561.43}, {1950., 981561.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981574.32}, {1950., 981574.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981576.94}, {1950., 981576.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981679.46}, {1950., 981679.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981689.47}, {1950., 981689.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981694.3}, {1950., 981694.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981800.3}, {1950., 981800.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981809.88}, {1950., 981809.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981810.71}, {1950., 981810.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981925.56}, {1950., 981925.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980253.27}, {2000., 980253.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.16140123], 
      PointBox[{{2000., 980255.78}, {2000., 980255.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980320.12}, {2000., 980320.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.064625941], 
      PointBox[{{2000., 980323.93}, {2000., 980323.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.37433418], 
      PointBox[{{2000., 980389.12}, {2000., 980389.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980391.98}, {2000., 980391.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.3938938], 
      PointBox[{{2000., 980392.38}, {2000., 980392.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980429.49}, {2000., 980429.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980454.14}, {2000., 980454.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.7274217*^-14], 
      PointBox[{{2000., 980464.74}, {2000., 980464.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980465.46}, {2000., 980465.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.1629817*^-15], 
      PointBox[{{2000., 980510.54}, {2000., 980510.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.2118549*^-12], 
      PointBox[{{2000., 980521.57}, {2000., 980521.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980541.04}, {2000., 980541.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980542.23}, {2000., 980542.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980556.43}, {2000., 980556.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980589.18}, {2000., 980589.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980600.14}, {2000., 980600.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.151782*^-12], 
      PointBox[{{2000., 980616.62}, {2000., 980616.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980620.04}, {2000., 980620.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980620.79}, {2000., 980620.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7365908*^-11], 
      PointBox[{{2000., 980630.33}, {2000., 980630.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980664.07}, {2000., 980664.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980687.17}, {2000., 980687.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.0231463*^-11], 
      PointBox[{{2000., 980690.66}, {2000., 980690.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980700.43}, {2000., 980700.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980701.43}, {2000., 980701.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980706.69}, {2000., 980706.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980727.79}, {2000., 980727.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980740.55}, {2000., 980740.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.002561168], 
      PointBox[{{2000., 980760.88}, {2000., 980760.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980762.39}, {2000., 980762.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980776.07}, {2000., 980776.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980780.77}, {2000., 980780.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980785.04}, {2000., 980785.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980789.87}, {2000., 980789.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980818.57}, {2000., 980818.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980823.94}, {2000., 980823.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980828.74}, {2000., 980828.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980853.55}, {2000., 980853.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980865.54}, {2000., 980865.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980865.67}, {2000., 980865.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980877.39}, {2000., 980877.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980897.82}, {2000., 980897.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1879686*^-12], 
      PointBox[{{2000., 980899.93}, {2000., 980899.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980915.56}, {2000., 980915.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980925.7}, {2000., 980925.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980955.45}, {2000., 980955.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980956.16}, {2000., 980956.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980957.48}, {2000., 980957.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980968.3}, {2000., 980968.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980976.82}, {2000., 980976.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981007.98}, {2000., 981007.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981017.02}, {2000., 981017.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981045.78}, {2000., 981045.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981049.33}, {2000., 981049.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981051.36}, {2000., 981051.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981061.49}, {2000., 981061.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981062.9}, {2000., 981062.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981073.11}, {2000., 981073.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981096.2}, {2000., 981096.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981111.66}, {2000., 981111.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981118.91}, {2000., 981118.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981156.4}, {2000., 981156.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981167.34}, {2000., 981167.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981177.33}, {2000., 981177.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981181.46}, {2000., 981181.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981185.85}, {2000., 981185.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981206.3}, {2000., 981206.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981218.6}, {2000., 981218.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981230.82}, {2000., 981230.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981271.6}, {2000., 981271.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981286.9}, {2000., 981286.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981301.16}, {2000., 981301.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981309.16}, {2000., 981309.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981310.66}, {2000., 981310.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981339.69}, {2000., 981339.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981343.71}, {2000., 981343.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981375.17}, {2000., 981375.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981392.31}, {2000., 981392.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981435.4}, {2000., 981435.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981435.41}, {2000., 981435.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981457.85}, {2000., 981457.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981459.32}, {2000., 981459.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981495.74}, {2000., 981495.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981558.44}, {2000., 981558.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981561.02}, {2000., 981561.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981574.17}, {2000., 981574.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981577.73}, {2000., 981577.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981680.15}, {2000., 981680.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981688.1}, {2000., 981688.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981695.13}, {2000., 981695.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981801.07}, {2000., 981801.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981808.44}, {2000., 981808.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981811.56}, {2000., 981811.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981926.34}, {2000., 981926.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980253.5}, {2050., 980253.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.16694614], 
      PointBox[{{2050., 980254.5}, {2050., 980254.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980319.14}, {2050., 980319.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.064094989], 
      PointBox[{{2050., 980323.99}, {2050., 980323.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.23046985], 
      PointBox[{{2050., 980388.56}, {2050., 980388.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980392.13}, {2050., 980392.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.53236853], 
      PointBox[{{2050., 980392.46}, {2050., 980392.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980428.33}, {2050., 980428.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980454.53}, {2050., 980454.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980464.47}, {2050., 980464.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.2171025*^-14], 
      PointBox[{{2050., 980465.}, {2050., 980465.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6996416*^-16], 
      PointBox[{{2050., 980509.55}, {2050., 980509.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.1486737*^-12], 
      PointBox[{{2050., 980521.86}, {2050., 980521.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980541.02}, {2050., 980541.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980541.44}, {2050., 980541.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980557.}, {2050., 980557.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980589.57}, {2050., 980589.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980599.05}, {2050., 980599.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0038031*^-12], 
      PointBox[{{2050., 980615.45}, {2050., 980615.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980619.41}, {2050., 980619.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980620.57}, {2050., 980620.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.9122192*^-11], 
      PointBox[{{2050., 980630.99}, {2050., 980630.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980664.73}, {2050., 980664.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980685.84}, {2050., 980685.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.175465*^-11], 
      PointBox[{{2050., 980691.46}, {2050., 980691.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980698.93}, {2050., 980698.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980702.07}, {2050., 980702.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980707.27}, {2050., 980707.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980726.86}, {2050., 980726.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980741.27}, {2050., 980741.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0026615723], 
      PointBox[{{2050., 980761.3}, {2050., 980761.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980762.9}, {2050., 980762.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980774.64}, {2050., 980774.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980779.16}, {2050., 980779.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980785.77}, {2050., 980785.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980790.6}, {2050., 980790.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980819.32}, {2050., 980819.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980824.2}, {2050., 980824.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980828.43}, {2050., 980828.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980853.28}, {2050., 980853.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980864.07}, {2050., 980864.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980866.16}, {2050., 980866.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980878.18}, {2050., 980878.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980898.57}, {2050., 980898.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.2811198*^-12], 
      PointBox[{{2050., 980900.72}, {2050., 980900.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980915.15}, {2050., 980915.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980925.65}, {2050., 980925.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980953.94}, {2050., 980953.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980956.54}, {2050., 980956.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980956.63}, {2050., 980956.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980969.12}, {2050., 980969.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980977.3}, {2050., 980977.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981008.63}, {2050., 981008.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981017.45}, {2050., 981017.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981044.24}, {2050., 981044.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981049.98}, {2050., 981049.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981050.66}, {2050., 981050.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981061.84}, {2050., 981061.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981062.32}, {2050., 981062.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981073.7}, {2050., 981073.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981096.62}, {2050., 981096.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981112.2}, {2050., 981112.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981119.48}, {2050., 981119.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981157.22}, {2050., 981157.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981166.12}, {2050., 981166.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981177.91}, {2050., 981177.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981180.8}, {2050., 981180.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981186.53}, {2050., 981186.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981206.92}, {2050., 981206.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981219.12}, {2050., 981219.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981231.29}, {2050., 981231.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981270.31}, {2050., 981270.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981287.53}, {2050., 981287.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981301.86}, {2050., 981301.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981308.5}, {2050., 981308.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981311.3}, {2050., 981311.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981340.31}, {2050., 981340.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981344.06}, {2050., 981344.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981373.82}, {2050., 981373.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981392.97}, {2050., 981392.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981434.8}, {2050., 981434.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981436.05}, {2050., 981436.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981458.02}, {2050., 981458.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981460.03}, {2050., 981460.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981496.42}, {2050., 981496.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981559.1}, {2050., 981559.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981560.48}, {2050., 981560.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981574.16}, {2050., 981574.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981578.51}, {2050., 981578.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981680.86}, {2050., 981680.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981686.75}, {2050., 981686.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981695.96}, {2050., 981695.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981801.85}, {2050., 981801.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981807.01}, {2050., 981807.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981812.41}, {2050., 981812.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981927.13}, {2050., 981927.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.1723896], 
      PointBox[{{2100., 980253.19}, {2100., 980253.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980253.7}, {2100., 980253.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980318.17}, {2100., 980318.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.06349032], 
      PointBox[{{2100., 980324.03}, {2100., 980324.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.14883654], 
      PointBox[{{2100., 980387.8}, {2100., 980387.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980392.26}, {2100., 980392.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.60876522], 
      PointBox[{{2100., 980392.74}, {2100., 980392.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980427.17}, {2100., 980427.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980454.88}, {2100., 980454.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980463.54}, {2100., 980463.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.7362183*^-14], 
      PointBox[{{2100., 980465.25}, {2100., 980465.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.1340328*^-15], 
      PointBox[{{2100., 980508.49}, {2100., 980508.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.0926512*^-12], 
      PointBox[{{2100., 980522.21}, {2100., 980522.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980539.83}, {2100., 980539.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980541.82}, {2100., 980541.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980557.58}, {2100., 980557.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980589.86}, {2100., 980589.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980598.07}, {2100., 980598.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.8840382*^-12], 
      PointBox[{{2100., 980614.28}, {2100., 980614.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980618.05}, {2100., 980618.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980621.09}, {2100., 980621.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0825496*^-11], 
      PointBox[{{2100., 980631.66}, {2100., 980631.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980665.39}, {2100., 980665.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980684.49}, {2100., 980684.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3023524*^-11], 
      PointBox[{{2100., 980692.28}, {2100., 980692.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980697.43}, {2100., 980697.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980702.7}, {2100., 980702.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980707.81}, {2100., 980707.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980725.95}, {2100., 980725.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980741.99}, {2100., 980741.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0027624177], 
      PointBox[{{2100., 980761.72}, {2100., 980761.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980763.41}, {2100., 980763.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980773.23}, {2100., 980773.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980777.55}, {2100., 980777.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980786.5}, {2100., 980786.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980791.34}, {2100., 980791.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980820.06}, {2100., 980820.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980824.45}, {2100., 980824.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980828.05}, {2100., 980828.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980853.08}, {2100., 980853.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980862.6}, {2100., 980862.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980866.66}, {2100., 980866.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980878.97}, {2100., 980878.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980899.33}, {2100., 980899.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3781721*^-12], 
      PointBox[{{2100., 980901.5}, {2100., 980901.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980914.71}, {2100., 980914.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980925.6}, {2100., 980925.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980952.43}, {2100., 980952.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980955.83}, {2100., 980955.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980956.91}, {2100., 980956.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980969.94}, {2100., 980969.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980977.78}, {2100., 980977.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981009.29}, {2100., 981009.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981017.86}, {2100., 981017.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981042.69}, {2100., 981042.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981049.95}, {2100., 981049.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981050.63}, {2100., 981050.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981060.82}, {2100., 981060.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981063.16}, {2100., 981063.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981074.3}, {2100., 981074.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981097.04}, {2100., 981097.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981112.73}, {2100., 981112.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981120.06}, {2100., 981120.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981158.05}, {2100., 981158.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981164.9}, {2100., 981164.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981178.51}, {2100., 981178.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981180.14}, {2100., 981180.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981187.22}, {2100., 981187.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981207.52}, {2100., 981207.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981219.63}, {2100., 981219.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981231.78}, {2100., 981231.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981269.02}, {2100., 981269.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981288.18}, {2100., 981288.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981302.54}, {2100., 981302.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981307.83}, {2100., 981307.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981311.95}, {2100., 981311.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981340.92}, {2100., 981340.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981344.44}, {2100., 981344.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981372.47}, {2100., 981372.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981393.64}, {2100., 981393.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981434.15}, {2100., 981434.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981436.69}, {2100., 981436.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981458.26}, {2100., 981458.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981460.73}, {2100., 981460.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981497.12}, {2100., 981497.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981559.76}, {2100., 981559.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981559.81}, {2100., 981559.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981574.28}, {2100., 981574.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981579.29}, {2100., 981579.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981681.57}, {2100., 981681.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981685.39}, {2100., 981685.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981696.79}, {2100., 981696.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981802.63}, {2100., 981802.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981805.57}, {2100., 981805.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981813.27}, {2100., 981813.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981927.92}, {2100., 981927.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.17772882], 
      PointBox[{{2150., 980251.86}, {2150., 980251.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980253.87}, {2150., 980253.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980317.2}, {2150., 980317.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.062815114], 
      PointBox[{{2150., 980324.05}, {2150., 980324.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.10555372], 
      PointBox[{{2150., 980386.95}, {2150., 980386.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980392.37}, {2150., 980392.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.64696429], 
      PointBox[{{2150., 980393.12}, {2150., 980393.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980426.}, {2150., 980426.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980455.17}, {2150., 980455.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980462.7}, {2150., 980462.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.287034*^-14], 
      PointBox[{{2150., 980465.49}, {2150., 980465.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.4166939*^-12], 
      PointBox[{{2150., 980507.38}, {2150., 980507.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.0468356*^-12], 
      PointBox[{{2150., 980522.6}, {2150., 980522.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980538.65}, {2150., 980538.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980542.2}, {2150., 980542.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980558.17}, {2150., 980558.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980589.98}, {2150., 980589.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980597.25}, {2150., 980597.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7818934*^-12], 
      PointBox[{{2150., 980613.09}, {2150., 980613.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980616.7}, {2150., 980616.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980621.6}, {2150., 980621.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.2496488*^-11], 
      PointBox[{{2150., 980632.34}, {2150., 980632.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980666.05}, {2150., 980666.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980683.14}, {2150., 980683.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.4243439*^-11], 
      PointBox[{{2150., 980693.11}, {2150., 980693.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980695.93}, {2150., 980695.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980703.33}, {2150., 980703.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980708.3}, {2150., 980708.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980725.07}, {2150., 980725.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980742.71}, {2150., 980742.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0028636448], 
      PointBox[{{2150., 980762.16}, {2150., 980762.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980763.92}, {2150., 980763.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980771.81}, {2150., 980771.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980775.94}, {2150., 980775.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980787.22}, {2150., 980787.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980792.06}, {2150., 980792.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980820.81}, {2150., 980820.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980824.67}, {2150., 980824.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980827.59}, {2150., 980827.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980852.95}, {2150., 980852.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980861.14}, {2150., 980861.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980867.17}, {2150., 980867.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980879.76}, {2150., 980879.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980900.09}, {2150., 980900.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4790653*^-12], 
      PointBox[{{2150., 980902.29}, {2150., 980902.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980914.26}, {2150., 980914.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980925.52}, {2150., 980925.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980950.91}, {2150., 980950.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980955.07}, {2150., 980955.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980957.26}, {2150., 980957.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980970.75}, {2150., 980970.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980978.26}, {2150., 980978.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981009.94}, {2150., 981009.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981018.25}, {2150., 981018.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981041.15}, {2150., 981041.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981049.25}, {2150., 981049.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981051.28}, {2150., 981051.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981059.82}, {2150., 981059.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981063.99}, {2150., 981063.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981074.9}, {2150., 981074.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981097.44}, {2150., 981097.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981113.24}, {2150., 981113.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981120.64}, {2150., 981120.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981158.89}, {2150., 981158.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981163.7}, {2150., 981163.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981179.11}, {2150., 981179.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981179.48}, {2150., 981179.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981187.91}, {2150., 981187.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981208.11}, {2150., 981208.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981220.12}, {2150., 981220.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981232.28}, {2150., 981232.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981267.74}, {2150., 981267.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981288.83}, {2150., 981288.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981303.22}, {2150., 981303.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981307.13}, {2150., 981307.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981312.6}, {2150., 981312.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981341.52}, {2150., 981341.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981344.84}, {2150., 981344.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981371.12}, {2150., 981371.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981394.32}, {2150., 981394.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981433.45}, {2150., 981433.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981437.34}, {2150., 981437.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981458.55}, {2150., 981458.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981461.43}, {2150., 981461.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981497.82}, {2150., 981497.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981559.03}, {2150., 981559.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981560.43}, {2150., 981560.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981574.51}, {2150., 981574.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981580.07}, {2150., 981580.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981682.28}, {2150., 981682.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981684.04}, {2150., 981684.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981697.63}, {2150., 981697.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981803.41}, {2150., 981803.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981804.14}, {2150., 981804.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981814.12}, {2150., 981814.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981928.72}, {2150., 981928.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.18296174], 
      PointBox[{{2200., 980250.52}, {2200., 980250.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980254.}, {2200., 980254.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980316.23}, {2200., 980316.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.062072178], 
      PointBox[{{2200., 980324.05}, {2200., 980324.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.081340149], 
      PointBox[{{2200., 980386.05}, {2200., 980386.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980392.46}, {2200., 980392.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.66624476], 
      PointBox[{{2200., 980393.56}, {2200., 980393.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980424.83}, {2200., 980424.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980455.36}, {2200., 980455.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980461.97}, {2200., 980461.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.8719773*^-14], 
      PointBox[{{2200., 980465.7}, {2200., 980465.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.9679111*^-12], 
      PointBox[{{2200., 980506.24}, {2200., 980506.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      8.0026931*^-12], 
      PointBox[{{2200., 980523.}, {2200., 980523.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980537.51}, {2200., 980537.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980542.56}, {2200., 980542.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980558.76}, {2200., 980558.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980589.86}, {2200., 980589.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980596.66}, {2200., 980596.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.6904296*^-12], 
      PointBox[{{2200., 980611.89}, {2200., 980611.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980615.36}, {2200., 980615.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980622.1}, {2200., 980622.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.4148581*^-11], 
      PointBox[{{2200., 980633.02}, {2200., 980633.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980666.7}, {2200., 980666.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980681.8}, {2200., 980681.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5251176*^-11], 
      PointBox[{{2200., 980693.95}, {2200., 980693.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980694.44}, {2200., 980694.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980703.95}, {2200., 980703.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980708.73}, {2200., 980708.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980724.23}, {2200., 980724.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980743.44}, {2200., 980743.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0029651978], 
      PointBox[{{2200., 980762.61}, {2200., 980762.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980764.43}, {2200., 980764.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980770.42}, {2200., 980770.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980774.33}, {2200., 980774.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980787.94}, {2200., 980787.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980792.78}, {2200., 980792.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980821.57}, {2200., 980821.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980824.87}, {2200., 980824.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980827.07}, {2200., 980827.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980852.89}, {2200., 980852.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980859.68}, {2200., 980859.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980867.69}, {2200., 980867.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980880.54}, {2200., 980880.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980900.86}, {2200., 980900.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.583721*^-12], 
      PointBox[{{2200., 980903.07}, {2200., 980903.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980913.81}, {2200., 980913.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980925.42}, {2200., 980925.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980949.4}, {2200., 980949.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980954.37}, {2200., 980954.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980957.59}, {2200., 980957.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980971.57}, {2200., 980971.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980978.75}, {2200., 980978.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981010.61}, {2200., 981010.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981018.61}, {2200., 981018.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981039.6}, {2200., 981039.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981048.55}, {2200., 981048.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981051.94}, {2200., 981051.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981058.86}, {2200., 981058.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981064.82}, {2200., 981064.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981075.51}, {2200., 981075.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981097.82}, {2200., 981097.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981113.73}, {2200., 981113.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981121.23}, {2200., 981121.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981159.72}, {2200., 981159.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981162.51}, {2200., 981162.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981178.82}, {2200., 981178.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981179.72}, {2200., 981179.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981188.61}, {2200., 981188.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981208.69}, {2200., 981208.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981220.6}, {2200., 981220.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981232.8}, {2200., 981232.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981266.47}, {2200., 981266.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981289.49}, {2200., 981289.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981303.88}, {2200., 981303.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981306.42}, {2200., 981306.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981313.26}, {2200., 981313.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981342.12}, {2200., 981342.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981345.27}, {2200., 981345.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981369.79}, {2200., 981369.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981395.}, {2200., 981395.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981432.71}, {2200., 981432.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981437.99}, {2200., 981437.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981458.88}, {2200., 981458.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981462.13}, {2200., 981462.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981498.53}, {2200., 981498.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981558.18}, {2200., 981558.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981561.11}, {2200., 981561.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981574.82}, {2200., 981574.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981580.85}, {2200., 981580.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981682.7}, {2200., 981682.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981683.}, {2200., 981683.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981698.46}, {2200., 981698.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981802.72}, {2200., 981802.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981804.2}, {2200., 981804.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981814.98}, {2200., 981814.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981929.52}, {2200., 981929.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.188087], 
      PointBox[{{2250., 980249.16}, {2250., 980249.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980254.11}, {2250., 980254.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980315.28}, {2250., 980315.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.061264037], 
      PointBox[{{2250., 980324.03}, {2250., 980324.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.066815663], 
      PointBox[{{2250., 980385.14}, {2250., 980385.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980392.53}, {2250., 980392.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.67598413], 
      PointBox[{{2250., 980394.03}, {2250., 980394.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980423.65}, {2250., 980423.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980455.38}, {2250., 980455.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980461.43}, {2250., 980461.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      9.4936257*^-14], 
      PointBox[{{2250., 980465.9}, {2250., 980465.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.4977056*^-12], 
      PointBox[{{2250., 980505.07}, {2250., 980505.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.9426028*^-12], 
      PointBox[{{2250., 980523.41}, {2250., 980523.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.8061671*^-14], 
      PointBox[{{2250., 980536.41}, {2250., 980536.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980542.91}, {2250., 980542.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980559.35}, {2250., 980559.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980589.47}, {2250., 980589.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980596.35}, {2250., 980596.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.6049132*^-12], 
      PointBox[{{2250., 980610.68}, {2250., 980610.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980614.04}, {2250., 980614.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980622.59}, {2250., 980622.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.5790654*^-11], 
      PointBox[{{2250., 980633.71}, {2250., 980633.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980667.33}, {2250., 980667.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980680.46}, {2250., 980680.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980692.96}, {2250., 980692.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.6682752*^-11], 
      PointBox[{{2250., 980694.79}, {2250., 980694.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980704.57}, {2250., 980704.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980709.08}, {2250., 980709.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980723.45}, {2250., 980723.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980744.16}, {2250., 980744.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0030670245], 
      PointBox[{{2250., 980763.07}, {2250., 980763.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980764.9}, {2250., 980764.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980769.07}, {2250., 980769.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980772.73}, {2250., 980772.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980788.66}, {2250., 980788.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980793.48}, {2250., 980793.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980822.33}, {2250., 980822.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980825.05}, {2250., 980825.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980826.49}, {2250., 980826.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980852.88}, {2250., 980852.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980858.24}, {2250., 980858.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980868.22}, {2250., 980868.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980881.32}, {2250., 980881.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980901.63}, {2250., 980901.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.6920404*^-12], 
      PointBox[{{2250., 980903.86}, {2250., 980903.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980913.35}, {2250., 980913.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980925.27}, {2250., 980925.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980947.89}, {2250., 980947.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980953.73}, {2250., 980953.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980957.91}, {2250., 980957.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980972.38}, {2250., 980972.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980979.25}, {2250., 980979.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981011.27}, {2250., 981011.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981018.93}, {2250., 981018.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981038.05}, {2250., 981038.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981047.85}, {2250., 981047.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981052.61}, {2250., 981052.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981057.94}, {2250., 981057.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981065.65}, {2250., 981065.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981076.12}, {2250., 981076.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981098.2}, {2250., 981098.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981114.2}, {2250., 981114.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981121.83}, {2250., 981121.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981160.55}, {2250., 981160.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981161.35}, {2250., 981161.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981178.16}, {2250., 981178.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981180.34}, {2250., 981180.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981189.31}, {2250., 981189.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981209.25}, {2250., 981209.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981221.06}, {2250., 981221.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981233.33}, {2250., 981233.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981265.21}, {2250., 981265.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981290.16}, {2250., 981290.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981304.52}, {2250., 981304.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981305.71}, {2250., 981305.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981313.92}, {2250., 981313.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981342.7}, {2250., 981342.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981345.73}, {2250., 981345.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981368.46}, {2250., 981368.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981395.7}, {2250., 981395.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981431.94}, {2250., 981431.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981438.65}, {2250., 981438.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981459.26}, {2250., 981459.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981462.82}, {2250., 981462.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981499.24}, {2250., 981499.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981557.26}, {2250., 981557.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981561.79}, {2250., 981561.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981575.19}, {2250., 981575.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981581.62}, {2250., 981581.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981681.36}, {2250., 981681.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981683.73}, {2250., 981683.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981699.29}, {2250., 981699.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981801.29}, {2250., 981801.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981805.}, {2250., 981805.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981815.84}, {2250., 981815.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981930.33}, {2250., 981930.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.19310383], 
      PointBox[{{2300., 980247.78}, {2300., 980247.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980254.18}, {2300., 980254.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980314.33}, {2300., 980314.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.060393029], 
      PointBox[{{2300., 980323.98}, {2300., 980323.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.057586788], 
      PointBox[{{2300., 980384.23}, {2300., 980384.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980392.58}, {2300., 980392.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.68057356], 
      PointBox[{{2300., 980394.53}, {2300., 980394.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980422.48}, {2300., 980422.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980455.21}, {2300., 980455.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980461.11}, {2300., 980461.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0154684*^-13], 
      PointBox[{{2300., 980466.07}, {2300., 980466.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.0078037*^-12], 
      PointBox[{{2300., 980503.88}, {2300., 980503.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.8387072*^-12], 
      PointBox[{{2300., 980523.8}, {2300., 980523.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.9182405*^-14], 
      PointBox[{{2300., 980535.36}, {2300., 980535.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980543.24}, {2300., 980543.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980559.95}, {2300., 980559.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980588.8}, {2300., 980588.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980596.29}, {2300., 980596.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.5220101*^-12], 
      PointBox[{{2300., 980609.46}, {2300., 980609.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980612.75}, {2300., 980612.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980623.06}, {2300., 980623.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.7428592*^-11], 
      PointBox[{{2300., 980634.4}, {2300., 980634.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980667.93}, {2300., 980667.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980679.15}, {2300., 980679.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980691.49}, {2300., 980691.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.7959325*^-11], 
      PointBox[{{2300., 980695.64}, {2300., 980695.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980705.18}, {2300., 980705.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980709.32}, {2300., 980709.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980722.77}, {2300., 980722.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980744.89}, {2300., 980744.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0031690756], 
      PointBox[{{2300., 980763.54}, {2300., 980763.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980765.23}, {2300., 980765.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980767.86}, {2300., 980767.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980771.13}, {2300., 980771.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980789.38}, {2300., 980789.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980794.17}, {2300., 980794.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980823.09}, {2300., 980823.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980825.21}, {2300., 980825.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980825.85}, {2300., 980825.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980852.91}, {2300., 980852.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980856.83}, {2300., 980856.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980868.77}, {2300., 980868.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980882.1}, {2300., 980882.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980902.4}, {2300., 980902.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.8039034*^-12], 
      PointBox[{{2300., 980904.64}, {2300., 980904.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980912.89}, {2300., 980912.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980925.08}, {2300., 980925.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980946.37}, {2300., 980946.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980953.16}, {2300., 980953.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980958.22}, {2300., 980958.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980973.18}, {2300., 980973.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980979.74}, {2300., 980979.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981011.94}, {2300., 981011.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981019.22}, {2300., 981019.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981036.51}, {2300., 981036.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981047.17}, {2300., 981047.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981053.27}, {2300., 981053.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981057.06}, {2300., 981057.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981066.48}, {2300., 981066.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981076.73}, {2300., 981076.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981098.56}, {2300., 981098.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981114.64}, {2300., 981114.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981122.43}, {2300., 981122.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981160.2}, {2300., 981160.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981161.39}, {2300., 981161.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981177.52}, {2300., 981177.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981180.96}, {2300., 981180.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981190.02}, {2300., 981190.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981209.78}, {2300., 981209.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981221.52}, {2300., 981221.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981233.86}, {2300., 981233.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981263.97}, {2300., 981263.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981290.84}, {2300., 981290.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981304.98}, {2300., 981304.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981305.14}, {2300., 981305.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981314.58}, {2300., 981314.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981343.27}, {2300., 981343.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981346.2}, {2300., 981346.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981367.15}, {2300., 981367.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981396.4}, {2300., 981396.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981431.14}, {2300., 981431.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981439.31}, {2300., 981439.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981459.68}, {2300., 981459.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981463.5}, {2300., 981463.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981499.97}, {2300., 981499.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981556.3}, {2300., 981556.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981562.47}, {2300., 981562.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981575.62}, {2300., 981575.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981582.38}, {2300., 981582.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981680.02}, {2300., 981680.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981684.45}, {2300., 981684.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981700.11}, {2300., 981700.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981799.87}, {2300., 981799.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981805.79}, {2300., 981805.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981816.7}, {2300., 981816.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981931.14}, {2300., 981931.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.19801196], 
      PointBox[{{2350., 980246.38}, {2350., 980246.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980254.22}, {2350., 980254.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980313.39}, {2350., 980313.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.059461399], 
      PointBox[{{2350., 980323.9}, {2350., 980323.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.051473541], 
      PointBox[{{2350., 980383.32}, {2350., 980383.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980392.6}, {2350., 980392.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.68218782], 
      PointBox[{{2350., 980395.03}, {2350., 980395.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980421.31}, {2350., 980421.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980454.82}, {2350., 980454.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980461.02}, {2350., 980461.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0857951*^-13], 
      PointBox[{{2350., 980466.22}, {2350., 980466.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.7771627*^-14], 
      PointBox[{{2350., 980502.68}, {2350., 980502.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.6492406*^-12], 
      PointBox[{{2350., 980524.15}, {2350., 980524.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.0129671*^-13], 
      PointBox[{{2350., 980534.37}, {2350., 980534.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980543.55}, {2350., 980543.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980560.55}, {2350., 980560.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980587.93}, {2350., 980587.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980596.43}, {2350., 980596.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.4393159*^-12], 
      PointBox[{{2350., 980608.24}, {2350., 980608.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980611.48}, {2350., 980611.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980623.53}, {2350., 980623.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.9066182*^-11], 
      PointBox[{{2350., 980635.1}, {2350., 980635.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980668.5}, {2350., 980668.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980677.88}, {2350., 980677.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980690.03}, {2350., 980690.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.924515*^-11], 
      PointBox[{{2350., 980696.48}, {2350., 980696.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980705.77}, {2350., 980705.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980709.44}, {2350., 980709.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980722.19}, {2350., 980722.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980745.62}, {2350., 980745.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0032713051], 
      PointBox[{{2350., 980764.02}, {2350., 980764.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980765.04}, {2350., 980765.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980767.18}, {2350., 980767.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980769.54}, {2350., 980769.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980790.09}, {2350., 980790.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980794.84}, {2350., 980794.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980823.85}, {2350., 980823.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980825.16}, {2350., 980825.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980825.34}, {2350., 980825.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980852.92}, {2350., 980852.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980855.5}, {2350., 980855.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980869.31}, {2350., 980869.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980882.87}, {2350., 980882.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980903.18}, {2350., 980903.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.9191658*^-12], 
      PointBox[{{2350., 980905.42}, {2350., 980905.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980912.44}, {2350., 980912.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980924.84}, {2350., 980924.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980944.86}, {2350., 980944.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980952.66}, {2350., 980952.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980958.5}, {2350., 980958.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980973.99}, {2350., 980973.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980980.24}, {2350., 980980.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981012.61}, {2350., 981012.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981019.47}, {2350., 981019.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981034.96}, {2350., 981034.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981046.49}, {2350., 981046.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981053.94}, {2350., 981053.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981056.22}, {2350., 981056.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981067.31}, {2350., 981067.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981077.35}, {2350., 981077.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981098.9}, {2350., 981098.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981115.06}, {2350., 981115.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981123.04}, {2350., 981123.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981159.08}, {2350., 981159.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981162.22}, {2350., 981162.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981176.88}, {2350., 981176.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981181.58}, {2350., 981181.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981190.73}, {2350., 981190.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981210.3}, {2350., 981210.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981221.95}, {2350., 981221.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981234.41}, {2350., 981234.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981262.75}, {2350., 981262.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981291.53}, {2350., 981291.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981304.26}, {2350., 981304.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981305.75}, {2350., 981305.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981315.25}, {2350., 981315.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981343.83}, {2350., 981343.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981346.69}, {2350., 981346.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981365.85}, {2350., 981365.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981397.11}, {2350., 981397.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981430.31}, {2350., 981430.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981439.97}, {2350., 981439.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981460.12}, {2350., 981460.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981464.17}, {2350., 981464.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981500.7}, {2350., 981500.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981555.3}, {2350., 981555.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981563.16}, {2350., 981563.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981576.09}, {2350., 981576.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981583.15}, {2350., 981583.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981678.7}, {2350., 981678.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981685.19}, {2350., 981685.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981700.94}, {2350., 981700.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981798.46}, {2350., 981798.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981806.59}, {2350., 981806.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981817.57}, {2350., 981817.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981931.96}, {2350., 981931.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.20281157], 
      PointBox[{{2400., 980244.97}, {2400., 980244.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980254.22}, {2400., 980254.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980312.46}, {2400., 980312.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.058471395], 
      PointBox[{{2400., 980323.79}, {2400., 980323.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.047318183], 
      PointBox[{{2400., 980382.42}, {2400., 980382.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980392.59}, {2400., 980392.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.68198107], 
      PointBox[{{2400., 980395.55}, {2400., 980395.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980420.14}, {2400., 980420.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980454.25}, {2400., 980454.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980461.14}, {2400., 980461.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.1606268*^-13], 
      PointBox[{{2400., 980466.35}, {2400., 980466.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.9690891*^-14], 
      PointBox[{{2400., 980501.48}, {2400., 980501.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      7.315225*^-12], 
      PointBox[{{2400., 980524.44}, {2400., 980524.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.5027425*^-13], 
      PointBox[{{2400., 980533.49}, {2400., 980533.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980543.84}, {2400., 980543.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980561.15}, {2400., 980561.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980586.92}, {2400., 980586.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980596.69}, {2400., 980596.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.3550709*^-12], 
      PointBox[{{2400., 980607.01}, {2400., 980607.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980610.25}, {2400., 980610.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980623.98}, {2400., 980623.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.0705633*^-11], 
      PointBox[{{2400., 980635.79}, {2400., 980635.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980669.}, {2400., 980669.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980676.67}, {2400., 980676.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980688.6}, {2400., 980688.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.0554631*^-11], 
      PointBox[{{2400., 980697.33}, {2400., 980697.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980706.36}, {2400., 980706.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980709.41}, {2400., 980709.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980721.75}, {2400., 980721.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980746.34}, {2400., 980746.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980764.07}, {2400., 980764.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0033736697], 
      PointBox[{{2400., 980764.51}, {2400., 980764.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980767.24}, {2400., 980767.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980768.}, {2400., 980768.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980790.79}, {2400., 980790.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980795.49}, {2400., 980795.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980824.4}, {2400., 980824.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980824.65}, {2400., 980824.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980825.44}, {2400., 980825.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980852.66}, {2400., 980852.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980854.49}, {2400., 980854.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980869.87}, {2400., 980869.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980883.63}, {2400., 980883.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980903.96}, {2400., 980903.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.0376578*^-12], 
      PointBox[{{2400., 980906.2}, {2400., 980906.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980912.}, {2400., 980912.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980924.53}, {2400., 980924.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980943.34}, {2400., 980943.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980952.23}, {2400., 980952.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980958.76}, {2400., 980958.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980974.79}, {2400., 980974.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980980.75}, {2400., 980980.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981013.28}, {2400., 981013.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981019.68}, {2400., 981019.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981033.42}, {2400., 981033.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981045.82}, {2400., 981045.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981054.62}, {2400., 981054.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981055.44}, {2400., 981055.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981068.14}, {2400., 981068.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981077.97}, {2400., 981077.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981099.23}, {2400., 981099.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981115.45}, {2400., 981115.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981123.65}, {2400., 981123.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981157.99}, {2400., 981157.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981163.06}, {2400., 981163.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981176.25}, {2400., 981176.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981182.22}, {2400., 981182.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981191.45}, {2400., 981191.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981210.79}, {2400., 981210.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981222.37}, {2400., 981222.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981234.97}, {2400., 981234.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981261.55}, {2400., 981261.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981292.22}, {2400., 981292.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981303.53}, {2400., 981303.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981306.33}, {2400., 981306.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981315.91}, {2400., 981315.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981344.38}, {2400., 981344.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981347.19}, {2400., 981347.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981364.56}, {2400., 981364.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981397.83}, {2400., 981397.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981429.48}, {2400., 981429.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981440.64}, {2400., 981440.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981460.6}, {2400., 981460.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981464.83}, {2400., 981464.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981501.43}, {2400., 981501.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981554.28}, {2400., 981554.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981563.85}, {2400., 981563.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981576.59}, {2400., 981576.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981583.9}, {2400., 981583.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981677.38}, {2400., 981677.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981685.92}, {2400., 981685.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981701.77}, {2400., 981701.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981797.05}, {2400., 981797.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981807.4}, {2400., 981807.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981818.43}, {2400., 981818.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981932.78}, {2400., 981932.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.20750323], 
      PointBox[{{2450., 980243.55}, {2450., 980243.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980254.18}, {2450., 980254.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980311.55}, {2450., 980311.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.05742537], 
      PointBox[{{2450., 980323.66}, {2450., 980323.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.044462567], 
      PointBox[{{2450., 980381.53}, {2450., 980381.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980392.55}, {2450., 980392.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.68060679], 
      PointBox[{{2450., 980396.08}, {2450., 980396.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980418.97}, {2450., 980418.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980453.55}, {2450., 980453.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980461.42}, {2450., 980461.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.240245*^-13], 
      PointBox[{{2450., 980466.45}, {2450., 980466.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.8382547*^-14], 
      PointBox[{{2450., 980500.26}, {2450., 980500.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.7669348*^-12], 
      PointBox[{{2450., 980524.63}, {2450., 980524.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2334596*^-13], 
      PointBox[{{2450., 980532.73}, {2450., 980532.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980544.11}, {2450., 980544.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980561.75}, {2450., 980561.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980585.82}, {2450., 980585.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980597.01}, {2450., 980597.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2679818*^-12], 
      PointBox[{{2450., 980605.77}, {2450., 980605.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980609.08}, {2450., 980609.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980624.41}, {2450., 980624.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.2347844*^-11], 
      PointBox[{{2450., 980636.49}, {2450., 980636.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980669.38}, {2450., 980669.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980675.56}, {2450., 980675.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980687.19}, {2450., 980687.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.189006*^-11], 
      PointBox[{{2450., 980698.18}, {2450., 980698.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980706.94}, {2450., 980706.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980709.21}, {2450., 980709.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980721.47}, {2450., 980721.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980747.06}, {2450., 980747.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980762.78}, {2450., 980762.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0034761289], 
      PointBox[{{2450., 980765.02}, {2450., 980765.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980766.34}, {2450., 980766.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980767.76}, {2450., 980767.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980791.5}, {2450., 980791.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980796.12}, {2450., 980796.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980823.66}, {2450., 980823.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980825.4}, {2450., 980825.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980825.52}, {2450., 980825.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980851.76}, {2450., 980851.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980854.18}, {2450., 980854.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980870.44}, {2450., 980870.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980884.38}, {2450., 980884.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980904.74}, {2450., 980904.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.1591809*^-12], 
      PointBox[{{2450., 980906.98}, {2450., 980906.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980911.57}, {2450., 980911.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980924.17}, {2450., 980924.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980941.83}, {2450., 980941.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980951.89}, {2450., 980951.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980959.}, {2450., 980959.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980975.58}, {2450., 980975.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980981.26}, {2450., 980981.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981013.96}, {2450., 981013.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981019.83}, {2450., 981019.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981031.88}, {2450., 981031.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981045.17}, {2450., 981045.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981054.72}, {2450., 981054.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981055.29}, {2450., 981055.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981068.97}, {2450., 981068.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981078.59}, {2450., 981078.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981099.54}, {2450., 981099.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981115.8}, {2450., 981115.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981124.27}, {2450., 981124.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981156.93}, {2450., 981156.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981163.9}, {2450., 981163.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981175.64}, {2450., 981175.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981182.85}, {2450., 981182.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981192.18}, {2450., 981192.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981211.25}, {2450., 981211.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981222.77}, {2450., 981222.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981235.53}, {2450., 981235.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981260.37}, {2450., 981260.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981292.92}, {2450., 981292.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981302.81}, {2450., 981302.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981306.89}, {2450., 981306.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981316.58}, {2450., 981316.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981344.91}, {2450., 981344.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981347.71}, {2450., 981347.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981363.3}, {2450., 981363.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981398.55}, {2450., 981398.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981428.63}, {2450., 981428.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981441.31}, {2450., 981441.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981461.09}, {2450., 981461.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981465.49}, {2450., 981465.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981502.17}, {2450., 981502.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981553.24}, {2450., 981553.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981564.54}, {2450., 981564.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981577.11}, {2450., 981577.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981584.66}, {2450., 981584.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981676.08}, {2450., 981676.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981686.66}, {2450., 981686.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981702.59}, {2450., 981702.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981795.65}, {2450., 981795.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981808.21}, {2450., 981808.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981819.3}, {2450., 981819.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981933.6}, {2450., 981933.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.21208783], 
      PointBox[{{2500., 980242.11}, {2500., 980242.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980254.1}, {2500., 980254.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980310.65}, {2500., 980310.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.056325867], 
      PointBox[{{2500., 980323.48}, {2500., 980323.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.042510823], 
      PointBox[{{2500., 980380.66}, {2500., 980380.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980392.48}, {2500., 980392.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.67845539], 
      PointBox[{{2500., 980396.6}, {2500., 980396.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980417.81}, {2500., 980417.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980452.78}, {2500., 980452.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980461.79}, {2500., 980461.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.3249193*^-13], 
      PointBox[{{2500., 980466.52}, {2500., 980466.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      5.4202869*^-14], 
      PointBox[{{2500., 980499.04}, {2500., 980499.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      6.8388003*^-13], 
      PointBox[{{2500., 980524.67}, {2500., 980524.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.2552657*^-13], 
      PointBox[{{2500., 980532.16}, {2500., 980532.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980544.35}, {2500., 980544.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980562.34}, {2500., 980562.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980584.67}, {2500., 980584.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980597.34}, {2500., 980597.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.1771086*^-12], 
      PointBox[{{2500., 980604.53}, {2500., 980604.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980607.98}, {2500., 980607.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980624.82}, {2500., 980624.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      4.3992502*^-11], 
      PointBox[{{2500., 980637.2}, {2500., 980637.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980669.54}, {2500., 980669.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980674.66}, {2500., 980674.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980685.82}, {2500., 980685.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      3.325236*^-11], 
      PointBox[{{2500., 980699.03}, {2500., 980699.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980707.5}, {2500., 980707.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980708.84}, {2500., 980708.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980721.35}, {2500., 980721.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980747.77}, {2500., 980747.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980761.41}, {2500., 980761.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980764.8}, {2500., 980764.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.0035786442], 
      PointBox[{{2500., 980765.53}, {2500., 980765.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980768.26}, {2500., 980768.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980792.19}, {2500., 980792.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980796.72}, {2500., 980796.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980822.88}, {2500., 980822.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980825.58}, {2500., 980825.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980826.17}, {2500., 980826.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980850.46}, {2500., 980850.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980854.31}, {2500., 980854.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980871.01}, {2500., 980871.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980885.13}, {2500., 980885.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980905.53}, {2500., 980905.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      2.2835057*^-12], 
      PointBox[{{2500., 980907.76}, {2500., 980907.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980911.16}, {2500., 980911.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980923.74}, {2500., 980923.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980940.32}, {2500., 980940.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980951.61}, {2500., 980951.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980959.22}, {2500., 980959.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980976.37}, {2500., 980976.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980981.77}, {2500., 980981.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981014.63}, {2500., 981014.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981019.93}, {2500., 981019.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981030.34}, {2500., 981030.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981044.54}, {2500., 981044.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981054.06}, {2500., 981054.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981055.97}, {2500., 981055.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981069.8}, {2500., 981069.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981079.21}, {2500., 981079.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981099.84}, {2500., 981099.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981116.11}, {2500., 981116.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981124.89}, {2500., 981124.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981155.92}, {2500., 981155.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981164.74}, {2500., 981164.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981175.04}, {2500., 981175.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981183.49}, {2500., 981183.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981192.9}, {2500., 981192.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981211.68}, {2500., 981211.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981223.16}, {2500., 981223.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981236.1}, {2500., 981236.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981259.22}, {2500., 981259.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981293.63}, {2500., 981293.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981302.09}, {2500., 981302.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981307.42}, {2500., 981307.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981317.25}, {2500., 981317.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981345.43}, {2500., 981345.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981348.24}, {2500., 981348.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981362.06}, {2500., 981362.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981399.28}, {2500., 981399.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981427.78}, {2500., 981427.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981441.97}, {2500., 981441.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981461.6}, {2500., 981461.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981466.14}, {2500., 981466.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981502.92}, {2500., 981502.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981552.19}, {2500., 981552.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981565.23}, {2500., 981565.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981577.65}, {2500., 981577.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981585.41}, {2500., 981585.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981674.78}, {2500., 981674.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981687.4}, {2500., 981687.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981703.42}, {2500., 981703.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981794.25}, {2500., 981794.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981809.02}, {2500., 981809.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981820.17}, {2500., 981820.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981934.43}, {2500., 981934.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.21656653], 
      PointBox[{{2550., 980240.66}, {2550., 980240.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980253.98}, {2550., 980253.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980309.76}, {2550., 980309.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.055175708], 
      PointBox[{{2550., 980323.28}, {2550., 980323.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.04121272], 
      PointBox[{{2550., 980379.81}, {2550., 980379.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980392.38}, {2550., 980392.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.67577096], 
      PointBox[{{2550., 980397.14}, {2550., 980397.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980416.65}, {2550., 980416.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980451.97}, {2550., 980451.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980462.23}, {2550., 980462.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      1.4148949*^-13], 
      PointBox[{{2550., 980466.56}, 